{$O+,F+}
unit Blad;

interface

function hex(n:word):string;
function TPErrorName(Code:integer):string;
function DOSErrorName(Code:integer):string;

implementation

type
  pr=record ofs,seg:word end;

function hex(n:word):string;
  function hexb(n:word):string;
  const d:string[16]='0123456789ABCDEF';
  begin
    hexb:=d[n shr 4 +1]+d[n and $F +1]
  end;
begin
  hex:=hexb(n shr 8)+hexb(n and $FF)
end;

procedure TPErrors;   external;  {$L TPErrors.obj}
procedure DOSErrors;  external;  {$L DOSError.obj}

function ErrorName(Code:integer; Errors : Pointer):string;
var p:^char;     s:string[60];   tp : Boolean;
begin
  p:=Errors;    if p=@TPerrors then tp:=True else tp:=False;
  ErrorName:='';
  while (byte(p^)<>Code) and (byte(p^)<>0) do begin
    while p^<>#0 do inc(pr(p).ofs);
    inc(pr(p).ofs);
  end;
  if byte(p^)=0 then begin
    if tp then ErrorName:='Nieznany blad'
          else ErrorName:='Unknown error';
          exit
  end;
  inc(pr(p).ofs);
  s:='';
  while p^<>#0 do begin
    s:=s+p^;
    inc(pr(p).ofs)
  end;
  ErrorName:=s
end;

function TPErrorName(Code:integer):string;
begin TPErrorName:=ErrorName(Code, @TPErrors) end;

function DOSErrorName(Code:integer):string;
begin DOSErrorName:=ErrorName(Code, @DOSErrors) end;

{$F+}
procedure MyExitProc;
begin
  if ExitCode<>0 then begin
    writeln(TPErrorName(ExitCode));
    writeln('(Blad wykonania nr ',ExitCode,' pod adresem ',
          hex(pr(ErrorAddr).Seg),':',hex(pr(ErrorAddr).Ofs),')')
  end;
  halt
end;
{$F-}

begin
  ExitProc:=@MyExitProc;
end.