/* ------------------------- com.h ------------------------------------------ */
/*									      */

#define	Xout	0x02		/* output XON/XOFF active (comlib.c) */
#define	Xin	0x04		/* input  XON/XOFF active (circbuff.c) */

/*
 * Low level access
*/

extern void far	intinit (void);
extern int far	cominit (int port);
extern void far	commoff (int port);
extern void far	setcomm (int port, long a, int b, int c, int d, int xmode);
extern void far	save_vec (void);
extern void far	rstr_vec (void);
extern void far	brk_on (void);
extern void far	brk_off (void);

extern void far	flushccb (int port);	/* for emergency only */

/*
 * High level access
*/

extern int far	com_start (int port, long a, int b, int c, int d,
			int xmode);
extern void far	com_stop (int port);

extern int far	port_set (int port, int isize, int osize, int irq, int base);
extern int far	port_start (int port, long a, int b, int c, int d,
			int xmode);
extern void far	port_stop (int port);

extern int far	comin (int port);
extern int far	comout (int port, int c);
extern int far	comoutb (int port, unsigned char *b, int len);

extern void far get_ccbinfo (int port, int info[]);

#define comoutnb comout		/* all output now non-blocking */
