/*
WRIMAGE is a word game written by John W. Ratcliff
*/


#define BLACK 0
#define BLUE 1
#define GREEN 2
#define CYAN 3
#define RED 4
#define MAGENTA 5
#define BROWN 6
#define GRAY 7
#define DARK_GRAY 8
#define LIGHT_BLUE 9
#define LIGHT_GREEN 10
#define LIGHT_CYAN 11
#define LIGHT_RED 12
#define LIGHT_MAGENTA 13
#define YELLOW 14
#define WHITE 15

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <string.h>
/*
Protypes here
*
*/
extern     char    sec,hsec;
int   keystat();
int   getch(void);
void  sound(int tone,int duration);
void  tprint(
             int x,
             int y,
             int wid,
             int bc,
             int fc,
             char *str
             );
void  flushk(void);
void  setmode(int vidmode);
void  getime(void);
void  getword(void);
void  big_print(char *str);
void  home(int bc,int fc);
int   keystat(void);
void  cursoff(void);
void  plet(void);
void  movlet(void);
void  slide(void);
void  ptime(void);
int   timit(int tn);
int   tinput(char *buf,int x1,int y1,int l,int bc,int fc);
void  discore(void);
int   grand(int rd);
int   getup(void);
void  getlet(void);
void  nexturn(void);
int   poplet(int c);
void  getword(void);
void  dospell(void);
void  clrmid(void);
int   win(void);
int   winner(int wscore);
void  sounder(int tone,int duration);
void  sound2(int tone,int duration);
void  buroing(void);
void  boroing(void);
/* All the variables are global because, as mentioned above, this was my
   first C program and I didn't know better.
*/
char blank[2] = {  32, 0 };
char blbd[2]  = { 200, 0 };
char brbd[2]  = { 188, 0 };
char tlbd[2]  = { 201, 0 };
char trbd[2]  = { 187, 0 };
char tbd[2]   = { 205, 0 };
char lbd[2]   = { 186, 0 };
char amount[26] = {
                   1, 3, 3, 2, 1, 4, 2, 4, 1, 6, 5, 1, 3, 1, 1, 3, 6,
                   1, 1, 1, 1, 5, 4, 7, 4, 7
                  };

char    *nums[7] = {
                    "1",
                    "2",
                    "3",
                    "4",
                    "5",
                    "6",
                    "7"
                    };
char     *title = { "WRIMAGE" };
int      bc,fc,x,y,i,j,k;
char    **words,*offset;
char    le1,le2,le3,let[3]; /* three letters choosen */
char    names[6][9];
int     scores[6];
char    tstr[2],ibuf[40];
char    vals[10] = { "0123456789" };
int     correct,adscore,length,turn;
int     sound_set;
char    *word;
int     sts,sth;
char    used[15];
int     nn,rd,m,ln,nwords,bas;
int     ts,th,col,t,kk,np,ky,op,echo;
main(argc,argv)
int argc;
char **argv;
{

FILE *fph;
int  s,n,a,excon,ns,line,l,err,wtype;

if (argc > 2)
   {
    printf("Invalid call to Wrimage\n");
    printf("Usage: WRIMGE <filename>\n");
    printf("Filename is your own text file of words to be used\n");
    printf("Without a filename passed the default word list is used\n");
    exit(1);
   }

if (argc == 2)
    wtype = 0;
   else
    wtype=1;

tstr[1]=0;
setmode(3);  /* Get in 80x25 color graphics mode */
words=malloc(4500*2);
if (words == NULL)
 {
  printf("Couldn't allocate local memory for word list\n");
  exit(1);
 }
word=malloc(32500);
if (word == NULL)
 {
  printf("Couldn't allocate local memory for word list\n");
  exit(1);
 }

getime();
i=hsec*256+sec;
srand(i);
if (wtype)
   fph=fopen("wrimage.lst", "rb");
  else
   fph=fopen(argv[1], "rb");

if (fph == NULL)
   {
    if (wtype)
       printf("Couldn't find standard word list file WRIMAGE.LST\n");
      else
       printf("Couldn't find user word list '%s'\n",argv[1]);
    exit(1);
   }
s=1;
n=32500;
home(BLACK,LIGHT_GREEN);
printf("Reading in word list file\n");
i=fread(word, s, n, fph);
fclose(fph);
printf("Setting up word list\n\n");
/* This routine translates the word list read in from dis */
/* j is the current character in the word list being examined */
/* i is the number of characters in the word list read in */
/* nwords is the number of words compiled by this routine */
/* n is the current character in the new list being created */
/* words is the pointer array pointing to words entered into the list */
err=0;
if (i>0) i--;
j      = 0;
nwords = 0;
line   = 0;
n      = 0;

do
   {
    words[nwords] = &word[n];
    excon = 0;
    ns = n;
    do {
        a=word[j];
        if (a >= 'a' && a <= 'z') a-=32;
        if ( (a < 'A' || a > 'Z') && a != 13)
            excon=1;
           else
           {
            word[n]=a;
            n++;
           }
        j++;
       } while (a !=13 && j<i);
    if (excon)
      word[n]=0;
       else
      word[n-1]=0;
    if (a == 13)
       {
        if (word[j] == 10) j++;
        line++;
       }
    if (excon)
       {
        printf("LINE->%4D: Word at line %d contains invalid characters.\n",line,line);
       }
    else
    {
     l=n-ns-1;
     if (l < 4)
       {
        printf("LINE->%4D: Word '%s' at line %d is too short.\n",line,words[nwords],line);
        excon=1;
       }
      if (l > 15)
       {
        printf("LINE->%4D: Word '%s' at line %d is too long.\n",line,words[nwords],line);
        excon=1;
        }
    }
    if (excon) { n=ns; err++; }
     else
       nwords++;
  } while (j < i && nwords < 4500);
if (nwords == 4500)
   {
    printf("You had more thant 4500 words in your word list\n");
    printf("the extra ones will be ignored\n");
   }
if (nwords < 20)
   {
    printf("Sorry but you must have at least 20 words in your word list to play\n");
    exit(1);
   }
if (err)
   {
    printf("\n%d errors were encountered reading in the word list.\n",err);
    printf("Do you wish to continue (y/n)?");
    do
     {
      a=getup();
     } while (a != 'Y' && a != 'N');
    if (a == 'N')
       {
        goto leave;
       }
    }

home(BLACK,BLACK);
cursoff();

 tprint(5,1,0,BLACK,LIGHT_CYAN,"    Copyright 1987, COMPUTE! Publications, Inc.");
 tprint(5,0,0,BLACK,LIGHT_CYAN,"Welcome to Wrimage: A word game written by John W. Ratcliff.");
 y=5;
 bc=BLUE;
 fc=GRAY;
 big_print(title);
 y=7;
 bc=MAGENTA;
 for (x=4,i=0; i<7; i++,x=x+5)
  {
   tstr[0]=title[i];
   plet();
  }
  tprint(18,23,0,BLACK,YELLOW,"Press a key to begin");
 getch();
newgame:
/* Ask for sound in this do loop */
 home(BLACK,BLACK);
 for (i=0; i<6; i++) scores[i]=0;
 turn=0;
 tprint(10,8,0,BLACK,LIGHT_CYAN,"Do you want sound in your game? (y/n)");
do {
    x=getup();
    switch (x)
     {
      case 'Y': sound_set = 1;
                sound(1000,2);
                break;
      case 'N': sound_set = 0;
                break;
     }
    }
    while (x != 'Y' && x != 'N' && x != 27);
if (x == 27) goto leave;

moder:
if (wtype)
 {
do {
  home(BLACK,BLACK);
  tprint(10,8,0,BLACK,LIGHT_CYAN,"Play at what level?");
  tprint(10,10,0,BLACK,LIGHT_CYAN,"  1.  Easy words.");
  tprint(10,11,0,BLACK,LIGHT_CYAN,"  2.  Medium words.");
  tprint(10,12,0,BLACK,LIGHT_CYAN,"  3.  Hard words.");
  tprint(10,13,0,BLACK,LIGHT_CYAN,"  4.  Mixed levels.");
  x=getch();
  switch(x)
     {
      case '1':  bas    = 1501;
                 nwords = 2000;
                 break;
      case '2':  bas    = 2000;
                 break;
      case '3':  bas    = 0;
                 nwords = 1500;
                 break;
      case '4':  bas    = 0;
                 break;
     }
  } while ( (x < '1' || x > '4') && x !=27);
if (x == 27) goto newgame;
 } else
  bas=0;

backup:
  home(BLACK,BLACK);
  tprint(2,23,0,BLACK,LIGHT_MAGENTA,"    Copyright 1987, COMPUTE! Publications, Inc.");
  tprint(5,0,0,BLACK,LIGHT_CYAN,"Welcome to Wrimage: A word game written by John W. Ratcliff.");
  tprint(0,2,0,BLACK,CYAN,"Make entry then press ENTER.  Press ESC to back-up an entry.");
  tprint(0,3,0,BLACK,CYAN,"Enter information below:");
  tprint(25,3,0,BLACK,RED,"You may press Control-C to break out of this program.");
  tprint(0,5,0,BLACK,CYAN,"How many players? (1-6):");
  do
    {
     j=tinput(ibuf,24,5,1,GRAY,BLACK);
    } while ( (ibuf[0]<'1' || ibuf[0]>'6') && j != 27 );
  if (j == 27 && wtype) goto moder;
  if (j == 27 && !wtype) goto newgame;

  np=ibuf[0]-'0';

reent:
 j=0;
 kk=0;
 do
   {
    tprint(0,7+kk*2,0,BLACK,CYAN,"What is your name player #");
    tprint(26,7+kk*2,0,BLACK,CYAN,nums[kk]);
    tprint(27,7+kk*2,0,BLACK,CYAN,"?");
    do {
        j=tinput(&names[kk][0],28,7+kk*2,9,GRAY,BLACK);
       } while (strlen(names[kk]) == 0 && j != 27);
    if (j != 27) kk++;
    if (j == 27 && kk > 0)
     {
      tprint(0,7+kk*2,80,BLACK,BLACK,blank);
      kk--;
      j=0;
     }
    } while ( kk < np && j !=27);
if (kk == 0) goto backup;
tprint(0,20,80,BLACK,BLACK," ");
tprint(0,21,80,BLACK,BLACK," ");
tprint(10,22,0,BLACK,LIGHT_CYAN,"Is this correct? (Y/N)");
do
 {
  j=getup();
 } while ( j != 'Y' && j != 'N' && j != 27);
 if (j == 27)
   {
    tprint(0,22,80,BLACK,BLACK,blank);
    j=np-1; goto reent;
   }
 if (j == 'N')
   {
    goto backup;
   }

home(BLACK,BLACK);
tprint(0,23,0,BLACK,WHITE,"Letter scoring values:");
for (x=23,j=0; j<7; j++,x=x+j+4)
    {
      tprint(x,23,0,BLACK,WHITE,nums[j]);
      tprint(x+1,23,0,BLACK,WHITE,".");
      tprint(x+2,23,j+1,j+1,j+1,blank);
    }

neword:
  discore();
  x=5;
  y=1;
  bc=BLUE;
  fc=GRAY;
  getword();
  big_print(offset);
agn:
  clrmid();
  discore();
  tprint(5,10,0,BLACK,CYAN,"C)hoose letters or S)pell the word?");
  op=0;
  j=timit(0);
  tprint(0,10,80,BLACK,BLACK,blank);
  if (j == 0)  { nexturn(); goto agn; }
  if (j == 'S')
     {
      dospell();
      if (correct)
         { 
          scores[turn]=scores[turn]+adscore;
          discore();
          clrmid();
          buroing();
          tprint(10,10,0,BLACK,LIGHT_CYAN,"You spelled the word correctly");
          tprint(42,10,0,BLACK,LIGHT_CYAN,&names[turn][0]);
          wtr:
          for (k=0; k<4; k++)
           {
            getime();
            i=sec;
            do { getime(); } while(i == sec);
            }
          nexturn();
          i=winner(69);
          if (i>=0)
            {
             clrmid();
             boroing();
             tprint(10,10,0,BLACK,LIGHT_CYAN,"Congratulations, the winner is...");
             tprint(15,11,0,BLACK,GREEN,&names[i][0]);
             for (k=0; k<5; k++)
               {
                getime();
                i=sec;
                do { getime(); } while(i == sec);
               }
             clrmid();
             tprint(10,10,0,BLACK,LIGHT_CYAN,"Play another game? (Y/N)");
             do {
                 j=getup();
                } while( (j != 'Y') && (j != 'N'));
             if (j == 'N')  { goto leave; }
             goto newgame;
           }
          goto neword;
        }
     else scores[turn]=scores[turn]-5;
   nexturn();
   goto agn;
 }
  getlet();
  fc=GRAY;
  movlet();
  tprint(14,14,0,BLACK,CYAN,"Press SPACE to pass");

  op=1;
  j=timit(0);
  if (j == 0)  { nexturn(); goto agn; }
  kk=poplet(j);
  scores[turn]+=kk;
  discore();
  i=win();
  if (i)
    {
     clrmid();
     buroing();
     tprint(5,7,0,BLACK,LIGHT_CYAN,".........is the word.");
     goto wtr;
    }
  if (kk <= 0)  nexturn();
goto agn;

leave: home(BLACK,YELLOW);
leave2: printf("Thankyou for playing Wrimage."); exit(0);

}

void big_print(str)
char *str;
 {
  i=-1;
  for (x=0,i++;str[i]>0; i++,x=x+5)
   {
    used[i]=0;
    tstr[0]=32;
    slide();
  }
   tprint(x,y,80-x,BLACK,fc,blank);
   tprint(x,y+1,80-x,BLACK,fc,blank);
   tprint(x,y+2,80-x,BLACK,fc,blank);
   length=i;
 }

void plet(void)
 {
   tprint(x,y,0,bc,fc,tlbd);
   tprint(x+1,y,0,bc,fc,tbd);
   tprint(x+2,y,0,bc,fc,tbd);
   tprint(x+3,y,0,bc,fc,tbd);
   tprint(x+4,y,0,bc,fc,trbd);
   tprint(x,y+1,0,bc,fc,lbd);
   tprint(x+1,y+1,0,bc,fc,blank);
   if (bc > 1 )
      tprint(x+2,y+1,1,bc,BLACK,tstr);
   else
      tprint(x+2,y+1,1,bc,LIGHT_CYAN,tstr);
   tprint(x+3,y+1,0,bc,fc,blank);
   tprint(x+4,y+1,0,bc,fc,lbd);
   tprint(x,y+2,0,bc,fc,blbd);
   tprint(x+1,y+2,0,bc,fc,tbd);
   tprint(x+2,y+2,0,bc,fc,tbd);
   tprint(x+3,y+2,0,bc,fc,tbd);
   tprint(x+4,y+2,0,bc,fc,brbd);
 }

void movlet(void)
{
 y=9;
 for (x=13,i=0; i<3; i++,x=x+6)
  {
   tstr[0]=let[i];
   bc=amount[(let[i]-65)];
   slide();
  }
}


void slide(void)
{
int tx,ty;
tx=x;
ty=y;
x=75;
for (y=0; y<=ty; y++)
  {
   if (y>0) tprint(x,y-1,5,BLACK,BLACK,blank);
   plet();
  }
tprint(x,y-1,5,BLACK,BLACK,blank);
for (x=74; x>=tx; x--)
  {
   tprint(x+5,y,0,BLACK,BLACK,blank);
   tprint(x+5,y+1,0,BLACK,BLACK,blank);
   tprint(x+5,y+2,0,BLACK,BLACK,blank);
   plet();
   }
 x=tx; y=ty;
 sounder(1000,1);
 }

void home(bc,fc)
int bc,fc;
 {
for (i=0; i<26; i++)
 tprint(0,i,80,bc,fc," ");
 }

void ptime(void)
 {
  rd++;
  sprintf(vals,"%d",ts);
  ln=strlen(vals);
  if (ln == 2)
     tprint(18,7,0,BLACK,col,vals);
     else { tprint(18,7,0,BLACK,BLACK,blank);
                tprint(19,7,0,BLACK,col,vals);
          }
  tprint(20,7,0,BLACK,col,":");
  sprintf(vals,"%d",th);
  i=strlen(vals);
  if (i>0)
      tprint(21,7,2,BLACK,DARK_GRAY,vals);
 }

int timit(tn)
int     tn;
{
  tprint(17,6,0,BLACK,GRAY,tlbd);
  tprint(23,6,0,BLACK,GRAY,trbd);
  tprint(17,8,0,BLACK,GRAY,blbd);
  tprint(23,8,0,BLACK,GRAY,brbd);
  tprint(17,7,0,BLACK,GRAY,lbd);
  tprint(23,7,0,BLACK,GRAY,lbd);
  for (i=18; i<23; i++)
   {
    tprint(i,6,0,BLACK,GRAY,tbd);
    tprint(i,8,0,BLACK,GRAY,tbd);
   }

  flushk();
  col=CYAN;
if (tn == 0)
 {
  getime();
  sts=sec;
  sth=hsec;
  ts=30;
  th=0;
 }
do
 {
  if (ts<6)  col=RED;
  ptime();
  getime();
  ts=sec;
  th=hsec;
  if (ts >= sts)  ts=29-(ts-sts);
   else ts=29-((60-sts)+ts);
   if (th >= sth)  th=99-(th-sth);
    else th=99-((100-sth)+th);
  i=keystat();
  if (i != 0 )
    {
     i=getup();
     if ( (i < 'A' || i > 'Z') && i!=32) i=0;
      if ((i == 32) && (op == 1))  i=1;
        else
      {
        if ((op == 0) && ( i != 'C' ) && ( i != 'S' ))  i=0;
        if ((op == 1) && (i != let[0]) && (i != let[1]) && (i != let[2]))  i=0;
      }
    }
 }  while ( ( ts >=0 ) && ( i == 0 ) );
   if (i == 1)  i=0;
   ky=i;
   if (ts == 0 )  { th=0; ptime(); }
  srand(rd);
  return(ky);
}



int tinput(buf,x1,y1,l1,bc1,fc1)
char buf[];
int x1,y1,l1,bc1,fc1;
{
buf[0]=0;

j=0;
t=0;
while ( j != 27 && j != 13 )
 {
  tprint(x1,y1,l1,bc1,fc1,buf);
  j=getch();
  if ( !j )
    {
     j=getch();
     if (j==75) j=8;
      else j=0;
    }

  if ( ((j>32 && j<127) || (j==32 && t>0)) && t<l1)
   {
    buf[t]=j;
    t=t+1;
    buf[t]=0;
   }

  if (j==8 && t>0)
   {
    t=t-1;
    buf[t]=0;
   } else if ( (l1 == 1) && (t == 1) )  t=0;

 }
return(j);
}

void discore(void)
{
/* this routine will display the players names and scores */
int sc;
for (j=0; j<np; j++)
{
  sc=scores[j];
  if (sc<-70)  sc=-70;
  if (sc>70)  sc=70;
  if (sc<0)  i=-sc; else i=sc;

  if (j == turn)  tprint(0,16+j,15,GREEN,BLACK,&names[j][0]);

    else tprint(0,16+j,15,BLACK,GREEN,&names[j][0]);

 if (sc>0)  tprint(10,16+j,sc,BLUE,BLUE,blank);
 if (sc<0)  tprint(10,16+j,-sc,RED,RED,blank);

  if (i<70)  for (; i<70; i++) tprint(i+10,16+j,0,BLACK,GRAY,tbd);
}
}

int grand(rd)
int rd;
{
/* this routine will generate a random number between 0 and the int requested */
 return(rand()%rd);
}

int getup()
{

 j=getch();
  if (j>='a' && j<='z')  j=j-32;
 return(j);
 }

void getlet(void)
{

 j=grand(length);
 le1=offset[j];
do
 {
 j=grand(26)+65;
 } while ( j    == le1 );
 le2=j;
 do
  {
  j=grand(26)+65;
  } while ( (j == le1) || (j == le2) );
  le3=j;

 j=grand(3);
 let[j]=le1;
 if (j == 0 )  { let[1]=le2; let[2]=le3; }
 if (j == 1 )  { let[0]=le2; let[2]=le3; }
 if (j == 2 )  { let[0]=le2; let[1]=le3; }
 if (let[1] == 'U')  { let[1]=let[0]; let[0]='U'; }

 }

void nexturn(void)
{
 turn++;
  if (turn == np)  turn=0;
  discore();
}

int poplet(c)
int c;
{

 y=10;
 for (x=13,i=0; i<3; i++,x=x+6)
  {
   tstr[0]=let[i];
   fc=GRAY;
   bc=amount[(let[i]-65)];
   if (let[i] != c)  { bc=BLACK; fc=BLACK; tstr[0]=32; }
   plet();
  }

tprint(0,14,80,BLACK,BLACK,blank);

 i=0;
 for (j=0; j<length; j++)
  {
   if ( (offset[j] == c) && ! used[j] )
         {
              clrmid();
              y=2; x=5*j;  fc=GRAY;
              tstr[0]=c;
              bc=GREEN;
              sounder(900,2);
              plet();
              getime();
              k=sec;
              do { getime(); } while(k == sec);
              bc=MAGENTA;
              plet();
              used[j]=1;
              i+=amount[c-65];
             }
   }
getime();
j=sec;
do { getime(); } while (j == sec);
  if (i == 0)
   {
    sounder(8000,2);
    i-=amount[c-65];
    getime();
    j=sec;
    do { getime(); } while (j == sec);
   }
 return(i);
 }

void getword(void)
{
int b;
i=grand(nwords-bas)+bas;
b=i;
for (;words[i] == NULL;)
 {
   i++;
   if (i == nwords) i=bas;
   if (i == b)
      {
       home(BLACK,YELLOW);
       printf("You have used up all of the words available\n");
       boroing();
       i=winner(-1000);
       printf("Congratulations, the winner is...%s\n",names[i]);
       exit(1);
      }
 }
 offset=words[i];
 words[i]=NULL;
}


void dospell(void)
{
int jk,tn;
tn=0;
adscore=0;
tprint(5,10,0,BLACK,CYAN,"Type the MISSING letters in the word.");
correct=1;
for (jk=0; jk<length && correct; jk++)
 {
    for (; used[jk] && jk<length; jk++);
    if (jk < length)
    {
      op=2;
      i=timit(tn);
      if (tn == 0)  tn=1;
      if (i == offset[jk])
              {
                sounder(1200,1);
                y=2; x=5*jk; bc=RED; fc=GRAY;
                tstr[0]=i; plet();
                used[jk]=1;
                adscore=adscore+amount[i-65]+4;
              }
               else
               {
               sounder(8000,2);
               y=2; x=5*jk; bc=GREEN; fc=GRAY;
               tstr[0]=i; plet();
               getime();
               i=sec;
               do { getime(); } while (i == sec);
               getime();
               i=sec;
               do { getime(); } while (i == sec);
               bc=BLUE;
               tstr[0]=32; plet();
               correct=0;
               }
    }
   }
}

void clrmid(void)
 {
  for (m=5; m<15; m++) tprint(0,m,80,BLACK,BLACK,blank);
 }

int win()
{
 i=1;
 for (j=0; j<length; j++)
    {
      if (! used[j])  i=0;
    }
return(i);
}

int winner(j)
int j;
{
 i=-1;
 for (k=0; k<np; k++)
  {
   if (scores[k]>j)  
     {
      i=k;
      j=scores[k];
     }
   }
  return(i);
 }

void sounder(tone,duration)
int     tone,duration;
{
if (sound_set == 1)  sound(tone,duration);
}

void buroing(void)
{
int tone;
if (sound_set == 1)
   {
    for (tone=1000; tone < 10000; tone=tone+50) sound2(tone,500);
   }
}

void boroing(void)
{
int tone;
if (sound_set == 1)
   {
    for (tone=1000; tone < 10000; tone=tone+50) sound2(tone,3000);
   }
}

