/*
ͻ
                     WordUp Graphics Toolkit Version 4.0                    
                            Demonstration Program 6                         
                                                                            
Draws lines of different colours, then fades the colours in and out         
in various ways.                                                            
                                                                            
  PROJECT                                                             
 This program requires the file WGT4.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 NONE                                                                       
                                                                            
ͼ
*/

#include <wgt4.h>

int y;
int oldmode;
color palette[256];
color blackpalette[256];	/* All value will be set to 0... */
color temppal[256];		/* Another black palette */

void main(void)
{
  if ( !vgadetected() )
  {
    printf("Error - VGA card required for any WGT program.\n");
    exit(0);
  }

  oldmode=wgetmode();
  vga256();

  wsetpalette(0,255,blackpalette); /* Hide all colours while we draw */

  /* Now let's make a screen while all the colours are black. */
  wcls(0);
  for (y = 0; y < 500; y++)
  {
    wsetcolor(rand() % 256);
    wline(rand() % 320,rand() % 200,rand() % 320,rand() % 200);
  }

  /* Make a palette with some colours. */
  for (y = 0; y < 64; y++)
    wsetrgb(y,y,y,y,palette);
  for (y = 0; y < 64; y++)
    wsetrgb(y + 64,y,0,0,palette);
  for (y = 0; y < 64; y++)
    wsetrgb(y + 128,0,y,0,palette);
  for (y = 0; y < 64; y++)
    wsetrgb(y + 192,0,0,y,palette);

  /* Fade in the screen */
  wfade_in(1,255,0,palette);
  delay(1000);

  wfade_out(0,255,20,palette);

  /* Draw a new screen */
  wcls(0);
  for (y = 0; y < 320; y++)
  {
    wsetcolor(y % 200);
    wline(319 - y,0,319,(float)y / 320.0 * 200);
    wline(0,(float)y / 320.0 * 200,319 - y,199);
  }

  wfade_in(1,200,40,palette);
  delay(2000);

  wfade_out(1,50,10,palette);
  wfade_out(50,75,10,palette);
  wfade_out(75,100,10,palette);
  wfade_out(100,125,10,palette);
  wfade_out(125,150,10,palette);
  wfade_out(150,175,10,palette);
  wfade_out(175,200,10,palette);

  for (y = 0; y < 64; y++)
  {
    wline(rand() % 319,rand() % 199,rand() % 319,rand() % 199);
    wfade_in_once(1,200,palette,temppal);
    wsetpalette(1,255,temppal);
    delay(30);
    /* Fade in while drawing lines. */
  }

  delay(2000);
  for (y = 0; y < 64; y++)
  {
    wline(rand() % 319,rand() % 199,rand() % 319,rand() % 199);
    wfade_out_once(1,200,palette);
    delay(30);
    /* Fade out while drawing lines. */
  }

  wsetmode(oldmode);
}