/* TGDLP4 common Data Types and Structures V1.1
 * Copyright (C) 1994 Tale Software
 * All rights reserved.
 */

/* TGDCONST.H already included? */
#ifndef TGDCONST_H
#define TGDCONST_H

/* define origin data types as understood by tale software */
#ifndef TALE_DATA_TYPES
 #define TALE_DATA_TYPES
 typedef unsigned char ubyte;	   /* unsigned byte */
 typedef signed char byte;	   /* signed byte */
 typedef unsigned int uword;	   /* unsigned word */
 typedef signed int word;	   /* signed word */
 typedef unsigned long int udword; /* unsigned double word */
#endif

/* the tgdlp4 structures */
typedef struct { uword xsize,ysize;
		 uword bytespline;
		 ubyte huge *plane[4];	/* but you can use far, too */
	       } bitmap;

typedef struct { ubyte fonttype;
		 ubyte startchr,stopchr;
		 ubyte pad;		/* for word alignment */
		 uword chrxsize,chrysize;
		 word spacingx,spacingy;
		 bitmap fontbitmap;
/*               uword propxsize[256];	only for proportional width fonts */
	       } fontmap;

typedef struct { ubyte animseqno;
		 ubyte pad;		/* for word alignment */
		 uword animseqsize;
		 bitmap spritebitmap;
	       } spritemap;

typedef struct { byte spronoff;
		 byte sprvisible;
		 ubyte animseq;
		 byte sprkvalid;
		 word sprcxpos,sprcypos;
		 uword sprbsxpos,sprbsypos;
		 uword sprbdxpos,sprbdypos;
		 uword sprbxsize,sprbysize;
		 uword sprvxpos,sprvypos;
		 uword sprvcxpos,sprvcypos;
		 uword sprvxsize,sprvysize;
		 word sprkrxpos,sprkrypos;
		 uword sprkxsize,sprkysize;
		 uword sprkaxpos,sprkaypos;
		 uword sprkaxsize,sprkaysize;
		 spritemap far *sprdef;
		 bitmap sprincbitmap;

		 byte dblspronoff;
		 byte dblsprvisible;
		 ubyte dblanimseq;
		 byte dblsprkvalid;
		 word dblsprcxpos,dblsprcypos;
		 uword dblsprbsxpos,dblsprbsypos;
		 uword dblsprbdxpos,dblsprbdypos;
		 uword dblsprbxsize,dblsprbysize;
		 uword dblsprvxpos,dblsprvypos;
		 uword dblsprvcxpos,dblsprvcypos;
		 uword dblsprvxsize,dblsprvysize;
		 word dblsprkrxpos,dblsprkrypos;
		 uword dblsprkxsize,dblsprkysize;
		 uword dblsprkaxpos,dblsprkaypos;
		 uword dblsprkaxsize,dblsprkaysize;
		 spritemap far *dblsprdef;
		 bitmap dblsprincbitmap;
	       } spriteinc;

#endif /* TGDCONST_H */
