;=============================================================================
; 0plasma.asm - Builds the diferent plasma effects.
;                                                    File created: 10-21-93
; Copyright (c) 1993, Carlos Hasan                  Last modified: 10-21-93
;
; Description:
;   This is just a simple loader that executes three differect plasma
;   routines that must be linked with this file.
;
; Portability:
;  Requires Turbo Assembler 3.2 or better to be assembler.
;  Dependent on the IBM PC 286 and the VGA graphics card.
;=============================================================================

                dosseg
                .model  small,pascal
                .286

                .stack  1024

                global  ColorPlasma:proc        ; in CPLASMA.ASM
                global  SinusPlasma:proc        ; in RPLASMA.ASM
                global  WavePlasma:proc         ; in WPLASMA.ASM


;====================== Demo Code ============================================

                .code

;-----------------------------------------------------------------------------
; Start - Entry point of execution for this tiny demostration.
; In:
;  DS - Program Segment Prefix.
;  CS - Code Segment.
;-----------------------------------------------------------------------------

Start           proc

                mov     ax,@Data                ; setup DS segment.
                mov     ds,ax
                call    ColorPlasma             ; do color plasma.
                call    SinusPlasma             ; do sinus plasma.
                call    WavePlasma              ; do wave plasma.
                mov     ax,4C00h
                int     21h                     ; exit to DOS.

Start           endp

                end     Start
;
