// IPsrc.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "ipsrc.h"
#include "conio.h"
#include "defines.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//#define HARDCODED			// uncomment for hard coded IP and port
#define HARDIP "10.10.6.100"	// hard coded IP
#define HARDPORT "1234"			// hard coded port

char PBGCOPYRIGHT[] = "Copyright (C) 2001, Paul B. Gerhart";

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	int nRetCode = 0;

	// initialize MFC and print and error on failure
	if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		cerr << _T("Fatal Error: MFC initialization failed") << endl;
		nRetCode = 1;
	}
	else
	{
	/////////////////////////////////////////
	// do this if hardcoded
#ifdef HARDCODED
		Start(HARDPORT);
#endif
	/////////////////////////////////////////

	/////////////////////////////////////////
	// do this if not hardcoded
#ifndef HARDCODED
		if (argc < 2)
		{
			printf( "\nCorrect Usage is\n\n   IPsrc portnumber [/TCP]\n\n"
					"Since you did not type a portnumber IPsrc will\n"
					"  use port 80. The IP and port numbers must match\n"
					"  between IPsrc and IPsink. Have a nice day ;-)\n\n");
			Start("80");
		}
		else
		{
			printf("\n...You specified port number %s\n\n", argv[1]);
			if (argc == 4)
			{
				CString s = argv[3];
				if (s == "/TCP")
				{
					m_eProtocolMode = eTCP;
				}
			}
			else
			{
				m_eProtocolMode = eUDP;
			}
			Start(argv[2]);
		}
#endif
	/////////////////////////////////////////

		printf("\n\nhit any key to exit");
		char c = getc(stdin);
	}

	return nRetCode;
}

/////////////////////////////////////////////////////////////////////////////
void Start(char * pPort)
{
	WORD wVersionRequested = MAKEWORD(1, 1);
	WSADATA WsaData;
	int err = WSAStartup(wVersionRequested, &WsaData);
	if (err == SOCKET_ERROR)
	{
		printf("WSAStartup failed: %ld\n", GetLastError());
		return;
	}

	m_timeout.tv_sec = 15; // in seconds
	m_timeout.tv_usec = 0;
	
	CString s;

	/////////////////////////////////////////
	// do this if hardcoded
#ifdef HARDCODED
	CString s = Send(HARDIP, pPort);
	printf("%s\n\n", s);
#endif
	/////////////////////////////////////////

	/////////////////////////////////////////
	// do this if not hardcoded
#ifndef HARDCODED

	printf("\nGetting local IP address...\n");
	m_sLocalDotName = GetLocalDotName();

	if (m_sLocalDotName.GetLength())
	{
		printf("\n\nThis box's IP address is %s\n", (const char *)m_sLocalDotName);

		printf( "\n  If you want to send to %s hit Enter\n"
				"   Otherwise type your desired IP in dot notation\n\n", (const char *)m_sLocalDotName);
		
		CString sHost = m_sLocalDotName;
		char szBuf[83];
		szBuf[0] = 80;
		char * pChar = _cgets(szBuf);
		if (*pChar == NULL)
		{
			;
		}
		else
		{
			// he typed in an IP
			sHost = pChar;
		}
		
		CString s = Send((const char *)sHost, pPort);
		printf("%s\n\n", s);
	}
#endif
	/////////////////////////////////////////
}

/////////////////////////////////////////////////////////////////////////////
CString Send(const char *szHost, const char *szPort)
{
	CString sRet = "";
	
	// become a client
	eClientFail eCF = ConnectToServerAsClient(szHost, szPort);

	if (eCF != eClientOK)
	{
		sRet.Format(SOCKERR " %d: Error while connecting", WSAGetLastError());
		if (m_sLocalDotName == szHost && m_eProtocolMode == eTCP)
		{
			sRet += "\n\nSince you connected via TCP to your local machine"
					" this failure is probably an expected condition.";
		}
		return sRet;
	}

//	regarding the eCF values above (not the quality or result of a Send)... 
//
//	Port Number of all cases is 80
//
//	Client Destination == Local Machine
//	Server Site == Local Machine
//	------------------------------------
//	UDP		TCP
//	OK		cClientFail4
//
//	Client Destination == some remote host
//	Server Site == Local Machine
//	------------------------------------
//	UDP		TCP
//	OK		OK

	CString sMsg;
	sMsg.Format("This is a test message from IPsrc at %s.", m_sLocalDotName);

	// send a message on socket
	int nBytesSent = 0;
	int i = 0;
	int j;
	printf("\n");
	BOOL bLoop = FALSE;
	BOOL bContinue = TRUE;
	char szBuf[83];
	szBuf[0] = 80;
	while (nBytesSent != SOCKET_ERROR && bContinue)
	{
		nBytesSent = send(m_hSendRcvSocket, (const char *)sMsg, sMsg.GetLength(), 0 );
		i++;
		if (!bLoop)
		{
			printf("sent %d. Hit Return to send again, X to Exit, a number for a loop.\n", i);
			char * pChar = _cgets(szBuf);
			if (*pChar == NULL)
			{
				;
			}
			else if (szBuf[2] == 'X' || szBuf[2] == 'x')
			{
				bContinue = FALSE;
			}
			else if (szBuf[2] > '0' && szBuf[2] <= '9')
			{
				bLoop = TRUE;
				j = atoi(pChar);
			}
		}
		else
		{
			j--;
			if (j == 1)
			{
				bLoop = FALSE;
			}
			printf("sent %d.\n", i);
		}
	}
	
	if (nBytesSent == SOCKET_ERROR) 
	{
		closesocket(m_hSendRcvSocket);
		sRet.Format(SOCKERR " %d: Error while sending data", WSAGetLastError());
		return sRet;
	}

	return sRet;
}

/////////////////////////////////////////////////////////////////////////////
// assumes no white space in arguments
eClientFail ConnectToServerAsClient(const char *szName, const char *szPort)
{
	SOCKET cli_sock;
	struct sockaddr_in cli_addr;
	LPHOSTENT lpHost;

	int nRet = 0;

	memset((char *)&cli_addr, 0, sizeof(cli_addr));

	cli_addr.sin_addr.s_addr = INADDR_ANY;		

	int nPortNumber = atoi(szPort);
	cli_addr.sin_port = htons(nPortNumber); // no specific local port req'd

	if ((szName[0] >= '0') && (szName[0] <= '9')) 
	{
		cli_addr.sin_addr.s_addr = inet_addr(szName);	
		cli_addr.sin_family = AF_INET;
	}
	else
	{
		// would use this for domain names
		// 128.11.120.114 is Honeywell
		lpHost = gethostbyname(szName);
		if (lpHost == NULL)
		{
			return eClientFail1;
		}
		memcpy((char *)&cli_addr.sin_addr, (char *)lpHost->h_addr, lpHost->h_length);
		cli_addr.sin_family = lpHost->h_addrtype;
	}

	// create local socket
	if (m_eProtocolMode == eUDP)
	{
		cli_sock = socket(PF_INET, SOCK_DGRAM, 0);
	}
	else
	{
		cli_sock = socket(PF_INET, SOCK_STREAM, 0); //SOCK_STREAM for TCP
	}
	
	if (cli_sock == INVALID_SOCKET)
	{
		return eClientFail2;
	}

// DONT bind local socket - that is what a server does and I am the client
//	nRet = bind(cli_sock, (LPSOCKADDR)&cli_addr, sizeof(cli_addr));
//	if (nRet == SOCKET_ERROR)
//	{
//		closesocket(cli_sock);
//		return eClientFail3;
//	}

	nRet = connect(cli_sock, (LPSOCKADDR)&cli_addr, sizeof(cli_addr));
	if (nRet == SOCKET_ERROR)
	{
		closesocket(cli_sock);
		return eClientFail4;
	}

// Would do this in a Windows app
//	nRet = WSAAsyncSelect(	cli_sock, 
//							m_hWnd, 
//							WM_WINSOCK_EVENT_SENDRCV, 
//							FD_WRITE|FD_READ|FD_CLOSE|FD_OOB|FD_ACCEPT);		
//	if (nRet == SOCKET_ERROR)
//	{
//		closesocket(cli_sock);
//		int n = WSAGetLastError();
//		return eClientFail5;
//	}

// DONT want to listen - that is what a server does and I am a client
//	nRet = listen(srv_sock, SOMAXCONN);
//	if (nRet == SOCKET_ERROR)
//	{
//		closesocket(cli_sock);
//		int n = WSAGetLastError();
//		return eClientFail6;
//	}

	m_hSendRcvSocket = cli_sock;
    return eClientOK;
}

/////////////////////////////////////////////////////////////////////////////
CString GetLocalDotName(void) 
{
	hostent * pMyHostEnt;
	char szMyName[100];
	memset(szMyName, 0, 100);
	gethostname(szMyName, 100);
	
	CString sLocalDotName = "";
	CString sLocalDotName1 = "";
	CString sLocalDotName1plus4 = "";
	
	pMyHostEnt = gethostbyname(szMyName);
	if (pMyHostEnt)
	{
		int nLenName = strlen(pMyHostEnt->h_name);
		int nLenList = strlen(*pMyHostEnt->h_addr_list);
		BOOL bDo2 = FALSE;
		if (nLenName && nLenList)
		{
			int nDiff = nLenList-nLenName;
			if (nDiff == 8)
			{
				bDo2 = TRUE;
			}
		}
		//////////////////////////////
		char * pChar1 = *(pMyHostEnt->h_addr_list);

		in_addr strMyInAddr1;
		char * pChar1Dest1 = (char *)(&strMyInAddr1);
		memcpy( pChar1Dest1, pChar1, 4); 

		sLocalDotName1 = inet_ntoa(strMyInAddr1);

		//////////////////////////////
		if (bDo2)
		{
			char * pChar1plus4 = pChar1+4;

			in_addr strMyInAddr1plus4;
			char * pChar1Dest1plus4 = (char *)(&strMyInAddr1plus4);
			memcpy( pChar1Dest1plus4, pChar1plus4, 4); 

			sLocalDotName1plus4 = inet_ntoa(strMyInAddr1plus4);
		}

		//////////////////////////////
		if (sLocalDotName1plus4.GetLength())
		{
			sLocalDotName = sLocalDotName1plus4;
		}
		else
		{
			sLocalDotName = sLocalDotName1;
		}
		
		NeatTest();
	}
	else
	{
		printf("\n\nUnable to get local IP address.");
	}
	return sLocalDotName;
}

/////////////////////////////////////////////////////////////////////////////
void NeatTest(void) 
{
	// optional - for the interested student only
	hostent * pMyHostEnt;
	char szMyName[100];
	memset(szMyName, 0, 100);
	gethostname(szMyName, 100);
	
	CString sLocalDotName1;
	CString sLocalDotName1plus4;
	
	pMyHostEnt = gethostbyname(szMyName);

	char * pChar1 = *(pMyHostEnt->h_addr_list);
	char * pChar1plus4 = pChar1+4;

	in_addr strMyInAddr1;
	in_addr strMyInAddr1plus4;
	char * pCharDest1 = (char *)(&strMyInAddr1);
	char * pCharDest1plus4 = (char *)(&strMyInAddr1plus4);
	memcpy(pCharDest1, pChar1, 4);
	memcpy(pCharDest1plus4, pChar1plus4, 4);

	CString sLocal1;
	CString sLocal1plus4;
	sLocal1 = inet_ntoa(strMyInAddr1);
	sLocal1plus4 = inet_ntoa(strMyInAddr1plus4);
}
