Imports System.Drawing.Printing
Imports IDAutomation.Windows.Forms.LinearBarCode
Public Class frmIDAutomation
	Inherits System.Windows.Forms.Form


#Region " Windows Form Designer generated code "

	Public Sub New()
		MyBase.New()

		'This call is required by the Windows Form Designer.
		InitializeComponent()

		'Add any initialization after the InitializeComponent() call

	End Sub

	'Form overrides dispose to clean up the component list.
	Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
		If disposing Then
			If Not (components Is Nothing) Then
				components.Dispose()
			End If
		End If
		MyBase.Dispose(disposing)
	End Sub

	'Required by the Windows Form Designer
	Private components As System.ComponentModel.IContainer

	'NOTE: The following procedure is required by the Windows Form Designer
	'It can be modified using the Windows Form Designer.  
	'Do not modify it using the code editor.
	Friend WithEvents txtDataToEncode As System.Windows.Forms.TextBox
	Friend WithEvents Label1 As System.Windows.Forms.Label
	Friend WithEvents Label2 As System.Windows.Forms.Label
	Friend WithEvents cboSymbology As System.Windows.Forms.ComboBox
	Friend WithEvents cmdUpdateBarcode As System.Windows.Forms.Button
    Friend WithEvents PictureBox1 As System.Windows.Forms.PictureBox
    Friend WithEvents Label4 As System.Windows.Forms.Label
	Friend WithEvents cmdPrint As System.Windows.Forms.Button
	Friend WithEvents Barcode1 As IDAutomation.Windows.Forms.LinearBarCode.Barcode
	Friend WithEvents chkUseCheckDigit As System.Windows.Forms.CheckBox
	Friend WithEvents chkShowText As System.Windows.Forms.CheckBox
	Friend WithEvents chkShowCheckDigit As System.Windows.Forms.CheckBox

	<System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.txtDataToEncode = New System.Windows.Forms.TextBox()
        Me.Label1 = New System.Windows.Forms.Label()
        Me.Label2 = New System.Windows.Forms.Label()
        Me.cboSymbology = New System.Windows.Forms.ComboBox()
        Me.cmdUpdateBarcode = New System.Windows.Forms.Button()
        Me.PictureBox1 = New System.Windows.Forms.PictureBox()
        Me.Label4 = New System.Windows.Forms.Label()
        Me.cmdPrint = New System.Windows.Forms.Button()
        Me.Barcode1 = New IDAutomation.Windows.Forms.LinearBarCode.Barcode()
        Me.chkUseCheckDigit = New System.Windows.Forms.CheckBox()
        Me.chkShowText = New System.Windows.Forms.CheckBox()
        Me.chkShowCheckDigit = New System.Windows.Forms.CheckBox()
        Me.SuspendLayout()
        '
        'txtDataToEncode
        '
        Me.txtDataToEncode.Location = New System.Drawing.Point(7, 125)
        Me.txtDataToEncode.Name = "txtDataToEncode"
        Me.txtDataToEncode.Size = New System.Drawing.Size(240, 26)
        Me.txtDataToEncode.TabIndex = 1
        Me.txtDataToEncode.Text = ""
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Location = New System.Drawing.Point(15, 101)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(113, 19)
        Me.Label1.TabIndex = 2
        Me.Label1.Text = "Data To Encode"
        '
        'Label2
        '
        Me.Label2.AutoSize = True
        Me.Label2.Location = New System.Drawing.Point(16, 157)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(82, 19)
        Me.Label2.TabIndex = 3
        Me.Label2.Text = "Symbology"
        '
        'cboSymbology
        '
        Me.cboSymbology.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.cboSymbology.Location = New System.Drawing.Point(7, 181)
        Me.cboSymbology.Name = "cboSymbology"
        Me.cboSymbology.Size = New System.Drawing.Size(248, 27)
        Me.cboSymbology.Sorted = True
        Me.cboSymbology.TabIndex = 4
        '
        'cmdUpdateBarcode
        '
        Me.cmdUpdateBarcode.Location = New System.Drawing.Point(369, 268)
        Me.cmdUpdateBarcode.Name = "cmdUpdateBarcode"
        Me.cmdUpdateBarcode.Size = New System.Drawing.Size(120, 38)
        Me.cmdUpdateBarcode.TabIndex = 5
        Me.cmdUpdateBarcode.Text = "Update Barcode"
        '
        'PictureBox1
        '
        Me.PictureBox1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.PictureBox1.Location = New System.Drawing.Point(321, 30)
        Me.PictureBox1.Name = "PictureBox1"
        Me.PictureBox1.Size = New System.Drawing.Size(306, 66)
        Me.PictureBox1.TabIndex = 10
        Me.PictureBox1.TabStop = False
        '
        'Label4
        '
        Me.Label4.AutoSize = True
        Me.Label4.Location = New System.Drawing.Point(326, 6)
        Me.Label4.Name = "Label4"
        Me.Label4.Size = New System.Drawing.Size(176, 19)
        Me.Label4.TabIndex = 11
        Me.Label4.Text = "Enhanced Metafile Image"
        '
        'cmdPrint
        '
        Me.cmdPrint.Location = New System.Drawing.Point(509, 268)
        Me.cmdPrint.Name = "cmdPrint"
        Me.cmdPrint.Size = New System.Drawing.Size(120, 38)
        Me.cmdPrint.TabIndex = 12
        Me.cmdPrint.Text = "Display && Print Metafile Picture"
        '
        'Barcode1
        '
        Me.Barcode1.BackColor = System.Drawing.Color.White
        Me.Barcode1.BarHeightCM = "1.000"
        Me.Barcode1.CheckCharacter = True
        Me.Barcode1.CheckCharacterInText = False
        Me.Barcode1.CODABARStartChar = "A"
        Me.Barcode1.CODABARStopChar = "B"
        Me.Barcode1.Code128Set = IDAutomation.Windows.Forms.LinearBarCode.Barcode.Code128CharacterSets.Auto
        Me.Barcode1.DataToEncode = "23"
        Me.Barcode1.FitControlToBarcode = False
        Me.Barcode1.LeftMarginCM = "0.200"
        Me.Barcode1.Name = "Barcode1"
        Me.Barcode1.NarrowToWideRatio = "2.0"
        Me.Barcode1.PostnetHeightShort = "0.125"
        Me.Barcode1.PostnetHeightTall = "0.300"
        Me.Barcode1.PostnetSpacing = "0.042"
        Me.Barcode1.Resolution = IDAutomation.Windows.Forms.LinearBarCode.Barcode.Resolutions.Screen
        Me.Barcode1.ResolutionCustomDPI = "96.00"
        Me.Barcode1.RotationAngle = IDAutomation.Windows.Forms.LinearBarCode.Barcode.RotationAngles.Zero_Degrees
        Me.Barcode1.ShowText = True
        Me.Barcode1.Size = New System.Drawing.Size(251, 94)
        Me.Barcode1.SupplementHeight = "0.80"
        Me.Barcode1.SupplementToEncode = ""
        Me.Barcode1.SuppSeparationCM = "0.500"
        Me.Barcode1.SymbologyID = IDAutomation.Windows.Forms.LinearBarCode.Barcode.Symbologies.Code128
        Me.Barcode1.TabIndex = 13
        Me.Barcode1.TextFontColor = System.Drawing.Color.Black
        Me.Barcode1.TextMargin_CM = "0.100"
        Me.Barcode1.TopMarginCM = "0.200"
        Me.Barcode1.UPCEANSupplement2 = False
        Me.Barcode1.UPCEANSupplement5 = False
        Me.Barcode1.UPCESystem = "1"
        Me.Barcode1.XDimensionCM = "0.0300"
        '
        'chkUseCheckDigit
        '
        Me.chkUseCheckDigit.Location = New System.Drawing.Point(12, 223)
        Me.chkUseCheckDigit.Name = "chkUseCheckDigit"
        Me.chkUseCheckDigit.Size = New System.Drawing.Size(174, 25)
        Me.chkUseCheckDigit.TabIndex = 14
        Me.chkUseCheckDigit.Text = "Use Check Digit"
        '
        'chkShowText
        '
        Me.chkShowText.Location = New System.Drawing.Point(214, 223)
        Me.chkShowText.Name = "chkShowText"
        Me.chkShowText.Size = New System.Drawing.Size(220, 25)
        Me.chkShowText.TabIndex = 15
        Me.chkShowText.Text = "Show Human Readable Text"
        '
        'chkShowCheckDigit
        '
        Me.chkShowCheckDigit.Location = New System.Drawing.Point(444, 224)
        Me.chkShowCheckDigit.Name = "chkShowCheckDigit"
        Me.chkShowCheckDigit.Size = New System.Drawing.Size(201, 21)
        Me.chkShowCheckDigit.TabIndex = 16
        Me.chkShowCheckDigit.Text = "Show Check Digit In Text"
        '
        'frmIDAutomation
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(7, 19)
        Me.ClientSize = New System.Drawing.Size(640, 311)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.chkShowCheckDigit, Me.chkShowText, Me.chkUseCheckDigit, Me.Barcode1, Me.Label4, Me.Label1, Me.Label2, Me.cmdPrint, Me.PictureBox1, Me.cmdUpdateBarcode, Me.cboSymbology, Me.txtDataToEncode})
        Me.Font = New System.Drawing.Font("Times New Roman", 12.0!, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, CType(0, Byte))
        Me.Name = "frmIDAutomation"
        Me.Text = "IDAutomation Example"
        Me.ResumeLayout(False)

    End Sub

#End Region

	Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
		'Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Barcode1, Me.cboCode128Set, Me.Label3, Me.cmdUpdateBarcode, Me.cmdExit, Me.cboSymbology, Me.Label1, Me.Label2, Me.txtDataToEncode})
		cboSymbology.Items.Add("CODE11")
		cboSymbology.Items.Add("CODE39")
		cboSymbology.Items.Add("CODE39EXT")
		cboSymbology.Items.Add("INTERLEAVED25")
		cboSymbology.Items.Add("CODABAR")
		cboSymbology.Items.Add("MSI")
		cboSymbology.Items.Add("UPCA")
		cboSymbology.Items.Add("IND25")
		cboSymbology.Items.Add("MAT25")
		cboSymbology.Items.Add("EAN13")
		cboSymbology.Items.Add("EAN8")
		cboSymbology.Items.Add("UPCE")
		cboSymbology.Items.Add("CODE128")
		cboSymbology.Items.Add("CODE93EXT")
		cboSymbology.Items.Add("POSTNET")
		cboSymbology.Items.Add("PLANET")

        'cboCode128Set.Items.Add("Auto")
        'cboCode128Set.Items.Add("A")
        'cboCode128Set.Items.Add("B")
        'cboCode128Set.Items.Add("C")

		txtDataToEncode.Text = Barcode1.DataToEncode

		SetSymbologyBoxEntry()

		chkUseCheckDigit.Checked = Barcode1.CheckCharacter
		chkShowText.Checked = Barcode1.ShowText
		chkShowCheckDigit.Checked = Barcode1.CheckCharacterInText
	End Sub

	Private Sub SetSymbologyBoxEntry()
		Dim SymbID As String

		If Barcode1.SymbologyID = Barcode1.Symbologies.Codabar Then
			SymbID = "CODABAR"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code11 Then
			SymbID = "CODE11"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code128 Then
			SymbID = "CODE128"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code39 Then
			SymbID = "CODE39"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code39Ext Then
			SymbID = "CODE39EXT"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code93 Then
			SymbID = "CODE93"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code93Ext Then
			SymbID = "CODE93EXT"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Ean13 Then
			SymbID = "EAN13"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Ean8 Then
			SymbID = "EAN8"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Ind25 Then
			SymbID = "IND25"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Interleaved25 Then
			SymbID = "INTERLEAVED25"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Mat25 Then
			SymbID = "MAT25"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.MSI Then
			SymbID = "MSI"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Planet Then
			SymbID = "PLANET"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Postnet Then
			SymbID = "POSTNET"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.UPCa Then
			SymbID = "UPCA"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.UPCe Then
			SymbID = "UPCE"
		End If

		Dim cboIndex As Integer
		cboIndex = cboSymbology.FindStringExact(SymbID)
		cboSymbology.SelectedIndex = cboIndex

		If Barcode1.Code128Set = Barcode1.Code128CharacterSets.A Then
			SymbID = "A"
		ElseIf Barcode1.Code128Set = Barcode1.Code128CharacterSets.B Then
			SymbID = "B"
		ElseIf Barcode1.Code128Set = Barcode1.Code128CharacterSets.C Then
			SymbID = "C"
		ElseIf Barcode1.Code128Set = Barcode1.Code128CharacterSets.Auto Then
			SymbID = "AUTO"
        End If

        'cboIndex = cboCode128Set.FindStringExact(SymbID)
        'cboCode128Set.SelectedIndex = cboIndex

        UpdateFormCaption()
	End Sub

	Private Sub UpdateFormCaption()
		If Barcode1.SymbologyID = Barcode1.Symbologies.Codabar Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Codabar"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code11 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Code11"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code128 Then
			If Barcode1.Code128Set = Barcode1.Code128CharacterSets.A Then
				Me.Text = "IDAutomation Example - " & "Barcoding with Code128 Set A"
			ElseIf Barcode1.Code128Set = Barcode1.Code128CharacterSets.B Then
				Me.Text = "IDAutomation Example - " & "Barcoding with Code128 Set B"
			ElseIf Barcode1.Code128Set = Barcode1.Code128CharacterSets.C Then
				Me.Text = "IDAutomation Example - " & "Barcoding with Code128 Set C"
			ElseIf Barcode1.Code128Set = Barcode1.Code128CharacterSets.Auto Then
				Me.Text = "IDAutomation Example - " & "Barcoding with Code128 Auto"
			End If
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code39 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Code39"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code39Ext Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Code39 Extended"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code93 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Code93"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Code93Ext Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Code93 Extended"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Ean13 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with EAN-13"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Ean8 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with EAN-8"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Ind25 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Industrial 2 of 5"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Interleaved25 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Interleaved 2 of 5"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Mat25 Then
			Me.Text = "IDAutomation Example - " & "Barcoding with MAT 2 of 5"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.MSI Then
			Me.Text = "IDAutomation Example - " & "Barcoding with MSI Plessey"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Planet Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Planet"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.Postnet Then
			Me.Text = "IDAutomation Example - " & "Barcoding with Postnet"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.UPCa Then
			Me.Text = "IDAutomation Example - " & "Barcoding with UPC-A"
		ElseIf Barcode1.SymbologyID = Barcode1.Symbologies.UPCe Then
			Me.Text = "IDAutomation Example - " & "Barcoding with UPC-E"
		End If
	End Sub

	Protected Overrides Sub OnPaint(ByVal e As System.Windows.Forms.PaintEventArgs)
		UpdateFormCaption()
	End Sub

	Private Sub txtDataToEncode_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtDataToEncode.TextChanged
		Barcode1.DataToEncode = txtDataToEncode.Text
	End Sub

	Private Sub cmdPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPrint.Click
		Dim myImage As System.Drawing.Imaging.Metafile
		myImage = Barcode1.Picture

		PictureBox1.Image = myImage

		'This is the event handler to print the image of this barcode on the printer
		'Make sure that system.drawing.printing is imported to use this

		'Create the document object that we are sending to the printer
		Dim prndoc As PrintDocument = New PrintDocument()

		'Give the document a title.  This is what displays in the Printers Control Panel item
		prndoc.DocumentName = "Printing a Barcode"

		'Add an event handler to handle any additional processing that may need to occur, such
		'as positioning of text
		AddHandler prndoc.PrintPage, New System.Drawing.Printing.PrintPageEventHandler(AddressOf PrintDocumentOnPrintPage)

		'Initiate the printing of the page.  PrintDocumentOnPrintPage will be handled next
		prndoc.Print()
	End Sub

	Private Sub PrintDocumentOnPrintPage(ByVal sender As Object, ByVal ppea As PrintPageEventArgs)
		Dim grfx As System.Drawing.Graphics = ppea.Graphics
		Dim myImage As System.Drawing.Imaging.Metafile

		grfx.DrawString(Me.Text, Me.Font, Brushes.Black, 0, 0)

		myImage = Barcode1.Picture
		grfx.DrawImage(myImage, 0, 40)

	End Sub

	Private Sub cboSymbology_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboSymbology.SelectedIndexChanged
		If cboSymbology.SelectedItem.ToString = "CODE128" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Code128
		ElseIf cboSymbology.SelectedItem.ToString = "CODABAR" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Codabar
		ElseIf cboSymbology.SelectedItem.ToString = "CODE11" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Code11
		ElseIf cboSymbology.SelectedItem.ToString = "CODE39" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Code39
		ElseIf cboSymbology.SelectedItem.ToString = "CODE39EXT" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Code39Ext
		ElseIf cboSymbology.SelectedItem.ToString = "CODE93" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Code93
		ElseIf cboSymbology.SelectedItem.ToString = "CODE93EXT" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Code93Ext
		ElseIf cboSymbology.SelectedItem.ToString = "EAN13" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Ean13
		ElseIf cboSymbology.SelectedItem.ToString = "EAN8" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Ean8
		ElseIf cboSymbology.SelectedItem.ToString = "IND25" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Ind25
		ElseIf cboSymbology.SelectedItem.ToString = "INTERLEAVED25" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Interleaved25
		ElseIf cboSymbology.SelectedItem.ToString = "MAT25" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Mat25
		ElseIf cboSymbology.SelectedItem.ToString = "MSI" Then
			Barcode1.SymbologyID = Barcode.Symbologies.MSI
		ElseIf cboSymbology.SelectedItem.ToString = "PLANET" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Planet
		ElseIf cboSymbology.SelectedItem.ToString = "POSTNET" Then
			Barcode1.SymbologyID = Barcode.Symbologies.Postnet
		ElseIf cboSymbology.SelectedItem.ToString = "UPCA" Then
			Barcode1.SymbologyID = Barcode.Symbologies.UPCa
		ElseIf cboSymbology.SelectedItem.ToString = "UPCE" Then
			Barcode1.SymbologyID = Barcode.Symbologies.UPCe
		End If

		UpdateFormCaption()
	End Sub

    Private Sub chkUseCheckDigit_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkUseCheckDigit.CheckedChanged
        If chkUseCheckDigit.Checked = True Then
            Barcode1.CheckCharacter = True
        Else
            Barcode1.CheckCharacter = False
        End If
    End Sub

    Private Sub chkShowText_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkShowText.CheckedChanged
        If chkShowText.Checked = True Then
            Barcode1.ShowText = True
        Else
            Barcode1.ShowText = False
        End If
    End Sub

    Private Sub chkShowCheckDigit_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkShowCheckDigit.CheckedChanged
        If chkShowCheckDigit.Checked = True Then
            Barcode1.CheckCharacterInText = True
        Else
            Barcode1.CheckCharacterInText = False
        End If
    End Sub
End Class
