// VaxVoIP.cpp: implementation of the CVaxVoIP class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "VCSample.h"
#include "VCSampleDlg.h"
#include "VaxVoIP.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVaxVoIP::CVaxVoIP()
{

}

CVaxVoIP::~CVaxVoIP()
{

}

void CVaxVoIP::ErrorMessage()
{
	DWORD dwError = GetVaxObjectError();
	
	switch(dwError)
	{
		case 10: m_pVCSampleDlg->MessageBox("You are not online, please click the 'Online' button first to make/receive the calls.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 11: m_pVCSampleDlg->MessageBox("Cann't open local communication port.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
		
		case 12: m_pVCSampleDlg->MessageBox("License Key is not valid.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
	
		case 13: m_pVCSampleDlg->MessageBox("Fail to initialize VaxVoIP task window.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 14: m_pVCSampleDlg->MessageBox("Cann't access Input/Mic device or device is already in use.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
		
		case 15: m_pVCSampleDlg->MessageBox("Cann't access Output/Speaker device or device is already in use.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 16: m_pVCSampleDlg->MessageBox("Fail to initialize voice compression manager.", "VaxVoIP SDK", MB_ICONEXCLAMATION); 
			break;

		case 17: m_pVCSampleDlg->MessageBox("Recording media initialization error.", "VaxVoIP SDK", MB_ICONEXCLAMATION); 
			break;

		case 18: m_pVCSampleDlg->MessageBox("Cann't open the wave file.", "VaxVoIP SDK", MB_ICONEXCLAMATION); 
			break;

		case 19: m_pVCSampleDlg->MessageBox("Fail to open voice recording channel.", "VaxVoIP SDK", MB_ICONEXCLAMATION); 
			break;

		case 20: m_pVCSampleDlg->MessageBox("Your sound device does not support mic volume.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 21: m_pVCSampleDlg->MessageBox("Your sound device does not support speaker volume.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
		
		case 22: m_pVCSampleDlg->MessageBox("Error to open wave file to play.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 23: m_pVCSampleDlg->MessageBox("Provided SIP URI is not valid.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
		
		case 24: m_pVCSampleDlg->MessageBox("Codec is not supported.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
		
		case 25: m_pVCSampleDlg->MessageBox("Error to create SDP (Session Description Protocol) request.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 26: m_pVCSampleDlg->MessageBox("Error to create CONNECTION request. Please check the provided SIP URI is valid.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 27: m_pVCSampleDlg->MessageBox("Error to create REGISTER request. Please check the provided SIP URI is valid.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 28: m_pVCSampleDlg->MessageBox("Error to create UN-REGISTER request. Please check the provided SIP URI is valid.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;

		case 29: m_pVCSampleDlg->MessageBox("Error to create DISCONNECT request.", "VaxVoIP SDK", MB_ICONEXCLAMATION);
			break;
	}
}

void CVaxVoIP::OnFailToUnRegister()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Fail to unregister.");
}

void CVaxVoIP::OnSuccessToUnRegister()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Unregistered successfully.");
}
	
void CVaxVoIP::OnFailToRegister()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Fail to register.");
}

void CVaxVoIP::OnSuccessToRegister()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Registered successfully.");
}

void CVaxVoIP::OnFailToConnect()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Fail to connect.");
}


void CVaxVoIP::OnSuccessToConnect(int nTxCodecNo)
{
	m_pVCSampleDlg->OnSuccessToConnect();
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Call connected successfully.");
}

void CVaxVoIP::OnConnecting()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Trying to connect.");
}

/* SIP URI Format:  "DisplayName"<sip:UserName@domain.com> */

void CVaxVoIP::OnIncomingCall(LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sFromURI)
{
	CWnd* pWnd = m_pVCSampleDlg->GetDlgItem(IDC_STATIC_INBOUND_CALL);
	pWnd->SetWindowText("CALL: " + CString(sUserName));
}

void CVaxVoIP::OnDisconnectCall()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Hung up by the other party.");
	
	CWnd* pWnd = m_pVCSampleDlg->GetDlgItem(IDC_STATIC_INBOUND_CALL);
	pWnd->SetWindowText("");
}
	
void CVaxVoIP::OnProvisionalResponse(int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Response: " + CString(sReasonPhrase));
}

void CVaxVoIP::OnRedirectionResponse(int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sContact)
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Response: " + CString(sReasonPhrase));
}


void CVaxVoIP::OnRequestFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Response: " + CString(sReasonPhrase));
}


void CVaxVoIP::OnServerFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Response: " + CString(sReasonPhrase));
}


void CVaxVoIP::OnGeneralFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase)
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Response: " + CString(sReasonPhrase));
}

void CVaxVoIP::OnIncomingCallRingingStart()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Incoming call ringing start.");
}

void CVaxVoIP::OnIncomingCallRingingStop()
{
	m_pVCSampleDlg->m_LogList.InsertItem(m_pVCSampleDlg->m_LogList.GetItemCount(), "Incoming call ringing stop.");
	CWnd* pWnd = m_pVCSampleDlg->GetDlgItem(IDC_STATIC_INBOUND_CALL);
	pWnd->SetWindowText("");
}