import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.beans.*;
import java.util.*;

import com.jpowered.vbgraph.*;

public class VerticalBarApplication {

    // Bean Object
    private VerticalBarGraph vbargraph;
//-----------------------------------------------------------------------------
	public static void main(String args[]) {
		new VerticalBarApplication();
	}
//-----------------------------------------------------------------------------
	public VerticalBarApplication() {
	
		// Create a Frame
		Frame f = new Frame();
		f.setSize(505,425);
		f.addWindowListener(new ApplicationWindowAdapter());		
		
		try {
			// Initialise the Vertical Bar Graph Bean
			vbargraph = (VerticalBarGraph)Beans.instantiate(null,"com.jpowered.vbgraph.VerticalBarGraph");

			// Set the Graph properties
			set_graph_properties();
			
			// Add the data to the graph bean
			define_data();

			// Add the graph to the frame and display
			f.setLayout(null);
			vbargraph.setSize(480,400);
			Dimension d = vbargraph.getSize();
			vbargraph.setBounds(25,25,d.width, d.height);
			f.add(vbargraph);
		}
		catch (Exception ex) {
			ex.printStackTrace();
		}
		f.setVisible(true);
	}

//-----------------------------------------------------------------------------
	private void define_data() {
	
		/* This method builds a data object and then applies it to the bean instance.
		   
		   For the purposes of demonstration the data values are simply 
		   hard coded here. However in practice the data values would be
		   previously acquired from a data source eg. a Database
		   
		   For further information on the Dataobject see:-
		   APIDocs - Dataobject
		*/
	
		// Create a Data Object
		Dataobject data_object = new Dataobject();
		
		// Add 3 series of data to the data object
		data_object.setSeries1("1000.0,2000.0,3000.0,4000.0,5000.0,6000.0");
		data_object.setSeries2("1500.7,2500.3,3000.0,3200.0,2600.3,1700.2");
		data_object.setSeries3("6400.1,4200.8,1500.6,1100.5,3500.0,6000.0");
		
		// Apply the data object to the bean instance
		vbargraph.setDataobj(data_object);

		return;
	}


//-----------------------------------------------------------------------------
	private void set_graph_properties() {
	
	    /* This method sets various properties of the graph.
	       If the following properties are not supplied the bean will
	       automatically calculate the values.
	       
	       For the full range of properties and thier effect please see:-
	       APIdocs - VerticalBarGraph
	       
	    */


    	// Boolean
		vbargraph.setThreed(true);        // 3D
		vbargraph.setGrid(true);          // Grid
		vbargraph.setAxis(true);          // Axis
		vbargraph.setYlabels(true);       // Y Labels
		vbargraph.setOutline(true);       // Outline
		vbargraph.setLegend(true);        // Legend
		vbargraph.setAutoscale(true);     // Autoscale
		vbargraph.setGradientfill(true);  // Gradientfill


		// Integer
		vbargraph.setNrows(6);            // Number of Rows
		vbargraph.setNcols(6);            // Number of Columns
		vbargraph.setVspace(30);          // Vertical Spacing
		vbargraph.setBarwidth(15);        // Bar Width
		vbargraph.setDepth3d(15);         // Depth of the 3D effect
		vbargraph.setNdecplaces(0);       // Number of decimal places to use when displaying number values
		vbargraph.setLabelorientation("Up angle"); // Orientation of x-axis labels
		vbargraph.setLabelsy(310);        // Y position of x-axis labels
		vbargraph.setLabelsy_offset(0);   // Y offset of every 2nd x-axis label
		vbargraph.setBar_spacing(5);      // Gap between bars
		vbargraph.setGridStyle("dotted");        // Grid Line Style

		// Double
		vbargraph.setChartscale(100); // Chart Scale
		vbargraph.setChartstarty(0);  // Chart Start Y value

    	// Font
		vbargraph.setXlabel_font(new Font("Arial",Font.PLAIN,12)); // X Label font
		vbargraph.setYlabel_font(new Font("Arial",Font.ITALIC,10)); // Y Label font
		vbargraph.setPopupfont(new Font("Arial",Font.PLAIN,10)); // Popup font

		// Colors
		vbargraph.setGridcolor(new Color(50,50,50));           // Grid color
		vbargraph.setAxiscolor(new Color(30,30,175));          // Axis color
		vbargraph.setFloorcolor(new Color(100,100,100));          // Floor color
		vbargraph.setBaroutlinecolor(new Color(0,0,0));        // Bar outline color
		vbargraph.setLabelcolor(new Color(75,75,125));         // label color
		vbargraph.setBackgroundcolor(new Color(255,255,255));  // Background color
		vbargraph.setLegendbackground(new Color(240,240,240)); // Legend background color
		vbargraph.setLegendborder(new Color(125,125,125));     // legend border color
		vbargraph.setLegendtextcolor(new Color(50,50,50));     // legend text color
		vbargraph.setPopupbgcolor(new Color(255,255,200));     // Popup bgcolor

		// String
		vbargraph.setPopup_pre("$");         // popup prefix symbol
        vbargraph.setPopup_post("");         // popup post symbol
        vbargraph.setYlabel_pre("$");        // y label prefix symbol
        vbargraph.setYlabel_post("");        // y label post symbol
        vbargraph.setThousandseparator(","); // thousand seperator

		// Grid Properties
 		vbargraph.setGridbgcolor(new Color(238,238,255)); // Grid background color
        vbargraph.setGridposition(new Point(60,300));     // Grid Position


    	// Legend
        vbargraph.setLegendtitle("Product Range");                // Legend Title
        vbargraph.setLegendposition(new Point(300,10));           // Legend Position
		vbargraph.setLegendfont(new Font("Arial",Font.PLAIN,10)); // Legend font

		// Main Title
        vbargraph.setTitletext("Sales by Quarter");             // Title text
		vbargraph.setTitlefont(new Font("Arial",Font.BOLD,18)); // Title font
		vbargraph.setTitlecolor(new Color(130,130,180));        // Title color
        vbargraph.setTitleposition(new Point(50,25));           // Title position

		// X axis Title
        vbargraph.setXtitletext("Year 2005");                      // X axis Title text
		vbargraph.setXtitlefont(new Font("Arial",Font.BOLD,16));   // X axis Title font
		vbargraph.setXtitlecolor(new Color(130,130,180));          // X axis Title color
        vbargraph.setXtitleposition(new Point(180,370));           // X axis Title position

		// Y axis Title
        vbargraph.setYtitletext("Sales Value");                  // Y axis Title text
		vbargraph.setYtitlefont(new Font("Arial",Font.BOLD,16)); // Y axis Title font
		vbargraph.setYtitlecolor(new Color(130,130,180));        // Y axis Title color
        vbargraph.setYtitleposition(new Point(2,130));           // Y axis Title position

		// Other
        vbargraph.setPopupcursor("Hand");  // Link / click cursor



        // Series Data (see APIdocs - Seriesobject)
		Seriesobject series_object = new Seriesobject();
    
    	series_object.setSeries1("#0A77A4,Product X,left");
    	series_object.setSeries2("#20B358,Product Y,left");
    	series_object.setSeries3("#F09004,Product Z,left");
    
    	vbargraph.setSeriesobj(series_object);                      

        // X Axis Labels (see APIdocs - Xlabelobject)
		Xlabelobject xaxislabels_object = new Xlabelobject();
        xaxislabels_object.setXlabels("January,February,March,April,May,June");
    	vbargraph.setXlabelobj(xaxislabels_object);


		// Add some Custom Text to the chart
		// see APIdocs - Textobject
		Textobject text_object = new Textobject();
		
		text_object.setText1("Note:|70,80|Arial,B,12|#0000FF");
		text_object.setText2("Product X launched in December 2004|70,95|Arial,N,12|#0088FF");
		vbargraph.setTextobj(text_object);





		return;
	}


//-----------------------------------------------------------------------------
    class ApplicationWindowAdapter extends WindowAdapter {
		public void windowClosing(WindowEvent we) {
			System.exit(0);
		}
	}
//-----------------------------------------------------------------------------
} // End application class
