package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Suppliers <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class SuppliersCached extends SuppliersBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public SuppliersCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected SuppliersCached(CS cs, int SupplierID) throws SQLException {
        super(cs, SupplierID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public SuppliersCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, getSupplierID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field SupplierID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithSupplierIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithSupplierIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public Iterator getIteratorWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getIteratorWithSupplierIDValueOf(cs, getSupplierID(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field SupplierID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithSupplierIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field ContactName
     * for equality with the same ContactName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfContactName(int maxResults)
        throws SQLException {
        return getLinkedListWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field ContactName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithContactNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field ContactName
     * for equality with the same ContactName as this instance.
     */
    public Iterator getIteratorWithSameValueOfContactName(int maxResults)
        throws SQLException {
        return getIteratorWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field ContactName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithContactNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field ContactTitle
     * for equality with the same ContactTitle as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfContactTitle(int maxResults)
        throws SQLException {
        return getLinkedListWithContactTitleValueOf(cs, getContactTitle(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field ContactTitle
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithContactTitleValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithContactTitleValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field ContactTitle
     * for equality with the same ContactTitle as this instance.
     */
    public Iterator getIteratorWithSameValueOfContactTitle(int maxResults)
        throws SQLException {
        return getIteratorWithContactTitleValueOf(cs, getContactTitle(),
            maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field ContactTitle
     * for equality with the "value".
     */
    public static Iterator getIteratorWithContactTitleValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithContactTitleValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Address
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Address
     * for equality with the same Address as this instance.
     */
    public Iterator getIteratorWithSameValueOfAddress(int maxResults)
        throws SQLException {
        return getIteratorWithAddressValueOf(cs, getAddress(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Address
     * for equality with the "value".
     */
    public static Iterator getIteratorWithAddressValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithAddressValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Region
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Region
     * for equality with the same Region as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegion(int maxResults)
        throws SQLException {
        return getIteratorWithRegionValueOf(cs, getRegion(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Region
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, getPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field PostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field PostalCode
     * for equality with the same PostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithPostalCodeValueOf(cs, getPostalCode(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field PostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Country
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Country
     * for equality with the same Country as this instance.
     */
    public Iterator getIteratorWithSameValueOfCountry(int maxResults)
        throws SQLException {
        return getIteratorWithCountryValueOf(cs, getCountry(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Country
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCountryValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCountryValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Phone
     * for equality with the same Phone as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getLinkedListWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Phone
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithPhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithPhoneValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Phone
     * for equality with the same Phone as this instance.
     */
    public Iterator getIteratorWithSameValueOfPhone(int maxResults)
        throws SQLException {
        return getIteratorWithPhoneValueOf(cs, getPhone(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Phone
     * for equality with the "value".
     */
    public static Iterator getIteratorWithPhoneValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithPhoneValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Fax
     * for equality with the same Fax as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfFax(int maxResults)
        throws SQLException {
        return getLinkedListWithFaxValueOf(cs, getFax(), maxResults);
    }

    /**
     * Gets a LinkedList of SuppliersCached's by querying table field Fax
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithFaxValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithFaxValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new SuppliersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Fax
     * for equality with the same Fax as this instance.
     */
    public Iterator getIteratorWithSameValueOfFax(int maxResults)
        throws SQLException {
        return getIteratorWithFaxValueOf(cs, getFax(), maxResults);
    }

    /**
     * Gets an Iterator of SuppliersCached's by querying table field Fax
     * for equality with the "value".
     */
    public static Iterator getIteratorWithFaxValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithFaxValueOf(cs, value, maxResults).iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return SuppliersCached.delete(cs, SupplierID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int SupplierID) throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                SuppliersCached.class,
                
            new Integer(SupplierID)
            });

        return SuppliersBase.delete(cs, SupplierID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { SuppliersCached.class, new Integer(SupplierID) };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached SuppliersCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { SuppliersCached.class });
    }

    /**
     * Flush a cached SuppliersCached item.
     */
    public static void flushCache(int SupplierID) {
        Cache.getCache().removeSynchronized(new Object[] {
                SuppliersCached.class,
                
            new Integer(SupplierID)
            });
    }

    private static SuppliersCached cacheLookup(int SupplierID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (SuppliersCached.class) {
            SuppliersCached t = (SuppliersCached) c.get(new Object[] {
                        SuppliersCached.class,
                        
                    new Integer(SupplierID)
                    });

            if (t != null) {
                return (SuppliersCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static SuppliersCached instance(CS cs, int SupplierID)
        throws SQLException, CloneNotSupportedException {
        SuppliersCached t = cacheLookup(SupplierID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new SuppliersCached(cs, SupplierID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth) {
        Element root = new Element("SuppliersCached");

        root.setAttribute("SupplierID", String.valueOf(getSupplierID()));

        root.addContent(new Element("CompanyName").setText(getCompanyName()));

        root.addContent(new Element("ContactName").setText(getContactName()));

        root.addContent(new Element("ContactTitle").setText(getContactTitle()));

        root.addContent(new Element("Address").setText(getAddress()));

        root.addContent(new Element("City").setText(getCity()));

        root.addContent(new Element("Region").setText(getRegion()));

        root.addContent(new Element("PostalCode").setText(getPostalCode()));

        root.addContent(new Element("Country").setText(getCountry()));

        root.addContent(new Element("Phone").setText(getPhone()));

        root.addContent(new Element("Fax").setText(getFax()));

        root.addContent(new Element("HomePage").setText(getHomePage()));

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
