package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Orders <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class OrdersCached extends OrdersBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public OrdersCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected OrdersCached(CS cs, int OrderID) throws SQLException {
        super(cs, OrderID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public OrdersCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Sets this row of Orders to reference the ref row of Customers
     */
    public void setCustomerIDRef(CustomersCached ref) {
        setCustomerID(new String(ref.getCustomerID()));
    }

    /**
     * Gets this row of Orders from referenced row of Customers
     */
    public CustomersCached getCustomerIDRef()
        throws SQLException, CloneNotSupportedException {
        return getCustomerIDRef(cs);
    }

    /**
     * Gets this row of Orders from referenced row of Customers
     */
    public CustomersCached getCustomerIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        if (getCustomerID() == null) {
            return null;
        }

        return CustomersCached.instance(cs, getCustomerID());
    }

    /**
     * Sets this row of Orders to reference the ref row of Employees
     */
    public void setEmployeeIDRef(EmployeesCached ref) {
        setEmployeeID(new Integer(ref.getEmployeeID()));
    }

    /**
     * Gets this row of Orders from referenced row of Employees
     */
    public EmployeesCached getEmployeeIDRef()
        throws SQLException, CloneNotSupportedException {
        return getEmployeeIDRef(cs);
    }

    /**
     * Gets this row of Orders from referenced row of Employees
     */
    public EmployeesCached getEmployeeIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        if (getEmployeeID() == null) {
            return null;
        }

        return EmployeesCached.instance(cs, getEmployeeID().intValue());
    }

    /**
     * Sets this row of Orders to reference the ref row of Shippers
     */
    public void setShipViaRef(ShippersCached ref) {
        setShipVia(new Integer(ref.getShipperID()));
    }

    /**
     * Gets this row of Orders from referenced row of Shippers
     */
    public ShippersCached getShipViaRef()
        throws SQLException, CloneNotSupportedException {
        return getShipViaRef(cs);
    }

    /**
     * Gets this row of Orders from referenced row of Shippers
     */
    public ShippersCached getShipViaRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        if (getShipVia() == null) {
            return null;
        }

        return ShippersCached.instance(cs, getShipVia().intValue());
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field OrderID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getIteratorWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field OrderID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field CustomerID
     * for equality with the same CustomerID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCustomerID(int maxResults)
        throws SQLException {
        return getLinkedListWithCustomerIDValueOf(cs, getCustomerID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field CustomerID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCustomerIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field CustomerID
     * for equality with the same CustomerID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCustomerID(int maxResults)
        throws SQLException {
        return getIteratorWithCustomerIDValueOf(cs, getCustomerID(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field CustomerID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCustomerIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCustomerIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, getEmployeeID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithEmployeeIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithEmployeeIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field EmployeeID
     * for equality with the same EmployeeID as this instance.
     */
    public Iterator getIteratorWithSameValueOfEmployeeID(int maxResults)
        throws SQLException {
        return getIteratorWithEmployeeIDValueOf(cs, getEmployeeID(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field EmployeeID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithEmployeeIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithEmployeeIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field OrderDate
     * for equality with the same OrderDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderDate(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderDateValueOf(cs, getOrderDate(), maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field OrderDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field OrderDate
     * for equality with the same OrderDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderDate(int maxResults)
        throws SQLException {
        return getIteratorWithOrderDateValueOf(cs, getOrderDate(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field OrderDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithOrderDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field RequiredDate
     * for equality with the same RequiredDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRequiredDate(int maxResults)
        throws SQLException {
        return getLinkedListWithRequiredDateValueOf(cs, getRequiredDate(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field RequiredDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRequiredDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRequiredDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field RequiredDate
     * for equality with the same RequiredDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfRequiredDate(int maxResults)
        throws SQLException {
        return getIteratorWithRequiredDateValueOf(cs, getRequiredDate(),
            maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field RequiredDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRequiredDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithRequiredDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShippedDate
     * for equality with the same ShippedDate as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShippedDate(int maxResults)
        throws SQLException {
        return getLinkedListWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShippedDate
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShippedDateValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShippedDate
     * for equality with the same ShippedDate as this instance.
     */
    public Iterator getIteratorWithSameValueOfShippedDate(int maxResults)
        throws SQLException {
        return getIteratorWithShippedDateValueOf(cs, getShippedDate(),
            maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShippedDate
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShippedDateValueOf(CS cs,
        java.sql.Date value, int maxResults) throws SQLException {
        return getLinkedListWithShippedDateValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipVia
     * for equality with the same ShipVia as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipVia(int maxResults)
        throws SQLException {
        return getLinkedListWithShipViaValueOf(cs, getShipVia(), maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipVia
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipViaValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipViaValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipVia
     * for equality with the same ShipVia as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipVia(int maxResults)
        throws SQLException {
        return getIteratorWithShipViaValueOf(cs, getShipVia(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipVia
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipViaValueOf(CS cs, Integer value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipViaValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field Freight
     * for equality with the same Freight as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfFreight(int maxResults)
        throws SQLException {
        return getLinkedListWithFreightValueOf(cs, getFreight(), maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field Freight
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithFreightValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithFreightValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field Freight
     * for equality with the same Freight as this instance.
     */
    public Iterator getIteratorWithSameValueOfFreight(int maxResults)
        throws SQLException {
        return getIteratorWithFreightValueOf(cs, getFreight(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field Freight
     * for equality with the "value".
     */
    public static Iterator getIteratorWithFreightValueOf(CS cs, Double value,
        int maxResults) throws SQLException {
        return getLinkedListWithFreightValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipName
     * for equality with the same ShipName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipName(int maxResults)
        throws SQLException {
        return getLinkedListWithShipNameValueOf(cs, getShipName(), maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipName
     * for equality with the same ShipName as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipName(int maxResults)
        throws SQLException {
        return getIteratorWithShipNameValueOf(cs, getShipName(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipNameValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipNameValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipAddress
     * for equality with the same ShipAddress as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipAddress(int maxResults)
        throws SQLException {
        return getLinkedListWithShipAddressValueOf(cs, getShipAddress(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipAddress
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipAddressValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipAddress
     * for equality with the same ShipAddress as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipAddress(int maxResults)
        throws SQLException {
        return getIteratorWithShipAddressValueOf(cs, getShipAddress(),
            maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipAddress
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipAddressValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipAddressValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipCity
     * for equality with the same ShipCity as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipCity(int maxResults)
        throws SQLException {
        return getLinkedListWithShipCityValueOf(cs, getShipCity(), maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipCity
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipCityValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipCity
     * for equality with the same ShipCity as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipCity(int maxResults)
        throws SQLException {
        return getIteratorWithShipCityValueOf(cs, getShipCity(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipCity
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithShipCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipRegion
     * for equality with the same ShipRegion as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipRegion(int maxResults)
        throws SQLException {
        return getLinkedListWithShipRegionValueOf(cs, getShipRegion(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipRegion
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipRegionValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipRegion
     * for equality with the same ShipRegion as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipRegion(int maxResults)
        throws SQLException {
        return getIteratorWithShipRegionValueOf(cs, getShipRegion(), maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipRegion
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipRegionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipRegionValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipPostalCode
     * for equality with the same ShipPostalCode as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipPostalCode(int maxResults)
        throws SQLException {
        return getLinkedListWithShipPostalCodeValueOf(cs, getShipPostalCode(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipPostalCode
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipPostalCodeValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipPostalCode
     * for equality with the same ShipPostalCode as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipPostalCode(int maxResults)
        throws SQLException {
        return getIteratorWithShipPostalCodeValueOf(cs, getShipPostalCode(),
            maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipPostalCode
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipPostalCodeValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipPostalCodeValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipCountry
     * for equality with the same ShipCountry as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfShipCountry(int maxResults)
        throws SQLException {
        return getLinkedListWithShipCountryValueOf(cs, getShipCountry(),
            maxResults);
    }

    /**
     * Gets a LinkedList of OrdersCached's by querying table field ShipCountry
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithShipCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithShipCountryValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new OrdersCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipCountry
     * for equality with the same ShipCountry as this instance.
     */
    public Iterator getIteratorWithSameValueOfShipCountry(int maxResults)
        throws SQLException {
        return getIteratorWithShipCountryValueOf(cs, getShipCountry(),
            maxResults);
    }

    /**
     * Gets an Iterator of OrdersCached's by querying table field ShipCountry
     * for equality with the "value".
     */
    public static Iterator getIteratorWithShipCountryValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithShipCountryValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return OrdersCached.delete(cs, OrderID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int OrderID) throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                OrdersCached.class,
                
            new Integer(OrderID)
            });

        return OrdersBase.delete(cs, OrderID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { OrdersCached.class, new Integer(OrderID) };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached OrdersCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { OrdersCached.class });
    }

    /**
     * Flush a cached OrdersCached item.
     */
    public static void flushCache(int OrderID) {
        Cache.getCache().removeSynchronized(new Object[] {
                OrdersCached.class,
                
            new Integer(OrderID)
            });
    }

    private static OrdersCached cacheLookup(int OrderID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (OrdersCached.class) {
            OrdersCached t = (OrdersCached) c.get(new Object[] {
                        OrdersCached.class,
                        
                    new Integer(OrderID)
                    });

            if (t != null) {
                return (OrdersCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static OrdersCached instance(CS cs, int OrderID)
        throws SQLException, CloneNotSupportedException {
        OrdersCached t = cacheLookup(OrderID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new OrdersCached(cs, OrderID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth)
        throws SQLException, CloneNotSupportedException {
        Element root = new Element("OrdersCached");

        root.setAttribute("OrderID", String.valueOf(getOrderID()));

        root.addContent(new Element("CustomerID").setText(getCustomerID()));

        root.setAttribute("EmployeeID", String.valueOf(getEmployeeID()));

        root.setAttribute("OrderDate", String.valueOf(getOrderDate()));

        root.setAttribute("RequiredDate", String.valueOf(getRequiredDate()));

        root.setAttribute("ShippedDate", String.valueOf(getShippedDate()));

        root.setAttribute("ShipVia", String.valueOf(getShipVia()));

        root.setAttribute("Freight", String.valueOf(getFreight()));

        root.addContent(new Element("ShipName").setText(getShipName()));

        root.addContent(new Element("ShipAddress").setText(getShipAddress()));

        root.addContent(new Element("ShipCity").setText(getShipCity()));

        root.addContent(new Element("ShipRegion").setText(getShipRegion()));

        root.addContent(new Element("ShipPostalCode").setText(
                getShipPostalCode()));

        root.addContent(new Element("ShipCountry").setText(getShipCountry()));

        if (depth > 0) {
            CustomersCached temp1 = getCustomerIDRef(cs);

            if (temp1 != null) {
                root.addContent(temp1.toXML(depth - 1));
            }

            EmployeesCached temp2 = getEmployeeIDRef(cs);

            if (temp2 != null) {
                root.addContent(temp2.toXML(depth - 1));
            }

            ShippersCached temp3 = getShipViaRef(cs);

            if (temp3 != null) {
                root.addContent(temp3.toXML(depth - 1));
            }
        }

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() throws SQLException, CloneNotSupportedException {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
