<%@ LANGUAGE=JScript %>
<%
	var bits=128;
%>
<html>
<head>
<title>Miraplacid MSCCryptoTwofish encryption sample</title>
</head>
<body >
<h3>MSCCryptoTwofish encryption sample</h3>
<h5>Encrypt and decrypt string using Twofish (<%=bits%> bits key)</h5>
<h4>To use this example, you have to install MSCBlob too.</h4>
Source string<br>
<%
	var str="The quick brown fox jumps over the lazy dog";
%>
<b><i><%=str%></i></b><br>
<h5>Creating Twofish component and generating key</h5>
<%
	Response.Flush();
	var tf1=Server.CreateObject("Miraplacid.MSCCryptoTwofish");
	var user=Server.CreateObject("Miraplacid.MSCBlob");
	tf1.Filler=0x31; // to prove that blob-to-blob technique works
	user.Str="John Smith";
	tf1.KeyGen(user,bits/8);
	var key=tf1.Key;
%>
<b>Key:</b><br>
<%=key.Hex%><br>
<h5>Encrypting and exporting keys to another MSCCryptoTwofish object</h5>
<%
	Response.Flush();
	var blob=Server.CreateObject("Miraplacid.MSCBlob");
	blob.Str=str;
	var blob1=Server.CreateObject("Miraplacid.MSCBlob");
	var misc=Server.CreateObject("Miraplacid.MSCCryptoMisc");
	misc.InsertBlobToBlob(blob1,0,blob);
	var crypted=tf1.Encrypt(blob1);

	var tf2=Server.CreateObject("Miraplacid.MSCCryptoTwofish");
	tf2.Key=key;
%>
<b>Encrypted text:</b><br>
<%=crypted.Hex%><br>
<h5>Decrypting</h5>
<%
	Response.Flush();
	var decrypted=tf2.Decrypt(crypted);
	var decrypted1=misc.ExtractBlobFromBlob(decrypted,0);
%>
<b>Decrypted text:</b><br>
<b><i><%=decrypted1.Str%></i></b><br>
<br><b>Done.</b><br>

</body>
</html>
