<%@ LANGUAGE=JScript %>
<%
	var bits=1024;
%>
<html>
<head>
<title>Miraplacid MSCCryptoRSA sign/verify sample</title>
</head>
<body >
<h3>MSCCryptoRSA sign/verify sample</h3>
<h5>Sign and verify string using RSA (<%=bits%> bits key)</h5>
<h4>To use this example, you have to install MSCBlob too.</h4>
Source string<br>
<%
	var str="The quick brown fox jumps over the lazy dog";
%>
<b><i><%=str%></i></b><br>
<h5>Creating RSA component and generating keyring</h5>
<%
	Response.Flush();
	var rsa1=Server.CreateObject("Miraplacid.MSCCryptoRSA");
	var user=Server.CreateObject("Miraplacid.MSCBlob");
	var pass=Server.CreateObject("Miraplacid.MSCBlob");
	user.Str="John";
	pass.Str="Smith";
	rsa1.KeyGen(user,pass,bits/8);
	var pubkey=rsa1.PublicKey;
	var prikey=rsa1.PrivateKey;
%>
<b>Public key:</b><br>
<%=pubkey.Hex%><br>
<b>Private key:</b><br>
<%=prikey.Hex%><br>
<h5>Encrypting and exporting keys to another MSCCryptoRSA object</h5>
<%
	Response.Flush();
	var blob=Server.CreateObject("Miraplacid.MSCBlob");
	blob.Str=str;
	var crypted=rsa1.Sign(blob);

	var rsa2=Server.CreateObject("Miraplacid.MSCCryptoRSA");
	rsa2.PublicKey=pubkey;
	rsa2.PrivateKey=prikey;
%>
<b>Signature:</b><br>
<%=crypted.Hex%><br>
<h5>Verifying</h5>
<%
	Response.Flush();
	var decrypted=rsa2.Verify(blob,crypted);
%>
<b>Verified (1 - Yes, 0 - No): <%=decrypted%></b><br>
<br><b>Done.</b><br>

</body>
</html>
