/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.sqlFreeEnter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javak.bo.BOAssert;
import javak.bo.BOFactory;
import javak.bo.ConfigData;
import javak.bo.DBInfoSpecific;
import javak.bo.ModelTable;
import javak.bo.sqlBuilder.BOSqlBuilderMain;
import javak.bo.sqlFreeEnter.sqlFreeEnterDBInfos;
import javak.common.CommonDBInfos;
import javak.common.DBCommon;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BOConstants;
import javak.iface.bo.I_BODBInfos;
import javak.iface.bo.I_BOError;
import javak.iface.bo.I_BOResultFetcher;
import javak.iface.bo.I_BOResultViewer;
import javak.iface.bo.I_BOSetText;
import javak.iface.bo.I_DataLoader;
import javak.iface.bo.I_SQLRenderer;
import javak.iface.bo.I_TableData;
import javak.iface.bo.I_dbInfoListener;
import javak.iface.bo.I_sqlFree;
import javak.iface.zs.I_DBZS;
import javak.iface.zs.I_DBZSInfo;
import javak.zs.DBjavakFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.w3c.dom.Document;

public class sqlFreeEnterMain
extends JPanel
implements I_sqlFree,
I_BOResultFetcher,
I_BOSetText,
I_BOError,
I_dbInfoListener {
    private final String BUT_SENDSQL = "Send Statement";
    private final String BUT_CLEAR = "Clear field";
    private final String BUT_REMEMBER = "Add to history";
    private final String BUT_LOADPREPSTATEMENTS = "Load statements";
    private final String BUT_BUILDQUERY = "Visual builder";
    private final String BUT_SHOWTABLES = "Show tables";
    private final String BUT_SHOWSTOREDPROCS = "Show stored procedures";
    private final String BUT_GETNEWVISUALBUILDER = "Create empty visual SQL-Builder";
    private final String BUT_GETSQLVISUALBUILDER = "Create visual SQL-Builder from statement";
    private final String BUT_MENUEDIT = "Edit";
    private final String BUT_ITEMCUT = "Cut";
    private final String BUT_ITEMCOPY = "Copy";
    private final String BUT_ITEMPASTE = "Paste";
    private final String TXT_STATEMENTHISTORY = "Statementhistory: ";
    private final String TXT_INFORMATION = "Information";
    private final String TXT_ABOUT = "About sqlFree";
    private final String END_STRING = "  ";
    private final String RESULTS_MORE = "There are more results!";
    private final String RESULTS_NOMORE = "There are no more results!";
    private JTextArea tfSqlArea = null;
    private JFrame dbInfoWindow = null;
    private JMenuBar menuBar = null;
    private I_DataLoader mainLoader = null;
    private JComboBox historyCombo = null;
    private Vector historyStrings = null;
    private I_BODBInfos dbinfos = null;
    DBInfoSpecific[] dbspec = new DBInfoSpecific[]{new DBInfoSpecific("Default", "Default", "\"", "\""), new DBInfoSpecific("Access and others", "Access", "[", "]"), new DBInfoSpecific("MySQL", "mySQL", "`", "`")};

    private sqlFreeEnterMain getSelfReference() {
        return this;
    }

    public sqlFreeEnterMain(String string, I_DataLoader i_DataLoader) {
        super(new BorderLayout());
        JButton jButton = null;
        this.mainLoader = i_DataLoader;
        this.tfSqlArea = new JTextArea();
        Font font = new Font("monospaced", 0, 12);
        this.tfSqlArea.setFont(font);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                try {
                    if (string.equals("Send Statement")) {
                        sqlFreeEnterMain.this.sendStatement(sqlFreeEnterMain.this.tfSqlArea.getText().trim());
                    } else if (string.equals("Add to history")) {
                        sqlFreeEnterMain.this.addToHistory(sqlFreeEnterMain.this.tfSqlArea.getText().trim());
                    }
                }
                catch (BOjavakException bOjavakException) {
                    JOptionPane.showMessageDialog(sqlFreeEnterMain.this.getSelfReference(), bOjavakException.toString(), "Error", 0);
                }
            }
        };
        this.menuBar = new JMenuBar();
        JMenu jMenu = null;
        jMenu = new JMenu("Options");
        this.menuBar.add(jMenu);
        jMenu.add("Databaseconfiguration").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    sqlFreeEnterMain.this.showDatabaseInfo();
                }
                catch (BOjavakException bOjavakException) {
                    JOptionPane.showMessageDialog(sqlFreeEnterMain.this.getSelfReference(), bOjavakException.toString(), "Error", 0);
                }
            }
        });
        jMenu.addSeparator();
        jMenu.add("Load statements").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    sqlFreeEnterMain.this.loadPreparedQueries();
                }
                catch (BOjavakException bOjavakException) {
                    JOptionPane.showMessageDialog(sqlFreeEnterMain.this.getSelfReference(), bOjavakException.toString(), "Error", 0);
                }
            }
        });
        jMenu.addSeparator();
        jMenu.add("Clear field").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sqlFreeEnterMain.this.tfSqlArea.setText("");
            }
        });
        jMenu = new JMenu("Edit");
        this.menuBar.add(jMenu);
        jMenu.add("Cut").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sqlFreeEnterMain.this.tfSqlArea.cut();
            }
        });
        jMenu.add("Copy").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sqlFreeEnterMain.this.tfSqlArea.copy();
            }
        });
        jMenu.add("Paste").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sqlFreeEnterMain.this.tfSqlArea.paste();
            }
        });
        jMenu = new JMenu("Visual builder");
        this.menuBar.add(jMenu);
        jMenu.add("Create empty visual SQL-Builder").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sqlFreeEnterMain.this.showVisualBuilder("Create empty visual SQL-Builder");
            }
        });
        jMenu.add("Create visual SQL-Builder from statement").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                sqlFreeEnterMain.this.showVisualBuilder("Create visual SQL-Builder from statement");
            }
        });
        jMenu = new JMenu("Information");
        this.menuBar.add(jMenu);
        jMenu.add("Show tables").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    sqlFreeEnterMain.this.showDBTables();
                }
                catch (BOjavakException bOjavakException) {
                    JOptionPane.showMessageDialog(sqlFreeEnterMain.this.getSelfReference(), bOjavakException.toString(), "Error", 0);
                }
            }
        });
        jMenu.addSeparator();
        jMenu.add("About sqlFree").addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    sqlFreeEnterMain.this.showAboutInfo();
                }
                catch (BOjavakException bOjavakException) {
                    JOptionPane.showMessageDialog(sqlFreeEnterMain.this.getSelfReference(), bOjavakException.toString(), "Error", 0);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.historyStrings = new Vector(5, 5);
        this.historyCombo = new JComboBox();
        this.historyCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = sqlFreeEnterMain.this.historyCombo.getSelectedIndex();
                if (n > -1) {
                    String string = (String)sqlFreeEnterMain.this.historyStrings.elementAt(n);
                    sqlFreeEnterMain.this.tfSqlArea.setText(string);
                }
            }
        });
        jPanel.add((Component)new JLabel("Statementhistory: "), "West");
        jPanel.add((Component)this.historyCombo, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jButton = new JButton("Send Statement");
        jButton.addActionListener(actionListener);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.addSeparator();
        jButton = new JButton("Add to history");
        jButton.addActionListener(actionListener);
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jPanel);
        this.add((Component)jToolBar, "North");
        this.add((Component)new JScrollPane(this.tfSqlArea), "Center");
        this.createDBInfoInstance(string);
    }

    private JPanel createDBInfoInstance(String string) {
        this.dbinfos = BOFactory.createDBInfos();
        this.dbinfos.addListener(this);
        try {
            this.dbinfos.setHostRMIRegistry(string);
            this.getSavedODBCInfos();
        }
        catch (BOjavakException bOjavakException) {
            JOptionPane.showMessageDialog(this.getSelfReference(), bOjavakException.toString(), "Error", 0);
        }
        this.showSharewareWindow(new sqlFreeEnterDBInfos(string, this.dbspec).isRegisteredVersion());
        return this.dbinfos.getPanel();
    }

    public JFrame createWindow(JPanel jPanel, String string) {
        JFrame jFrame = new JFrame(string);
        jFrame.getContentPane().add(jPanel);
        return jFrame;
    }

    public JPanel getPanel() {
        if (this.getRootPane() != null) {
            this.getRootPane().setJMenuBar(this.menuBar);
            this.getRootPane().revalidate();
        }
        return this;
    }

    public void sendStatement(String string) throws BOjavakException {
        Vector vector = null;
        String string2 = "";
        String string3 = "";
        if (string.trim().equals("")) {
            JOptionPane.showMessageDialog(this.getSelfReference(), "Nothing to do!", "Information", 1);
            return;
        }
        CommonDBInfos commonDBInfos = null;
        string3 = this.replacePlaceholdersSQL(string);
        try {
            int n = this.dbinfos.getNrDatasetsReadAtOnce();
            if (n < 1) {
                n = -1;
            }
            commonDBInfos = DBCommon.sendSQLString(this.dbinfos.getLogin(), this.dbinfos.getPassword(), this.dbinfos.getDBName(), this.dbinfos.getHostRMIRegistry(), this.dbinfos.getJDBCProtocol(), this.dbinfos.getDriverClass(), string3, n);
            vector = commonDBInfos.getInfos();
        }
        catch (Exception exception) {
            BOjavakException bOjavakException = new BOjavakException(exception, "Error at sending SQL-Statement");
            throw bOjavakException;
        }
        I_BOResultViewer i_BOResultViewer = BOFactory.createResultViewer(this, commonDBInfos);
        try {
            if (commonDBInfos.getResultSet() != null) {
                i_BOResultViewer.setResultColumnNames(commonDBInfos.getResultSet().getColumnNames());
            }
            i_BOResultViewer.setResults(vector);
            if (commonDBInfos.hasMoreResults()) {
                i_BOResultViewer.setStatus("There are more results!");
            } else {
                i_BOResultViewer.setStatus("There are no more results!");
                i_BOResultViewer.disableNextResultButtons();
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getSelfReference(), exception.toString(), "Error", 0);
        }
        JFrame jFrame = new JFrame("Resultviewer");
        jFrame.getContentPane().add(i_BOResultViewer.getPanel());
        jFrame.pack();
        ((Component)jFrame).setSize(650, 500);
        ((Component)jFrame).setVisible(true);
        i_BOResultViewer.setQuery(string3);
        if (commonDBInfos.getMoreInfo() != null) {
            i_BOResultViewer.setStatus(commonDBInfos.getMoreInfo());
        }
    }

    private String replacePlaceholdersSQL(String string) throws BOjavakException {
        Vector vector = this.getPlaceholders(string);
        if (vector.size() == 0) {
            return string;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = new String(string2);
            string3 = string3.replace('#', ' ');
            string = this.replacePlaceholder(string, this.getInputFromDialog("Input for:" + string3), string2);
        }
        return string;
    }

    private Vector getPlaceholders(String string) throws BOjavakException {
        Vector<String> vector = new Vector<String>(3, 3);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            char c = string.charAt(n2);
            if (c == '\'') {
                n3 = string.indexOf(39, n2 + 1);
                if (n3 == -1) {
                    throw new BOjavakException("Closing quotation mark is missing in:\n" + string);
                }
                n2 = n3;
            } else if (c == '#' && n2 + 1 < n && string.charAt(n2 + 1) == '#') {
                n3 = string.indexOf(I_BOConstants.BOSQL_PLACEHOLDERPATTERN, n2 + 2);
                if (n3 == -1) {
                    throw new BOjavakException("Closing metasymbol is missing in:\n" + string);
                }
                String string2 = string.substring(n2, n3 += 2);
                vector.addElement(string2);
                n2 = n3 - 1;
            }
            ++n2;
        }
        return vector;
    }

    private String replacePlaceholder(String string, String string2, String string3) throws BOjavakException {
        if (string2.equals("  ")) {
            return string;
        }
        int n = string.indexOf(string3);
        if (n < 0) {
            throw new BOjavakException("Couldn't replace '" + string3 + "' with '" + string2 + "'");
        }
        string = string.substring(0, n) + string2 + string.substring(n + string3.length());
        return string;
    }

    private String getInputFromDialog(String string) {
        String string2 = JOptionPane.showInputDialog(string);
        return string2.trim();
    }

    private void getSavedODBCInfos() throws BOjavakException {
        try {
            I_DBZS i_DBZS = new DBjavakFactory(this.dbinfos.getHostRMIRegistry()).i_dbzs();
            I_DBZSInfo i_DBZSInfo = i_DBZS.getDBZSInfo();
            Document document = i_DBZSInfo.readConfig();
            if (document != null) {
                this.dbinfos.setConfigData(new ConfigData(document));
            }
        }
        catch (Exception exception) {
            System.err.println("Could not read all saved configuration infos! Proceeding.");
        }
    }

    public void boSetText(String string) throws BOjavakException {
        this.tfSqlArea.setText(string);
    }

    public void boSetText(I_SQLRenderer i_SQLRenderer) throws BOjavakException {
        this.boSetText(i_SQLRenderer.getStatementFormatted());
    }

    public void boSetText(I_TableData i_TableData) throws BOjavakException {
    }

    public void setErrorMessage(String string) {
        this.tfSqlArea.setText(string);
    }

    public void addToHistory(String string) {
        this.historyStrings.addElement(string);
        String string2 = string.substring(0, string.length() < 60 ? string.length() : 60);
        string2 = string2.replace('\t', ' ');
        string2 = string2.replace('\n', ' ');
        this.historyCombo.addItem(string2);
    }

    public void showVisualBuilder(String string) {
        try {
            sqlFreeEnterDBInfos sqlFreeEnterDBInfos2 = new sqlFreeEnterDBInfos(this.dbinfos.getHostRMIRegistry(), this.dbspec);
            boolean bl = sqlFreeEnterDBInfos2.isRegisteredVersion();
            Hashtable hashtable = sqlFreeEnterDBInfos2.getTablesAndColumns(this.dbinfos.getDBName(), this.dbinfos.getLogin(), this.dbinfos.getPassword(), this.dbinfos.getJDBCProtocol(), this.dbinfos.getDriverClass());
            BOSqlBuilderMain bOSqlBuilderMain = BOFactory.createSqlVisualBuilder(this, this, hashtable, this.dbspec);
            bOSqlBuilderMain.setRegistered(bl);
            ImageIcon imageIcon = this.mainLoader.loadIcon("javak/bo/gifs/add.gif");
            if (imageIcon != null) {
                bOSqlBuilderMain.setToolbarIcon_AddTable(imageIcon);
            }
            if ((imageIcon = this.mainLoader.loadIcon("javak/bo/gifs/trash.gif")) != null) {
                bOSqlBuilderMain.setToolbarIcon_ClearView(imageIcon);
            }
            if ((imageIcon = this.mainLoader.loadIcon("javak/bo/gifs/build.gif")) != null) {
                bOSqlBuilderMain.setToolbarIcon_BuildStatement(imageIcon);
            }
            JFrame jFrame = this.createWindow(bOSqlBuilderMain.getPanel(), "Querybuilder");
            jFrame.pack();
            ((Component)jFrame).setSize(720, 500);
            ((Component)jFrame).setVisible(true);
            bOSqlBuilderMain.initView();
            if (string.equals("Create visual SQL-Builder from statement")) {
                bOSqlBuilderMain.showSQLStatement(this.tfSqlArea.getText());
            }
        }
        catch (BOjavakException bOjavakException) {
            JOptionPane.showMessageDialog(this.getSelfReference(), bOjavakException.toString(), "Error", 0);
        }
    }

    public String[][] getNextResults(Object object, I_BOResultViewer i_BOResultViewer) throws BOjavakException {
        CommonDBInfos commonDBInfos = (CommonDBInfos)object;
        int n = this.dbinfos.getNrDatasetsReadAtOnce();
        if (n < 1) {
            n = -1;
        }
        return this.readIntervalResults(n, (CommonDBInfos)object, i_BOResultViewer);
    }

    public String[][] getAllResults(Object object, I_BOResultViewer i_BOResultViewer) throws BOjavakException {
        return this.readIntervalResults(-1, (CommonDBInfos)object, i_BOResultViewer);
    }

    private String[][] readIntervalResults(int n, CommonDBInfos commonDBInfos, I_BOResultViewer i_BOResultViewer) throws BOjavakException {
        BOAssert.assert(commonDBInfos != null, "No actual CommonDBInfo (null)");
        BOAssert.assert(n >= -1, "Wrong number of datasets to read (<=-1)");
        if (!commonDBInfos.hasMoreResults()) {
            commonDBInfos.setMoreInfo("There are no more results!");
            if (i_BOResultViewer != null) {
                i_BOResultViewer.setStatus(commonDBInfos.getMoreInfo());
            }
            return null;
        }
        String[][] stringArray = null;
        try {
            int n2 = commonDBInfos.getReadDatasets();
            DBCommon.readInterval(commonDBInfos, n);
            int n3 = commonDBInfos.getReadDatasets();
            if (n3 == n2) {
                return null;
            }
            stringArray = this.convertToArray(commonDBInfos.getInfos(), n2);
        }
        catch (Exception exception) {
            throw new BOjavakException(exception, "Error at reading more results");
        }
        if (i_BOResultViewer != null) {
            if (commonDBInfos.hasMoreResults()) {
                i_BOResultViewer.setStatus("There are more results!");
            } else {
                i_BOResultViewer.setStatus("There are no more results!");
                i_BOResultViewer.disableNextResultButtons();
            }
        }
        return stringArray;
    }

    private String[][] convertToArray(Vector vector, int n) {
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        int n3 = ((Hashtable)vector.firstElement()).size();
        int n4 = 0;
        String[][] stringArray = new String[n2 - n][n3];
        ListIterator listIterator = vector.subList(n, n2).listIterator();
        while (listIterator.hasNext()) {
            Hashtable hashtable = (Hashtable)listIterator.next();
            int n5 = 1;
            while (n5 <= n3) {
                String string;
                stringArray[n4][n5 - 1] = string = (String)hashtable.get("" + n5);
                ++n5;
            }
            ++n4;
        }
        return stringArray;
    }

    public void loadPreparedQueries() throws BOjavakException {
        try {
            I_DBZS i_DBZS = new DBjavakFactory(this.dbinfos.getHostRMIRegistry()).i_dbzs();
            I_DBZSInfo i_DBZSInfo = i_DBZS.getDBZSInfo();
            String string = i_DBZSInfo.readFixedQueries();
            if (string == null) {
                this.boSetText("There seem to be no prepared queries.");
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
            String string2 = null;
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                if (string2.startsWith("[")) {
                    if (string3 != null) {
                        this.addToHistory(string3.trim());
                    }
                    string3 = "--" + string2.substring(1, string2.length() - 1) + "\n";
                    continue;
                }
                string3 = string3 + string2 + "\n";
            }
            if (string3 != null) {
                this.addToHistory(string3.trim());
            }
        }
        catch (Exception exception) {
            String string = this.dbinfos.getHostRMIRegistry();
            if (string.trim().equals("")) {
                string = "local";
            }
            throw new BOjavakException(exception, "Problem at reading prepared queries of " + string);
        }
    }

    public void showDBTables() throws BOjavakException {
        String string = "";
        sqlFreeEnterDBInfos sqlFreeEnterDBInfos2 = new sqlFreeEnterDBInfos(this.dbinfos.getHostRMIRegistry(), this.dbspec);
        Hashtable hashtable = sqlFreeEnterDBInfos2.getTablesAndColumns(this.dbinfos.getDBName(), this.dbinfos.getLogin(), this.dbinfos.getPassword(), this.dbinfos.getJDBCProtocol(), this.dbinfos.getDriverClass());
        String string2 = "";
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ModelTable modelTable = (ModelTable)enumeration.nextElement();
            string2 = string2 + modelTable.toString() + "\n";
        }
        this.boSetText(string2);
    }

    public void showAboutInfo() throws BOjavakException {
        String string = null;
        string = "sqlFree v3.0\n\nInformation and updates available at\nhttp://www.independencesoft.com";
        this.boSetText(string);
    }

    public void showDBStoredProcs() throws BOjavakException {
        String string = "";
        sqlFreeEnterDBInfos sqlFreeEnterDBInfos2 = new sqlFreeEnterDBInfos(this.dbinfos.getHostRMIRegistry(), this.dbspec);
        Hashtable hashtable = sqlFreeEnterDBInfos2.getProceduresAndColumns(this.dbinfos.getDBName(), this.dbinfos.getLogin(), this.dbinfos.getPassword(), this.dbinfos.getJDBCProtocol(), this.dbinfos.getDriverClass());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            string = string + "Procedurename: " + string2 + "\n";
            Enumeration enumeration2 = hashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                string = string + "    Parameter: " + string3 + "   - Type: " + (String)hashtable2.get(string3) + "\n";
            }
            string = string + "*********\n";
        }
        this.boSetText(string);
    }

    public void showDatabaseInfo() throws BOjavakException {
        if (this.dbInfoWindow == null) {
            this.dbInfoWindow = this.createWindow(this.dbinfos.getPanel(), "Databaseinformation");
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)sqlFreeEnterMain.this.dbInfoWindow).setVisible(false);
                }
            });
            ((JPanel)this.dbInfoWindow.getContentPane().getComponent(0)).add(new JLabel(""));
            ((JPanel)this.dbInfoWindow.getContentPane().getComponent(0)).add(jButton);
            ((Component)this.dbInfoWindow).setLocation(100, 100);
        }
        this.dbInfoWindow.pack();
        ((Component)this.dbInfoWindow).setVisible(true);
    }

    private void showSharewareWindow(boolean bl) {
        if (bl) {
            return;
        }
        String string = "This is a non-registered version of sqlFree!\nThe only restriction in using this tool is that\nmaximally three tables are shown in the visual-sql-builder.\n\nIf you keep using this tool please register and purchase at\nhttp://www.independencesoft.com";
        JOptionPane.showMessageDialog(this, string, "Shareware information", 1);
    }

    public void rmiAddressChanged() {
        try {
            this.getSavedODBCInfos();
        }
        catch (BOjavakException bOjavakException) {
            JOptionPane.showMessageDialog(this.getSelfReference(), bOjavakException.toString(), "Error", 0);
        }
    }
}

