/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.operations;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;

public class Variable
extends Expression {
    private boolean m_fixUpWasCalled = false;
    protected QName m_qname;
    protected int m_index;
    protected boolean m_isGlobal = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XObject execute(XPathContext xctxt) throws TransformerException {
        if (this.m_fixUpWasCalled) {
            XObject result = this.m_isGlobal ? xctxt.getVarStack().getGlobalVariable(xctxt, this.m_index) : xctxt.getVarStack().getLocalVariable(xctxt, this.m_index);
            if (result != null) return result;
            this.warn(xctxt, 11, new Object[]{this.m_qname.getLocalPart()});
            return new XNodeSet(xctxt.getDTMManager());
        }
        Variable variable = this;
        synchronized (variable) {
            ElemVariable vvar;
            PrefixResolver prefixResolver = xctxt.getNamespaceContext();
            if (!(prefixResolver instanceof ElemTemplateElement)) throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{this.m_qname.toString()}));
            ElemTemplateElement prev = (ElemTemplateElement)prefixResolver;
            if (!(prev instanceof Stylesheet)) {
                while (!(prev.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement savedprev = prev;
                    while ((prev = prev.getPreviousSiblingElem()) != null) {
                        if (!(prev instanceof ElemVariable) || !(vvar = (ElemVariable)prev).getName().equals(this.m_qname)) continue;
                        this.m_index = vvar.getIndex();
                        this.m_isGlobal = false;
                        this.m_fixUpWasCalled = true;
                        return this.execute(xctxt);
                    }
                    prev = savedprev.getParentElem();
                }
            }
            if ((vvar = prev.getStylesheetRoot().getVariableOrParamComposed(this.m_qname)) == null) throw new TransformerException(XSLMessages.createXPATHMessage(74, new Object[]{this.m_qname.toString()}));
            this.m_index = vvar.getIndex();
            this.m_isGlobal = true;
            this.m_fixUpWasCalled = true;
            return this.execute(xctxt);
        }
    }

    public void fixupVariables(Vector vars, int globalsSize) {
        this.m_fixUpWasCalled = true;
        int sz = vars.size();
        int i = vars.size() - 1;
        while (i >= 0) {
            QName qn = (QName)vars.elementAt(i);
            if (qn.equals(this.m_qname)) {
                if (i < globalsSize) {
                    this.m_isGlobal = true;
                    this.m_index = i;
                } else {
                    this.m_index = i - globalsSize;
                }
                return;
            }
            --i;
        }
        String msg = XSLMessages.createXPATHMessage(81, new Object[]{this.m_qname.toString()});
        TransformerException te = new TransformerException(msg, this.m_slocator);
        throw new WrappedRuntimeException(te);
    }

    public boolean isStableNumber() {
        return true;
    }

    public void setQName(QName qname) {
        this.m_qname = qname;
    }
}

