/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.compiler.Compiler;

public class ChildIterator
extends LocPathIterator {
    ChildIterator(Compiler compiler, int opPos, int analysis) throws TransformerException {
        super(compiler, opPos, analysis, false);
    }

    public int asNode(XPathContext xctxt) throws TransformerException {
        int current = xctxt.getCurrentNode();
        DTM dtm = xctxt.getDTM(current);
        return dtm.getFirstChild(current);
    }

    public int getAxis() {
        return 3;
    }

    public int nextNode() {
        if (this.m_cachedNodes != null && this.m_next < this.m_cachedNodes.size()) {
            int next = this.m_cachedNodes.elementAt(this.m_next);
            this.incrementNextPosition();
            this.m_currentContextNode = next;
            return next;
        }
        if (this.m_foundLast) {
            this.m_lastFetched = -1;
            return -1;
        }
        int next = this.m_lastFetched == -1 ? this.m_cdtm.getFirstChild(this.m_context) : this.m_cdtm.getNextSibling(this.m_lastFetched);
        this.m_lastFetched = next;
        if (next != -1) {
            if (this.m_cachedNodes != null) {
                this.m_cachedNodes.addElement(this.m_lastFetched);
            }
            ++this.m_next;
            return next;
        }
        this.m_foundLast = true;
        return -1;
    }
}

