#include <windows.h>
#include <string.h>

#include "winio.h"
#include "global.h"

/* The Rule:
	Leave backcolor as white (or the user's chosen background color)
	Text attributes are set as per lcurid. (Somewhat inefficient, but hell.)
*/

static HFONT lcurid;		// current font id
static ULONG forecolor = 0;
static ULONG backcolor = RGB(255, 255, 255);
static ULONG curcolor = 0L;
static HPEN	curpen = 0;
BOOL fCursorBlink = FALSE;		// True if the cursor is visible in blinking
static BOOL fDotLocked = FALSE;		// Semaphore: can we access cursor?

VOID mySetRect(PRECT prect, LONG xL, LONG yT, LONG xR, LONG yB)
{
	prect->left = xL;
	prect->top = yT;
	prect->right = xR;
	prect->bottom = yB;
}

VOID mySetPoint(PPOINT ppoint, LONG x0, LONG y0)
{
	ppoint->x = x0;
	ppoint->y = y0;
}

VOID myDrawBox(HDC hdc, LONG left, LONG top, LONG right,
	LONG bottom, LONG lCol, BOOL bFill)
{
	HPEN	hpen, hpenOld;
	HBRUSH	hbrush, hbrushOld;

	hpen = CreatePen(PS_SOLID, 0, lCol);
	if (bFill)
		hbrush = CreateSolidBrush(lCol);
	else hbrush = CreateSolidBrush(backcolor);

	hpenOld = SelectObject(hdc, hpen);
	hbrushOld = SelectObject(hdc, hbrush);
	Rectangle(hdc, left, top, right, bottom);
	SelectObject(hdc, hbrushOld);
	SelectObject(hdc, hpenOld);

	DeleteObject(hbrush);
	DeleteObject(hpen);
}

void XKnowIgnorance()
{
	lcurid = 0L;
	curcolor = 0L;
}

// Sets the font in a graphics context
void XSetFont(HDC hdc, HFONT font)
{
	lcurid = font;
	SelectObject(hdc, lcurid);
}

void XSetUpHDC(HDC hdc)
{
	SetTextAlign(hdc, TA_BASELINE);
	SelectObject(hdc, lcurid);
}

static void XSetColor(HDC hdc, ULONG newcol)
{
	HPEN	hpTemp;
	
	curcolor = newcol;
	hpTemp = CreatePen(PS_SOLID, 0, newcol);
	SelectObject(hdc, hpTemp);
	if (curpen)
		DeleteObject(curpen);
	curpen = hpTemp;
}

void XSetForeColor(ULONG newcol)
{
	forecolor = newcol;
}

void XSetBackColor(ULONG newcol)
{
	backcolor = newcol;
}

// Clears a window
void XClearWindow(HDC hdc)
{
	BOOL	f = FALSE;

	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
	}
	myDrawBox(hdc, clientRect.left, clientRect.top, clientRect.right,
		clientRect.bottom, backcolor, TRUE);
	if (f)
		XShowDot(hdc, TRUE);
}

// Prevent updating the already-invalid portions of the window
void XClipToValid(HWND win, HDC hdc)
{
	ExcludeUpdateRgn(hdc, win);
}

// Clear a square in a window
void XClearArea(HDC hdc, LONG xpos, LONG ypos, LONG wid, LONG hgt)
{
	BOOL	f = FALSE;
	
	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
	}
	myDrawBox(hdc, xpos, ypos, xpos+wid, ypos+hgt, backcolor, TRUE);
	if (f)
		XShowDot(hdc, TRUE);
}

void XDrawReverseString(HDC hdc, HFONT font, short xpos, short ypos, 
	short fieldwid, unsigned char *buf, long len)
{
	BOOL	f = FALSE;
	int linhgt, linhgtoff;
	
	if (lcurid != font) 
		XSetFont(hdc, font);

	linhgt = lineheight_story;
	linhgtoff = lineheightoff_story;

	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
		fDotLocked = TRUE;
	}
	myDrawBox(hdc, xpos, ypos - linhgtoff, xpos+fieldwid,
		ypos-linhgtoff+linhgt, forecolor, TRUE);

	SetTextColor(hdc, backcolor);
	SetBkColor(hdc, forecolor);
	TextOut(hdc, xpos, ypos, buf, len);
	if (f) {
		fDotLocked = FALSE;
		XShowDot(hdc, TRUE);
	}
}

void XDrawString(HDC hdc, HFONT font, short xpos, short ypos,
	unsigned char *buf, long len)
{
	BOOL	f = FALSE;
	
	if (lcurid != font)
		XSetFont(hdc, font);
	SetTextColor(hdc, forecolor);
	SetBkColor(hdc, backcolor);

	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
	}
	TextOut(hdc, xpos, ypos, buf, len);
	if (f)
		XShowDot(hdc, TRUE);
}

void XTextExtents(HDC hdc, HFONT font, unsigned char *buf, long len, short *width)
{
	SIZE	size;

	if (lcurid != font) 
		XSetFont(hdc, font);

	GetTextExtentPoint32(hdc, buf, len, &size);

	*width = (short)size.cx;
}

void XCharPos(HDC hdc, HFONT font, unsigned char *buf, long len, int *positions)
{
	SIZE	sz;
	int		i;
	
	if (lcurid != font)
		XSetFont(hdc, font);

	GetTextExtentExPoint(hdc, buf, len, 0, NULL, positions, &sz);
	for (i = len-1; i > 0; i--)
		positions[i] = positions[i-1];
	positions[0] = 0;
}

void XFillRectangle(HDC hdc, short pattern, short xpos, short ypos,
	short wid, short hgt)
{
	RECT	box;
	BOOL f = FALSE;
	
	mySetRect(&box, xpos, ypos, xpos+wid, ypos+hgt);
	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
		fDotLocked = TRUE;
	}
	switch (pattern) {			// gcblack &c. defined in winio.h
		case gcblack:
			myDrawBox(hdc, xpos, ypos, xpos+wid, ypos+hgt, 0L, TRUE);
			break;
		case gcwhite:
			myDrawBox(hdc, xpos, ypos, xpos+wid, ypos+hgt,
				RGB(255, 255, 255), TRUE);
			break;
		case gcflip:
			InvertRect(hdc, &box);
			break;
	}
	if (f) {
		fDotLocked = FALSE;
		XShowDot(hdc, TRUE);
	}
}

void XFillRectangleColor(HDC hdc, LONG lCol, short xpos, short ypos,
	short wid, short hgt)
{
	BOOL f = FALSE;
	
	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
		fDotLocked = TRUE;
	}
	myDrawBox(hdc, xpos, ypos, xpos+wid, ypos+hgt, lCol, TRUE);
	if (f) {
		fDotLocked = FALSE;
		XShowDot(hdc, TRUE);
	}
}

void XDrawRectangle(HDC hdc, short xpos, short ypos, short wid, short hgt)
{
	BOOL f = FALSE;
	
	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdc, FALSE);
	}
	myDrawBox(hdc, xpos, ypos, xpos+wid+1, ypos+hgt+1, forecolor, FALSE);
	if (f)
		XShowDot(hdc, TRUE);
}

// Actually print the cursor
static void XDisplayDot(HDC hdc)
{
	RECT	box;
	
	box.left = cursorX;
	box.bottom = cursorY;
	box.right = cursorX + cursorWidth;
	box.top = cursorY - cursorHeight;
	InvertRect(hdc, &box);
	fCursorBlink = !fCursorBlink;
}

// Show or hide the cursor
void XShowDot(HDC hdc, BOOL bFlag)
{
	while (fDotLocked) Sleep(5);
	fDotLocked = TRUE;
	if (fCursorOn == bFlag && fCursorBlink == bFlag) {
		fDotLocked = FALSE;
		return;
	}
	if ((bFlag && !fCursorBlink) || (!bFlag && fCursorBlink))
		XDisplayDot(hdc);
	fCursorOn = bFlag;
	fDotLocked = FALSE;
}

// Make the cursor blink
void XBlinkDot(HDC hdc)
{
	while (fDotLocked) Sleep(5);
	fDotLocked = TRUE;
	if (!fCursorOn) {
		fDotLocked = FALSE;
		return;
	}
	XDisplayDot(hdc);
	fDotLocked = FALSE;
}

// Move the cursor around
void XDrawDot(HDC hdc, short xpos, short ypos)
{
	while (fDotLocked) Sleep(5);
	fDotLocked = TRUE;
	if (fCursorOn && fCursorBlink) {
		XDisplayDot(hdc);
	}
	cursorX = xpos-1;
	cursorY = ypos+1;
	if (fCursorOn && !fCursorBlink) {
		XDisplayDot(hdc);
	}
	fDotLocked = FALSE;
}

void XDrawLine(HDC hdc, short xpos, short ypos, short xpos2, short ypos2)
{
	MoveToEx(hdc, xpos, ypos, NULL);
	LineTo(hdc, xpos2, ypos2);
}

// This scrolls the window and then invalidates the new region.
void XCopyArea(HWND win, short xpos, short ypos, short wid, short hgt, 
	short destxpos, short destypos)
{
	RECT	rclBox;
	BOOL	f = FALSE;
	
	mySetRect(&rclBox, xpos, ypos, xpos+wid, ypos+hgt);
	if (fCursorOn) {
		f = TRUE;
		XShowDot(hdcClient, FALSE);
	}
	ScrollWindowEx(win, destxpos-xpos, destypos-ypos, &rclBox, NULL,
		NULL, NULL, 0L);
	if (f)
		XShowDot(hdcClient, TRUE);
}
