////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: queue 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _QUEUE_T_
#define _QUEUE_T_

#include <listdefart.t>
#include <listnoart.t>
#include <replacewith.t>

#pragma C+

queue: object
    list        = []
    actor_      = nil
    verb_       = nil
    doList_     = []
    prep_       = nil
    iobj_       = nil
    status_     = nil
    str_        = nil
    queueMessage(actor, verb, dobj, prep, iobj, status, str) = {
        local o, c = self.list;
        
            
        o = car(c);
        while( o ) {
            if (actor == o.actor_
            && verb == o.verb_
            && prep == o.prep_
            && iobj == o.iobj_
            && status == o.status_
            && str == o.str_)
                break;
            c = cdr(c);
            o = car(c);
        }
        if ( o == nil) {
            o = new Message;
            self.list += o;
            o.actor_    = actor;
            o.verb_     = verb;
            o.prep_     = prep;
            o.iobj_     = iobj;
            o.status_   = status;
            o.str_      = str;
        }
        if (dobj)
            o.doList_ += dobj;
            
        /*
         *  If we aren't aggregating display messages then process the
         *  queue immediately.
         */
        if ( !global.textStyleAggregate ) {
            self.processQueue;
            return;
        }
    }
    processQueue = {
        local i, o, c, vptr, f;
        
        self.compressList;
        
        f = length(self.list);
        
        if (f > 1 || global.prefixShow) self.multi = true;
        
        c = self.list;
        o = car(c);
        while( o ) {
            self.actor_     = o.actor_;
            self.verb_      = o.verb_;
            self.doList_    = o.doList_;
            self.prep_      = o.prep_;
            self.iobj_      = o.iobj_;
            self.status_    = o.status_;
            
            self.processString(o.str_); "\n";
            
            delete o;
            c = cdr(c);
            o = car(c);
        }
        self.multi = nil;
        self.list = [];
    }
    compressList = {
        local i, j, o1, o2, len, oldList;
        local remList = [], newList = [];
        
        oldList = self.list;
        len = length(oldList);
        for (i = 1; i <= len-1; ++i) {
            for (j = i+1; j <= len; ++j) {
                o1 = oldList[i];
                o2 = oldList[j];
                if (o1.doList_ == o2.doList_) {
                    o1.str_ += o2.str_;
                    remList += o2;
                }
            }
        }
        self.list = oldList - remList;
        
        // Clean-up messages removed from the queue
        len = length(remList);
        for (i = 1; i <= len; ++i)
            delete remList[i];
    }
    processString(val) = {
        local ret, len, stat, str1, str2, sing, plur;
        
        stat = outcapture(true);
        if (length(self.doList_) > 1 && itemCount(self.doList_) == 1) {
            self.doList_[1].sDesc;
        }
        sing = '%<' + outcapture(stat) + '%>';
        
        stat = outcapture(true);
        if (length(self.doList_) > 1) {
            self.doList_[1].pluralDesc;
        }
        plur = outcapture(stat);
        
        stat = outcapture(true);
        listDefArt(self.doList_);
        str1 = outcapture(stat);
        
        caps();
        stat = outcapture(true);
        listDefArt(self.doList_);
        str2 = outcapture(stat);        
        
        ret = reSearch('_dobj_|_Dobj_', val);
        if (self.multi || (ret == nil && length(self.doList_) > 1))  {
            listNoArt(self.doList_);
            ": ";
        }
        
        caps();
        
        val = replaceWith(val, '_dobj_', str1);
        val = replaceWith(val, '_Dobj_', str2);
        if (length(self.doList_) == 1
        && !car(self.doList_).isThem) {
            val = replaceWith(val, '_it_', 'it');
            val = replaceWith(val, '_It_', 'It');
            val = replaceWith(val, '_s_', 's');
            val = replaceWith(val, '_is_', 'is');
            val = replaceWith(val, '_isn\'t_', 'isn\'t');
            val = replaceWith(val, '_does_', 'does');
            val = replaceWith(val, '_has_', 'has');
            val = replaceWith(val, '_a_', 'a');
            val = replaceWith(val, '_an_','an');
        } else {
            val = replaceWith(val, '_it_', 'they');
            val = replaceWith(val, '_It_', 'They');
            val = replaceWith(val, '_s_', '');
            val = replaceWith(val, '_is_', 'are');
            val = replaceWith(val, '_isn\'t_', 'aren\'t');
            val = replaceWith(val, '_does_', 'do');
            val = replaceWith(val, '_has_', 'have');
            val = replaceWith(val, '_a_|_an_', 'some');
            val = replaceWith(val, sing, plur);
        }
        
        say(val);
    }
;

#pragma C-

#endif /* _QUEUE_T_ */
