////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: sleepDaemon() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SLEEP_DAEMON_T_
#define _SLEEP_DAEMON_T_

#include <global.t>

#pragma C+

/*
 *   This function is a daemon, started by init(), that monitors how long
 *   it has been since the player slept.  It provides warnings for a while
 *   before the player gets completely exhausted, and causes the player
 *   to pass out and sleep when it has been too long.  The only penalty
 *   exacted if the player passes out is that he drops all his possessions.
 *   Some games might also wish to consider the effects of several hours
 *   having passed; for example, the time-without-food count might be
 *   increased accordingly.
 */
sleepDaemon: function(parm) {
    local a, s;

    global.awakeTime = global.awakeTime + 1;
    a = global.awakeTime;
    s = global.sleepTime;

    if (a == s || a == s + 10 || a == s + 20)
        "\bYou're feeling a bit drowsy; you should find a
        comfortable place to sleep. ";
    else if (a == s + 25 || a == s + 30)
        "\bYou really should find someplace to sleep soon, or
        you'll probably pass out from exhaustion. ";
    else if (a >= s + 35) {
        global.awakeTime = 0;
        if (parserGetMe().location.isBed || parserGetMe().location.isChair) {
            "\bYou find yourself unable to stay awake any longer.
            Fortunately, you are << parserGetMe().location.boardingPrep >> <<
            parserGetMe().location.aDesc >>, so you gently slip off into
            unconsciousness.
            \b* * * * *
            \bYou awake some time later, feeling refreshed. ";
        } else {
            local itemRem, thisItem;
            
            "\bYou find yourself unable to stay awake any longer.
            You pass out, falling to the ground.
            \b* * * * *
            \bYou awaken, feeling somewhat the worse for wear.
            You get up and dust yourself off. ";
            itemRem = parserGetMe().contents;
            while (car(itemRem)) {
                thisItem = car(itemRem);
                if (!thisItem.isWornBy(parserGetMe()))
                    thisItem.moveInto(parserGetMe().location);
                itemRem = cdr(itemRem);
            }
        }
    }
}

#pragma C-

#endif /* _SLEEP_DAEMON_T_ */
