////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: nestListCont() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NEST_LIST_CONT_T_
#define _NEST_LIST_CONT_T_

#include <listcontgen.t>

#pragma C+

/*
 *  nestListCont: function(obj, depth)
 *
 *  This function will produce a nested listing of the contents of obj.
 *  It will recurse down into the objects contents until the list is
 *  exhausted. An object's contents are listed only if they are
 *  considered visible by the normal visibility rules.  The depth
 *  parameter is used to control the tabbing of the listing: an initial
 *  value of 1 will produce a listing with indented top-level contents,
 *  which is normally what you want, but 0 might also be desirable
 *  desirable in certain cases.
 */
nestListCont: function(obj, depth) {
    /* 
     *   use the general-purpose contents lister to show a "tall" listing,
     *   recursing into contents of the items in the list 
     */
    listContGen(obj, &aDesc, LCG_TALL | LCG_RECURSE | LCG_CHECKVIS, depth);
}

#pragma C-

#endif /* _NEST_LIST_CONT_T_ */
