////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: checkInterface() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CHECK_INTERFACE_T_
#define _CHECK_INTERFACE_T_

#pragma C+

/*
 *   checkInterface:  
 */
checkInterface: function {
    local i, j, o, c, m, interfaceList = [];
    
    // Make a list of all interfaces that have a requiredMethod list
    o = firstobj(Interface);
    while(o != nil) {
        if (proptype(o, &requiredMethod) == DTY_LIST) {
            interfaceList += o;
        }
        o = nextobj(o, Interface);
    }
    
    // Loop thru all game objects and check Interface requirements
    o = firstobj();
    while (o != nil) {
        local requiredMethodList = [];
        if (find(interfaceList, o)) goto skip_next_obj;
        
        // For each object we loop through the list of Interfaces
        for (i = 1; i <= length(interfaceList); ++i) {
            /*
             *  If the object inherits the mix-in class we get the
             *  the interface required method list and loop through it.
             *  For each required method we get the class where it is
             *  defined for the object and check to see if the
             *  mixInClass is a superclass of this class. If it isn't 
             *  then we display an error and quit the game.
             */
            if (isclass(o, interfaceList[i].mixInClass)) {
                requiredMethodList = interfaceList[i].requiredMethod;
                for (j = 1; j <= length(requiredMethodList); ++j) {
                    m = requiredMethodList[j];
                    c = defined(o, m, DEFINED_GET_CLASS);
                    if (c == nil 
                    || !isclass(c, interfaceList[i].mixInClass)) {
                        "\n\b[ALT checkInterface Exception]\n
                        <<o.sDesc>>.requiredMethod[
                        <<j>> ] is not defined at a higher level
                        of inheritance than the object's 
                        <<interfaceList[i].mixInName>> 
                        superclass.\n";
                        quit();
                    }
                }
            }
        }
        
    skip_next_obj:;
        o = nextobj(o);
    }
}

#pragma C-

#endif /* _CHECK_INTERFACE_T_ */
