////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Functions 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _FUNCTIONS_H_
#define _FUNCTIONS_H_

/*
 *   Forward-declare functions.  This is not required in most cases,
 *   but it doesn't hurt.  Providing these forward declarations ensures
 *   that the compiler knows that we want these symbols to refer to
 *   functions rather than objects.
 */
addBulk: function;
addUnique: function;
addWeight: function;
askForDobj: function;
askForIobj: function;
box: function;
checkDoor: function;
checkInterface: function;
checkReach: function;
child: function;
children: function;
command: function;

#ifdef USE_HTML_PROMPT
commandAfterRead: function;
commandPrompt: function;
#endif /* USE_HTML_PROMPT */

commonAncestor: function;
darkTravel: function;
eatDaemon: function;
endCommand: function;
gActor: function;
gCmdString: function;
gCmdWordList: function;
gDobj: function;
gDoList: function;
gIobj: function;
gLocation: function;
goToSleep: function;
gPrep: function;
gStatus: function;
gVerb: function;
incScore: function;
indirectlyContains: function;
init: function;
initRestart: function;
initRestore: function;
initSearch: function;
inputLine: function;
isIndistinguishable: function;
itemCount: function;
languageNumber: function;
listCont: function;
listContCont: function;
listContGen: function;
listDefArt: function;
listFixedContCont: function;
listNoArt: function;
moveFloating: function;
nestListCont: function;
nestOutcapture: function;
numberedCleanup: function;
pardon: function;
parent: function;
postAction: function;
preCommand: function;
preinit: function;
preparse: function;
preparseCmd: function;
quitGame: function;
_rand: function;
replaceWith: function;
sayPrefixCount: function;
scoreFormat: function;
scoreRank: function;
scoreStatus: function;
showContCont: function;
sibling: function;
sleepDaemon: function;
switchPlayer: function;
turnCount: function;
undoTurn: function;
yesOrNo: function;
;

#include <addbulk.t>
#include <addunique.t>
#include <addweight.t>
#include <askfordobj.t>
#include <askforiobj.t>
#include <box.t>
#include <checkdoor.t>
#include <checkinterface.t>
#include <checkreach.t>
#include <child.t>
#include <children.t>
#include <command.t>
#include <commandafterread.t>
#include <commandprompt.t>
#include <commonancestor.t>
#include <darktravel.t>
#include <eatdaemon.t>
#include <endcommand.t>
#include <gactor.t>
#include <gcmdstring.t>
#include <gcmdwordlist.t>
#include <gdobj.t>
#include <gdolist.t>
#include <giobj.t>
#include <glocation.t>
#include <gotosleep.t>
#include <gprep.t>
#include <gstatus.t>
#include <gverb.t>
#include <incscore.t>
#include <indirectlycontains.t>
#include <init.t>
#include <initrestart.t>
#include <initrestore.t>
#include <initsearch.t>
#include <inputline.t>
#include <isindistinguishable.t>
#include <itemcount.t>
#include <languagenumber.t>
#include <listcont.t>
#include <listcontcont.t>
#include <listcontgen.t>
#include <listdefart.t>
#include <listfixedcontcont.t>
#include <listnoart.t>
#include <movefloating.t>
#include <nestlistcont.t>
#include <nestoutcapture.t>
#include <numberedcleanup.t>
#include <pardon.t>
#include <parent.t>
#include <postaction.t>
#include <precommand.t>
#include <preinit.t>
#include <preparse.t>
#include <preparsecmd.t>
#include <quitgame.t>
#include <rand.t>
#include <replacewith.t>
#include <sayprefixcount.t>
#include <scoreformat.t>
#include <scorerank.t>
#include <scorestatus.t>
#include <showcontcont.t>
#include <sibling.t>
#include <sleepdaemon.t>
#include <switchplayer.t>
#include <turncount.t>
#include <undoturn.t>
#include <yesorno.t>

#endif /* _FUNCTIONS_H_ */
