////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: RoomActionable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ROOM_ACTIONABLE_H_
#define _ROOM_ACTIONABLE_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  RoomActionable: object
 */
class RoomActionable: object
    lightsOn = true            // Rooms are lit unless otherwise specified
    isSeen = nil            // Room has not been seen yet
    /*
     *   'reachable' is the list of explicitly reachable objects, over and
     *   above the objects that are here.  This is mostly used in nested
     *   rooms to make objects in the containing Room accessible.  Most
     *   normal Rooms will leave this as an empty list.
     */
    reachable = []

    /*
     *   roomCheck is true if the verb is valid in the Room.  This
     *   is a first pass; generally, its only function is to disallow
     *   certain commands in a DarkRoom.
     */
    roomCheck(v) = { return true; }
        
    roomAction(a, v, d, p, i) = {
        if (self.location && self.canSenseLocations(sight, nil))
            self.location.roomAction(a, v, d, p, i);
    }


    /*
     *   Whenever a normal object (i.e., one that does not override the
     *   default doDrop provided by 'thing') is dropped, the actor's
     *   location is sent roomDrop(object being dropped).  By default, 
     *   we move the object into this Room.
     */
    roomDrop(obj) = {
        "Dropped. ";
        obj.moveInto(self);
    }
;

#pragma C-

#endif /* _ROOM_ACTIONABLE_H_ */
