////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Passageway 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _PASSAGEWAY_H_
#define _PASSAGEWAY_H_

#include <destination.h>
#include <fixeditem.h>

#pragma C+

/*
 *  Passageway: Destination, FixedItem
 *
 *  A Passageway should code a location and leadsTo property to indicate
 *  where the object is located and where travel leads to when the
 *  Destination is successfully negotiated.
 */
class Passageway: Destination, FixedItem
    verDoEnter(actor) = {}
    doEnter(actor) = {
        actor.travelTo(self.destination);
    }
    doSynonym('Enter') = 'Gothrough'
;

#pragma C-

#endif /* _PASSAGEWAY_H_ */
