////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: DarkRoomable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _DARK_ROOMABLE_H_
#define _DARK_ROOMABLE_H_

#include <darkroomactionable.h>
#include <darkroomdisplayable.h>
#include <darkroomtravelable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  DarkRoomable: DarkRoomActionable, DarkRoomDisplayable, 
 *      DarkRoomTravelable
 *
 *  An enterable area which might be dark
 */
class DarkRoomable: DarkRoomActionable, DarkRoomDisplayable, 
    DarkRoomTravelable      
;

#pragma C-

#endif /* _DARK_ROOMABLE_H_ */
