////////////////////////////////////////////////////////////////////////
//  
//  Inform.t Library File: Object 991214
//
//  Copyright (c) 1999 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the Inform.t library extension for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#include <declare.t>

#pragma C+

modify global
    tlist = []
    timeStatus = nil
	preparseObjList = []
	initialList = []
	describeList = []
	whenContOpenList = []
	whenContClosedList = []
	whenObstOpenList = []
	whenObstClosedList = []
	whenOnList = []
	whenOffList = []
	stat = nil
;

/*
 *  command: object
 *
 *  The command object carries all the pertinent information connected
 *  with the command, including the plist and the word-string list that
 *  the user entered for the direct and indirect objects of the command.
 */
command: object
    actorPtr        = nil
    verbPtr         = nil
    dolistPtr       = []
    dobjPtr         = nil
    prepPtr         = nil
    iolistPtr       = []
    iobjPtr         = nil
    plist           = []
    doWords         = []
    ioWords         = []
    cantReachWords  = []
;

story: object
    dispBeginDesc = "<B>"
    dispEndDesc = "</B>"
    main = {
        story.initialise_common;
        "<<story.introduction>>\b";
        self.dispBeginDesc;
        "<<story.title>>\n";
        self.dispEndDesc;
        "<<story.headline>>\n";
        "<<story.versiondesc>>\n";          
        story.initialise;
    }
    title = ""
    headline = ""
    starting_location = nil
    introduction = ""
    restore_introduction = ""
    initialise = {
        // move player to initial location    
        command.actorPtr = parserGetMe();
        parserGetMe().location = story.starting_location;
        maintainScopelist(parserGetMe());

        // show player where he is    
        parserGetMe().location.senseAround(parserGetMe(), true); 
        parserGetMe().location.isseen = true; 
        scoreStatus(0,0);
    }
    initialise_common = { "\H+"; }
    initialise_daemon = {}
    versiondesc = { 
        "Release <<say(self.release)>> / 
        Serial number <<self.serial>> / TADS Version 
        <<say(systemInfo(__TADS_VERSION_MAJOR))>>\b";
    }
    release = 1
    serial = "000000"
;

lamplist_pio: preinitObj
	piomethod =
	{
    	local o;
    
    	global.lamplist = [];
    	o = firstobj();
    	while( o )
    	{
        	if (o.islamp)
            	global.lamplist = global.lamplist + o;
        	o = nextobj(o);
    	}
	}
;

clist_pio: preinitObj
	piomethod =
	{
    	local o;
    
    	o = firstobj();
    	while( o )
    	{
            maintainScopelist(o);
        	o = nextobj(o);
    	}
	}
;

preparse_pio: preinitObj
	piomethod =
	{
    	local o;   
    	o = firstobj(preparseObj);
    	while( o )
    	{
        	global.preparseObjList += o;
        	o = nextobj(o, preparseObj);
    	}
	}
;

/*
 *	timesys_ppo: preparseObj
 *
 *	Preparses the wait command. This will return a list consisting of the 
 *	reSearch() return for the command, a calculated waittime, and a field that
 *	contains the time-value for the o'clock, or a boolean which indicates
 *	whether 24-hour restriction was necessary.
 *
 *  If ppo.t is not #include'd in the source then TimeSys reverts to the
 *  use of an ordinary TADS preparse() function.
 */
timesys_ppo: preparseObj
    ppomethod( cmd ) =
    {
        local ret, grp, waitret;
        
        cmd = lower(cmd);
        
        waitret = reSearch('(.*)(%<wait%>)(.*)',cmd);
        if (waitret == nil)
        {
        	waitret = reSearch('(.*)(%<z%>)(.*)',cmd);
        	if (waitret == nil)
        		return true;
        }
        
       	/*
       	 *	If wait has no specified time we use the default timesys 
       	 *  timerate.
       	 */
       	if (reGetGroup(3)[3] == '' || reGetGroup(3)[3] == ' ')
    	{
    		cmd = reGetGroup(1)[3] + reGetGroup(2)[3] + 
    		    ' ' + cvtstr(timesys.timerate) + reGetGroup(3)[3];
    	}
        ret = parsetime( cmd );
        if (ret)
        {
            local tmpcmd = '';
            
            timesys.waittime = ret[2];
            
            /*
             *	Restructuring the command. The reSearch() return from parsetime is
             *	the first element of ret. We can discard the rest of the list.
             *	We save ret[3], which is are returned parsed time parm, for
             *	use with the 'Again' command.
             */
            ret = car(ret);
            
            timesys.timestring = ret[3];
            
            if (ret[1] - 1)
                tmpcmd += substr(cmd, 1, ret[1]-1);
                
            if (length(cmd) - ret[1] - ret[2] + 1)
        	{	
             	local tmpcmd2;
             	
             	tmpcmd2 = substr(cmd, ret[1] + ret[2], 
                   length(cmd) - ret[1] - ret[2] + 1);

        		ret = reSearch('%w', tmpcmd2);
        		
        		if (ret)
        		{
        			"[There appear to be extra words or commands after the
        			WAIT command.]\b";
        			return nil;
        		}
        		else
        		{
        			tmpcmd += tmpcmd2;
        		}
        	}
            return tmpcmd;
        }
        else
        {
        	if (waitret)
        	{
        			"[This does not appear to be a valid time-format.]\b";
        			return nil;
        	}
        }
        return true;
    }
;

/*
 * 	timesys: object
 *
 *	This is the game 'time clock' which keeps track of various
 *	date and time values, advances the time when requested
 *	and converts numeric date and time values into parm values
 *	for statusLine display.
 */
timesys: object
	/* 
	 *	TIME ATTRIBUTES AND METHODS
	 *
	 *	Once initialized settimesys() the time is maintained 
	 *	as a cyclical value that represents the minutes
	 *	past midnight from 0 to 1439.
	 */
	timestring = nil					// last value processed by parsetime()
	time = 0 							// time representation in minutes
	timerate = 1
	informWait = true                   // controls how waitingVerb handles daemons						// time increment per turn in minutes
	timeDisplay( t, parm ) =
	{
		local h, m, ampm, t24, i;

		h = t / 60;
		t24 = h;
		m = t % 60;
		if ( h >= 12 )
		{
			if ( h > 12 )
			{
				h = h - 12;
			}
			ampm = ' pm';
		}
		else
		{
			ampm = ' am';
			if ( h == 0 )
			{
				h = 12;
			}
		};
		i = cvtstr( h ) + ':';
		if ( m < 10 )
		{
			i = i + '0';
		}
		
		i = i + cvtstr( m ) + ampm;
		
		if ( parm )
		{
			t24 = cvtstr( t24 ) + ':' + cvtstr( m );	// i.e. 15:00
			h = cvtstr( h );
			m = cvtstr( m );
			
			return [ self.time i t24 h m ampm ];
		}
		else
		{
			return i;
		}
	}
	/*
	 *	DAY ATTRIBUTES AND METHODS
	 *		
	 *	Once initialized with settimesys(), either directly
	 *	or through calculation, this maintains a 
	 *	cyclical value that represents the day of the week
	 *	with values from 1=Fri to 7=Thur.
	 */
    day = 2                                   		// the numeric day of the week
	dayDisplay( d, parm ) = 
	{
		local i, j;

		switch( d )
		{
			case nil:
				i = nil;
				j = nil;
				break;
			case 1:
				i = 'Friday';
				j = 'Fri';
				break;
			case 2:
				i = 'Saturday';
				j = 'Sat';
				break;
			case 3:
				i = 'Sunday';
				j = 'Sun';
				break;
			case 4:
				i = 'Monday';
				j = 'Mon';
				break;
			case 5:
				i = 'Tuesday';
				j = 'Tue';
				break;
			case 6: 
				i = 'Wednesday';
				j = 'Wed';
				break;
			case 7:
				i = 'Thursday';
				j = 'Thur';
				break;
		};
		
		if ( parm )
		{ 
			return [ self.day i j ];
		}
		else
		{
			return i;
		}
	}
	/*
	 *	DATE ATTRIBUTES AND METHODS
	 *
	 *	Once intiliazed with settimesys() the date is maintained as
	 *	a base number calculated to take into account the 
	 *	full century and year (year 2000 compliant!) as well
	 *	as leap year days.
	 */
	date = 730500
	dateDisplay( d, parm ) =
	{
		local e1, e2, yyyy, ddd, base, p, m, dd, i, j;

		base = d;
		
		e1 = base / 366;
		e2 = base / 365;
		
		for ( yyyy = e1; yyyy <= e2; yyyy++ )
		{
			ddd = base - yyyy*365 - ( yyyy - 1 ) / 4;

			if ( ddd < 1 )
			{
				break;
			}
		}
		yyyy--;
		
		ddd = base - yyyy*365 - (( yyyy - 1 ) / 4);

		if ( yyyy%4 == 0 ) 
		{
			p = 1;
		}
		else
		{
			p = 0;
		}
		
		if ( ddd > p + 334 )
		{
			m = 'December';
			dd = ddd - ( p + 334 );
		}
		else if ( ddd > p + 304 )
		{
			m = 'November';
			dd = ddd - ( p + 304 );
		}
		else if ( ddd > p + 273 )
		{
			m = 'October';
			dd = ddd - ( p + 273 );
		}
		else if ( ddd > p + 243 )
		{
			m = 'September';
			dd = ddd - ( p + 243 );
		}
		else if ( ddd > p + 212 )
		{
			m = 'August';
			dd = ddd - ( p + 212 );
		}
		else if ( ddd > p + 181 )
		{
			m = 'July';
			dd = ddd - ( p + 181 );
		}
		else if ( ddd > p + 151 )
		{
			m = 'June';
			dd = ddd - ( p + 151 );
		}
		else if ( ddd > p + 120 )
		{
			m = 'May';
			dd = ddd - ( p + 120 );
		}
		else if ( ddd > p + 90 )
		{
			m = 'April';
			dd = ddd - ( p + 90 );
		}
		else if ( ddd > p + 59 )
		{
			m = 'March';
			dd = ddd - ( p + 59 );
		}
		else if ( ddd > 31 )
		{
			m = 'February';
			dd = ddd - 31;
		}
		else
		{
			m = 'January';
			dd = ddd;
		}; 
	
		i = cvtstr( dd ) + ' ' + m + ' ' + cvtstr( yyyy );		// the default date format dd mmmmm yyyy

		if ( parm )
		{
			j = m + ' ' + cvtstr( dd ) + ' ' + cvtstr( yyyy ); // format mmmmm dd yyyy
		
			return [ self.date i j yyyy m ddd dd ];
		}
		else
		{
			return i;
		}
	}
	/*
	 *	ELAPSETIME ATTRIBUTES AND METHODS
	 *
	 *	This represents the total accumulated game time
	 *	in minutes. It is updated each time timesys.advance()
	 *	is called.
	 */
	elapsetime = 0
	elapsetimeDisplay( e, parm ) =
	{
		local t, d, h, i = ' ', len;
		t = e;
		d = ( t / 1440 );
		t -= d*1440;
		h = ( t / 60 );
		t -= h*60;
		if ( d > 0 )
		{
			i = cvtstr( d );
			if ( d == 1 )
			   i = i + ' day ';
			else
			   i = i + ' days ';
		}
		if ( h > 0 )
		{
			if ( d > 0 )
			{
				i = i + ' and ';
			}
			i = i + cvtstr( h );
			if ( h == 1 )
			   i = i + ' hour ';
			else
			   i = i + ' hours ';
		}
		if ( d > 0 || h > 0 )
		{
			if ( t > 0 )
			{
				i = i + ' and ';
				i = i + cvtstr( t );
				if ( t == 1 )
		   	   	   i = i + ' minute';
				else
		   	    	   i = i + ' minutes';
			}
		}
		else
		{
			i = i + cvtstr( t );
			if ( t == 1 )
		  	   i = i + ' minute';
			else
		    	   i = i + ' minutes';
		}

		len = length( i );

		if ( substr( i, len, 1 ) == ' ' )
		{
			i = substr( i, 1, len-1 );
		}

		if ( parm )
		{
			h = self.elapsetime / 60;
			d = self.elapsetime / 1440;
			
			return [ self.elapsetime i d h ];
		}
		else
		{
			return i;
		}
	}
	/*
	 *	WAITING PROCESS ATTRIBUTES
	 *
	 *	Used by the waiting process initiated by either the 
	 *	waitingVerb class or the advanctime(). 
	 */
	waiting = nil		// waiting process active (true/nil)
	waittime = nil		// time in minutes to wait
	waitquery = nil		// ask player if they wish to continue waiting
	waitqblock = nil		// block any waitquery
	/*
	 *	ADVANCE METHOD
	 *
	 *	This progresses the time, day, date, and elapsetime
	 *	and makes a call to timepasses()
 	 */
	advance( incr ) =
	{
		local b, d, e, t;
        		
		t = self.time;
		if ( self.day )
			d = self.day;
		else
			d = 0;

		if ( self.date )
			b = self.date;
		else
			b = 0;
		
		e = self.elapsetime;

		if ( incr == nil )
		{
			t += self.timerate;
			e += self.timerate;
		}
		else
		{
			t += incr;
			e += incr;
		}

		while( t >= 1440 ) 
		{ 
			t -= 1440;
			d++;
			if ( d > 7 )
				d = 1;
			b++;
		}
		
		self.time = t;

		if ( self.day ) 
			self.day = d;

		if ( self.date )
			self.date = b;
		
		self.elapsetime = e;
	}
	/*
	 *	EVENTS METHOD
	 *
	 *	Allows the author to affect global time-related events, such as lighting and 
	 *	weather effects. This method is called with each increment of timesys.time.
	 *	You should use replace this method in your game source using the 'modify'
	 *	statement.
	 */
	events =
	{
		return nil;
	}	                                             
;

/*
 *  messagepump: object
 *
 *  The messagepump builds and maintains two lists. The schedule is used
 *  to carry pending events from one queue stage to the next. The 
 *  dynamList is reduced object by object until it is empty. It rebuilt 
 *  from the schedule at the beginning of each queue stage.
 */
messagepump: object
	schedule = []
	
	//  schedules an event on the messagepump and checks to see if it is
	//  ready to process immediately.
	generateEvent( o, p, v, s, r, f, c, actor, verb, dobj, prep, iobj ) =
	{
	    local event;
	    
		event = self.scheduleEvent( o, p, v, s, r, f, c, actor, verb, dobj, prep, iobj );
		self.checkQueue( event, nil );
	}	
	//  An event is only scheduled once, but the eventCnt
	//  is incremented and the e parameter is added to the 
	//  eventList.
	scheduleEvent( o, p, v, s, r, f, c, actor, verb, dobj, prep, iobj ) = 
	{
		local event;
		
		event = self.getEvent(o, p, v, s, r, f);

		//  We didn't find a scheduled event that matches our newly
		//  generated one, so we loop through our dynamically-created
		//  event objects, looking for an unscheduled one.
		if (event == nil)
		{
    			event = firstobj(eventObj);
    			while ( event )
    			{
        			if (! event.isscheduled)
					break;
        			event = nextobj(event, eventObj);
    			}
		}
		
		//  We don't have any scheduled event that matches our new one,
		//  nor any free event objects, so we create a new event object.
		if (event == nil)
		{
			event = new eventObj;
		}
		
        //  If the event is unscheduled we set its attributes up as a
		//  newly generated event.
		if (! event.isscheduled)
		{
			event.isscheduled = true;
			event.objPtr = o;
			event.processPtr = p;
			event.validatePtr = v;
			event.stage = s;
			event.retain = r;
			event.frequency = f;
			event.frequencyCnt = 0;
			event.commArg = c;
			event.actorPtr = actor;
			event.verbPtr = verb;
			event.dobjListPtr = [];
			event.prepPtr = prep;
			event.iobjPtr = iobj;
			event.eventCnt = 0;
			event.pendingReason = nil;

			self.schedule += event;
		}
		
		++event.eventCnt;
		if ( dobj )
		    event.dobjListPtr += dobj;
		
	    return event;
	}
	//  An event is declared to be a unique combination of stage,
	//  retain, frequency, object, validate, and process properties. 
	//  The method searches messagepump schedule. If found it returns 
	//  the event object; otherwise it returns nil.
	getEvent( o, p, v, s, r, f ) = 
	{
		local i, len, event;
		
		len = length(self.schedule);

		for (i = 1; i <= len; ++i)
		{
			event = self.schedule[i];

			if (o == event.objPtr
			&& p == event.processPtr
			&& v == event.validatePtr
			&& s == event.stage
			&& r == event.retain
			&& f == event.frequency)
				return event;
		}
		return nil;
	}	
    //  processQueue is called at each queue stage. It loops through every 
	//  event in the dynamList until it has an empty list. Only events
	//  marked isscheduled are passed on to checkQueue()
	processQueue( queueStage ) =
	{
		local event, dynamList;

		dynamList = self.schedule;
		
		event = car( dynamList );
		while( event )
		{
		    if (event.isscheduled)
		        self.checkQueue( event, queueStage );		    
		    dynamList = cdr( dynamList );
		    event = car( dynamList );
		}
	}	
	//  checkQueue is called initially, when the event is generated, to
	//  determine if it should be processed immediately. It is also
	//  called at each queue stage.
	checkQueue( event, queueStage ) =
	{
		local ptr, ret, arg, actor, verb, dobjList, prep, iobj, eCnt, pReason;
		
		//
		//  If the stage is nil or equal to queueStage then we continue
		//  checkQueue processing; otherwise we return.
		//
        	if (event.stage != nil
	    	&& event.stage != queueStage) 
            	return;
		
		ret = self.checkFrequency( event );
		
		if (ret == nil)
		{
			arg         = event.commArg;
			actor       = event.actorPtr;
			verb        = event.verbPtr;
			dobjList    = event.dobjListPtr;
			prep        = event.prepPtr;
			iobj        = event.iobjPtr;
			eCnt        = event.eventCnt;
			pReason     = event.pendingReason;
		
			//  Call the event's validate method / function. If the event
			//  doesn't have a validate method / function then we use the 
			// messagepump.validate() method.
			
			ptr = event.validatePtr;
			
			if (ptr)
			{
				if (arg)	
		    		ret = event.objPtr.ptr(actor, verb, dobjList, prep, iobj, 
						eCnt, pReason);
				else
					ret = event.objPtr.ptr(eCnt, pReason);
			}
		}
		
	    //  Call the event's processPtr, if the event passed validate;
	    //  otherwise we update its pendingReason with a any non-purge
	    //  return value.
		if (ret == nil)
		{
		    ptr = event.processPtr;
		    
		    if (arg)
		        event.objPtr.ptr(actor, verb, dobjList, prep, iobj, eCnt, pReason);
		    else
			    event.objPtr.ptr(eCnt, pReason);
		}
	    else if (ret != MP_PURGE)
	        event.pendingReason = ret;

	    //  if the event is not retained and we've called its
	    //  processPtr or its validate requested that the event be
	    //  purged then we unschedule it.
		if ((! event.retain && ret == nil)
		|| ret == MP_PURGE)
			self.unscheduleEvent( event );
	}
    //  If the frequencyCnt is greater than 0 we're not ready to
    //  process this event yet. We decrement the count and return.
    //  This is used to simulate fuse-like behaviour.
	checkFrequency( event ) = 
	{ 
		if (event.frequencyCnt > 0)
		{
			--event.frequencyCnt;
			return MP_FUSE;
		}
		else if (event.retain)
		{
			event.frequencyCnt = event.frequency;
		}
		
	    return nil; 
	}
	//  This method should be used for explicitly purging an event from
	//  the messagepump schedule.
	deletePending( o, p, v, s, r, f ) =
	{
		local event = self.getEvent(o, p, v, s, r, f);
		
		if ( event )
			self.unscheduleEvent( event );
	}
	//  Removes the event from the messagepump schedule, and re-
	//  initializes it.
	unscheduleEvent( event ) =
	{
		event.isscheduled = nil;
		self.schedule -= event;		
	}
;

//
//  Kludge for story object
//
startroom: object;

#pragma C-
