#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>
#include "1mazes.h"

// -------------------------------------------------------------------
// TABLE OF CONTENTS
// -------------------------------------------------------------------

// NOTES
// DEBUG STUFF
// TWISTY/ESCAPE MAZES: DIRECTION MACROS
// TWISTY/ESCAPE MAZES: DIRECTIONS, ETC.
// TWISTY/ESCAPE MAZES: ROOMS, ETC: ROOM CLASSES
// TWISTY/ESCAPE MAZES: ROOMS, ETC: ROOMS
// TWISTY/ESCAPE MAZES: ROOMS, ETC: PASSAGES
// TWISTY/ESCAPE MAZES: MISC
// TWISTY/ESCAPE MAZES: DECORATIONS: SPEAKERS, BUTTONS, WALLS
// TWISTY/ESCAPE MAZES: DECORATIONS: STATUES
// TWISTY/ESCAPE MAZES: MAPS: TWISTY MAP
// TWISTY/ESCAPE MAZES: MAPS: ESCAPE MAP
// TWISTY/ESCAPE MAZES: ANSWER PARSING
// TWISTY/ESCAPE MAZES: THE DATA OBJECT

// -------------------------------------------------------------------
// NOTES
// -------------------------------------------------------------------

//////////////////////////////
// 
// Make sure to modify "fore" to disassociate the "fore" dictionary
//   word from that direction.
// Modify the "Yes" and "No" actions, and any others that have 'say' in
//   their grammar, removing that grammar. And then modify the "Say" 
//   action, doing replaceAction(Yes) or whatever as appropriate.
//
//
//
// 
//////////////////////////////

/*
say tow.say wiki.say is.say sit.say toy.say yell.say loci.say it.say tat.say tall.say lie.say equip.say pasta.say ass.say sis.say spa.say aging.say gale.say empress
say eaves.say sac.say cola.say atop.say peace.say east.say teeth.say hi.say is.say sail.say lava.say adverb.say by.say your.say rigatoni.say in.say not.say teeth
*/

// -------------------------------------------------------------------
// DEBUG STUFF
// -------------------------------------------------------------------

#ifdef __DEBUG

twistyOutputFilter: OutputFilter
    filterText(ostr, val) {
        if (val.find('PERSON')) {
            local k = 0;
            k=k/k;
        }
        return val;
    }
;

twistyObj: Fixture 'twisty' 'twisty'
  @twistyRoomT
;
escapeObj: Fixture 'escape' 'escape'
  @escapeRoomE
;
class TwiEscButton: Button, Fixture 'buon' 'buon'
  "It<./s>s just a buon. "
  dobjFor(Push) { 
    action() { 
      "You push the buon. "; 
      asscPass.makeOpen(true);
      nbmBanner.updateMe();
    } 
  }   
;

twistyButtonT:       TwiEscButton location=twistyRoomT        asscPass=twiForwPassTW;
twistyButtonTw:      TwiEscButton location=twistyRoomTw       asscPass=twiForwPassWI;
twistyButtonTwi:     TwiEscButton location=twistyRoomTwi      asscPass=twiForwPassIS;
twistyButtonTwis:    TwiEscButton location=twistyRoomTwis     asscPass=twiForwPassST;
twistyButtonTwist:   TwiEscButton location=twistyRoomTwist    asscPass=twiForwPassTY;
twistyButtonTwisty:  TwiEscButton location=twistyRoomTwisty   asscPass=twiForwPassYL;
twistyButtonL:       TwiEscButton location=twistyRoomL        asscPass=twiForwPassLI;
twistyButtonLi:      TwiEscButton location=twistyRoomLi       asscPass=twiForwPassIT;
twistyButtonLit:     TwiEscButton location=twistyRoomLit      asscPass=twiForwPassTT;
twistyButtonLitt:    TwiEscButton location=twistyRoomLitt     asscPass=twiForwPassTL;
twistyButtonLittl:   TwiEscButton location=twistyRoomLittl    asscPass=twiForwPassLE;
twistyButtonLittle:  TwiEscButton location=twistyRoomLittle   asscPass=twiForwPassEP;
twistyButtonP:       TwiEscButton location=twistyRoomP        asscPass=twiForwPassPA;
twistyButtonPa:      TwiEscButton location=twistyRoomPa       asscPass=twiForwPassAS;
twistyButtonPas:     TwiEscButton location=twistyRoomPas      asscPass=twiForwPassSS;
twistyButtonPass:    TwiEscButton location=twistyRoomPass     asscPass=twiForwPassSA;
twistyButtonPassa:   TwiEscButton location=twistyRoomPassa    asscPass=twiForwPassAG;
twistyButtonPassag:  TwiEscButton location=twistyRoomPassag   asscPass=twiForwPassGE;
twistyButtonPassage: TwiEscButton location=twistyRoomPassage  asscPass=twiForwPassES;

escapeButtonE:       TwiEscButton location=escapeRoomE        asscPass=escForwPassES;
escapeButtonEs:      TwiEscButton location=escapeRoomEs       asscPass=escForwPassSC;
escapeButtonEsc:     TwiEscButton location=escapeRoomEsc      asscPass=escForwPassCA;
escapeButtonEsca:    TwiEscButton location=escapeRoomEsca     asscPass=escForwPassAP;
escapeButtonEscap:   TwiEscButton location=escapeRoomEscap    asscPass=escForwPassPE;
escapeButtonEscape:  TwiEscButton location=escapeRoomEscape   asscPass=escForwPassET;
escapeButtonT:       TwiEscButton location=escapeRoomT        asscPass=escForwPassTH1;
escapeButtonTh:      TwiEscButton location=escapeRoomTh       asscPass=escForwPassHI;
escapeButtonThi:     TwiEscButton location=escapeRoomThi      asscPass=escForwPassIS;
escapeButtonThis:    TwiEscButton location=escapeRoomThis     asscPass=escForwPassSL;
escapeButtonL:       TwiEscButton location=escapeRoomL        asscPass=escForwPassLA;
escapeButtonLa:      TwiEscButton location=escapeRoomLa       asscPass=escForwPassAB;
escapeButtonLab:     TwiEscButton location=escapeRoomLab      asscPass=escForwPassBY;
escapeButtonLaby:    TwiEscButton location=escapeRoomLaby     asscPass=escForwPassYR;
escapeButtonLabyr:   TwiEscButton location=escapeRoomLabyr    asscPass=escForwPassRI;
escapeButtonLabyri:  TwiEscButton location=escapeRoomLabyri   asscPass=escForwPassIN;
escapeButtonLabyrin: TwiEscButton location=escapeRoomLabyrin  asscPass=escForwPassNT;
escapeButtonLabyrint:TwiEscButton location=escapeRoomLabyrint asscPass=escForwPassTH2;

#endif // __DEBUG


















// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: DIRECTION MACROS
// -------------------------------------------------------------------

#define DefineDirection(prop, base, order) \
    prop##Direction: base##Direction \
    dirProp = &prop \
    sortingOrder = order

#define DefineLangDir(root, dirNames, backPre) \
grammar directionName(root): dirNames: DirectionProd \
   dir = root##Direction \
; \
\
modify root##Direction \
   name = #@root \
   backToPrefix = backPre

#define DefineDirection(prop, base, order) \
    prop##Direction: base##Direction \
    dirProp = &prop \
    sortingOrder = order

//#define DefLngNationDir(root, nm, dirNames, backPre) \
//grammar directionName(root): dirNames: DirectionProd \
//   dir = root##Direction \
//; \
//\
//modify root##Direction \
//   name = #@nm \
//   backToPrefix = backPre

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: DIRECTIONS, ETC.
// -------------------------------------------------------------------

class ActorRelativeDirection: Direction
  defaultConnector(loc) {
    return (loc.isTwistyEscape ? noTravel : noActorRelativeTravel);
  }
;

noActorRelativeTravel: noTravel
  dobjFor(TravelVia) {
    action() {
      //libMessages.notOnboardShip();
      //"That direction isn<./s>t meaningful here. ";
      //"{You/he} can<./s>t go that way. ";
      say(gActor.getActionMessageObj.cannotGoThatWayMsg);
      exit;
    }
  }
;

replace grammar directionName(fore): ' ': DirectionProd
  dir = foreDirection
;

DefineDirection(forward,  ActorRelative, 13010);
DefineDirection(backward, ActorRelative, 13020);

DefineLangDir(forward,  'forward'|'forwards'|'ahead'|'fore'|'f', '');
DefineLangDir(backward, 'backward'|'backwards'|'back'|'b', '');

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: ROOMS, ETC: ROOM CLASSES
// -------------------------------------------------------------------

/*
TWISTY LITTLE PASSAGES
ESCAPE THIS LABYRINTH

A astonishing angling    arc and curve
B bizarre     brilliant  bend and curve
C cavernous   curious    coil and curve
E eerie       elliptical are extremely curved
G giant       gleaming   glide and curve
H huge        high       hook and curve
I imposing    iridescent are immensely curved
L large       luminous   loop and curve
N nebulous    numberless narrow and widen
P peculiar    polished   plunge and curve
R round       radiant    roll and curve
S strange     shimmering slope and curve
T tall        twinkling  twist and turn
W weird       wide       wind and curve
Y yawning     yielding   curve away from your bot

You are in an astonishing room, with angling    walls that arc and curve           , leaving your bot faintly disoriented.
You are in a  bizarre     room, with brilliant  walls that bend and curve          , leaving your bot faintly disoriented.
You are in a  cavernous   room, with curious    walls that coil and curve          , leaving your bot faintly disoriented.
You are in an eerie       room, with elliptical walls that are extremely curved    , leaving your bot faintly disoriented.
You are in a  giant       room, with gleaming   walls that glide and curve         , leaving your bot faintly disoriented.
You are in a  huge        room, with high       walls that hook and curve          , leaving your bot faintly disoriented.
You are in an imposing    room, with iridescent walls that are immensely curved    , leaving your bot faintly disoriented.
You are in a  large       room, with luminous   walls that loop and curve          , leaving your bot faintly disoriented.
You are in a  nebulous    room, with numberless walls that narrow and widen        , leaving your bot faintly disoriented.
You are in a  peculiar    room, with polished   walls that plunge and curve        , leaving your bot faintly disoriented.
You are in a  round       room, with radiant    walls that roll and curve          , leaving your bot faintly disoriented.
You are in a  strange     room, with shimmering walls that slope and curve         , leaving your bot faintly disoriented.
You are in a  tall        room, with twinkling  walls that twist and turn          , leaving your bot faintly disoriented.
You are in a  weird       room, with wide       walls that wind and curve          , leaving your bot faintly disoriented.
You are in a  yawning     room, with yielding   walls that curve away from your bot, leaving your bot faintly disoriented.


A amazing artifact ascends ... 
B big statue bends up ... 
C colossal statue curves up ...
E enormous statue is elevated ...
G gigantic statue goes up ...
H huge statue hangs high above, ...
I immense statue is incredibly high, ...
L large statue looms ...
N noteworthy statue is not what you<./s>d call tiny. ...
P prodigious statue is positioned ...
R remarkable statue rises ...
S sizeable statue soars up ...
T tremendous statue towers ...
W whopping statue rises well into the air ...
Y Before your bot, the statue rises several yards into the air ...
*/


class TwistyEscapeRoom: Room
  name = 'room'
  vocabWords = 'room'
  isTwistyEscape = true
  isVeryEasy = nil
  desc {
    "This is <<aNameFrom(teRoomAdj)>> room, with <<teWallsAdj>> walls 
      that <<teVerbPhrase>>, leaving your bot faintly disoriented. ";
    if (canGoForward && canGoBackward)
      "Exits lead forward and backward. ";
    else if (canGoForward)
      "An exit leads forward. ";
    else if (canGoBackward)
      "An exit leads backward. ";
  }
  north: NoTravelMessage {
    travelDesc {
      "Sheila looks around in confusion, then says, 
        <.q>Something about these walls has me really confused! 
        I can<./s>t tell one direction from another. ";
      if (!bot.location.canGoForward && !bot.location.canGoBackward)
        "Besides, there don<./s>t seem to be any exits out of here 
          anyway.<./q> ";
      else {
        "However, I can tell you that ";
        if (bot.location.canGoForward && bot.location.canGoBackward)
          "there are exits leading forward and backward.<./q> ";
        else if (bot.location.canGoForward)
          "there is an exit leading forward.<./q> ";
        else
          "there is an exit leading backward.<./q> ";
      }
      //"You are rather disoriented among these strange curving walls. You 
      //  can no longer tell north from south or east from west. "
    }
  }
  nextRoom {
    if (!forward) return nil;
    return forward.otherSide.location;
  }
  canGoForward {
    if (!forward) return nil;
    return forward.isOpen;
  }
  canGoBackward {
    if (!backward) return nil;
    return backward.isOpen;
  }
  south     asExit(north)
  east      asExit(north)
  west      asExit(north)
  northeast asExit(north)
  northwest asExit(north)
  southeast asExit(north)
  southwest asExit(north)
  roomParts = [defaultFloor, defaultCeiling, teWalls]
  holeSound = 'the echoing of an odd, spherical chamber'
  setWarning {
    //local k = 0; k=k/k;
    local weNeedToGiveWarning = nil;
    if (//gPlayerChar.getOutermostRoom == firstRoomInThisMazeSet
        glob.(openingProp) == nil
        && glob.(warningProp) == nil)
      weNeedToGiveWarning = true;
    glob.(warningProp) = true;
    return !weNeedToGiveWarning;  
  }
  specificHintState = 0
  giveHint {
    glob.(generalHintProp)++;
    // If we need to give general hints for this whole maze,
    // then do so.
    if (bot.getOutermostRoom == firstRoomInThisMazeSet
        && glob.(generalHintProp) < 4) {
      switch (glob.(generalHintProp)) {
        case 1:
          "Sheila says, <.q>First of all, 
            if you examine the statue in this room, 
            you<./s>ll find it contains a button. 
            Try pressing the button and see what happens.<./q> ";
          break;
        case 2:
          "Sheila says, <.q>If you try pushing the button 
            on the statue, you<./s>ll hear a voice asking you 
            for a proper magic word. You may have 
            no idea about the magic word, but try guessing. 
            Type <.s>SAY ABRACADABRA<./s>, 
            or something like that.<./q> ";
          if (glob.(potentialScoreProp) > (glob.(initialPsp) - 10))
            glob.(potentialScoreProp) = glob.(initialPsp) - 10;
          break;
        case 3:
          "Sheila says, <.q>When you make a wrong guess 
            about the magic word, the voice not only tells you 
            it<./s>s wrong, but it also tells you 
            <i>why</i> it's wrong. Using that information, 
            make another guess (e.g. <.s>SAY ANCHOVY<./s>), 
            and then another. Hopefully you<./s>ll keep 
            getting closer to a correct answer.<./q> ";
          if (glob.(potentialScoreProp) > (glob.(initialPsp) - 20))
            glob.(potentialScoreProp) = glob.(initialPsp) - 20;
          break;
      }
    }
    // If we need to give specific word hints for this particular room,
    // then do so.
    else if (nextRoom && !forward.isOpen) {
      specificHintState++;
      switch (specificHintState) {
        case 1:
          "Sheila says, <.q>In this room, a proper magic word 
            would be any word that begins in 
            <<aNameFromLetter(asscLetter)>> and ends in 
            <<aNameFromLetter(nextRoom.asscLetter)>>. 
            Also, remember the command format: 
            <.s>SAY WORD<./s>.<./q> ";
          break;
        case 2:
          if (!isVeryEasy && (nextRoom.asscLetter.toUpper != 'S' && nextRoom.asscLetter.toUpper != 'G'))
            "Shiela says, <.q>All right, here<./s>s one idea. ";
          else if (!isVeryEasy)
            "Shiela says, <.q>";
          else if (isVeryEasy && (nextRoom.asscLetter.toUpper != 'S' && nextRoom.asscLetter.toUpper != 'G'))
            "<.q>So you need more help on this one, do you?<./q> 
              says Sheila. <.q>All right, then, here<./s>s
              one idea. ";
          else
            "<.q>So you need more help on this one, do you?<./q> 
              says Sheila. <.q>";
          specificWordHint;
          "<./q> ";
          glob.(potentialScoreProp) = glob.(potentialScoreProp) - 5;
          if (glob.(potentialScoreProp) < 0) glob.(potentialScoreProp) = 0;
          break;
        case 3:
          "Sheila says, <.q>I<./s>ve given you all the hints I can.
            All I can do now is give you the complete solution for this room.
            Is that what you want?<./q> ";
          if (!sayYesOrNo()) {
            "<.q>No problem,<./q> says Sheila. <.q>Back to the game, then!<./q> ";
            specificHintState--;
          }
          else {
            giveCompleteSolution();
          }
          break;
        default:
          giveCompleteSolution();
          break;
      }
    }
    else if (nextRoom) {
      "Sheila says, <.q>I think all we need to do here now
        is go forward.<./q> ";
    }
    else {
      "Sheila says, <.q>I think all we need to do here now 
        is push the button.<./q> ";
    }
  }
  giveCompleteSolution {
    "Sheila says, <.q>Type SAY <<specificWordAnswer.toUpper>>. 
      Of course, that<./s>s just one answer among many.<./q> ";
    glob.(potentialScoreProp) = glob.(potentialScoreProp) - 10;
    if (glob.(potentialScoreProp) < 0) glob.(potentialScoreProp) = 0;
  }
;
modify Room
  isSayingRoom = nil
;
class IntercomRoom: Room
  isSayingRoom = true
;
class TwistyRoom: TwistyEscapeRoom
  bannerValue = twisty
  firstRoomInThisMazeSet = twistyRoomT
  warningProp = &twistyWarningHasBeenSet
  openingProp = &hasSeenTwistyOpening
  generalHintProp = &twistyHintState
  potentialScoreProp = &potentialScoreTwisty
  initialPsp = &initialPotentialScoreTwisty
  resetThisMazeSet {
    glob.twistyWarningHasBeenSet = nil;
    glob.hasSeenTwistyOpening = nil;
    glob.twistyHintState = 0;
    for(local cur=firstObj(TwistyRoom); cur != nil; cur=nextObj(cur,TwistyRoom)) {
      cur.specificHintState = 0;
    }
    for(local cur=firstObj(TwistyPassage); cur != nil; cur=nextObj(cur,TwistyPassage)) {
      cur.makeOpen(nil);
    }
    inherited();
  }
;
modify glob
  twistyWarningHasBeenSet = nil
  escapeWarningHasBeenSet = nil
  hasSeenTwistyOpening = nil
  hasSeenEscapeOpening = nil
  twistyHintState = 0
  escapeHintState = 0
;
class EscapeRoom: TwistyEscapeRoom
  bannerValue = escape
  firstRoomInThisMazeSet = escapeRoomE
  warningProp = &escapeWarningHasBeenSet
  openingProp = &hasSeenEscapeOpening
  generalHintProp = &escapeHintState
  potentialScoreProp = &potentialScoreEscape
  initialPsp = &initialPotentialScoreEscape
  resetThisMazeSet {
    glob.escapeWarningHasBeenSet = nil;
    glob.hasSeenEscapeOpening = nil;
    glob.escapeHintState = 0;
    for(local cur=firstObj(EscapeRoom); cur != nil; cur=nextObj(cur,EscapeRoom)) {
      cur.specificHintState = 0;
    }
    for(local cur=firstObj(EscapePassage); cur != nil; cur=nextObj(cur,EscapePassage)) {
      cur.makeOpen(nil);
    }
    inherited();
  }
;
class TwistyIntercomRoom: TwistyRoom, IntercomRoom
;
class EscapeIntercomRoom: EscapeRoom, IntercomRoom
;

class TeLetterRoom: Room
  roomName = (asscLetter + ' Room')
;

class TeLetterRoomA: TeLetterRoom
  asscLetter = 'A'
  teRoomAdj = 'astonishing'
  teWallsAdj = 'angling'
  teVerbPhrase = 'arc and curve'
;
class TeLetterRoomB: TeLetterRoom
  asscLetter = 'B'
  teRoomAdj = 'bizarre'
  teWallsAdj = 'brilliant'
  teVerbPhrase = 'bend and curve'
;
class TeLetterRoomC: TeLetterRoom
  asscLetter = 'C'
  teRoomAdj = 'cavernous'
  teWallsAdj = 'curious'
  teVerbPhrase = 'coil and curve'
;
class TeLetterRoomD: TeLetterRoom
  asscLetter = 'D'
  teRoomAdj = 'D'
  teWallsAdj = 'D'
  teVerbPhrase = 'D'
;
class TeLetterRoomE: TeLetterRoom
  asscLetter = 'E'
  teRoomAdj = 'eerie'
  teWallsAdj = 'elliptical'
  teVerbPhrase = 'are extremely curved'
;
class TeLetterRoomF: TeLetterRoom
  asscLetter = 'F'
  teRoomAdj = 'F'
  teWallsAdj = 'F'
  teVerbPhrase = 'F'
;
class TeLetterRoomG: TeLetterRoom
  asscLetter = 'G'
  teRoomAdj = 'giant'
  teWallsAdj = 'gleaming'
  teVerbPhrase = 'glide and curve'
;
class TeLetterRoomH: TeLetterRoom
  asscLetter = 'H'
  teRoomAdj = 'huge'
  teWallsAdj = 'high'
  teVerbPhrase = 'hook and curve'
;
class TeLetterRoomI: TeLetterRoom
  asscLetter = 'I'
  teRoomAdj = 'imposing'
  teWallsAdj = 'iridescent'
  teVerbPhrase = 'are immensely curved'
;
class TeLetterRoomJ: TeLetterRoom
  asscLetter = 'J'
  teRoomAdj = 'J'
  teWallsAdj = 'J'
  teVerbPhrase = 'J'
;
class TeLetterRoomK: TeLetterRoom
  asscLetter = 'K'
  teRoomAdj = 'K'
  teWallsAdj = 'K'
  teVerbPhrase = 'K'
;
class TeLetterRoomL: TeLetterRoom
  asscLetter = 'L'
  teRoomAdj = 'large'
  teWallsAdj = 'luminous'
  teVerbPhrase = 'loop and curve'
;
class TeLetterRoomM: TeLetterRoom
  asscLetter = 'M'
  teRoomAdj = 'M'
  teWallsAdj = 'M'
  teVerbPhrase = 'M'
;
class TeLetterRoomN: TeLetterRoom
  asscLetter = 'N'
  teRoomAdj = 'nebulous'
  teWallsAdj = 'numberless'
  teVerbPhrase = 'narrow and widen'
;
class TeLetterRoomO: TeLetterRoom
  asscLetter = 'O'
  teRoomAdj = 'O'
  teWallsAdj = 'O'
  teVerbPhrase = 'O'
;
class TeLetterRoomP: TeLetterRoom
  asscLetter = 'P'
  teRoomAdj = 'peculiar'
  teWallsAdj = 'polished'
  teVerbPhrase = 'plunge and curve'
;
class TeLetterRoomQ: TeLetterRoom
  asscLetter = 'Q'
  teRoomAdj = 'Q'
  teWallsAdj = 'Q'
  teVerbPhrase = 'Q'
;
class TeLetterRoomR: TeLetterRoom
  asscLetter = 'R'
  teRoomAdj = 'round'
  teWallsAdj = 'radiant'
  teVerbPhrase = 'roll and curve'
;
class TeLetterRoomS: TeLetterRoom
  asscLetter = 'S'
  teRoomAdj = 'strange'
  teWallsAdj = 'shimmering'
  teVerbPhrase = 'slope and swerve'
;
class TeLetterRoomT: TeLetterRoom
  asscLetter = 'T'
  teRoomAdj = 'tall'
  teWallsAdj = 'twinkling'
  teVerbPhrase = 'twist and turn'
;
class TeLetterRoomU: TeLetterRoom
  asscLetter = 'U'
  teRoomAdj = 'U'
  teWallsAdj = 'U'
  teVerbPhrase = 'U'
;
class TeLetterRoomV: TeLetterRoom
  asscLetter = 'V'
  teRoomAdj = 'V'
  teWallsAdj = 'V'
  teVerbPhrase = 'V'
;
class TeLetterRoomW: TeLetterRoom
  asscLetter = 'W'
  teRoomAdj = 'weird'
  teWallsAdj = 'wide'
  teVerbPhrase = 'wind and curve'
;
class TeLetterRoomX: TeLetterRoom
  asscLetter = 'X'
  teRoomAdj = 'X'
  teWallsAdj = 'X'
  teVerbPhrase = 'X'
;
class TeLetterRoomY: TeLetterRoom
  asscLetter = 'Y'
  teRoomAdj = 'yawning'
  teWallsAdj = 'yielding'
  teVerbPhrase = 'curve away from your bot'
;
class TeLetterRoomZ: TeLetterRoom
  asscLetter = 'Z'
  teRoomAdj = 'Z'
  teWallsAdj = 'Z'
  teVerbPhrase = 'Z'
;

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: ROOMS, ETC: ROOMS
// -------------------------------------------------------------------

twistyRoomT: TwistyIntercomRoom, TeLetterRoomT
  forward  = twiForwPassTW
  
  teFilename = 'text/tedataTW.txt'
;
twistyRoomTw: TwistyIntercomRoom, TeLetterRoomW
  backward = twiBackPassTW
  forward  = twiForwPassWI
  teFilename = 'text/tedataWI.txt'
;
twistyRoomTwi: TwistyIntercomRoom, TeLetterRoomI
  backward = twiBackPassWI
  forward  = twiForwPassIS
  teFilename = 'text/tedataIS.txt'
;
twistyRoomTwis: TwistyIntercomRoom, TeLetterRoomS
  backward = twiBackPassIS
  forward  = twiForwPassST
  teFilename = 'text/tedataST.txt'
;
twistyRoomTwist: TwistyIntercomRoom, TeLetterRoomT
  backward = twiBackPassST
  forward  = twiForwPassTY
  teFilename = 'text/tedataTY.txt'
;
twistyRoomTwisty: TwistyIntercomRoom, TeLetterRoomY
  backward = twiBackPassTY
  forward  = twiForwPassYL
  teFilename = 'text/tedataYL.txt'
;
twistyRoomL: TwistyIntercomRoom, TeLetterRoomL
  backward = twiBackPassYL
  forward  = twiForwPassLI
  teFilename = 'text/tedataLI.txt'
;
twistyRoomLi: TwistyIntercomRoom, TeLetterRoomI
  backward = twiBackPassLI
  forward  = twiForwPassIT
  teFilename = 'text/tedataIT.txt'
;
twistyRoomLit: TwistyIntercomRoom, TeLetterRoomT
  backward = twiBackPassIT
  forward  = twiForwPassTT
  teFilename = 'text/tedataTT.txt'
;
twistyRoomLitt: TwistyIntercomRoom, TeLetterRoomT
  backward = twiBackPassTT
  forward  = twiForwPassTL
  teFilename = 'text/tedataTL.txt'
;
twistyRoomLittl: TwistyIntercomRoom, TeLetterRoomL
  backward = twiBackPassTL
  forward  = twiForwPassLE
  teFilename = 'text/tedataLE.txt'
;
twistyRoomLittle: TwistyIntercomRoom, TeLetterRoomE
  backward = twiBackPassLE
  forward  = twiForwPassEP
  teFilename = 'text/tedataEP.txt'
;
twistyRoomP: TwistyIntercomRoom, TeLetterRoomP
  backward = twiBackPassEP
  forward  = twiForwPassPA
  teFilename = 'text/tedataPA.txt'
;
twistyRoomPa: TwistyIntercomRoom, TeLetterRoomA
  backward = twiBackPassPA
  forward  = twiForwPassAS
  teFilename = 'text/tedataAS.txt'
;
twistyRoomPas: TwistyIntercomRoom, TeLetterRoomS
  backward = twiBackPassAS
  forward  = twiForwPassSS
  teFilename = 'text/tedataSS.txt'
;
twistyRoomPass: TwistyIntercomRoom, TeLetterRoomS
  backward = twiBackPassSS
  forward  = twiForwPassSA
  teFilename = 'text/tedataSA.txt'
;
twistyRoomPassa: TwistyIntercomRoom, TeLetterRoomA
  backward = twiBackPassSA
  forward  = twiForwPassAG
  teFilename = 'text/tedataAG.txt'
;
twistyRoomPassag: TwistyIntercomRoom, TeLetterRoomG
  backward = twiBackPassAG
  forward  = twiForwPassGE
  teFilename = 'text/tedataGE.txt'
;
twistyRoomPassage: TwistyIntercomRoom, TeLetterRoomE
  backward = twiBackPassGE
  forward  = twiForwPassES
  teFilename = 'text/tedataES.txt'
;
twistyRoomPassages: TwistyRoom, TeLetterRoomS
  backward = twiBackPassES
  
  teFilename = nil
;

escapeRoomE: EscapeIntercomRoom, TeLetterRoomE
  forward  = escForwPassES
  
  teFilename = 'text/tedataES.txt'
;
escapeRoomEs: EscapeIntercomRoom, TeLetterRoomS
  backward = escBackPassES
  forward  = escForwPassSC
  teFilename = 'text/tedataSC.txt'
;
escapeRoomEsc: EscapeIntercomRoom, TeLetterRoomC
  backward = escBackPassSC
  forward  = escForwPassCA
  teFilename = 'text/tedataCA.txt'
;
escapeRoomEsca: EscapeIntercomRoom, TeLetterRoomA
  backward = escBackPassCA
  forward  = escForwPassAP
  teFilename = 'text/tedataAP.txt'
;
escapeRoomEscap: EscapeIntercomRoom, TeLetterRoomP
  backward = escBackPassAP
  forward  = escForwPassPE
  teFilename = 'text/tedataPE.txt'
;
escapeRoomEscape: EscapeIntercomRoom, TeLetterRoomE
  backward = escBackPassPE
  forward  = escForwPassET
  teFilename = 'text/tedataET.txt'
;
escapeRoomT: EscapeIntercomRoom, TeLetterRoomT
  backward = escBackPassET
  forward  = escForwPassTH1
  teFilename = 'text/tedataTH.txt'
;
escapeRoomTh: EscapeIntercomRoom, TeLetterRoomH
  backward = escBackPassTH1
  forward  = escForwPassHI
  teFilename = 'text/tedataHI.txt'
;
escapeRoomThi: EscapeIntercomRoom, TeLetterRoomI
  backward = escBackPassHI
  forward  = escForwPassIS
  teFilename = 'text/tedataIS.txt'
;
escapeRoomThis: EscapeIntercomRoom, TeLetterRoomS
  backward = escBackPassIS
  forward  = escForwPassSL
  teFilename = 'text/tedataSL.txt'
;
escapeRoomL: EscapeIntercomRoom, TeLetterRoomL
  backward = escBackPassSL
  forward  = escForwPassLA
  teFilename = 'text/tedataLA.txt'
;
escapeRoomLa: EscapeIntercomRoom, TeLetterRoomA
  backward = escBackPassLA
  forward  = escForwPassAB
  teFilename = 'text/tedataAB.txt'
;
escapeRoomLab: EscapeIntercomRoom, TeLetterRoomB
  backward = escBackPassAB
  forward  = escForwPassBY
  teFilename = 'text/tedataBY.txt'
;
escapeRoomLaby: EscapeIntercomRoom, TeLetterRoomY
  backward = escBackPassBY
  forward  = escForwPassYR
  teFilename = 'text/tedataYR.txt'
;
escapeRoomLabyr: EscapeIntercomRoom, TeLetterRoomR
  backward = escBackPassYR
  forward  = escForwPassRI
  teFilename = 'text/tedataRI.txt'
;
escapeRoomLabyri: EscapeIntercomRoom, TeLetterRoomI
  backward = escBackPassRI
  forward  = escForwPassIN
  teFilename = 'text/tedataIN.txt'
;
escapeRoomLabyrin: EscapeIntercomRoom, TeLetterRoomN
  backward = escBackPassIN
  forward  = escForwPassNT
  teFilename = 'text/tedataNT.txt'
;
escapeRoomLabyrint: EscapeIntercomRoom, TeLetterRoomT
  backward = escBackPassNT
  forward  = escForwPassTH2
  teFilename = 'text/tedataTH.txt'
;
escapeRoomLabyrinth: EscapeRoom, TeLetterRoomH
  
  backward = escBackPassTH2
  teFilename = nil
;

modify twistyRoomT
  specificWordHint = "Think of a candle material."
  specificWordAnswer = 'TALLOW'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomTw
  specificWordHint = "Think of a Japanese condiment. Or, if you want, think of a collaborative web site."
  specificWordAnswer = 'WASABI'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomTwi
  specificWordHint = "Well, a lot of plural nouns would work here. Or, if you want to be different, think of an eye part."
  specificWordAnswer = 'IRIS'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomTwis
  specificWordHint = "Think of a common condiment."
  specificWordAnswer = 'SALT'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomTwist
  specificWordHint = "Think of a something that might hold a dinner plate."
  specificWordAnswer = 'TRAY'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomTwisty
  specificWordHint = "Think of a shout."
  specificWordAnswer = 'YELL'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomL
  specificWordHint = "Think of a kind of pasta."
  specificWordAnswer = 'LINGUINI'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomLi
  specificWordHint = "Think of a mentally challenged person."
  specificWordAnswer = 'IDIOT'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomLit
  specificWordHint = "Think of a piece of camping equipment."
  specificWordAnswer = 'TENT'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomLitt
  specificWordHint = "Think of a word that means <.s>high.<./s>"
  specificWordAnswer = 'TALL'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomLittl
  specificWordHint = "Think of a body of water."
  specificWordAnswer = 'LAKE'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomLittle
  specificWordHint = "Think of a verb that contains the letter Q."
  specificWordAnswer = 'EQUIP'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomP
  specificWordHint = "Think of a large Chinese animal."
  specificWordAnswer = 'PANDA'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPa
  specificWordHint = "Well, a lot of plural nouns would work here. Or, if you want to be different, think of a map book."
  specificWordAnswer = 'ATLAS'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPas
  specificWordHint = "For crying out loud, just pick any plural beginning with S!<./q> Then, musing, she adds, <.q>Well, not sarcophagi. And not seraphim, either. But you get the point."
  specificWordAnswer = 'SEAMSTRESSES'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPass
  specificWordHint = "Think of a room with dry or wet heat."
  specificWordAnswer = 'SAUNA'
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPassa
  specificWordHint = "Well, a lot of -ing verbs would work here. Or, if you want to be different, there are a couple of prepositions that would work."
  specificWordAnswer = 'AMONG'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPassag
  specificWordHint = "Think of a strong wind."
  specificWordAnswer = 'GALE'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPassage
  specificWordHint = "Well, a lot of plural nouns would work here. Or if you want to be different, think of a woman who outranks a queen."
  specificWordAnswer = 'EMPRESS'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify twistyRoomPassages
;

modify escapeRoomE
  specificWordHint = "A lot of plural nouns would work here. Or if you want to be different, think of a woman who outranks a queen."
  specificWordAnswer = 'EMPRESS'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomEs
  specificWordHint = "Think of an adjective for auditory stuff."
  specificWordAnswer = 'SONIC'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomEsc
  specificWordHint = "Think of something that contains film."
  specificWordAnswer = 'CAMERA'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomEsca
  specificWordHint = "Think of an adjective for somebody taking a nap."
  specificWordAnswer = 'ASLEEP'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomEscap
  specificWordHint = "Think of a kind of tree."
  specificWordAnswer = 'PINE'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomEscape
  specificWordHint = "Think of a direction."
  specificWordAnswer = 'EAST'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomT
  specificWordHint = "Think of a chewing tool."
  specificWordAnswer = 'TOOTH'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomTh
  specificWordHint = "Think of a greeting. Or, if you want, think of a number of African mammals."
  specificWordAnswer = 'HIPPOPOTAMI'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomThi
  specificWordHint = "Well, a lot of plural nouns would work here. Or, if you want to be different, think of an eye part."
  specificWordAnswer = 'IRIS'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomThis
  specificWordHint = "Think of an accoutrement for a mast."
  specificWordAnswer = 'SAIL'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomL
  specificWordHint = "Think of a large South American mammal."
  specificWordAnswer = 'LLAMA'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLa
  specificWordHint = "Think of a part of speech."
  specificWordAnswer = 'ADVERB'
  //wordList = []
  capitalizedWordList = ['arab']
;
modify escapeRoomLab
  specificWordHint = "Think of a small child."
  specificWordAnswer = 'BABY'
  isVeryEasy = true
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLaby
  specificWordHint = "Think of a long period of time."
  specificWordAnswer = 'YEAR'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLabyr
  specificWordHint = "Think of a kind of pasta."
  specificWordAnswer = 'RAVIOLI'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLabyri
  specificWordHint = "Think of a kind of metal."
  specificWordAnswer = 'IRON'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLabyrin
  specificWordHint = "Think of a bird<./s>s home."
  specificWordAnswer = 'NEST'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLabyrint
  specificWordHint = "Think of a chewing tool."
  specificWordAnswer = 'TOOTH'
  //wordList = []
  //capitalizedWordList = []
;
modify escapeRoomLabyrinth
;


// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: ROOMS, ETC: PASSAGES
// -------------------------------------------------------------------

class TwistyEscapePassage: HiddenDoor, Fixture
;
class TwistyPassage: TwistyEscapePassage;
class EscapePassage: TwistyEscapePassage;
class ForwardPassage: TwistyEscapePassage
  //initiallyOpen = true
;
class BackwardPassage: TwistyEscapePassage;
class TwiForwPass: ForwardPassage, TwistyPassage;
class TwiBackPass: BackwardPassage, TwistyPassage;
class EscForwPass: ForwardPassage, EscapePassage;
class EscBackPass: BackwardPassage, EscapePassage;

twiForwPassTW:  TwiForwPass location=twistyRoomT        ;
twiForwPassWI:  TwiForwPass location=twistyRoomTw       ;
twiForwPassIS:  TwiForwPass location=twistyRoomTwi      ;
twiForwPassST:  TwiForwPass location=twistyRoomTwis     ;
twiForwPassTY:  TwiForwPass location=twistyRoomTwist    ;
twiForwPassYL:  TwiForwPass location=twistyRoomTwisty   ;
twiForwPassLI:  TwiForwPass location=twistyRoomL        ;
twiForwPassIT:  TwiForwPass location=twistyRoomLi       ;
twiForwPassTT:  TwiForwPass location=twistyRoomLit      ;
twiForwPassTL:  TwiForwPass location=twistyRoomLitt     ;
twiForwPassLE:  TwiForwPass location=twistyRoomLittl    ;
twiForwPassEP:  TwiForwPass location=twistyRoomLittle   ;
twiForwPassPA:  TwiForwPass location=twistyRoomP        ;
twiForwPassAS:  TwiForwPass location=twistyRoomPa       ;
twiForwPassSS:  TwiForwPass location=twistyRoomPas      ;
twiForwPassSA:  TwiForwPass location=twistyRoomPass     ;
twiForwPassAG:  TwiForwPass location=twistyRoomPassa    ;
twiForwPassGE:  TwiForwPass location=twistyRoomPassag   ;
twiForwPassES:  TwiForwPass location=twistyRoomPassage  ;
escForwPassES:  EscForwPass location=escapeRoomE        ;
escForwPassSC:  EscForwPass location=escapeRoomEs       ;
escForwPassCA:  EscForwPass location=escapeRoomEsc      ;
escForwPassAP:  EscForwPass location=escapeRoomEsca     ;
escForwPassPE:  EscForwPass location=escapeRoomEscap    ;
escForwPassET:  EscForwPass location=escapeRoomEscape   ;
escForwPassTH1: EscForwPass location=escapeRoomT        ;
escForwPassHI:  EscForwPass location=escapeRoomTh       ;
escForwPassIS:  EscForwPass location=escapeRoomThi      ;
escForwPassSL:  EscForwPass location=escapeRoomThis     ;
escForwPassLA:  EscForwPass location=escapeRoomL        ;
escForwPassAB:  EscForwPass location=escapeRoomLa       ;
escForwPassBY:  EscForwPass location=escapeRoomLab      ;
escForwPassYR:  EscForwPass location=escapeRoomLaby     ;
escForwPassRI:  EscForwPass location=escapeRoomLabyr    ;
escForwPassIN:  EscForwPass location=escapeRoomLabyri   ;
escForwPassNT:  EscForwPass location=escapeRoomLabyrin  ;
escForwPassTH2: EscForwPass location=escapeRoomLabyrint ;
twiBackPassTW: TwiBackPass -> twiForwPassTW  location=twistyRoomTw       ;
twiBackPassWI: TwiBackPass -> twiForwPassWI  location=twistyRoomTwi      ;
twiBackPassIS: TwiBackPass -> twiForwPassIS  location=twistyRoomTwis     ;
twiBackPassST: TwiBackPass -> twiForwPassST  location=twistyRoomTwist    ;
twiBackPassTY: TwiBackPass -> twiForwPassTY  location=twistyRoomTwisty   ;
twiBackPassYL: TwiBackPass -> twiForwPassYL  location=twistyRoomL        ;
twiBackPassLI: TwiBackPass -> twiForwPassLI  location=twistyRoomLi       ;
twiBackPassIT: TwiBackPass -> twiForwPassIT  location=twistyRoomLit      ;
twiBackPassTT: TwiBackPass -> twiForwPassTT  location=twistyRoomLitt     ;
twiBackPassTL: TwiBackPass -> twiForwPassTL  location=twistyRoomLittl    ;
twiBackPassLE: TwiBackPass -> twiForwPassLE  location=twistyRoomLittle   ;
twiBackPassEP: TwiBackPass -> twiForwPassEP  location=twistyRoomP        ;
twiBackPassPA: TwiBackPass -> twiForwPassPA  location=twistyRoomPa       ;
twiBackPassAS: TwiBackPass -> twiForwPassAS  location=twistyRoomPas      ;
twiBackPassSS: TwiBackPass -> twiForwPassSS  location=twistyRoomPass     ;
twiBackPassSA: TwiBackPass -> twiForwPassSA  location=twistyRoomPassa    ;
twiBackPassAG: TwiBackPass -> twiForwPassAG  location=twistyRoomPassag   ;
twiBackPassGE: TwiBackPass -> twiForwPassGE  location=twistyRoomPassage  ;
twiBackPassES: TwiBackPass -> twiForwPassES  location=twistyRoomPassages ;
escBackPassES: EscBackPass -> escForwPassES  location=escapeRoomEs       ;
escBackPassSC: EscBackPass -> escForwPassSC  location=escapeRoomEsc      ;
escBackPassCA: EscBackPass -> escForwPassCA  location=escapeRoomEsca     ;
escBackPassAP: EscBackPass -> escForwPassAP  location=escapeRoomEscap    ;
escBackPassPE: EscBackPass -> escForwPassPE  location=escapeRoomEscape   ;
escBackPassET: EscBackPass -> escForwPassET  location=escapeRoomT        ;
escBackPassTH1:EscBackPass -> escForwPassTH1 location=escapeRoomTh       ;
escBackPassHI: EscBackPass -> escForwPassHI  location=escapeRoomThi      ;
escBackPassIS: EscBackPass -> escForwPassIS  location=escapeRoomThis     ;
escBackPassSL: EscBackPass -> escForwPassSL  location=escapeRoomL        ;
escBackPassLA: EscBackPass -> escForwPassLA  location=escapeRoomLa       ;
escBackPassAB: EscBackPass -> escForwPassAB  location=escapeRoomLab      ;
escBackPassBY: EscBackPass -> escForwPassBY  location=escapeRoomLaby     ;
escBackPassYR: EscBackPass -> escForwPassYR  location=escapeRoomLabyr    ;
escBackPassRI: EscBackPass -> escForwPassRI  location=escapeRoomLabyri   ;
escBackPassIN: EscBackPass -> escForwPassIN  location=escapeRoomLabyrin  ;
escBackPassNT: EscBackPass -> escForwPassNT  location=escapeRoomLabyrint ;
escBackPassTH2:EscBackPass -> escForwPassTH2 location=escapeRoomLabyrinth;








// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: MISC
// -------------------------------------------------------------------

aNameFromLetter(x) {
  switch (x.toUpper.substr(1,1)) {
    case 'A': return 'an ' + x;
    //case 'B': return 'an ' + x;
    //case 'C': return 'an ' + x;
    //case 'D': return 'an ' + x;
    case 'E': return 'an ' + x;
    case 'F': return 'an ' + x;
    //case 'G': return 'an ' + x;
    case 'H': return 'an ' + x;
    case 'I': return 'an ' + x;
    //case 'J': return 'an ' + x;
    //case 'K': return 'an ' + x;
    case 'L': return 'an ' + x;
    case 'M': return 'an ' + x;
    case 'N': return 'an ' + x;
    case 'O': return 'an ' + x;
    //case 'P': return 'an ' + x;
    //case 'Q': return 'an ' + x;
    case 'R': return 'an ' + x;
    case 'S': return 'an ' + x;
    //case 'T': return 'an ' + x;
    //case 'U': return 'an ' + x;
    //case 'V': return 'an ' + x;
    //case 'W': return 'an ' + x;
    case 'X': return 'an ' + x;
    //case 'Y': return 'an ' + x;
    //case 'Z': return 'an ' + x;
  }
  return 'a ' + x;
}

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: DECORATIONS: SPEAKERS, BUTTONS, WALLS
// -------------------------------------------------------------------

teWalls: RoomPart
  vocabWords = 'angling brilliant curious elliptical gleaming 
    high iridescent luminous numberless polished radiant shimmering 
    twinkling wide yielding wall*walls'
  name = 'walls'
  desc = "The walls here are curved, and they gleam with shimmering
    intensity. "
  isPlural = true
  feelDesc = "Your bot touches one of the walls. It surface gives a bit
    beneath her touch. <.q>That<./s>s 
    really weird!<./q> says Sheila. <.q>It<./s>s not like any wall
    I<./s>ve ever seen!<./q> "
  dobjFor(Attack) {
    verify { }
    action {
      "<.q>Okay!<./q> says Sheila, and she hauls off and punches
        a nearby wall. It gives a little, but soon bends back to
        its original shape. ";
    }
  }
  dobjFor(Hit) asDobjFor(Attack)
;

teButton: MultiLoc, Button, Fixture
  'button'
  '(intercom) button'
  initialLocationClass = TwistyEscapeRoom
  dobjFor(Push) {
    action {
      if (gPlayerChar.getOutermostRoom.ofKind(IntercomRoom) 
          && !gPlayerChar.getOutermostRoom.canGoForward) {
        "Sheila presses the button.
          <p>A voice comes out of the speaker, saying,
            <.q>To get to the next room, just say a proper magic 
            word.<./q>
          <p>Sheila says to you, ";
        if (!gPlayerChar.getOutermostRoom.setWarning)
          "<.q>I have no idea what a <.s>proper magic word<./s>
            is, but if you want me to make a guess, just type
            SAY WORD, for example.<./q> ";
        else
          "<.q>If you want me to guess a word, just type
            SAY WORD, for example.<./q> ";
      }
      else if (gPlayerChar.getOutermostRoom.ofKind(IntercomRoom)) {
        "Sheila presses the button, but nothing seems to happen. ";
      }
      else { // No intercom here. We're ready to exit this maze.
        "Sheila presses the button.
          <p>In a flash, a gigantic trap door opens up 
            beneath Sheila<./s>s feet. 
            She tries to grab for something, but fails, 
            and then she is falling down and down\ .\ .\ . ";
        returnToCaveVictoriously('Mission accomplished.');
      }
    }
  }
;

teSpeaker: MultiLoc, Fixture
  'intercom speaker'
  'intercom'
  "The intercom<./s>s speaker is a rather ordinary, circular affair.
    Beside the speaker is a button. "
  initialLocationClass = IntercomRoom
  soundDesc = "Presently, no sound is coming out of the speaker. "
  dobjFor(Push) remapTo(Push, teButton)
  dobjFor(TalkTo) {
    verify { }
    action {
      "Sheila peers at the intercom, then says, <.q>Hello?<./q>
        <p>A voice comes out of the speaker, saying,
          <.q>What? How can <.s>hello<./s> be a proper magic word? ";
      if (!gPlayerChar.getOutermostRoom.ofKind(TeLetterRoomH))
        "It doesn<./s>t even begin with the letter 
          <<gPlayerChar.getOutermostRoom.asscLetter>>.<./q> ";
      else
        "It doesn<./s>t even end with the letter 
          <<gPlayerChar.getOutermostRoom.nextRoom.asscLetter>>.<./q> ";
      "<p>Sheila says, <.q>Apparently this thing isn<./s>t much
        for conversation. However, if you want me to offer a
        <.s>magic word,<./s> you can just type SAY WORD.<./q> ";
    }
  }
;

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: DECORATIONS: STATUES
// -------------------------------------------------------------------

class TeStatue: MultiLoc, Fixture
  name = 'statue'
  asscRoomClass = initialLocationClass
  specialDesc = "In the middle of this room is a large statue
    shaped like the letter <<asscLetter>>. "
  desc {
    descPrefix;
    ", and is shaped like the letter <<asscLetter>>. 
      It has the same shimmering surface as the walls,
      but unlike the walls, it is as hard as metal. ";
    if (bot.location && bot.location.ofKind(IntercomRoom))
      "On the side of the statue there is an intercom,
        which consists of a speaker and a button. ";
    else
      "On the side of the statue there is a button. ";
  }
  materialNoun = ''
  materialAdj = materialNoun
  anAsscLetter = ('a ' + asscLetter)
;

/*
The huge statue rises up several feet into the air, 
and is shaped like the letter A.
It shimmers, like the walls, but unlike the walls, it is as hard as metal.

A amazing artifact ascends ... 
B big statue bends up ... 
C colossal statue curves up ...
E enormous statue is elevated ...
G gigantic statue goes up ...
H huge statue hangs high above, ...
I immense statue is incredibly high, ...
L large statue looms ...
N noteworthy statue is not what you<./s>d call tiny. ...
P prodigious statue is positioned ...
R remarkable statue rises ...
S sizeable statue soars up ...
T tremendous statue towers ...
W whopping statue rises well into the air ...
Y Before your bot, the statue rises several yards into the air ...
*/

teStatueA: TeStatue
  vocabWords = 'a letter metal statue/sculpture/artifact'
  descPrefix = "The amazing statue ascends several feet into the air"
  asscLetter = 'A' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomA
;
teStatueB: TeStatue
  vocabWords = 'b letter metal statue/sculpture/artifact'
  descPrefix = "The big statue bends up several feet into the air"
  asscLetter = 'B'
  initialLocationClass = TeLetterRoomB
;
teStatueC: TeStatue
  vocabWords = 'c letter metal statue/sculpture/artifact'
  descPrefix = "The colossal statue curves up several feet into the air"
  asscLetter = 'C'
  initialLocationClass = TeLetterRoomC
;
teStatueD: TeStatue
  vocabWords = 'd letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'D'
  initialLocationClass = TeLetterRoomD
;
teStatueE: TeStatue
  vocabWords = 'e letter metal statue/sculpture/artifact'
  descPrefix = "The statue is extremely enormous"
  asscLetter = 'E' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomE
;
teStatueF: TeStatue
  vocabWords = 'f letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'F' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomF
;
teStatueG: TeStatue
  vocabWords = 'g letter metal statue/sculpture/artifact'
  descPrefix = "The gigantic statue goes up several feet into the air"
  asscLetter = 'G'
  initialLocationClass = TeLetterRoomG
;
teStatueH: TeStatue
  vocabWords = 'h letter metal statue/sculpture/artifact'
  descPrefix = "The huge statue hangs high above"
  asscLetter = 'H' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomH
;
teStatueI: TeStatue
  vocabWords = 'i letter metal statue/sculpture/artifact'
  descPrefix = "The immense statue is incredibly high"
  asscLetter = 'I' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomI
;
teStatueJ: TeStatue
  vocabWords = 'j letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'J'
  initialLocationClass = TeLetterRoomJ
;
teStatueK: TeStatue
  vocabWords = 'k letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'K'
  initialLocationClass = TeLetterRoomK
;
teStatueL: TeStatue
  vocabWords = 'l letter metal statue/sculpture/artifact'
  descPrefix = "The large statue looms several feet into the air"
  asscLetter = 'L' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomL
;
teStatueM: TeStatue
  vocabWords = 'm letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'M' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomM
;
teStatueN: TeStatue
  vocabWords = 'n letter metal statue/sculpture/artifact'
  descPrefix = "This noteworthy statue is not what you<./s>d call tiny"
  asscLetter = 'N' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomN
;
teStatueO: TeStatue
  vocabWords = 'o letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'O' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomO
;
teStatueP: TeStatue
  vocabWords = 'p letter metal statue/sculpture/artifact'
  descPrefix = "The prodigious statue rises like a pillar"
  asscLetter = 'P'
  initialLocationClass = TeLetterRoomP
;
teStatueQ: TeStatue // will never be used
  vocabWords = 'q letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'Q'
  initialLocationClass = TeLetterRoomQ
;
teStatueR: TeStatue
  vocabWords = 'r letter metal statue/sculpture/artifact'
  descPrefix = "The remarkable statue rises several feet into the air"
  asscLetter = 'R' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomR
;
teStatueS: TeStatue
  vocabWords = 's letter metal statue/sculpture/artifact'
  descPrefix = "The sizeable statue soars up several feet into the air"
  asscLetter = 'S' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomS
;
teStatueT: TeStatue
  vocabWords = 't letter metal statue/sculpture/artifact'
  descPrefix = "The tremendous statue towers several feet into the air"
  asscLetter = 'T'
  initialLocationClass = TeLetterRoomT
;
teStatueU: TeStatue
  vocabWords = 'u letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'U'
  initialLocationClass = TeLetterRoomU
;
teStatueV: TeStatue
  vocabWords = 'v letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'V'
  initialLocationClass = TeLetterRoomV
;
teStatueW: TeStatue
  vocabWords = 'w letter metal statue/sculpture/artifact'
  descPrefix = "The whopping statue rises well into the air"
  asscLetter = 'W'
  initialLocationClass = TeLetterRoomW
;
teStatueX: TeStatue // will never be used
  vocabWords = 'x letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'X' anAsscLetter=('an '+asscLetter)
  initialLocationClass = TeLetterRoomX
;
teStatueY: TeStatue
  vocabWords = 'y letter metal statue/sculpture/artifact'
  descPrefix = "Before your bot, the statue rises several yards into the air"
  asscLetter = 'Y'
  initialLocationClass = TeLetterRoomY
;
teStatueZ: TeStatue
  vocabWords = 'z letter metal statue/sculpture/artifact'
  descPrefix = ""
  asscLetter = 'Z'
  initialLocationClass = TeLetterRoomZ
;


// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: MAPS: TWISTY MAP
// -------------------------------------------------------------------

function zeroString(x) {
  if (x < 10) return '0' + x;
  else return x;
}

function twistyMapPrint() {
  local a, b, c, d, e, f, g;
  if (twiForwPassES.isOpen) {
    a=4; b=6; c=9; d=11; e=15; f=18; g=20;
  }
  else if (twiForwPassGE.isOpen) {
    a=4; b=6; c=9; d=11; e=15; f=18; g=19;
  }
  else if (twiForwPassAG.isOpen) {
    a=4; b=6; c=9; d=11; e=15; f=18; g=18;
  }
  else if (twiForwPassSA.isOpen) {
    a=4; b=6; c=9; d=11; e=15; f=17; g=0;
  }
  else if (twiForwPassSS.isOpen) {
    a=4; b=6; c=9; d=11; e=15; f=16; g=0;
  }
  else if (twiForwPassAS.isOpen) {
    a=4; b=6; c=9; d=11; e=15; f=15; g=0;
  }
  else if (twiForwPassPA.isOpen) {
    a=4; b=6; c=9; d=11; e=14; f=0; g=0;
  }
  else if (twiForwPassEP.isOpen) {
    a=4; b=6; c=9; d=11; e=13; f=0; g=0;
  }
  else if (twiForwPassLE.isOpen) {
    a=4; b=6; c=9; d=11; e=12; f=0; g=0;
  }
  else if (twiForwPassTL.isOpen) {
    a=4; b=6; c=9; d=11; e=11; f=0; g=0;
  }
  else if (twiForwPassTT.isOpen) {
    a=4; b=6; c=9; d=10; e=0; f=0; g=0;
  }
  else if (twiForwPassIT.isOpen) {
    a=4; b=6; c=9; d=9; e=0; f=0; g=0;
  }
  else if (twiForwPassLI.isOpen) {
    a=4; b=6; c=8; d=0; e=0; f=0; g=0;
  }
  else if (twiForwPassYL.isOpen) {
    a=4; b=6; c=7; d=0; e=0; f=0; g=0;
  }
  else if (twiForwPassTY.isOpen) {
    a=4; b=6; c=6; d=0; e=0; f=0; g=0;
  }
  else if (twiForwPassST.isOpen) {
    a=4; b=5; c=0; d=0; e=0; f=0; g=0;
  }
  else if (twiForwPassIS.isOpen) {
    a=4; b=4; c=0; d=0; e=0; f=0; g=0;
  }
  else if (twiForwPassWI.isOpen) {
    a=3; b=0; c=0; d=0; e=0; f=0; g=0;
  }
  else if (twiForwPassTW.isOpen) {
    a=2; b=0; c=0; d=0; e=0; f=0; g=0;
  }
  else {
    a=1; b=0; c=0; d=0; e=0; f=0; g=0;
  }
  return '<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
    <tr>
      <td><img src=\"twisty/twi-a-' + zeroString(a) + '.png\" width=\"50\" height=\"350\" border=\"0\"></td>
      <td><img src=\"twisty/twi-b-' + zeroString(b) + '.png\" width=\"42\" height=\"350\" border=\"0\"></td>
      <td>
        <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
          <tr>
            <td><img src=\"twisty/twi-f-' + zeroString(f) + '.png\" width=\"125\" height=\"176\" border=\"0\"></td>
          </tr>
          <tr>
            <td><img src=\"twisty/twi-c-' + zeroString(c) + '.png\" width=\"125\" height=\"174\" border=\"0\"></td>
          </tr>
        </table>
      </td>
      <td>
        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
          <tr>
            <td><img src=\"twisty/twi-g-' + zeroString(g) + '.png\" width=\"133\" height=\"131\" border=\"0\"></td>
          </tr>
          <tr>
            <td><img src=\"twisty/twi-e-' + zeroString(e) + '.png\" width=\"133\" height=\"88\" border=\"0\"></td>
          </tr>
          <tr>
            <td><img src=\"twisty/twi-d-' + zeroString(d) + '.png\" width=\"133\" height=\"131\" border=\"0\"></td>
          </tr>
        </table>
      </td>
    </tr>
  </table>'
  + doCompass(aheadBack);
}

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: MAPS: ESCAPE MAP
// -------------------------------------------------------------------

function escapeMapPrint() {
  local str;
  if      (escForwPassTH2.isOpen) str = '19';
  else if (escForwPassNT.isOpen ) str = '18';
  else if (escForwPassIN.isOpen ) str = '17';
  else if (escForwPassRI.isOpen ) str = '16';
  else if (escForwPassYR.isOpen ) str = '15';
  else if (escForwPassBY.isOpen ) str = '14';
  else if (escForwPassAB.isOpen ) str = '13';
  else if (escForwPassLA.isOpen ) str = '12';
  else if (escForwPassSL.isOpen ) str = '11';
  else if (escForwPassIS.isOpen ) str = '10';
  else if (escForwPassHI.isOpen ) str = '09';
  else if (escForwPassTH1.isOpen) str = '08';
  else if (escForwPassET.isOpen ) str = '07';
  else if (escForwPassPE.isOpen ) str = '06';
  else if (escForwPassAP.isOpen ) str = '05';
  else if (escForwPassCA.isOpen ) str = '04';
  else if (escForwPassSC.isOpen ) str = '03';
  else if (escForwPassES.isOpen ) str = '02';
  else                            str = '01';
  //switch (gPlayerChar.getOutermostRoom) {
  //  case escapeRoomE        : str = '01'; break;
  //  case escapeRoomEs       : str = '02'; break;
  //  case escapeRoomEsc      : str = '03'; break;
  //  case escapeRoomEsca     : str = '04'; break;
  //  case escapeRoomEscap    : str = '05'; break;
  //  case escapeRoomEscape   : str = '06'; break;
  //  case escapeRoomT        : str = '07'; break;
  //  case escapeRoomTh       : str = '08'; break;
  //  case escapeRoomThi      : str = '09'; break;
  //  case escapeRoomThis     : str = '10'; break;
  //  case escapeRoomL        : str = '11'; break;
  //  case escapeRoomLa       : str = '12'; break;
  //  case escapeRoomLab      : str = '13'; break;
  //  case escapeRoomLaby     : str = '14'; break;
  //  case escapeRoomLabyr    : str = '15'; break;
  //  case escapeRoomLabyri   : str = '16'; break;
  //  case escapeRoomLabyrin  : str = '17'; break;
  //  case escapeRoomLabyrint : str = '18'; break;
  //  case escapeRoomLabyrinth: str = '19'; break;
  //  default                 : str = '01'; break;
  //}
  return 
'<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
  <tr>
    <td><img src=\"escape/esc' + str + '.png\"border=\"0\"></td>
  </tr>
</table>'
+ doCompass(aheadBack);
}

//function escapeMapPrint() {
//  local a, b, c, d;
//  if (escForwPassTH2.isOpen) {
//    a=6; b=10; c=15; d=19;
//  }
//  else if (escForwPassNT.isOpen) {
//    a=6; b=10; c=15; d=18;
//  }
//  else if (escForwPassIN.isOpen) {
//    a=6; b=10; c=15; d=17;
//  }
//  else if (escForwPassRI.isOpen) {
//    a=6; b=10; c=15; d=16;
//  }
//  else if (escForwPassYR.isOpen) {
//    a=6; b=10; c=15; d=15;
//  }
//  else if (escForwPassBY.isOpen) {
//    a=6; b=10; c=14; d=0;
//  }
//  else if (escForwPassAB.isOpen) {
//    a=6; b=10; c=13; d=0;
//  }
//  else if (escForwPassLA.isOpen) {
//    a=6; b=10; c=12; d=0;
//  }
//  else if (escForwPassSL.isOpen) {
//    a=6; b=10; c=11; d=0;
//  }
//  else if (escForwPassIS.isOpen) {
//    a=6; b=10; c=10; d=0;
//  }
//  else if (escForwPassHI.isOpen) {
//    a=6; b=9; c=0; d=0;
//  }
//  else if (escForwPassTH1.isOpen) {
//    a=6; b=8; c=0; d=0;
//  }
//  else if (escForwPassET.isOpen) {
//    a=6; b=7; c=0; d=0;
//  }
//  else if (escForwPassPE.isOpen) {
//    a=6; b=6; c=0; d=0;
//  }
//  else if (escForwPassAP.isOpen) {
//    a=5; b=0; c=0; d=0;
//  }
//  else if (escForwPassCA.isOpen) {
//    a=4; b=0; c=0; d=0;
//  }
//  else if (escForwPassSC.isOpen) {
//    a=3; b=0; c=0; d=0;
//  }
//  else if (escForwPassES.isOpen) {
//    a=2; b=0; c=0; d=0;
//  }
//  else {
//    a=1; b=0; c=0; d=0;
//  }
//  return '<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//    <tr>
//      <td>
//        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//          <tr>
//            <td><img src=\"escape/esc-b-' + zeroString(b) + '.png\" width=\"176\" height=\"173\" border=\"0\"></td>
//          </tr>
//          <tr>
//            <td><img src=\"escape/esc-a-' + zeroString(a) + '.png\" width=\"176\" height=\"177\" border=\"0\"></td>
//          </tr>
//        </table>
//      </td>
//      <td>
//        <table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">
//          <tr> 
//            <td><img src=\"escape/esc-d-' + zeroString(d) + '.png\" width=\"174\" height=\"128\" border=\"0\"></td>
//          </tr>
//          <tr> 
//            <td><img src=\"escape/esc-c-' + zeroString(c) + '.png\" width=\"174\" height=\"222\" border=\"0\"></td>
//          </tr>
//        </table>
//      </td>
//    </tr>
//  </table>';
//}

// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: ANSWER PARSING
// -------------------------------------------------------------------

enum ansNotApplicable, ansBad, ansGood, ansNonUngulate, ansException;


// -------------------------------------------------------------------
// TWISTY/ESCAPE MAZES: THE DATA OBJECT
// -------------------------------------------------------------------

teData: object
  curListFilename = nil
  curFile = nil
  curList = []
  forgetCurList {
    if (curFile) {
      curFile.closeFile;
    }
    curFile = nil;
    curListFilename = nil;
    curList = [];
  }
  rememberNewList(filename) {
    //local ct = 0;
    local wrd;
    // if any file is currently opened, close it
    forgetCurList;
    curFile = 
      //File.openTextFile(filename, FileAccessRead);
      File.openTextResource(filename);
    curListFilename = filename;
    curList = []; // just to be absolutely sure
    for (;;) {
      wrd = curFile.readFile();
      if (wrd == nil) break;
      if (wrd.endsWith('\n'))
        wrd = wrd.substr(1, wrd.length - 1);
      //local k=0;k=k/k;
      if (wrd.length == 0)
        break;
      curList = curList.append(wrd);
      //ct++;
      //"<<ct>>\n";
      //if (inputManager.getKey(nil,nil) == 'q') {
      //  local k=0; k=k/k;
      //}
    }
    curFile.closeFile;
    curFile = nil;
    //local k=0;k=k/k;
    // curList should now be complete
  }
  isGoodWord(str) {
    str = str.toLower;
    // If the correct word list is already being remembered,
    // then we don't need to re-remember it. Otherwise, remember
    // the correct word list. (We take self.curListFilename to be an 
    // adequate indicator of whether we've got the right word list.)
    if (curListFilename != gActor.getOutermostRoom.teFilename) {
      rememberNewList(gActor.getOutermostRoom.teFilename);
    }
    if (curList.indexOf(str))
      return true;
    if (gActor.getOutermostRoom.wordList.indexOf(str))
      return true;
    else
      return nil;
  }
;


modify TwistyEscapeRoom
  roomAfterAction() {
    if (gActionIs(Say)) {
      //local satisfactory = nil;
      
      // let str be the string we're working it. For starters,
      // make it a lowercase version of the text entered.
      local str = gLiteral.toLower;
      // If the bot can go forward from this room (i.e. has already
      // opened up the applicable passageway) -- OR if the bot will
      // never be able to open up a passageway forward -- then 
      // do nothing special.
      if (canGoForward || !bot.getOutermostRoom.nextRoom) {
        noResponseToSay();
        exit;
      }
      local goodWord = reportIsGoodWord(str);
      if (!goodWord) {
        exit;
      }
      // If we reach this point, presumably str is satisfactory, and we
      // need to open up a passageway to the next room.
      "<p>A voice comes out of the speaker:
        <.q>Yes, <.s><<str>><./s> is a proper magic word!
        Opening the passage\ .\ .\ .<./q> ";
      if (!glob.(bot.getOutermostRoom.openingProp))
        "<p>And all of a sudden, something remarkable happens.
            The walls morph into a new shape, curving away 
            faster and faster, until before long there is 
            a new passage here, leading forward to a new room. 
          <p>Enthralled, Sheila wheels herself tentatively 
            towards the new opening. She reaches out her arm 
            into it and finds that it is no illusion. 
            In a state of fascination,
            she wheels a few feet down the passageway, 
            and then another few feet, until before long 
            she has arrived in the next room. 
          <p>";
      else
        "<p>And once again the walls do their morphing. 
            Before long there is a new passage here, 
            leading forward to a new room.
          <p>As if driven by some outside force, 
            Sheila wheels herself down the passageway 
            into the next room. 
          <p>";
      bot.getOutermostRoom.solveRoom;
      bot.moveIntoForTravel(nextRoom);
      bot.makePosture(standing);
      nestedAction(Look);
      // After doing this, we no longer need to remember the 
      // word list we previously consulted.
      teData.forgetCurList;
      exit;
    }
  }
  nonAlphabetical = static new RexPattern('[^a-zA-Z]')
  nonAlphanumeric = static new RexPattern('[^a-zA-Z0-9]')
  solveRoom {
    if (forward)
      forward.makeOpen(true);
    nbmBanner.updateMe();
    glob.(bot.getOutermostRoom.openingProp) = true;
  }
  // Override this to define new words not in the external .txt files.
  wordList = []
  // Override this to define words that are not correct because
  // they're capitalized (e.g. "Arab"), but should be acknowledged
  // as a "nice try" at least.
  capitalizedWordList = []
  // reportIsGoodWord(str): if a bad word, say so and return nil.
  // Otherwise, return true.
  reportIsGoodWord(str) {
    local satisfactory = nil;
      // If str has any spaces, reject it
      if (str.find(' ')) {
        "<p>A voice comes out of the speaker:
          <.q>What? How can <.s><<str>><./s> be a proper magic word?
          It<./s>s more than one word.<./q> ";
        return nil;
      }
      // if str has anything non-alphabetical, such as 
      // punctuation or numbers, reject it
      if (rexSearch(nonAlphabetical, str)) {
        "<p>A voice comes out of the speaker:
          <.q>What? How can <.s><<str>><./s> be a proper magic word?
          It<./s>s not even a proper word.<./q> ";
        return nil;
      }
      // if str doesn't begin with the right letter, reject it
      if (str.substr(1,1).toLower 
          != bot.getOutermostRoom.asscLetter.toLower) {
        "<p>A voice comes out of the speaker:
          <.q>What? How can <.s><<str>><./s> be a proper magic word?
          It doesn<./s>t even begin with the letter
          <<bot.getOutermostRoom.asscLetter>>.<./q> ";
        return nil;
      }
      // if str doesn't end with the right letter, reject it
      if (str.substr(str.length).toLower 
          != bot.getOutermostRoom.nextRoom.asscLetter.toLower) {
        "<p>A voice comes out of the speaker:
          <.q>What? How can <.s><<str>><./s> be a proper magic word?
          It doesn<./s>t even end with the letter 
          <<bot.getOutermostRoom.nextRoom.asscLetter>>.<./q> ";
        return nil;
      }
      // If none of the above problems happen, then it is time to check
      // str against the word list.
      satisfactory = teData.isGoodWord(str);
      //switch (gActor.getOutermostRoom()) {
      //  case twistyRoomT:         x = twiEscTW.test(gLiteral); break;
      //  case twistyRoomTw:        x = twiEscWI.test(gLiteral); break;
      //  case twistyRoomTwi:       x = twiEscIS.test(gLiteral); break;
      //  case twistyRoomTwis:      x = twiEscST.test(gLiteral); break;
      //  case twistyRoomTwist:     x = twiEscTY.test(gLiteral); break;
      //  case twistyRoomTwisty:    x = twiEscYL.test(gLiteral); break;
      //  case twistyRoomL:         x = twiEscLI.test(gLiteral); break;
      //  case twistyRoomLi:        x = twiEscIT.test(gLiteral); break;
      //  case twistyRoomLit:       x = twiEscTT.test(gLiteral); break;
      //  case twistyRoomLitt:      x = twiEscTL.test(gLiteral); break;
      //  case twistyRoomLittl:     x = twiEscLE.test(gLiteral); break;
      //  case twistyRoomLittle:    x = twiEscEP.test(gLiteral); break;
      //  case twistyRoomP:         x = twiEscPA.test(gLiteral); break;
      //  case twistyRoomPa:        x = twiEscAS.test(gLiteral); break;
      //  case twistyRoomPas:       x = twiEscSS.test(gLiteral); break;
      //  case twistyRoomPass:      x = twiEscSA.test(gLiteral); break;
      //  case twistyRoomPassa:     x = twiEscAG.test(gLiteral); break;
      //  case twistyRoomPassag:    x = twiEscGE.test(gLiteral); break;
      //  case twistyRoomPassage:   x = twiEscES.test(gLiteral); break;
      //  case twistyRoomPassages:  x = ansNotApplicable;        break;
      //  case escapeRoomE:         x = twiEscES.test(gLiteral); break;
      //  case escapeRoomEs:        x = twiEscSC.test(gLiteral); break;
      //  case escapeRoomEsc:       x = twiEscCA.test(gLiteral); break;
      //  case escapeRoomEsca:      x = twiEscAP.test(gLiteral); break;
      //  case escapeRoomEscap:     x = twiEscPE.test(gLiteral); break;
      //  case escapeRoomEscape:    x = twiEscET.test(gLiteral); break;
      //  case escapeRoomT:         x = twiEscTH.test(gLiteral); break;
      //  case escapeRoomTh:        x = twiEscHI.test(gLiteral); break;
      //  case escapeRoomThi:       x = twiEscIS.test(gLiteral); break;
      //  case escapeRoomThis:      x = twiEscSL.test(gLiteral); break;
      //  case escapeRoomL:         x = twiEscLA.test(gLiteral); break;
      //  case escapeRoomLa:        x = twiEscAB.test(gLiteral); break;
      //  case escapeRoomLab:       x = twiEscBY.test(gLiteral); break;
      //  case escapeRoomLaby:      x = twiEscYR.test(gLiteral); break;
      //  case escapeRoomLabyr:     x = twiEscRI.test(gLiteral); break;
      //  case escapeRoomLabyri:    x = twiEscIN.test(gLiteral); break;
      //  case escapeRoomLabyrin:   x = twiEscNT.test(gLiteral); break;
      //  case escapeRoomLabyrint:  x = twiEscTH.test(gLiteral); break;
      //  case escapeRoomLabyrinth: x = ansNotApplicable;        break;
      //  default:                  x = ansNotApplicable;        break;
      //}
      // If str is not satisfactory and is on the list of capitalized 
      // words, say why it's wrong.
      if (!satisfactory && 
          bot.getOutermostRoom.capitalizedWordList.indexOf(str)) {
        "<p>A voice comes out of the speaker:
          <.q>Nice try, but <.s>\^<<str>><./s> is not a real word
          unless it<./s>s capitalized. You<./s>ll
          need to think of a real, uncapitalized word.<./q> ";
        return nil;
      }
      // If str is not satisfactory, say so.
      if (!satisfactory) {
        "<p>A voice comes out of the speaker:
          <.q>What? How can <.s><<str>><./s> be a proper magic word?
          It<./s>s not a word I<./s>ve ever heard of.<./q> ";
        return nil;
      }
      // if str is just a two-letter word or less, reject it
      if (str.length < 4) {
        "<p>A voice comes out of the speaker:
          <.q>What? How can <.s><<str>><./s> be a proper magic word?
          It<./s>s less than four letters long.<./q> ";
        return nil;
      }
      // If none of the above objections are relevant, return true
      // to indicate that it's a good word. 
      return true;
  }
;

/*
isItAGoodCandidate(x, doesGoodFollow) {
  x = twiEscTW.convertToGoodString(x);
  local a; local b;
  if (twiEscTW.isGoodCandidate(x)) {
    a = 'That<./s>s a good candidate. ';
    if (doesGoodFollow) b = 'In fact, '; else b = 'But ';
  }
  else {
    a = 'That is NOT a good candidate. ';
    if (doesGoodFollow) b = 'ERROR: '; else b = 'So ';
  }
  return a + b;
}

class TwiEscDataObject: object
  firstLetter = '' //override
  lastLetter  = '' //override
  // This method was formerly designed to chop off any nonalphabetical
  // characters from the beginning and end of the string.
  // I now see this as undesirable, so I have radically modified
  // this method.
  convertToGoodString(x) {
    x = x.toLower();
    //if (x.length() == 0) return x;
    //for (local a=1; a<=x.length(); ++a) {
    //  if (x.substr(a,1) >= 'a' && x.substr(a,1) <= 'z') {
    //    x = x.substr(a);
    //    break;
    //  }
    //}
    //if (x.length() == 0) return x;
    //for (local a=1; a<=x.length(); ++a) {
    //  if (x.substr((0-a),1) >= 'a' && x.substr((0-a),1) <= 'z') {
    //    x = x.substr(1,x.length()-a+1);
    //    break;
    //  }
    //}
    return x;
  }
  isGoodCandidate(x) {
    if (x.length() < 1) return nil;
    else if (x.substr(1,1) != firstLetter) return nil;
    else if (x.substr(-1) != lastLetter) return nil;
    else {
      for (local c=1; c<=x.length(); ++c) {
        if (x.substr(c,1) < 'a' || x.substr(c,1) > 'z') {
          return nil;
        }
      }
      return true;
    }
  }
  test(x) {
    x = convertToGoodString(x);
    if (!isGoodCandidate(x)) return ansBad;
    if (isGoodWord(x)) return ansGood;
    return ansBad;
  }
  // override this
  isGoodWord(x) {
    return true;
  }
;
*/
/*
twiEscTW: TwiEscDataObject
  firstLetter = 't'
  lastLetter  = 'w'
  isGoodWord(x) {
    if (x == 'tallow') return true;
    if (x == 'taw') return true;
    if (x == 'teleview') return true;
    if (x == 'tew') return true;
    if (x == 'thaw') return true;
    if (x == 'thew') return true;
    if (x == 'thraw') return true;
    if (x == 'threw') return true;
    if (x == 'throw') return true;
    if (x == 'tomorrow') return true;
    if (x == 'tow') return true;
    if (x == 'trow') return true;
    return nil;
  }
;
twiEscWI: TwiEscDataObject
  firstLetter = 'w'
  lastLetter  = 'i'
  isGoodWord(x) {
    // new additions: 2006
    if (x == 'wiki') return true;
    if (x == 'wasabi') return true;
    
    // old
    if (x == 'wadi') return true;
    if (x == 'wakiki') return true;
    if (x == 'wapiti') return true;
    if (x == 'woorali') return true;
    if (x == 'woorari') return true;
    return nil;
  }
;
twiEscIS: TwiEscDataObject
  firstLetter = 'i'
  lastLetter  = 's'
  isGoodWord(x) {
    if (x < 'in') {                     // IA-IM
      if (isGoodWordIA(x)) return true;
      else return nil;
    }
    else if (x < 'ink') {               // INA-INJ
      if (isGoodWordINA(x)) return true;
      else return nil;
    }
    else if (x < 'io') {                // INK-INZ
      if (isGoodWordINK(x)) return true;
      else return nil;
    }
    else {                              // IO-IZ
      if (isGoodWordIO(x)) return true;
      else return nil;
    }
  }
  isGoodWordIA(x) {
    if (x == 'iambics') return true;
    if (x == 'iambs') return true;
    if (x == 'iambus') return true;
    if (x == 'iambuses') return true;
    if (x == 'ibexes') return true;
    if (x == 'ibices') return true;
    if (x == 'ibis') return true;
    if (x == 'ibises') return true;
    if (x == 'icebergs') return true;
    if (x == 'iceblinks') return true;
    if (x == 'iceboats') return true;
    if (x == 'iceboxes') return true;
    if (x == 'icebreakers') return true;
    if (x == 'icecaps') return true;
    if (x == 'icefalls') return true;
    if (x == 'icehouses') return true;
    if (x == 'icekhanas') return true;
    if (x == 'iceless') return true;
    if (x == 'icers') return true;
    if (x == 'ices') return true;
    if (x == 'ichnites') return true;
    if (x == 'ichorous') return true;
    if (x == 'ichors') return true;
    if (x == 'ichs') return true;
    if (x == 'ichthus') return true;
    if (x == 'ichthyologies') return true;
    if (x == 'ichthyologists') return true;
    if (x == 'icicles') return true;
    if (x == 'iciness') return true;
    if (x == 'icinesses') return true;
    if (x == 'icings') return true;
    if (x == 'ickers') return true;
    if (x == 'icones') return true;
    if (x == 'iconoclasms') return true;
    if (x == 'iconoclasts') return true;
    if (x == 'icons') return true;
    if (x == 'icterics') return true;
    if (x == 'icterus') return true;
    if (x == 'icteruses') return true;
    if (x == 'icthiologists') return true;
    if (x == 'ictus') return true;
    if (x == 'ictuses') return true;
    if (x == 'idealess') return true;
    if (x == 'idealisations') return true;
    if (x == 'idealises') return true;
    if (x == 'idealisms') return true;
    if (x == 'idealists') return true;
    if (x == 'idealities') return true;
    if (x == 'idealizations') return true;
    if (x == 'idealizes') return true;
    if (x == 'idealogies') return true;
    if (x == 'ideals') return true;
    if (x == 'ideas') return true;
    if (x == 'ideates') return true;
    if (x == 'ideations') return true;
    if (x == 'idems') return true;
    if (x == 'identifications') return true;
    if (x == 'identifiers') return true;
    if (x == 'identifies') return true;
    if (x == 'identities') return true;
    if (x == 'ideograms') return true;
    if (x == 'ideologies') return true;
    if (x == 'ides') return true;
    if (x == 'idiocies') return true;
    if (x == 'idiolects') return true;
    if (x == 'idioms') return true;
    if (x == 'idiosyncrasies') return true;
    if (x == 'idiotisms') return true;
    if (x == 'idiots') return true;
    if (x == 'idleness') return true;
    if (x == 'idlenesses') return true;
    if (x == 'idlers') return true;
    if (x == 'idles') return true;
    if (x == 'idlesses') return true;
    if (x == 'idocrases') return true;
    if (x == 'idolaters') return true;
    if (x == 'idolatries') return true;
    if (x == 'idolatrous') return true;
    if (x == 'idolisers') return true;
    if (x == 'idolises') return true;
    if (x == 'idolisms') return true;
    if (x == 'idolizers') return true;
    if (x == 'idolizes') return true;
    if (x == 'idols') return true;
    if (x == 'idoneities') return true;
    if (x == 'idoneous') return true;
    if (x == 'ids') return true;
    if (x == 'idylists') return true;
    if (x == 'idyllists') return true;
    if (x == 'idylls') return true;
    if (x == 'idyls') return true;
    if (x == 'iffiness') return true;
    if (x == 'iffinesses') return true;
    if (x == 'ifs') return true;
    if (x == 'igloos') return true;
    if (x == 'iglus') return true;
    if (x == 'ignatias') return true;
    if (x == 'igneous') return true;
    if (x == 'ignifies') return true;
    if (x == 'igniters') return true;
    if (x == 'ignites') return true;
    if (x == 'ignitions') return true;
    if (x == 'ignitors') return true;
    if (x == 'ignitrons') return true;
    if (x == 'ignominies') return true;
    if (x == 'ignominious') return true;
    if (x == 'ignoramus') return true;
    if (x == 'ignoramuses') return true;
    if (x == 'ignorances') return true;
    if (x == 'ignorers') return true;
    if (x == 'ignores') return true;
    if (x == 'iguanas') return true;
    if (x == 'iguanians') return true;
    if (x == 'ihrams') return true;
    if (x == 'ikebanas') return true;
    if (x == 'ikons') return true;
    if (x == 'ileitides') return true;
    if (x == 'ileitis') return true;
    if (x == 'ileus') return true;
    if (x == 'ileuses') return true;
    if (x == 'ilexes') return true;
    if (x == 'iliads') return true;
    if (x == 'ilks') return true;
    if (x == 'illations') return true;
    if (x == 'illatives') return true;
    if (x == 'illegalities') return true;
    if (x == 'illegibilities') return true;
    if (x == 'illegitimacies') return true;
    if (x == 'illiniums') return true;
    if (x == 'illiteracies') return true;
    if (x == 'illiterates') return true;
    if (x == 'illites') return true;
    if (x == 'illness') return true;
    if (x == 'illnesses') return true;
    if (x == 'illogics') return true;
    if (x == 'ills') return true;
    if (x == 'illumes') return true;
    if (x == 'illuminates') return true;
    if (x == 'illuminations') return true;
    if (x == 'illumines') return true;
    if (x == 'illusions') return true;
    if (x == 'illustrates') return true;
    if (x == 'illustrations') return true;
    if (x == 'illustrators') return true;
    if (x == 'illustrious') return true;
    if (x == 'illustriousness') return true;
    if (x == 'illustriousnesses') return true;
    if (x == 'illuviums') return true;
    if (x == 'ilmenites') return true;
    if (x == 'imageries') return true;
    if (x == 'images') return true;
    if (x == 'imaginations') return true;
    if (x == 'imaginers') return true;
    if (x == 'imagines') return true;
    if (x == 'imagisms') return true;
    if (x == 'imagists') return true;
    if (x == 'imagoes') return true;
    if (x == 'imamates') return true;
    if (x == 'imams') return true;
    if (x == 'imarets') return true;
    if (x == 'imaums') return true;
    if (x == 'imbalances') return true;
    if (x == 'imbalmers') return true;
    if (x == 'imbalms') return true;
    if (x == 'imbarks') return true;
    if (x == 'imbeciles') return true;
    if (x == 'imbecilities') return true;
    if (x == 'imbeds') return true;
    if (x == 'imbibers') return true;
    if (x == 'imbibes') return true;
    if (x == 'imbitters') return true;
    if (x == 'imblazes') return true;
    if (x == 'imbodies') return true;
    if (x == 'imboldens') return true;
    if (x == 'imbosoms') return true;
    if (x == 'imbowers') return true;
    if (x == 'imbroglios') return true;
    if (x == 'imbrowns') return true;
    if (x == 'imbrues') return true;
    if (x == 'imbrutes') return true;
    if (x == 'imbues') return true;
    if (x == 'imides') return true;
    if (x == 'imids') return true;
    if (x == 'imines') return true;
    if (x == 'imitates') return true;
    if (x == 'imitations') return true;
    if (x == 'imitators') return true;
    if (x == 'immaterialities') return true;
    if (x == 'immatures') return true;
    if (x == 'immaturities') return true;
    if (x == 'immediacies') return true;
    if (x == 'immensities') return true;
    if (x == 'immerges') return true;
    if (x == 'immerses') return true;
    if (x == 'immersions') return true;
    if (x == 'immeshes') return true;
    if (x == 'immies') return true;
    if (x == 'immigrants') return true;
    if (x == 'immigrates') return true;
    if (x == 'immigrations') return true;
    if (x == 'imminences') return true;
    if (x == 'immingles') return true;
    if (x == 'immixes') return true;
    if (x == 'immobilises') return true;
    if (x == 'immobilities') return true;
    if (x == 'immobilizes') return true;
    if (x == 'immoderacies') return true;
    if (x == 'immodesties') return true;
    if (x == 'immolates') return true;
    if (x == 'immolations') return true;
    if (x == 'immoralities') return true;
    if (x == 'immortalises') return true;
    if (x == 'immortalities') return true;
    if (x == 'immortalizes') return true;
    if (x == 'immortals') return true;
    if (x == 'immovabilities') return true;
    if (x == 'immunes') return true;
    if (x == 'immunisations') return true;
    if (x == 'immunises') return true;
    if (x == 'immunities') return true;
    if (x == 'immunizations') return true;
    if (x == 'immunizes') return true;
    if (x == 'immunologies') return true;
    if (x == 'immunologists') return true;
    if (x == 'immures') return true;
    if (x == 'immutabilities') return true;
    if (x == 'impacters') return true;
    if (x == 'impactors') return true;
    if (x == 'impacts') return true;
    if (x == 'impaints') return true;
    if (x == 'impairers') return true;
    if (x == 'impairments') return true;
    if (x == 'impairs') return true;
    if (x == 'impalas') return true;
    if (x == 'impalements') return true;
    if (x == 'impalers') return true;
    if (x == 'impales') return true;
    if (x == 'impanels') return true;
    if (x == 'imparities') return true;
    if (x == 'imparks') return true;
    if (x == 'imparters') return true;
    if (x == 'impartialities') return true;
    if (x == 'imparts') return true;
    if (x == 'impasses') return true;
    if (x == 'impassivities') return true;
    if (x == 'impastes') return true;
    if (x == 'impastos') return true;
    if (x == 'impatiences') return true;
    if (x == 'impatiens') return true;
    if (x == 'impawns') return true;
    if (x == 'impeaches') return true;
    if (x == 'impeachments') return true;
    if (x == 'impearls') return true;
    if (x == 'impecunious') return true;
    if (x == 'impecuniousness') return true;
    if (x == 'impecuniousnesses') return true;
    if (x == 'impedances') return true;
    if (x == 'impeders') return true;
    if (x == 'impedes') return true;
    if (x == 'impediments') return true;
    if (x == 'impellers') return true;
    if (x == 'impellors') return true;
    if (x == 'impels') return true;
    if (x == 'impends') return true;
    if (x == 'impenetrabilities') return true;
    if (x == 'impenitences') return true;
    if (x == 'imperatives') return true;
    if (x == 'imperfections') return true;
    if (x == 'imperials') return true;
    if (x == 'imperils') return true;
    if (x == 'imperious') return true;
    if (x == 'imperiums') return true;
    if (x == 'impersonates') return true;
    if (x == 'impersonations') return true;
    if (x == 'impersonators') return true;
    if (x == 'impertinences') return true;
    if (x == 'impervious') return true;
    if (x == 'impetigos') return true;
    if (x == 'impetuous') return true;
    if (x == 'impetuousities') return true;
    if (x == 'impetus') return true;
    if (x == 'impetuses') return true;
    if (x == 'imphees') return true;
    if (x == 'impieties') return true;
    if (x == 'impingements') return true;
    if (x == 'impingers') return true;
    if (x == 'impinges') return true;
    if (x == 'impings') return true;
    if (x == 'impious') return true;
    if (x == 'impis') return true;
    if (x == 'impishness') return true;
    if (x == 'impishnesses') return true;
    if (x == 'implacabilities') return true;
    if (x == 'implants') return true;
    if (x == 'implausibilities') return true;
    if (x == 'impleads') return true;
    if (x == 'impledges') return true;
    if (x == 'implementations') return true;
    if (x == 'implements') return true;
    if (x == 'implicates') return true;
    if (x == 'implications') return true;
    if (x == 'implies') return true;
    if (x == 'implodes') return true;
    if (x == 'implorers') return true;
    if (x == 'implores') return true;
    if (x == 'implosions') return true;
    if (x == 'impolicies') return true;
    if (x == 'imponderables') return true;
    if (x == 'impones') return true;
    if (x == 'imporous') return true;
    if (x == 'importations') return true;
    if (x == 'importers') return true;
    if (x == 'imports') return true;
    if (x == 'importunes') return true;
    if (x == 'importunities') return true;
    if (x == 'imposers') return true;
    if (x == 'imposes') return true;
    if (x == 'impositions') return true;
    if (x == 'impossibilities') return true;
    if (x == 'imposters') return true;
    if (x == 'impostors') return true;
    if (x == 'imposts') return true;
    if (x == 'impostures') return true;
    if (x == 'impotences') return true;
    if (x == 'impotencies') return true;
    if (x == 'impotents') return true;
    if (x == 'impoundments') return true;
    if (x == 'impounds') return true;
    if (x == 'impoverishes') return true;
    if (x == 'impoverishments') return true;
    if (x == 'impowers') return true;
    if (x == 'impreciseness') return true;
    if (x == 'imprecisenesses') return true;
    if (x == 'impregabilities') return true;
    if (x == 'impregnates') return true;
    if (x == 'impregnations') return true;
    if (x == 'impregns') return true;
    if (x == 'impresarios') return true;
    if (x == 'impresas') return true;
    if (x == 'impreses') return true;
    if (x == 'impress') return true;
    if (x == 'impresses') return true;
    if (x == 'impressions') return true;
    if (x == 'impressiveness') return true;
    if (x == 'impressivenesses') return true;
    if (x == 'impressments') return true;
    if (x == 'imprests') return true;
    if (x == 'imprimaturs') return true;
    if (x == 'imprimis') return true;
    if (x == 'imprints') return true;
    if (x == 'imprisonments') return true;
    if (x == 'imprisons') return true;
    if (x == 'improbabilities') return true;
    if (x == 'impromptus') return true;
    if (x == 'improprieties') return true;
    if (x == 'improvements') return true;
    if (x == 'improvers') return true;
    if (x == 'improves') return true;
    if (x == 'improvidences') return true;
    if (x == 'improvisations') return true;
    if (x == 'improvisers') return true;
    if (x == 'improvisors') return true;
    if (x == 'imprudences') return true;
    if (x == 'imps') return true;
    if (x == 'impudences') return true;
    if (x == 'impugners') return true;
    if (x == 'impugns') return true;
    if (x == 'impulses') return true;
    if (x == 'impulsions') return true;
    if (x == 'impulsiveness') return true;
    if (x == 'impulsivenesses') return true;
    if (x == 'impunities') return true;
    if (x == 'impurities') return true;
    if (x == 'imputations') return true;
    if (x == 'imputers') return true;
    if (x == 'imputes') return true;
    return nil;
  }
  isGoodWordINA(x) {
    if (x == 'inabilities') return true;
    if (x == 'inaccessibilities') return true;
    if (x == 'inaccuracies') return true;
    if (x == 'inactions') return true;
    if (x == 'inactivates') return true;
    if (x == 'inactivities') return true;
    if (x == 'inadequacies') return true;
    if (x == 'inadvertences') return true;
    if (x == 'inadvertencies') return true;
    if (x == 'inadvisabilities') return true;
    if (x == 'inalienabilities') return true;
    if (x == 'inanes') return true;
    if (x == 'inanimateness') return true;
    if (x == 'inanimatenesses') return true;
    if (x == 'inanities') return true;
    if (x == 'inanitions') return true;
    if (x == 'inappositeness') return true;
    if (x == 'inappositenesses') return true;
    if (x == 'inappropriateness') return true;
    if (x == 'inappropriatenesses') return true;
    if (x == 'inarches') return true;
    if (x == 'inarms') return true;
    if (x == 'inattentions') return true;
    if (x == 'inattentiveness') return true;
    if (x == 'inattentivenesses') return true;
    if (x == 'inaugurates') return true;
    if (x == 'inaugurations') return true;
    if (x == 'inauspicious') return true;
    if (x == 'inbeings') return true;
    if (x == 'inboards') return true;
    if (x == 'inbounds') return true;
    if (x == 'inbreedings') return true;
    if (x == 'inbreeds') return true;
    if (x == 'inbursts') return true;
    if (x == 'incages') return true;
    if (x == 'incandescences') return true;
    if (x == 'incantations') return true;
    if (x == 'incapabilities') return true;
    if (x == 'incapacitates') return true;
    if (x == 'incapacities') return true;
    if (x == 'incarcerates') return true;
    if (x == 'incarcerations') return true;
    if (x == 'incarnations') return true;
    if (x == 'incases') return true;
    if (x == 'incautious') return true;
    if (x == 'incendiaries') return true;
    if (x == 'incenses') return true;
    if (x == 'incentives') return true;
    if (x == 'inceptions') return true;
    if (x == 'inceptors') return true;
    if (x == 'incepts') return true;
    if (x == 'incests') return true;
    if (x == 'incestuous') return true;
    if (x == 'inches') return true;
    if (x == 'inchworms') return true;
    if (x == 'incidences') return true;
    if (x == 'incidentals') return true;
    if (x == 'incidents') return true;
    if (x == 'incinerates') return true;
    if (x == 'incinerators') return true;
    if (x == 'incipits') return true;
    if (x == 'incises') return true;
    if (x == 'incisions') return true;
    if (x == 'incisors') return true;
    if (x == 'incisures') return true;
    if (x == 'incitants') return true;
    if (x == 'incitements') return true;
    if (x == 'inciters') return true;
    if (x == 'incites') return true;
    if (x == 'incivilities') return true;
    if (x == 'inclasps') return true;
    if (x == 'inclemencies') return true;
    if (x == 'inclinations') return true;
    if (x == 'incliners') return true;
    if (x == 'inclines') return true;
    if (x == 'inclips') return true;
    if (x == 'inclosers') return true;
    if (x == 'incloses') return true;
    if (x == 'inclosures') return true;
    if (x == 'includes') return true;
    if (x == 'inclusions') return true;
    if (x == 'incogs') return true;
    if (x == 'incoherences') return true;
    if (x == 'incomers') return true;
    if (x == 'incomes') return true;
    if (x == 'incomings') return true;
    if (x == 'incommodious') return true;
    if (x == 'incompetences') return true;
    if (x == 'incompetencies') return true;
    if (x == 'incompetents') return true;
    if (x == 'incompleteness') return true;
    if (x == 'incompletenesses') return true;
    if (x == 'incongruities') return true;
    if (x == 'incongruous') return true;
    if (x == 'inconnus') return true;
    if (x == 'inconsequences') return true;
    if (x == 'inconsiderateness') return true;
    if (x == 'inconsideratenesses') return true;
    if (x == 'inconsistencies') return true;
    if (x == 'inconspicuous') return true;
    if (x == 'inconstancies') return true;
    if (x == 'incontinences') return true;
    if (x == 'inconveniences') return true;
    if (x == 'incorporates') return true;
    if (x == 'incorporations') return true;
    if (x == 'incorpses') return true;
    if (x == 'incorrectness') return true;
    if (x == 'incorrectnesses') return true;
    if (x == 'incorrigibilities') return true;
    if (x == 'increases') return true;
    if (x == 'incredibilities') return true;
    if (x == 'incredulities') return true;
    if (x == 'incredulous') return true;
    if (x == 'increments') return true;
    if (x == 'incriminates') return true;
    if (x == 'incriminations') return true;
    if (x == 'incross') return true;
    if (x == 'incrosses') return true;
    if (x == 'incrusts') return true;
    if (x == 'incubates') return true;
    if (x == 'incubations') return true;
    if (x == 'incubators') return true;
    if (x == 'incubus') return true;
    if (x == 'incubuses') return true;
    if (x == 'incudes') return true;
    if (x == 'inculcates') return true;
    if (x == 'inculcations') return true;
    if (x == 'incumbencies') return true;
    if (x == 'incumbents') return true;
    if (x == 'incumbers') return true;
    if (x == 'incurious') return true;
    if (x == 'incurs') return true;
    if (x == 'incursions') return true;
    if (x == 'incurves') return true;
    if (x == 'incus') return true;
    if (x == 'incuses') return true;
    if (x == 'indabas') return true;
    if (x == 'indagates') return true;
    if (x == 'indamines') return true;
    if (x == 'indamins') return true;
    if (x == 'indebtedness') return true;
    if (x == 'indebtednesses') return true;
    if (x == 'indecencies') return true;
    if (x == 'indecisions') return true;
    if (x == 'indecisiveness') return true;
    if (x == 'indecisivenesses') return true;
    if (x == 'indecorous') return true;
    if (x == 'indecorousness') return true;
    if (x == 'indecorousnesses') return true;
    if (x == 'indelicacies') return true;
    if (x == 'indemnifications') return true;
    if (x == 'indemnifies') return true;
    if (x == 'indemnities') return true;
    if (x == 'indenes') return true;
    if (x == 'indentations') return true;
    if (x == 'indenters') return true;
    if (x == 'indentors') return true;
    if (x == 'indents') return true;
    if (x == 'indentures') return true;
    if (x == 'indeterminacies') return true;
    if (x == 'indexers') return true;
    if (x == 'indexes') return true;
    if (x == 'indicans') return true;
    if (x == 'indicants') return true;
    if (x == 'indicates') return true;
    if (x == 'indications') return true;
    if (x == 'indicators') return true;
    if (x == 'indices') return true;
    if (x == 'indicias') return true;
    if (x == 'indiciums') return true;
    if (x == 'indictees') return true;
    if (x == 'indicters') return true;
    if (x == 'indictments') return true;
    if (x == 'indictors') return true;
    if (x == 'indicts') return true;
    if (x == 'indifferences') return true;
    if (x == 'indigences') return true;
    if (x == 'indigenes') return true;
    if (x == 'indigenous') return true;
    if (x == 'indigens') return true;
    if (x == 'indigents') return true;
    if (x == 'indigestions') return true;
    if (x == 'indignations') return true;
    if (x == 'indignities') return true;
    if (x == 'indigoes') return true;
    if (x == 'indigoids') return true;
    if (x == 'indigos') return true;
    if (x == 'indirections') return true;
    if (x == 'indirectness') return true;
    if (x == 'indirectnesses') return true;
    if (x == 'indiscretions') return true;
    if (x == 'indispensabilities') return true;
    if (x == 'indispensables') return true;
    if (x == 'indispositions') return true;
    if (x == 'indistinctness') return true;
    if (x == 'indistinctnesses') return true;
    if (x == 'inditers') return true;
    if (x == 'indites') return true;
    if (x == 'indiums') return true;
    if (x == 'individualises') return true;
    if (x == 'individualities') return true;
    if (x == 'individualizes') return true;
    if (x == 'individuals') return true;
    if (x == 'indoctrinates') return true;
    if (x == 'indoctrinations') return true;
    if (x == 'indolences') return true;
    if (x == 'indoles') return true;
    if (x == 'indols') return true;
    if (x == 'indoors') return true;
    if (x == 'indorsees') return true;
    if (x == 'indorsers') return true;
    if (x == 'indorses') return true;
    if (x == 'indorsors') return true;
    if (x == 'indows') return true;
    if (x == 'indoxyls') return true;
    if (x == 'indrafts') return true;
    if (x == 'indris') return true;
    if (x == 'inducements') return true;
    if (x == 'inducers') return true;
    if (x == 'induces') return true;
    if (x == 'inductees') return true;
    if (x == 'inductions') return true;
    if (x == 'inductors') return true;
    if (x == 'inducts') return true;
    if (x == 'indues') return true;
    if (x == 'indulgers') return true;
    if (x == 'indulges') return true;
    if (x == 'indulines') return true;
    if (x == 'indulins') return true;
    if (x == 'indults') return true;
    if (x == 'indurates') return true;
    if (x == 'industrialisations') return true;
    if (x == 'industrialises') return true;
    if (x == 'industrializations') return true;
    if (x == 'industrializes') return true;
    if (x == 'industries') return true;
    if (x == 'industrious') return true;
    if (x == 'industriousness') return true;
    if (x == 'industriousnesses') return true;
    if (x == 'indwells') return true;
    if (x == 'inearths') return true;
    if (x == 'inebriates') return true;
    if (x == 'inebriations') return true;
    if (x == 'ineffectiveness') return true;
    if (x == 'ineffectivenesses') return true;
    if (x == 'ineffectualness') return true;
    if (x == 'ineffectualnesses') return true;
    if (x == 'inelasticities') return true;
    if (x == 'inelegances') return true;
    if (x == 'ineptitudes') return true;
    if (x == 'ineptness') return true;
    if (x == 'ineptnesses') return true;
    if (x == 'inequalities') return true;
    if (x == 'inequities') return true;
    if (x == 'inertias') return true;
    if (x == 'inertness') return true;
    if (x == 'inertnesses') return true;
    if (x == 'inerts') return true;
    if (x == 'inevitabilities') return true;
    if (x == 'inexperiences') return true;
    if (x == 'inexpertness') return true;
    if (x == 'inexpertnesses') return true;
    if (x == 'inexperts') return true;
    if (x == 'infamies') return true;
    if (x == 'infamous') return true;
    if (x == 'infancies') return true;
    if (x == 'infantas') return true;
    if (x == 'infantes') return true;
    if (x == 'infantries') return true;
    if (x == 'infants') return true;
    if (x == 'infarcts') return true;
    if (x == 'infares') return true;
    if (x == 'infatuates') return true;
    if (x == 'infatuations') return true;
    if (x == 'infaunas') return true;
    if (x == 'infeasibilities') return true;
    if (x == 'infecters') return true;
    if (x == 'infections') return true;
    if (x == 'infectious') return true;
    if (x == 'infectors') return true;
    if (x == 'infects') return true;
    if (x == 'infelicities') return true;
    if (x == 'infelicitous') return true;
    if (x == 'infeoffs') return true;
    if (x == 'inferences') return true;
    if (x == 'inferiors') return true;
    if (x == 'infernos') return true;
    if (x == 'inferrers') return true;
    if (x == 'infers') return true;
    if (x == 'infertilities') return true;
    if (x == 'infestations') return true;
    if (x == 'infesters') return true;
    if (x == 'infests') return true;
    if (x == 'infidelities') return true;
    if (x == 'infidels') return true;
    if (x == 'infielders') return true;
    if (x == 'infields') return true;
    if (x == 'infiltrates') return true;
    if (x == 'infiltrations') return true;
    if (x == 'infinites') return true;
    if (x == 'infinities') return true;
    if (x == 'infinitives') return true;
    if (x == 'infinitudes') return true;
    if (x == 'infirmaries') return true;
    if (x == 'infirmities') return true;
    if (x == 'infirms') return true;
    if (x == 'infixes') return true;
    if (x == 'infixions') return true;
    if (x == 'inflamers') return true;
    if (x == 'inflames') return true;
    if (x == 'inflammations') return true;
    if (x == 'inflaters') return true;
    if (x == 'inflates') return true;
    if (x == 'inflators') return true;
    if (x == 'inflections') return true;
    if (x == 'inflects') return true;
    if (x == 'inflexibilities') return true;
    if (x == 'inflictions') return true;
    if (x == 'inflicts') return true;
    if (x == 'inflows') return true;
    if (x == 'influences') return true;
    if (x == 'influents') return true;
    if (x == 'influenzas') return true;
    if (x == 'influxes') return true;
    if (x == 'infolders') return true;
    if (x == 'infolds') return true;
    if (x == 'informalities') return true;
    if (x == 'informants') return true;
    if (x == 'informations') return true;
    if (x == 'informers') return true;
    if (x == 'informs') return true;
    if (x == 'infos') return true;
    if (x == 'infractions') return true;
    if (x == 'infracts') return true;
    if (x == 'infrareds') return true;
    if (x == 'infringements') return true;
    if (x == 'infringes') return true;
    if (x == 'infuriates') return true;
    if (x == 'infusers') return true;
    if (x == 'infuses') return true;
    if (x == 'infusions') return true;
    if (x == 'ingates') return true;
    if (x == 'ingathers') return true;
    if (x == 'ingenious') return true;
    if (x == 'ingeniousness') return true;
    if (x == 'ingeniousnesses') return true;
    if (x == 'ingenues') return true;
    if (x == 'ingenuities') return true;
    if (x == 'ingenuous') return true;
    if (x == 'ingenuousness') return true;
    if (x == 'ingenuousnesses') return true;
    if (x == 'ingests') return true;
    if (x == 'inglenooks') return true;
    if (x == 'ingles') return true;
    if (x == 'inglorious') return true;
    if (x == 'ingots') return true;
    if (x == 'ingrafts') return true;
    if (x == 'ingrains') return true;
    if (x == 'ingrates') return true;
    if (x == 'ingratiates') return true;
    if (x == 'ingratitudes') return true;
    if (x == 'ingredients') return true;
    if (x == 'ingress') return true;
    if (x == 'ingresses') return true;
    if (x == 'ingroups') return true;
    if (x == 'ingrowths') return true;
    if (x == 'ingulfs') return true;
    if (x == 'inhabits') return true;
    if (x == 'inhalants') return true;
    if (x == 'inhalations') return true;
    if (x == 'inhalers') return true;
    if (x == 'inhales') return true;
    if (x == 'inhaulers') return true;
    if (x == 'inhauls') return true;
    if (x == 'inheres') return true;
    if (x == 'inheritances') return true;
    if (x == 'inheritors') return true;
    if (x == 'inherits') return true;
    if (x == 'inhesions') return true;
    if (x == 'inhibitions') return true;
    if (x == 'inhibits') return true;
    if (x == 'inhumanities') return true;
    if (x == 'inhumers') return true;
    if (x == 'inhumes') return true;
    if (x == 'iniquities') return true;
    if (x == 'iniquitous') return true;
    if (x == 'initialisations') return true;
    if (x == 'initialises') return true;
    if (x == 'initializations') return true;
    if (x == 'initializes') return true;
    if (x == 'initials') return true;
    if (x == 'initiates') return true;
    if (x == 'initiations') return true;
    if (x == 'injections') return true;
    if (x == 'injectors') return true;
    if (x == 'injects') return true;
    if (x == 'injudicious') return true;
    if (x == 'injudiciousness') return true;
    if (x == 'injudiciousnesses') return true;
    if (x == 'injunctions') return true;
    if (x == 'injurers') return true;
    if (x == 'injures') return true;
    if (x == 'injuries') return true;
    if (x == 'injurious') return true;
    return nil;
  }
  isGoodWordINK(x) {
    if (x == 'inkberries') return true;
    if (x == 'inkblots') return true;
    if (x == 'inkers') return true;
    if (x == 'inkhorns') return true;
    if (x == 'inkiness') return true;
    if (x == 'inkinesses') return true;
    if (x == 'inkles') return true;
    if (x == 'inkless') return true;
    if (x == 'inklings') return true;
    if (x == 'inkpots') return true;
    if (x == 'inks') return true;
    if (x == 'inkstands') return true;
    if (x == 'inkwells') return true;
    if (x == 'inkwoods') return true;
    if (x == 'inlaces') return true;
    if (x == 'inlanders') return true;
    if (x == 'inlands') return true;
    if (x == 'inlayers') return true;
    if (x == 'inlays') return true;
    if (x == 'inlets') return true;
    if (x == 'inliers') return true;
    if (x == 'inmates') return true;
    if (x == 'inmeshes') return true;
    if (x == 'innards') return true;
    if (x == 'inners') return true;
    if (x == 'innersoles') return true;
    if (x == 'innerves') return true;
    if (x == 'innings') return true;
    if (x == 'innkeepers') return true;
    if (x == 'innless') return true;
    if (x == 'innocences') return true;
    if (x == 'innocents') return true;
    if (x == 'innocuous') return true;
    if (x == 'innovates') return true;
    if (x == 'innovations') return true;
    if (x == 'innovators') return true;
    if (x == 'inns') return true;
    if (x == 'innuendoes') return true;
    if (x == 'innuendos') return true;
    if (x == 'inoculates') return true;
    if (x == 'inoculations') return true;
    if (x == 'inoculums') return true;
    if (x == 'inosites') return true;
    if (x == 'inositols') return true;
    if (x == 'inpatients') return true;
    if (x == 'inpours') return true;
    if (x == 'inputs') return true;
    if (x == 'inquests') return true;
    if (x == 'inquiets') return true;
    if (x == 'inquirers') return true;
    if (x == 'inquires') return true;
    if (x == 'inquiries') return true;
    if (x == 'inquisitions') return true;
    if (x == 'inquisitiveness') return true;
    if (x == 'inquisitivenesses') return true;
    if (x == 'inquisitors') return true;
    if (x == 'inroads') return true;
    if (x == 'inrushes') return true;
    if (x == 'ins') return true;
    if (x == 'insalubrious') return true;
    if (x == 'insanities') return true;
    if (x == 'inscribes') return true;
    if (x == 'inscriptions') return true;
    if (x == 'inscrolls') return true;
    if (x == 'insculps') return true;
    if (x == 'inseams') return true;
    if (x == 'insecticides') return true;
    if (x == 'insects') return true;
    if (x == 'insecurations') return true;
    if (x == 'insecurities') return true;
    if (x == 'insensibilities') return true;
    if (x == 'insensitivities') return true;
    if (x == 'insentiences') return true;
    if (x == 'inserters') return true;
    if (x == 'insertions') return true;
    if (x == 'inserts') return true;
    if (x == 'insets') return true;
    if (x == 'insetters') return true;
    if (x == 'insheaths') return true;
    if (x == 'inshrines') return true;
    if (x == 'insiders') return true;
    if (x == 'insides') return true;
    if (x == 'insidious') return true;
    if (x == 'insidiousness') return true;
    if (x == 'insidiousnesses') return true;
    if (x == 'insights') return true;
    if (x == 'insignias') return true;
    if (x == 'insincerities') return true;
    if (x == 'insinuates') return true;
    if (x == 'insinuations') return true;
    if (x == 'insipidities') return true;
    if (x == 'insipidus') return true;
    if (x == 'insistences') return true;
    if (x == 'insisters') return true;
    if (x == 'insists') return true;
    if (x == 'insnarers') return true;
    if (x == 'insnares') return true;
    if (x == 'insolates') return true;
    if (x == 'insolences') return true;
    if (x == 'insolents') return true;
    if (x == 'insoles') return true;
    if (x == 'insolubilities') return true;
    if (x == 'insolvencies') return true;
    if (x == 'insomnias') return true;
    if (x == 'insouciances') return true;
    if (x == 'insouls') return true;
    if (x == 'inspans') return true;
    if (x == 'inspections') return true;
    if (x == 'inspectors') return true;
    if (x == 'inspects') return true;
    if (x == 'inspheres') return true;
    if (x == 'inspirations') return true;
    if (x == 'inspirers') return true;
    if (x == 'inspires') return true;
    if (x == 'inspirits') return true;
    if (x == 'instabilities') return true;
    if (x == 'installations') return true;
    if (x == 'installments') return true;
    if (x == 'installs') return true;
    if (x == 'instals') return true;
    if (x == 'instances') return true;
    if (x == 'instancies') return true;
    if (x == 'instantaneous') return true;
    if (x == 'instants') return true;
    if (x == 'instars') return true;
    if (x == 'instates') return true;
    if (x == 'insteps') return true;
    if (x == 'instigates') return true;
    if (x == 'instigations') return true;
    if (x == 'instigators') return true;
    if (x == 'instills') return true;
    if (x == 'instils') return true;
    if (x == 'instincts') return true;
    if (x == 'institutes') return true;
    if (x == 'institutions') return true;
    if (x == 'instrokes') return true;
    if (x == 'instructions') return true;
    if (x == 'instructors') return true;
    if (x == 'instructorships') return true;
    if (x == 'instructs') return true;
    if (x == 'instrumentalists') return true;
    if (x == 'instrumentalities') return true;
    if (x == 'instrumentals') return true;
    if (x == 'instrumentations') return true;
    if (x == 'instruments') return true;
    if (x == 'insubordinations') return true;
    if (x == 'insufficiencies') return true;
    if (x == 'insulants') return true;
    if (x == 'insularities') return true;
    if (x == 'insulars') return true;
    if (x == 'insulates') return true;
    if (x == 'insulations') return true;
    if (x == 'insulators') return true;
    if (x == 'insulins') return true;
    if (x == 'insulters') return true;
    if (x == 'insults') return true;
    if (x == 'insurances') return true;
    if (x == 'insurants') return true;
    if (x == 'insureds') return true;
    if (x == 'insurers') return true;
    if (x == 'insures') return true;
    if (x == 'insurgences') return true;
    if (x == 'insurgencies') return true;
    if (x == 'insurgents') return true;
    if (x == 'insurrectionists') return true;
    if (x == 'insurrections') return true;
    if (x == 'inswathes') return true;
    if (x == 'intaglios') return true;
    if (x == 'intakes') return true;
    if (x == 'intangibilities') return true;
    if (x == 'intarsias') return true;
    if (x == 'integers') return true;
    if (x == 'integrals') return true;
    if (x == 'integrates') return true;
    if (x == 'integrities') return true;
    if (x == 'intellects') return true;
    if (x == 'intellectualisms') return true;
    if (x == 'intellectuals') return true;
    if (x == 'intelligibilities') return true;
    if (x == 'intemperances') return true;
    if (x == 'intemperateness') return true;
    if (x == 'intemperatenesses') return true;
    if (x == 'intendeds') return true;
    if (x == 'intenders') return true;
    if (x == 'intends') return true;
    if (x == 'intensifications') return true;
    if (x == 'intensifies') return true;
    if (x == 'intensities') return true;
    if (x == 'intentions') return true;
    if (x == 'intentness') return true;
    if (x == 'intentnesses') return true;
    if (x == 'intents') return true;
    if (x == 'interactions') return true;
    if (x == 'interacts') return true;
    if (x == 'interbreeds') return true;
    if (x == 'interbusiness') return true;
    if (x == 'intercalates') return true;
    if (x == 'intercalations') return true;
    if (x == 'intercampus') return true;
    if (x == 'intercedes') return true;
    if (x == 'interceptions') return true;
    if (x == 'interceptors') return true;
    if (x == 'intercepts') return true;
    if (x == 'intercessions') return true;
    if (x == 'intercessors') return true;
    if (x == 'interchanges') return true;
    if (x == 'interclass') return true;
    if (x == 'intercoms') return true;
    if (x == 'intercourses') return true;
    if (x == 'intercuts') return true;
    if (x == 'interdependences') return true;
    if (x == 'interdictions') return true;
    if (x == 'interdicts') return true;
    if (x == 'interests') return true;
    if (x == 'interfaces') return true;
    if (x == 'interferences') return true;
    if (x == 'interferes') return true;
    if (x == 'interims') return true;
    if (x == 'interiors') return true;
    if (x == 'interjections') return true;
    if (x == 'interjects') return true;
    if (x == 'interlaces') return true;
    if (x == 'interlaps') return true;
    if (x == 'interlards') return true;
    if (x == 'interlays') return true;
    if (x == 'interleaves') return true;
    if (x == 'interlocks') return true;
    if (x == 'interlopers') return true;
    if (x == 'interlopes') return true;
    if (x == 'interludes') return true;
    if (x == 'intermarriages') return true;
    if (x == 'intermarries') return true;
    if (x == 'intermediaries') return true;
    if (x == 'intermediates') return true;
    if (x == 'interments') return true;
    if (x == 'intermingles') return true;
    if (x == 'intermissions') return true;
    if (x == 'intermits') return true;
    if (x == 'intermixes') return true;
    if (x == 'intermixtures') return true;
    if (x == 'internals') return true;
    if (x == 'internationalises') return true;
    if (x == 'internationalisms') return true;
    if (x == 'internationalizes') return true;
    if (x == 'internationals') return true;
    if (x == 'internees') return true;
    if (x == 'internes') return true;
    if (x == 'internists') return true;
    if (x == 'internments') return true;
    if (x == 'interns') return true;
    if (x == 'internships') return true;
    if (x == 'interplays') return true;
    if (x == 'interpolates') return true;
    if (x == 'interpolations') return true;
    if (x == 'interposes') return true;
    if (x == 'interpositions') return true;
    if (x == 'interpretations') return true;
    if (x == 'interpreters') return true;
    if (x == 'interprets') return true;
    if (x == 'interreges') return true;
    if (x == 'interrelatedness') return true;
    if (x == 'interrelatednesses') return true;
    if (x == 'interrelates') return true;
    if (x == 'interrelations') return true;
    if (x == 'interreligious') return true;
    if (x == 'interrogates') return true;
    if (x == 'interrogations') return true;
    if (x == 'interrogatives') return true;
    if (x == 'interrogators') return true;
    if (x == 'interrupters') return true;
    if (x == 'interruptions') return true;
    if (x == 'interrupts') return true;
    if (x == 'inters') return true;
    if (x == 'intersections') return true;
    if (x == 'intersects') return true;
    if (x == 'intersexes') return true;
    if (x == 'intersperses') return true;
    if (x == 'interspersions') return true;
    if (x == 'interstices') return true;
    if (x == 'interties') return true;
    if (x == 'intertwines') return true;
    if (x == 'intervals') return true;
    if (x == 'intervenes') return true;
    if (x == 'interventions') return true;
    if (x == 'interviewers') return true;
    if (x == 'interviews') return true;
    if (x == 'interweaves') return true;
    if (x == 'intestines') return true;
    if (x == 'inthralls') return true;
    if (x == 'inthrals') return true;
    if (x == 'inthrones') return true;
    if (x == 'intimacies') return true;
    if (x == 'intimas') return true;
    if (x == 'intimates') return true;
    if (x == 'intimations') return true;
    if (x == 'intimidates') return true;
    if (x == 'intimidations') return true;
    if (x == 'intines') return true;
    if (x == 'intitles') return true;
    if (x == 'intitules') return true;
    if (x == 'intolerances') return true;
    if (x == 'intombs') return true;
    if (x == 'intonates') return true;
    if (x == 'intonations') return true;
    if (x == 'intoners') return true;
    if (x == 'intones') return true;
    if (x == 'intorts') return true;
    if (x == 'intoxicants') return true;
    if (x == 'intoxicates') return true;
    if (x == 'intoxications') return true;
    if (x == 'intrados') return true;
    if (x == 'intradoses') return true;
    if (x == 'intransigences') return true;
    if (x == 'intransigents') return true;
    if (x == 'intrants') return true;
    if (x == 'intravenous') return true;
    if (x == 'intreats') return true;
    if (x == 'intrenches') return true;
    if (x == 'intrepidities') return true;
    if (x == 'intricacies') return true;
    if (x == 'intrigues') return true;
    if (x == 'introduces') return true;
    if (x == 'introductions') return true;
    if (x == 'introfies') return true;
    if (x == 'introits') return true;
    if (x == 'intromits') return true;
    if (x == 'intros') return true;
    if (x == 'introspections') return true;
    if (x == 'introspects') return true;
    if (x == 'introversions') return true;
    if (x == 'introverts') return true;
    if (x == 'intruders') return true;
    if (x == 'intrudes') return true;
    if (x == 'intrusions') return true;
    if (x == 'intrusiveness') return true;
    if (x == 'intrusivenesses') return true;
    if (x == 'intrusts') return true;
    if (x == 'intubates') return true;
    if (x == 'intuitions') return true;
    if (x == 'intuits') return true;
    if (x == 'inturns') return true;
    if (x == 'intwines') return true;
    if (x == 'intwists') return true;
    if (x == 'inulases') return true;
    if (x == 'inulins') return true;
    if (x == 'inundates') return true;
    if (x == 'inundations') return true;
    if (x == 'inures') return true;
    if (x == 'inurns') return true;
    if (x == 'invaders') return true;
    if (x == 'invades') return true;
    if (x == 'invalidates') return true;
    if (x == 'invalids') return true;
    if (x == 'invars') return true;
    if (x == 'invasions') return true;
    if (x == 'invectives') return true;
    if (x == 'inveighs') return true;
    if (x == 'inveigles') return true;
    if (x == 'inventers') return true;
    if (x == 'inventions') return true;
    if (x == 'inventiveness') return true;
    if (x == 'inventivenesses') return true;
    if (x == 'inventories') return true;
    if (x == 'inventors') return true;
    if (x == 'invents') return true;
    if (x == 'inverities') return true;
    if (x == 'inverses') return true;
    if (x == 'inversions') return true;
    if (x == 'inverters') return true;
    if (x == 'invertibrates') return true;
    if (x == 'invertors') return true;
    if (x == 'inverts') return true;
    if (x == 'investigates') return true;
    if (x == 'investigations') return true;
    if (x == 'investigators') return true;
    if (x == 'investitures') return true;
    if (x == 'investments') return true;
    if (x == 'investors') return true;
    if (x == 'invests') return true;
    if (x == 'inveteracies') return true;
    if (x == 'invidious') return true;
    if (x == 'invigorates') return true;
    if (x == 'invigorations') return true;
    if (x == 'invincibilities') return true;
    if (x == 'inviolabilities') return true;
    if (x == 'invisibilities') return true;
    if (x == 'invitations') return true;
    if (x == 'invitees') return true;
    if (x == 'inviters') return true;
    if (x == 'invites') return true;
    if (x == 'invocates') return true;
    if (x == 'invocations') return true;
    if (x == 'invoices') return true;
    if (x == 'invokers') return true;
    if (x == 'invokes') return true;
    if (x == 'involutes') return true;
    if (x == 'involvements') return true;
    if (x == 'involvers') return true;
    if (x == 'involves') return true;
    if (x == 'inwalls') return true;
    if (x == 'inwards') return true;
    if (x == 'inweaves') return true;
    if (x == 'inwinds') return true;
    if (x == 'inwraps') return true;
    return nil;
  }
  isGoodWordIO(x) {
    if (x == 'iodates') return true;
    if (x == 'iodations') return true;
    if (x == 'iodides') return true;
    if (x == 'iodids') return true;
    if (x == 'iodinates') return true;
    if (x == 'iodines') return true;
    if (x == 'iodins') return true;
    if (x == 'iodisers') return true;
    if (x == 'iodises') return true;
    if (x == 'iodisms') return true;
    if (x == 'iodizers') return true;
    if (x == 'iodizes') return true;
    if (x == 'iodoforms') return true;
    if (x == 'iodols') return true;
    if (x == 'iodophors') return true;
    if (x == 'iodopsins') return true;
    if (x == 'iodous') return true;
    if (x == 'iolites') return true;
    if (x == 'ionicities') return true;
    if (x == 'ionics') return true;
    if (x == 'ionisers') return true;
    if (x == 'ionises') return true;
    if (x == 'ioniums') return true;
    if (x == 'ionizers') return true;
    if (x == 'ionizes') return true;
    if (x == 'ionomers') return true;
    if (x == 'ionones') return true;
    if (x == 'ionospheres') return true;
    if (x == 'ions') return true;
    if (x == 'iotacisms') return true;
    if (x == 'iotas') return true;
    if (x == 'ipecacs') return true;
    if (x == 'ipomoeas') return true;
    if (x == 'irades') return true;
    if (x == 'irascibilities') return true;
    if (x == 'ireless') return true;
    if (x == 'irenics') return true;
    if (x == 'ires') return true;
    if (x == 'irides') return true;
    if (x == 'iridescences') return true;
    if (x == 'iridiums') return true;
    if (x == 'irids') return true;
    if (x == 'iris') return true;
    if (x == 'irises') return true;
    if (x == 'iritis') return true;
    if (x == 'iritises') return true;
    if (x == 'irks') return true;
    if (x == 'ironbarks') return true;
    if (x == 'ironclads') return true;
    if (x == 'ironers') return true;
    if (x == 'irones') return true;
    if (x == 'ironies') return true;
    if (x == 'ironings') return true;
    if (x == 'ironists') return true;
    if (x == 'ironness') return true;
    if (x == 'ironnesses') return true;
    if (x == 'irons') return true;
    if (x == 'ironsides') return true;
    if (x == 'ironwares') return true;
    if (x == 'ironweeds') return true;
    if (x == 'ironwoods') return true;
    if (x == 'ironworkers') return true;
    if (x == 'ironworks') return true;
    if (x == 'irradiates') return true;
    if (x == 'irradiations') return true;
    if (x == 'irrationalities') return true;
    if (x == 'irrationals') return true;
    if (x == 'irreconcilabilities') return true;
    if (x == 'irregularities') return true;
    if (x == 'irregulars') return true;
    if (x == 'irrelevances') return true;
    if (x == 'irreligious') return true;
    if (x == 'irresolutions') return true;
    if (x == 'irresponsibilities') return true;
    if (x == 'irreverences') return true;
    if (x == 'irrigates') return true;
    if (x == 'irrigations') return true;
    if (x == 'irritabilities') return true;
    if (x == 'irritants') return true;
    if (x == 'irritates') return true;
    if (x == 'irritations') return true;
    if (x == 'irrupts') return true;
    if (x == 'is') return true;
    if (x == 'isagoges') return true;
    if (x == 'isagogics') return true;
    if (x == 'isarithms') return true;
    if (x == 'isatines') return true;
    if (x == 'isatins') return true;
    if (x == 'isbas') return true;
    if (x == 'ischemias') return true;
    if (x == 'isinglass') return true;
    if (x == 'islanders') return true;
    if (x == 'islands') return true;
    if (x == 'isleless') return true;
    if (x == 'isles') return true;
    if (x == 'islets') return true;
    if (x == 'isms') return true;
    if (x == 'isobares') return true;
    if (x == 'isobars') return true;
    if (x == 'isobaths') return true;
    if (x == 'isocheims') return true;
    if (x == 'isochimes') return true;
    if (x == 'isochores') return true;
    if (x == 'isochors') return true;
    if (x == 'isochrons') return true;
    if (x == 'isoclines') return true;
    if (x == 'isocracies') return true;
    if (x == 'isogamies') return true;
    if (x == 'isogenies') return true;
    if (x == 'isogloss') return true;
    if (x == 'isoglosses') return true;
    if (x == 'isogonals') return true;
    if (x == 'isogones') return true;
    if (x == 'isogonics') return true;
    if (x == 'isogonies') return true;
    if (x == 'isogons') return true;
    if (x == 'isograms') return true;
    if (x == 'isographs') return true;
    if (x == 'isogrivs') return true;
    if (x == 'isohels') return true;
    if (x == 'isohyets') return true;
    if (x == 'isolates') return true;
    if (x == 'isolations') return true;
    if (x == 'isolators') return true;
    if (x == 'isoleads') return true;
    if (x == 'isolines') return true;
    if (x == 'isologs') return true;
    if (x == 'isologues') return true;
    if (x == 'isomers') return true;
    if (x == 'isometrics') return true;
    if (x == 'isometries') return true;
    if (x == 'isomorphs') return true;
    if (x == 'isonomies') return true;
    if (x == 'isophotes') return true;
    if (x == 'isopleths') return true;
    if (x == 'isopodans') return true;
    if (x == 'isopods') return true;
    if (x == 'isoprenes') return true;
    if (x == 'isosceles') return true;
    if (x == 'isospins') return true;
    if (x == 'isospories') return true;
    if (x == 'isostasies') return true;
    if (x == 'isotachs') return true;
    if (x == 'isotheres') return true;
    if (x == 'isotherms') return true;
    if (x == 'isotones') return true;
    if (x == 'isotopes') return true;
    if (x == 'isotopies') return true;
    if (x == 'isotropies') return true;
    if (x == 'isotypes') return true;
    if (x == 'isozymes') return true;
    if (x == 'isseis') return true;
    if (x == 'issuances') return true;
    if (x == 'issuers') return true;
    if (x == 'issues') return true;
    if (x == 'isthmians') return true;
    if (x == 'isthmus') return true;
    if (x == 'isthmuses') return true;
    if (x == 'istles') return true;
    if (x == 'italicisations') return true;
    if (x == 'italicises') return true;
    if (x == 'italicizations') return true;
    if (x == 'italicizes') return true;
    if (x == 'italics') return true;
    if (x == 'itches') return true;
    if (x == 'itchings') return true;
    if (x == 'itemisations') return true;
    if (x == 'itemisers') return true;
    if (x == 'itemises') return true;
    if (x == 'itemizations') return true;
    if (x == 'itemizers') return true;
    if (x == 'itemizes') return true;
    if (x == 'items') return true;
    if (x == 'iterances') return true;
    if (x == 'iterates') return true;
    if (x == 'iterations') return true;
    if (x == 'itinerants') return true;
    if (x == 'its') return true;
    if (x == 'ivies') return true;
    if (x == 'ivories') return true;
    if (x == 'iwis') return true;
    if (x == 'ixias') return true;
    if (x == 'ixodids') return true;
    if (x == 'ixtles') return true;
    if (x == 'izars') return true;
    if (x == 'izzards') return true;
    return nil;
  }
;
twiEscST: TwiEscDataObject
  firstLetter = 's'
  lastLetter  = 't'
  isGoodWord(x) {
    if (x < 'so') {                     // SA-SN
      if (isGoodWordSA(x)) return true;
      else return nil;
    }
    else {                              // SO-SZ
      if (isGoodWordSO(x)) return true;
      else return nil;
    }
  }
  isGoodWordSA(x) {
    if (x == 'sabbat') return true;
    if (x == 'sabot') return true;
    if (x == 'sacbut') return true;
    if (x == 'sachet') return true;
    if (x == 'sackbut') return true;
    if (x == 'sacrament') return true;
    if (x == 'sacrist') return true;
    if (x == 'sacrosanct') return true;
    if (x == 'saddest') return true;
    if (x == 'sadist') return true;
    if (x == 'safest') return true;
    if (x == 'sagbut') return true;
    if (x == 'sagest') return true;
    if (x == 'sagiest') return true;
    if (x == 'sailboat') return true;
    if (x == 'saint') return true;
    if (x == 'saintliest') return true;
    if (x == 'salariat') return true;
    if (x == 'salient') return true;
    if (x == 'sallet') return true;
    if (x == 'sallowest') return true;
    if (x == 'salt') return true;
    if (x == 'saltant') return true;
    if (x == 'saltest') return true;
    if (x == 'saltiest') return true;
    if (x == 'saltwort') return true;
    if (x == 'samlet') return true;
    if (x == 'sandiest') return true;
    if (x == 'sandlot') return true;
    if (x == 'sandpit') return true;
    if (x == 'sandwort') return true;
    if (x == 'sanest') return true;
    if (x == 'sapient') return true;
    if (x == 'sapphist') return true;
    if (x == 'sappiest') return true;
    if (x == 'sarcenet') return true;
    if (x == 'sarment') return true;
    if (x == 'sarodist') return true;
    if (x == 'sarsenet') return true;
    if (x == 'sassiest') return true;
    if (x == 'sat') return true;
    if (x == 'satanist') return true;
    if (x == 'satinet') return true;
    if (x == 'satirist') return true;
    if (x == 'saturant') return true;
    if (x == 'sauciest') return true;
    if (x == 'sauerkraut') return true;
    if (x == 'sault') return true;
    if (x == 'savagest') return true;
    if (x == 'savant') return true;
    if (x == 'savoriest') return true;
    if (x == 'savouriest') return true;
    if (x == 'sawdust') return true;
    if (x == 'sayest') return true;
    if (x == 'sayst') return true;
    if (x == 'scabbiest') return true;
    if (x == 'scaliest') return true;
    if (x == 'scandent') return true;
    if (x == 'scant') return true;
    if (x == 'scantest') return true;
    if (x == 'scantiest') return true;
    if (x == 'scapegoat') return true;
    if (x == 'scarcest') return true;
    if (x == 'scariest') return true;
    if (x == 'scarlet') return true;
    if (x == 'scarriest') return true;
    if (x == 'scart') return true;
    if (x == 'scat') return true;
    if (x == 'scatt') return true;
    if (x == 'scattiest') return true;
    if (x == 'scent') return true;
    if (x == 'schist') return true;
    if (x == 'schizont') return true;
    if (x == 'schmalziest') return true;
    if (x == 'schuit') return true;
    if (x == 'scientist') return true;
    if (x == 'scilicet') return true;
    if (x == 'sciolist') return true;
    if (x == 'scoot') return true;
    if (x == 'scot') return true;
    if (x == 'scout') return true;
    if (x == 'scraggiest') return true;
    if (x == 'scraggliest') return true;
    if (x == 'scrappiest') return true;
    if (x == 'scratchiest') return true;
    if (x == 'scrawliest') return true;
    if (x == 'scrawniest') return true;
    if (x == 'screechiest') return true;
    if (x == 'screwiest') return true;
    if (x == 'scrimpiest') return true;
    if (x == 'scrimpit') return true;
    if (x == 'script') return true;
    if (x == 'scroggiest') return true;
    if (x == 'scroungiest') return true;
    if (x == 'scrubbiest') return true;
    if (x == 'scruffiest') return true;
    if (x == 'sculpt') return true;
    if (x == 'scummiest') return true;
    if (x == 'scurfiest') return true;
    if (x == 'scurviest') return true;
    if (x == 'scut') return true;
    if (x == 'seaboot') return true;
    if (x == 'seacoast') return true;
    if (x == 'seacraft') return true;
    if (x == 'seafront') return true;
    if (x == 'seagirt') return true;
    if (x == 'sealant') return true;
    if (x == 'seamiest') return true;
    if (x == 'seamount') return true;
    if (x == 'seaport') return true;
    if (x == 'searchlight') return true;
    if (x == 'searest') return true;
    if (x == 'seascout') return true;
    if (x == 'seat') return true;
    if (x == 'seawant') return true;
    if (x == 'secant') return true;
    if (x == 'secret') return true;
    if (x == 'secretariat') return true;
    if (x == 'secretest') return true;
    if (x == 'sect') return true;
    if (x == 'securest') return true;
    if (x == 'sedatest') return true;
    if (x == 'sederunt') return true;
    if (x == 'sedgiest') return true;
    if (x == 'sediment') return true;
    if (x == 'seediest') return true;
    if (x == 'seemliest') return true;
    if (x == 'seepiest') return true;
    if (x == 'segment') return true;
    if (x == 'sejant') return true;
    if (x == 'sejeant') return true;
    if (x == 'select') return true;
    if (x == 'sellout') return true;
    if (x == 'semifinalist') return true;
    if (x == 'semifit') return true;
    if (x == 'semimat') return true;
    if (x == 'semimatt') return true;
    if (x == 'semisoft') return true;
    if (x == 'semitist') return true;
    if (x == 'sennet') return true;
    if (x == 'sennight') return true;
    if (x == 'sennit') return true;
    if (x == 'sensiblest') return true;
    if (x == 'sensualist') return true;
    if (x == 'sent') return true;
    if (x == 'sentient') return true;
    if (x == 'sentiment') return true;
    if (x == 'sentimentalist') return true;
    if (x == 'sept') return true;
    if (x == 'septet') return true;
    if (x == 'septuplet') return true;
    if (x == 'sequent') return true;
    if (x == 'serenest') return true;
    if (x == 'serest') return true;
    if (x == 'sergeant') return true;
    if (x == 'serjeant') return true;
    if (x == 'serpent') return true;
    if (x == 'servant') return true;
    if (x == 'sestet') return true;
    if (x == 'set') return true;
    if (x == 'setout') return true;
    if (x == 'settlement') return true;
    if (x == 'severest') return true;
    if (x == 'sexiest') return true;
    if (x == 'sexist') return true;
    if (x == 'sexpot') return true;
    if (x == 'sext') return true;
    if (x == 'sextant') return true;
    if (x == 'sextet') return true;
    if (x == 'sextuplet') return true;
    if (x == 'shabbiest') return true;
    if (x == 'shadiest') return true;
    if (x == 'shadowiest') return true;
    if (x == 'shaft') return true;
    if (x == 'shaggiest') return true;
    if (x == 'shakeout') return true;
    if (x == 'shakiest') return true;
    if (x == 'shaliest') return true;
    if (x == 'shallot') return true;
    if (x == 'shallowest') return true;
    if (x == 'shalt') return true;
    if (x == 'shapeliest') return true;
    if (x == 'sharpest') return true;
    if (x == 'shat') return true;
    if (x == 'sheeniest') return true;
    if (x == 'sheerest') return true;
    if (x == 'sheet') return true;
    if (x == 'shelliest') return true;
    if (x == 'shelviest') return true;
    if (x == 'shent') return true;
    if (x == 'sherbert') return true;
    if (x == 'sherbet') return true;
    if (x == 'sheroot') return true;
    if (x == 'shiest') return true;
    if (x == 'shift') return true;
    if (x == 'shiftiest') return true;
    if (x == 'shilpit') return true;
    if (x == 'shiniest') return true;
    if (x == 'shipment') return true;
    if (x == 'shirt') return true;
    if (x == 'shirtiest') return true;
    if (x == 'shist') return true;
    if (x == 'shit') return true;
    if (x == 'shoalest') return true;
    if (x == 'shoaliest') return true;
    if (x == 'shoat') return true;
    if (x == 'shoddiest') return true;
    if (x == 'shoot') return true;
    if (x == 'shoplift') return true;
    if (x == 'short') return true;
    if (x == 'shortcut') return true;
    if (x == 'shortest') return true;
    if (x == 'shot') return true;
    if (x == 'shott') return true;
    if (x == 'shouldest') return true;
    if (x == 'shouldst') return true;
    if (x == 'shout') return true;
    if (x == 'showboat') return true;
    if (x == 'showiest') return true;
    if (x == 'shrewdest') return true;
    if (x == 'shriekiest') return true;
    if (x == 'shrift') return true;
    if (x == 'shrillest') return true;
    if (x == 'shrimpiest') return true;
    if (x == 'shrubbiest') return true;
    if (x == 'shunt') return true;
    if (x == 'shut') return true;
    if (x == 'shutout') return true;
    if (x == 'shyest') return true;
    if (x == 'sibilant') return true;
    if (x == 'sickest') return true;
    if (x == 'sickliest') return true;
    if (x == 'sift') return true;
    if (x == 'sight') return true;
    if (x == 'sightliest') return true;
    if (x == 'signet') return true;
    if (x == 'signficant') return true;
    if (x == 'significant') return true;
    if (x == 'signpost') return true;
    if (x == 'silent') return true;
    if (x == 'silentest') return true;
    if (x == 'silkiest') return true;
    if (x == 'silliest') return true;
    if (x == 'silt') return true;
    if (x == 'siltiest') return true;
    if (x == 'simonist') return true;
    if (x == 'simplest') return true;
    if (x == 'simulant') return true;
    if (x == 'sincerest') return true;
    if (x == 'sinciput') return true;
    if (x == 'singlet') return true;
    if (x == 'sippet') return true;
    if (x == 'sissiest') return true;
    if (x == 'sit') return true;
    if (x == 'sitarist') return true;
    if (x == 'siziest') return true;
    if (x == 'skat') return true;
    if (x == 'skeet') return true;
    if (x == 'skelpit') return true;
    if (x == 'sketchiest') return true;
    if (x == 'skiddiest') return true;
    if (x == 'skillet') return true;
    if (x == 'skimpiest') return true;
    if (x == 'skinflint') return true;
    if (x == 'skinniest') return true;
    if (x == 'skint') return true;
    if (x == 'skintight') return true;
    if (x == 'skippet') return true;
    if (x == 'skirret') return true;
    if (x == 'skirt') return true;
    if (x == 'skit') return true;
    if (x == 'skitteriest') return true;
    if (x == 'sklent') return true;
    if (x == 'skylight') return true;
    if (x == 'skyrocket') return true;
    if (x == 'slackest') return true;
    if (x == 'slaggiest') return true;
    if (x == 'slangiest') return true;
    if (x == 'slant') return true;
    if (x == 'slat') return true;
    if (x == 'slatiest') return true;
    if (x == 'sleaziest') return true;
    if (x == 'sleekest') return true;
    if (x == 'sleekiest') return true;
    if (x == 'sleekit') return true;
    if (x == 'sleepiest') return true;
    if (x == 'sleet') return true;
    if (x == 'sleetiest') return true;
    if (x == 'sleight') return true;
    if (x == 'slenderest') return true;
    if (x == 'slept') return true;
    if (x == 'slickest') return true;
    if (x == 'sliest') return true;
    if (x == 'slight') return true;
    if (x == 'slightest') return true;
    if (x == 'slimiest') return true;
    if (x == 'slimmest') return true;
    if (x == 'slimpsiest') return true;
    if (x == 'slimsiest') return true;
    if (x == 'slingshot') return true;
    if (x == 'slinkiest') return true;
    if (x == 'slipknot') return true;
    if (x == 'slipout') return true;
    if (x == 'slipperiest') return true;
    if (x == 'slippiest') return true;
    if (x == 'slipt') return true;
    if (x == 'slit') return true;
    if (x == 'sloppiest') return true;
    if (x == 'sloshiest') return true;
    if (x == 'slot') return true;
    if (x == 'slouchiest') return true;
    if (x == 'sloughiest') return true;
    if (x == 'slovenliest') return true;
    if (x == 'slowest') return true;
    if (x == 'sludgiest') return true;
    if (x == 'slugfest') return true;
    if (x == 'slummiest') return true;
    if (x == 'slushiest') return true;
    if (x == 'slut') return true;
    if (x == 'slyest') return true;
    if (x == 'smallest') return true;
    if (x == 'smalt') return true;
    if (x == 'smarmiest') return true;
    if (x == 'smart') return true;
    if (x == 'smartest') return true;
    if (x == 'smeariest') return true;
    if (x == 'smelliest') return true;
    if (x == 'smelt') return true;
    if (x == 'smirkiest') return true;
    if (x == 'smit') return true;
    if (x == 'smoggiest') return true;
    if (x == 'smokepot') return true;
    if (x == 'smokiest') return true;
    if (x == 'smolt') return true;
    if (x == 'smoothest') return true;
    if (x == 'smudgiest') return true;
    if (x == 'smuggest') return true;
    if (x == 'smut') return true;
    if (x == 'smutchiest') return true;
    if (x == 'smuttiest') return true;
    if (x == 'snaggiest') return true;
    if (x == 'snakiest') return true;
    if (x == 'snappiest') return true;
    if (x == 'snapshot') return true;
    if (x == 'snarliest') return true;
    if (x == 'snatchiest') return true;
    if (x == 'snazziest') return true;
    if (x == 'sneakiest') return true;
    if (x == 'sneeziest') return true;
    if (x == 'snellest') return true;
    if (x == 'snidest') return true;
    if (x == 'sniffiest') return true;
    if (x == 'snippet') return true;
    if (x == 'snippetiest') return true;
    if (x == 'snippiest') return true;
    if (x == 'snit') return true;
    if (x == 'snobbiest') return true;
    if (x == 'snoopiest') return true;
    if (x == 'snoot') return true;
    if (x == 'snootiest') return true;
    if (x == 'snooziest') return true;
    if (x == 'snort') return true;
    if (x == 'snot') return true;
    if (x == 'snottiest') return true;
    if (x == 'snout') return true;
    if (x == 'snoutiest') return true;
    if (x == 'snowdrift') return true;
    if (x == 'snowiest') return true;
    if (x == 'snowmelt') return true;
    if (x == 'snowsuit') return true;
    if (x == 'snubbiest') return true;
    if (x == 'snuffiest') return true;
    if (x == 'snuffliest') return true;
    if (x == 'snuggest') return true;
    return nil;
  }
  isGoodWordSO(x) {
    if (x == 'soapiest') return true;
    if (x == 'soapwort') return true;
    if (x == 'sobeit') return true;
    if (x == 'soberest') return true;
    if (x == 'socialist') return true;
    if (x == 'sociologist') return true;
    if (x == 'socket') return true;
    if (x == 'sodalist') return true;
    if (x == 'soffit') return true;
    if (x == 'soft') return true;
    if (x == 'softest') return true;
    if (x == 'soggiest') return true;
    if (x == 'solecist') return true;
    if (x == 'solemnest') return true;
    if (x == 'soleret') return true;
    if (x == 'solicit') return true;
    if (x == 'solidest') return true;
    if (x == 'solleret') return true;
    if (x == 'soloist') return true;
    if (x == 'solvent') return true;
    if (x == 'somersault') return true;
    if (x == 'somerset') return true;
    if (x == 'somewhat') return true;
    if (x == 'somnambulist') return true;
    if (x == 'somnolent') return true;
    if (x == 'sonant') return true;
    if (x == 'songfest') return true;
    if (x == 'sonnet') return true;
    if (x == 'sonorant') return true;
    if (x == 'sonsiest') return true;
    if (x == 'soonest') return true;
    if (x == 'soot') return true;
    if (x == 'soothest') return true;
    if (x == 'sootiest') return true;
    if (x == 'sophist') return true;
    if (x == 'soppiest') return true;
    if (x == 'sorbent') return true;
    if (x == 'sorbet') return true;
    if (x == 'sorest') return true;
    if (x == 'sorriest') return true;
    if (x == 'sort') return true;
    if (x == 'sot') return true;
    if (x == 'sought') return true;
    if (x == 'soundest') return true;
    if (x == 'soupiest') return true;
    if (x == 'sourest') return true;
    if (x == 'southeast') return true;
    if (x == 'southernmost') return true;
    if (x == 'southwest') return true;
    if (x == 'soviet') return true;
    if (x == 'spacecraft') return true;
    if (x == 'spaceflight') return true;
    if (x == 'spait') return true;
    if (x == 'spangliest') return true;
    if (x == 'sparest') return true;
    if (x == 'sparkiest') return true;
    if (x == 'sparriest') return true;
    if (x == 'sparsest') return true;
    if (x == 'spat') return true;
    if (x == 'spaviet') return true;
    if (x == 'spearmint') return true;
    if (x == 'specialest') return true;
    if (x == 'specialist') return true;
    if (x == 'speedboat') return true;
    if (x == 'speediest') return true;
    if (x == 'spelt') return true;
    if (x == 'spendthrift') return true;
    if (x == 'spent') return true;
    if (x == 'spheriest') return true;
    if (x == 'spiciest') return true;
    if (x == 'spideriest') return true;
    if (x == 'spiffiest') return true;
    if (x == 'spigot') return true;
    if (x == 'spikelet') return true;
    if (x == 'spikiest') return true;
    if (x == 'spilt') return true;
    if (x == 'spindliest') return true;
    if (x == 'spinet') return true;
    if (x == 'spiniest') return true;
    if (x == 'spinout') return true;
    if (x == 'spirant') return true;
    if (x == 'spirit') return true;
    if (x == 'spiritualist') return true;
    if (x == 'spirt') return true;
    if (x == 'spit') return true;
    if (x == 'spitefullest') return true;
    if (x == 'splashiest') return true;
    if (x == 'splat') return true;
    if (x == 'spleeniest') return true;
    if (x == 'splendidest') return true;
    if (x == 'splent') return true;
    if (x == 'splint') return true;
    if (x == 'split') return true;
    if (x == 'splotchiest') return true;
    if (x == 'splurgiest') return true;
    if (x == 'spoilt') return true;
    if (x == 'spongiest') return true;
    if (x == 'spookiest') return true;
    if (x == 'spooniest') return true;
    if (x == 'sport') return true;
    if (x == 'sportiest') return true;
    if (x == 'sportscast') return true;
    if (x == 'spot') return true;
    if (x == 'spotlight') return true;
    if (x == 'spottiest') return true;
    if (x == 'spout') return true;
    if (x == 'sprat') return true;
    if (x == 'sprawliest') return true;
    if (x == 'sprent') return true;
    if (x == 'spriest') return true;
    if (x == 'spriggiest') return true;
    if (x == 'spright') return true;
    if (x == 'springiest') return true;
    if (x == 'sprint') return true;
    if (x == 'sprit') return true;
    if (x == 'sprocket') return true;
    if (x == 'sprout') return true;
    if (x == 'sprucest') return true;
    if (x == 'spruciest') return true;
    if (x == 'spryest') return true;
    if (x == 'spumiest') return true;
    if (x == 'spunkiest') return true;
    if (x == 'spurt') return true;
    if (x == 'squabbiest') return true;
    if (x == 'squalidest') return true;
    if (x == 'squalliest') return true;
    if (x == 'squarest') return true;
    if (x == 'squashiest') return true;
    if (x == 'squat') return true;
    if (x == 'squattest') return true;
    if (x == 'squattiest') return true;
    if (x == 'squeakiest') return true;
    if (x == 'squelchiest') return true;
    if (x == 'squiggliest') return true;
    if (x == 'squinniest') return true;
    if (x == 'squint') return true;
    if (x == 'squintest') return true;
    if (x == 'squintiest') return true;
    if (x == 'squirmiest') return true;
    if (x == 'squirt') return true;
    if (x == 'squishiest') return true;
    if (x == 'stablest') return true;
    if (x == 'staggart') return true;
    if (x == 'staggiest') return true;
    if (x == 'stagiest') return true;
    if (x == 'stagnant') return true;
    if (x == 'staidest') return true;
    if (x == 'stakeout') return true;
    if (x == 'stalest') return true;
    if (x == 'stalkiest') return true;
    if (x == 'stalwart') return true;
    if (x == 'stanchest') return true;
    if (x == 'standout') return true;
    if (x == 'standpat') return true;
    if (x == 'standpoint') return true;
    if (x == 'starchiest') return true;
    if (x == 'stardust') return true;
    if (x == 'starkest') return true;
    if (x == 'starlet') return true;
    if (x == 'starlight') return true;
    if (x == 'starlit') return true;
    if (x == 'starriest') return true;
    if (x == 'start') return true;
    if (x == 'starwort') return true;
    if (x == 'statant') return true;
    if (x == 'stateliest') return true;
    if (x == 'statement') return true;
    if (x == 'statist') return true;
    if (x == 'staunchest') return true;
    if (x == 'steadfast') return true;
    if (x == 'steadiest') return true;
    if (x == 'stealthiest') return true;
    if (x == 'steamboat') return true;
    if (x == 'steamiest') return true;
    if (x == 'stedfast') return true;
    if (x == 'steeliest') return true;
    if (x == 'steepest') return true;
    if (x == 'stemmiest') return true;
    if (x == 'stenchiest') return true;
    if (x == 'sterlet') return true;
    if (x == 'sternest') return true;
    if (x == 'stet') return true;
    if (x == 'stickiest') return true;
    if (x == 'stickit') return true;
    if (x == 'stickout') return true;
    if (x == 'stiffest') return true;
    if (x == 'stillest') return true;
    if (x == 'stilliest') return true;
    if (x == 'stilt') return true;
    if (x == 'stimulant') return true;
    if (x == 'stingiest') return true;
    if (x == 'stinkiest') return true;
    if (x == 'stinkpot') return true;
    if (x == 'stint') return true;
    if (x == 'stoat') return true;
    if (x == 'stockiest') return true;
    if (x == 'stockist') return true;
    if (x == 'stockpot') return true;
    if (x == 'stodgiest') return true;
    if (x == 'stolidest') return true;
    if (x == 'stoniest') return true;
    if (x == 'stoplight') return true;
    if (x == 'stopt') return true;
    if (x == 'stormiest') return true;
    if (x == 'stout') return true;
    if (x == 'stoutest') return true;
    if (x == 'straggliest') return true;
    if (x == 'straight') return true;
    if (x == 'straightest') return true;
    if (x == 'straightforwardest') return true;
    if (x == 'strait') return true;
    if (x == 'straitest') return true;
    if (x == 'strangest') return true;
    if (x == 'strategist') return true;
    if (x == 'strawhat') return true;
    if (x == 'strawiest') return true;
    if (x == 'streakiest') return true;
    if (x == 'streamiest') return true;
    if (x == 'street') return true;
    if (x == 'stretchiest') return true;
    if (x == 'strict') return true;
    if (x == 'strictest') return true;
    if (x == 'strident') return true;
    if (x == 'stringent') return true;
    if (x == 'stringiest') return true;
    if (x == 'stripiest') return true;
    if (x == 'stript') return true;
    if (x == 'strongest') return true;
    if (x == 'strumpet') return true;
    if (x == 'strunt') return true;
    if (x == 'strut') return true;
    if (x == 'stubbiest') return true;
    if (x == 'stubbliest') return true;
    if (x == 'stubiest') return true;
    if (x == 'student') return true;
    if (x == 'stuffiest') return true;
    if (x == 'stumpiest') return true;
    if (x == 'stunt') return true;
    if (x == 'stupidest') return true;
    if (x == 'sturdiest') return true;
    if (x == 'sturt') return true;
    if (x == 'stylet') return true;
    if (x == 'stylist') return true;
    if (x == 'suavest') return true;
    if (x == 'subabbot') return true;
    if (x == 'subadult') return true;
    if (x == 'subagent') return true;
    if (x == 'subbasement') return true;
    if (x == 'subcabinet') return true;
    if (x == 'subcomponent') return true;
    if (x == 'subconcept') return true;
    if (x == 'subcontract') return true;
    if (x == 'subdepartment') return true;
    if (x == 'subdepot') return true;
    if (x == 'subdistrict') return true;
    if (x == 'subduct') return true;
    if (x == 'subedit') return true;
    if (x == 'suberect') return true;
    if (x == 'subject') return true;
    if (x == 'sublet') return true;
    if (x == 'sublimest') return true;
    if (x == 'submit') return true;
    if (x == 'subpart') return true;
    if (x == 'subplot') return true;
    if (x == 'subproject') return true;
    if (x == 'subrent') return true;
    if (x == 'subscript') return true;
    if (x == 'subsect') return true;
    if (x == 'subsequent') return true;
    if (x == 'subset') return true;
    if (x == 'subshaft') return true;
    if (x == 'subsist') return true;
    if (x == 'subtext') return true;
    if (x == 'subtilest') return true;
    if (x == 'subtlest') return true;
    if (x == 'subtract') return true;
    if (x == 'subunit') return true;
    if (x == 'subvert') return true;
    if (x == 'succinct') return true;
    if (x == 'succinctest') return true;
    if (x == 'succulent') return true;
    if (x == 'sudsiest') return true;
    if (x == 'suet') return true;
    if (x == 'sufficient') return true;
    if (x == 'sugariest') return true;
    if (x == 'suggest') return true;
    if (x == 'suint') return true;
    if (x == 'suit') return true;
    if (x == 'sulfuret') return true;
    if (x == 'sulkiest') return true;
    if (x == 'sullenest') return true;
    if (x == 'sultriest') return true;
    if (x == 'summeriest') return true;
    if (x == 'summit') return true;
    if (x == 'sunburnt') return true;
    if (x == 'sunburst') return true;
    if (x == 'sunfast') return true;
    if (x == 'sunket') return true;
    if (x == 'sunlight') return true;
    if (x == 'sunlit') return true;
    if (x == 'sunniest') return true;
    if (x == 'sunset') return true;
    if (x == 'sunspot') return true;
    if (x == 'sunsuit') return true;
    if (x == 'superabundant') return true;
    if (x == 'superbest') return true;
    if (x == 'superconvenient') return true;
    if (x == 'superefficient') return true;
    if (x == 'superfast') return true;
    if (x == 'supergovernment') return true;
    if (x == 'superintelligent') return true;
    if (x == 'superintendent') return true;
    if (x == 'superjet') return true;
    if (x == 'supermarket') return true;
    if (x == 'superpatriot') return true;
    if (x == 'superport') return true;
    if (x == 'superscout') return true;
    if (x == 'superscript') return true;
    if (x == 'supersecret') return true;
    if (x == 'supersoft') return true;
    if (x == 'superspecialist') return true;
    if (x == 'supertight') return true;
    if (x == 'supervenient') return true;
    if (x == 'supplant') return true;
    if (x == 'supplement') return true;
    if (x == 'supplest') return true;
    if (x == 'suppliant') return true;
    if (x == 'supplicant') return true;
    if (x == 'support') return true;
    if (x == 'supremest') return true;
    if (x == 'surcoat') return true;
    if (x == 'surest') return true;
    if (x == 'surfboat') return true;
    if (x == 'surfeit') return true;
    if (x == 'surfiest') return true;
    if (x == 'surliest') return true;
    if (x == 'surmount') return true;
    if (x == 'surprint') return true;
    if (x == 'surtout') return true;
    if (x == 'suspect') return true;
    if (x == 'sveltest') return true;
    if (x == 'swampiest') return true;
    if (x == 'swankest') return true;
    if (x == 'swankiest') return true;
    if (x == 'swart') return true;
    if (x == 'swarthiest') return true;
    if (x == 'swat') return true;
    if (x == 'sweat') return true;
    if (x == 'sweatiest') return true;
    if (x == 'sweepiest') return true;
    if (x == 'sweet') return true;
    if (x == 'sweetest') return true;
    if (x == 'sweetheart') return true;
    if (x == 'swellest') return true;
    if (x == 'sweltriest') return true;
    if (x == 'swept') return true;
    if (x == 'swift') return true;
    if (x == 'swiftest') return true;
    if (x == 'swimmiest') return true;
    if (x == 'swimsuit') return true;
    if (x == 'swingiest') return true;
    if (x == 'swirliest') return true;
    if (x == 'swishiest') return true;
    if (x == 'swivet') return true;
    if (x == 'swot') return true;
    if (x == 'sycophant') return true;
    if (x == 'symbiont') return true;
    if (x == 'symbiot') return true;
    if (x == 'syndet') return true;
    return nil;
  }
;
twiEscTY: TwiEscDataObject
  firstLetter = 't'
  lastLetter  = 'y'
  isGoodWord(x) {
    if (x == 'tabby') return true;
    if (x == 'tacitly') return true;
    if (x == 'taciturnity') return true;
    if (x == 'tackey') return true;
    if (x == 'tackify') return true;
    if (x == 'tackily') return true;
    if (x == 'tacky') return true;
    if (x == 'tactfully') return true;
    if (x == 'tactlessly') return true;
    if (x == 'taffy') return true;
    if (x == 'takingly') return true;
    if (x == 'talcky') return true;
    if (x == 'talky') return true;
    if (x == 'tallboy') return true;
    if (x == 'tallowy') return true;
    if (x == 'tally') return true;
    if (x == 'tamely') return true;
    if (x == 'tammy') return true;
    if (x == 'tangency') return true;
    if (x == 'tangibility') return true;
    if (x == 'tangibly') return true;
    if (x == 'tangly') return true;
    if (x == 'tangy') return true;
    if (x == 'tanistry') return true;
    if (x == 'tannery') return true;
    if (x == 'tansy') return true;
    if (x == 'tantalisingly') return true;
    if (x == 'tantalizingly') return true;
    if (x == 'tantivy') return true;
    if (x == 'tapestry') return true;
    if (x == 'tardily') return true;
    if (x == 'tardy') return true;
    if (x == 'tarnally') return true;
    if (x == 'tarry') return true;
    if (x == 'tartly') return true;
    if (x == 'tastefully') return true;
    if (x == 'tastelessly') return true;
    if (x == 'tastily') return true;
    if (x == 'tasty') return true;
    if (x == 'tatouay') return true;
    if (x == 'tatty') return true;
    if (x == 'tautly') return true;
    if (x == 'tawdry') return true;
    if (x == 'tawney') return true;
    if (x == 'tawnily') return true;
    if (x == 'tawny') return true;
    if (x == 'tawsy') return true;
    if (x == 'taxably') return true;
    if (x == 'taxidermy') return true;
    if (x == 'taxingly') return true;
    if (x == 'taxiway') return true;
    if (x == 'taxonomy') return true;
    if (x == 'teaberry') return true;
    if (x == 'teapoy') return true;
    if (x == 'tearily') return true;
    if (x == 'teary') return true;
    if (x == 'techily') return true;
    if (x == 'technicality') return true;
    if (x == 'technically') return true;
    if (x == 'technology') return true;
    if (x == 'techy') return true;
    if (x == 'teddy') return true;
    if (x == 'tediously') return true;
    if (x == 'teensy') return true;
    if (x == 'teentsy') return true;
    if (x == 'teeny') return true;
    if (x == 'telegony') return true;
    if (x == 'telepathically') return true;
    if (x == 'telepathy') return true;
    if (x == 'teleplay') return true;
    if (x == 'telly') return true;
    if (x == 'temerity') return true;
    if (x == 'temporarily') return true;
    if (x == 'temporary') return true;
    if (x == 'temptingly') return true;
    if (x == 'tenability') return true;
    if (x == 'tenably') return true;
    if (x == 'tenaciously') return true;
    if (x == 'tenacity') return true;
    if (x == 'tenancy') return true;
    if (x == 'tenantry') return true;
    if (x == 'tendency') return true;
    if (x == 'tenderly') return true;
    if (x == 'tenotomy') return true;
    if (x == 'tenpenny') return true;
    if (x == 'tensely') return true;
    if (x == 'tensibly') return true;
    if (x == 'tensity') return true;
    if (x == 'tentatively') return true;
    if (x == 'tenthly') return true;
    if (x == 'tenty') return true;
    if (x == 'tenuity') return true;
    if (x == 'tenuously') return true;
    if (x == 'tepefy') return true;
    if (x == 'tepidity') return true;
    if (x == 'tepidly') return true;
    if (x == 'terminology') return true;
    if (x == 'termly') return true;
    if (x == 'ternary') return true;
    if (x == 'terribly') return true;
    if (x == 'terrify') return true;
    if (x == 'terrifyingly') return true;
    if (x == 'territory') return true;
    if (x == 'terry') return true;
    if (x == 'tersely') return true;
    if (x == 'tertiary') return true;
    if (x == 'testacy') return true;
    if (x == 'testamentary') return true;
    if (x == 'testify') return true;
    if (x == 'testily') return true;
    if (x == 'testimony') return true;
    if (x == 'testy') return true;
    if (x == 'tetany') return true;
    if (x == 'tetchily') return true;
    if (x == 'tetchy') return true;
    if (x == 'teughly') return true;
    if (x == 'textuary') return true;
    if (x == 'thankfully') return true;
    if (x == 'thataway') return true;
    if (x == 'thatchy') return true;
    if (x == 'thearchy') return true;
    if (x == 'thegnly') return true;
    if (x == 'theocracy') return true;
    if (x == 'theodicy') return true;
    if (x == 'theogony') return true;
    if (x == 'theology') return true;
    if (x == 'theonomy') return true;
    if (x == 'theoretically') return true;
    if (x == 'theory') return true;
    if (x == 'therapeutically') return true;
    if (x == 'therapy') return true;
    if (x == 'thereby') return true;
    if (x == 'thermometrically') return true;
    if (x == 'thermostatically') return true;
    if (x == 'theurgy') return true;
    if (x == 'thewy') return true;
    if (x == 'they') return true;
    if (x == 'thickety') return true;
    if (x == 'thickly') return true;
    if (x == 'thievery') return true;
    if (x == 'thinly') return true;
    if (x == 'thirdly') return true;
    if (x == 'thirsty') return true;
    if (x == 'thirty') return true;
    if (x == 'thistly') return true;
    if (x == 'thornily') return true;
    if (x == 'thorny') return true;
    if (x == 'thoroughly') return true;
    if (x == 'thoughtfully') return true;
    if (x == 'thoughtlessly') return true;
    if (x == 'thrawnly') return true;
    if (x == 'thready') return true;
    if (x == 'threateningly') return true;
    if (x == 'threnody') return true;
    if (x == 'thriftily') return true;
    if (x == 'thrifty') return true;
    if (x == 'thrillingly') return true;
    if (x == 'throaty') return true;
    if (x == 'thrummy') return true;
    if (x == 'thruway') return true;
    if (x == 'thuggery') return true;
    if (x == 'thunderously') return true;
    if (x == 'thundery') return true;
    if (x == 'thursday') return true;
    if (x == 'thusly') return true;
    if (x == 'thwartly') return true;
    if (x == 'thy') return true;
    if (x == 'thymey') return true;
    if (x == 'thymy') return true;
    if (x == 'ticklishly') return true;
    if (x == 'tidally') return true;
    if (x == 'tiddly') return true;
    if (x == 'tideway') return true;
    if (x == 'tidily') return true;
    if (x == 'tidy') return true;
    if (x == 'tiffany') return true;
    if (x == 'tightly') return true;
    if (x == 'tilbury') return true;
    if (x == 'timely') return true;
    if (x == 'timidity') return true;
    if (x == 'timidly') return true;
    if (x == 'timorously') return true;
    if (x == 'timothy') return true;
    if (x == 'tindery') return true;
    if (x == 'tingly') return true;
    if (x == 'tinily') return true;
    if (x == 'tinkly') return true;
    if (x == 'tinnily') return true;
    if (x == 'tinny') return true;
    if (x == 'tinselly') return true;
    if (x == 'tiny') return true;
    if (x == 'tippy') return true;
    if (x == 'tipsily') return true;
    if (x == 'tipsy') return true;
    if (x == 'tiredly') return true;
    if (x == 'tirelessly') return true;
    if (x == 'tiresomely') return true;
    if (x == 'tissuey') return true;
    if (x == 'tittuppy') return true;
    if (x == 'titty') return true;
    if (x == 'titulary') return true;
    if (x == 'tivy') return true;
    if (x == 'tizzy') return true;
    if (x == 'toady') return true;
    if (x == 'toasty') return true;
    if (x == 'toby') return true;
    if (x == 'tocology') return true;
    if (x == 'today') return true;
    if (x == 'toddy') return true;
    if (x == 'tody') return true;
    if (x == 'toffy') return true;
    if (x == 'toggery') return true;
    if (x == 'toiletry') return true;
    if (x == 'tokay') return true;
    if (x == 'tokology') return true;
    if (x == 'tolerably') return true;
    if (x == 'tollway') return true;
    if (x == 'tomalley') return true;
    if (x == 'tomboy') return true;
    if (x == 'tommy') return true;
    if (x == 'tonality') return true;
    if (x == 'tonally') return true;
    if (x == 'tonicity') return true;
    if (x == 'tonishly') return true;
    if (x == 'tonsillectomy') return true;
    if (x == 'tony') return true;
    if (x == 'toothily') return true;
    if (x == 'toothy') return true;
    if (x == 'tootsy') return true;
    if (x == 'topiary') return true;
    if (x == 'topically') return true;
    if (x == 'toplofty') return true;
    if (x == 'topography') return true;
    if (x == 'topology') return true;
    if (x == 'toponymy') return true;
    if (x == 'torosity') return true;
    if (x == 'torpidity') return true;
    if (x == 'torpidly') return true;
    if (x == 'torrefy') return true;
    if (x == 'torridly') return true;
    if (x == 'torrify') return true;
    if (x == 'torsionally') return true;
    if (x == 'tory') return true;
    if (x == 'totality') return true;
    if (x == 'totally') return true;
    if (x == 'tottery') return true;
    if (x == 'totty') return true;
    if (x == 'touchily') return true;
    if (x == 'touchy') return true;
    if (x == 'toughly') return true;
    if (x == 'toughy') return true;
    if (x == 'touristy') return true;
    if (x == 'tourney') return true;
    if (x == 'towardly') return true;
    if (x == 'towaway') return true;
    if (x == 'towery') return true;
    if (x == 'towny') return true;
    if (x == 'towy') return true;
    if (x == 'toxicity') return true;
    if (x == 'toy') return true;
    if (x == 'tracery') return true;
    if (x == 'tracherously') return true;
    if (x == 'traditionally') return true;
    if (x == 'tragedy') return true;
    if (x == 'tragically') return true;
    if (x == 'trainway') return true;
    if (x == 'tramway') return true;
    if (x == 'tranquility') return true;
    if (x == 'tranquillity') return true;
    if (x == 'tranquilly') return true;
    if (x == 'transferability') return true;
    if (x == 'transitory') return true;
    if (x == 'translucency') return true;
    if (x == 'translucently') return true;
    if (x == 'transparency') return true;
    if (x == 'transparently') return true;
    if (x == 'transversely') return true;
    if (x == 'trashily') return true;
    if (x == 'trashy') return true;
    if (x == 'travesty') return true;
    if (x == 'trawley') return true;
    if (x == 'tray') return true;
    if (x == 'treacly') return true;
    if (x == 'treasury') return true;
    if (x == 'treaty') return true;
    if (x == 'trebly') return true;
    if (x == 'trembly') return true;
    if (x == 'tremendously') return true;
    if (x == 'tremulously') return true;
    if (x == 'trendily') return true;
    if (x == 'trendy') return true;
    if (x == 'tressy') return true;
    if (x == 'trey') return true;
    if (x == 'triangularly') return true;
    if (x == 'triarchy') return true;
    if (x == 'tribally') return true;
    if (x == 'tributary') return true;
    if (x == 'trickery') return true;
    if (x == 'trickily') return true;
    if (x == 'trickly') return true;
    if (x == 'tricksy') return true;
    if (x == 'tricky') return true;
    if (x == 'trigly') return true;
    if (x == 'trigonometry') return true;
    if (x == 'trilby') return true;
    if (x == 'trilogy') return true;
    if (x == 'trimly') return true;
    if (x == 'trinary') return true;
    if (x == 'trinity') return true;
    if (x == 'triply') return true;
    if (x == 'tripody') return true;
    if (x == 'trisomy') return true;
    if (x == 'tritely') return true;
    if (x == 'triumphantly') return true;
    if (x == 'triunity') return true;
    if (x == 'triviality') return true;
    if (x == 'trolley') return true;
    if (x == 'trollopy') return true;
    if (x == 'trolly') return true;
    if (x == 'trophy') return true;
    if (x == 'troublesomely') return true;
    if (x == 'trouty') return true;
    if (x == 'troy') return true;
    if (x == 'truancy') return true;
    if (x == 'truantry') return true;
    if (x == 'truculency') return true;
    if (x == 'truculently') return true;
    if (x == 'truly') return true;
    if (x == 'trumpery') return true;
    if (x == 'trustfully') return true;
    if (x == 'trustily') return true;
    if (x == 'trustworthy') return true;
    if (x == 'trusty') return true;
    if (x == 'truthfully') return true;
    if (x == 'try') return true;
    if (x == 'tryingly') return true;
    if (x == 'tubby') return true;
    if (x == 'tuesday') return true;
    if (x == 'tuftily') return true;
    if (x == 'tufty') return true;
    if (x == 'tumefy') return true;
    if (x == 'tumidily') return true;
    if (x == 'tumidity') return true;
    if (x == 'tummy') return true;
    if (x == 'tunably') return true;
    if (x == 'tuneably') return true;
    if (x == 'tunny') return true;
    if (x == 'tuppeny') return true;
    if (x == 'turbary') return true;
    if (x == 'turbidity') return true;
    if (x == 'turbidly') return true;
    if (x == 'turbulently') return true;
    if (x == 'turfy') return true;
    if (x == 'turgency') return true;
    if (x == 'turgidity') return true;
    if (x == 'turgidly') return true;
    if (x == 'turkey') return true;
    if (x == 'turnery') return true;
    if (x == 'turnkey') return true;
    if (x == 'tussocky') return true;
    if (x == 'tutelary') return true;
    if (x == 'tutty') return true;
    if (x == 'twangy') return true;
    if (x == 'twanky') return true;
    if (x == 'tweaky') return true;
    if (x == 'tweedy') return true;
    if (x == 'twenty') return true;
    if (x == 'twiggy') return true;
    if (x == 'twinkly') return true;
    if (x == 'twiny') return true;
    if (x == 'twirly') return true;
    if (x == 'twitchy') return true;
    if (x == 'twittery') return true;
    if (x == 'twopenny') return true;
    if (x == 'tympany') return true;
    if (x == 'typey') return true;
    if (x == 'typically') return true;
    if (x == 'typify') return true;
    if (x == 'typographically') return true;
    if (x == 'typography') return true;
    if (x == 'typology') return true;
    if (x == 'typy') return true;
    if (x == 'tyranny') return true;
    return nil;
  }
;
twiEscYL: TwiEscDataObject
  firstLetter = 'y'
  lastLetter  = 'l'
  isGoodWord(x) {
    if (x == 'yawl') return true;
    if (x == 'yell') return true;
    if (x == 'yill') return true;
    if (x == 'yodel') return true;
    if (x == 'yokel') return true;
    if (x == 'youthful') return true;
    if (x == 'yowl') return true;
    return nil;
  }
;
twiEscLI: TwiEscDataObject
  firstLetter = 'l'
  lastLetter  = 'i'
  isGoodWord(x) {
    if (x == 'lanai') return true;
    if (x == 'lapilli') return true;
    if (x == 'lati') return true;
    if (x == 'lazuli') return true;
    if (x == 'lecythi') return true;
    if (x == 'lei') return true;
    if (x == 'lekythi') return true;
    if (x == 'lekythoi') return true;
    if (x == 'lemnisci') return true;
    if (x == 'li') return true;
    if (x == 'libretti') return true;
    if (x == 'libri') return true;
    if (x == 'lichi') return true;
    if (x == 'limbi') return true;
    if (x == 'limuli') return true;
    if (x == 'linguini') return true;
    if (x == 'litai') return true;
    if (x == 'litchi') return true;
    if (x == 'literati') return true;
    if (x == 'loci') return true;
    if (x == 'loculi') return true;
    if (x == 'logoi') return true;
    if (x == 'lungi') return true;
    if (x == 'lungyi') return true;
    return nil;
  }
;
twiEscIT: TwiEscDataObject
  firstLetter = 'i'
  lastLetter  = 't'
  isGoodWord(x) {
    if (x == 'iceboat') return true;
    if (x == 'ichthyologist') return true;
    if (x == 'iciest') return true;
    if (x == 'ickiest') return true;
    if (x == 'iconoclast') return true;
    if (x == 'icthiologist') return true;
    if (x == 'idealist') return true;
    if (x == 'idiolect') return true;
    if (x == 'idiot') return true;
    if (x == 'idlest') return true;
    if (x == 'idylist') return true;
    if (x == 'idyllist') return true;
    if (x == 'iffiest') return true;
    if (x == 'ignorant') return true;
    if (x == 'illicit') return true;
    if (x == 'imagist') return true;
    if (x == 'imaret') return true;
    if (x == 'immanent') return true;
    if (x == 'immensest') return true;
    if (x == 'immigrant') return true;
    if (x == 'imminent') return true;
    if (x == 'immodest') return true;
    if (x == 'immunologist') return true;
    if (x == 'impact') return true;
    if (x == 'impaint') return true;
    if (x == 'impairment') return true;
    if (x == 'impalement') return true;
    if (x == 'impart') return true;
    if (x == 'impatient') return true;
    if (x == 'impeachment') return true;
    if (x == 'impediment') return true;
    if (x == 'impenitent') return true;
    if (x == 'imperialist') return true;
    if (x == 'impermanent') return true;
    if (x == 'impertinent') return true;
    if (x == 'impingement') return true;
    if (x == 'implant') return true;
    if (x == 'implement') return true;
    if (x == 'implicit') return true;
    if (x == 'import') return true;
    if (x == 'important') return true;
    if (x == 'impost') return true;
    if (x == 'impotent') return true;
    if (x == 'impoundment') return true;
    if (x == 'impoverishment') return true;
    if (x == 'impressment') return true;
    if (x == 'imprest') return true;
    if (x == 'imprint') return true;
    if (x == 'imprisonment') return true;
    if (x == 'improvement') return true;
    if (x == 'improvident') return true;
    if (x == 'imprudent') return true;
    if (x == 'impudent') return true;
    if (x == 'inadvertent') return true;
    if (x == 'inanest') return true;
    if (x == 'inapparent') return true;
    if (x == 'inapt') return true;
    if (x == 'inbuilt') return true;
    if (x == 'inburst') return true;
    if (x == 'incandescent') return true;
    if (x == 'incept') return true;
    if (x == 'incessant') return true;
    if (x == 'incest') return true;
    if (x == 'incident') return true;
    if (x == 'incipient') return true;
    if (x == 'incipit') return true;
    if (x == 'incitant') return true;
    if (x == 'incitement') return true;
    if (x == 'inclement') return true;
    if (x == 'incoherent') return true;
    if (x == 'incompetent') return true;
    if (x == 'incongruent') return true;
    if (x == 'inconsistent') return true;
    if (x == 'inconstant') return true;
    if (x == 'inconvenient') return true;
    if (x == 'incorrect') return true;
    if (x == 'increment') return true;
    if (x == 'incrust') return true;
    if (x == 'incult') return true;
    if (x == 'incumbent') return true;
    if (x == 'indecent') return true;
    if (x == 'indecentest') return true;
    if (x == 'indent') return true;
    if (x == 'independent') return true;
    if (x == 'indevout') return true;
    if (x == 'indicant') return true;
    if (x == 'indict') return true;
    if (x == 'indictment') return true;
    if (x == 'indifferent') return true;
    if (x == 'indigent') return true;
    if (x == 'indignant') return true;
    if (x == 'indirect') return true;
    if (x == 'indiscreet') return true;
    if (x == 'indistinct') return true;
    if (x == 'indolent') return true;
    if (x == 'indraft') return true;
    if (x == 'inducement') return true;
    if (x == 'induct') return true;
    if (x == 'indulgent') return true;
    if (x == 'indult') return true;
    if (x == 'industrialist') return true;
    if (x == 'indwelt') return true;
    if (x == 'inefficient') return true;
    if (x == 'inelegant') return true;
    if (x == 'inept') return true;
    if (x == 'inerrant') return true;
    if (x == 'inert') return true;
    if (x == 'inexact') return true;
    if (x == 'inexpedient') return true;
    if (x == 'inexpert') return true;
    if (x == 'inexplicit') return true;
    if (x == 'infant') return true;
    if (x == 'infarct') return true;
    if (x == 'infect') return true;
    if (x == 'infest') return true;
    if (x == 'inflect') return true;
    if (x == 'inflict') return true;
    if (x == 'inflight') return true;
    if (x == 'influent') return true;
    if (x == 'informant') return true;
    if (x == 'infract') return true;
    if (x == 'infrequent') return true;
    if (x == 'infringement') return true;
    if (x == 'ingest') return true;
    if (x == 'ingot') return true;
    if (x == 'ingraft') return true;
    if (x == 'ingredient') return true;
    if (x == 'inhabit') return true;
    if (x == 'inhabitant') return true;
    if (x == 'inhalant') return true;
    if (x == 'inherent') return true;
    if (x == 'inherit') return true;
    if (x == 'inhibit') return true;
    if (x == 'inject') return true;
    if (x == 'inkblot') return true;
    if (x == 'inkiest') return true;
    if (x == 'inkpot') return true;
    if (x == 'inlet') return true;
    if (x == 'inmost') return true;
    if (x == 'innermost') return true;
    if (x == 'innocent') return true;
    if (x == 'innocentest') return true;
    if (x == 'inpatient') return true;
    if (x == 'input') return true;
    if (x == 'inquest') return true;
    if (x == 'inquiet') return true;
    if (x == 'insanest') return true;
    if (x == 'insect') return true;
    if (x == 'insentient') return true;
    if (x == 'insert') return true;
    if (x == 'inset') return true;
    if (x == 'insight') return true;
    if (x == 'insignificant') return true;
    if (x == 'insist') return true;
    if (x == 'insistent') return true;
    if (x == 'insolent') return true;
    if (x == 'insolvent') return true;
    if (x == 'insouciant') return true;
    if (x == 'inspect') return true;
    if (x == 'inspirit') return true;
    if (x == 'installment') return true;
    if (x == 'instant') return true;
    if (x == 'instinct') return true;
    if (x == 'instruct') return true;
    if (x == 'instrument') return true;
    if (x == 'instrumentalist') return true;
    if (x == 'insufficent') return true;
    if (x == 'insufficient') return true;
    if (x == 'insulant') return true;
    if (x == 'insult') return true;
    if (x == 'insurant') return true;
    if (x == 'insurgent') return true;
    if (x == 'insurrectionist') return true;
    if (x == 'inswept') return true;
    if (x == 'intact') return true;
    if (x == 'intellect') return true;
    if (x == 'intelligent') return true;
    if (x == 'intensest') return true;
    if (x == 'intent') return true;
    if (x == 'interact') return true;
    if (x == 'intercept') return true;
    if (x == 'intercurrent') return true;
    if (x == 'intercut') return true;
    if (x == 'interdependent') return true;
    if (x == 'interdict') return true;
    if (x == 'interest') return true;
    if (x == 'interject') return true;
    if (x == 'interment') return true;
    if (x == 'intermit') return true;
    if (x == 'intermittent') return true;
    if (x == 'internet') return true;
    if (x == 'internist') return true;
    if (x == 'internment') return true;
    if (x == 'interpret') return true;
    if (x == 'interrupt') return true;
    if (x == 'intersect') return true;
    if (x == 'intolerant') return true;
    if (x == 'intort') return true;
    if (x == 'intoxicant') return true;
    if (x == 'intransigent') return true;
    if (x == 'intrant') return true;
    if (x == 'intreat') return true;
    if (x == 'introit') return true;
    if (x == 'intromit') return true;
    if (x == 'introspect') return true;
    if (x == 'introvert') return true;
    if (x == 'intrust') return true;
    if (x == 'intuit') return true;
    if (x == 'intwist') return true;
    if (x == 'inundant') return true;
    if (x == 'invent') return true;
    if (x == 'invert') return true;
    if (x == 'invest') return true;
    if (x == 'investment') return true;
    if (x == 'involvement') return true;
    if (x == 'iratest') return true;
    if (x == 'iridescent') return true;
    if (x == 'ironist') return true;
    if (x == 'irrelevant') return true;
    if (x == 'irritant') return true;
    if (x == 'irrupt') return true;
    if (x == 'islet') return true;
    if (x == 'isohyet') return true;
    if (x == 'issuant') return true;
    if (x == 'it') return true;
    if (x == 'itchiest') return true;
    if (x == 'iterant') return true;
    if (x == 'itinerant') return true;
    return nil;
  }
;
twiEscTT: TwiEscDataObject
  firstLetter = 't'
  lastLetter  = 't'
  isGoodWord(x) {
    if (x == 'tabaret') return true;
    if (x == 'tablet') return true;
    if (x == 'taboret') return true;
    if (x == 'tabouret') return true;
    if (x == 'tacet') return true;
    if (x == 'tachist') return true;
    if (x == 'tacit') return true;
    if (x == 'tacket') return true;
    if (x == 'tackiest') return true;
    if (x == 'tact') return true;
    if (x == 'tailcoat') return true;
    if (x == 'taillight') return true;
    if (x == 'taint') return true;
    if (x == 'takeout') return true;
    if (x == 'talent') return true;
    if (x == 'talipot') return true;
    if (x == 'talkiest') return true;
    if (x == 'tallest') return true;
    if (x == 'tamest') return true;
    if (x == 'tangent') return true;
    if (x == 'tangiest') return true;
    if (x == 'tangliest') return true;
    if (x == 'tanist') return true;
    if (x == 'tannest') return true;
    if (x == 'tantamount') return true;
    if (x == 'tappet') return true;
    if (x == 'taproot') return true;
    if (x == 'tardiest') return true;
    if (x == 'target') return true;
    if (x == 'tarot') return true;
    if (x == 'tarriest') return true;
    if (x == 'tart') return true;
    if (x == 'tartest') return true;
    if (x == 'tartlet') return true;
    if (x == 'tasset') return true;
    if (x == 'tastiest') return true;
    if (x == 'tat') return true;
    if (x == 'tattiest') return true;
    if (x == 'taught') return true;
    if (x == 'taunt') return true;
    if (x == 'taut') return true;
    if (x == 'tautest') return true;
    if (x == 'tawdriest') return true;
    if (x == 'tawniest') return true;
    if (x == 'taxidermist') return true;
    if (x == 'teacart') return true;
    if (x == 'teapot') return true;
    if (x == 'teariest') return true;
    if (x == 'teat') return true;
    if (x == 'techiest') return true;
    if (x == 'teeniest') return true;
    if (x == 'teensiest') return true;
    if (x == 'teentsiest') return true;
    if (x == 'tegument') return true;
    if (x == 'telecast') return true;
    if (x == 'telegraphist') return true;
    if (x == 'teleost') return true;
    if (x == 'teleport') return true;
    if (x == 'temperament') return true;
    if (x == 'tempest') return true;
    if (x == 'templet') return true;
    if (x == 'tempt') return true;
    if (x == 'tenant') return true;
    if (x == 'tenderest') return true;
    if (x == 'tenement') return true;
    if (x == 'tenet') return true;
    if (x == 'tennist') return true;
    if (x == 'tensest') return true;
    if (x == 'tent') return true;
    if (x == 'tentiest') return true;
    if (x == 'terabit') return true;
    if (x == 'terawatt') return true;
    if (x == 'tercelet') return true;
    if (x == 'tercet') return true;
    if (x == 'terret') return true;
    if (x == 'territ') return true;
    if (x == 'tersest') return true;
    if (x == 'test') return true;
    if (x == 'testament') return true;
    if (x == 'testiest') return true;
    if (x == 'testpatient') return true;
    if (x == 'tetchiest') return true;
    if (x == 'text') return true;
    if (x == 'thankfullest') return true;
    if (x == 'that') return true;
    if (x == 'theft') return true;
    if (x == 'theist') return true;
    if (x == 'theocrat') return true;
    if (x == 'theorist') return true;
    if (x == 'therapist') return true;
    if (x == 'thereabout') return true;
    if (x == 'thereat') return true;
    if (x == 'thermit') return true;
    if (x == 'thermostat') return true;
    if (x == 'thickest') return true;
    if (x == 'thicket') return true;
    if (x == 'thickset') return true;
    if (x == 'thinnest') return true;
    if (x == 'thirst') return true;
    if (x == 'thirstiest') return true;
    if (x == 'thorniest') return true;
    if (x == 'thoroughest') return true;
    if (x == 'thought') return true;
    if (x == 'thrawart') return true;
    if (x == 'threadiest') return true;
    if (x == 'threat') return true;
    if (x == 'thrift') return true;
    if (x == 'thriftiest') return true;
    if (x == 'throat') return true;
    if (x == 'throatiest') return true;
    if (x == 'throughout') return true;
    if (x == 'thrummiest') return true;
    if (x == 'thruput') return true;
    if (x == 'thrust') return true;
    if (x == 'thumbnut') return true;
    if (x == 'thunderbolt') return true;
    if (x == 'thwart') return true;
    if (x == 'thymiest') return true;
    if (x == 'ticket') return true;
    if (x == 'tidbit') return true;
    if (x == 'tidiest') return true;
    if (x == 'tight') return true;
    if (x == 'tightest') return true;
    if (x == 'tilt') return true;
    if (x == 'timeliest') return true;
    if (x == 'timeout') return true;
    if (x == 'timidest') return true;
    if (x == 'timpanist') return true;
    if (x == 'tinct') return true;
    if (x == 'tingliest') return true;
    if (x == 'tiniest') return true;
    if (x == 'tinkliest') return true;
    if (x == 'tinniest') return true;
    if (x == 'tint') return true;
    if (x == 'tipcart') return true;
    if (x == 'tipcat') return true;
    if (x == 'tippet') return true;
    if (x == 'tippiest') return true;
    if (x == 'tipsiest') return true;
    if (x == 'tiredest') return true;
    if (x == 'tit') return true;
    if (x == 'titbit') return true;
    if (x == 'titlist') return true;
    if (x == 'titrant') return true;
    if (x == 'toast') return true;
    if (x == 'toastiest') return true;
    if (x == 'toft') return true;
    if (x == 'toilet') return true;
    if (x == 'toit') return true;
    if (x == 'tolerant') return true;
    if (x == 'tomcat') return true;
    if (x == 'tommyrot') return true;
    if (x == 'tomtit') return true;
    if (x == 'toniest') return true;
    if (x == 'tonight') return true;
    if (x == 'tonlet') return true;
    if (x == 'toot') return true;
    if (x == 'toothiest') return true;
    if (x == 'topcoat') return true;
    if (x == 'topknot') return true;
    if (x == 'toploftiest') return true;
    if (x == 'topmast') return true;
    if (x == 'topmost') return true;
    if (x == 'toquet') return true;
    if (x == 'torchlight') return true;
    if (x == 'torment') return true;
    if (x == 'torrent') return true;
    if (x == 'torridest') return true;
    if (x == 'tort') return true;
    if (x == 'tosspot') return true;
    if (x == 'tost') return true;
    if (x == 'tot') return true;
    if (x == 'totemist') return true;
    if (x == 'touchiest') return true;
    if (x == 'toughest') return true;
    if (x == 'tourist') return true;
    if (x == 'tournament') return true;
    if (x == 'tourniquet') return true;
    if (x == 'tout') return true;
    if (x == 'towboat') return true;
    if (x == 'toweriest') return true;
    if (x == 'towmont') return true;
    if (x == 'townlet') return true;
    if (x == 'toxicant') return true;
    if (x == 'tract') return true;
    if (x == 'trait') return true;
    if (x == 'traject') return true;
    if (x == 'trampolinist') return true;
    if (x == 'tranquilest') return true;
    if (x == 'tranquillest') return true;
    if (x == 'transact') return true;
    if (x == 'transcendent') return true;
    if (x == 'transcript') return true;
    if (x == 'transect') return true;
    if (x == 'transept') return true;
    if (x == 'transfixt') return true;
    if (x == 'transit') return true;
    if (x == 'translucent') return true;
    if (x == 'transmit') return true;
    if (x == 'transparent') return true;
    if (x == 'transplant') return true;
    if (x == 'transport') return true;
    if (x == 'transshipment') return true;
    if (x == 'transsubstantiationist') return true;
    if (x == 'trapnest') return true;
    if (x == 'trapt') return true;
    if (x == 'trashiest') return true;
    if (x == 'treat') return true;
    if (x == 'treatment') return true;
    if (x == 'trembliest') return true;
    if (x == 'trenchant') return true;
    if (x == 'trendiest') return true;
    if (x == 'tressiest') return true;
    if (x == 'tret') return true;
    if (x == 'trevet') return true;
    if (x == 'trickiest') return true;
    if (x == 'trickliest') return true;
    if (x == 'tricksiest') return true;
    if (x == 'tricot') return true;
    if (x == 'trident') return true;
    if (x == 'triggest') return true;
    if (x == 'trijet') return true;
    if (x == 'trimmest') return true;
    if (x == 'trinket') return true;
    if (x == 'triolet') return true;
    if (x == 'tripart') return true;
    if (x == 'triplet') return true;
    if (x == 'trippet') return true;
    if (x == 'trisect') return true;
    if (x == 'tritest') return true;
    if (x == 'triumphant') return true;
    if (x == 'trivet') return true;
    if (x == 'trombonist') return true;
    if (x == 'trot') return true;
    if (x == 'troubleshoot') return true;
    if (x == 'trout') return true;
    if (x == 'troutiest') return true;
    if (x == 'truant') return true;
    if (x == 'truculent') return true;
    if (x == 'truest') return true;
    if (x == 'trumpet') return true;
    if (x == 'trust') return true;
    if (x == 'trustiest') return true;
    if (x == 'tryout') return true;
    if (x == 'tryst') return true;
    if (x == 'tsarist') return true;
    if (x == 'tubbiest') return true;
    if (x == 'tucket') return true;
    if (x == 'tuffet') return true;
    if (x == 'tuft') return true;
    if (x == 'tuftiest') return true;
    if (x == 'tugboat') return true;
    if (x == 'tumult') return true;
    if (x == 'turbit') return true;
    if (x == 'turbojet') return true;
    if (x == 'turbot') return true;
    if (x == 'turfiest') return true;
    if (x == 'turgent') return true;
    if (x == 'turncoat') return true;
    if (x == 'turnout') return true;
    if (x == 'turnspit') return true;
    if (x == 'turret') return true;
    if (x == 'tut') return true;
    if (x == 'twangiest') return true;
    if (x == 'twat') return true;
    if (x == 'tweakiest') return true;
    if (x == 'tweediest') return true;
    if (x == 'tweet') return true;
    if (x == 'twiggiest') return true;
    if (x == 'twilight') return true;
    if (x == 'twilit') return true;
    if (x == 'twiniest') return true;
    if (x == 'twinight') return true;
    if (x == 'twirliest') return true;
    if (x == 'twist') return true;
    if (x == 'twit') return true;
    if (x == 'twitchiest') return true;
    if (x == 'twixt') return true;
    if (x == 'typecast') return true;
    if (x == 'typeset') return true;
    if (x == 'typiest') return true;
    if (x == 'typist') return true;
    if (x == 'tyrant') return true;
    if (x == 'tzarist') return true;
    return nil;
  }
;
twiEscTL: TwiEscDataObject
  firstLetter = 't'
  lastLetter  = 'l'
  isGoodWord(x) {
    if (x == 'tableful') return true;
    if (x == 'tablesful') return true;
    if (x == 'tablespoonful') return true;
    if (x == 'tactful') return true;
    if (x == 'tactical') return true;
    if (x == 'tactual') return true;
    if (x == 'tael') return true;
    if (x == 'taffarel') return true;
    if (x == 'tafferel') return true;
    if (x == 'taffrail') return true;
    if (x == 'tahsil') return true;
    if (x == 'tail') return true;
    if (x == 'tall') return true;
    if (x == 'tallol') return true;
    if (x == 'tamal') return true;
    if (x == 'tangential') return true;
    if (x == 'tankful') return true;
    if (x == 'tapetal') return true;
    if (x == 'tarnal') return true;
    if (x == 'tarsal') return true;
    if (x == 'tassel') return true;
    if (x == 'tasteful') return true;
    if (x == 'teabowl') return true;
    if (x == 'teal') return true;
    if (x == 'tearful') return true;
    if (x == 'teasel') return true;
    if (x == 'teaspoonful') return true;
    if (x == 'teazel') return true;
    if (x == 'technical') return true;
    if (x == 'technological') return true;
    if (x == 'tectal') return true;
    if (x == 'teenful') return true;
    if (x == 'teetotal') return true;
    if (x == 'tegminal') return true;
    if (x == 'televisual') return true;
    if (x == 'telial') return true;
    if (x == 'tell') return true;
    if (x == 'temperamental') return true;
    if (x == 'temporal') return true;
    if (x == 'tenail') return true;
    if (x == 'tendril') return true;
    if (x == 'tenurial') return true;
    if (x == 'tercel') return true;
    if (x == 'tergal') return true;
    if (x == 'terminal') return true;
    if (x == 'terpinol') return true;
    if (x == 'terrestrial') return true;
    if (x == 'territorial') return true;
    if (x == 'tertial') return true;
    if (x == 'testimonial') return true;
    if (x == 'tetanal') return true;
    if (x == 'tetrahedral') return true;
    if (x == 'tetryl') return true;
    if (x == 'textual') return true;
    if (x == 'textural') return true;
    if (x == 'thankful') return true;
    if (x == 'theatrical') return true;
    if (x == 'thecal') return true;
    if (x == 'theelol') return true;
    if (x == 'thenal') return true;
    if (x == 'theological') return true;
    if (x == 'theoretical') return true;
    if (x == 'thermal') return true;
    if (x == 'thermel') return true;
    if (x == 'thetical') return true;
    if (x == 'thiazol') return true;
    if (x == 'thill') return true;
    if (x == 'thimbleful') return true;
    if (x == 'thiol') return true;
    if (x == 'thionyl') return true;
    if (x == 'thirl') return true;
    if (x == 'thoracal') return true;
    if (x == 'thoughtful') return true;
    if (x == 'thrall') return true;
    if (x == 'thrill') return true;
    if (x == 'thumbnail') return true;
    if (x == 'thurl') return true;
    if (x == 'thymol') return true;
    if (x == 'thyroidal') return true;
    if (x == 'tibial') return true;
    if (x == 'tical') return true;
    if (x == 'tidal') return true;
    if (x == 'tiercel') return true;
    if (x == 'til') return true;
    if (x == 'till') return true;
    if (x == 'timbal') return true;
    if (x == 'timbrel') return true;
    if (x == 'tincal') return true;
    if (x == 'tineal') return true;
    if (x == 'tinfoil') return true;
    if (x == 'tinful') return true;
    if (x == 'tinsel') return true;
    if (x == 'tirl') return true;
    if (x == 'tissual') return true;
    if (x == 'toadstool') return true;
    if (x == 'toenail') return true;
    if (x == 'toil') return true;
    if (x == 'toilful') return true;
    if (x == 'toll') return true;
    if (x == 'toluol') return true;
    if (x == 'toluyl') return true;
    if (x == 'tolyl') return true;
    if (x == 'tombal') return true;
    if (x == 'tomfool') return true;
    if (x == 'tonal') return true;
    if (x == 'tonsil') return true;
    if (x == 'tool') return true;
    if (x == 'topful') return true;
    if (x == 'topfull') return true;
    if (x == 'topical') return true;
    if (x == 'topographical') return true;
    if (x == 'topsail') return true;
    if (x == 'topsoil') return true;
    if (x == 'toroidal') return true;
    if (x == 'torrential') return true;
    if (x == 'torsional') return true;
    if (x == 'total') return true;
    if (x == 'towel') return true;
    if (x == 'toxical') return true;
    if (x == 'tracheal') return true;
    if (x == 'tractional') return true;
    if (x == 'traditional') return true;
    if (x == 'tragical') return true;
    if (x == 'trail') return true;
    if (x == 'trainful') return true;
    if (x == 'tramel') return true;
    if (x == 'tramell') return true;
    if (x == 'trammel') return true;
    if (x == 'tranquil') return true;
    if (x == 'transcendental') return true;
    if (x == 'transferal') return true;
    if (x == 'transitional') return true;
    if (x == 'transmittal') return true;
    if (x == 'transsubstantiational') return true;
    if (x == 'trapball') return true;
    if (x == 'trapezoidal') return true;
    if (x == 'travail') return true;
    if (x == 'travel') return true;
    if (x == 'trawl') return true;
    if (x == 'trayful') return true;
    if (x == 'treadmill') return true;
    if (x == 'treenail') return true;
    if (x == 'trefoil') return true;
    if (x == 'trenail') return true;
    if (x == 'tressel') return true;
    if (x == 'trial') return true;
    if (x == 'triaxial') return true;
    if (x == 'tribal') return true;
    if (x == 'tribunal') return true;
    if (x == 'triennial') return true;
    if (x == 'triethyl') return true;
    if (x == 'trifocal') return true;
    if (x == 'trigonal') return true;
    if (x == 'trigonometrical') return true;
    if (x == 'trill') return true;
    if (x == 'trilobal') return true;
    if (x == 'trinal') return true;
    if (x == 'trinodal') return true;
    if (x == 'triol') return true;
    if (x == 'tripedal') return true;
    if (x == 'tripodal') return true;
    if (x == 'tristful') return true;
    if (x == 'triumphal') return true;
    if (x == 'trivial') return true;
    if (x == 'trochal') return true;
    if (x == 'trochil') return true;
    if (x == 'troll') return true;
    if (x == 'trommel') return true;
    if (x == 'troopial') return true;
    if (x == 'tropical') return true;
    if (x == 'trotyl') return true;
    if (x == 'troupial') return true;
    if (x == 'trowel') return true;
    if (x == 'trull') return true;
    if (x == 'trunnel') return true;
    if (x == 'trustful') return true;
    if (x == 'truthful') return true;
    if (x == 'trysail') return true;
    if (x == 'tubal') return true;
    if (x == 'tubful') return true;
    if (x == 'tumbrel') return true;
    if (x == 'tumbril') return true;
    if (x == 'tumoral') return true;
    if (x == 'tuneful') return true;
    if (x == 'tunnel') return true;
    if (x == 'turbinal') return true;
    if (x == 'turmoil') return true;
    if (x == 'turnhall') return true;
    if (x == 'turrical') return true;
    if (x == 'tussal') return true;
    if (x == 'tutorial') return true;
    if (x == 'twibil') return true;
    if (x == 'twibill') return true;
    if (x == 'twill') return true;
    if (x == 'twirl') return true;
    if (x == 'tymbal') return true;
    if (x == 'tympanal') return true;
    if (x == 'typal') return true;
    if (x == 'typical') return true;
    if (x == 'typographical') return true;
    return nil;
  }
;
twiEscLE: TwiEscDataObject
  firstLetter = 'l'
  lastLetter  = 'e'
  isGoodWord(x) {
    if (x == 'labiate') return true;
    if (x == 'labile') return true;
    if (x == 'laborite') return true;
    if (x == 'labyrinthine') return true;
    if (x == 'lace') return true;
    if (x == 'lacelike') return true;
    if (x == 'lacerate') return true;
    if (x == 'lachrymose') return true;
    if (x == 'lacrosse') return true;
    if (x == 'lactase') return true;
    if (x == 'lactate') return true;
    if (x == 'lactone') return true;
    if (x == 'lactose') return true;
    if (x == 'lacunae') return true;
    if (x == 'lacunate') return true;
    if (x == 'lacune') return true;
    if (x == 'lacunose') return true;
    if (x == 'laddie') return true;
    if (x == 'lade') return true;
    if (x == 'ladle') return true;
    if (x == 'ladrone') return true;
    if (x == 'ladylike') return true;
    if (x == 'ladylove') return true;
    if (x == 'lagnappe') return true;
    if (x == 'lagniappe') return true;
    if (x == 'lagune') return true;
    if (x == 'laicise') return true;
    if (x == 'laicize') return true;
    if (x == 'laitance') return true;
    if (x == 'lake') return true;
    if (x == 'lakeside') return true;
    if (x == 'lambaste') return true;
    if (x == 'lambie') return true;
    if (x == 'lamblike') return true;
    if (x == 'lame') return true;
    if (x == 'lamellae') return true;
    if (x == 'lamentable') return true;
    if (x == 'lamiae') return true;
    if (x == 'laminae') return true;
    if (x == 'laminate') return true;
    if (x == 'laminose') return true;
    if (x == 'lanate') return true;
    if (x == 'lance') return true;
    if (x == 'landscape') return true;
    if (x == 'landside') return true;
    if (x == 'landslide') return true;
    if (x == 'lane') return true;
    if (x == 'langrage') return true;
    if (x == 'langsyne') return true;
    if (x == 'language') return true;
    if (x == 'langue') return true;
    if (x == 'lanoline') return true;
    if (x == 'lanose') return true;
    if (x == 'lanthanide') return true;
    if (x == 'lapidate') return true;
    if (x == 'lapsable') return true;
    if (x == 'lapse') return true;
    if (x == 'lapsible') return true;
    if (x == 'lardlike') return true;
    if (x == 'large') return true;
    if (x == 'largesse') return true;
    if (x == 'larine') return true;
    if (x == 'larksome') return true;
    if (x == 'larvae') return true;
    if (x == 'lasagne') return true;
    if (x == 'lase') return true;
    if (x == 'lassie') return true;
    if (x == 'lassitude') return true;
    if (x == 'late') return true;
    if (x == 'laterite') return true;
    if (x == 'lathe') return true;
    if (x == 'latinise') return true;
    if (x == 'latinize') return true;
    if (x == 'latitude') return true;
    if (x == 'latrine') return true;
    if (x == 'lattice') return true;
    if (x == 'laudable') return true;
    if (x == 'laughable') return true;
    if (x == 'launce') return true;
    if (x == 'laurae') return true;
    if (x == 'laureate') return true;
    if (x == 'lauwine') return true;
    if (x == 'lavage') return true;
    if (x == 'lavalike') return true;
    if (x == 'lave') return true;
    if (x == 'lawine') return true;
    if (x == 'lawlike') return true;
    if (x == 'laxative') return true;
    if (x == 'layerage') return true;
    if (x == 'layette') return true;
    if (x == 'laze') return true;
    if (x == 'lazulite') return true;
    if (x == 'lazurite') return true;
    if (x == 'leachate') return true;
    if (x == 'leafage') return true;
    if (x == 'leaflike') return true;
    if (x == 'league') return true;
    if (x == 'leakage') return true;
    if (x == 'leasable') return true;
    if (x == 'lease') return true;
    if (x == 'leave') return true;
    if (x == 'lecture') return true;
    if (x == 'ledge') return true;
    if (x == 'lee') return true;
    if (x == 'legalese') return true;
    if (x == 'legalise') return true;
    if (x == 'legalize') return true;
    if (x == 'legate') return true;
    if (x == 'legatee') return true;
    if (x == 'legatine') return true;
    if (x == 'legible') return true;
    if (x == 'legionnaire') return true;
    if (x == 'legislate') return true;
    if (x == 'legislative') return true;
    if (x == 'legislature') return true;
    if (x == 'legitimate') return true;
    if (x == 'leglike') return true;
    if (x == 'legume') return true;
    if (x == 'leisure') return true;
    if (x == 'lemonade') return true;
    if (x == 'lengthwise') return true;
    if (x == 'lenience') return true;
    if (x == 'lenitive') return true;
    if (x == 'lense') return true;
    if (x == 'leone') return true;
    if (x == 'leonine') return true;
    if (x == 'lepidote') return true;
    if (x == 'leporine') return true;
    if (x == 'leprose') return true;
    if (x == 'lessee') return true;
    if (x == 'lethe') return true;
    if (x == 'lettuce') return true;
    if (x == 'leucine') return true;
    if (x == 'leucite') return true;
    if (x == 'levee') return true;
    if (x == 'leverage') return true;
    if (x == 'leviable') return true;
    if (x == 'levigate') return true;
    if (x == 'levirate') return true;
    if (x == 'levitate') return true;
    if (x == 'levogyre') return true;
    if (x == 'levulose') return true;
    if (x == 'lewisite') return true;
    if (x == 'liable') return true;
    if (x == 'liaise') return true;
    if (x == 'liane') return true;
    if (x == 'libelee') return true;
    if (x == 'libellee') return true;
    if (x == 'liberalise') return true;
    if (x == 'liberalize') return true;
    if (x == 'liberate') return true;
    if (x == 'libertine') return true;
    if (x == 'librae') return true;
    if (x == 'librate') return true;
    if (x == 'lice') return true;
    if (x == 'licence') return true;
    if (x == 'licencee') return true;
    if (x == 'license') return true;
    if (x == 'licensee') return true;
    if (x == 'lichee') return true;
    if (x == 'licorice') return true;
    if (x == 'lie') return true;
    if (x == 'liege') return true;
    if (x == 'lienable') return true;
    if (x == 'lierne') return true;
    if (x == 'lieve') return true;
    if (x == 'life') return true;
    if (x == 'lifelike') return true;
    if (x == 'lifeline') return true;
    if (x == 'lifetime') return true;
    if (x == 'liftable') return true;
    if (x == 'ligase') return true;
    if (x == 'ligate') return true;
    if (x == 'ligative') return true;
    if (x == 'ligature') return true;
    if (x == 'lighthouse') return true;
    if (x == 'lignite') return true;
    if (x == 'ligroine') return true;
    if (x == 'ligulae') return true;
    if (x == 'ligulate') return true;
    if (x == 'ligule') return true;
    if (x == 'ligure') return true;
    if (x == 'likable') return true;
    if (x == 'like') return true;
    if (x == 'likeable') return true;
    if (x == 'likewise') return true;
    if (x == 'lilylike') return true;
    if (x == 'limacine') return true;
    if (x == 'limbate') return true;
    if (x == 'lime') return true;
    if (x == 'limeade') return true;
    if (x == 'limestone') return true;
    if (x == 'limonene') return true;
    if (x == 'limonite') return true;
    if (x == 'limousine') return true;
    if (x == 'linable') return true;
    if (x == 'linage') return true;
    if (x == 'lindane') return true;
    if (x == 'line') return true;
    if (x == 'lineable') return true;
    if (x == 'lineage') return true;
    if (x == 'lineate') return true;
    if (x == 'linelike') return true;
    if (x == 'lingerie') return true;
    if (x == 'linguae') return true;
    if (x == 'linguine') return true;
    if (x == 'linkable') return true;
    if (x == 'linkage') return true;
    if (x == 'lionise') return true;
    if (x == 'lionize') return true;
    if (x == 'lionlike') return true;
    if (x == 'lipase') return true;
    if (x == 'lipide') return true;
    if (x == 'liplike') return true;
    if (x == 'lipocyte') return true;
    if (x == 'liquate') return true;
    if (x == 'liquefiable') return true;
    if (x == 'liquidate') return true;
    if (x == 'lire') return true;
    if (x == 'liripipe') return true;
    if (x == 'lisle') return true;
    if (x == 'lissome') return true;
    if (x == 'listable') return true;
    if (x == 'literate') return true;
    if (x == 'literature') return true;
    if (x == 'litharge') return true;
    if (x == 'lithe') return true;
    if (x == 'lithesome') return true;
    if (x == 'litigate') return true;
    if (x == 'litre') return true;
    if (x == 'little') return true;
    if (x == 'livable') return true;
    if (x == 'live') return true;
    if (x == 'liveable') return true;
    if (x == 'livre') return true;
    if (x == 'loanable') return true;
    if (x == 'loathe') return true;
    if (x == 'loathsome') return true;
    if (x == 'lobate') return true;
    if (x == 'lobe') return true;
    if (x == 'lobeline') return true;
    if (x == 'lobulate') return true;
    if (x == 'lobule') return true;
    if (x == 'lobulose') return true;
    if (x == 'locale') return true;
    if (x == 'localise') return true;
    if (x == 'localite') return true;
    if (x == 'localize') return true;
    if (x == 'locate') return true;
    if (x == 'locative') return true;
    if (x == 'lockable') return true;
    if (x == 'lockage') return true;
    if (x == 'locomote') return true;
    if (x == 'locomotive') return true;
    if (x == 'loculate') return true;
    if (x == 'locule') return true;
    if (x == 'locustae') return true;
    if (x == 'lode') return true;
    if (x == 'lodge') return true;
    if (x == 'lodicule') return true;
    if (x == 'loge') return true;
    if (x == 'loggie') return true;
    if (x == 'logicise') return true;
    if (x == 'logicize') return true;
    if (x == 'logotype') return true;
    if (x == 'lone') return true;
    if (x == 'lonesome') return true;
    if (x == 'longe') return true;
    if (x == 'longitude') return true;
    if (x == 'longline') return true;
    if (x == 'longsome') return true;
    if (x == 'longtime') return true;
    if (x == 'longwise') return true;
    if (x == 'looie') return true;
    if (x == 'loophole') return true;
    if (x == 'loose') return true;
    if (x == 'lope') return true;
    if (x == 'lordlike') return true;
    if (x == 'lore') return true;
    if (x == 'loricae') return true;
    if (x == 'loricate') return true;
    if (x == 'losable') return true;
    if (x == 'lose') return true;
    if (x == 'lothsome') return true;
    if (x == 'louie') return true;
    if (x == 'lounge') return true;
    if (x == 'loupe') return true;
    if (x == 'louse') return true;
    if (x == 'louvre') return true;
    if (x == 'lovable') return true;
    if (x == 'lovage') return true;
    if (x == 'love') return true;
    if (x == 'loveable') return true;
    if (x == 'lovesome') return true;
    if (x == 'lovevine') return true;
    if (x == 'lowe') return true;
    if (x == 'lowercase') return true;
    if (x == 'lowlife') return true;
    if (x == 'lowse') return true;
    if (x == 'lozenge') return true;
    if (x == 'lube') return true;
    if (x == 'lubricate') return true;
    if (x == 'lucarne') return true;
    if (x == 'luce') return true;
    if (x == 'lucence') return true;
    if (x == 'lucerne') return true;
    if (x == 'luckie') return true;
    if (x == 'lucrative') return true;
    if (x == 'lucre') return true;
    if (x == 'luge') return true;
    if (x == 'luggage') return true;
    if (x == 'luggie') return true;
    if (x == 'luminance') return true;
    if (x == 'luminescence') return true;
    if (x == 'lunate') return true;
    if (x == 'lune') return true;
    if (x == 'lunette') return true;
    if (x == 'lunge') return true;
    if (x == 'lungee') return true;
    if (x == 'lunulae') return true;
    if (x == 'lunulate') return true;
    if (x == 'lunule') return true;
    if (x == 'lupine') return true;
    if (x == 'lurdane') return true;
    if (x == 'lure') return true;
    if (x == 'lustrate') return true;
    if (x == 'lustre') return true;
    if (x == 'lute') return true;
    if (x == 'luxate') return true;
    if (x == 'luxe') return true;
    if (x == 'luxuriance') return true;
    if (x == 'luxuriate') return true;
    if (x == 'lyase') return true;
    if (x == 'lycee') return true;
    if (x == 'lychee') return true;
    if (x == 'lycopene') return true;
    if (x == 'lyddite') return true;
    if (x == 'lye') return true;
    if (x == 'lyophile') return true;
    if (x == 'lyrate') return true;
    if (x == 'lyre') return true;
    if (x == 'lyricise') return true;
    if (x == 'lyricize') return true;
    if (x == 'lysate') return true;
    if (x == 'lyse') return true;
    if (x == 'lysine') return true;
    if (x == 'lysosome') return true;
    if (x == 'lysozyme') return true;
    if (x == 'lyttae') return true;
    return nil;
  }
;
twiEscEP: TwiEscDataObject
  firstLetter = 'e'
  lastLetter  = 'p'
  isGoodWord(x) {
    if (x == 'eardrop') return true;
    if (x == 'earflap') return true;
    if (x == 'earlap') return true;
    if (x == 'earlship') return true;
    if (x == 'eavesdrop') return true;
    if (x == 'eggcup') return true;
    if (x == 'encamp') return true;
    if (x == 'enclasp') return true;
    if (x == 'endocarp') return true;
    if (x == 'entrap') return true;
    if (x == 'envelop') return true;
    if (x == 'enwrap') return true;
    if (x == 'epicarp') return true;
    if (x == 'equip') return true;
    if (x == 'escallop') return true;
    if (x == 'escalop') return true;
    if (x == 'escarp') return true;
    if (x == 'estop') return true;
    if (x == 'exocarp') return true;
    if (x == 'eyecup') return true;
    return nil;
  }
;
twiEscPA: TwiEscDataObject
  firstLetter = 'p'
  lastLetter  = 'a'
  isGoodWord(x) {
    if (x == 'pa') return true;
    if (x == 'paca') return true;
    if (x == 'pacha') return true;
    if (x == 'paella') return true;
    if (x == 'pagoda') return true;
    if (x == 'paisa') return true;
    if (x == 'pajama') return true;
    if (x == 'palabra') return true;
    if (x == 'palea') return true;
    if (x == 'palestra') return true;
    if (x == 'palladia') return true;
    if (x == 'pallia') return true;
    if (x == 'palmyra') return true;
    if (x == 'palooka') return true;
    if (x == 'palpebra') return true;
    if (x == 'pampa') return true;
    if (x == 'panacea') return true;
    if (x == 'panada') return true;
    if (x == 'panama') return true;
    if (x == 'panatela') return true;
    if (x == 'panda') return true;
    if (x == 'pandora') return true;
    if (x == 'pandura') return true;
    if (x == 'panetela') return true;
    if (x == 'panga') return true;
    if (x == 'panmixia') return true;
    if (x == 'panocha') return true;
    if (x == 'panorama') return true;
    if (x == 'papa') return true;
    if (x == 'papaya') return true;
    if (x == 'papilla') return true;
    if (x == 'paprica') return true;
    if (x == 'paprika') return true;
    if (x == 'papula') return true;
    if (x == 'para') return true;
    if (x == 'parabola') return true;
    if (x == 'paramenta') return true;
    if (x == 'paranoea') return true;
    if (x == 'paranoia') return true;
    if (x == 'paraphernalia') return true;
    if (x == 'paraplegia') return true;
    if (x == 'pareira') return true;
    if (x == 'paresthesia') return true;
    if (x == 'parhelia') return true;
    if (x == 'parka') return true;
    if (x == 'partita') return true;
    if (x == 'parura') return true;
    if (x == 'pasha') return true;
    if (x == 'pasta') return true;
    if (x == 'pastina') return true;
    if (x == 'pataca') return true;
    if (x == 'patagia') return true;
    if (x == 'patella') return true;
    if (x == 'patina') return true;
    if (x == 'payola') return true;
    if (x == 'pea') return true;
    if (x == 'peculia') return true;
    if (x == 'pellagra') return true;
    if (x == 'peloria') return true;
    if (x == 'pelota') return true;
    if (x == 'pembina') return true;
    if (x == 'peninsula') return true;
    if (x == 'penna') return true;
    if (x == 'pennia') return true;
    if (x == 'pennsylvania') return true;
    if (x == 'penumbra') return true;
    if (x == 'pepla') return true;
    if (x == 'peponida') return true;
    if (x == 'perfecta') return true;
    if (x == 'pergola') return true;
    if (x == 'peridia') return true;
    if (x == 'perilla') return true;
    if (x == 'perinea') return true;
    if (x == 'persona') return true;
    if (x == 'peseta') return true;
    if (x == 'pesewa') return true;
    if (x == 'petechia') return true;
    if (x == 'petunia') return true;
    if (x == 'phelonia') return true;
    if (x == 'phenomena') return true;
    if (x == 'philadelphia') return true;
    if (x == 'phobia') return true;
    if (x == 'phobophobia') return true;
    if (x == 'photopia') return true;
    if (x == 'phyla') return true;
    if (x == 'pia') return true;
    if (x == 'piasaba') return true;
    if (x == 'piasava') return true;
    if (x == 'piassaba') return true;
    if (x == 'piassava') return true;
    if (x == 'piazza') return true;
    if (x == 'pica') return true;
    if (x == 'picara') return true;
    if (x == 'pieta') return true;
    if (x == 'pignora') return true;
    if (x == 'pika') return true;
    if (x == 'pilea') return true;
    if (x == 'pima') return true;
    if (x == 'pina') return true;
    if (x == 'pinata') return true;
    if (x == 'pineta') return true;
    if (x == 'pinna') return true;
    if (x == 'pinnula') return true;
    if (x == 'pinta') return true;
    if (x == 'pintada') return true;
    if (x == 'piragua') return true;
    if (x == 'pirana') return true;
    if (x == 'piranha') return true;
    if (x == 'piraya') return true;
    if (x == 'piscina') return true;
    if (x == 'pita') return true;
    if (x == 'pizza') return true;
    if (x == 'pizzeria') return true;
    if (x == 'placenta') return true;
    if (x == 'planaria') return true;
    if (x == 'planetaria') return true;
    if (x == 'planula') return true;
    if (x == 'plasma') return true;
    if (x == 'platina') return true;
    if (x == 'playa') return true;
    if (x == 'plaza') return true;
    if (x == 'plea') return true;
    if (x == 'plectra') return true;
    if (x == 'plena') return true;
    if (x == 'plethora') return true;
    if (x == 'pleura') return true;
    if (x == 'plica') return true;
    if (x == 'pneuma') return true;
    if (x == 'pneumonia') return true;
    if (x == 'podagra') return true;
    if (x == 'podesta') return true;
    if (x == 'podia') return true;
    if (x == 'pogonia') return true;
    if (x == 'poinsettia') return true;
    if (x == 'polenta') return true;
    if (x == 'polka') return true;
    if (x == 'pollinia') return true;
    if (x == 'polygala') return true;
    if (x == 'polynya') return true;
    if (x == 'polypnea') return true;
    if (x == 'polyuria') return true;
    if (x == 'poppa') return true;
    if (x == 'posada') return true;
    if (x == 'postcava') return true;
    if (x == 'precava') return true;
    if (x == 'prenomina') return true;
    if (x == 'presa') return true;
    if (x == 'presidia') return true;
    if (x == 'prima') return true;
    if (x == 'primula') return true;
    if (x == 'proa') return true;
    if (x == 'prodromata') return true;
    if (x == 'pronota') return true;
    if (x == 'propaganda') return true;
    if (x == 'propyla') return true;
    if (x == 'prosoma') return true;
    if (x == 'protea') return true;
    if (x == 'proteinuria') return true;
    if (x == 'protozoa') return true;
    if (x == 'prunella') return true;
    if (x == 'pruta') return true;
    if (x == 'pseudepigrapha') return true;
    if (x == 'pseudopodia') return true;
    if (x == 'psoralea') return true;
    if (x == 'psylla') return true;
    if (x == 'pteryla') return true;
    if (x == 'pucka') return true;
    if (x == 'pudenda') return true;
    if (x == 'pukka') return true;
    if (x == 'puma') return true;
    if (x == 'puna') return true;
    if (x == 'punka') return true;
    if (x == 'pupa') return true;
    if (x == 'puparia') return true;
    if (x == 'purana') return true;
    if (x == 'purda') return true;
    if (x == 'purpura') return true;
    if (x == 'putamina') return true;
    if (x == 'pya') return true;
    if (x == 'pyaemia') return true;
    if (x == 'pycnidia') return true;
    if (x == 'pyemia') return true;
    if (x == 'pygidia') return true;
    if (x == 'pyoderma') return true;
    if (x == 'pyorrhea') return true;
    if (x == 'pyrexia') return true;
    if (x == 'pyrola') return true;
    if (x == 'pyromania') return true;
    if (x == 'pyuria') return true;
    if (x == 'pyxidia') return true;
    return nil;
  }
;
twiEscAS: TwiEscDataObject
  firstLetter = 'a'
  lastLetter  = 's'
  isGoodWord(x) {
    if (x < 'ad') {                     // AA-AC
      if (isGoodWordAA(x)) return true;
      else return nil;
    }
    else if (x < 'al') {                // AD-AK
      if (isGoodWordAD(x)) return true;
      else return nil;
    }
    else if (x < 'an') {                // AL-AM
      if (isGoodWordAL(x)) return true;
      else return nil;
    }
    else if (x < 'aq') {                // AN-AP
      if (isGoodWordAN(x)) return true;
      else return nil;
    }
    else if (x < 'at') {                // AQ-AS
      if (isGoodWordAQ(x)) return true;
      else return nil;
    }
    else {                             // AT-AZ
      if (isGoodWordAT(x)) return true;
      else return nil;
    }
  }
  isGoodWordAA(x) {
    if (x == 'aahs') return true;
    if (x == 'aaliis') return true;
    if (x == 'aals') return true;
    if (x == 'aardvarks') return true;
    if (x == 'aardwolves') return true;
    if (x == 'aas') return true;
    if (x == 'aasvogels') return true;
    if (x == 'abacas') return true;
    if (x == 'abacus') return true;
    if (x == 'abacuses') return true;
    if (x == 'abakas') return true;
    if (x == 'abalones') return true;
    if (x == 'abamperes') return true;
    if (x == 'abamps') return true;
    if (x == 'abandonments') return true;
    if (x == 'abandons') return true;
    if (x == 'abas') return true;
    if (x == 'abasements') return true;
    if (x == 'abasers') return true;
    if (x == 'abases') return true;
    if (x == 'abashes') return true;
    if (x == 'abatements') return true;
    if (x == 'abaters') return true;
    if (x == 'abates') return true;
    if (x == 'abatis') return true;
    if (x == 'abatises') return true;
    if (x == 'abators') return true;
    if (x == 'abattis') return true;
    if (x == 'abattises') return true;
    if (x == 'abattoirs') return true;
    if (x == 'abbacies') return true;
    if (x == 'abbes') return true;
    if (x == 'abbess') return true;
    if (x == 'abbesses') return true;
    if (x == 'abbeys') return true;
    if (x == 'abbotcies') return true;
    if (x == 'abbots') return true;
    if (x == 'abbreviates') return true;
    if (x == 'abbreviations') return true;
    if (x == 'abdicates') return true;
    if (x == 'abdications') return true;
    if (x == 'abdomens') return true;
    if (x == 'abducens') return true;
    if (x == 'abducentes') return true;
    if (x == 'abduces') return true;
    if (x == 'abductores') return true;
    if (x == 'abductors') return true;
    if (x == 'abducts') return true;
    if (x == 'abeles') return true;
    if (x == 'abelmosks') return true;
    if (x == 'aberrants') return true;
    if (x == 'aberrations') return true;
    if (x == 'abetments') return true;
    if (x == 'abets') return true;
    if (x == 'abettals') return true;
    if (x == 'abetters') return true;
    if (x == 'abettors') return true;
    if (x == 'abeyances') return true;
    if (x == 'abeyancies') return true;
    if (x == 'abfarads') return true;
    if (x == 'abhenries') return true;
    if (x == 'abhenrys') return true;
    if (x == 'abhorrences') return true;
    if (x == 'abhorrers') return true;
    if (x == 'abhors') return true;
    if (x == 'abidances') return true;
    if (x == 'abiders') return true;
    if (x == 'abides') return true;
    if (x == 'abies') return true;
    if (x == 'abigails') return true;
    if (x == 'abilities') return true;
    if (x == 'abioses') return true;
    if (x == 'abiosis') return true;
    if (x == 'abjectness') return true;
    if (x == 'abjectnesses') return true;
    if (x == 'abjurations') return true;
    if (x == 'abjurers') return true;
    if (x == 'abjures') return true;
    if (x == 'ablates') return true;
    if (x == 'ablations') return true;
    if (x == 'ablatives') return true;
    if (x == 'ablauts') return true;
    if (x == 'ablegates') return true;
    if (x == 'ables') return true;
    if (x == 'ablings') return true;
    if (x == 'ablins') return true;
    if (x == 'abluents') return true;
    if (x == 'ablutions') return true;
    if (x == 'abmhos') return true;
    if (x == 'abnegates') return true;
    if (x == 'abnegations') return true;
    if (x == 'abnormalities') return true;
    if (x == 'abnormals') return true;
    if (x == 'abodes') return true;
    if (x == 'abohms') return true;
    if (x == 'aboideaus') return true;
    if (x == 'aboiteaus') return true;
    if (x == 'abolishes') return true;
    if (x == 'abolitions') return true;
    if (x == 'abomas') return true;
    if (x == 'abomasus') return true;
    if (x == 'abominates') return true;
    if (x == 'abominations') return true;
    if (x == 'aborigines') return true;
    if (x == 'aborters') return true;
    if (x == 'abortions') return true;
    if (x == 'aborts') return true;
    if (x == 'abos') return true;
    if (x == 'aboulias') return true;
    if (x == 'abounds') return true;
    if (x == 'aboves') return true;
    if (x == 'abradants') return true;
    if (x == 'abraders') return true;
    if (x == 'abrades') return true;
    if (x == 'abrasions') return true;
    if (x == 'abrasiveness') return true;
    if (x == 'abrasivenesses') return true;
    if (x == 'abrasives') return true;
    if (x == 'abreacts') return true;
    if (x == 'abridgements') return true;
    if (x == 'abridgers') return true;
    if (x == 'abridges') return true;
    if (x == 'abridgments') return true;
    if (x == 'abris') return true;
    if (x == 'abrogates') return true;
    if (x == 'abscess') return true;
    if (x == 'abscesses') return true;
    if (x == 'abscises') return true;
    if (x == 'abscisins') return true;
    if (x == 'abscissas') return true;
    if (x == 'absconds') return true;
    if (x == 'absences') return true;
    if (x == 'absentees') return true;
    if (x == 'absenters') return true;
    if (x == 'absentmindedness') return true;
    if (x == 'absentmindednesses') return true;
    if (x == 'absents') return true;
    if (x == 'absinthes') return true;
    if (x == 'absinths') return true;
    if (x == 'absolutes') return true;
    if (x == 'absolutions') return true;
    if (x == 'absolvers') return true;
    if (x == 'absolves') return true;
    if (x == 'absorbencies') return true;
    if (x == 'absorbers') return true;
    if (x == 'absorbs') return true;
    if (x == 'absorptions') return true;
    if (x == 'abstainers') return true;
    if (x == 'abstains') return true;
    if (x == 'abstemious') return true;
    if (x == 'abstentions') return true;
    if (x == 'absterges') return true;
    if (x == 'abstinences') return true;
    if (x == 'abstractions') return true;
    if (x == 'abstractness') return true;
    if (x == 'abstractnesses') return true;
    if (x == 'abstracts') return true;
    if (x == 'abstricts') return true;
    if (x == 'abstruseness') return true;
    if (x == 'abstrusenesses') return true;
    if (x == 'absurdities') return true;
    if (x == 'absurds') return true;
    if (x == 'abulias') return true;
    if (x == 'abundances') return true;
    if (x == 'abusers') return true;
    if (x == 'abuses') return true;
    if (x == 'abusiveness') return true;
    if (x == 'abusivenesses') return true;
    if (x == 'abutilons') return true;
    if (x == 'abutments') return true;
    if (x == 'abuts') return true;
    if (x == 'abuttals') return true;
    if (x == 'abutters') return true;
    if (x == 'abvolts') return true;
    if (x == 'abwatts') return true;
    if (x == 'abyes') return true;
    if (x == 'abys') return true;
    if (x == 'abysms') return true;
    if (x == 'abyss') return true;
    if (x == 'abysses') return true;
    if (x == 'acacias') return true;
    if (x == 'academes') return true;
    if (x == 'academias') return true;
    if (x == 'academics') return true;
    if (x == 'academies') return true;
    if (x == 'acajous') return true;
    if (x == 'acalephes') return true;
    if (x == 'acalephs') return true;
    if (x == 'acanthus') return true;
    if (x == 'acanthuses') return true;
    if (x == 'acaridans') return true;
    if (x == 'acarids') return true;
    if (x == 'acarines') return true;
    if (x == 'acarpous') return true;
    if (x == 'acarus') return true;
    if (x == 'acaulous') return true;
    if (x == 'acceders') return true;
    if (x == 'accedes') return true;
    if (x == 'accelerates') return true;
    if (x == 'accelerations') return true;
    if (x == 'accelerators') return true;
    if (x == 'accentors') return true;
    if (x == 'accents') return true;
    if (x == 'accentuates') return true;
    if (x == 'accentuations') return true;
    if (x == 'acceptabilities') return true;
    if (x == 'acceptances') return true;
    if (x == 'acceptees') return true;
    if (x == 'accepters') return true;
    if (x == 'acceptors') return true;
    if (x == 'accepts') return true;
    if (x == 'access') return true;
    if (x == 'accesses') return true;
    if (x == 'accessibilities') return true;
    if (x == 'accessions') return true;
    if (x == 'accessories') return true;
    if (x == 'accidentals') return true;
    if (x == 'accidents') return true;
    if (x == 'accidies') return true;
    if (x == 'acclaims') return true;
    if (x == 'acclamations') return true;
    if (x == 'acclimates') return true;
    if (x == 'acclimations') return true;
    if (x == 'acclimatisations') return true;
    if (x == 'acclimatises') return true;
    if (x == 'acclimatizations') return true;
    if (x == 'acclimatizes') return true;
    if (x == 'accolades') return true;
    if (x == 'accommodates') return true;
    if (x == 'accommodations') return true;
    if (x == 'accompanies') return true;
    if (x == 'accompaniments') return true;
    if (x == 'accomplices') return true;
    if (x == 'accomplishers') return true;
    if (x == 'accomplishes') return true;
    if (x == 'accomplishments') return true;
    if (x == 'accorders') return true;
    if (x == 'accordions') return true;
    if (x == 'accords') return true;
    if (x == 'accosts') return true;
    if (x == 'accountabilities') return true;
    if (x == 'accountancies') return true;
    if (x == 'accountants') return true;
    if (x == 'accountings') return true;
    if (x == 'accounts') return true;
    if (x == 'accouters') return true;
    if (x == 'accoutrements') return true;
    if (x == 'accoutres') return true;
    if (x == 'accredits') return true;
    if (x == 'accretes') return true;
    if (x == 'accruals') return true;
    if (x == 'accrues') return true;
    if (x == 'accumulates') return true;
    if (x == 'accumulations') return true;
    if (x == 'accumulators') return true;
    if (x == 'accuracies') return true;
    if (x == 'accurateness') return true;
    if (x == 'accuratenesses') return true;
    if (x == 'accusals') return true;
    if (x == 'accusants') return true;
    if (x == 'accusations') return true;
    if (x == 'accusers') return true;
    if (x == 'accuses') return true;
    if (x == 'accustoms') return true;
    if (x == 'acedias') return true;
    if (x == 'aceldamas') return true;
    if (x == 'acequias') return true;
    if (x == 'acerbates') return true;
    if (x == 'acerbities') return true;
    if (x == 'acerolas') return true;
    if (x == 'acerous') return true;
    if (x == 'acers') return true;
    if (x == 'aces') return true;
    if (x == 'acescents') return true;
    if (x == 'acetals') return true;
    if (x == 'acetamids') return true;
    if (x == 'acetates') return true;
    if (x == 'acetifies') return true;
    if (x == 'acetones') return true;
    if (x == 'acetous') return true;
    if (x == 'acetoxyls') return true;
    if (x == 'acetylenes') return true;
    if (x == 'acetyls') return true;
    if (x == 'achenes') return true;
    if (x == 'aches') return true;
    if (x == 'achievements') return true;
    if (x == 'achievers') return true;
    if (x == 'achieves') return true;
    if (x == 'achiness') return true;
    if (x == 'achinesses') return true;
    if (x == 'achiotes') return true;
    if (x == 'achromats') return true;
    if (x == 'aciculas') return true;
    if (x == 'acidheads') return true;
    if (x == 'acidifies') return true;
    if (x == 'acidities') return true;
    if (x == 'acidness') return true;
    if (x == 'acidnesses') return true;
    if (x == 'acidoses') return true;
    if (x == 'acidosis') return true;
    if (x == 'acids') return true;
    if (x == 'acierates') return true;
    if (x == 'acinous') return true;
    if (x == 'acinus') return true;
    if (x == 'acknowledgements') return true;
    if (x == 'acknowledges') return true;
    if (x == 'acknowledgments') return true;
    if (x == 'acmes') return true;
    if (x == 'acnes') return true;
    if (x == 'acnodes') return true;
    if (x == 'acolytes') return true;
    if (x == 'aconites') return true;
    if (x == 'aconitums') return true;
    if (x == 'acorns') return true;
    if (x == 'acoustics') return true;
    if (x == 'acquaintances') return true;
    if (x == 'acquaintanceships') return true;
    if (x == 'acquaints') return true;
    if (x == 'acquests') return true;
    if (x == 'acquiescences') return true;
    if (x == 'acquiesces') return true;
    if (x == 'acquirers') return true;
    if (x == 'acquires') return true;
    if (x == 'acquisitions') return true;
    if (x == 'acquits') return true;
    if (x == 'acrasins') return true;
    if (x == 'acreages') return true;
    if (x == 'acres') return true;
    if (x == 'acridines') return true;
    if (x == 'acridities') return true;
    if (x == 'acridness') return true;
    if (x == 'acridnesses') return true;
    if (x == 'acrimonies') return true;
    if (x == 'acrimonious') return true;
    if (x == 'acrobats') return true;
    if (x == 'acrodonts') return true;
    if (x == 'acrogens') return true;
    if (x == 'acroleins') return true;
    if (x == 'acroliths') return true;
    if (x == 'acronyms') return true;
    if (x == 'across') return true;
    if (x == 'acrostics') return true;
    if (x == 'acrotisms') return true;
    if (x == 'acrylates') return true;
    if (x == 'acrylics') return true;
    if (x == 'actings') return true;
    if (x == 'actinians') return true;
    if (x == 'actinias') return true;
    if (x == 'actinides') return true;
    if (x == 'actinisms') return true;
    if (x == 'actiniums') return true;
    if (x == 'actinoids') return true;
    if (x == 'actinons') return true;
    if (x == 'actins') return true;
    if (x == 'actions') return true;
    if (x == 'activates') return true;
    if (x == 'activations') return true;
    if (x == 'actives') return true;
    if (x == 'activisms') return true;
    if (x == 'activists') return true;
    if (x == 'activities') return true;
    if (x == 'actors') return true;
    if (x == 'actress') return true;
    if (x == 'actresses') return true;
    if (x == 'acts') return true;
    if (x == 'actualisations') return true;
    if (x == 'actualises') return true;
    if (x == 'actualities') return true;
    if (x == 'actualizations') return true;
    if (x == 'actualizes') return true;
    if (x == 'actuaries') return true;
    if (x == 'actuates') return true;
    if (x == 'actuators') return true;
    if (x == 'acuities') return true;
    if (x == 'acumens') return true;
    if (x == 'acupunctures') return true;
    if (x == 'acupuncturists') return true;
    if (x == 'acutances') return true;
    if (x == 'acuteness') return true;
    if (x == 'acutenesses') return true;
    if (x == 'acutes') return true;
    if (x == 'acylates') return true;
    if (x == 'acyls') return true;
    return nil;
  }
  isGoodWordAD(x) {
    if (x == 'adages') return true;
    if (x == 'adagios') return true;
    if (x == 'adamances') return true;
    if (x == 'adamancies') return true;
    if (x == 'adamantlies') return true;
    if (x == 'adamants') return true;
    if (x == 'adamsites') return true;
    if (x == 'adaptabilities') return true;
    if (x == 'adaptations') return true;
    if (x == 'adapters') return true;
    if (x == 'adaptions') return true;
    if (x == 'adaptors') return true;
    if (x == 'adapts') return true;
    if (x == 'addaxes') return true;
    if (x == 'addends') return true;
    if (x == 'adders') return true;
    if (x == 'addictions') return true;
    if (x == 'addicts') return true;
    if (x == 'additions') return true;
    if (x == 'additives') return true;
    if (x == 'addles') return true;
    if (x == 'address') return true;
    if (x == 'addresses') return true;
    if (x == 'adds') return true;
    if (x == 'adducers') return true;
    if (x == 'adduces') return true;
    if (x == 'adductors') return true;
    if (x == 'adducts') return true;
    if (x == 'adeems') return true;
    if (x == 'adenines') return true;
    if (x == 'adenitis') return true;
    if (x == 'adenitises') return true;
    if (x == 'adenoids') return true;
    if (x == 'adenomas') return true;
    if (x == 'adenyls') return true;
    if (x == 'adeptness') return true;
    if (x == 'adeptnesses') return true;
    if (x == 'adepts') return true;
    if (x == 'adequacies') return true;
    if (x == 'adherences') return true;
    if (x == 'adherends') return true;
    if (x == 'adherents') return true;
    if (x == 'adherers') return true;
    if (x == 'adheres') return true;
    if (x == 'adhesions') return true;
    if (x == 'adhesives') return true;
    if (x == 'adhibits') return true;
    if (x == 'adieus') return true;
    if (x == 'adios') return true;
    if (x == 'adiposes') return true;
    if (x == 'adiposis') return true;
    if (x == 'adipous') return true;
    if (x == 'adits') return true;
    if (x == 'adjectives') return true;
    if (x == 'adjoins') return true;
    if (x == 'adjoints') return true;
    if (x == 'adjournments') return true;
    if (x == 'adjourns') return true;
    if (x == 'adjudges') return true;
    if (x == 'adjudicates') return true;
    if (x == 'adjudications') return true;
    if (x == 'adjuncts') return true;
    if (x == 'adjurers') return true;
    if (x == 'adjures') return true;
    if (x == 'adjurors') return true;
    if (x == 'adjusters') return true;
    if (x == 'adjustments') return true;
    if (x == 'adjustors') return true;
    if (x == 'adjusts') return true;
    if (x == 'adjutants') return true;
    if (x == 'adjuvants') return true;
    if (x == 'admass') return true;
    if (x == 'administers') return true;
    if (x == 'administrants') return true;
    if (x == 'administrations') return true;
    if (x == 'administrators') return true;
    if (x == 'adminstrations') return true;
    if (x == 'admirals') return true;
    if (x == 'admirations') return true;
    if (x == 'admirers') return true;
    if (x == 'admires') return true;
    if (x == 'admissibilities') return true;
    if (x == 'admissions') return true;
    if (x == 'admits') return true;
    if (x == 'admittances') return true;
    if (x == 'admitters') return true;
    if (x == 'admixes') return true;
    if (x == 'admixtures') return true;
    if (x == 'admonishes') return true;
    if (x == 'adnations') return true;
    if (x == 'adnouns') return true;
    if (x == 'adobes') return true;
    if (x == 'adolescences') return true;
    if (x == 'adolescents') return true;
    if (x == 'adoptees') return true;
    if (x == 'adopters') return true;
    if (x == 'adoptions') return true;
    if (x == 'adopts') return true;
    if (x == 'adorations') return true;
    if (x == 'adorers') return true;
    if (x == 'adores') return true;
    if (x == 'adorners') return true;
    if (x == 'adorns') return true;
    if (x == 'ados') return true;
    if (x == 'adrenals') return true;
    if (x == 'adroitness') return true;
    if (x == 'adroitnesses') return true;
    if (x == 'ads') return true;
    if (x == 'adscripts') return true;
    if (x == 'adsorbs') return true;
    if (x == 'adularias') return true;
    if (x == 'adulates') return true;
    if (x == 'adulators') return true;
    if (x == 'adulterates') return true;
    if (x == 'adulterations') return true;
    if (x == 'adulterers') return true;
    if (x == 'adulteress') return true;
    if (x == 'adulteresses') return true;
    if (x == 'adulteries') return true;
    if (x == 'adulterous') return true;
    if (x == 'adulthoods') return true;
    if (x == 'adults') return true;
    if (x == 'aduncous') return true;
    if (x == 'advancements') return true;
    if (x == 'advancers') return true;
    if (x == 'advances') return true;
    if (x == 'advantageous') return true;
    if (x == 'advantages') return true;
    if (x == 'adventitious') return true;
    if (x == 'adventitiousness') return true;
    if (x == 'adventitiousnesses') return true;
    if (x == 'advents') return true;
    if (x == 'adventurers') return true;
    if (x == 'adventures') return true;
    if (x == 'adventurous') return true;
    if (x == 'adverbs') return true;
    if (x == 'adversaries') return true;
    if (x == 'advertisements') return true;
    if (x == 'advertisers') return true;
    if (x == 'advertises') return true;
    if (x == 'advertisings') return true;
    if (x == 'adverts') return true;
    if (x == 'advices') return true;
    if (x == 'advisabilities') return true;
    if (x == 'advisees') return true;
    if (x == 'advisements') return true;
    if (x == 'advisers') return true;
    if (x == 'advises') return true;
    if (x == 'advisories') return true;
    if (x == 'advisors') return true;
    if (x == 'advocacies') return true;
    if (x == 'advocates') return true;
    if (x == 'advowsons') return true;
    if (x == 'adynamias') return true;
    if (x == 'adzes') return true;
    if (x == 'aedes') return true;
    if (x == 'aediles') return true;
    if (x == 'aegis') return true;
    if (x == 'aegises') return true;
    if (x == 'aeneous') return true;
    if (x == 'aeneus') return true;
    if (x == 'aeons') return true;
    if (x == 'aerates') return true;
    if (x == 'aerations') return true;
    if (x == 'aerators') return true;
    if (x == 'aerials') return true;
    if (x == 'aeries') return true;
    if (x == 'aerifies') return true;
    if (x == 'aerobes') return true;
    if (x == 'aeroducts') return true;
    if (x == 'aerodynamics') return true;
    if (x == 'aerodynes') return true;
    if (x == 'aerofoils') return true;
    if (x == 'aerogels') return true;
    if (x == 'aerograms') return true;
    if (x == 'aerolites') return true;
    if (x == 'aeroliths') return true;
    if (x == 'aerologies') return true;
    if (x == 'aeronautics') return true;
    if (x == 'aeronauts') return true;
    if (x == 'aeronomies') return true;
    if (x == 'aeroplanes') return true;
    if (x == 'aerosols') return true;
    if (x == 'aerostats') return true;
    if (x == 'aerugos') return true;
    if (x == 'aesthetes') return true;
    if (x == 'aesthetics') return true;
    if (x == 'aethers') return true;
    if (x == 'afars') return true;
    if (x == 'affabilities') return true;
    if (x == 'affaires') return true;
    if (x == 'affairs') return true;
    if (x == 'affectations') return true;
    if (x == 'affecters') return true;
    if (x == 'affections') return true;
    if (x == 'affects') return true;
    if (x == 'affiances') return true;
    if (x == 'affiants') return true;
    if (x == 'affiches') return true;
    if (x == 'affidavits') return true;
    if (x == 'affiliates') return true;
    if (x == 'affiliations') return true;
    if (x == 'affines') return true;
    if (x == 'affinities') return true;
    if (x == 'affirmations') return true;
    if (x == 'affirmatives') return true;
    if (x == 'affirmers') return true;
    if (x == 'affirms') return true;
    if (x == 'affixers') return true;
    if (x == 'affixes') return true;
    if (x == 'afflatus') return true;
    if (x == 'afflatuses') return true;
    if (x == 'afflictions') return true;
    if (x == 'afflicts') return true;
    if (x == 'affluences') return true;
    if (x == 'affluents') return true;
    if (x == 'affluxes') return true;
    if (x == 'affords') return true;
    if (x == 'afforests') return true;
    if (x == 'affrayers') return true;
    if (x == 'affrays') return true;
    if (x == 'affrights') return true;
    if (x == 'affronts') return true;
    if (x == 'affusions') return true;
    if (x == 'afghanis') return true;
    if (x == 'afghans') return true;
    if (x == 'afreets') return true;
    if (x == 'afrits') return true;
    if (x == 'afterlifes') return true;
    if (x == 'aftermaths') return true;
    if (x == 'afternoons') return true;
    if (x == 'afters') return true;
    if (x == 'afterthoughts') return true;
    if (x == 'afterwards') return true;
    if (x == 'aftosas') return true;
    if (x == 'agallochs') return true;
    if (x == 'agalwoods') return true;
    if (x == 'agamas') return true;
    if (x == 'agametes') return true;
    if (x == 'agamous') return true;
    if (x == 'agarics') return true;
    if (x == 'agars') return true;
    if (x == 'agas') return true;
    if (x == 'agates') return true;
    if (x == 'agatizes') return true;
    if (x == 'agaves') return true;
    if (x == 'agedness') return true;
    if (x == 'agednesses') return true;
    if (x == 'ageings') return true;
    if (x == 'ageless') return true;
    if (x == 'agencies') return true;
    if (x == 'agendas') return true;
    if (x == 'agendums') return true;
    if (x == 'agenes') return true;
    if (x == 'ageneses') return true;
    if (x == 'agenesias') return true;
    if (x == 'agenesis') return true;
    if (x == 'agenizes') return true;
    if (x == 'agentries') return true;
    if (x == 'agents') return true;
    if (x == 'ageratums') return true;
    if (x == 'agers') return true;
    if (x == 'ages') return true;
    if (x == 'aggers') return true;
    if (x == 'aggies') return true;
    if (x == 'aggrades') return true;
    if (x == 'aggrandisements') return true;
    if (x == 'aggrandises') return true;
    if (x == 'aggrandizements') return true;
    if (x == 'aggrandizes') return true;
    if (x == 'aggravates') return true;
    if (x == 'aggravations') return true;
    if (x == 'aggregates') return true;
    if (x == 'aggress') return true;
    if (x == 'aggresses') return true;
    if (x == 'aggressions') return true;
    if (x == 'aggressiveness') return true;
    if (x == 'aggressivenesses') return true;
    if (x == 'aggrieves') return true;
    if (x == 'aghas') return true;
    if (x == 'agilities') return true;
    if (x == 'agings') return true;
    if (x == 'aginners') return true;
    if (x == 'agios') return true;
    if (x == 'agiotages') return true;
    if (x == 'agists') return true;
    if (x == 'agitates') return true;
    if (x == 'agitations') return true;
    if (x == 'agitators') return true;
    if (x == 'agitprops') return true;
    if (x == 'aglets') return true;
    if (x == 'aglycones') return true;
    if (x == 'aglycons') return true;
    if (x == 'agmas') return true;
    if (x == 'agnails') return true;
    if (x == 'agnates') return true;
    if (x == 'agnations') return true;
    if (x == 'agnises') return true;
    if (x == 'agnizes') return true;
    if (x == 'agnomens') return true;
    if (x == 'agnostics') return true;
    if (x == 'agones') return true;
    if (x == 'agonies') return true;
    if (x == 'agonises') return true;
    if (x == 'agonists') return true;
    if (x == 'agonizes') return true;
    if (x == 'agons') return true;
    if (x == 'agoraphobics') return true;
    if (x == 'agoras') return true;
    if (x == 'agouties') return true;
    if (x == 'agoutis') return true;
    if (x == 'agrafes') return true;
    if (x == 'agraffes') return true;
    if (x == 'agraphias') return true;
    if (x == 'agrarianisms') return true;
    if (x == 'agrarians') return true;
    if (x == 'agreeableness') return true;
    if (x == 'agreeablenesses') return true;
    if (x == 'agreements') return true;
    if (x == 'agrees') return true;
    if (x == 'agriculturalists') return true;
    if (x == 'agricultures') return true;
    if (x == 'agriculturists') return true;
    if (x == 'agrimonies') return true;
    if (x == 'agrologies') return true;
    if (x == 'agronomies') return true;
    if (x == 'agues') return true;
    if (x == 'agueweeds') return true;
    if (x == 'ahimsas') return true;
    if (x == 'aholds') return true;
    if (x == 'ahoys') return true;
    if (x == 'aiblins') return true;
    if (x == 'aiders') return true;
    if (x == 'aides') return true;
    if (x == 'aidless') return true;
    if (x == 'aids') return true;
    if (x == 'aiglets') return true;
    if (x == 'aigrets') return true;
    if (x == 'aigrettes') return true;
    if (x == 'aiguilles') return true;
    if (x == 'aikidos') return true;
    if (x == 'ailerons') return true;
    if (x == 'ailments') return true;
    if (x == 'ails') return true;
    if (x == 'aimers') return true;
    if (x == 'aimless') return true;
    if (x == 'aimlessness') return true;
    if (x == 'aimlessnesses') return true;
    if (x == 'aims') return true;
    if (x == 'ains') return true;
    if (x == 'ainsells') return true;
    if (x == 'airboats') return true;
    if (x == 'airbrushes') return true;
    if (x == 'airbursts') return true;
    if (x == 'airbus') return true;
    if (x == 'airbuses') return true;
    if (x == 'airbusses') return true;
    if (x == 'aircoaches') return true;
    if (x == 'airconditions') return true;
    if (x == 'aircrews') return true;
    if (x == 'airdromes') return true;
    if (x == 'airdrops') return true;
    if (x == 'airfields') return true;
    if (x == 'airflows') return true;
    if (x == 'airfoils') return true;
    if (x == 'airframes') return true;
    if (x == 'airglows') return true;
    if (x == 'airheads') return true;
    if (x == 'airiness') return true;
    if (x == 'airinesses') return true;
    if (x == 'airings') return true;
    if (x == 'airless') return true;
    if (x == 'airlifts') return true;
    if (x == 'airliners') return true;
    if (x == 'airlines') return true;
    if (x == 'airmails') return true;
    if (x == 'airns') return true;
    if (x == 'airparks') return true;
    if (x == 'airplanes') return true;
    if (x == 'airports') return true;
    if (x == 'airposts') return true;
    if (x == 'airproofs') return true;
    if (x == 'airs') return true;
    if (x == 'airscrews') return true;
    if (x == 'airships') return true;
    if (x == 'airspaces') return true;
    if (x == 'airspeeds') return true;
    if (x == 'airstrips') return true;
    if (x == 'airths') return true;
    if (x == 'airts') return true;
    if (x == 'airwaves') return true;
    if (x == 'airways') return true;
    if (x == 'ais') return true;
    if (x == 'aisles') return true;
    if (x == 'aitches') return true;
    if (x == 'aits') return true;
    if (x == 'aivers') return true;
    if (x == 'ajivas') return true;
    if (x == 'ajowans') return true;
    if (x == 'akees') return true;
    if (x == 'akelas') return true;
    if (x == 'akenes') return true;
    if (x == 'akvavits') return true;
    return nil;
  }
  isGoodWordAL(x) {
    if (x == 'alabasters') return true;
    if (x == 'alacrities') return true;
    if (x == 'alamedas') return true;
    if (x == 'alamodes') return true;
    if (x == 'alamos') return true;
    if (x == 'alands') return true;
    if (x == 'alanines') return true;
    if (x == 'alanins') return true;
    if (x == 'alans') return true;
    if (x == 'alants') return true;
    if (x == 'alanyls') return true;
    if (x == 'alarmisms') return true;
    if (x == 'alarmists') return true;
    if (x == 'alarms') return true;
    if (x == 'alarums') return true;
    if (x == 'alas') return true;
    if (x == 'alaskas') return true;
    if (x == 'alastors') return true;
    if (x == 'alations') return true;
    if (x == 'albacores') return true;
    if (x == 'albas') return true;
    if (x == 'albatas') return true;
    if (x == 'albatross') return true;
    if (x == 'albatrosses') return true;
    if (x == 'albedos') return true;
    if (x == 'albicores') return true;
    if (x == 'albinisms') return true;
    if (x == 'albinos') return true;
    if (x == 'albites') return true;
    if (x == 'albs') return true;
    if (x == 'albumens') return true;
    if (x == 'albumins') return true;
    if (x == 'albumoses') return true;
    if (x == 'albums') return true;
    if (x == 'alburnums') return true;
    if (x == 'alcades') return true;
    if (x == 'alcahests') return true;
    if (x == 'alcaics') return true;
    if (x == 'alcaides') return true;
    if (x == 'alcaldes') return true;
    if (x == 'alcaydes') return true;
    if (x == 'alcazars') return true;
    if (x == 'alchemies') return true;
    if (x == 'alchemists') return true;
    if (x == 'alchymies') return true;
    if (x == 'alcoholics') return true;
    if (x == 'alcoholisms') return true;
    if (x == 'alcohols') return true;
    if (x == 'alcoves') return true;
    if (x == 'aldehydes') return true;
    if (x == 'alders') return true;
    if (x == 'aldolases') return true;
    if (x == 'aldols') return true;
    if (x == 'aldoses') return true;
    if (x == 'aldrins') return true;
    if (x == 'alecs') return true;
    if (x == 'alefs') return true;
    if (x == 'alegars') return true;
    if (x == 'alehouses') return true;
    if (x == 'alembics') return true;
    if (x == 'alephs') return true;
    if (x == 'alertness') return true;
    if (x == 'alertnesses') return true;
    if (x == 'alerts') return true;
    if (x == 'ales') return true;
    if (x == 'aleurones') return true;
    if (x == 'aleurons') return true;
    if (x == 'alevins') return true;
    if (x == 'alewives') return true;
    if (x == 'alexias') return true;
    if (x == 'alexines') return true;
    if (x == 'alexins') return true;
    if (x == 'alfakis') return true;
    if (x == 'alfalfas') return true;
    if (x == 'alfaquins') return true;
    if (x == 'alfaquis') return true;
    if (x == 'alfas') return true;
    if (x == 'alforjas') return true;
    if (x == 'algarobas') return true;
    if (x == 'algas') return true;
    if (x == 'algebras') return true;
    if (x == 'algerines') return true;
    if (x == 'algicides') return true;
    if (x == 'algidities') return true;
    if (x == 'alginates') return true;
    if (x == 'algins') return true;
    if (x == 'algologies') return true;
    if (x == 'algorisms') return true;
    if (x == 'algorithms') return true;
    if (x == 'algors') return true;
    if (x == 'algums') return true;
    if (x == 'alias') return true;
    if (x == 'aliases') return true;
    if (x == 'alibies') return true;
    if (x == 'alibis') return true;
    if (x == 'alidades') return true;
    if (x == 'alidads') return true;
    if (x == 'alienages') return true;
    if (x == 'alienates') return true;
    if (x == 'alienations') return true;
    if (x == 'alienees') return true;
    if (x == 'alieners') return true;
    if (x == 'alienisms') return true;
    if (x == 'alienists') return true;
    if (x == 'alienors') return true;
    if (x == 'aliens') return true;
    if (x == 'alifs') return true;
    if (x == 'alights') return true;
    if (x == 'aligners') return true;
    if (x == 'alignments') return true;
    if (x == 'aligns') return true;
    if (x == 'aliments') return true;
    if (x == 'alimonies') return true;
    if (x == 'aliners') return true;
    if (x == 'alines') return true;
    if (x == 'alipeds') return true;
    if (x == 'aliquots') return true;
    if (x == 'aliyahs') return true;
    if (x == 'alizarins') return true;
    if (x == 'alkahests') return true;
    if (x == 'alkalies') return true;
    if (x == 'alkalifies') return true;
    if (x == 'alkalinities') return true;
    if (x == 'alkalis') return true;
    if (x == 'alkalises') return true;
    if (x == 'alkalizes') return true;
    if (x == 'alkaloids') return true;
    if (x == 'alkanes') return true;
    if (x == 'alkanets') return true;
    if (x == 'alkenes') return true;
    if (x == 'alkines') return true;
    if (x == 'alkyds') return true;
    if (x == 'alkylates') return true;
    if (x == 'alkyls') return true;
    if (x == 'alkynes') return true;
    if (x == 'allanites') return true;
    if (x == 'allayers') return true;
    if (x == 'allays') return true;
    if (x == 'allegations') return true;
    if (x == 'allegers') return true;
    if (x == 'alleges') return true;
    if (x == 'allegiances') return true;
    if (x == 'allegories') return true;
    if (x == 'allegros') return true;
    if (x == 'alleles') return true;
    if (x == 'allelisms') return true;
    if (x == 'alleluias') return true;
    if (x == 'allergens') return true;
    if (x == 'allergies') return true;
    if (x == 'allergins') return true;
    if (x == 'allergists') return true;
    if (x == 'alleviates') return true;
    if (x == 'alleviations') return true;
    if (x == 'alleys') return true;
    if (x == 'alleyways') return true;
    if (x == 'allheals') return true;
    if (x == 'alliances') return true;
    if (x == 'allies') return true;
    if (x == 'alligators') return true;
    if (x == 'alliterations') return true;
    if (x == 'alliums') return true;
    if (x == 'allobars') return true;
    if (x == 'allocates') return true;
    if (x == 'allocations') return true;
    if (x == 'allods') return true;
    if (x == 'allogamies') return true;
    if (x == 'allonges') return true;
    if (x == 'allonyms') return true;
    if (x == 'allopaths') return true;
    if (x == 'allotments') return true;
    if (x == 'allots') return true;
    if (x == 'allottees') return true;
    if (x == 'allotters') return true;
    if (x == 'allotypes') return true;
    if (x == 'allotypies') return true;
    if (x == 'allovers') return true;
    if (x == 'allowances') return true;
    if (x == 'allows') return true;
    if (x == 'alloxans') return true;
    if (x == 'alloys') return true;
    if (x == 'alls') return true;
    if (x == 'allseeds') return true;
    if (x == 'allspices') return true;
    if (x == 'alludes') return true;
    if (x == 'allurements') return true;
    if (x == 'allurers') return true;
    if (x == 'allures') return true;
    if (x == 'allusions') return true;
    if (x == 'allusiveness') return true;
    if (x == 'allusivenesses') return true;
    if (x == 'alluvials') return true;
    if (x == 'alluvions') return true;
    if (x == 'alluviums') return true;
    if (x == 'allyls') return true;
    if (x == 'almagests') return true;
    if (x == 'almahs') return true;
    if (x == 'almanacs') return true;
    if (x == 'almas') return true;
    if (x == 'almehs') return true;
    if (x == 'almemars') return true;
    if (x == 'almes') return true;
    if (x == 'almners') return true;
    if (x == 'almonds') return true;
    if (x == 'almoners') return true;
    if (x == 'almonries') return true;
    if (x == 'alms') return true;
    if (x == 'almuces') return true;
    if (x == 'almudes') return true;
    if (x == 'almuds') return true;
    if (x == 'almugs') return true;
    if (x == 'alnicoes') return true;
    if (x == 'aloes') return true;
    if (x == 'alohas') return true;
    if (x == 'aloins') return true;
    if (x == 'alopecias') return true;
    if (x == 'alpacas') return true;
    if (x == 'alphabetisers') return true;
    if (x == 'alphabetises') return true;
    if (x == 'alphabetizers') return true;
    if (x == 'alphabetizes') return true;
    if (x == 'alphabets') return true;
    if (x == 'alphanumerics') return true;
    if (x == 'alphas') return true;
    if (x == 'alphorns') return true;
    if (x == 'alphosis') return true;
    if (x == 'alphosises') return true;
    if (x == 'alphyls') return true;
    if (x == 'alpines') return true;
    if (x == 'alpinisms') return true;
    if (x == 'alpinists') return true;
    if (x == 'alps') return true;
    if (x == 'alsikes') return true;
    if (x == 'altars') return true;
    if (x == 'alterants') return true;
    if (x == 'alterations') return true;
    if (x == 'altercations') return true;
    if (x == 'alterers') return true;
    if (x == 'alternates') return true;
    if (x == 'alternations') return true;
    if (x == 'alternatives') return true;
    if (x == 'alternators') return true;
    if (x == 'alters') return true;
    if (x == 'althaeas') return true;
    if (x == 'altheas') return true;
    if (x == 'althorns') return true;
    if (x == 'altimeters') return true;
    if (x == 'altitudes') return true;
    if (x == 'altos') return true;
    if (x == 'altruisms') return true;
    if (x == 'altruists') return true;
    if (x == 'alts') return true;
    if (x == 'aludels') return true;
    if (x == 'aluminas') return true;
    if (x == 'alumines') return true;
    if (x == 'aluminiums') return true;
    if (x == 'alumins') return true;
    if (x == 'aluminums') return true;
    if (x == 'alumnus') return true;
    if (x == 'alumroots') return true;
    if (x == 'alums') return true;
    if (x == 'alunites') return true;
    if (x == 'alveolars') return true;
    if (x == 'alveolus') return true;
    if (x == 'always') return true;
    if (x == 'alyssums') return true;
    if (x == 'amadavats') return true;
    if (x == 'amadous') return true;
    if (x == 'amahs') return true;
    if (x == 'amalgamates') return true;
    if (x == 'amalgamations') return true;
    if (x == 'amalgams') return true;
    if (x == 'amanitas') return true;
    if (x == 'amanuensis') return true;
    if (x == 'amaranths') return true;
    if (x == 'amarelles') return true;
    if (x == 'amaryllis') return true;
    if (x == 'amaryllises') return true;
    if (x == 'amas') return true;
    if (x == 'amass') return true;
    if (x == 'amassers') return true;
    if (x == 'amasses') return true;
    if (x == 'amateurisms') return true;
    if (x == 'amateurs') return true;
    if (x == 'amatols') return true;
    if (x == 'amazements') return true;
    if (x == 'amazes') return true;
    if (x == 'amazons') return true;
    if (x == 'ambages') return true;
    if (x == 'ambaries') return true;
    if (x == 'ambaris') return true;
    if (x == 'ambassadors') return true;
    if (x == 'ambassadorships') return true;
    if (x == 'ambeers') return true;
    if (x == 'ambergris') return true;
    if (x == 'ambergrises') return true;
    if (x == 'amberies') return true;
    if (x == 'amberoids') return true;
    if (x == 'ambers') return true;
    if (x == 'ambiances') return true;
    if (x == 'ambidextrous') return true;
    if (x == 'ambiences') return true;
    if (x == 'ambients') return true;
    if (x == 'ambiguities') return true;
    if (x == 'ambiguous') return true;
    if (x == 'ambitions') return true;
    if (x == 'ambitious') return true;
    if (x == 'ambits') return true;
    if (x == 'ambivalences') return true;
    if (x == 'ambiverts') return true;
    if (x == 'amblers') return true;
    if (x == 'ambles') return true;
    if (x == 'amboinas') return true;
    if (x == 'ambones') return true;
    if (x == 'ambos') return true;
    if (x == 'amboynas') return true;
    if (x == 'ambries') return true;
    if (x == 'ambroids') return true;
    if (x == 'ambrosias') return true;
    if (x == 'ambsaces') return true;
    if (x == 'ambulances') return true;
    if (x == 'ambulates') return true;
    if (x == 'ambushers') return true;
    if (x == 'ambushes') return true;
    if (x == 'amebas') return true;
    if (x == 'ameerates') return true;
    if (x == 'ameers') return true;
    if (x == 'amelcorns') return true;
    if (x == 'ameliorates') return true;
    if (x == 'ameliorations') return true;
    if (x == 'ameliotasis') return true;
    if (x == 'amenders') return true;
    if (x == 'amendments') return true;
    if (x == 'amends') return true;
    if (x == 'amenities') return true;
    if (x == 'amens') return true;
    if (x == 'amentias') return true;
    if (x == 'aments') return true;
    if (x == 'amercers') return true;
    if (x == 'amerces') return true;
    if (x == 'amesaces') return true;
    if (x == 'amethysts') return true;
    if (x == 'amiabilities') return true;
    if (x == 'amiantus') return true;
    if (x == 'amiantuses') return true;
    if (x == 'amias') return true;
    if (x == 'amices') return true;
    if (x == 'amidases') return true;
    if (x == 'amides') return true;
    if (x == 'amidins') return true;
    if (x == 'amidogens') return true;
    if (x == 'amidols') return true;
    if (x == 'amids') return true;
    if (x == 'amies') return true;
    if (x == 'amigas') return true;
    if (x == 'amigos') return true;
    if (x == 'amines') return true;
    if (x == 'aminities') return true;
    if (x == 'amins') return true;
    if (x == 'amirates') return true;
    if (x == 'amirs') return true;
    if (x == 'amis') return true;
    if (x == 'amiss') return true;
    if (x == 'amities') return true;
    if (x == 'amitoses') return true;
    if (x == 'amitosis') return true;
    if (x == 'amitroles') return true;
    if (x == 'ammeters') return true;
    if (x == 'ammines') return true;
    if (x == 'ammocetes') return true;
    if (x == 'ammonals') return true;
    if (x == 'ammoniacs') return true;
    if (x == 'ammonias') return true;
    if (x == 'ammonifies') return true;
    if (x == 'ammonites') return true;
    if (x == 'ammoniums') return true;
    if (x == 'ammonoids') return true;
    if (x == 'ammos') return true;
    if (x == 'ammunitions') return true;
    if (x == 'amnesiacs') return true;
    if (x == 'amnesias') return true;
    if (x == 'amnesics') return true;
    if (x == 'amnesties') return true;
    if (x == 'amnions') return true;
    if (x == 'amniotes') return true;
    if (x == 'amoebas') return true;
    if (x == 'amoks') return true;
    if (x == 'amoles') return true;
    if (x == 'amorettos') return true;
    if (x == 'amorists') return true;
    if (x == 'amorous') return true;
    if (x == 'amorousness') return true;
    if (x == 'amorousnesses') return true;
    if (x == 'amorphous') return true;
    if (x == 'amortises') return true;
    if (x == 'amortizations') return true;
    if (x == 'amortizes') return true;
    if (x == 'amotions') return true;
    if (x == 'amounts') return true;
    if (x == 'amours') return true;
    if (x == 'amperages') return true;
    if (x == 'amperes') return true;
    if (x == 'ampersands') return true;
    if (x == 'amphibians') return true;
    if (x == 'amphibious') return true;
    if (x == 'amphipods') return true;
    if (x == 'amphitheaters') return true;
    if (x == 'amphoras') return true;
    if (x == 'amplifications') return true;
    if (x == 'amplifiers') return true;
    if (x == 'amplifies') return true;
    if (x == 'amplitudes') return true;
    if (x == 'ampoules') return true;
    if (x == 'amps') return true;
    if (x == 'ampules') return true;
    if (x == 'ampuls') return true;
    if (x == 'amputates') return true;
    if (x == 'amputations') return true;
    if (x == 'amputees') return true;
    if (x == 'amreetas') return true;
    if (x == 'amritas') return true;
    if (x == 'amtracks') return true;
    if (x == 'amtracs') return true;
    if (x == 'amucks') return true;
    if (x == 'amulets') return true;
    if (x == 'amus') return true;
    if (x == 'amusements') return true;
    if (x == 'amusers') return true;
    if (x == 'amuses') return true;
    if (x == 'amygdales') return true;
    if (x == 'amygdules') return true;
    if (x == 'amylases') return true;
    if (x == 'amylenes') return true;
    if (x == 'amyloids') return true;
    if (x == 'amyloses') return true;
    if (x == 'amyls') return true;
    if (x == 'amylums') return true;
    return nil;
  }
  isGoodWordAN(x) {
    if (x == 'anabaenas') return true;
    if (x == 'anabas') return true;
    if (x == 'anabases') return true;
    if (x == 'anabasis') return true;
    if (x == 'anableps') return true;
    if (x == 'anablepses') return true;
    if (x == 'anachronisms') return true;
    if (x == 'anacondas') return true;
    if (x == 'anadems') return true;
    if (x == 'anaemias') return true;
    if (x == 'anaerobes') return true;
    if (x == 'anaesthesias') return true;
    if (x == 'anaesthetics') return true;
    if (x == 'anaesthetises') return true;
    if (x == 'anaesthetists') return true;
    if (x == 'anaglyphs') return true;
    if (x == 'anagoges') return true;
    if (x == 'anagogies') return true;
    if (x == 'anagrams') return true;
    if (x == 'analcimes') return true;
    if (x == 'analcites') return true;
    if (x == 'analects') return true;
    if (x == 'analemmas') return true;
    if (x == 'analgesics') return true;
    if (x == 'analgias') return true;
    if (x == 'analities') return true;
    if (x == 'analogies') return true;
    if (x == 'analogs') return true;
    if (x == 'analogues') return true;
    if (x == 'analysers') return true;
    if (x == 'analyses') return true;
    if (x == 'analysis') return true;
    if (x == 'analysts') return true;
    if (x == 'analyzers') return true;
    if (x == 'analyzes') return true;
    if (x == 'anankes') return true;
    if (x == 'anapaests') return true;
    if (x == 'anapests') return true;
    if (x == 'anaphases') return true;
    if (x == 'anaphoras') return true;
    if (x == 'anarchies') return true;
    if (x == 'anarchisms') return true;
    if (x == 'anarchists') return true;
    if (x == 'anarchs') return true;
    if (x == 'anas') return true;
    if (x == 'anasarcas') return true;
    if (x == 'anatases') return true;
    if (x == 'anathemas') return true;
    if (x == 'anatomies') return true;
    if (x == 'anatomists') return true;
    if (x == 'anatoxins') return true;
    if (x == 'anattos') return true;
    if (x == 'ancestors') return true;
    if (x == 'ancestress') return true;
    if (x == 'ancestresses') return true;
    if (x == 'ancestries') return true;
    if (x == 'anchorages') return true;
    if (x == 'anchorets') return true;
    if (x == 'anchors') return true;
    if (x == 'anchovies') return true;
    if (x == 'anchusas') return true;
    if (x == 'anchusins') return true;
    if (x == 'ancients') return true;
    if (x == 'ancillas') return true;
    if (x == 'ancones') return true;
    if (x == 'ancress') return true;
    if (x == 'ancresses') return true;
    if (x == 'andantes') return true;
    if (x == 'andesites') return true;
    if (x == 'andesytes') return true;
    if (x == 'andirons') return true;
    if (x == 'androgens') return true;
    if (x == 'androgynous') return true;
    if (x == 'androids') return true;
    if (x == 'ands') return true;
    if (x == 'anears') return true;
    if (x == 'anecdotes') return true;
    if (x == 'aneles') return true;
    if (x == 'anemias') return true;
    if (x == 'anemones') return true;
    if (x == 'anergias') return true;
    if (x == 'anergies') return true;
    if (x == 'aneroids') return true;
    if (x == 'anes') return true;
    if (x == 'anesthesias') return true;
    if (x == 'anesthetics') return true;
    if (x == 'anesthetists') return true;
    if (x == 'anesthetizes') return true;
    if (x == 'anestrus') return true;
    if (x == 'anetholes') return true;
    if (x == 'anethols') return true;
    if (x == 'aneurisms') return true;
    if (x == 'aneurysms') return true;
    if (x == 'angarias') return true;
    if (x == 'angaries') return true;
    if (x == 'angas') return true;
    if (x == 'angelicas') return true;
    if (x == 'angels') return true;
    if (x == 'angelus') return true;
    if (x == 'angeluses') return true;
    if (x == 'angers') return true;
    if (x == 'anginas') return true;
    if (x == 'anginous') return true;
    if (x == 'angiomas') return true;
    if (x == 'anglepods') return true;
    if (x == 'anglers') return true;
    if (x == 'angles') return true;
    if (x == 'angleworms') return true;
    if (x == 'anglings') return true;
    if (x == 'angoras') return true;
    if (x == 'angstroms') return true;
    if (x == 'angsts') return true;
    if (x == 'anguishes') return true;
    if (x == 'angularities') return true;
    if (x == 'angulates') return true;
    if (x == 'angulous') return true;
    if (x == 'anhingas') return true;
    if (x == 'anilines') return true;
    if (x == 'anilins') return true;
    if (x == 'anilities') return true;
    if (x == 'anils') return true;
    if (x == 'animals') return true;
    if (x == 'animas') return true;
    if (x == 'animaters') return true;
    if (x == 'animates') return true;
    if (x == 'animations') return true;
    if (x == 'animators') return true;
    if (x == 'animes') return true;
    if (x == 'animis') return true;
    if (x == 'animisms') return true;
    if (x == 'animists') return true;
    if (x == 'animosities') return true;
    if (x == 'animus') return true;
    if (x == 'animuses') return true;
    if (x == 'anions') return true;
    if (x == 'anis') return true;
    if (x == 'aniseeds') return true;
    if (x == 'anises') return true;
    if (x == 'anisettes') return true;
    if (x == 'anisoles') return true;
    if (x == 'ankerites') return true;
    if (x == 'ankhs') return true;
    if (x == 'anklebones') return true;
    if (x == 'ankles') return true;
    if (x == 'anklets') return true;
    if (x == 'ankus') return true;
    if (x == 'ankuses') return true;
    if (x == 'ankushes') return true;
    if (x == 'ankyloses') return true;
    if (x == 'anlaces') return true;
    if (x == 'anlages') return true;
    if (x == 'anlas') return true;
    if (x == 'anlases') return true;
    if (x == 'annalists') return true;
    if (x == 'annals') return true;
    if (x == 'annas') return true;
    if (x == 'annates') return true;
    if (x == 'annattos') return true;
    if (x == 'annealers') return true;
    if (x == 'anneals') return true;
    if (x == 'annelids') return true;
    if (x == 'annexations') return true;
    if (x == 'annexes') return true;
    if (x == 'annihilates') return true;
    if (x == 'annihilations') return true;
    if (x == 'anniversaries') return true;
    if (x == 'annotates') return true;
    if (x == 'annotations') return true;
    if (x == 'annotators') return true;
    if (x == 'announcements') return true;
    if (x == 'announcers') return true;
    if (x == 'announces') return true;
    if (x == 'annoyances') return true;
    if (x == 'annoyers') return true;
    if (x == 'annoys') return true;
    if (x == 'annuals') return true;
    if (x == 'annuities') return true;
    if (x == 'annulets') return true;
    if (x == 'annulments') return true;
    if (x == 'annuls') return true;
    if (x == 'annulus') return true;
    if (x == 'annuluses') return true;
    if (x == 'anoas') return true;
    if (x == 'anodes') return true;
    if (x == 'anodises') return true;
    if (x == 'anodizes') return true;
    if (x == 'anodynes') return true;
    if (x == 'anointers') return true;
    if (x == 'anointments') return true;
    if (x == 'anoints') return true;
    if (x == 'anoles') return true;
    if (x == 'anolytes') return true;
    if (x == 'anomalies') return true;
    if (x == 'anomalous') return true;
    if (x == 'anomies') return true;
    if (x == 'anonymities') return true;
    if (x == 'anonymous') return true;
    if (x == 'anonyms') return true;
    if (x == 'anoopsias') return true;
    if (x == 'anopias') return true;
    if (x == 'anopsias') return true;
    if (x == 'anoraks') return true;
    if (x == 'anorexias') return true;
    if (x == 'anorexies') return true;
    if (x == 'anosmias') return true;
    if (x == 'anoxemias') return true;
    if (x == 'anoxias') return true;
    if (x == 'anserines') return true;
    if (x == 'anserous') return true;
    if (x == 'answerers') return true;
    if (x == 'answers') return true;
    if (x == 'antacids') return true;
    if (x == 'antagonises') return true;
    if (x == 'antagonisms') return true;
    if (x == 'antagonists') return true;
    if (x == 'antagonizes') return true;
    if (x == 'antalgics') return true;
    if (x == 'antas') return true;
    if (x == 'anteaters') return true;
    if (x == 'antecedents') return true;
    if (x == 'antecedes') return true;
    if (x == 'antedates') return true;
    if (x == 'antefixes') return true;
    if (x == 'antelopes') return true;
    if (x == 'antennas') return true;
    if (x == 'antepasts') return true;
    if (x == 'anterooms') return true;
    if (x == 'antes') return true;
    if (x == 'antetypes') return true;
    if (x == 'anteverts') return true;
    if (x == 'anthelices') return true;
    if (x == 'anthems') return true;
    if (x == 'antherids') return true;
    if (x == 'anthers') return true;
    if (x == 'antheses') return true;
    if (x == 'anthesis') return true;
    if (x == 'anthills') return true;
    if (x == 'anthologies') return true;
    if (x == 'anthraces') return true;
    if (x == 'anthracites') return true;
    if (x == 'anthropologists') return true;
    if (x == 'anthropomorphisations') return true;
    if (x == 'anthropomorphises') return true;
    if (x == 'anthropomorphisms') return true;
    if (x == 'anthropomorphists') return true;
    if (x == 'anthropomorphizations') return true;
    if (x == 'anthropomorphizes') return true;
    if (x == 'anthropomorphs') return true;
    if (x == 'anthropopathisms') return true;
    if (x == 'antiarins') return true;
    if (x == 'antiars') return true;
    if (x == 'antibiotics') return true;
    if (x == 'antibodies') return true;
    if (x == 'antibourgeois') return true;
    if (x == 'antibusiness') return true;
    if (x == 'anticipates') return true;
    if (x == 'anticipations') return true;
    if (x == 'anticks') return true;
    if (x == 'anticlimaxes') return true;
    if (x == 'antics') return true;
    if (x == 'antidotes') return true;
    if (x == 'antiemetics') return true;
    if (x == 'antifreezes') return true;
    if (x == 'antifungus') return true;
    if (x == 'antigenes') return true;
    if (x == 'antigens') return true;
    if (x == 'antiheroes') return true;
    if (x == 'antihistamines') return true;
    if (x == 'antikings') return true;
    if (x == 'antilogies') return true;
    if (x == 'antilogs') return true;
    if (x == 'antimasks') return true;
    if (x == 'antimeres') return true;
    if (x == 'antimonies') return true;
    if (x == 'antings') return true;
    if (x == 'antinodes') return true;
    if (x == 'antinomies') return true;
    if (x == 'antipathies') return true;
    if (x == 'antiperistalsis') return true;
    if (x == 'antiphons') return true;
    if (x == 'antipodeans') return true;
    if (x == 'antipodes') return true;
    if (x == 'antipoles') return true;
    if (x == 'antipopes') return true;
    if (x == 'antipyics') return true;
    if (x == 'antiquarians') return true;
    if (x == 'antiquaries') return true;
    if (x == 'antiquers') return true;
    if (x == 'antiques') return true;
    if (x == 'antiquities') return true;
    if (x == 'antirabies') return true;
    if (x == 'antireligious') return true;
    if (x == 'antirusts') return true;
    if (x == 'antis') return true;
    if (x == 'antiseptics') return true;
    if (x == 'antisyphillis') return true;
    if (x == 'antitheses') return true;
    if (x == 'antithesis') return true;
    if (x == 'antituberculosis') return true;
    if (x == 'antitypes') return true;
    if (x == 'antlers') return true;
    if (x == 'antlions') return true;
    if (x == 'antonymies') return true;
    if (x == 'antonyms') return true;
    if (x == 'antres') return true;
    if (x == 'ants') return true;
    if (x == 'anurans') return true;
    if (x == 'anureses') return true;
    if (x == 'anuresis') return true;
    if (x == 'anurias') return true;
    if (x == 'anurous') return true;
    if (x == 'anus') return true;
    if (x == 'anuses') return true;
    if (x == 'anvils') return true;
    if (x == 'anviltops') return true;
    if (x == 'anxieties') return true;
    if (x == 'anxious') return true;
    if (x == 'anybodies') return true;
    if (x == 'anythings') return true;
    if (x == 'anyways') return true;
    if (x == 'anywheres') return true;
    if (x == 'aorists') return true;
    if (x == 'aortas') return true;
    if (x == 'aoudads') return true;
    if (x == 'apaches') return true;
    if (x == 'apagoges') return true;
    if (x == 'apanages') return true;
    if (x == 'aparejos') return true;
    if (x == 'apartheids') return true;
    if (x == 'apathies') return true;
    if (x == 'apatites') return true;
    if (x == 'apercus') return true;
    if (x == 'aperients') return true;
    if (x == 'aperies') return true;
    if (x == 'aperitifs') return true;
    if (x == 'apers') return true;
    if (x == 'apertures') return true;
    if (x == 'apes') return true;
    if (x == 'apetalies') return true;
    if (x == 'apexes') return true;
    if (x == 'aphagias') return true;
    if (x == 'aphanites') return true;
    if (x == 'aphasiacs') return true;
    if (x == 'aphasias') return true;
    if (x == 'aphasics') return true;
    if (x == 'apheses') return true;
    if (x == 'aphesis') return true;
    if (x == 'aphides') return true;
    if (x == 'aphidians') return true;
    if (x == 'aphids') return true;
    if (x == 'aphis') return true;
    if (x == 'apholates') return true;
    if (x == 'aphonias') return true;
    if (x == 'aphonics') return true;
    if (x == 'aphorises') return true;
    if (x == 'aphorisms') return true;
    if (x == 'aphorists') return true;
    if (x == 'aphorizes') return true;
    if (x == 'aphthous') return true;
    if (x == 'aphyllies') return true;
    if (x == 'apiarians') return true;
    if (x == 'apiaries') return true;
    if (x == 'apiarists') return true;
    if (x == 'apices') return true;
    if (x == 'apiculus') return true;
    if (x == 'apimanias') return true;
    if (x == 'apiologies') return true;
    if (x == 'aplasias') return true;
    if (x == 'aplites') return true;
    if (x == 'aplombs') return true;
    if (x == 'apneas') return true;
    if (x == 'apnoeas') return true;
    if (x == 'apocalypses') return true;
    if (x == 'apocarpies') return true;
    if (x == 'apocarps') return true;
    if (x == 'apocopes') return true;
    if (x == 'apodoses') return true;
    if (x == 'apodosis') return true;
    if (x == 'apodous') return true;
    if (x == 'apogamies') return true;
    if (x == 'apogees') return true;
    if (x == 'apollos') return true;
    if (x == 'apologias') return true;
    if (x == 'apologies') return true;
    if (x == 'apologises') return true;
    if (x == 'apologizes') return true;
    if (x == 'apologs') return true;
    if (x == 'apologues') return true;
    if (x == 'apolunes') return true;
    if (x == 'apomicts') return true;
    if (x == 'apomixes') return true;
    if (x == 'apomixis') return true;
    if (x == 'apophyges') return true;
    if (x == 'apoplexies') return true;
    if (x == 'apostacies') return true;
    if (x == 'apostasies') return true;
    if (x == 'apostates') return true;
    if (x == 'apostils') return true;
    if (x == 'apostles') return true;
    if (x == 'apostrophes') return true;
    if (x == 'apothecaries') return true;
    if (x == 'apotheces') return true;
    if (x == 'apothegms') return true;
    if (x == 'apothems') return true;
    if (x == 'appalls') return true;
    if (x == 'appals') return true;
    if (x == 'appanages') return true;
    if (x == 'apparats') return true;
    if (x == 'apparatus') return true;
    if (x == 'apparatuses') return true;
    if (x == 'apparels') return true;
    if (x == 'apparitions') return true;
    if (x == 'appealers') return true;
    if (x == 'appeals') return true;
    if (x == 'appearances') return true;
    if (x == 'appears') return true;
    if (x == 'appeasements') return true;
    if (x == 'appeasers') return true;
    if (x == 'appeases') return true;
    if (x == 'appellees') return true;
    if (x == 'appellors') return true;
    if (x == 'appels') return true;
    if (x == 'appendages') return true;
    if (x == 'appendectomies') return true;
    if (x == 'appendices') return true;
    if (x == 'appendicitis') return true;
    if (x == 'appendixes') return true;
    if (x == 'appends') return true;
    if (x == 'appestats') return true;
    if (x == 'appetites') return true;
    if (x == 'appetizers') return true;
    if (x == 'applauds') return true;
    if (x == 'applauses') return true;
    if (x == 'applejacks') return true;
    if (x == 'apples') return true;
    if (x == 'applicabilities') return true;
    if (x == 'applicancies') return true;
    if (x == 'applicants') return true;
    if (x == 'applications') return true;
    if (x == 'applicators') return true;
    if (x == 'appliers') return true;
    if (x == 'applies') return true;
    if (x == 'appliques') return true;
    if (x == 'appointments') return true;
    if (x == 'appoints') return true;
    if (x == 'apportionments') return true;
    if (x == 'apportions') return true;
    if (x == 'apposers') return true;
    if (x == 'apposes') return true;
    if (x == 'appraisals') return true;
    if (x == 'appraisers') return true;
    if (x == 'appraises') return true;
    if (x == 'appreciates') return true;
    if (x == 'appreciations') return true;
    if (x == 'apprehends') return true;
    if (x == 'apprehensions') return true;
    if (x == 'apprehensiveness') return true;
    if (x == 'apprehensivenesses') return true;
    if (x == 'apprentices') return true;
    if (x == 'apprenticeships') return true;
    if (x == 'apprisers') return true;
    if (x == 'apprises') return true;
    if (x == 'apprizers') return true;
    if (x == 'apprizes') return true;
    if (x == 'approaches') return true;
    if (x == 'appropriateness') return true;
    if (x == 'appropriates') return true;
    if (x == 'appropriations') return true;
    if (x == 'approvals') return true;
    if (x == 'approvers') return true;
    if (x == 'approves') return true;
    if (x == 'approximates') return true;
    if (x == 'approximations') return true;
    if (x == 'appulses') return true;
    if (x == 'appurtenances') return true;
    if (x == 'apraxias') return true;
    if (x == 'apricots') return true;
    if (x == 'aprons') return true;
    if (x == 'apropos') return true;
    if (x == 'apses') return true;
    if (x == 'apsides') return true;
    if (x == 'apsis') return true;
    if (x == 'apterous') return true;
    if (x == 'apteryxes') return true;
    if (x == 'aptitudes') return true;
    if (x == 'aptness') return true;
    if (x == 'aptnesses') return true;
    if (x == 'apyrases') return true;
    return nil;
  }
  isGoodWordAQ(x) {
    if (x == 'aquacades') return true;
    if (x == 'aquamarines') return true;
    if (x == 'aquanauts') return true;
    if (x == 'aquarians') return true;
    if (x == 'aquarists') return true;
    if (x == 'aquariums') return true;
    if (x == 'aquas') return true;
    if (x == 'aquatics') return true;
    if (x == 'aquatints') return true;
    if (x == 'aquatones') return true;
    if (x == 'aquavits') return true;
    if (x == 'aqueducts') return true;
    if (x == 'aqueous') return true;
    if (x == 'aquifers') return true;
    if (x == 'arabesks') return true;
    if (x == 'arabesques') return true;
    if (x == 'arabises') return true;
    if (x == 'arabizes') return true;
    if (x == 'arables') return true;
    if (x == 'araceous') return true;
    if (x == 'arachnids') return true;
    if (x == 'araks') return true;
    if (x == 'araneids') return true;
    if (x == 'arapaimas') return true;
    if (x == 'ararobas') return true;
    if (x == 'arbalests') return true;
    if (x == 'arbalists') return true;
    if (x == 'arbiters') return true;
    if (x == 'arbitrariness') return true;
    if (x == 'arbitrarinesses') return true;
    if (x == 'arbitrates') return true;
    if (x == 'arbitrations') return true;
    if (x == 'arbitrators') return true;
    if (x == 'arbores') return true;
    if (x == 'arborists') return true;
    if (x == 'arborizes') return true;
    if (x == 'arborous') return true;
    if (x == 'arbors') return true;
    if (x == 'arbours') return true;
    if (x == 'arbuscles') return true;
    if (x == 'arbutes') return true;
    if (x == 'arbutus') return true;
    if (x == 'arbutuses') return true;
    if (x == 'arcades') return true;
    if (x == 'arcadians') return true;
    if (x == 'arcadias') return true;
    if (x == 'arcadings') return true;
    if (x == 'arcatures') return true;
    if (x == 'archaeologies') return true;
    if (x == 'archaeologists') return true;
    if (x == 'archaises') return true;
    if (x == 'archaisms') return true;
    if (x == 'archaists') return true;
    if (x == 'archaizes') return true;
    if (x == 'archangels') return true;
    if (x == 'archbishoprics') return true;
    if (x == 'archbishops') return true;
    if (x == 'archdioceses') return true;
    if (x == 'archdukes') return true;
    if (x == 'archeologies') return true;
    if (x == 'archeries') return true;
    if (x == 'archers') return true;
    if (x == 'arches') return true;
    if (x == 'archetypes') return true;
    if (x == 'archils') return true;
    if (x == 'archines') return true;
    if (x == 'archings') return true;
    if (x == 'archipelagos') return true;
    if (x == 'architects') return true;
    if (x == 'architectures') return true;
    if (x == 'archives') return true;
    if (x == 'archness') return true;
    if (x == 'archnesses') return true;
    if (x == 'archons') return true;
    if (x == 'archways') return true;
    if (x == 'arcs') return true;
    if (x == 'arctics') return true;
    if (x == 'arcus') return true;
    if (x == 'arcuses') return true;
    if (x == 'ardebs') return true;
    if (x == 'ardencies') return true;
    if (x == 'ardors') return true;
    if (x == 'ardours') return true;
    if (x == 'arduous') return true;
    if (x == 'arduousness') return true;
    if (x == 'arduousnesses') return true;
    if (x == 'areas') return true;
    if (x == 'areaways') return true;
    if (x == 'arecas') return true;
    if (x == 'arenas') return true;
    if (x == 'arenous') return true;
    if (x == 'areolas') return true;
    if (x == 'areoles') return true;
    if (x == 'areologies') return true;
    if (x == 'ares') return true;
    if (x == 'aretes') return true;
    if (x == 'arethusas') return true;
    if (x == 'argalis') return true;
    if (x == 'argals') return true;
    if (x == 'argents') return true;
    if (x == 'argentums') return true;
    if (x == 'argils') return true;
    if (x == 'arginases') return true;
    if (x == 'arginines') return true;
    if (x == 'argles') return true;
    if (x == 'argols') return true;
    if (x == 'argonauts') return true;
    if (x == 'argons') return true;
    if (x == 'argosies') return true;
    if (x == 'argots') return true;
    if (x == 'arguers') return true;
    if (x == 'argues') return true;
    if (x == 'argufiers') return true;
    if (x == 'argufies') return true;
    if (x == 'arguments') return true;
    if (x == 'argus') return true;
    if (x == 'arguses') return true;
    if (x == 'argyles') return true;
    if (x == 'argylls') return true;
    if (x == 'arhats') return true;
    if (x == 'arias') return true;
    if (x == 'aridities') return true;
    if (x == 'aridness') return true;
    if (x == 'aridnesses') return true;
    if (x == 'ariels') return true;
    if (x == 'ariettas') return true;
    if (x == 'ariettes') return true;
    if (x == 'arillodes') return true;
    if (x == 'arils') return true;
    if (x == 'ariosos') return true;
    if (x == 'arises') return true;
    if (x == 'aristas') return true;
    if (x == 'aristocracies') return true;
    if (x == 'aristocrats') return true;
    if (x == 'arks') return true;
    if (x == 'arles') return true;
    if (x == 'armadas') return true;
    if (x == 'armadillos') return true;
    if (x == 'armaments') return true;
    if (x == 'armatures') return true;
    if (x == 'armbands') return true;
    if (x == 'armchairs') return true;
    if (x == 'armers') return true;
    if (x == 'armets') return true;
    if (x == 'armfuls') return true;
    if (x == 'armholes') return true;
    if (x == 'armies') return true;
    if (x == 'armigeros') return true;
    if (x == 'armigers') return true;
    if (x == 'armillas') return true;
    if (x == 'armings') return true;
    if (x == 'armless') return true;
    if (x == 'armlets') return true;
    if (x == 'armloads') return true;
    if (x == 'armoires') return true;
    if (x == 'armonicas') return true;
    if (x == 'armorers') return true;
    if (x == 'armorials') return true;
    if (x == 'armories') return true;
    if (x == 'armors') return true;
    if (x == 'armourers') return true;
    if (x == 'armouries') return true;
    if (x == 'armours') return true;
    if (x == 'armpits') return true;
    if (x == 'armrests') return true;
    if (x == 'arms') return true;
    if (x == 'armures') return true;
    if (x == 'armyworms') return true;
    if (x == 'arnattos') return true;
    if (x == 'arnicas') return true;
    if (x == 'arnottos') return true;
    if (x == 'aroids') return true;
    if (x == 'aroints') return true;
    if (x == 'aromas') return true;
    if (x == 'aromatics') return true;
    if (x == 'arousals') return true;
    if (x == 'arousers') return true;
    if (x == 'arouses') return true;
    if (x == 'aroynts') return true;
    if (x == 'arpeggios') return true;
    if (x == 'arpens') return true;
    if (x == 'arpents') return true;
    if (x == 'arquebus') return true;
    if (x == 'arquebuses') return true;
    if (x == 'arracks') return true;
    if (x == 'arraigns') return true;
    if (x == 'arrangements') return true;
    if (x == 'arrangers') return true;
    if (x == 'arranges') return true;
    if (x == 'arras') return true;
    if (x == 'arrayals') return true;
    if (x == 'arrayers') return true;
    if (x == 'arrays') return true;
    if (x == 'arrears') return true;
    if (x == 'arrestees') return true;
    if (x == 'arresters') return true;
    if (x == 'arrestors') return true;
    if (x == 'arrests') return true;
    if (x == 'arris') return true;
    if (x == 'arrises') return true;
    if (x == 'arrivals') return true;
    if (x == 'arrivers') return true;
    if (x == 'arrives') return true;
    if (x == 'arrobas') return true;
    if (x == 'arrogances') return true;
    if (x == 'arrogates') return true;
    if (x == 'arrowheads') return true;
    if (x == 'arrows') return true;
    if (x == 'arroyos') return true;
    if (x == 'ars') return true;
    if (x == 'arsenals') return true;
    if (x == 'arsenates') return true;
    if (x == 'arsenics') return true;
    if (x == 'arsenides') return true;
    if (x == 'arsenious') return true;
    if (x == 'arsenites') return true;
    if (x == 'arsenous') return true;
    if (x == 'arses') return true;
    if (x == 'arshins') return true;
    if (x == 'arsines') return true;
    if (x == 'arsis') return true;
    if (x == 'arsonists') return true;
    if (x == 'arsonous') return true;
    if (x == 'arsons') return true;
    if (x == 'artefacts') return true;
    if (x == 'artels') return true;
    if (x == 'arterials') return true;
    if (x == 'arteries') return true;
    if (x == 'arteriosclerosis') return true;
    if (x == 'artfulness') return true;
    if (x == 'artfulnesses') return true;
    if (x == 'arthritides') return true;
    if (x == 'arthritis') return true;
    if (x == 'arthropods') return true;
    if (x == 'artichokes') return true;
    if (x == 'articles') return true;
    if (x == 'articulateness') return true;
    if (x == 'articulatenesses') return true;
    if (x == 'articulates') return true;
    if (x == 'artifacts') return true;
    if (x == 'artifices') return true;
    if (x == 'artificialities') return true;
    if (x == 'artificialness') return true;
    if (x == 'artificialnesses') return true;
    if (x == 'artilleries') return true;
    if (x == 'artiness') return true;
    if (x == 'artinesses') return true;
    if (x == 'artisans') return true;
    if (x == 'artistes') return true;
    if (x == 'artistries') return true;
    if (x == 'artists') return true;
    if (x == 'artless') return true;
    if (x == 'artlessness') return true;
    if (x == 'artlessnesses') return true;
    if (x == 'arts') return true;
    if (x == 'artworks') return true;
    if (x == 'arums') return true;
    if (x == 'aruspices') return true;
    if (x == 'arvos') return true;
    if (x == 'aryls') return true;
    if (x == 'arythmias') return true;
    if (x == 'as') return true;
    if (x == 'asarums') return true;
    if (x == 'asbestos') return true;
    if (x == 'asbestoses') return true;
    if (x == 'asbestus') return true;
    if (x == 'asbestuses') return true;
    if (x == 'ascarides') return true;
    if (x == 'ascarids') return true;
    if (x == 'ascaris') return true;
    if (x == 'ascendancies') return true;
    if (x == 'ascenders') return true;
    if (x == 'ascends') return true;
    if (x == 'ascensions') return true;
    if (x == 'ascents') return true;
    if (x == 'ascertains') return true;
    if (x == 'asceses') return true;
    if (x == 'ascesis') return true;
    if (x == 'asceticisms') return true;
    if (x == 'ascetics') return true;
    if (x == 'ascidians') return true;
    if (x == 'ascites') return true;
    if (x == 'ascocarps') return true;
    if (x == 'ascots') return true;
    if (x == 'ascribes') return true;
    if (x == 'ascriptions') return true;
    if (x == 'ascus') return true;
    if (x == 'asdics') return true;
    if (x == 'asepses') return true;
    if (x == 'asepsis') return true;
    if (x == 'ashcans') return true;
    if (x == 'ashes') return true;
    if (x == 'ashlars') return true;
    if (x == 'ashlers') return true;
    if (x == 'ashless') return true;
    if (x == 'ashplants') return true;
    if (x == 'ashrams') return true;
    if (x == 'ashtrays') return true;
    if (x == 'asides') return true;
    if (x == 'askers') return true;
    if (x == 'askeses') return true;
    if (x == 'askesis') return true;
    if (x == 'askings') return true;
    if (x == 'asks') return true;
    if (x == 'aspects') return true;
    if (x == 'aspens') return true;
    if (x == 'asperates') return true;
    if (x == 'asperges') return true;
    if (x == 'asperities') return true;
    if (x == 'aspers') return true;
    if (x == 'aspersers') return true;
    if (x == 'asperses') return true;
    if (x == 'aspersions') return true;
    if (x == 'aspersors') return true;
    if (x == 'asphalts') return true;
    if (x == 'asphaltums') return true;
    if (x == 'asphodels') return true;
    if (x == 'asphyxias') return true;
    if (x == 'asphyxiates') return true;
    if (x == 'asphyxiations') return true;
    if (x == 'asphyxies') return true;
    if (x == 'aspics') return true;
    if (x == 'aspirants') return true;
    if (x == 'aspirates') return true;
    if (x == 'aspirations') return true;
    if (x == 'aspirers') return true;
    if (x == 'aspires') return true;
    if (x == 'aspirins') return true;
    if (x == 'aspis') return true;
    if (x == 'aspises') return true;
    if (x == 'asps') return true;
    if (x == 'asramas') return true;
    if (x == 'ass') return true;
    if (x == 'assagais') return true;
    if (x == 'assailants') return true;
    if (x == 'assailers') return true;
    if (x == 'assails') return true;
    if (x == 'assais') return true;
    if (x == 'assassinates') return true;
    if (x == 'assassinations') return true;
    if (x == 'assassins') return true;
    if (x == 'assaults') return true;
    if (x == 'assayers') return true;
    if (x == 'assays') return true;
    if (x == 'assegais') return true;
    if (x == 'assembles') return true;
    if (x == 'assemblies') return true;
    if (x == 'assenters') return true;
    if (x == 'assentors') return true;
    if (x == 'assents') return true;
    if (x == 'asserters') return true;
    if (x == 'assertions') return true;
    if (x == 'assertiveness') return true;
    if (x == 'assertivenesses') return true;
    if (x == 'assertors') return true;
    if (x == 'asserts') return true;
    if (x == 'asses') return true;
    if (x == 'assess') return true;
    if (x == 'assesses') return true;
    if (x == 'assessments') return true;
    if (x == 'assessors') return true;
    if (x == 'assets') return true;
    if (x == 'assiduities') return true;
    if (x == 'assiduous') return true;
    if (x == 'assiduousness') return true;
    if (x == 'assiduousnesses') return true;
    if (x == 'assignats') return true;
    if (x == 'assignees') return true;
    if (x == 'assigners') return true;
    if (x == 'assignments') return true;
    if (x == 'assignors') return true;
    if (x == 'assigns') return true;
    if (x == 'assimilates') return true;
    if (x == 'assimilations') return true;
    if (x == 'assistances') return true;
    if (x == 'assistants') return true;
    if (x == 'assisters') return true;
    if (x == 'assistors') return true;
    if (x == 'assists') return true;
    if (x == 'assizes') return true;
    if (x == 'associates') return true;
    if (x == 'associations') return true;
    if (x == 'assoils') return true;
    if (x == 'assonants') return true;
    if (x == 'assorters') return true;
    if (x == 'assortments') return true;
    if (x == 'assorts') return true;
    if (x == 'assuages') return true;
    if (x == 'assumers') return true;
    if (x == 'assumes') return true;
    if (x == 'assumptions') return true;
    if (x == 'assurances') return true;
    if (x == 'assureds') return true;
    if (x == 'assurers') return true;
    if (x == 'assures') return true;
    if (x == 'assurors') return true;
    if (x == 'asswages') return true;
    if (x == 'astasias') return true;
    if (x == 'astatines') return true;
    if (x == 'asterias') return true;
    if (x == 'asterisks') return true;
    if (x == 'asterisms') return true;
    if (x == 'asteroids') return true;
    if (x == 'asters') return true;
    if (x == 'asthenias') return true;
    if (x == 'asthenics') return true;
    if (x == 'asthenies') return true;
    if (x == 'asthmas') return true;
    if (x == 'astigmatisms') return true;
    if (x == 'astomous') return true;
    if (x == 'astonies') return true;
    if (x == 'astonishes') return true;
    if (x == 'astonishments') return true;
    if (x == 'astounds') return true;
    if (x == 'astragals') return true;
    if (x == 'astrals') return true;
    if (x == 'astricts') return true;
    if (x == 'astringencies') return true;
    if (x == 'astringents') return true;
    if (x == 'astringes') return true;
    if (x == 'astrolabes') return true;
    if (x == 'astrologers') return true;
    if (x == 'astrologies') return true;
    if (x == 'astronautics') return true;
    if (x == 'astronauts') return true;
    if (x == 'astronomers') return true;
    if (x == 'astuteness') return true;
    if (x == 'asylums') return true;
    if (x == 'asymmetries') return true;
    if (x == 'asymptotes') return true;
    return nil;
  }
  isGoodWordAT(x) {
    if (x == 'atabals') return true;
    if (x == 'ataghans') return true;
    if (x == 'atalayas') return true;
    if (x == 'atamans') return true;
    if (x == 'atamascos') return true;
    if (x == 'ataraxias') return true;
    if (x == 'ataraxics') return true;
    if (x == 'ataraxies') return true;
    if (x == 'atavisms') return true;
    if (x == 'atavists') return true;
    if (x == 'ataxias') return true;
    if (x == 'ataxics') return true;
    if (x == 'ataxies') return true;
    if (x == 'ateliers') return true;
    if (x == 'ates') return true;
    if (x == 'athanasies') return true;
    if (x == 'atheisms') return true;
    if (x == 'atheists') return true;
    if (x == 'athelings') return true;
    if (x == 'atheneums') return true;
    if (x == 'atheromas') return true;
    if (x == 'atherosclerosis') return true;
    if (x == 'athletes') return true;
    if (x == 'athletics') return true;
    if (x == 'athodyds') return true;
    if (x == 'atlantes') return true;
    if (x == 'atlas') return true;
    if (x == 'atlases') return true;
    if (x == 'atlatls') return true;
    if (x == 'atmans') return true;
    if (x == 'atmas') return true;
    if (x == 'atmospheres') return true;
    if (x == 'atolls') return true;
    if (x == 'atomics') return true;
    if (x == 'atomies') return true;
    if (x == 'atomises') return true;
    if (x == 'atomisms') return true;
    if (x == 'atomists') return true;
    if (x == 'atomizers') return true;
    if (x == 'atomizes') return true;
    if (x == 'atoms') return true;
    if (x == 'atonements') return true;
    if (x == 'atoners') return true;
    if (x == 'atones') return true;
    if (x == 'atonics') return true;
    if (x == 'atonies') return true;
    if (x == 'atopies') return true;
    if (x == 'atrazines') return true;
    if (x == 'atresias') return true;
    if (x == 'atriums') return true;
    if (x == 'atrocious') return true;
    if (x == 'atrociousness') return true;
    if (x == 'atrociousnesses') return true;
    if (x == 'atrocities') return true;
    if (x == 'atrophias') return true;
    if (x == 'atrophies') return true;
    if (x == 'atropines') return true;
    if (x == 'atropins') return true;
    if (x == 'atropisms') return true;
    if (x == 'attachers') return true;
    if (x == 'attaches') return true;
    if (x == 'attachments') return true;
    if (x == 'attackers') return true;
    if (x == 'attacks') return true;
    if (x == 'attainabilities') return true;
    if (x == 'attainers') return true;
    if (x == 'attainments') return true;
    if (x == 'attains') return true;
    if (x == 'attaints') return true;
    if (x == 'attars') return true;
    if (x == 'attempers') return true;
    if (x == 'attempts') return true;
    if (x == 'attendances') return true;
    if (x == 'attendants') return true;
    if (x == 'attendees') return true;
    if (x == 'attenders') return true;
    if (x == 'attendings') return true;
    if (x == 'attends') return true;
    if (x == 'attentions') return true;
    if (x == 'attentiveness') return true;
    if (x == 'attentivenesses') return true;
    if (x == 'attenuates') return true;
    if (x == 'attenuations') return true;
    if (x == 'attestations') return true;
    if (x == 'attesters') return true;
    if (x == 'attestors') return true;
    if (x == 'attests') return true;
    if (x == 'atticisms') return true;
    if (x == 'atticists') return true;
    if (x == 'attics') return true;
    if (x == 'attires') return true;
    if (x == 'attitudes') return true;
    if (x == 'attofarads') return true;
    if (x == 'attograms') return true;
    if (x == 'attometers') return true;
    if (x == 'attorneys') return true;
    if (x == 'attorns') return true;
    if (x == 'attoseconds') return true;
    if (x == 'attractions') return true;
    if (x == 'attractiveness') return true;
    if (x == 'attractivenesses') return true;
    if (x == 'attracts') return true;
    if (x == 'attributes') return true;
    if (x == 'attributions') return true;
    if (x == 'attunes') return true;
    if (x == 'aubades') return true;
    if (x == 'auberges') return true;
    if (x == 'auburns') return true;
    if (x == 'auctioneers') return true;
    if (x == 'auctions') return true;
    if (x == 'audacious') return true;
    if (x == 'audacities') return true;
    if (x == 'audads') return true;
    if (x == 'audibles') return true;
    if (x == 'audiences') return true;
    if (x == 'audients') return true;
    if (x == 'audiles') return true;
    if (x == 'audings') return true;
    if (x == 'audiograms') return true;
    if (x == 'audios') return true;
    if (x == 'auditions') return true;
    if (x == 'auditives') return true;
    if (x == 'auditories') return true;
    if (x == 'auditoriums') return true;
    if (x == 'auditors') return true;
    if (x == 'audits') return true;
    if (x == 'augends') return true;
    if (x == 'augers') return true;
    if (x == 'aughts') return true;
    if (x == 'augites') return true;
    if (x == 'augmentations') return true;
    if (x == 'augments') return true;
    if (x == 'augurers') return true;
    if (x == 'auguries') return true;
    if (x == 'augurs') return true;
    if (x == 'auklets') return true;
    if (x == 'auks') return true;
    if (x == 'aunthoods') return true;
    if (x == 'aunties') return true;
    if (x == 'aunts') return true;
    if (x == 'auras') return true;
    if (x == 'aureolas') return true;
    if (x == 'aureoles') return true;
    if (x == 'aures') return true;
    if (x == 'aureus') return true;
    if (x == 'auricles') return true;
    if (x == 'auriculas') return true;
    if (x == 'auris') return true;
    if (x == 'aurists') return true;
    if (x == 'aurochs') return true;
    if (x == 'aurochses') return true;
    if (x == 'auroras') return true;
    if (x == 'aurous') return true;
    if (x == 'aurums') return true;
    if (x == 'auscultations') return true;
    if (x == 'auspices') return true;
    if (x == 'auspicious') return true;
    if (x == 'austerities') return true;
    if (x == 'autacoids') return true;
    if (x == 'autarchies') return true;
    if (x == 'autarkies') return true;
    if (x == 'autecisms') return true;
    if (x == 'authenticates') return true;
    if (x == 'authentications') return true;
    if (x == 'authenticities') return true;
    if (x == 'authoress') return true;
    if (x == 'authoresses') return true;
    if (x == 'authorisations') return true;
    if (x == 'authorises') return true;
    if (x == 'authorities') return true;
    if (x == 'authorizations') return true;
    if (x == 'authorizes') return true;
    if (x == 'authors') return true;
    if (x == 'authorships') return true;
    if (x == 'autisms') return true;
    if (x == 'autobahns') return true;
    if (x == 'autobiographers') return true;
    if (x == 'autobiographies') return true;
    if (x == 'autobus') return true;
    if (x == 'autobuses') return true;
    if (x == 'autobusses') return true;
    if (x == 'autocades') return true;
    if (x == 'autocoids') return true;
    if (x == 'autocracies') return true;
    if (x == 'autocrats') return true;
    if (x == 'autodynes') return true;
    if (x == 'autogamies') return true;
    if (x == 'autogenies') return true;
    if (x == 'autogiros') return true;
    if (x == 'autographs') return true;
    if (x == 'autogyros') return true;
    if (x == 'autolyzes') return true;
    if (x == 'automates') return true;
    if (x == 'automations') return true;
    if (x == 'automatons') return true;
    if (x == 'automobiles') return true;
    if (x == 'autonomies') return true;
    if (x == 'autonomous') return true;
    if (x == 'autopsies') return true;
    if (x == 'autos') return true;
    if (x == 'autosomes') return true;
    if (x == 'autotomies') return true;
    if (x == 'autotypes') return true;
    if (x == 'autotypies') return true;
    if (x == 'autumns') return true;
    if (x == 'autunites') return true;
    if (x == 'auxeses') return true;
    if (x == 'auxesis') return true;
    if (x == 'auxetics') return true;
    if (x == 'auxiliaries') return true;
    if (x == 'auxins') return true;
    if (x == 'availabilities') return true;
    if (x == 'avails') return true;
    if (x == 'avalanches') return true;
    if (x == 'avarices') return true;
    if (x == 'avatars') return true;
    if (x == 'avengers') return true;
    if (x == 'avenges') return true;
    if (x == 'avens') return true;
    if (x == 'avenses') return true;
    if (x == 'aventails') return true;
    if (x == 'avenues') return true;
    if (x == 'averages') return true;
    if (x == 'averments') return true;
    if (x == 'avers') return true;
    if (x == 'aversions') return true;
    if (x == 'averts') return true;
    if (x == 'aves') return true;
    if (x == 'avgas') return true;
    if (x == 'avgases') return true;
    if (x == 'avgasses') return true;
    if (x == 'avianizes') return true;
    if (x == 'avians') return true;
    if (x == 'aviaries') return true;
    if (x == 'aviarists') return true;
    if (x == 'aviates') return true;
    if (x == 'aviations') return true;
    if (x == 'aviators') return true;
    if (x == 'aviatrices') return true;
    if (x == 'aviatrixes') return true;
    if (x == 'avidins') return true;
    if (x == 'avidities') return true;
    if (x == 'avidness') return true;
    if (x == 'avidnesses') return true;
    if (x == 'avifaunas') return true;
    if (x == 'avigators') return true;
    if (x == 'avionics') return true;
    if (x == 'avions') return true;
    if (x == 'avisos') return true;
    if (x == 'avocadoes') return true;
    if (x == 'avocados') return true;
    if (x == 'avocations') return true;
    if (x == 'avocets') return true;
    if (x == 'avodires') return true;
    if (x == 'avoidances') return true;
    if (x == 'avoiders') return true;
    if (x == 'avoids') return true;
    if (x == 'avoidupois') return true;
    if (x == 'avoidupoises') return true;
    if (x == 'avos') return true;
    if (x == 'avosets') return true;
    if (x == 'avouchers') return true;
    if (x == 'avouches') return true;
    if (x == 'avowals') return true;
    if (x == 'avowers') return true;
    if (x == 'avows') return true;
    if (x == 'avulses') return true;
    if (x == 'avulsions') return true;
    if (x == 'awaiters') return true;
    if (x == 'awaits') return true;
    if (x == 'awakeners') return true;
    if (x == 'awakens') return true;
    if (x == 'awakes') return true;
    if (x == 'awardees') return true;
    if (x == 'awarders') return true;
    if (x == 'awards') return true;
    if (x == 'awayness') return true;
    if (x == 'awaynesses') return true;
    if (x == 'aweless') return true;
    if (x == 'awes') return true;
    if (x == 'awkwardness') return true;
    if (x == 'awkwardnesses') return true;
    if (x == 'awless') return true;
    if (x == 'awls') return true;
    if (x == 'awlworts') return true;
    if (x == 'awmous') return true;
    if (x == 'awnings') return true;
    if (x == 'awnless') return true;
    if (x == 'awns') return true;
    if (x == 'awols') return true;
    if (x == 'axels') return true;
    if (x == 'axes') return true;
    if (x == 'axialities') return true;
    if (x == 'axillaries') return true;
    if (x == 'axillars') return true;
    if (x == 'axillas') return true;
    if (x == 'axils') return true;
    if (x == 'axiologies') return true;
    if (x == 'axioms') return true;
    if (x == 'axis') return true;
    if (x == 'axises') return true;
    if (x == 'axites') return true;
    if (x == 'axles') return true;
    if (x == 'axletrees') return true;
    if (x == 'axolotls') return true;
    if (x == 'axones') return true;
    if (x == 'axons') return true;
    if (x == 'axoplasms') return true;
    if (x == 'axseeds') return true;
    if (x == 'ayahs') return true;
    if (x == 'ayes') return true;
    if (x == 'ayins') return true;
    if (x == 'ays') return true;
    if (x == 'azaleas') return true;
    if (x == 'azans') return true;
    if (x == 'azides') return true;
    if (x == 'azimuths') return true;
    if (x == 'azines') return true;
    if (x == 'azoles') return true;
    if (x == 'azons') return true;
    if (x == 'azotemias') return true;
    if (x == 'azotes') return true;
    if (x == 'azoths') return true;
    if (x == 'azotises') return true;
    if (x == 'azotizes') return true;
    if (x == 'azoturias') return true;
    if (x == 'azures') return true;
    if (x == 'azurites') return true;
    if (x == 'azygos') return true;
    if (x == 'azygoses') return true;
    if (x == 'azygous') return true;
    return nil;
  }
;
twiEscSS: TwiEscDataObject
  firstLetter = 's'
  lastLetter  = 's'
  isGoodWord(x) {
    if (x < 'sc') {                     // SA-SB
      if (isGoodWordSA(x)) return true;
      else return nil;
    }
    else if (x < 'se') {                // SC-SD
      if (isGoodWordSC(x)) return true;
      else return nil;
    }
    else if (x < 'sf') {                // SE
      if (isGoodWordSE(x)) return true;
      else return nil;
    }
    else if (x < 'si') {                // SF-SH
      if (isGoodWordSF(x)) return true;
      else return nil;
    }
    else if (x < 'sl') {                // SI-SK
      if (isGoodWordSI(x)) return true;
      else return nil;
    }
    else if (x < 'so') {                // SL-SN
      if (isGoodWordSL(x)) return true;
      else return nil;
    }
    else if (x < 'sp') {                // SO
      if (isGoodWordSO(x)) return true;
      else return nil;
    }
    else if (x < 'sta') {               // SP-SS
      if (isGoodWordSP(x)) return true;
      else return nil;
    }
    else if (x < 'str') {               // STA-STQ
      if (isGoodWordSTA(x)) return true;
      else return nil;
    }
    else if (x < 'suc') {               // STR-SUB
      if (isGoodWordSTR(x)) return true;
      else return nil;
    }
    else if (x < 'sv') {                // SUC-SUZ
      if (isGoodWordSUC(x)) return true;
      else return nil;
    }
    else {                              // SV-SZ
      if (isGoodWordSV(x)) return true;
      else return nil;
    }
  }
  isGoodWordSA(x) {
    if (x == 'sabatons') return true;
    if (x == 'sabbaths') return true;
    if (x == 'sabbats') return true;
    if (x == 'sabers') return true;
    if (x == 'sabes') return true;
    if (x == 'sabines') return true;
    if (x == 'sabins') return true;
    if (x == 'sabirs') return true;
    if (x == 'sables') return true;
    if (x == 'sabotages') return true;
    if (x == 'saboteurs') return true;
    if (x == 'sabots') return true;
    if (x == 'sabras') return true;
    if (x == 'sabres') return true;
    if (x == 'sabs') return true;
    if (x == 'sabulous') return true;
    if (x == 'sacatons') return true;
    if (x == 'sacbuts') return true;
    if (x == 'saccades') return true;
    if (x == 'saccharins') return true;
    if (x == 'saccules') return true;
    if (x == 'sacculus') return true;
    if (x == 'sachems') return true;
    if (x == 'sachets') return true;
    if (x == 'sackbuts') return true;
    if (x == 'sackcloths') return true;
    if (x == 'sackers') return true;
    if (x == 'sackfuls') return true;
    if (x == 'sackings') return true;
    if (x == 'sacks') return true;
    if (x == 'sacques') return true;
    if (x == 'sacrals') return true;
    if (x == 'sacraments') return true;
    if (x == 'sacrifices') return true;
    if (x == 'sacrileges') return true;
    if (x == 'sacrilegious') return true;
    if (x == 'sacristies') return true;
    if (x == 'sacrists') return true;
    if (x == 'sacs') return true;
    if (x == 'saddens') return true;
    if (x == 'saddhus') return true;
    if (x == 'saddleries') return true;
    if (x == 'saddlers') return true;
    if (x == 'saddles') return true;
    if (x == 'sades') return true;
    if (x == 'sadhes') return true;
    if (x == 'sadhus') return true;
    if (x == 'sadirons') return true;
    if (x == 'sadis') return true;
    if (x == 'sadisms') return true;
    if (x == 'sadists') return true;
    if (x == 'sadness') return true;
    if (x == 'sadnesses') return true;
    if (x == 'safaris') return true;
    if (x == 'safeguards') return true;
    if (x == 'safekeepings') return true;
    if (x == 'safeness') return true;
    if (x == 'safenesses') return true;
    if (x == 'safes') return true;
    if (x == 'safeties') return true;
    if (x == 'safflowers') return true;
    if (x == 'saffrons') return true;
    if (x == 'safranins') return true;
    if (x == 'safroles') return true;
    if (x == 'safrols') return true;
    if (x == 'sagacious') return true;
    if (x == 'sagacities') return true;
    if (x == 'sagamores') return true;
    if (x == 'saganashes') return true;
    if (x == 'sagas') return true;
    if (x == 'sagbuts') return true;
    if (x == 'sagebrushes') return true;
    if (x == 'sageness') return true;
    if (x == 'sagenesses') return true;
    if (x == 'sages') return true;
    if (x == 'saggards') return true;
    if (x == 'saggars') return true;
    if (x == 'saggers') return true;
    if (x == 'sagos') return true;
    if (x == 'sags') return true;
    if (x == 'saguaros') return true;
    if (x == 'sahibs') return true;
    if (x == 'sahiwals') return true;
    if (x == 'sahuaros') return true;
    if (x == 'saices') return true;
    if (x == 'saids') return true;
    if (x == 'saigas') return true;
    if (x == 'sailboats') return true;
    if (x == 'sailers') return true;
    if (x == 'sailfishes') return true;
    if (x == 'sailings') return true;
    if (x == 'sailors') return true;
    if (x == 'sails') return true;
    if (x == 'sainfoins') return true;
    if (x == 'sains') return true;
    if (x == 'saintdoms') return true;
    if (x == 'sainthoods') return true;
    if (x == 'saintliness') return true;
    if (x == 'saintlinesses') return true;
    if (x == 'saints') return true;
    if (x == 'saiyids') return true;
    if (x == 'sajous') return true;
    if (x == 'sakers') return true;
    if (x == 'sakes') return true;
    if (x == 'sakis') return true;
    if (x == 'salaams') return true;
    if (x == 'salacious') return true;
    if (x == 'salacities') return true;
    if (x == 'saladangs') return true;
    if (x == 'salads') return true;
    if (x == 'salamanders') return true;
    if (x == 'salamis') return true;
    if (x == 'salariats') return true;
    if (x == 'salaries') return true;
    if (x == 'saleps') return true;
    if (x == 'salerooms') return true;
    if (x == 'sales') return true;
    if (x == 'salicines') return true;
    if (x == 'salicins') return true;
    if (x == 'saliences') return true;
    if (x == 'saliencies') return true;
    if (x == 'salients') return true;
    if (x == 'salifies') return true;
    if (x == 'salinas') return true;
    if (x == 'salines') return true;
    if (x == 'salinises') return true;
    if (x == 'salinities') return true;
    if (x == 'salinizes') return true;
    if (x == 'salivas') return true;
    if (x == 'salivates') return true;
    if (x == 'salivations') return true;
    if (x == 'sallets') return true;
    if (x == 'salliers') return true;
    if (x == 'sallies') return true;
    if (x == 'sallows') return true;
    if (x == 'salmis') return true;
    if (x == 'salmonids') return true;
    if (x == 'salmons') return true;
    if (x == 'salols') return true;
    if (x == 'salons') return true;
    if (x == 'saloons') return true;
    if (x == 'saloops') return true;
    if (x == 'salpas') return true;
    if (x == 'salpians') return true;
    if (x == 'salpids') return true;
    if (x == 'salpinges') return true;
    if (x == 'salps') return true;
    if (x == 'sals') return true;
    if (x == 'salsifies') return true;
    if (x == 'salsillas') return true;
    if (x == 'saltboxes') return true;
    if (x == 'saltbushes') return true;
    if (x == 'salterns') return true;
    if (x == 'salters') return true;
    if (x == 'saltiers') return true;
    if (x == 'salties') return true;
    if (x == 'saltines') return true;
    if (x == 'saltiness') return true;
    if (x == 'saltinesses') return true;
    if (x == 'saltires') return true;
    if (x == 'saltless') return true;
    if (x == 'saltness') return true;
    if (x == 'saltnesses') return true;
    if (x == 'saltpans') return true;
    if (x == 'salts') return true;
    if (x == 'saltwaters') return true;
    if (x == 'saltworks') return true;
    if (x == 'saltworts') return true;
    if (x == 'salubrious') return true;
    if (x == 'salukis') return true;
    if (x == 'salutations') return true;
    if (x == 'saluters') return true;
    if (x == 'salutes') return true;
    if (x == 'salvagees') return true;
    if (x == 'salvagers') return true;
    if (x == 'salvages') return true;
    if (x == 'salvations') return true;
    if (x == 'salvers') return true;
    if (x == 'salves') return true;
    if (x == 'salvias') return true;
    if (x == 'salvoes') return true;
    if (x == 'salvors') return true;
    if (x == 'salvos') return true;
    if (x == 'samaras') return true;
    if (x == 'samariums') return true;
    if (x == 'sambars') return true;
    if (x == 'sambas') return true;
    if (x == 'sambhars') return true;
    if (x == 'sambhurs') return true;
    if (x == 'sambos') return true;
    if (x == 'sambucas') return true;
    if (x == 'sambukes') return true;
    if (x == 'samburs') return true;
    if (x == 'samechs') return true;
    if (x == 'samekhs') return true;
    if (x == 'sameks') return true;
    if (x == 'sameness') return true;
    if (x == 'samenesses') return true;
    if (x == 'samiels') return true;
    if (x == 'samisens') return true;
    if (x == 'samites') return true;
    if (x == 'samlets') return true;
    if (x == 'samovars') return true;
    if (x == 'sampans') return true;
    if (x == 'samphires') return true;
    if (x == 'samplers') return true;
    if (x == 'samples') return true;
    if (x == 'samplings') return true;
    if (x == 'samps') return true;
    if (x == 'samsaras') return true;
    if (x == 'samshus') return true;
    if (x == 'samurais') return true;
    if (x == 'sanatoriums') return true;
    if (x == 'sanctifications') return true;
    if (x == 'sanctifies') return true;
    if (x == 'sanctimonious') return true;
    if (x == 'sanctions') return true;
    if (x == 'sanctities') return true;
    if (x == 'sanctuaries') return true;
    if (x == 'sanctums') return true;
    if (x == 'sandals') return true;
    if (x == 'sandaracs') return true;
    if (x == 'sandbags') return true;
    if (x == 'sandbanks') return true;
    if (x == 'sandbars') return true;
    if (x == 'sandboxes') return true;
    if (x == 'sandburrs') return true;
    if (x == 'sandburs') return true;
    if (x == 'sanders') return true;
    if (x == 'sandfishes') return true;
    if (x == 'sandflies') return true;
    if (x == 'sandhis') return true;
    if (x == 'sandhogs') return true;
    if (x == 'sandlings') return true;
    if (x == 'sandlots') return true;
    if (x == 'sandpapers') return true;
    if (x == 'sandpeeps') return true;
    if (x == 'sandpiles') return true;
    if (x == 'sandpipers') return true;
    if (x == 'sandpits') return true;
    if (x == 'sands') return true;
    if (x == 'sandsoaps') return true;
    if (x == 'sandstones') return true;
    if (x == 'sandstorms') return true;
    if (x == 'sandwiches') return true;
    if (x == 'sandworms') return true;
    if (x == 'sandworts') return true;
    if (x == 'saneness') return true;
    if (x == 'sanenesses') return true;
    if (x == 'sanes') return true;
    if (x == 'sangarees') return true;
    if (x == 'sangars') return true;
    if (x == 'sangas') return true;
    if (x == 'sangers') return true;
    if (x == 'sanghs') return true;
    if (x == 'sangrias') return true;
    if (x == 'sanguines') return true;
    if (x == 'sanicles') return true;
    if (x == 'sanies') return true;
    if (x == 'sanious') return true;
    if (x == 'sanitaries') return true;
    if (x == 'sanitariums') return true;
    if (x == 'sanitates') return true;
    if (x == 'sanitations') return true;
    if (x == 'sanities') return true;
    if (x == 'sanitises') return true;
    if (x == 'sanitizes') return true;
    if (x == 'sanjaks') return true;
    if (x == 'sannops') return true;
    if (x == 'sannups') return true;
    if (x == 'sannyasis') return true;
    if (x == 'sans') return true;
    if (x == 'sansars') return true;
    if (x == 'sanseis') return true;
    if (x == 'sanserifs') return true;
    if (x == 'santims') return true;
    if (x == 'santirs') return true;
    if (x == 'santols') return true;
    if (x == 'santonins') return true;
    if (x == 'santours') return true;
    if (x == 'sapajous') return true;
    if (x == 'sapheads') return true;
    if (x == 'sapidities') return true;
    if (x == 'sapiences') return true;
    if (x == 'sapiencies') return true;
    if (x == 'sapiens') return true;
    if (x == 'sapless') return true;
    if (x == 'saplings') return true;
    if (x == 'saponifies') return true;
    if (x == 'saponines') return true;
    if (x == 'saponins') return true;
    if (x == 'saponites') return true;
    if (x == 'saporous') return true;
    if (x == 'sapors') return true;
    if (x == 'sapotas') return true;
    if (x == 'sapours') return true;
    if (x == 'sappers') return true;
    if (x == 'sapphics') return true;
    if (x == 'sapphires') return true;
    if (x == 'sapphisms') return true;
    if (x == 'sapphists') return true;
    if (x == 'sapremias') return true;
    if (x == 'saprobes') return true;
    if (x == 'sapropels') return true;
    if (x == 'saps') return true;
    if (x == 'sapsagos') return true;
    if (x == 'sapsuckers') return true;
    if (x == 'sapwoods') return true;
    if (x == 'sarabands') return true;
    if (x == 'sarapes') return true;
    if (x == 'sarcasms') return true;
    if (x == 'sarcenets') return true;
    if (x == 'sarcoids') return true;
    if (x == 'sarcomas') return true;
    if (x == 'sarcophagus') return true;
    if (x == 'sarcous') return true;
    if (x == 'sardars') return true;
    if (x == 'sardines') return true;
    if (x == 'sardius') return true;
    if (x == 'sardiuses') return true;
    if (x == 'sardonyxes') return true;
    if (x == 'sards') return true;
    if (x == 'sarees') return true;
    if (x == 'sargassos') return true;
    if (x == 'sarges') return true;
    if (x == 'sarins') return true;
    if (x == 'saris') return true;
    if (x == 'sarks') return true;
    if (x == 'sarments') return true;
    if (x == 'sarodes') return true;
    if (x == 'sarodists') return true;
    if (x == 'sarods') return true;
    if (x == 'sarongs') return true;
    if (x == 'sarsaparillas') return true;
    if (x == 'sarsars') return true;
    if (x == 'sarsenets') return true;
    if (x == 'sarsens') return true;
    if (x == 'sartors') return true;
    if (x == 'sashays') return true;
    if (x == 'sashes') return true;
    if (x == 'sashimis') return true;
    if (x == 'sasins') return true;
    if (x == 'sass') return true;
    if (x == 'sassabies') return true;
    if (x == 'sassafras') return true;
    if (x == 'sassafrases') return true;
    if (x == 'sasses') return true;
    if (x == 'sassies') return true;
    if (x == 'sasswoods') return true;
    if (x == 'satangs') return true;
    if (x == 'satanisms') return true;
    if (x == 'satanists') return true;
    if (x == 'sataras') return true;
    if (x == 'satchels') return true;
    if (x == 'sateens') return true;
    if (x == 'satellites') return true;
    if (x == 'sates') return true;
    if (x == 'satiates') return true;
    if (x == 'satieties') return true;
    if (x == 'satinets') return true;
    if (x == 'satinpods') return true;
    if (x == 'satins') return true;
    if (x == 'satires') return true;
    if (x == 'satirises') return true;
    if (x == 'satirists') return true;
    if (x == 'satirizes') return true;
    if (x == 'satis') return true;
    if (x == 'satisfactions') return true;
    if (x == 'satisfies') return true;
    if (x == 'satoris') return true;
    if (x == 'satrapies') return true;
    if (x == 'satraps') return true;
    if (x == 'saturants') return true;
    if (x == 'saturates') return true;
    if (x == 'saturations') return true;
    if (x == 'saturnalias') return true;
    if (x == 'saturnisms') return true;
    if (x == 'satyrids') return true;
    if (x == 'satyrs') return true;
    if (x == 'sauceboxes') return true;
    if (x == 'saucepans') return true;
    if (x == 'saucers') return true;
    if (x == 'sauces') return true;
    if (x == 'sauchs') return true;
    if (x == 'sauerkrauts') return true;
    if (x == 'saugers') return true;
    if (x == 'saughs') return true;
    if (x == 'sauls') return true;
    if (x == 'saults') return true;
    if (x == 'saunas') return true;
    if (x == 'saunters') return true;
    if (x == 'saurels') return true;
    if (x == 'saurians') return true;
    if (x == 'sauries') return true;
    if (x == 'sauropods') return true;
    if (x == 'sausages') return true;
    if (x == 'sauternes') return true;
    if (x == 'sautes') return true;
    if (x == 'sautoires') return true;
    if (x == 'sautoirs') return true;
    if (x == 'savageness') return true;
    if (x == 'savagenesses') return true;
    if (x == 'savageries') return true;
    if (x == 'savages') return true;
    if (x == 'savagisms') return true;
    if (x == 'savannahs') return true;
    if (x == 'savannas') return true;
    if (x == 'savants') return true;
    if (x == 'savates') return true;
    if (x == 'saveloys') return true;
    if (x == 'savers') return true;
    if (x == 'saves') return true;
    if (x == 'savines') return true;
    if (x == 'savings') return true;
    if (x == 'savins') return true;
    if (x == 'saviors') return true;
    if (x == 'saviours') return true;
    if (x == 'savorers') return true;
    if (x == 'savories') return true;
    if (x == 'savorous') return true;
    if (x == 'savors') return true;
    if (x == 'savourers') return true;
    if (x == 'savouries') return true;
    if (x == 'savours') return true;
    if (x == 'savoys') return true;
    if (x == 'savvies') return true;
    if (x == 'sawbills') return true;
    if (x == 'sawbones') return true;
    if (x == 'sawboneses') return true;
    if (x == 'sawbucks') return true;
    if (x == 'sawdusts') return true;
    if (x == 'sawers') return true;
    if (x == 'sawfishes') return true;
    if (x == 'sawflies') return true;
    if (x == 'sawhorses') return true;
    if (x == 'sawlogs') return true;
    if (x == 'sawmills') return true;
    if (x == 'sawneys') return true;
    if (x == 'saws') return true;
    if (x == 'sawyers') return true;
    if (x == 'saxes') return true;
    if (x == 'saxhorns') return true;
    if (x == 'saxonies') return true;
    if (x == 'saxophones') return true;
    if (x == 'saxtubas') return true;
    if (x == 'sayers') return true;
    if (x == 'sayids') return true;
    if (x == 'sayings') return true;
    if (x == 'sayonaras') return true;
    if (x == 'says') return true;
    if (x == 'sayyids') return true;
    return nil;
  }
  isGoodWordSC(x) {
    if (x == 'scabbards') return true;
    if (x == 'scabbles') return true;
    if (x == 'scabies') return true;
    if (x == 'scabiosas') return true;
    if (x == 'scabious') return true;
    if (x == 'scabiouses') return true;
    if (x == 'scabrous') return true;
    if (x == 'scabs') return true;
    if (x == 'scads') return true;
    if (x == 'scaffolds') return true;
    if (x == 'scags') return true;
    if (x == 'scalades') return true;
    if (x == 'scalados') return true;
    if (x == 'scalages') return true;
    if (x == 'scalares') return true;
    if (x == 'scalars') return true;
    if (x == 'scalawags') return true;
    if (x == 'scalds') return true;
    if (x == 'scaleless') return true;
    if (x == 'scalenus') return true;
    if (x == 'scalepans') return true;
    if (x == 'scalers') return true;
    if (x == 'scales') return true;
    if (x == 'scallions') return true;
    if (x == 'scallops') return true;
    if (x == 'scalls') return true;
    if (x == 'scalpels') return true;
    if (x == 'scalpers') return true;
    if (x == 'scalps') return true;
    if (x == 'scammonies') return true;
    if (x == 'scampers') return true;
    if (x == 'scamps') return true;
    if (x == 'scams') return true;
    if (x == 'scandalises') return true;
    if (x == 'scandalizes') return true;
    if (x == 'scandalous') return true;
    if (x == 'scandals') return true;
    if (x == 'scandias') return true;
    if (x == 'scandiums') return true;
    if (x == 'scanners') return true;
    if (x == 'scannings') return true;
    if (x == 'scans') return true;
    if (x == 'scansions') return true;
    if (x == 'scanties') return true;
    if (x == 'scants') return true;
    if (x == 'scapegoats') return true;
    if (x == 'scapes') return true;
    if (x == 'scaphoids') return true;
    if (x == 'scapulars') return true;
    if (x == 'scapulas') return true;
    if (x == 'scarabs') return true;
    if (x == 'scarcities') return true;
    if (x == 'scarecrows') return true;
    if (x == 'scarers') return true;
    if (x == 'scares') return true;
    if (x == 'scarfpins') return true;
    if (x == 'scarfs') return true;
    if (x == 'scarifies') return true;
    if (x == 'scarious') return true;
    if (x == 'scarless') return true;
    if (x == 'scarlets') return true;
    if (x == 'scarpers') return true;
    if (x == 'scarphs') return true;
    if (x == 'scarps') return true;
    if (x == 'scars') return true;
    if (x == 'scarts') return true;
    if (x == 'scarves') return true;
    if (x == 'scatbacks') return true;
    if (x == 'scathes') return true;
    if (x == 'scats') return true;
    if (x == 'scattergrams') return true;
    if (x == 'scatters') return true;
    if (x == 'scatts') return true;
    if (x == 'scaupers') return true;
    if (x == 'scaups') return true;
    if (x == 'scaurs') return true;
    if (x == 'scavengers') return true;
    if (x == 'scavenges') return true;
    if (x == 'scenarios') return true;
    if (x == 'scenas') return true;
    if (x == 'scends') return true;
    if (x == 'sceneries') return true;
    if (x == 'scenes') return true;
    if (x == 'scents') return true;
    if (x == 'scepters') return true;
    if (x == 'sceptics') return true;
    if (x == 'sceptres') return true;
    if (x == 'schappes') return true;
    if (x == 'schavs') return true;
    if (x == 'schedules') return true;
    if (x == 'schemers') return true;
    if (x == 'schemes') return true;
    if (x == 'scherzos') return true;
    if (x == 'schillers') return true;
    if (x == 'schisms') return true;
    if (x == 'schists') return true;
    if (x == 'schizoids') return true;
    if (x == 'schizonts') return true;
    if (x == 'schizophrenias') return true;
    if (x == 'schizophrenics') return true;
    if (x == 'schizos') return true;
    if (x == 'schlepps') return true;
    if (x == 'schleps') return true;
    if (x == 'schlocks') return true;
    if (x == 'schmaltzes') return true;
    if (x == 'schmalzes') return true;
    if (x == 'schmeers') return true;
    if (x == 'schmelzes') return true;
    if (x == 'schmoes') return true;
    if (x == 'schmoos') return true;
    if (x == 'schmooses') return true;
    if (x == 'schmoozes') return true;
    if (x == 'schmucks') return true;
    if (x == 'schnapps') return true;
    if (x == 'schnaps') return true;
    if (x == 'schnooks') return true;
    if (x == 'scholars') return true;
    if (x == 'scholarships') return true;
    if (x == 'scholiums') return true;
    if (x == 'schoolboys') return true;
    if (x == 'schoolgirls') return true;
    if (x == 'schoolhouses') return true;
    if (x == 'schoolmates') return true;
    if (x == 'schoolrooms') return true;
    if (x == 'schools') return true;
    if (x == 'schoolteachers') return true;
    if (x == 'schooners') return true;
    if (x == 'schorls') return true;
    if (x == 'schriks') return true;
    if (x == 'schticks') return true;
    if (x == 'schuits') return true;
    if (x == 'schuss') return true;
    if (x == 'schusses') return true;
    if (x == 'schwas') return true;
    if (x == 'sciaenids') return true;
    if (x == 'sciaticas') return true;
    if (x == 'sciatics') return true;
    if (x == 'sciences') return true;
    if (x == 'scientists') return true;
    if (x == 'scillas') return true;
    if (x == 'scimetars') return true;
    if (x == 'scimitars') return true;
    if (x == 'scimiters') return true;
    if (x == 'scincoids') return true;
    if (x == 'scintillates') return true;
    if (x == 'scintillations') return true;
    if (x == 'sciolisms') return true;
    if (x == 'sciolists') return true;
    if (x == 'scions') return true;
    if (x == 'sciroccos') return true;
    if (x == 'scirrhus') return true;
    if (x == 'scirrhuses') return true;
    if (x == 'scissions') return true;
    if (x == 'scissors') return true;
    if (x == 'scissures') return true;
    if (x == 'sciurines') return true;
    if (x == 'sclaffers') return true;
    if (x == 'sclaffs') return true;
    if (x == 'scleras') return true;
    if (x == 'sclereids') return true;
    if (x == 'sclerites') return true;
    if (x == 'scleroses') return true;
    if (x == 'sclerosis') return true;
    if (x == 'sclerosises') return true;
    if (x == 'sclerous') return true;
    if (x == 'scoffers') return true;
    if (x == 'scofflaws') return true;
    if (x == 'scoffs') return true;
    if (x == 'scolders') return true;
    if (x == 'scoldings') return true;
    if (x == 'scolds') return true;
    if (x == 'scoleces') return true;
    if (x == 'scolices') return true;
    if (x == 'scoliomas') return true;
    if (x == 'scollops') return true;
    if (x == 'sconces') return true;
    if (x == 'scones') return true;
    if (x == 'scoopers') return true;
    if (x == 'scoopfuls') return true;
    if (x == 'scoops') return true;
    if (x == 'scooters') return true;
    if (x == 'scoots') return true;
    if (x == 'scopes') return true;
    if (x == 'scops') return true;
    if (x == 'scopulas') return true;
    if (x == 'scorchers') return true;
    if (x == 'scorches') return true;
    if (x == 'scoreless') return true;
    if (x == 'scorepads') return true;
    if (x == 'scorers') return true;
    if (x == 'scores') return true;
    if (x == 'scorifies') return true;
    if (x == 'scorners') return true;
    if (x == 'scorns') return true;
    if (x == 'scorpions') return true;
    if (x == 'scotches') return true;
    if (x == 'scoters') return true;
    if (x == 'scotias') return true;
    if (x == 'scotomas') return true;
    if (x == 'scotopias') return true;
    if (x == 'scots') return true;
    if (x == 'scotties') return true;
    if (x == 'scoundrels') return true;
    if (x == 'scourers') return true;
    if (x == 'scourgers') return true;
    if (x == 'scourges') return true;
    if (x == 'scourings') return true;
    if (x == 'scours') return true;
    if (x == 'scousers') return true;
    if (x == 'scouses') return true;
    if (x == 'scouters') return true;
    if (x == 'scouthers') return true;
    if (x == 'scouths') return true;
    if (x == 'scoutings') return true;
    if (x == 'scouts') return true;
    if (x == 'scowders') return true;
    if (x == 'scowlers') return true;
    if (x == 'scowls') return true;
    if (x == 'scows') return true;
    if (x == 'scrabbles') return true;
    if (x == 'scrags') return true;
    if (x == 'scraichs') return true;
    if (x == 'scraighs') return true;
    if (x == 'scrambles') return true;
    if (x == 'scrams') return true;
    if (x == 'scrannels') return true;
    if (x == 'scrapbooks') return true;
    if (x == 'scrapers') return true;
    if (x == 'scrapes') return true;
    if (x == 'scrapies') return true;
    if (x == 'scrapings') return true;
    if (x == 'scrappers') return true;
    if (x == 'scrapples') return true;
    if (x == 'scraps') return true;
    if (x == 'scratches') return true;
    if (x == 'scrawlers') return true;
    if (x == 'scrawls') return true;
    if (x == 'screaks') return true;
    if (x == 'screamers') return true;
    if (x == 'screams') return true;
    if (x == 'screeches') return true;
    if (x == 'screeds') return true;
    if (x == 'screeners') return true;
    if (x == 'screens') return true;
    if (x == 'screes') return true;
    if (x == 'screwballs') return true;
    if (x == 'screwdrivers') return true;
    if (x == 'screwers') return true;
    if (x == 'screws') return true;
    if (x == 'scribbles') return true;
    if (x == 'scribers') return true;
    if (x == 'scribes') return true;
    if (x == 'scrieves') return true;
    if (x == 'scrimps') return true;
    if (x == 'scrims') return true;
    if (x == 'scrips') return true;
    if (x == 'scripts') return true;
    if (x == 'scriptures') return true;
    if (x == 'scrives') return true;
    if (x == 'scrods') return true;
    if (x == 'scrofulas') return true;
    if (x == 'scrolls') return true;
    if (x == 'scrooges') return true;
    if (x == 'scroops') return true;
    if (x == 'scrotums') return true;
    if (x == 'scrouges') return true;
    if (x == 'scrounges') return true;
    if (x == 'scrubbers') return true;
    if (x == 'scrubs') return true;
    if (x == 'scruffs') return true;
    if (x == 'scrums') return true;
    if (x == 'scrunches') return true;
    if (x == 'scruples') return true;
    if (x == 'scrupulous') return true;
    if (x == 'scrutinies') return true;
    if (x == 'scrutinises') return true;
    if (x == 'scrutinizes') return true;
    if (x == 'scubas') return true;
    if (x == 'scuds') return true;
    if (x == 'scufflers') return true;
    if (x == 'scuffles') return true;
    if (x == 'scuffs') return true;
    if (x == 'sculkers') return true;
    if (x == 'sculks') return true;
    if (x == 'sculleries') return true;
    if (x == 'scullers') return true;
    if (x == 'scullions') return true;
    if (x == 'sculls') return true;
    if (x == 'sculpins') return true;
    if (x == 'sculps') return true;
    if (x == 'sculptors') return true;
    if (x == 'sculpts') return true;
    if (x == 'sculptures') return true;
    if (x == 'scumbles') return true;
    if (x == 'scummers') return true;
    if (x == 'scums') return true;
    if (x == 'scunners') return true;
    if (x == 'scuppaugs') return true;
    if (x == 'scuppers') return true;
    if (x == 'scups') return true;
    if (x == 'scurfs') return true;
    if (x == 'scurries') return true;
    if (x == 'scurrilous') return true;
    if (x == 'scurvies') return true;
    if (x == 'scutages') return true;
    if (x == 'scutchers') return true;
    if (x == 'scutches') return true;
    if (x == 'scutes') return true;
    if (x == 'scuts') return true;
    if (x == 'scutters') return true;
    if (x == 'scuttles') return true;
    if (x == 'scythes') return true;
    return nil;
  }
  isGoodWordSE(x) {
    if (x == 'seabags') return true;
    if (x == 'seabeaches') return true;
    if (x == 'seabeds') return true;
    if (x == 'seabirds') return true;
    if (x == 'seaboards') return true;
    if (x == 'seaboots') return true;
    if (x == 'seacoasts') return true;
    if (x == 'seacocks') return true;
    if (x == 'seacrafts') return true;
    if (x == 'seadogs') return true;
    if (x == 'seadromes') return true;
    if (x == 'seafarers') return true;
    if (x == 'seafarings') return true;
    if (x == 'seafloors') return true;
    if (x == 'seafoods') return true;
    if (x == 'seafowls') return true;
    if (x == 'seafronts') return true;
    if (x == 'sealants') return true;
    if (x == 'sealeries') return true;
    if (x == 'sealers') return true;
    if (x == 'seals') return true;
    if (x == 'sealskins') return true;
    if (x == 'seamanships') return true;
    if (x == 'seamarks') return true;
    if (x == 'seamers') return true;
    if (x == 'seamless') return true;
    if (x == 'seamounts') return true;
    if (x == 'seams') return true;
    if (x == 'seamsters') return true;
    if (x == 'seamstress') return true;
    if (x == 'seamstresses') return true;
    if (x == 'seances') return true;
    if (x == 'seapieces') return true;
    if (x == 'seaplanes') return true;
    if (x == 'seaports') return true;
    if (x == 'seaquakes') return true;
    if (x == 'searchers') return true;
    if (x == 'searches') return true;
    if (x == 'searchlights') return true;
    if (x == 'sears') return true;
    if (x == 'seas') return true;
    if (x == 'seascapes') return true;
    if (x == 'seascouts') return true;
    if (x == 'seashells') return true;
    if (x == 'seashores') return true;
    if (x == 'seasickness') return true;
    if (x == 'seasicknesses') return true;
    if (x == 'seasides') return true;
    if (x == 'seasoners') return true;
    if (x == 'seasons') return true;
    if (x == 'seaters') return true;
    if (x == 'seatings') return true;
    if (x == 'seatless') return true;
    if (x == 'seatmates') return true;
    if (x == 'seatrains') return true;
    if (x == 'seats') return true;
    if (x == 'seatworks') return true;
    if (x == 'seawalls') return true;
    if (x == 'seawans') return true;
    if (x == 'seawants') return true;
    if (x == 'seawards') return true;
    if (x == 'seawares') return true;
    if (x == 'seawaters') return true;
    if (x == 'seaways') return true;
    if (x == 'seaweeds') return true;
    if (x == 'sebums') return true;
    if (x == 'secants') return true;
    if (x == 'secateurs') return true;
    if (x == 'seccos') return true;
    if (x == 'seceders') return true;
    if (x == 'secedes') return true;
    if (x == 'secerns') return true;
    if (x == 'secludes') return true;
    if (x == 'seclusions') return true;
    if (x == 'seconders') return true;
    if (x == 'secondes') return true;
    if (x == 'seconds') return true;
    if (x == 'secpars') return true;
    if (x == 'secrecies') return true;
    if (x == 'secretariats') return true;
    if (x == 'secretaries') return true;
    if (x == 'secretes') return true;
    if (x == 'secretins') return true;
    if (x == 'secretions') return true;
    if (x == 'secretors') return true;
    if (x == 'secrets') return true;
    if (x == 'secs') return true;
    if (x == 'sectarians') return true;
    if (x == 'sectaries') return true;
    if (x == 'sections') return true;
    if (x == 'sectors') return true;
    if (x == 'sects') return true;
    if (x == 'seculars') return true;
    if (x == 'securers') return true;
    if (x == 'secures') return true;
    if (x == 'securities') return true;
    if (x == 'sedans') return true;
    if (x == 'sedates') return true;
    if (x == 'sedations') return true;
    if (x == 'sedatives') return true;
    if (x == 'seders') return true;
    if (x == 'sederunts') return true;
    if (x == 'sedges') return true;
    if (x == 'sedimentations') return true;
    if (x == 'sediments') return true;
    if (x == 'seditions') return true;
    if (x == 'seditious') return true;
    if (x == 'seducers') return true;
    if (x == 'seduces') return true;
    if (x == 'seductions') return true;
    if (x == 'sedulities') return true;
    if (x == 'sedulous') return true;
    if (x == 'sedums') return true;
    if (x == 'seedbeds') return true;
    if (x == 'seedcakes') return true;
    if (x == 'seedcases') return true;
    if (x == 'seeders') return true;
    if (x == 'seedless') return true;
    if (x == 'seedlings') return true;
    if (x == 'seedpods') return true;
    if (x == 'seeds') return true;
    if (x == 'seedtimes') return true;
    if (x == 'seeings') return true;
    if (x == 'seekers') return true;
    if (x == 'seeks') return true;
    if (x == 'seels') return true;
    if (x == 'seemers') return true;
    if (x == 'seemings') return true;
    if (x == 'seems') return true;
    if (x == 'seepages') return true;
    if (x == 'seeps') return true;
    if (x == 'seeress') return true;
    if (x == 'seeresses') return true;
    if (x == 'seers') return true;
    if (x == 'seersuckers') return true;
    if (x == 'sees') return true;
    if (x == 'seesaws') return true;
    if (x == 'seethes') return true;
    if (x == 'seggars') return true;
    if (x == 'segments') return true;
    if (x == 'segnos') return true;
    if (x == 'segos') return true;
    if (x == 'segregates') return true;
    if (x == 'segregations') return true;
    if (x == 'segues') return true;
    if (x == 'seicentos') return true;
    if (x == 'seiches') return true;
    if (x == 'seidels') return true;
    if (x == 'seigneurs') return true;
    if (x == 'seigniors') return true;
    if (x == 'seignories') return true;
    if (x == 'seiners') return true;
    if (x == 'seines') return true;
    if (x == 'seis') return true;
    if (x == 'seisers') return true;
    if (x == 'seises') return true;
    if (x == 'seisings') return true;
    if (x == 'seisins') return true;
    if (x == 'seismisms') return true;
    if (x == 'seismographs') return true;
    if (x == 'seisms') return true;
    if (x == 'seisors') return true;
    if (x == 'seisures') return true;
    if (x == 'seizers') return true;
    if (x == 'seizes') return true;
    if (x == 'seizings') return true;
    if (x == 'seizins') return true;
    if (x == 'seizors') return true;
    if (x == 'seizures') return true;
    if (x == 'seladangs') return true;
    if (x == 'selahs') return true;
    if (x == 'selamliks') return true;
    if (x == 'selectees') return true;
    if (x == 'selections') return true;
    if (x == 'selectors') return true;
    if (x == 'selects') return true;
    if (x == 'selenates') return true;
    if (x == 'selenides') return true;
    if (x == 'selenites') return true;
    if (x == 'seleniums') return true;
    if (x == 'selenous') return true;
    if (x == 'selfdoms') return true;
    if (x == 'selfheals') return true;
    if (x == 'selfhoods') return true;
    if (x == 'selfishness') return true;
    if (x == 'selfishnesses') return true;
    if (x == 'selfless') return true;
    if (x == 'selflessness') return true;
    if (x == 'selflessnesses') return true;
    if (x == 'selfness') return true;
    if (x == 'selfnesses') return true;
    if (x == 'selfs') return true;
    if (x == 'sellers') return true;
    if (x == 'selles') return true;
    if (x == 'sellouts') return true;
    if (x == 'sells') return true;
    if (x == 'sels') return true;
    if (x == 'selsyns') return true;
    if (x == 'seltzers') return true;
    if (x == 'selvages') return true;
    if (x == 'selvedges') return true;
    if (x == 'selves') return true;
    if (x == 'semantics') return true;
    if (x == 'semaphores') return true;
    if (x == 'semblances') return true;
    if (x == 'sememes') return true;
    if (x == 'semens') return true;
    if (x == 'semes') return true;
    if (x == 'semesters') return true;
    if (x == 'semicolons') return true;
    if (x == 'semicomas') return true;
    if (x == 'semiconductors') return true;
    if (x == 'semidomes') return true;
    if (x == 'semifinalists') return true;
    if (x == 'semifinals') return true;
    if (x == 'semihoboes') return true;
    if (x == 'semihobos') return true;
    if (x == 'seminarians') return true;
    if (x == 'seminaries') return true;
    if (x == 'seminars') return true;
    if (x == 'semioses') return true;
    if (x == 'semiosis') return true;
    if (x == 'semiotics') return true;
    if (x == 'semipros') return true;
    if (x == 'semis') return true;
    if (x == 'semises') return true;
    if (x == 'semitists') return true;
    if (x == 'semitones') return true;
    if (x == 'semolinas') return true;
    if (x == 'senarius') return true;
    if (x == 'senates') return true;
    if (x == 'senators') return true;
    if (x == 'sendals') return true;
    if (x == 'senders') return true;
    if (x == 'sendoffs') return true;
    if (x == 'sends') return true;
    if (x == 'senecas') return true;
    if (x == 'senecios') return true;
    if (x == 'senegas') return true;
    if (x == 'senhoras') return true;
    if (x == 'senhores') return true;
    if (x == 'senhors') return true;
    if (x == 'seniles') return true;
    if (x == 'senilities') return true;
    if (x == 'seniorities') return true;
    if (x == 'seniors') return true;
    if (x == 'sennas') return true;
    if (x == 'sennets') return true;
    if (x == 'sennights') return true;
    if (x == 'sennits') return true;
    if (x == 'senopias') return true;
    if (x == 'senoras') return true;
    if (x == 'senores') return true;
    if (x == 'senoritas') return true;
    if (x == 'senors') return true;
    if (x == 'sensates') return true;
    if (x == 'sensations') return true;
    if (x == 'senseless') return true;
    if (x == 'senses') return true;
    if (x == 'sensibilities') return true;
    if (x == 'sensibles') return true;
    if (x == 'sensitises') return true;
    if (x == 'sensitiveness') return true;
    if (x == 'sensitivenesses') return true;
    if (x == 'sensitivities') return true;
    if (x == 'sensitizes') return true;
    if (x == 'sensors') return true;
    if (x == 'sensualists') return true;
    if (x == 'sensualities') return true;
    if (x == 'sensuous') return true;
    if (x == 'sensuousness') return true;
    if (x == 'sensuousnesses') return true;
    if (x == 'sentences') return true;
    if (x == 'sententious') return true;
    if (x == 'sentients') return true;
    if (x == 'sentimentalises') return true;
    if (x == 'sentimentalisms') return true;
    if (x == 'sentimentalists') return true;
    if (x == 'sentimentalizes') return true;
    if (x == 'sentiments') return true;
    if (x == 'sentinels') return true;
    if (x == 'sentries') return true;
    if (x == 'sepalous') return true;
    if (x == 'sepals') return true;
    if (x == 'separates') return true;
    if (x == 'separations') return true;
    if (x == 'separators') return true;
    if (x == 'sepias') return true;
    if (x == 'sepoys') return true;
    if (x == 'seppukus') return true;
    if (x == 'sepses') return true;
    if (x == 'sepsis') return true;
    if (x == 'septets') return true;
    if (x == 'septettes') return true;
    if (x == 'septics') return true;
    if (x == 'septimes') return true;
    if (x == 'septs') return true;
    if (x == 'septuples') return true;
    if (x == 'septuplets') return true;
    if (x == 'sepulchers') return true;
    if (x == 'sepulchres') return true;
    if (x == 'sequels') return true;
    if (x == 'sequences') return true;
    if (x == 'sequencies') return true;
    if (x == 'sequents') return true;
    if (x == 'sequesters') return true;
    if (x == 'sequins') return true;
    if (x == 'sequiturs') return true;
    if (x == 'sequoias') return true;
    if (x == 'seracs') return true;
    if (x == 'seraglios') return true;
    if (x == 'serails') return true;
    if (x == 'serais') return true;
    if (x == 'serapes') return true;
    if (x == 'seraphims') return true;
    if (x == 'seraphs') return true;
    if (x == 'serdabs') return true;
    if (x == 'sereins') return true;
    if (x == 'serenades') return true;
    if (x == 'serenatas') return true;
    if (x == 'serendipitous') return true;
    if (x == 'serenes') return true;
    if (x == 'serenities') return true;
    if (x == 'seres') return true;
    if (x == 'serfages') return true;
    if (x == 'serfdoms') return true;
    if (x == 'serfhoods') return true;
    if (x == 'serfs') return true;
    if (x == 'sergeants') return true;
    if (x == 'serges') return true;
    if (x == 'sergings') return true;
    if (x == 'serials') return true;
    if (x == 'seriates') return true;
    if (x == 'sericins') return true;
    if (x == 'seriemas') return true;
    if (x == 'series') return true;
    if (x == 'serifs') return true;
    if (x == 'serines') return true;
    if (x == 'seringas') return true;
    if (x == 'serins') return true;
    if (x == 'serious') return true;
    if (x == 'seriousness') return true;
    if (x == 'seriousnesses') return true;
    if (x == 'serjeants') return true;
    if (x == 'sermons') return true;
    if (x == 'serologies') return true;
    if (x == 'serosas') return true;
    if (x == 'serosities') return true;
    if (x == 'serotines') return true;
    if (x == 'serotypes') return true;
    if (x == 'serous') return true;
    if (x == 'serows') return true;
    if (x == 'serpents') return true;
    if (x == 'serpigines') return true;
    if (x == 'serpigoes') return true;
    if (x == 'serranids') return true;
    if (x == 'serrates') return true;
    if (x == 'serries') return true;
    if (x == 'sers') return true;
    if (x == 'serums') return true;
    if (x == 'servals') return true;
    if (x == 'servants') return true;
    if (x == 'servers') return true;
    if (x == 'serves') return true;
    if (x == 'servicers') return true;
    if (x == 'services') return true;
    if (x == 'servilities') return true;
    if (x == 'servings') return true;
    if (x == 'servitors') return true;
    if (x == 'servitudes') return true;
    if (x == 'servos') return true;
    if (x == 'sesames') return true;
    if (x == 'sesamoids') return true;
    if (x == 'sesquicentennaries') return true;
    if (x == 'sesquicentennials') return true;
    if (x == 'sessions') return true;
    if (x == 'sesspools') return true;
    if (x == 'sesterces') return true;
    if (x == 'sestets') return true;
    if (x == 'sestinas') return true;
    if (x == 'sestines') return true;
    if (x == 'setbacks') return true;
    if (x == 'setlines') return true;
    if (x == 'setoffs') return true;
    if (x == 'setons') return true;
    if (x == 'setous') return true;
    if (x == 'setouts') return true;
    if (x == 'sets') return true;
    if (x == 'setscrews') return true;
    if (x == 'settees') return true;
    if (x == 'setters') return true;
    if (x == 'settings') return true;
    if (x == 'settlements') return true;
    if (x == 'settlers') return true;
    if (x == 'settles') return true;
    if (x == 'settlings') return true;
    if (x == 'settlors') return true;
    if (x == 'setulous') return true;
    if (x == 'setups') return true;
    if (x == 'sevens') return true;
    if (x == 'seventeens') return true;
    if (x == 'seventeenths') return true;
    if (x == 'sevenths') return true;
    if (x == 'seventies') return true;
    if (x == 'seventieths') return true;
    if (x == 'severals') return true;
    if (x == 'severances') return true;
    if (x == 'severities') return true;
    if (x == 'severs') return true;
    if (x == 'sewages') return true;
    if (x == 'sewans') return true;
    if (x == 'sewars') return true;
    if (x == 'sewerages') return true;
    if (x == 'sewers') return true;
    if (x == 'sewings') return true;
    if (x == 'sews') return true;
    if (x == 'sexes') return true;
    if (x == 'sexiness') return true;
    if (x == 'sexinesses') return true;
    if (x == 'sexisms') return true;
    if (x == 'sexists') return true;
    if (x == 'sexless') return true;
    if (x == 'sexologies') return true;
    if (x == 'sexpots') return true;
    if (x == 'sextains') return true;
    if (x == 'sextans') return true;
    if (x == 'sextants') return true;
    if (x == 'sextets') return true;
    if (x == 'sextettes') return true;
    if (x == 'sextiles') return true;
    if (x == 'sextons') return true;
    if (x == 'sextos') return true;
    if (x == 'sexts') return true;
    if (x == 'sextuples') return true;
    if (x == 'sextuplets') return true;
    if (x == 'sexualities') return true;
    return nil;
  }
  isGoodWordSF(x) {
    if (x == 'sferics') return true;
    if (x == 'sforzatos') return true;
    if (x == 'sfumatos') return true;
    if (x == 'shabbiness') return true;
    if (x == 'shabbinesses') return true;
    if (x == 'shacklers') return true;
    if (x == 'shackles') return true;
    if (x == 'shackoes') return true;
    if (x == 'shackos') return true;
    if (x == 'shacks') return true;
    if (x == 'shadblows') return true;
    if (x == 'shadbushes') return true;
    if (x == 'shadchans') return true;
    if (x == 'shaddocks') return true;
    if (x == 'shaders') return true;
    if (x == 'shades') return true;
    if (x == 'shadflies') return true;
    if (x == 'shadings') return true;
    if (x == 'shadoofs') return true;
    if (x == 'shadowers') return true;
    if (x == 'shadows') return true;
    if (x == 'shadrachs') return true;
    if (x == 'shads') return true;
    if (x == 'shadufs') return true;
    if (x == 'shaftings') return true;
    if (x == 'shafts') return true;
    if (x == 'shagbarks') return true;
    if (x == 'shagreens') return true;
    if (x == 'shags') return true;
    if (x == 'shahdoms') return true;
    if (x == 'shahs') return true;
    if (x == 'shairds') return true;
    if (x == 'shairns') return true;
    if (x == 'shaitans') return true;
    if (x == 'shakeouts') return true;
    if (x == 'shakers') return true;
    if (x == 'shakes') return true;
    if (x == 'shakeups') return true;
    if (x == 'shakiness') return true;
    if (x == 'shakinesses') return true;
    if (x == 'shakoes') return true;
    if (x == 'shakos') return true;
    if (x == 'shales') return true;
    if (x == 'shalloons') return true;
    if (x == 'shallops') return true;
    if (x == 'shallots') return true;
    if (x == 'shallows') return true;
    if (x == 'shamans') return true;
    if (x == 'shambles') return true;
    if (x == 'shameless') return true;
    if (x == 'shames') return true;
    if (x == 'shammas') return true;
    if (x == 'shammers') return true;
    if (x == 'shammes') return true;
    if (x == 'shammies') return true;
    if (x == 'shammos') return true;
    if (x == 'shamois') return true;
    if (x == 'shamoys') return true;
    if (x == 'shampoos') return true;
    if (x == 'shamrocks') return true;
    if (x == 'shams') return true;
    if (x == 'shamus') return true;
    if (x == 'shamuses') return true;
    if (x == 'shandies') return true;
    if (x == 'shanghais') return true;
    if (x == 'shanks') return true;
    if (x == 'shanteys') return true;
    if (x == 'shanties') return true;
    if (x == 'shantihs') return true;
    if (x == 'shantis') return true;
    if (x == 'shantungs') return true;
    if (x == 'shapeless') return true;
    if (x == 'shapers') return true;
    if (x == 'shapes') return true;
    if (x == 'shapeups') return true;
    if (x == 'shards') return true;
    if (x == 'sharecroppers') return true;
    if (x == 'sharecrops') return true;
    if (x == 'shareholders') return true;
    if (x == 'sharers') return true;
    if (x == 'shares') return true;
    if (x == 'sharifs') return true;
    if (x == 'sharkers') return true;
    if (x == 'sharks') return true;
    if (x == 'sharns') return true;
    if (x == 'sharpeners') return true;
    if (x == 'sharpens') return true;
    if (x == 'sharpers') return true;
    if (x == 'sharpies') return true;
    if (x == 'sharpness') return true;
    if (x == 'sharpnesses') return true;
    if (x == 'sharps') return true;
    if (x == 'sharpshooters') return true;
    if (x == 'sharpshootings') return true;
    if (x == 'shashliks') return true;
    if (x == 'shasliks') return true;
    if (x == 'shatters') return true;
    if (x == 'shaughs') return true;
    if (x == 'shauls') return true;
    if (x == 'shavers') return true;
    if (x == 'shaves') return true;
    if (x == 'shavies') return true;
    if (x == 'shavings') return true;
    if (x == 'shawls') return true;
    if (x == 'shawms') return true;
    if (x == 'shaws') return true;
    if (x == 'shays') return true;
    if (x == 'sheafs') return true;
    if (x == 'shealings') return true;
    if (x == 'sheals') return true;
    if (x == 'shearers') return true;
    if (x == 'shears') return true;
    if (x == 'sheas') return true;
    if (x == 'sheathers') return true;
    if (x == 'sheathes') return true;
    if (x == 'sheaths') return true;
    if (x == 'sheaves') return true;
    if (x == 'shebangs') return true;
    if (x == 'shebeans') return true;
    if (x == 'shebeens') return true;
    if (x == 'shedders') return true;
    if (x == 'sheds') return true;
    if (x == 'sheeneys') return true;
    if (x == 'sheenies') return true;
    if (x == 'sheens') return true;
    if (x == 'sheepdogs') return true;
    if (x == 'sheepskins') return true;
    if (x == 'sheers') return true;
    if (x == 'sheeters') return true;
    if (x == 'sheetings') return true;
    if (x == 'sheets') return true;
    if (x == 'sheeves') return true;
    if (x == 'sheikdoms') return true;
    if (x == 'sheikhdoms') return true;
    if (x == 'sheikhs') return true;
    if (x == 'sheiks') return true;
    if (x == 'sheitans') return true;
    if (x == 'shekels') return true;
    if (x == 'shelducks') return true;
    if (x == 'shelffuls') return true;
    if (x == 'shellackings') return true;
    if (x == 'shellacks') return true;
    if (x == 'shellacs') return true;
    if (x == 'shellers') return true;
    if (x == 'shellfishes') return true;
    if (x == 'shells') return true;
    if (x == 'shelters') return true;
    if (x == 'shelties') return true;
    if (x == 'shelvers') return true;
    if (x == 'shelves') return true;
    if (x == 'shelvings') return true;
    if (x == 'shenanigans') return true;
    if (x == 'shends') return true;
    if (x == 'sheols') return true;
    if (x == 'shepherdess') return true;
    if (x == 'shepherdesses') return true;
    if (x == 'shepherds') return true;
    if (x == 'sherberts') return true;
    if (x == 'sherbets') return true;
    if (x == 'sherds') return true;
    if (x == 'shereefs') return true;
    if (x == 'sheriffs') return true;
    if (x == 'sherifs') return true;
    if (x == 'sherlocks') return true;
    if (x == 'sheroots') return true;
    if (x == 'sherries') return true;
    if (x == 'sherris') return true;
    if (x == 'sherrises') return true;
    if (x == 'shes') return true;
    if (x == 'shetlands') return true;
    if (x == 'sheuchs') return true;
    if (x == 'sheughs') return true;
    if (x == 'shewers') return true;
    if (x == 'shews') return true;
    if (x == 'shibahs') return true;
    if (x == 'shicksas') return true;
    if (x == 'shielders') return true;
    if (x == 'shields') return true;
    if (x == 'shielings') return true;
    if (x == 'shiels') return true;
    if (x == 'shiers') return true;
    if (x == 'shies') return true;
    if (x == 'shifters') return true;
    if (x == 'shiftless') return true;
    if (x == 'shiftlessness') return true;
    if (x == 'shiftlessnesses') return true;
    if (x == 'shifts') return true;
    if (x == 'shigellas') return true;
    if (x == 'shikarees') return true;
    if (x == 'shikaris') return true;
    if (x == 'shikars') return true;
    if (x == 'shiksas') return true;
    if (x == 'shikses') return true;
    if (x == 'shillalas') return true;
    if (x == 'shillelaghs') return true;
    if (x == 'shillings') return true;
    if (x == 'shills') return true;
    if (x == 'shimmers') return true;
    if (x == 'shimmies') return true;
    if (x == 'shims') return true;
    if (x == 'shinbones') return true;
    if (x == 'shindies') return true;
    if (x == 'shindigs') return true;
    if (x == 'shindys') return true;
    if (x == 'shiners') return true;
    if (x == 'shines') return true;
    if (x == 'shinglers') return true;
    if (x == 'shingles') return true;
    if (x == 'shinleafs') return true;
    if (x == 'shinleaves') return true;
    if (x == 'shinneries') return true;
    if (x == 'shinneys') return true;
    if (x == 'shinnies') return true;
    if (x == 'shins') return true;
    if (x == 'shipboards') return true;
    if (x == 'shipbuilders') return true;
    if (x == 'shiplaps') return true;
    if (x == 'shiploads') return true;
    if (x == 'shipmates') return true;
    if (x == 'shipments') return true;
    if (x == 'shippens') return true;
    if (x == 'shippers') return true;
    if (x == 'shippings') return true;
    if (x == 'shippons') return true;
    if (x == 'ships') return true;
    if (x == 'shipsides') return true;
    if (x == 'shipways') return true;
    if (x == 'shipworms') return true;
    if (x == 'shipwrecks') return true;
    if (x == 'shipyards') return true;
    if (x == 'shires') return true;
    if (x == 'shirkers') return true;
    if (x == 'shirks') return true;
    if (x == 'shirrings') return true;
    if (x == 'shirrs') return true;
    if (x == 'shirtings') return true;
    if (x == 'shirtless') return true;
    if (x == 'shirts') return true;
    if (x == 'shists') return true;
    if (x == 'shits') return true;
    if (x == 'shittahs') return true;
    if (x == 'shittims') return true;
    if (x == 'shivahs') return true;
    if (x == 'shivarees') return true;
    if (x == 'shivas') return true;
    if (x == 'shiverers') return true;
    if (x == 'shivers') return true;
    if (x == 'shives') return true;
    if (x == 'shivs') return true;
    if (x == 'shlemiels') return true;
    if (x == 'shlocks') return true;
    if (x == 'shmoes') return true;
    if (x == 'shnaps') return true;
    if (x == 'shoals') return true;
    if (x == 'shoats') return true;
    if (x == 'shockers') return true;
    if (x == 'shocks') return true;
    if (x == 'shoddies') return true;
    if (x == 'shoddiness') return true;
    if (x == 'shoddinesses') return true;
    if (x == 'shoebills') return true;
    if (x == 'shoehorns') return true;
    if (x == 'shoelaces') return true;
    if (x == 'shoemakers') return true;
    if (x == 'shoepacks') return true;
    if (x == 'shoepacs') return true;
    if (x == 'shoers') return true;
    if (x == 'shoes') return true;
    if (x == 'shoetrees') return true;
    if (x == 'shofars') return true;
    if (x == 'shogs') return true;
    if (x == 'shoguns') return true;
    if (x == 'shojis') return true;
    if (x == 'shooflies') return true;
    if (x == 'shooks') return true;
    if (x == 'shools') return true;
    if (x == 'shoos') return true;
    if (x == 'shooters') return true;
    if (x == 'shootings') return true;
    if (x == 'shoots') return true;
    if (x == 'shopboys') return true;
    if (x == 'shopgirls') return true;
    if (x == 'shophars') return true;
    if (x == 'shopkeepers') return true;
    if (x == 'shoplifters') return true;
    if (x == 'shoplifts') return true;
    if (x == 'shoppers') return true;
    if (x == 'shoppes') return true;
    if (x == 'shoppings') return true;
    if (x == 'shops') return true;
    if (x == 'shoptalks') return true;
    if (x == 'shorans') return true;
    if (x == 'shorebirds') return true;
    if (x == 'shoreless') return true;
    if (x == 'shores') return true;
    if (x == 'shorings') return true;
    if (x == 'shorls') return true;
    if (x == 'shortages') return true;
    if (x == 'shortcakes') return true;
    if (x == 'shortchanges') return true;
    if (x == 'shortcomings') return true;
    if (x == 'shortcuts') return true;
    if (x == 'shortens') return true;
    if (x == 'shorthands') return true;
    if (x == 'shortias') return true;
    if (x == 'shorties') return true;
    if (x == 'shortness') return true;
    if (x == 'shortnesses') return true;
    if (x == 'shorts') return true;
    if (x == 'shotes') return true;
    if (x == 'shotguns') return true;
    if (x == 'shots') return true;
    if (x == 'shotts') return true;
    if (x == 'shoulders') return true;
    if (x == 'shouters') return true;
    if (x == 'shouts') return true;
    if (x == 'shovelers') return true;
    if (x == 'shovels') return true;
    if (x == 'shovers') return true;
    if (x == 'shoves') return true;
    if (x == 'showboats') return true;
    if (x == 'showcases') return true;
    if (x == 'showdowns') return true;
    if (x == 'showers') return true;
    if (x == 'showgirls') return true;
    if (x == 'showiness') return true;
    if (x == 'showinesses') return true;
    if (x == 'showings') return true;
    if (x == 'showoffs') return true;
    if (x == 'showrooms') return true;
    if (x == 'shows') return true;
    if (x == 'shredders') return true;
    if (x == 'shreds') return true;
    if (x == 'shrewdness') return true;
    if (x == 'shrewdnesses') return true;
    if (x == 'shrews') return true;
    if (x == 'shriekers') return true;
    if (x == 'shrieks') return true;
    if (x == 'shrieves') return true;
    if (x == 'shrifts') return true;
    if (x == 'shrikes') return true;
    if (x == 'shrills') return true;
    if (x == 'shrimpers') return true;
    if (x == 'shrimps') return true;
    if (x == 'shrines') return true;
    if (x == 'shrinkages') return true;
    if (x == 'shrinkers') return true;
    if (x == 'shrinks') return true;
    if (x == 'shris') return true;
    if (x == 'shrivels') return true;
    if (x == 'shrivers') return true;
    if (x == 'shrives') return true;
    if (x == 'shroffs') return true;
    if (x == 'shrouds') return true;
    if (x == 'shrubberies') return true;
    if (x == 'shrubs') return true;
    if (x == 'shrugs') return true;
    if (x == 'shticks') return true;
    if (x == 'shuckers') return true;
    if (x == 'shuckings') return true;
    if (x == 'shucks') return true;
    if (x == 'shudders') return true;
    if (x == 'shuffleboards') return true;
    if (x == 'shufflers') return true;
    if (x == 'shuffles') return true;
    if (x == 'shuls') return true;
    if (x == 'shunners') return true;
    if (x == 'shunpikes') return true;
    if (x == 'shuns') return true;
    if (x == 'shunters') return true;
    if (x == 'shunts') return true;
    if (x == 'shushes') return true;
    if (x == 'shutdowns') return true;
    if (x == 'shutes') return true;
    if (x == 'shuteyes') return true;
    if (x == 'shutoffs') return true;
    if (x == 'shutouts') return true;
    if (x == 'shuts') return true;
    if (x == 'shutters') return true;
    if (x == 'shuttlecocks') return true;
    if (x == 'shuttles') return true;
    if (x == 'shwanpans') return true;
    if (x == 'shyers') return true;
    if (x == 'shylocks') return true;
    if (x == 'shyness') return true;
    if (x == 'shynesses') return true;
    if (x == 'shysters') return true;
    return nil;
  }
  isGoodWordSI(x) {
    if (x == 'sials') return true;
    if (x == 'siamangs') return true;
    if (x == 'siameses') return true;
    if (x == 'sibbs') return true;
    if (x == 'sibilants') return true;
    if (x == 'sibilates') return true;
    if (x == 'siblings') return true;
    if (x == 'sibs') return true;
    if (x == 'sibyls') return true;
    if (x == 'sices') return true;
    if (x == 'sickbays') return true;
    if (x == 'sickbeds') return true;
    if (x == 'sickeners') return true;
    if (x == 'sickens') return true;
    if (x == 'sickles') return true;
    if (x == 'sicklies') return true;
    if (x == 'sickness') return true;
    if (x == 'sicknesses') return true;
    if (x == 'sickrooms') return true;
    if (x == 'sicks') return true;
    if (x == 'sics') return true;
    if (x == 'siddurs') return true;
    if (x == 'sidebands') return true;
    if (x == 'sideboards') return true;
    if (x == 'sideburns') return true;
    if (x == 'sidecars') return true;
    if (x == 'sidehills') return true;
    if (x == 'sidekicks') return true;
    if (x == 'sidelines') return true;
    if (x == 'siderites') return true;
    if (x == 'sides') return true;
    if (x == 'sideshows') return true;
    if (x == 'sideslips') return true;
    if (x == 'sidespins') return true;
    if (x == 'sidesteps') return true;
    if (x == 'sideswipes') return true;
    if (x == 'sidetracks') return true;
    if (x == 'sidewalks') return true;
    if (x == 'sidewalls') return true;
    if (x == 'sideways') return true;
    if (x == 'sidings') return true;
    if (x == 'sidlers') return true;
    if (x == 'sidles') return true;
    if (x == 'sieges') return true;
    if (x == 'siemens') return true;
    if (x == 'sienites') return true;
    if (x == 'siennas') return true;
    if (x == 'sierozems') return true;
    if (x == 'sierras') return true;
    if (x == 'siestas') return true;
    if (x == 'sieurs') return true;
    if (x == 'sieves') return true;
    if (x == 'siffleurs') return true;
    if (x == 'sifters') return true;
    if (x == 'siftings') return true;
    if (x == 'sifts') return true;
    if (x == 'siganids') return true;
    if (x == 'sighers') return true;
    if (x == 'sighless') return true;
    if (x == 'sighs') return true;
    if (x == 'sighters') return true;
    if (x == 'sightless') return true;
    if (x == 'sights') return true;
    if (x == 'sightseers') return true;
    if (x == 'sightsees') return true;
    if (x == 'sigils') return true;
    if (x == 'siglos') return true;
    if (x == 'sigmas') return true;
    if (x == 'sigmoids') return true;
    if (x == 'signalers') return true;
    if (x == 'signals') return true;
    if (x == 'signatories') return true;
    if (x == 'signatures') return true;
    if (x == 'signers') return true;
    if (x == 'signets') return true;
    if (x == 'signficances') return true;
    if (x == 'significances') return true;
    if (x == 'significations') return true;
    if (x == 'signifies') return true;
    if (x == 'signiories') return true;
    if (x == 'signiors') return true;
    if (x == 'signoras') return true;
    if (x == 'signories') return true;
    if (x == 'signors') return true;
    if (x == 'signposts') return true;
    if (x == 'signs') return true;
    if (x == 'sikes') return true;
    if (x == 'silages') return true;
    if (x == 'silanes') return true;
    if (x == 'silds') return true;
    if (x == 'silencers') return true;
    if (x == 'silences') return true;
    if (x == 'silents') return true;
    if (x == 'silenus') return true;
    if (x == 'silesias') return true;
    if (x == 'silexes') return true;
    if (x == 'silhouettes') return true;
    if (x == 'silicas') return true;
    if (x == 'silicates') return true;
    if (x == 'silicides') return true;
    if (x == 'silicifies') return true;
    if (x == 'siliciums') return true;
    if (x == 'silicles') return true;
    if (x == 'silicones') return true;
    if (x == 'silicons') return true;
    if (x == 'siliques') return true;
    if (x == 'silks') return true;
    if (x == 'silkweeds') return true;
    if (x == 'silkworms') return true;
    if (x == 'sillabubs') return true;
    if (x == 'sillers') return true;
    if (x == 'sillibibs') return true;
    if (x == 'sillies') return true;
    if (x == 'silliness') return true;
    if (x == 'sillinesses') return true;
    if (x == 'sills') return true;
    if (x == 'silos') return true;
    if (x == 'siloxanes') return true;
    if (x == 'silts') return true;
    if (x == 'silurids') return true;
    if (x == 'siluroids') return true;
    if (x == 'silvans') return true;
    if (x == 'silvas') return true;
    if (x == 'silverers') return true;
    if (x == 'silvers') return true;
    if (x == 'silverwares') return true;
    if (x == 'silvics') return true;
    if (x == 'simars') return true;
    if (x == 'simarubas') return true;
    if (x == 'simas') return true;
    if (x == 'simazines') return true;
    if (x == 'simians') return true;
    if (x == 'similarities') return true;
    if (x == 'similes') return true;
    if (x == 'similitudes') return true;
    if (x == 'simious') return true;
    if (x == 'simitars') return true;
    if (x == 'simlins') return true;
    if (x == 'simmers') return true;
    if (x == 'simnels') return true;
    if (x == 'simoleons') return true;
    if (x == 'simoniacs') return true;
    if (x == 'simonies') return true;
    if (x == 'simonises') return true;
    if (x == 'simonists') return true;
    if (x == 'simonizes') return true;
    if (x == 'simooms') return true;
    if (x == 'simoons') return true;
    if (x == 'simperers') return true;
    if (x == 'simpers') return true;
    if (x == 'simpleness') return true;
    if (x == 'simplenesses') return true;
    if (x == 'simples') return true;
    if (x == 'simpletons') return true;
    if (x == 'simplexes') return true;
    if (x == 'simplices') return true;
    if (x == 'simplicities') return true;
    if (x == 'simplifications') return true;
    if (x == 'simplifies') return true;
    if (x == 'simplisms') return true;
    if (x == 'simps') return true;
    if (x == 'sims') return true;
    if (x == 'simulants') return true;
    if (x == 'simulars') return true;
    if (x == 'simulates') return true;
    if (x == 'simulations') return true;
    if (x == 'simultaneous') return true;
    if (x == 'simultaneousness') return true;
    if (x == 'simultaneousnesses') return true;
    if (x == 'sinapisms') return true;
    if (x == 'sincerities') return true;
    if (x == 'sinciputs') return true;
    if (x == 'sinecures') return true;
    if (x == 'sines') return true;
    if (x == 'sinews') return true;
    if (x == 'singers') return true;
    if (x == 'singes') return true;
    if (x == 'singleness') return true;
    if (x == 'singlenesses') return true;
    if (x == 'singles') return true;
    if (x == 'singlets') return true;
    if (x == 'sings') return true;
    if (x == 'singsongs') return true;
    if (x == 'singularities') return true;
    if (x == 'singulars') return true;
    if (x == 'sinhs') return true;
    if (x == 'sinicises') return true;
    if (x == 'sinicizes') return true;
    if (x == 'sinkages') return true;
    if (x == 'sinkers') return true;
    if (x == 'sinkholes') return true;
    if (x == 'sinks') return true;
    if (x == 'sinless') return true;
    if (x == 'sinners') return true;
    if (x == 'sinologies') return true;
    if (x == 'sinopias') return true;
    if (x == 'sins') return true;
    if (x == 'sinters') return true;
    if (x == 'sinuates') return true;
    if (x == 'sinuous') return true;
    if (x == 'sinuousities') return true;
    if (x == 'sinus') return true;
    if (x == 'sinuses') return true;
    if (x == 'sinusoids') return true;
    if (x == 'sipes') return true;
    if (x == 'siphons') return true;
    if (x == 'sippers') return true;
    if (x == 'sippets') return true;
    if (x == 'sips') return true;
    if (x == 'sirdars') return true;
    if (x == 'sirees') return true;
    if (x == 'sirenians') return true;
    if (x == 'sirens') return true;
    if (x == 'sires') return true;
    if (x == 'sirloins') return true;
    if (x == 'siroccos') return true;
    if (x == 'sirrahs') return true;
    if (x == 'sirras') return true;
    if (x == 'sirrees') return true;
    if (x == 'sirs') return true;
    if (x == 'sirups') return true;
    if (x == 'sirventes') return true;
    if (x == 'sis') return true;
    if (x == 'sisals') return true;
    if (x == 'sises') return true;
    if (x == 'siskins') return true;
    if (x == 'sissies') return true;
    if (x == 'sisterhoods') return true;
    if (x == 'sisters') return true;
    if (x == 'sistrums') return true;
    if (x == 'sitarists') return true;
    if (x == 'sitars') return true;
    if (x == 'sites') return true;
    if (x == 'sithens') return true;
    if (x == 'sitologies') return true;
    if (x == 'sits') return true;
    if (x == 'sitters') return true;
    if (x == 'sittings') return true;
    if (x == 'situates') return true;
    if (x == 'situations') return true;
    if (x == 'situs') return true;
    if (x == 'situses') return true;
    if (x == 'sitzmarks') return true;
    if (x == 'sivers') return true;
    if (x == 'sixes') return true;
    if (x == 'sixmos') return true;
    if (x == 'sixpences') return true;
    if (x == 'sixteens') return true;
    if (x == 'sixteenths') return true;
    if (x == 'sixtes') return true;
    if (x == 'sixths') return true;
    if (x == 'sixties') return true;
    if (x == 'sixtieths') return true;
    if (x == 'sizars') return true;
    if (x == 'sizers') return true;
    if (x == 'sizes') return true;
    if (x == 'siziness') return true;
    if (x == 'sizinesses') return true;
    if (x == 'sizings') return true;
    if (x == 'sizzlers') return true;
    if (x == 'sizzles') return true;
    if (x == 'skags') return true;
    if (x == 'skalds') return true;
    if (x == 'skaters') return true;
    if (x == 'skates') return true;
    if (x == 'skatings') return true;
    if (x == 'skatoles') return true;
    if (x == 'skatols') return true;
    if (x == 'skats') return true;
    if (x == 'skeanes') return true;
    if (x == 'skeans') return true;
    if (x == 'skeens') return true;
    if (x == 'skees') return true;
    if (x == 'skeeters') return true;
    if (x == 'skeets') return true;
    if (x == 'skegs') return true;
    if (x == 'skeins') return true;
    if (x == 'skeletons') return true;
    if (x == 'skellums') return true;
    if (x == 'skelps') return true;
    if (x == 'skelters') return true;
    if (x == 'skenes') return true;
    if (x == 'skeps') return true;
    if (x == 'skepsis') return true;
    if (x == 'skepsises') return true;
    if (x == 'skepticisms') return true;
    if (x == 'skeptics') return true;
    if (x == 'skerries') return true;
    if (x == 'sketchers') return true;
    if (x == 'sketches') return true;
    if (x == 'skewbacks') return true;
    if (x == 'skewbalds') return true;
    if (x == 'skewers') return true;
    if (x == 'skewness') return true;
    if (x == 'skewnesses') return true;
    if (x == 'skews') return true;
    if (x == 'skiagrams') return true;
    if (x == 'skibobs') return true;
    if (x == 'skidders') return true;
    if (x == 'skiddoos') return true;
    if (x == 'skidoos') return true;
    if (x == 'skids') return true;
    if (x == 'skidways') return true;
    if (x == 'skiers') return true;
    if (x == 'skies') return true;
    if (x == 'skiffles') return true;
    if (x == 'skiffs') return true;
    if (x == 'skiings') return true;
    if (x == 'skiis') return true;
    if (x == 'skijorers') return true;
    if (x == 'skilless') return true;
    if (x == 'skillets') return true;
    if (x == 'skillfulness') return true;
    if (x == 'skillfulnesses') return true;
    if (x == 'skillings') return true;
    if (x == 'skills') return true;
    if (x == 'skimmers') return true;
    if (x == 'skimmings') return true;
    if (x == 'skimos') return true;
    if (x == 'skimps') return true;
    if (x == 'skims') return true;
    if (x == 'skinflints') return true;
    if (x == 'skinfuls') return true;
    if (x == 'skinheads') return true;
    if (x == 'skinkers') return true;
    if (x == 'skinks') return true;
    if (x == 'skinless') return true;
    if (x == 'skinners') return true;
    if (x == 'skins') return true;
    if (x == 'skiorings') return true;
    if (x == 'skipjacks') return true;
    if (x == 'skiplanes') return true;
    if (x == 'skippers') return true;
    if (x == 'skippets') return true;
    if (x == 'skips') return true;
    if (x == 'skirls') return true;
    if (x == 'skirmishes') return true;
    if (x == 'skirrets') return true;
    if (x == 'skirrs') return true;
    if (x == 'skirters') return true;
    if (x == 'skirtings') return true;
    if (x == 'skirts') return true;
    if (x == 'skis') return true;
    if (x == 'skites') return true;
    if (x == 'skits') return true;
    if (x == 'skitters') return true;
    if (x == 'skittles') return true;
    if (x == 'skivers') return true;
    if (x == 'skives') return true;
    if (x == 'skivvies') return true;
    if (x == 'skiwears') return true;
    if (x == 'sklents') return true;
    if (x == 'skoals') return true;
    if (x == 'skreeghs') return true;
    if (x == 'skreighs') return true;
    if (x == 'skuas') return true;
    if (x == 'skulkers') return true;
    if (x == 'skulks') return true;
    if (x == 'skullcaps') return true;
    if (x == 'skulls') return true;
    if (x == 'skunks') return true;
    if (x == 'skycaps') return true;
    if (x == 'skydivers') return true;
    if (x == 'skydives') return true;
    if (x == 'skyhooks') return true;
    if (x == 'skyjacks') return true;
    if (x == 'skylarks') return true;
    if (x == 'skylights') return true;
    if (x == 'skylines') return true;
    if (x == 'skyphos') return true;
    if (x == 'skyrockets') return true;
    if (x == 'skysails') return true;
    if (x == 'skyscrapers') return true;
    if (x == 'skywards') return true;
    if (x == 'skyways') return true;
    if (x == 'skywrites') return true;
    return nil;
  }
  isGoodWordSL(x) {
    if (x == 'slabbers') return true;
    if (x == 'slabs') return true;
    if (x == 'slackens') return true;
    if (x == 'slackers') return true;
    if (x == 'slackness') return true;
    if (x == 'slacknesses') return true;
    if (x == 'slacks') return true;
    if (x == 'slags') return true;
    if (x == 'slakers') return true;
    if (x == 'slakes') return true;
    if (x == 'slaloms') return true;
    if (x == 'slams') return true;
    if (x == 'slanderers') return true;
    if (x == 'slanderous') return true;
    if (x == 'slanders') return true;
    if (x == 'slangs') return true;
    if (x == 'slants') return true;
    if (x == 'slapdashes') return true;
    if (x == 'slapjacks') return true;
    if (x == 'slappers') return true;
    if (x == 'slaps') return true;
    if (x == 'slashers') return true;
    if (x == 'slashes') return true;
    if (x == 'slashings') return true;
    if (x == 'slatches') return true;
    if (x == 'slaters') return true;
    if (x == 'slates') return true;
    if (x == 'slathers') return true;
    if (x == 'slatings') return true;
    if (x == 'slats') return true;
    if (x == 'slatterns') return true;
    if (x == 'slaughterhouses') return true;
    if (x == 'slaughters') return true;
    if (x == 'slaverers') return true;
    if (x == 'slaveries') return true;
    if (x == 'slavers') return true;
    if (x == 'slaves') return true;
    if (x == 'slaveys') return true;
    if (x == 'slaws') return true;
    if (x == 'slayers') return true;
    if (x == 'slays') return true;
    if (x == 'sleaves') return true;
    if (x == 'sledders') return true;
    if (x == 'sleddings') return true;
    if (x == 'sledgehammers') return true;
    if (x == 'sledges') return true;
    if (x == 'sleds') return true;
    if (x == 'sleekens') return true;
    if (x == 'sleeks') return true;
    if (x == 'sleepers') return true;
    if (x == 'sleepiness') return true;
    if (x == 'sleepings') return true;
    if (x == 'sleepless') return true;
    if (x == 'sleeplessness') return true;
    if (x == 'sleeps') return true;
    if (x == 'sleepwalkers') return true;
    if (x == 'sleepwalks') return true;
    if (x == 'sleets') return true;
    if (x == 'sleeveless') return true;
    if (x == 'sleeves') return true;
    if (x == 'sleighers') return true;
    if (x == 'sleighs') return true;
    if (x == 'sleights') return true;
    if (x == 'sleuths') return true;
    if (x == 'slews') return true;
    if (x == 'slicers') return true;
    if (x == 'slices') return true;
    if (x == 'slickers') return true;
    if (x == 'slicks') return true;
    if (x == 'sliders') return true;
    if (x == 'slides') return true;
    if (x == 'slideways') return true;
    if (x == 'slights') return true;
    if (x == 'slimes') return true;
    if (x == 'slimness') return true;
    if (x == 'slimnesses') return true;
    if (x == 'slims') return true;
    if (x == 'slingers') return true;
    if (x == 'slings') return true;
    if (x == 'slingshots') return true;
    if (x == 'slinks') return true;
    if (x == 'slipcases') return true;
    if (x == 'slipes') return true;
    if (x == 'slipforms') return true;
    if (x == 'slipknots') return true;
    if (x == 'slipless') return true;
    if (x == 'slipouts') return true;
    if (x == 'slipovers') return true;
    if (x == 'slippages') return true;
    if (x == 'slipperiness') return true;
    if (x == 'slipperinesses') return true;
    if (x == 'slippers') return true;
    if (x == 'slips') return true;
    if (x == 'slipslops') return true;
    if (x == 'slipsoles') return true;
    if (x == 'slipups') return true;
    if (x == 'slipwares') return true;
    if (x == 'slipways') return true;
    if (x == 'slithers') return true;
    if (x == 'slitless') return true;
    if (x == 'slits') return true;
    if (x == 'slitters') return true;
    if (x == 'sliverers') return true;
    if (x == 'slivers') return true;
    if (x == 'slivovics') return true;
    if (x == 'slobbers') return true;
    if (x == 'slobs') return true;
    if (x == 'sloes') return true;
    if (x == 'slogans') return true;
    if (x == 'sloggers') return true;
    if (x == 'slogs') return true;
    if (x == 'sloids') return true;
    if (x == 'slojds') return true;
    if (x == 'sloops') return true;
    if (x == 'slopers') return true;
    if (x == 'slopes') return true;
    if (x == 'slops') return true;
    if (x == 'slopworks') return true;
    if (x == 'sloshes') return true;
    if (x == 'slotbacks') return true;
    if (x == 'sloths') return true;
    if (x == 'slots') return true;
    if (x == 'slouchers') return true;
    if (x == 'slouches') return true;
    if (x == 'sloughs') return true;
    if (x == 'slovens') return true;
    if (x == 'slowdowns') return true;
    if (x == 'slowness') return true;
    if (x == 'slownesses') return true;
    if (x == 'slowpokes') return true;
    if (x == 'slows') return true;
    if (x == 'slowworms') return true;
    if (x == 'sloyds') return true;
    if (x == 'slubbers') return true;
    if (x == 'slubbings') return true;
    if (x == 'slubs') return true;
    if (x == 'sludges') return true;
    if (x == 'slues') return true;
    if (x == 'sluffs') return true;
    if (x == 'slugabeds') return true;
    if (x == 'slugfests') return true;
    if (x == 'sluggards') return true;
    if (x == 'sluggers') return true;
    if (x == 'sluggishness') return true;
    if (x == 'sluggishnesses') return true;
    if (x == 'slugs') return true;
    if (x == 'sluices') return true;
    if (x == 'slumbers') return true;
    if (x == 'slumgums') return true;
    if (x == 'slumlords') return true;
    if (x == 'slummers') return true;
    if (x == 'slumps') return true;
    if (x == 'slums') return true;
    if (x == 'slurbs') return true;
    if (x == 'slurps') return true;
    if (x == 'slurries') return true;
    if (x == 'slurs') return true;
    if (x == 'slushes') return true;
    if (x == 'sluts') return true;
    if (x == 'slyboots') return true;
    if (x == 'slyness') return true;
    if (x == 'slynesses') return true;
    if (x == 'slypes') return true;
    if (x == 'smackers') return true;
    if (x == 'smacks') return true;
    if (x == 'smallages') return true;
    if (x == 'smallness') return true;
    if (x == 'smallnesses') return true;
    if (x == 'smallpoxes') return true;
    if (x == 'smalls') return true;
    if (x == 'smaltines') return true;
    if (x == 'smaltites') return true;
    if (x == 'smaltos') return true;
    if (x == 'smalts') return true;
    if (x == 'smaragdes') return true;
    if (x == 'smaragds') return true;
    if (x == 'smarms') return true;
    if (x == 'smartens') return true;
    if (x == 'smarties') return true;
    if (x == 'smartness') return true;
    if (x == 'smartnesses') return true;
    if (x == 'smarts') return true;
    if (x == 'smashers') return true;
    if (x == 'smashes') return true;
    if (x == 'smashups') return true;
    if (x == 'smatterings') return true;
    if (x == 'smatters') return true;
    if (x == 'smazes') return true;
    if (x == 'smearers') return true;
    if (x == 'smears') return true;
    if (x == 'smeddums') return true;
    if (x == 'smeeks') return true;
    if (x == 'smegmas') return true;
    if (x == 'smellers') return true;
    if (x == 'smells') return true;
    if (x == 'smelteries') return true;
    if (x == 'smelters') return true;
    if (x == 'smelts') return true;
    if (x == 'smerks') return true;
    if (x == 'smews') return true;
    if (x == 'smidgens') return true;
    if (x == 'smidgeons') return true;
    if (x == 'smidgins') return true;
    if (x == 'smilaxes') return true;
    if (x == 'smilers') return true;
    if (x == 'smiles') return true;
    if (x == 'smirches') return true;
    if (x == 'smirkers') return true;
    if (x == 'smirks') return true;
    if (x == 'smiters') return true;
    if (x == 'smites') return true;
    if (x == 'smitheries') return true;
    if (x == 'smithies') return true;
    if (x == 'smiths') return true;
    if (x == 'smockings') return true;
    if (x == 'smocks') return true;
    if (x == 'smogless') return true;
    if (x == 'smogs') return true;
    if (x == 'smokeless') return true;
    if (x == 'smokepots') return true;
    if (x == 'smokers') return true;
    if (x == 'smokes') return true;
    if (x == 'smokestacks') return true;
    if (x == 'smolders') return true;
    if (x == 'smolts') return true;
    if (x == 'smooches') return true;
    if (x == 'smoothens') return true;
    if (x == 'smoothers') return true;
    if (x == 'smoothies') return true;
    if (x == 'smoothness') return true;
    if (x == 'smoothnesses') return true;
    if (x == 'smooths') return true;
    if (x == 'smorgasbords') return true;
    if (x == 'smothers') return true;
    if (x == 'smoulders') return true;
    if (x == 'smudges') return true;
    if (x == 'smugglers') return true;
    if (x == 'smuggles') return true;
    if (x == 'smugness') return true;
    if (x == 'smugnesses') return true;
    if (x == 'smutches') return true;
    if (x == 'smuts') return true;
    if (x == 'snacks') return true;
    if (x == 'snaffles') return true;
    if (x == 'snafus') return true;
    if (x == 'snags') return true;
    if (x == 'snails') return true;
    if (x == 'snakes') return true;
    if (x == 'snapbacks') return true;
    if (x == 'snapdragons') return true;
    if (x == 'snapless') return true;
    if (x == 'snappers') return true;
    if (x == 'snaps') return true;
    if (x == 'snapshots') return true;
    if (x == 'snapweeds') return true;
    if (x == 'snarers') return true;
    if (x == 'snares') return true;
    if (x == 'snarks') return true;
    if (x == 'snarlers') return true;
    if (x == 'snarls') return true;
    if (x == 'snashes') return true;
    if (x == 'snatchers') return true;
    if (x == 'snatches') return true;
    if (x == 'snathes') return true;
    if (x == 'snaths') return true;
    if (x == 'snaws') return true;
    if (x == 'sneakers') return true;
    if (x == 'sneaks') return true;
    if (x == 'sneaps') return true;
    if (x == 'snecks') return true;
    if (x == 'sneds') return true;
    if (x == 'sneerers') return true;
    if (x == 'sneers') return true;
    if (x == 'sneeshes') return true;
    if (x == 'sneezers') return true;
    if (x == 'sneezes') return true;
    if (x == 'snells') return true;
    if (x == 'snibs') return true;
    if (x == 'snickers') return true;
    if (x == 'snicks') return true;
    if (x == 'sniffers') return true;
    if (x == 'snifflers') return true;
    if (x == 'sniffles') return true;
    if (x == 'sniffs') return true;
    if (x == 'snifters') return true;
    if (x == 'sniggers') return true;
    if (x == 'snigglers') return true;
    if (x == 'sniggles') return true;
    if (x == 'snipers') return true;
    if (x == 'snipes') return true;
    if (x == 'snippers') return true;
    if (x == 'snippets') return true;
    if (x == 'snips') return true;
    if (x == 'snitchers') return true;
    if (x == 'snitches') return true;
    if (x == 'snits') return true;
    if (x == 'snivelers') return true;
    if (x == 'snivels') return true;
    if (x == 'snobberies') return true;
    if (x == 'snobbishness') return true;
    if (x == 'snobbishnesses') return true;
    if (x == 'snobbisms') return true;
    if (x == 'snobs') return true;
    if (x == 'snoods') return true;
    if (x == 'snookers') return true;
    if (x == 'snooks') return true;
    if (x == 'snools') return true;
    if (x == 'snoopers') return true;
    if (x == 'snoops') return true;
    if (x == 'snoots') return true;
    if (x == 'snoozers') return true;
    if (x == 'snoozes') return true;
    if (x == 'snoozles') return true;
    if (x == 'snorers') return true;
    if (x == 'snores') return true;
    if (x == 'snorkels') return true;
    if (x == 'snorters') return true;
    if (x == 'snorts') return true;
    if (x == 'snots') return true;
    if (x == 'snouts') return true;
    if (x == 'snowballs') return true;
    if (x == 'snowbanks') return true;
    if (x == 'snowbells') return true;
    if (x == 'snowbirds') return true;
    if (x == 'snowbushes') return true;
    if (x == 'snowcaps') return true;
    if (x == 'snowdrifts') return true;
    if (x == 'snowdrops') return true;
    if (x == 'snowfalls') return true;
    if (x == 'snowflakes') return true;
    if (x == 'snowlands') return true;
    if (x == 'snowless') return true;
    if (x == 'snowmelts') return true;
    if (x == 'snowpacks') return true;
    if (x == 'snowplows') return true;
    if (x == 'snows') return true;
    if (x == 'snowsheds') return true;
    if (x == 'snowshoes') return true;
    if (x == 'snowstorms') return true;
    if (x == 'snowsuits') return true;
    if (x == 'snubbers') return true;
    if (x == 'snubness') return true;
    if (x == 'snubnesses') return true;
    if (x == 'snubs') return true;
    if (x == 'snuffboxes') return true;
    if (x == 'snuffers') return true;
    if (x == 'snufflers') return true;
    if (x == 'snuffles') return true;
    if (x == 'snuffs') return true;
    if (x == 'snuggeries') return true;
    if (x == 'snuggles') return true;
    if (x == 'snugness') return true;
    if (x == 'snugnesses') return true;
    if (x == 'snugs') return true;
    if (x == 'snyes') return true;
    return nil;
  }
  isGoodWordSO(x) {
    if (x == 'soakages') return true;
    if (x == 'soakers') return true;
    if (x == 'soaks') return true;
    if (x == 'soapbarks') return true;
    if (x == 'soapboxes') return true;
    if (x == 'soapless') return true;
    if (x == 'soaps') return true;
    if (x == 'soapsuds') return true;
    if (x == 'soapworts') return true;
    if (x == 'soarers') return true;
    if (x == 'soarings') return true;
    if (x == 'soars') return true;
    if (x == 'soaves') return true;
    if (x == 'sobbers') return true;
    if (x == 'soberises') return true;
    if (x == 'soberizes') return true;
    if (x == 'sobers') return true;
    if (x == 'sobrieties') return true;
    if (x == 'sobs') return true;
    if (x == 'socagers') return true;
    if (x == 'socages') return true;
    if (x == 'soccages') return true;
    if (x == 'soccers') return true;
    if (x == 'sociabilities') return true;
    if (x == 'sociables') return true;
    if (x == 'socialisations') return true;
    if (x == 'socialises') return true;
    if (x == 'socialists') return true;
    if (x == 'socializations') return true;
    if (x == 'socializes') return true;
    if (x == 'socials') return true;
    if (x == 'societies') return true;
    if (x == 'sociologies') return true;
    if (x == 'sociologists') return true;
    if (x == 'sockets') return true;
    if (x == 'sockeyes') return true;
    if (x == 'socks') return true;
    if (x == 'socles') return true;
    if (x == 'sodaless') return true;
    if (x == 'sodalists') return true;
    if (x == 'sodalites') return true;
    if (x == 'sodalities') return true;
    if (x == 'sodamides') return true;
    if (x == 'sodas') return true;
    if (x == 'soddens') return true;
    if (x == 'soddies') return true;
    if (x == 'sodiums') return true;
    if (x == 'sodomies') return true;
    if (x == 'sodomites') return true;
    if (x == 'sods') return true;
    if (x == 'sofars') return true;
    if (x == 'sofas') return true;
    if (x == 'soffits') return true;
    if (x == 'softas') return true;
    if (x == 'softbacks') return true;
    if (x == 'softballs') return true;
    if (x == 'softeners') return true;
    if (x == 'softens') return true;
    if (x == 'softheads') return true;
    if (x == 'softies') return true;
    if (x == 'softness') return true;
    if (x == 'softnesses') return true;
    if (x == 'softs') return true;
    if (x == 'softwares') return true;
    if (x == 'softwoods') return true;
    if (x == 'sogginess') return true;
    if (x == 'sogginesses') return true;
    if (x == 'soilages') return true;
    if (x == 'soilless') return true;
    if (x == 'soils') return true;
    if (x == 'soilures') return true;
    if (x == 'soirees') return true;
    if (x == 'sojas') return true;
    if (x == 'sojourns') return true;
    if (x == 'sokes') return true;
    if (x == 'solacers') return true;
    if (x == 'solaces') return true;
    if (x == 'solanders') return true;
    if (x == 'solands') return true;
    if (x == 'solanines') return true;
    if (x == 'solanins') return true;
    if (x == 'solanos') return true;
    if (x == 'solans') return true;
    if (x == 'solanums') return true;
    if (x == 'solarises') return true;
    if (x == 'solarisms') return true;
    if (x == 'solariums') return true;
    if (x == 'solarizes') return true;
    if (x == 'solates') return true;
    if (x == 'solations') return true;
    if (x == 'soldans') return true;
    if (x == 'solderers') return true;
    if (x == 'solders') return true;
    if (x == 'soldieries') return true;
    if (x == 'soldiers') return true;
    if (x == 'solecises') return true;
    if (x == 'solecisms') return true;
    if (x == 'solecists') return true;
    if (x == 'solecizes') return true;
    if (x == 'soleless') return true;
    if (x == 'solemnness') return true;
    if (x == 'solemnnesses') return true;
    if (x == 'soleness') return true;
    if (x == 'solenesses') return true;
    if (x == 'solenoids') return true;
    if (x == 'solerets') return true;
    if (x == 'soles') return true;
    if (x == 'solfeges') return true;
    if (x == 'solicitors') return true;
    if (x == 'solicitous') return true;
    if (x == 'solicits') return true;
    if (x == 'solicitudes') return true;
    if (x == 'solidagos') return true;
    if (x == 'solidarities') return true;
    if (x == 'solidifications') return true;
    if (x == 'solidifies') return true;
    if (x == 'solidities') return true;
    if (x == 'solidness') return true;
    if (x == 'solidnesses') return true;
    if (x == 'solids') return true;
    if (x == 'solidus') return true;
    if (x == 'soliloquises') return true;
    if (x == 'soliloquizes') return true;
    if (x == 'soliloquys') return true;
    if (x == 'solions') return true;
    if (x == 'soliquids') return true;
    if (x == 'solitaires') return true;
    if (x == 'solitaries') return true;
    if (x == 'solitudes') return true;
    if (x == 'sollerets') return true;
    if (x == 'soloists') return true;
    if (x == 'solonets') return true;
    if (x == 'solonetses') return true;
    if (x == 'solonetzes') return true;
    if (x == 'solons') return true;
    if (x == 'solos') return true;
    if (x == 'sols') return true;
    if (x == 'solstices') return true;
    if (x == 'solubilities') return true;
    if (x == 'solubles') return true;
    if (x == 'solums') return true;
    if (x == 'solus') return true;
    if (x == 'solutes') return true;
    if (x == 'solutions') return true;
    if (x == 'solvates') return true;
    if (x == 'solvencies') return true;
    if (x == 'solvents') return true;
    if (x == 'solvers') return true;
    if (x == 'solves') return true;
    if (x == 'somas') return true;
    if (x == 'sombreros') return true;
    if (x == 'sombrous') return true;
    if (x == 'somebodies') return true;
    if (x == 'someones') return true;
    if (x == 'somersaults') return true;
    if (x == 'somersets') return true;
    if (x == 'sometimes') return true;
    if (x == 'someways') return true;
    if (x == 'somewhats') return true;
    if (x == 'somites') return true;
    if (x == 'somnambulists') return true;
    if (x == 'somnolences') return true;
    if (x == 'sonances') return true;
    if (x == 'sonants') return true;
    if (x == 'sonars') return true;
    if (x == 'sonatas') return true;
    if (x == 'sonatinas') return true;
    if (x == 'sonders') return true;
    if (x == 'sondes') return true;
    if (x == 'sones') return true;
    if (x == 'songbirds') return true;
    if (x == 'songbooks') return true;
    if (x == 'songfests') return true;
    if (x == 'songless') return true;
    if (x == 'songs') return true;
    if (x == 'songsters') return true;
    if (x == 'sonicates') return true;
    if (x == 'sonics') return true;
    if (x == 'sonless') return true;
    if (x == 'sonnets') return true;
    if (x == 'sonnies') return true;
    if (x == 'sonorants') return true;
    if (x == 'sonorities') return true;
    if (x == 'sonorous') return true;
    if (x == 'sonovoxes') return true;
    if (x == 'sons') return true;
    if (x == 'sonships') return true;
    if (x == 'soochongs') return true;
    if (x == 'sooners') return true;
    if (x == 'soothers') return true;
    if (x == 'soothes') return true;
    if (x == 'sooths') return true;
    if (x == 'soothsayers') return true;
    if (x == 'soothsayings') return true;
    if (x == 'soothsays') return true;
    if (x == 'soots') return true;
    if (x == 'sophies') return true;
    if (x == 'sophisms') return true;
    if (x == 'sophisticates') return true;
    if (x == 'sophistications') return true;
    if (x == 'sophistries') return true;
    if (x == 'sophists') return true;
    if (x == 'sophomores') return true;
    if (x == 'sophs') return true;
    if (x == 'sopites') return true;
    if (x == 'sopors') return true;
    if (x == 'sopranos') return true;
    if (x == 'sops') return true;
    if (x == 'soras') return true;
    if (x == 'sorbates') return true;
    if (x == 'sorbents') return true;
    if (x == 'sorbets') return true;
    if (x == 'sorbitols') return true;
    if (x == 'sorboses') return true;
    if (x == 'sorbs') return true;
    if (x == 'sorcerers') return true;
    if (x == 'sorceress') return true;
    if (x == 'sorceresses') return true;
    if (x == 'sorceries') return true;
    if (x == 'sordidness') return true;
    if (x == 'sordidnesses') return true;
    if (x == 'sordines') return true;
    if (x == 'sords') return true;
    if (x == 'soreheads') return true;
    if (x == 'sorels') return true;
    if (x == 'soreness') return true;
    if (x == 'sorenesses') return true;
    if (x == 'sores') return true;
    if (x == 'sorghos') return true;
    if (x == 'sorghums') return true;
    if (x == 'sorgos') return true;
    if (x == 'sorites') return true;
    if (x == 'sorners') return true;
    if (x == 'sorns') return true;
    if (x == 'soroches') return true;
    if (x == 'sororates') return true;
    if (x == 'sororities') return true;
    if (x == 'soroses') return true;
    if (x == 'sorosis') return true;
    if (x == 'sorosises') return true;
    if (x == 'sorptions') return true;
    if (x == 'sorrels') return true;
    if (x == 'sorrowers') return true;
    if (x == 'sorrows') return true;
    if (x == 'sorters') return true;
    if (x == 'sorties') return true;
    if (x == 'sorts') return true;
    if (x == 'sorus') return true;
    if (x == 'sos') return true;
    if (x == 'soths') return true;
    if (x == 'sotols') return true;
    if (x == 'sots') return true;
    if (x == 'souaris') return true;
    if (x == 'soubises') return true;
    if (x == 'soucars') return true;
    if (x == 'souchongs') return true;
    if (x == 'soudans') return true;
    if (x == 'souffles') return true;
    if (x == 'soughs') return true;
    if (x == 'soulless') return true;
    if (x == 'souls') return true;
    if (x == 'soundboxes') return true;
    if (x == 'sounders') return true;
    if (x == 'soundings') return true;
    if (x == 'soundness') return true;
    if (x == 'soundnesses') return true;
    if (x == 'soundproofs') return true;
    if (x == 'sounds') return true;
    if (x == 'soupcons') return true;
    if (x == 'soups') return true;
    if (x == 'sourballs') return true;
    if (x == 'sources') return true;
    if (x == 'sourdines') return true;
    if (x == 'sourness') return true;
    if (x == 'sournesses') return true;
    if (x == 'sourpuss') return true;
    if (x == 'sourpusses') return true;
    if (x == 'sours') return true;
    if (x == 'soursops') return true;
    if (x == 'sourwoods') return true;
    if (x == 'sous') return true;
    if (x == 'souses') return true;
    if (x == 'soutaches') return true;
    if (x == 'soutanes') return true;
    if (x == 'souters') return true;
    if (x == 'southeasts') return true;
    if (x == 'southerns') return true;
    if (x == 'southernwards') return true;
    if (x == 'southers') return true;
    if (x == 'southings') return true;
    if (x == 'southpaws') return true;
    if (x == 'southrons') return true;
    if (x == 'souths') return true;
    if (x == 'southwests') return true;
    if (x == 'souvenirs') return true;
    if (x == 'sovereigns') return true;
    if (x == 'sovereignties') return true;
    if (x == 'soviets') return true;
    if (x == 'sovkhozes') return true;
    if (x == 'sovrans') return true;
    if (x == 'sovranties') return true;
    if (x == 'sowans') return true;
    if (x == 'sowars') return true;
    if (x == 'sowbellies') return true;
    if (x == 'sowbreads') return true;
    if (x == 'sowcars') return true;
    if (x == 'sowens') return true;
    if (x == 'sowers') return true;
    if (x == 'sows') return true;
    if (x == 'soyas') return true;
    if (x == 'soybeans') return true;
    if (x == 'soys') return true;
    if (x == 'sozines') return true;
    if (x == 'sozins') return true;
    return nil;
  }
  isGoodWordSP(x) {
    if (x == 'spacecrafts') return true;
    if (x == 'spaceflights') return true;
    if (x == 'spacers') return true;
    if (x == 'spaces') return true;
    if (x == 'spaceships') return true;
    if (x == 'spacings') return true;
    if (x == 'spacious') return true;
    if (x == 'spaciousness') return true;
    if (x == 'spaciousnesses') return true;
    if (x == 'spadefuls') return true;
    if (x == 'spaders') return true;
    if (x == 'spades') return true;
    if (x == 'spadices') return true;
    if (x == 'spadilles') return true;
    if (x == 'spadones') return true;
    if (x == 'spaeings') return true;
    if (x == 'spaes') return true;
    if (x == 'spaghettis') return true;
    if (x == 'spagyrics') return true;
    if (x == 'spahees') return true;
    if (x == 'spahis') return true;
    if (x == 'spails') return true;
    if (x == 'spaits') return true;
    if (x == 'spales') return true;
    if (x == 'spallers') return true;
    if (x == 'spalls') return true;
    if (x == 'spalpeens') return true;
    if (x == 'spancels') return true;
    if (x == 'spandrels') return true;
    if (x == 'spandrils') return true;
    if (x == 'spangles') return true;
    if (x == 'spaniels') return true;
    if (x == 'spankers') return true;
    if (x == 'spankings') return true;
    if (x == 'spanks') return true;
    if (x == 'spanless') return true;
    if (x == 'spanners') return true;
    if (x == 'spans') return true;
    if (x == 'spanworms') return true;
    if (x == 'sparables') return true;
    if (x == 'spareribs') return true;
    if (x == 'sparers') return true;
    if (x == 'spares') return true;
    if (x == 'spargers') return true;
    if (x == 'sparges') return true;
    if (x == 'sparids') return true;
    if (x == 'sparkers') return true;
    if (x == 'sparklers') return true;
    if (x == 'sparkles') return true;
    if (x == 'sparks') return true;
    if (x == 'sparlings') return true;
    if (x == 'sparoids') return true;
    if (x == 'sparrows') return true;
    if (x == 'spars') return true;
    if (x == 'sparsities') return true;
    if (x == 'spas') return true;
    if (x == 'spasms') return true;
    if (x == 'spastics') return true;
    if (x == 'spates') return true;
    if (x == 'spathes') return true;
    if (x == 'spats') return true;
    if (x == 'spatters') return true;
    if (x == 'spatulas') return true;
    if (x == 'spavies') return true;
    if (x == 'spavins') return true;
    if (x == 'spawners') return true;
    if (x == 'spawns') return true;
    if (x == 'spays') return true;
    if (x == 'speakers') return true;
    if (x == 'speakings') return true;
    if (x == 'speaks') return true;
    if (x == 'speans') return true;
    if (x == 'spearers') return true;
    if (x == 'spearheads') return true;
    if (x == 'spears') return true;
    if (x == 'specialisations') return true;
    if (x == 'specialises') return true;
    if (x == 'specialists') return true;
    if (x == 'specializations') return true;
    if (x == 'specializes') return true;
    if (x == 'specials') return true;
    if (x == 'specialties') return true;
    if (x == 'speciates') return true;
    if (x == 'species') return true;
    if (x == 'specifications') return true;
    if (x == 'specificities') return true;
    if (x == 'specifics') return true;
    if (x == 'specifies') return true;
    if (x == 'specimens') return true;
    if (x == 'specious') return true;
    if (x == 'speckles') return true;
    if (x == 'specks') return true;
    if (x == 'specs') return true;
    if (x == 'spectacles') return true;
    if (x == 'spectates') return true;
    if (x == 'spectators') return true;
    if (x == 'specters') return true;
    if (x == 'spectres') return true;
    if (x == 'spectrums') return true;
    if (x == 'speculates') return true;
    if (x == 'speculations') return true;
    if (x == 'speculators') return true;
    if (x == 'speculums') return true;
    if (x == 'speeches') return true;
    if (x == 'speechless') return true;
    if (x == 'speedboats') return true;
    if (x == 'speeders') return true;
    if (x == 'speedings') return true;
    if (x == 'speedometers') return true;
    if (x == 'speeds') return true;
    if (x == 'speedups') return true;
    if (x == 'speedways') return true;
    if (x == 'speels') return true;
    if (x == 'speerings') return true;
    if (x == 'speers') return true;
    if (x == 'speils') return true;
    if (x == 'speirs') return true;
    if (x == 'speises') return true;
    if (x == 'speiss') return true;
    if (x == 'speisses') return true;
    if (x == 'spellers') return true;
    if (x == 'spellings') return true;
    if (x == 'spells') return true;
    if (x == 'spelters') return true;
    if (x == 'spelts') return true;
    if (x == 'speltzes') return true;
    if (x == 'spelunks') return true;
    if (x == 'spencers') return true;
    if (x == 'spences') return true;
    if (x == 'spenders') return true;
    if (x == 'spends') return true;
    if (x == 'spendthrifts') return true;
    if (x == 'spermaries') return true;
    if (x == 'spermines') return true;
    if (x == 'spermous') return true;
    if (x == 'sperms') return true;
    if (x == 'spewers') return true;
    if (x == 'spews') return true;
    if (x == 'sphagnums') return true;
    if (x == 'sphenes') return true;
    if (x == 'sphenoids') return true;
    if (x == 'spheres') return true;
    if (x == 'spherics') return true;
    if (x == 'spheroids') return true;
    if (x == 'spherules') return true;
    if (x == 'sphinges') return true;
    if (x == 'sphingids') return true;
    if (x == 'sphinxes') return true;
    if (x == 'sphygmus') return true;
    if (x == 'sphygmuses') return true;
    if (x == 'spicas') return true;
    if (x == 'spiccatos') return true;
    if (x == 'spiceries') return true;
    if (x == 'spicers') return true;
    if (x == 'spices') return true;
    if (x == 'spicks') return true;
    if (x == 'spics') return true;
    if (x == 'spicules') return true;
    if (x == 'spiders') return true;
    if (x == 'spiegels') return true;
    if (x == 'spielers') return true;
    if (x == 'spiels') return true;
    if (x == 'spiers') return true;
    if (x == 'spies') return true;
    if (x == 'spigots') return true;
    if (x == 'spikelets') return true;
    if (x == 'spikers') return true;
    if (x == 'spikes') return true;
    if (x == 'spiks') return true;
    if (x == 'spiles') return true;
    if (x == 'spilikins') return true;
    if (x == 'spilings') return true;
    if (x == 'spillages') return true;
    if (x == 'spillers') return true;
    if (x == 'spills') return true;
    if (x == 'spillways') return true;
    if (x == 'spilths') return true;
    if (x == 'spinaches') return true;
    if (x == 'spinages') return true;
    if (x == 'spinals') return true;
    if (x == 'spindlers') return true;
    if (x == 'spindles') return true;
    if (x == 'spineless') return true;
    if (x == 'spinelles') return true;
    if (x == 'spinels') return true;
    if (x == 'spines') return true;
    if (x == 'spinets') return true;
    if (x == 'spinifexes') return true;
    if (x == 'spinless') return true;
    if (x == 'spinneries') return true;
    if (x == 'spinners') return true;
    if (x == 'spinneys') return true;
    if (x == 'spinnies') return true;
    if (x == 'spinnings') return true;
    if (x == 'spinoffs') return true;
    if (x == 'spinors') return true;
    if (x == 'spinous') return true;
    if (x == 'spinouts') return true;
    if (x == 'spins') return true;
    if (x == 'spinsters') return true;
    if (x == 'spinules') return true;
    if (x == 'spiracles') return true;
    if (x == 'spiraeas') return true;
    if (x == 'spirals') return true;
    if (x == 'spirants') return true;
    if (x == 'spireas') return true;
    if (x == 'spiremes') return true;
    if (x == 'spirems') return true;
    if (x == 'spires') return true;
    if (x == 'spiritless') return true;
    if (x == 'spirits') return true;
    if (x == 'spiritualisms') return true;
    if (x == 'spiritualists') return true;
    if (x == 'spiritualities') return true;
    if (x == 'spirituals') return true;
    if (x == 'spirts') return true;
    if (x == 'spirulas') return true;
    if (x == 'spitals') return true;
    if (x == 'spitballs') return true;
    if (x == 'spites') return true;
    if (x == 'spitfires') return true;
    if (x == 'spits') return true;
    if (x == 'spitters') return true;
    if (x == 'spittles') return true;
    if (x == 'spittoons') return true;
    if (x == 'spitzes') return true;
    if (x == 'spivs') return true;
    if (x == 'splakes') return true;
    if (x == 'splashers') return true;
    if (x == 'splashes') return true;
    if (x == 'splats') return true;
    if (x == 'splatters') return true;
    if (x == 'splays') return true;
    if (x == 'spleens') return true;
    if (x == 'splendors') return true;
    if (x == 'splenius') return true;
    if (x == 'splents') return true;
    if (x == 'splicers') return true;
    if (x == 'splices') return true;
    if (x == 'splines') return true;
    if (x == 'splinters') return true;
    if (x == 'splints') return true;
    if (x == 'splits') return true;
    if (x == 'splitters') return true;
    if (x == 'splores') return true;
    if (x == 'sploshes') return true;
    if (x == 'splotches') return true;
    if (x == 'splurges') return true;
    if (x == 'splutters') return true;
    if (x == 'spodes') return true;
    if (x == 'spoilages') return true;
    if (x == 'spoilers') return true;
    if (x == 'spoils') return true;
    if (x == 'spokes') return true;
    if (x == 'spoliates') return true;
    if (x == 'spondaics') return true;
    if (x == 'spondees') return true;
    if (x == 'spongers') return true;
    if (x == 'sponges') return true;
    if (x == 'spongins') return true;
    if (x == 'sponsions') return true;
    if (x == 'sponsons') return true;
    if (x == 'sponsors') return true;
    if (x == 'sponsorships') return true;
    if (x == 'spontaneities') return true;
    if (x == 'spontaneous') return true;
    if (x == 'spontoons') return true;
    if (x == 'spoofs') return true;
    if (x == 'spooks') return true;
    if (x == 'spools') return true;
    if (x == 'spoonerisms') return true;
    if (x == 'spooneys') return true;
    if (x == 'spoonfuls') return true;
    if (x == 'spoonies') return true;
    if (x == 'spoons') return true;
    if (x == 'spoors') return true;
    if (x == 'spores') return true;
    if (x == 'sporrans') return true;
    if (x == 'sporters') return true;
    if (x == 'sports') return true;
    if (x == 'sportscasters') return true;
    if (x == 'sportscasts') return true;
    if (x == 'sportsmanships') return true;
    if (x == 'sporules') return true;
    if (x == 'spotless') return true;
    if (x == 'spotlights') return true;
    if (x == 'spots') return true;
    if (x == 'spotters') return true;
    if (x == 'spousals') return true;
    if (x == 'spouses') return true;
    if (x == 'spouters') return true;
    if (x == 'spouts') return true;
    if (x == 'spraddles') return true;
    if (x == 'sprags') return true;
    if (x == 'sprains') return true;
    if (x == 'sprats') return true;
    if (x == 'sprattles') return true;
    if (x == 'sprawlers') return true;
    if (x == 'sprawls') return true;
    if (x == 'sprayers') return true;
    if (x == 'sprays') return true;
    if (x == 'spreaders') return true;
    if (x == 'spreads') return true;
    if (x == 'sprees') return true;
    if (x == 'spriggers') return true;
    if (x == 'sprightliness') return true;
    if (x == 'sprightlinesses') return true;
    if (x == 'sprights') return true;
    if (x == 'sprigs') return true;
    if (x == 'springals') return true;
    if (x == 'springers') return true;
    if (x == 'springes') return true;
    if (x == 'springs') return true;
    if (x == 'sprinklers') return true;
    if (x == 'sprinkles') return true;
    if (x == 'sprinters') return true;
    if (x == 'sprints') return true;
    if (x == 'sprites') return true;
    if (x == 'sprits') return true;
    if (x == 'sprockets') return true;
    if (x == 'sprouts') return true;
    if (x == 'spruces') return true;
    if (x == 'sprues') return true;
    if (x == 'sprugs') return true;
    if (x == 'spryness') return true;
    if (x == 'sprynesses') return true;
    if (x == 'spudders') return true;
    if (x == 'spuds') return true;
    if (x == 'spues') return true;
    if (x == 'spumes') return true;
    if (x == 'spumones') return true;
    if (x == 'spumonis') return true;
    if (x == 'spumous') return true;
    if (x == 'spunkies') return true;
    if (x == 'spunks') return true;
    if (x == 'spurgalls') return true;
    if (x == 'spurges') return true;
    if (x == 'spurious') return true;
    if (x == 'spurners') return true;
    if (x == 'spurns') return true;
    if (x == 'spurrers') return true;
    if (x == 'spurreys') return true;
    if (x == 'spurriers') return true;
    if (x == 'spurries') return true;
    if (x == 'spurs') return true;
    if (x == 'spurtles') return true;
    if (x == 'spurts') return true;
    if (x == 'sputniks') return true;
    if (x == 'sputters') return true;
    if (x == 'spyglass') return true;
    if (x == 'spyglasses') return true;
    if (x == 'squabbles') return true;
    if (x == 'squabs') return true;
    if (x == 'squadrons') return true;
    if (x == 'squads') return true;
    if (x == 'squalenes') return true;
    if (x == 'squallers') return true;
    if (x == 'squalls') return true;
    if (x == 'squalors') return true;
    if (x == 'squamous') return true;
    if (x == 'squanders') return true;
    if (x == 'squarers') return true;
    if (x == 'squares') return true;
    if (x == 'squashers') return true;
    if (x == 'squashes') return true;
    if (x == 'squats') return true;
    if (x == 'squatters') return true;
    if (x == 'squawkers') return true;
    if (x == 'squawks') return true;
    if (x == 'squaws') return true;
    if (x == 'squeakers') return true;
    if (x == 'squeaks') return true;
    if (x == 'squealers') return true;
    if (x == 'squeals') return true;
    if (x == 'squeegees') return true;
    if (x == 'squeezers') return true;
    if (x == 'squeezes') return true;
    if (x == 'squegs') return true;
    if (x == 'squelches') return true;
    if (x == 'squibs') return true;
    if (x == 'squids') return true;
    if (x == 'squiggles') return true;
    if (x == 'squilgees') return true;
    if (x == 'squillas') return true;
    if (x == 'squills') return true;
    if (x == 'squinches') return true;
    if (x == 'squinnies') return true;
    if (x == 'squinters') return true;
    if (x == 'squints') return true;
    if (x == 'squireens') return true;
    if (x == 'squires') return true;
    if (x == 'squirmers') return true;
    if (x == 'squirms') return true;
    if (x == 'squirrels') return true;
    if (x == 'squirters') return true;
    if (x == 'squirts') return true;
    if (x == 'squishes') return true;
    if (x == 'squooshes') return true;
    if (x == 'squushes') return true;
    if (x == 'sraddhas') return true;
    if (x == 'sradhas') return true;
    if (x == 'sris') return true;
    return nil;
  }
  isGoodWordSTA(x) {
    if (x == 'stabbers') return true;
    if (x == 'stabiles') return true;
    if (x == 'stabilisers') return true;
    if (x == 'stabilises') return true;
    if (x == 'stabilities') return true;
    if (x == 'stabilizers') return true;
    if (x == 'stabilizes') return true;
    if (x == 'stablers') return true;
    if (x == 'stables') return true;
    if (x == 'stablings') return true;
    if (x == 'stablishes') return true;
    if (x == 'stabs') return true;
    if (x == 'staccatos') return true;
    if (x == 'stackers') return true;
    if (x == 'stacks') return true;
    if (x == 'stactes') return true;
    if (x == 'staddles') return true;
    if (x == 'stades') return true;
    if (x == 'stadias') return true;
    if (x == 'stadiums') return true;
    if (x == 'staffers') return true;
    if (x == 'staffs') return true;
    if (x == 'stagecoaches') return true;
    if (x == 'stagers') return true;
    if (x == 'stages') return true;
    if (x == 'staggards') return true;
    if (x == 'staggarts') return true;
    if (x == 'staggers') return true;
    if (x == 'staggies') return true;
    if (x == 'stagings') return true;
    if (x == 'stagnates') return true;
    if (x == 'stagnations') return true;
    if (x == 'stags') return true;
    if (x == 'staigs') return true;
    if (x == 'stainers') return true;
    if (x == 'stainless') return true;
    if (x == 'stains') return true;
    if (x == 'staircases') return true;
    if (x == 'stairs') return true;
    if (x == 'stairways') return true;
    if (x == 'stairwells') return true;
    if (x == 'stakeouts') return true;
    if (x == 'stakes') return true;
    if (x == 'stalactites') return true;
    if (x == 'stalagmites') return true;
    if (x == 'stalags') return true;
    if (x == 'stalemates') return true;
    if (x == 'stales') return true;
    if (x == 'stalkers') return true;
    if (x == 'stalks') return true;
    if (x == 'stallions') return true;
    if (x == 'stalls') return true;
    if (x == 'stalwarts') return true;
    if (x == 'stamens') return true;
    if (x == 'staminas') return true;
    if (x == 'stammels') return true;
    if (x == 'stammers') return true;
    if (x == 'stampedes') return true;
    if (x == 'stampers') return true;
    if (x == 'stamps') return true;
    if (x == 'stances') return true;
    if (x == 'stanchers') return true;
    if (x == 'stanches') return true;
    if (x == 'stanchions') return true;
    if (x == 'standardisations') return true;
    if (x == 'standardises') return true;
    if (x == 'standardizations') return true;
    if (x == 'standardizes') return true;
    if (x == 'standards') return true;
    if (x == 'standbys') return true;
    if (x == 'standees') return true;
    if (x == 'standers') return true;
    if (x == 'standings') return true;
    if (x == 'standishes') return true;
    if (x == 'standoffs') return true;
    if (x == 'standouts') return true;
    if (x == 'standpoints') return true;
    if (x == 'stands') return true;
    if (x == 'stanes') return true;
    if (x == 'stangs') return true;
    if (x == 'stanhopes') return true;
    if (x == 'stanks') return true;
    if (x == 'stannaries') return true;
    if (x == 'stannites') return true;
    if (x == 'stannous') return true;
    if (x == 'stannums') return true;
    if (x == 'stanzas') return true;
    if (x == 'stapedes') return true;
    if (x == 'stapelias') return true;
    if (x == 'stapes') return true;
    if (x == 'staphs') return true;
    if (x == 'staplers') return true;
    if (x == 'staples') return true;
    if (x == 'starboards') return true;
    if (x == 'starches') return true;
    if (x == 'stardoms') return true;
    if (x == 'stardusts') return true;
    if (x == 'starers') return true;
    if (x == 'stares') return true;
    if (x == 'starets') return true;
    if (x == 'starfishes') return true;
    if (x == 'stargazes') return true;
    if (x == 'starless') return true;
    if (x == 'starlets') return true;
    if (x == 'starlights') return true;
    if (x == 'starlings') return true;
    if (x == 'starnoses') return true;
    if (x == 'stars') return true;
    if (x == 'starters') return true;
    if (x == 'startlers') return true;
    if (x == 'startles') return true;
    if (x == 'starts') return true;
    if (x == 'starvations') return true;
    if (x == 'starvers') return true;
    if (x == 'starves') return true;
    if (x == 'starworts') return true;
    if (x == 'stases') return true;
    if (x == 'stashes') return true;
    if (x == 'stasis') return true;
    if (x == 'statehoods') return true;
    if (x == 'stateliness') return true;
    if (x == 'statelinesses') return true;
    if (x == 'statements') return true;
    if (x == 'staterooms') return true;
    if (x == 'staters') return true;
    if (x == 'states') return true;
    if (x == 'statesmanships') return true;
    if (x == 'statices') return true;
    if (x == 'statics') return true;
    if (x == 'stationeries') return true;
    if (x == 'stationers') return true;
    if (x == 'stations') return true;
    if (x == 'statisms') return true;
    if (x == 'statisticians') return true;
    if (x == 'statistics') return true;
    if (x == 'statists') return true;
    if (x == 'statives') return true;
    if (x == 'stators') return true;
    if (x == 'statuaries') return true;
    if (x == 'statues') return true;
    if (x == 'statuettes') return true;
    if (x == 'statures') return true;
    if (x == 'status') return true;
    if (x == 'statuses') return true;
    if (x == 'statutes') return true;
    if (x == 'staumrels') return true;
    if (x == 'staunches') return true;
    if (x == 'staves') return true;
    if (x == 'stayers') return true;
    if (x == 'stays') return true;
    if (x == 'staysails') return true;
    if (x == 'steadfastness') return true;
    if (x == 'steadfastnesses') return true;
    if (x == 'steadiers') return true;
    if (x == 'steadies') return true;
    if (x == 'steadiness') return true;
    if (x == 'steadinesses') return true;
    if (x == 'steadings') return true;
    if (x == 'steads') return true;
    if (x == 'steaks') return true;
    if (x == 'stealages') return true;
    if (x == 'stealers') return true;
    if (x == 'stealings') return true;
    if (x == 'steals') return true;
    if (x == 'stealths') return true;
    if (x == 'steamboats') return true;
    if (x == 'steamers') return true;
    if (x == 'steams') return true;
    if (x == 'steamships') return true;
    if (x == 'steapsins') return true;
    if (x == 'stearates') return true;
    if (x == 'stearines') return true;
    if (x == 'stearins') return true;
    if (x == 'steatites') return true;
    if (x == 'steeds') return true;
    if (x == 'steeks') return true;
    if (x == 'steelies') return true;
    if (x == 'steels') return true;
    if (x == 'steenboks') return true;
    if (x == 'steepens') return true;
    if (x == 'steepers') return true;
    if (x == 'steeplechases') return true;
    if (x == 'steeples') return true;
    if (x == 'steepness') return true;
    if (x == 'steepnesses') return true;
    if (x == 'steeps') return true;
    if (x == 'steerages') return true;
    if (x == 'steerers') return true;
    if (x == 'steers') return true;
    if (x == 'steeves') return true;
    if (x == 'steevings') return true;
    if (x == 'stegodons') return true;
    if (x == 'steinboks') return true;
    if (x == 'steins') return true;
    if (x == 'steles') return true;
    if (x == 'stellas') return true;
    if (x == 'stellifies') return true;
    if (x == 'stemless') return true;
    if (x == 'stemmas') return true;
    if (x == 'stemmeries') return true;
    if (x == 'stemmers') return true;
    if (x == 'stems') return true;
    if (x == 'stemsons') return true;
    if (x == 'stemwares') return true;
    if (x == 'stenches') return true;
    if (x == 'stencils') return true;
    if (x == 'stengahs') return true;
    if (x == 'stenographers') return true;
    if (x == 'stenos') return true;
    if (x == 'stenoses') return true;
    if (x == 'stenosis') return true;
    if (x == 'stentors') return true;
    if (x == 'stepdames') return true;
    if (x == 'stepladders') return true;
    if (x == 'steppers') return true;
    if (x == 'steppes') return true;
    if (x == 'steps') return true;
    if (x == 'stepsons') return true;
    if (x == 'stereos') return true;
    if (x == 'stereotypes') return true;
    if (x == 'steres') return true;
    if (x == 'sterigmas') return true;
    if (x == 'sterilisations') return true;
    if (x == 'sterilisers') return true;
    if (x == 'sterilises') return true;
    if (x == 'sterilities') return true;
    if (x == 'sterilizations') return true;
    if (x == 'sterilizers') return true;
    if (x == 'sterilizes') return true;
    if (x == 'sterlets') return true;
    if (x == 'sterlings') return true;
    if (x == 'sternites') return true;
    if (x == 'sternness') return true;
    if (x == 'sternnesses') return true;
    if (x == 'sterns') return true;
    if (x == 'sternsons') return true;
    if (x == 'sternums') return true;
    if (x == 'sternways') return true;
    if (x == 'steroids') return true;
    if (x == 'sterols') return true;
    if (x == 'stertors') return true;
    if (x == 'stethoscopes') return true;
    if (x == 'stets') return true;
    if (x == 'stetsons') return true;
    if (x == 'stevedores') return true;
    if (x == 'stewardess') return true;
    if (x == 'stewardesses') return true;
    if (x == 'stewards') return true;
    if (x == 'stewardships') return true;
    if (x == 'stewbums') return true;
    if (x == 'stewpans') return true;
    if (x == 'stews') return true;
    if (x == 'sthenias') return true;
    if (x == 'stibines') return true;
    if (x == 'stibiums') return true;
    if (x == 'stibnites') return true;
    if (x == 'stichs') return true;
    if (x == 'stickers') return true;
    if (x == 'stickfuls') return true;
    if (x == 'sticklers') return true;
    if (x == 'stickles') return true;
    if (x == 'stickouts') return true;
    if (x == 'stickpins') return true;
    if (x == 'sticks') return true;
    if (x == 'stickums') return true;
    if (x == 'stickups') return true;
    if (x == 'sties') return true;
    if (x == 'stiffens') return true;
    if (x == 'stiffness') return true;
    if (x == 'stiffnesses') return true;
    if (x == 'stiffs') return true;
    if (x == 'stiflers') return true;
    if (x == 'stifles') return true;
    if (x == 'stigmas') return true;
    if (x == 'stigmatises') return true;
    if (x == 'stigmatizes') return true;
    if (x == 'stilbenes') return true;
    if (x == 'stilbites') return true;
    if (x == 'stiles') return true;
    if (x == 'stilettoes') return true;
    if (x == 'stilettos') return true;
    if (x == 'stillbirths') return true;
    if (x == 'stillness') return true;
    if (x == 'stillnesses') return true;
    if (x == 'stills') return true;
    if (x == 'stilts') return true;
    if (x == 'stimes') return true;
    if (x == 'stimies') return true;
    if (x == 'stimulants') return true;
    if (x == 'stimulates') return true;
    if (x == 'stimulations') return true;
    if (x == 'stimulus') return true;
    if (x == 'stingers') return true;
    if (x == 'stinginess') return true;
    if (x == 'stinginesses') return true;
    if (x == 'stingos') return true;
    if (x == 'stingrays') return true;
    if (x == 'stings') return true;
    if (x == 'stinkards') return true;
    if (x == 'stinkbugs') return true;
    if (x == 'stinkers') return true;
    if (x == 'stinkpots') return true;
    if (x == 'stinks') return true;
    if (x == 'stinters') return true;
    if (x == 'stints') return true;
    if (x == 'stipels') return true;
    if (x == 'stipends') return true;
    if (x == 'stipes') return true;
    if (x == 'stipites') return true;
    if (x == 'stipplers') return true;
    if (x == 'stipples') return true;
    if (x == 'stipulates') return true;
    if (x == 'stipulations') return true;
    if (x == 'stipules') return true;
    if (x == 'stirks') return true;
    if (x == 'stirpes') return true;
    if (x == 'stirps') return true;
    if (x == 'stirrers') return true;
    if (x == 'stirrups') return true;
    if (x == 'stirs') return true;
    if (x == 'stitchers') return true;
    if (x == 'stitches') return true;
    if (x == 'stithies') return true;
    if (x == 'stivers') return true;
    if (x == 'stoas') return true;
    if (x == 'stoats') return true;
    if (x == 'stobs') return true;
    if (x == 'stoccados') return true;
    if (x == 'stoccatas') return true;
    if (x == 'stockades') return true;
    if (x == 'stockcars') return true;
    if (x == 'stockers') return true;
    if (x == 'stockings') return true;
    if (x == 'stockists') return true;
    if (x == 'stockpiles') return true;
    if (x == 'stockpots') return true;
    if (x == 'stocks') return true;
    if (x == 'stockyards') return true;
    if (x == 'stodges') return true;
    if (x == 'stogeys') return true;
    if (x == 'stogies') return true;
    if (x == 'stoicisms') return true;
    if (x == 'stoics') return true;
    if (x == 'stokers') return true;
    if (x == 'stokes') return true;
    if (x == 'stokesias') return true;
    if (x == 'stoles') return true;
    if (x == 'stolidities') return true;
    if (x == 'stollens') return true;
    if (x == 'stolons') return true;
    if (x == 'stomachaches') return true;
    if (x == 'stomachs') return true;
    if (x == 'stomas') return true;
    if (x == 'stomates') return true;
    if (x == 'stomatitis') return true;
    if (x == 'stompers') return true;
    if (x == 'stomps') return true;
    if (x == 'stoneflies') return true;
    if (x == 'stoners') return true;
    if (x == 'stones') return true;
    if (x == 'stonishes') return true;
    if (x == 'stooges') return true;
    if (x == 'stookers') return true;
    if (x == 'stooks') return true;
    if (x == 'stoolies') return true;
    if (x == 'stools') return true;
    if (x == 'stoopers') return true;
    if (x == 'stoops') return true;
    if (x == 'stopcocks') return true;
    if (x == 'stopers') return true;
    if (x == 'stopes') return true;
    if (x == 'stopgaps') return true;
    if (x == 'stoplights') return true;
    if (x == 'stopovers') return true;
    if (x == 'stoppages') return true;
    if (x == 'stoppers') return true;
    if (x == 'stopples') return true;
    if (x == 'stops') return true;
    if (x == 'stopwatches') return true;
    if (x == 'storables') return true;
    if (x == 'storages') return true;
    if (x == 'storaxes') return true;
    if (x == 'storehouses') return true;
    if (x == 'storekeepers') return true;
    if (x == 'storerooms') return true;
    if (x == 'stores') return true;
    if (x == 'storeys') return true;
    if (x == 'stories') return true;
    if (x == 'storks') return true;
    if (x == 'storms') return true;
    if (x == 'storytellers') return true;
    if (x == 'storytellings') return true;
    if (x == 'stoss') return true;
    if (x == 'stounds') return true;
    if (x == 'stoups') return true;
    if (x == 'stoures') return true;
    if (x == 'stours') return true;
    if (x == 'stoutens') return true;
    if (x == 'stoutness') return true;
    if (x == 'stoutnesses') return true;
    if (x == 'stouts') return true;
    if (x == 'stovers') return true;
    if (x == 'stoves') return true;
    if (x == 'stowages') return true;
    if (x == 'stowaways') return true;
    if (x == 'stowps') return true;
    if (x == 'stows') return true;
    return nil;
  }
  isGoodWordSTR(x) {
    if (x == 'straddles') return true;
    if (x == 'strafers') return true;
    if (x == 'strafes') return true;
    if (x == 'stragglers') return true;
    if (x == 'straggles') return true;
    if (x == 'straightens') return true;
    if (x == 'straights') return true;
    if (x == 'strainers') return true;
    if (x == 'strains') return true;
    if (x == 'straitens') return true;
    if (x == 'straits') return true;
    if (x == 'strakes') return true;
    if (x == 'stramashes') return true;
    if (x == 'stramonies') return true;
    if (x == 'stranders') return true;
    if (x == 'strands') return true;
    if (x == 'strangeness') return true;
    if (x == 'strangenesses') return true;
    if (x == 'strangers') return true;
    if (x == 'stranglers') return true;
    if (x == 'strangles') return true;
    if (x == 'strangulations') return true;
    if (x == 'strapness') return true;
    if (x == 'strapnesses') return true;
    if (x == 'strappers') return true;
    if (x == 'straps') return true;
    if (x == 'strass') return true;
    if (x == 'strasses') return true;
    if (x == 'stratagems') return true;
    if (x == 'stratas') return true;
    if (x == 'strategies') return true;
    if (x == 'strategists') return true;
    if (x == 'straths') return true;
    if (x == 'stratifications') return true;
    if (x == 'stratifies') return true;
    if (x == 'stratospheres') return true;
    if (x == 'stratous') return true;
    if (x == 'stratums') return true;
    if (x == 'stratus') return true;
    if (x == 'stravages') return true;
    if (x == 'stravaigs') return true;
    if (x == 'strawberries') return true;
    if (x == 'straws') return true;
    if (x == 'strayers') return true;
    if (x == 'strays') return true;
    if (x == 'streakers') return true;
    if (x == 'streaks') return true;
    if (x == 'streamers') return true;
    if (x == 'streamlines') return true;
    if (x == 'streams') return true;
    if (x == 'streekers') return true;
    if (x == 'streeks') return true;
    if (x == 'streetcars') return true;
    if (x == 'streets') return true;
    if (x == 'strengtheners') return true;
    if (x == 'strengthens') return true;
    if (x == 'strengthless') return true;
    if (x == 'strengthlessness') return true;
    if (x == 'strengthlessnesses') return true;
    if (x == 'strengths') return true;
    if (x == 'strenuous') return true;
    if (x == 'streps') return true;
    if (x == 'stress') return true;
    if (x == 'stresses') return true;
    if (x == 'stressors') return true;
    if (x == 'stretchers') return true;
    if (x == 'stretches') return true;
    if (x == 'strettas') return true;
    if (x == 'strettos') return true;
    if (x == 'streusels') return true;
    if (x == 'strewers') return true;
    if (x == 'strews') return true;
    if (x == 'striates') return true;
    if (x == 'striations') return true;
    if (x == 'strickles') return true;
    if (x == 'stricks') return true;
    if (x == 'strictness') return true;
    if (x == 'strictnesses') return true;
    if (x == 'strictures') return true;
    if (x == 'striders') return true;
    if (x == 'strides') return true;
    if (x == 'stridors') return true;
    if (x == 'strifes') return true;
    if (x == 'strigils') return true;
    if (x == 'strikers') return true;
    if (x == 'strikes') return true;
    if (x == 'stringers') return true;
    if (x == 'strings') return true;
    if (x == 'stripers') return true;
    if (x == 'stripes') return true;
    if (x == 'stripings') return true;
    if (x == 'strippers') return true;
    if (x == 'strips') return true;
    if (x == 'strivers') return true;
    if (x == 'strives') return true;
    if (x == 'strobes') return true;
    if (x == 'strobiles') return true;
    if (x == 'strobils') return true;
    if (x == 'strokers') return true;
    if (x == 'strokes') return true;
    if (x == 'strollers') return true;
    if (x == 'strolls') return true;
    if (x == 'strongholds') return true;
    if (x == 'strongyls') return true;
    if (x == 'strontias') return true;
    if (x == 'strontiums') return true;
    if (x == 'strophes') return true;
    if (x == 'strops') return true;
    if (x == 'strouds') return true;
    if (x == 'strows') return true;
    if (x == 'stroyers') return true;
    if (x == 'stroys') return true;
    if (x == 'structures') return true;
    if (x == 'strudels') return true;
    if (x == 'struggles') return true;
    if (x == 'strumas') return true;
    if (x == 'strummers') return true;
    if (x == 'strumous') return true;
    if (x == 'strumpets') return true;
    if (x == 'strums') return true;
    if (x == 'strunts') return true;
    if (x == 'struts') return true;
    if (x == 'strutters') return true;
    if (x == 'strychnines') return true;
    if (x == 'stubbles') return true;
    if (x == 'stubbornness') return true;
    if (x == 'stubbornnesses') return true;
    if (x == 'stubs') return true;
    if (x == 'stuccoers') return true;
    if (x == 'stuccoes') return true;
    if (x == 'stuccos') return true;
    if (x == 'studbooks') return true;
    if (x == 'studdies') return true;
    if (x == 'studdings') return true;
    if (x == 'students') return true;
    if (x == 'studfishes') return true;
    if (x == 'studiers') return true;
    if (x == 'studies') return true;
    if (x == 'studios') return true;
    if (x == 'studious') return true;
    if (x == 'studs') return true;
    if (x == 'studworks') return true;
    if (x == 'stuffers') return true;
    if (x == 'stuffings') return true;
    if (x == 'stuffs') return true;
    if (x == 'stuivers') return true;
    if (x == 'stulls') return true;
    if (x == 'stultifications') return true;
    if (x == 'stultifies') return true;
    if (x == 'stumblers') return true;
    if (x == 'stumbles') return true;
    if (x == 'stumpages') return true;
    if (x == 'stumpers') return true;
    if (x == 'stumps') return true;
    if (x == 'stums') return true;
    if (x == 'stunners') return true;
    if (x == 'stuns') return true;
    if (x == 'stunsails') return true;
    if (x == 'stunts') return true;
    if (x == 'stupas') return true;
    if (x == 'stupefactions') return true;
    if (x == 'stupefies') return true;
    if (x == 'stupendous') return true;
    if (x == 'stupes') return true;
    if (x == 'stupids') return true;
    if (x == 'stuporous') return true;
    if (x == 'stupors') return true;
    if (x == 'sturdies') return true;
    if (x == 'sturdiness') return true;
    if (x == 'sturdinesses') return true;
    if (x == 'sturgeons') return true;
    if (x == 'sturts') return true;
    if (x == 'stutters') return true;
    if (x == 'styes') return true;
    if (x == 'stylers') return true;
    if (x == 'styles') return true;
    if (x == 'stylets') return true;
    if (x == 'stylings') return true;
    if (x == 'stylisers') return true;
    if (x == 'stylises') return true;
    if (x == 'stylishness') return true;
    if (x == 'stylishnesses') return true;
    if (x == 'stylists') return true;
    if (x == 'stylites') return true;
    if (x == 'stylizers') return true;
    if (x == 'stylizes') return true;
    if (x == 'stylus') return true;
    if (x == 'styluses') return true;
    if (x == 'stymies') return true;
    if (x == 'stypsis') return true;
    if (x == 'stypsises') return true;
    if (x == 'styptics') return true;
    if (x == 'styraxes') return true;
    if (x == 'styrenes') return true;
    if (x == 'suasions') return true;
    if (x == 'suavities') return true;
    if (x == 'subabbots') return true;
    if (x == 'subadars') return true;
    if (x == 'subadults') return true;
    if (x == 'subagencies') return true;
    if (x == 'subagents') return true;
    if (x == 'subahdars') return true;
    if (x == 'subahs') return true;
    if (x == 'subareas') return true;
    if (x == 'subas') return true;
    if (x == 'subatoms') return true;
    if (x == 'subbasements') return true;
    if (x == 'subbases') return true;
    if (x == 'subbass') return true;
    if (x == 'subbasses') return true;
    if (x == 'subbings') return true;
    if (x == 'subbranches') return true;
    if (x == 'subbreeds') return true;
    if (x == 'subcabinets') return true;
    if (x == 'subcategories') return true;
    if (x == 'subcauses') return true;
    if (x == 'subcells') return true;
    if (x == 'subchiefs') return true;
    if (x == 'subclans') return true;
    if (x == 'subclass') return true;
    if (x == 'subclasses') return true;
    if (x == 'subclassifications') return true;
    if (x == 'subclassifies') return true;
    if (x == 'subclerks') return true;
    if (x == 'subcommands') return true;
    if (x == 'subcommissions') return true;
    if (x == 'subcommunities') return true;
    if (x == 'subcomponents') return true;
    if (x == 'subconcepts') return true;
    if (x == 'subconscious') return true;
    if (x == 'subconsciouses') return true;
    if (x == 'subconsciousness') return true;
    if (x == 'subconsciousnesses') return true;
    if (x == 'subcontractors') return true;
    if (x == 'subcontracts') return true;
    if (x == 'subcools') return true;
    if (x == 'subcultures') return true;
    if (x == 'subcutaneous') return true;
    if (x == 'subcutes') return true;
    if (x == 'subcutis') return true;
    if (x == 'subcutises') return true;
    if (x == 'subdeans') return true;
    if (x == 'subdebs') return true;
    if (x == 'subdepartments') return true;
    if (x == 'subdepots') return true;
    if (x == 'subdistricts') return true;
    if (x == 'subdivides') return true;
    if (x == 'subdivisions') return true;
    if (x == 'subduals') return true;
    if (x == 'subduces') return true;
    if (x == 'subducts') return true;
    if (x == 'subduers') return true;
    if (x == 'subdues') return true;
    if (x == 'subechoes') return true;
    if (x == 'subedits') return true;
    if (x == 'subentries') return true;
    if (x == 'subepochs') return true;
    if (x == 'suberins') return true;
    if (x == 'suberises') return true;
    if (x == 'suberizes') return true;
    if (x == 'suberous') return true;
    if (x == 'subers') return true;
    if (x == 'subfamilies') return true;
    if (x == 'subfields') return true;
    if (x == 'subfixes') return true;
    if (x == 'subfloors') return true;
    if (x == 'subgenus') return true;
    if (x == 'subgenuses') return true;
    if (x == 'subgrades') return true;
    if (x == 'subgroups') return true;
    if (x == 'subheadings') return true;
    if (x == 'subheads') return true;
    if (x == 'subhumans') return true;
    if (x == 'subideas') return true;
    if (x == 'subindexes') return true;
    if (x == 'subindices') return true;
    if (x == 'subindustries') return true;
    if (x == 'subitems') return true;
    if (x == 'subjections') return true;
    if (x == 'subjectivities') return true;
    if (x == 'subjects') return true;
    if (x == 'subjoins') return true;
    if (x == 'subjugates') return true;
    if (x == 'subjugations') return true;
    if (x == 'subjunctives') return true;
    if (x == 'sublates') return true;
    if (x == 'subleases') return true;
    if (x == 'sublets') return true;
    if (x == 'sublevels') return true;
    if (x == 'sublimers') return true;
    if (x == 'sublimes') return true;
    if (x == 'sublimities') return true;
    if (x == 'submarines') return true;
    if (x == 'submergences') return true;
    if (x == 'submerges') return true;
    if (x == 'submerses') return true;
    if (x == 'submersions') return true;
    if (x == 'submiss') return true;
    if (x == 'submissions') return true;
    if (x == 'submits') return true;
    if (x == 'subnetworks') return true;
    if (x == 'suborders') return true;
    if (x == 'subordinates') return true;
    if (x == 'subordinations') return true;
    if (x == 'suborners') return true;
    if (x == 'suborns') return true;
    if (x == 'suboxides') return true;
    if (x == 'subparts') return true;
    if (x == 'subpenas') return true;
    if (x == 'subplots') return true;
    if (x == 'subpoenas') return true;
    if (x == 'subprincipals') return true;
    if (x == 'subprocess') return true;
    if (x == 'subprocesses') return true;
    if (x == 'subprograms') return true;
    if (x == 'subprojects') return true;
    if (x == 'subraces') return true;
    if (x == 'subregions') return true;
    if (x == 'subrents') return true;
    if (x == 'subrings') return true;
    if (x == 'subroutines') return true;
    if (x == 'subrules') return true;
    if (x == 'subs') return true;
    if (x == 'subsales') return true;
    if (x == 'subscribers') return true;
    if (x == 'subscribes') return true;
    if (x == 'subscriptions') return true;
    if (x == 'subscripts') return true;
    if (x == 'subsections') return true;
    if (x == 'subsects') return true;
    if (x == 'subseres') return true;
    if (x == 'subserves') return true;
    if (x == 'subsets') return true;
    if (x == 'subshafts') return true;
    if (x == 'subshrubs') return true;
    if (x == 'subsiders') return true;
    if (x == 'subsides') return true;
    if (x == 'subsidiaries') return true;
    if (x == 'subsidies') return true;
    if (x == 'subsidises') return true;
    if (x == 'subsidizes') return true;
    if (x == 'subsistences') return true;
    if (x == 'subsists') return true;
    if (x == 'subsoils') return true;
    if (x == 'subspaces') return true;
    if (x == 'subspecialties') return true;
    if (x == 'subspecies') return true;
    if (x == 'substages') return true;
    if (x == 'substantiates') return true;
    if (x == 'substantiations') return true;
    if (x == 'substitutes') return true;
    if (x == 'substitutions') return true;
    if (x == 'substructures') return true;
    if (x == 'subsumes') return true;
    if (x == 'subsystems') return true;
    if (x == 'subteens') return true;
    if (x == 'subtends') return true;
    if (x == 'subterfuges') return true;
    if (x == 'subterraneous') return true;
    if (x == 'subtexts') return true;
    if (x == 'subtilties') return true;
    if (x == 'subtitles') return true;
    if (x == 'subtleties') return true;
    if (x == 'subtones') return true;
    if (x == 'subtonics') return true;
    if (x == 'subtopics') return true;
    if (x == 'subtotals') return true;
    if (x == 'subtractions') return true;
    if (x == 'subtracts') return true;
    if (x == 'subtreasuries') return true;
    if (x == 'subtribes') return true;
    if (x == 'subtunics') return true;
    if (x == 'subtypes') return true;
    if (x == 'subunits') return true;
    if (x == 'suburbans') return true;
    if (x == 'suburbias') return true;
    if (x == 'suburbs') return true;
    if (x == 'subvenes') return true;
    if (x == 'subverts') return true;
    if (x == 'subvicars') return true;
    if (x == 'subways') return true;
    if (x == 'subzones') return true;
    return nil;
  }
  isGoodWordSUC(x) {
    if (x == 'succahs') return true;
    if (x == 'succeeds') return true;
    if (x == 'success') return true;
    if (x == 'successes') return true;
    if (x == 'successions') return true;
    if (x == 'successors') return true;
    if (x == 'succinctness') return true;
    if (x == 'succinctnesses') return true;
    if (x == 'succinyls') return true;
    if (x == 'succorers') return true;
    if (x == 'succories') return true;
    if (x == 'succors') return true;
    if (x == 'succotashes') return true;
    if (x == 'succours') return true;
    if (x == 'succubus') return true;
    if (x == 'succubuses') return true;
    if (x == 'succulences') return true;
    if (x == 'succulents') return true;
    if (x == 'succumbs') return true;
    if (x == 'succuss') return true;
    if (x == 'succusses') return true;
    if (x == 'suchness') return true;
    if (x == 'suchnesses') return true;
    if (x == 'suckers') return true;
    if (x == 'suckfishes') return true;
    if (x == 'sucklers') return true;
    if (x == 'suckles') return true;
    if (x == 'suckless') return true;
    if (x == 'sucklings') return true;
    if (x == 'sucks') return true;
    if (x == 'sucrases') return true;
    if (x == 'sucres') return true;
    if (x == 'sucroses') return true;
    if (x == 'suctions') return true;
    if (x == 'sudaries') return true;
    if (x == 'sudations') return true;
    if (x == 'sudatories') return true;
    if (x == 'suddenness') return true;
    if (x == 'suddennesses') return true;
    if (x == 'suddens') return true;
    if (x == 'sudds') return true;
    if (x == 'sudors') return true;
    if (x == 'suds') return true;
    if (x == 'sudsers') return true;
    if (x == 'sudses') return true;
    if (x == 'sudsless') return true;
    if (x == 'suedes') return true;
    if (x == 'suers') return true;
    if (x == 'sues') return true;
    if (x == 'suets') return true;
    if (x == 'suffaris') return true;
    if (x == 'sufferers') return true;
    if (x == 'sufferings') return true;
    if (x == 'suffers') return true;
    if (x == 'sufficers') return true;
    if (x == 'suffices') return true;
    if (x == 'sufficiencies') return true;
    if (x == 'suffixations') return true;
    if (x == 'suffixes') return true;
    if (x == 'sufflates') return true;
    if (x == 'suffocates') return true;
    if (x == 'suffocations') return true;
    if (x == 'suffrages') return true;
    if (x == 'suffuses') return true;
    if (x == 'sugarcanes') return true;
    if (x == 'sugars') return true;
    if (x == 'suggestions') return true;
    if (x == 'suggestiveness') return true;
    if (x == 'suggestivenesses') return true;
    if (x == 'suggests') return true;
    if (x == 'sughs') return true;
    if (x == 'suicides') return true;
    if (x == 'suints') return true;
    if (x == 'suitabilities') return true;
    if (x == 'suitcases') return true;
    if (x == 'suites') return true;
    if (x == 'suitings') return true;
    if (x == 'suitors') return true;
    if (x == 'suits') return true;
    if (x == 'sukiyakis') return true;
    if (x == 'sukkahs') return true;
    if (x == 'sulcus') return true;
    if (x == 'suldans') return true;
    if (x == 'sulfas') return true;
    if (x == 'sulfates') return true;
    if (x == 'sulfides') return true;
    if (x == 'sulfids') return true;
    if (x == 'sulfinyls') return true;
    if (x == 'sulfites') return true;
    if (x == 'sulfonals') return true;
    if (x == 'sulfones') return true;
    if (x == 'sulfonyls') return true;
    if (x == 'sulfureous') return true;
    if (x == 'sulfurets') return true;
    if (x == 'sulfurous') return true;
    if (x == 'sulfurs') return true;
    if (x == 'sulfuryls') return true;
    if (x == 'sulkers') return true;
    if (x == 'sulkies') return true;
    if (x == 'sulkiness') return true;
    if (x == 'sulkinesses') return true;
    if (x == 'sulks') return true;
    if (x == 'sullages') return true;
    if (x == 'sullenness') return true;
    if (x == 'sullennesses') return true;
    if (x == 'sullies') return true;
    if (x == 'sulphas') return true;
    if (x == 'sulphates') return true;
    if (x == 'sulphers') return true;
    if (x == 'sulphides') return true;
    if (x == 'sulphids') return true;
    if (x == 'sulphites') return true;
    if (x == 'sulphones') return true;
    if (x == 'sulphurs') return true;
    if (x == 'sultanas') return true;
    if (x == 'sultanates') return true;
    if (x == 'sultans') return true;
    if (x == 'sumachs') return true;
    if (x == 'sumacs') return true;
    if (x == 'sumless') return true;
    if (x == 'summands') return true;
    if (x == 'summaries') return true;
    if (x == 'summarisations') return true;
    if (x == 'summarises') return true;
    if (x == 'summarizations') return true;
    if (x == 'summarizes') return true;
    if (x == 'summas') return true;
    if (x == 'summates') return true;
    if (x == 'summations') return true;
    if (x == 'summers') return true;
    if (x == 'summitries') return true;
    if (x == 'summits') return true;
    if (x == 'summoners') return true;
    if (x == 'summons') return true;
    if (x == 'summonses') return true;
    if (x == 'sumos') return true;
    if (x == 'sumps') return true;
    if (x == 'sumpters') return true;
    if (x == 'sumptuous') return true;
    if (x == 'sumpweeds') return true;
    if (x == 'sums') return true;
    if (x == 'sunbathes') return true;
    if (x == 'sunbaths') return true;
    if (x == 'sunbeams') return true;
    if (x == 'sunbirds') return true;
    if (x == 'sunbows') return true;
    if (x == 'sunburns') return true;
    if (x == 'sunbursts') return true;
    if (x == 'sundaes') return true;
    if (x == 'sunderers') return true;
    if (x == 'sunders') return true;
    if (x == 'sundews') return true;
    if (x == 'sundials') return true;
    if (x == 'sundogs') return true;
    if (x == 'sundowns') return true;
    if (x == 'sundries') return true;
    if (x == 'sundrops') return true;
    if (x == 'sunfishes') return true;
    if (x == 'sunflowers') return true;
    if (x == 'sunglass') return true;
    if (x == 'sunglasses') return true;
    if (x == 'sunglows') return true;
    if (x == 'sunkets') return true;
    if (x == 'sunlamps') return true;
    if (x == 'sunlands') return true;
    if (x == 'sunless') return true;
    if (x == 'sunlights') return true;
    if (x == 'sunnas') return true;
    if (x == 'sunns') return true;
    if (x == 'sunrises') return true;
    if (x == 'sunroofs') return true;
    if (x == 'sunrooms') return true;
    if (x == 'suns') return true;
    if (x == 'sunscalds') return true;
    if (x == 'sunsets') return true;
    if (x == 'sunshades') return true;
    if (x == 'sunshines') return true;
    if (x == 'sunspots') return true;
    if (x == 'sunstones') return true;
    if (x == 'sunsuits') return true;
    if (x == 'suntans') return true;
    if (x == 'sunups') return true;
    if (x == 'sunwards') return true;
    if (x == 'superabundances') return true;
    if (x == 'superadds') return true;
    if (x == 'superambitious') return true;
    if (x == 'superathletes') return true;
    if (x == 'superbombs') return true;
    if (x == 'supercilious') return true;
    if (x == 'superefficiencies') return true;
    if (x == 'superegos') return true;
    if (x == 'superenthusiasms') return true;
    if (x == 'superficialities') return true;
    if (x == 'superfixes') return true;
    if (x == 'superfluous') return true;
    if (x == 'supergovernments') return true;
    if (x == 'supergroups') return true;
    if (x == 'superheroines') return true;
    if (x == 'superheros') return true;
    if (x == 'superhumans') return true;
    if (x == 'superimposes') return true;
    if (x == 'superintellectuals') return true;
    if (x == 'superintelligences') return true;
    if (x == 'superintendences') return true;
    if (x == 'superintendencies') return true;
    if (x == 'superintendents') return true;
    if (x == 'superintends') return true;
    if (x == 'superiorities') return true;
    if (x == 'superiors') return true;
    if (x == 'superjets') return true;
    if (x == 'superlies') return true;
    if (x == 'supermarkets') return true;
    if (x == 'superpatriotisms') return true;
    if (x == 'superpatriots') return true;
    if (x == 'superplanes') return true;
    if (x == 'superports') return true;
    if (x == 'supers') return true;
    if (x == 'superscouts') return true;
    if (x == 'superscripts') return true;
    if (x == 'supersecrecies') return true;
    if (x == 'supersedes') return true;
    if (x == 'supersexes') return true;
    if (x == 'superships') return true;
    if (x == 'superspecialists') return true;
    if (x == 'superstars') return true;
    if (x == 'superstates') return true;
    if (x == 'superstitions') return true;
    if (x == 'superstitious') return true;
    if (x == 'superstrengths') return true;
    if (x == 'superstrings') return true;
    if (x == 'superstructures') return true;
    if (x == 'supersystems') return true;
    if (x == 'supertankers') return true;
    if (x == 'supertaxes') return true;
    if (x == 'supervenes') return true;
    if (x == 'supervises') return true;
    if (x == 'supervisions') return true;
    if (x == 'supervisors') return true;
    if (x == 'superweapons') return true;
    if (x == 'supes') return true;
    if (x == 'supinates') return true;
    if (x == 'supines') return true;
    if (x == 'suppers') return true;
    if (x == 'supplants') return true;
    if (x == 'supplements') return true;
    if (x == 'supples') return true;
    if (x == 'suppliants') return true;
    if (x == 'supplicants') return true;
    if (x == 'supplicates') return true;
    if (x == 'supplications') return true;
    if (x == 'suppliers') return true;
    if (x == 'supplies') return true;
    if (x == 'supporters') return true;
    if (x == 'supports') return true;
    if (x == 'supposals') return true;
    if (x == 'supposers') return true;
    if (x == 'supposes') return true;
    if (x == 'suppositions') return true;
    if (x == 'suppositories') return true;
    if (x == 'suppress') return true;
    if (x == 'suppresses') return true;
    if (x == 'suppressions') return true;
    if (x == 'suppurates') return true;
    if (x == 'suppurations') return true;
    if (x == 'supremacies') return true;
    if (x == 'sups') return true;
    if (x == 'surahs') return true;
    if (x == 'suras') return true;
    if (x == 'surbases') return true;
    if (x == 'surceases') return true;
    if (x == 'surcharges') return true;
    if (x == 'surcoats') return true;
    if (x == 'surds') return true;
    if (x == 'sureness') return true;
    if (x == 'surenesses') return true;
    if (x == 'sureties') return true;
    if (x == 'surfacers') return true;
    if (x == 'surfaces') return true;
    if (x == 'surfbirds') return true;
    if (x == 'surfboats') return true;
    if (x == 'surfeits') return true;
    if (x == 'surfers') return true;
    if (x == 'surffishes') return true;
    if (x == 'surfings') return true;
    if (x == 'surfs') return true;
    if (x == 'surgeons') return true;
    if (x == 'surgeries') return true;
    if (x == 'surgers') return true;
    if (x == 'surges') return true;
    if (x == 'suricates') return true;
    if (x == 'surmisers') return true;
    if (x == 'surmises') return true;
    if (x == 'surmounts') return true;
    if (x == 'surnamers') return true;
    if (x == 'surnames') return true;
    if (x == 'surpass') return true;
    if (x == 'surpasses') return true;
    if (x == 'surplices') return true;
    if (x == 'surplus') return true;
    if (x == 'surpluses') return true;
    if (x == 'surprints') return true;
    if (x == 'surprises') return true;
    if (x == 'surprizes') return true;
    if (x == 'surras') return true;
    if (x == 'surrenders') return true;
    if (x == 'surreptitious') return true;
    if (x == 'surreys') return true;
    if (x == 'surroundings') return true;
    if (x == 'surrounds') return true;
    if (x == 'surroyals') return true;
    if (x == 'surtaxes') return true;
    if (x == 'surtouts') return true;
    if (x == 'surveillances') return true;
    if (x == 'surveils') return true;
    if (x == 'surveyors') return true;
    if (x == 'surveys') return true;
    if (x == 'survivals') return true;
    if (x == 'survivers') return true;
    if (x == 'survives') return true;
    if (x == 'survivors') return true;
    if (x == 'survivorships') return true;
    if (x == 'susceptibilities') return true;
    if (x == 'susliks') return true;
    if (x == 'suspects') return true;
    if (x == 'suspenders') return true;
    if (x == 'suspends') return true;
    if (x == 'suspenses') return true;
    if (x == 'suspensions') return true;
    if (x == 'suspicions') return true;
    if (x == 'suspicious') return true;
    if (x == 'suspires') return true;
    if (x == 'sustains') return true;
    if (x == 'sustenances') return true;
    if (x == 'susurrus') return true;
    if (x == 'susurruses') return true;
    if (x == 'sutlers') return true;
    if (x == 'sutras') return true;
    if (x == 'suttas') return true;
    if (x == 'suttees') return true;
    if (x == 'sutures') return true;
    if (x == 'suzerains') return true;
    return nil;
  }
  isGoodWordSV(x) {
    if (x == 'svarajes') return true;
    if (x == 'svedbergs') return true;
    if (x == 'swabbers') return true;
    if (x == 'swabbies') return true;
    if (x == 'swabs') return true;
    if (x == 'swaddles') return true;
    if (x == 'swagers') return true;
    if (x == 'swages') return true;
    if (x == 'swaggers') return true;
    if (x == 'swags') return true;
    if (x == 'swails') return true;
    if (x == 'swains') return true;
    if (x == 'swales') return true;
    if (x == 'swallows') return true;
    if (x == 'swamies') return true;
    if (x == 'swamis') return true;
    if (x == 'swampers') return true;
    if (x == 'swamps') return true;
    if (x == 'swanherds') return true;
    if (x == 'swanks') return true;
    if (x == 'swanneries') return true;
    if (x == 'swanpans') return true;
    if (x == 'swans') return true;
    if (x == 'swanskins') return true;
    if (x == 'swappers') return true;
    if (x == 'swaps') return true;
    if (x == 'swarajes') return true;
    if (x == 'swards') return true;
    if (x == 'swarfs') return true;
    if (x == 'swarmers') return true;
    if (x == 'swarms') return true;
    if (x == 'swarths') return true;
    if (x == 'swashbucklers') return true;
    if (x == 'swashbucklings') return true;
    if (x == 'swashers') return true;
    if (x == 'swashes') return true;
    if (x == 'swasticas') return true;
    if (x == 'swastikas') return true;
    if (x == 'swatches') return true;
    if (x == 'swathers') return true;
    if (x == 'swathes') return true;
    if (x == 'swaths') return true;
    if (x == 'swats') return true;
    if (x == 'swatters') return true;
    if (x == 'swaybacks') return true;
    if (x == 'swayers') return true;
    if (x == 'sways') return true;
    if (x == 'swearers') return true;
    if (x == 'swears') return true;
    if (x == 'sweatboxes') return true;
    if (x == 'sweaters') return true;
    if (x == 'sweats') return true;
    if (x == 'swedes') return true;
    if (x == 'sweenies') return true;
    if (x == 'sweepers') return true;
    if (x == 'sweepings') return true;
    if (x == 'sweeps') return true;
    if (x == 'sweepstakes') return true;
    if (x == 'sweeteners') return true;
    if (x == 'sweetens') return true;
    if (x == 'sweethearts') return true;
    if (x == 'sweeties') return true;
    if (x == 'sweetings') return true;
    if (x == 'sweetness') return true;
    if (x == 'sweetnesses') return true;
    if (x == 'sweets') return true;
    if (x == 'sweetsops') return true;
    if (x == 'swellings') return true;
    if (x == 'swells') return true;
    if (x == 'swelters') return true;
    if (x == 'swervers') return true;
    if (x == 'swerves') return true;
    if (x == 'swevens') return true;
    if (x == 'swifters') return true;
    if (x == 'swiftness') return true;
    if (x == 'swiftnesses') return true;
    if (x == 'swifts') return true;
    if (x == 'swiggers') return true;
    if (x == 'swigs') return true;
    if (x == 'swillers') return true;
    if (x == 'swills') return true;
    if (x == 'swimmers') return true;
    if (x == 'swimmings') return true;
    if (x == 'swims') return true;
    if (x == 'swimsuits') return true;
    if (x == 'swindlers') return true;
    if (x == 'swindles') return true;
    if (x == 'swinepoxes') return true;
    if (x == 'swingers') return true;
    if (x == 'swinges') return true;
    if (x == 'swingles') return true;
    if (x == 'swings') return true;
    if (x == 'swinks') return true;
    if (x == 'swinneys') return true;
    if (x == 'swipes') return true;
    if (x == 'swiples') return true;
    if (x == 'swipples') return true;
    if (x == 'swirls') return true;
    if (x == 'swishers') return true;
    if (x == 'swishes') return true;
    if (x == 'swiss') return true;
    if (x == 'swisses') return true;
    if (x == 'switchboards') return true;
    if (x == 'switchers') return true;
    if (x == 'switches') return true;
    if (x == 'swithers') return true;
    if (x == 'swivels') return true;
    if (x == 'swives') return true;
    if (x == 'swivets') return true;
    if (x == 'swizzlers') return true;
    if (x == 'swizzles') return true;
    if (x == 'swobbers') return true;
    if (x == 'swobs') return true;
    if (x == 'swooners') return true;
    if (x == 'swoons') return true;
    if (x == 'swoopers') return true;
    if (x == 'swoops') return true;
    if (x == 'swooshes') return true;
    if (x == 'swops') return true;
    if (x == 'swordfishes') return true;
    if (x == 'swords') return true;
    if (x == 'swots') return true;
    if (x == 'swotters') return true;
    if (x == 'swounds') return true;
    if (x == 'swouns') return true;
    if (x == 'sybarites') return true;
    if (x == 'syboes') return true;
    if (x == 'sycamines') return true;
    if (x == 'sycamores') return true;
    if (x == 'sycees') return true;
    if (x == 'syces') return true;
    if (x == 'sycomores') return true;
    if (x == 'sycophants') return true;
    if (x == 'sycoses') return true;
    if (x == 'sycosis') return true;
    if (x == 'syenites') return true;
    if (x == 'sykes') return true;
    if (x == 'syllabics') return true;
    if (x == 'syllables') return true;
    if (x == 'syllabubs') return true;
    if (x == 'syllabus') return true;
    if (x == 'syllabuses') return true;
    if (x == 'sylphids') return true;
    if (x == 'sylphs') return true;
    if (x == 'sylvans') return true;
    if (x == 'sylvas') return true;
    if (x == 'sylvines') return true;
    if (x == 'sylvins') return true;
    if (x == 'sylvites') return true;
    if (x == 'symbions') return true;
    if (x == 'symbionts') return true;
    if (x == 'symbiotes') return true;
    if (x == 'symbiots') return true;
    if (x == 'symbolisations') return true;
    if (x == 'symbolises') return true;
    if (x == 'symbolisms') return true;
    if (x == 'symbolizations') return true;
    if (x == 'symbolizes') return true;
    if (x == 'symbols') return true;
    if (x == 'symmetries') return true;
    if (x == 'sympathies') return true;
    if (x == 'sympathises') return true;
    if (x == 'sympathizes') return true;
    if (x == 'sympatries') return true;
    if (x == 'symphonies') return true;
    if (x == 'symptoms') return true;
    if (x == 'synagogs') return true;
    if (x == 'synagogues') return true;
    if (x == 'synapses') return true;
    if (x == 'synapsis') return true;
    if (x == 'syncarpies') return true;
    if (x == 'syncarps') return true;
    if (x == 'synchronisations') return true;
    if (x == 'synchronises') return true;
    if (x == 'synchros') return true;
    if (x == 'synchs') return true;
    if (x == 'synclines') return true;
    if (x == 'syncoms') return true;
    if (x == 'syncopates') return true;
    if (x == 'syncopations') return true;
    if (x == 'syncopes') return true;
    if (x == 'syncs') return true;
    if (x == 'syndeses') return true;
    if (x == 'syndesis') return true;
    if (x == 'syndesises') return true;
    if (x == 'syndets') return true;
    if (x == 'syndicates') return true;
    if (x == 'syndics') return true;
    if (x == 'syndromes') return true;
    if (x == 'synergias') return true;
    if (x == 'synergids') return true;
    if (x == 'synergies') return true;
    if (x == 'synesis') return true;
    if (x == 'synesises') return true;
    if (x == 'syngamies') return true;
    if (x == 'synods') return true;
    if (x == 'synonymes') return true;
    if (x == 'synonymies') return true;
    if (x == 'synonymous') return true;
    if (x == 'synonyms') return true;
    if (x == 'synopses') return true;
    if (x == 'synopsis') return true;
    if (x == 'synovias') return true;
    if (x == 'syntaxes') return true;
    if (x == 'syntheses') return true;
    if (x == 'synthesis') return true;
    if (x == 'synthesisers') return true;
    if (x == 'synthesises') return true;
    if (x == 'synthesizers') return true;
    if (x == 'synthesizes') return true;
    if (x == 'synthetics') return true;
    if (x == 'syntonies') return true;
    if (x == 'syphers') return true;
    if (x == 'syphilis') return true;
    if (x == 'syphilises') return true;
    if (x == 'syphons') return true;
    if (x == 'syrens') return true;
    if (x == 'syringas') return true;
    if (x == 'syringes') return true;
    if (x == 'syrinxes') return true;
    if (x == 'syrphians') return true;
    if (x == 'syrphids') return true;
    if (x == 'syrups') return true;
    if (x == 'systematises') return true;
    if (x == 'systematizes') return true;
    if (x == 'systemics') return true;
    if (x == 'systems') return true;
    if (x == 'systoles') return true;
    if (x == 'syzygies') return true;
    return nil;
  }
;
twiEscSA: TwiEscDataObject
  firstLetter = 's'
  lastLetter  = 'a'
  isGoodWord(x) {
    if (x == 'sabra') return true;
    if (x == 'sacra') return true;
    if (x == 'sacraria') return true;
    if (x == 'saga') return true;
    if (x == 'saiga') return true;
    if (x == 'salina') return true;
    if (x == 'saliva') return true;
    if (x == 'salpa') return true;
    if (x == 'salsilla') return true;
    if (x == 'salvia') return true;
    if (x == 'samara') return true;
    if (x == 'samba') return true;
    if (x == 'sambuca') return true;
    if (x == 'samsara') return true;
    if (x == 'sanatoria') return true;
    if (x == 'sancta') return true;
    if (x == 'sanga') return true;
    if (x == 'sangria') return true;
    if (x == 'sanitaria') return true;
    if (x == 'saphena') return true;
    if (x == 'sapota') return true;
    if (x == 'sapremia') return true;
    if (x == 'sarcoma') return true;
    if (x == 'sarcomata') return true;
    if (x == 'sarmenta') return true;
    if (x == 'sarsaparilla') return true;
    if (x == 'sastruga') return true;
    if (x == 'satara') return true;
    if (x == 'saturnalia') return true;
    if (x == 'sauna') return true;
    if (x == 'savanna') return true;
    if (x == 'saxtuba') return true;
    if (x == 'sayonara') return true;
    if (x == 'scabiosa') return true;
    if (x == 'scandia') return true;
    if (x == 'scapula') return true;
    if (x == 'scena') return true;
    if (x == 'schema') return true;
    if (x == 'schemata') return true;
    if (x == 'schizophrenia') return true;
    if (x == 'scholia') return true;
    if (x == 'schwa') return true;
    if (x == 'sciatica') return true;
    if (x == 'scilla') return true;
    if (x == 'sclera') return true;
    if (x == 'scleroma') return true;
    if (x == 'scleromata') return true;
    if (x == 'scolioma') return true;
    if (x == 'scopula') return true;
    if (x == 'scoria') return true;
    if (x == 'scotia') return true;
    if (x == 'scotoma') return true;
    if (x == 'scotomata') return true;
    if (x == 'scotopia') return true;
    if (x == 'scrofula') return true;
    if (x == 'scrota') return true;
    if (x == 'scuba') return true;
    if (x == 'scuta') return true;
    if (x == 'scutella') return true;
    if (x == 'sea') return true;
    if (x == 'sedilia') return true;
    if (x == 'semicoma') return true;
    if (x == 'semigala') return true;
    if (x == 'semina') return true;
    if (x == 'semolina') return true;
    if (x == 'seneca') return true;
    if (x == 'senega') return true;
    if (x == 'senhora') return true;
    if (x == 'senna') return true;
    if (x == 'senopia') return true;
    if (x == 'senora') return true;
    if (x == 'senorita') return true;
    if (x == 'sensa') return true;
    if (x == 'sensilla') return true;
    if (x == 'sensoria') return true;
    if (x == 'sepia') return true;
    if (x == 'septa') return true;
    if (x == 'septaria') return true;
    if (x == 'septuagesima') return true;
    if (x == 'sequela') return true;
    if (x == 'sequoia') return true;
    if (x == 'sera') return true;
    if (x == 'serenata') return true;
    if (x == 'seriema') return true;
    if (x == 'seringa') return true;
    if (x == 'serosa') return true;
    if (x == 'sestina') return true;
    if (x == 'seta') return true;
    if (x == 'shea') return true;
    if (x == 'shicksa') return true;
    if (x == 'shigella') return true;
    if (x == 'shiksa') return true;
    if (x == 'shillala') return true;
    if (x == 'shiva') return true;
    if (x == 'shortia') return true;
    if (x == 'sienna') return true;
    if (x == 'sierra') return true;
    if (x == 'siesta') return true;
    if (x == 'sieva') return true;
    if (x == 'sigma') return true;
    if (x == 'signora') return true;
    if (x == 'silesia') return true;
    if (x == 'silica') return true;
    if (x == 'siliqua') return true;
    if (x == 'silva') return true;
    if (x == 'sima') return true;
    if (x == 'simaruba') return true;
    if (x == 'simplicia') return true;
    if (x == 'sincipita') return true;
    if (x == 'sinfonia') return true;
    if (x == 'sinopia') return true;
    if (x == 'sirra') return true;
    if (x == 'sistra') return true;
    if (x == 'skua') return true;
    if (x == 'smegma') return true;
    if (x == 'soda') return true;
    if (x == 'sofa') return true;
    if (x == 'softa') return true;
    if (x == 'soja') return true;
    if (x == 'sola') return true;
    if (x == 'solaria') return true;
    if (x == 'solatia') return true;
    if (x == 'soma') return true;
    if (x == 'somata') return true;
    if (x == 'sonata') return true;
    if (x == 'sonatina') return true;
    if (x == 'sora') return true;
    if (x == 'soya') return true;
    if (x == 'spa') return true;
    if (x == 'spatula') return true;
    if (x == 'spectra') return true;
    if (x == 'specula') return true;
    if (x == 'spica') return true;
    if (x == 'spicula') return true;
    if (x == 'spinula') return true;
    if (x == 'spiraea') return true;
    if (x == 'spirea') return true;
    if (x == 'spirilla') return true;
    if (x == 'spirula') return true;
    if (x == 'splenia') return true;
    if (x == 'sputa') return true;
    if (x == 'squama') return true;
    if (x == 'squilla') return true;
    if (x == 'sraddha') return true;
    if (x == 'sradha') return true;
    if (x == 'stadia') return true;
    if (x == 'stamina') return true;
    if (x == 'stanza') return true;
    if (x == 'stapelia') return true;
    if (x == 'stasima') return true;
    if (x == 'stela') return true;
    if (x == 'stella') return true;
    if (x == 'stemma') return true;
    if (x == 'stemmata') return true;
    if (x == 'sterigma') return true;
    if (x == 'sterigmata') return true;
    if (x == 'sterna') return true;
    if (x == 'sthenia') return true;
    if (x == 'stigma') return true;
    if (x == 'stigmata') return true;
    if (x == 'stoa') return true;
    if (x == 'stoccata') return true;
    if (x == 'stokesia') return true;
    if (x == 'stoma') return true;
    if (x == 'stomata') return true;
    if (x == 'stomodea') return true;
    if (x == 'stotinka') return true;
    if (x == 'strata') return true;
    if (x == 'stretta') return true;
    if (x == 'stria') return true;
    if (x == 'strobila') return true;
    if (x == 'stroma') return true;
    if (x == 'stromata') return true;
    if (x == 'strontia') return true;
    if (x == 'struma') return true;
    if (x == 'stupa') return true;
    if (x == 'suba') return true;
    if (x == 'subarea') return true;
    if (x == 'subgenera') return true;
    if (x == 'subidea') return true;
    if (x == 'subpena') return true;
    if (x == 'subphyla') return true;
    if (x == 'subpoena') return true;
    if (x == 'suburbia') return true;
    if (x == 'succuba') return true;
    if (x == 'sudaria') return true;
    if (x == 'sulfa') return true;
    if (x == 'sulpha') return true;
    if (x == 'sultana') return true;
    if (x == 'summa') return true;
    if (x == 'sunna') return true;
    if (x == 'supra') return true;
    if (x == 'sura') return true;
    if (x == 'surra') return true;
    if (x == 'sutra') return true;
    if (x == 'sutta') return true;
    if (x == 'swastica') return true;
    if (x == 'swastika') return true;
    if (x == 'syconia') return true;
    if (x == 'sylva') return true;
    if (x == 'sympodia') return true;
    if (x == 'symposia') return true;
    if (x == 'syncytia') return true;
    if (x == 'synergia') return true;
    if (x == 'synovia') return true;
    if (x == 'synura') return true;
    if (x == 'syringa') return true;
    return nil;
  }
;
twiEscAG: TwiEscDataObject
  firstLetter = 'a'
  lastLetter  = 'g'
  isGoodWord(x) {
    if (x == 'aahing') return true;
    if (x == 'abandoning') return true;
    if (x == 'abashing') return true;
    if (x == 'abasing') return true;
    if (x == 'abating') return true;
    if (x == 'abbreviating') return true;
    if (x == 'abdicating') return true;
    if (x == 'abducing') return true;
    if (x == 'abducting') return true;
    if (x == 'abetting') return true;
    if (x == 'abhorring') return true;
    if (x == 'abiding') return true;
    if (x == 'abjuring') return true;
    if (x == 'ablating') return true;
    if (x == 'abnegating') return true;
    if (x == 'aboding') return true;
    if (x == 'abolishing') return true;
    if (x == 'abominating') return true;
    if (x == 'aborning') return true;
    if (x == 'aborting') return true;
    if (x == 'abounding') return true;
    if (x == 'abrading') return true;
    if (x == 'abreacting') return true;
    if (x == 'abridging') return true;
    if (x == 'abrogating') return true;
    if (x == 'abscessing') return true;
    if (x == 'abscising') return true;
    if (x == 'absconding') return true;
    if (x == 'absenting') return true;
    if (x == 'absolving') return true;
    if (x == 'absorbing') return true;
    if (x == 'abstaining') return true;
    if (x == 'absterging') return true;
    if (x == 'abstracting') return true;
    if (x == 'abstricting') return true;
    if (x == 'abusing') return true;
    if (x == 'abutting') return true;
    if (x == 'abying') return true;
    if (x == 'acceding') return true;
    if (x == 'accelerating') return true;
    if (x == 'accenting') return true;
    if (x == 'accentuating') return true;
    if (x == 'accepting') return true;
    if (x == 'accessing') return true;
    if (x == 'acclaiming') return true;
    if (x == 'acclimating') return true;
    if (x == 'accommodating') return true;
    if (x == 'accompanying') return true;
    if (x == 'accomplishing') return true;
    if (x == 'according') return true;
    if (x == 'accosting') return true;
    if (x == 'accounting') return true;
    if (x == 'accoutering') return true;
    if (x == 'accoutring') return true;
    if (x == 'accrediting') return true;
    if (x == 'accreting') return true;
    if (x == 'accruing') return true;
    if (x == 'accumulating') return true;
    if (x == 'accusing') return true;
    if (x == 'accustoming') return true;
    if (x == 'acerbating') return true;
    if (x == 'acetifying') return true;
    if (x == 'achieving') return true;
    if (x == 'aching') return true;
    if (x == 'acidifying') return true;
    if (x == 'acierating') return true;
    if (x == 'acing') return true;
    if (x == 'acknowledging') return true;
    if (x == 'acquainting') return true;
    if (x == 'acquiescing') return true;
    if (x == 'acquiring') return true;
    if (x == 'acquitting') return true;
    if (x == 'acting') return true;
    if (x == 'activating') return true;
    if (x == 'actualising') return true;
    if (x == 'actualizing') return true;
    if (x == 'actuating') return true;
    if (x == 'acylating') return true;
    if (x == 'adapting') return true;
    if (x == 'addicting') return true;
    if (x == 'adding') return true;
    if (x == 'addling') return true;
    if (x == 'addressing') return true;
    if (x == 'adducing') return true;
    if (x == 'adducting') return true;
    if (x == 'adeeming') return true;
    if (x == 'adhering') return true;
    if (x == 'adhibiting') return true;
    if (x == 'adjoining') return true;
    if (x == 'adjourning') return true;
    if (x == 'adjudging') return true;
    if (x == 'adjudicating') return true;
    if (x == 'adjuring') return true;
    if (x == 'adjusting') return true;
    if (x == 'admiring') return true;
    if (x == 'admitting') return true;
    if (x == 'admixing') return true;
    if (x == 'admonishing') return true;
    if (x == 'adopting') return true;
    if (x == 'adoring') return true;
    if (x == 'adorning') return true;
    if (x == 'adsorbing') return true;
    if (x == 'adulating') return true;
    if (x == 'adulterating') return true;
    if (x == 'advancing') return true;
    if (x == 'adverting') return true;
    if (x == 'advertising') return true;
    if (x == 'advising') return true;
    if (x == 'advocating') return true;
    if (x == 'aerating') return true;
    if (x == 'aerifying') return true;
    if (x == 'affecting') return true;
    if (x == 'affiancing') return true;
    if (x == 'affiliating') return true;
    if (x == 'affirming') return true;
    if (x == 'affixing') return true;
    if (x == 'afflicting') return true;
    if (x == 'affording') return true;
    if (x == 'afforesting') return true;
    if (x == 'affraying') return true;
    if (x == 'affrighting') return true;
    if (x == 'affronting') return true;
    if (x == 'agatizing') return true;
    if (x == 'ageing') return true;
    if (x == 'agelong') return true;
    if (x == 'agenizing') return true;
    if (x == 'aggrading') return true;
    if (x == 'aggrandising') return true;
    if (x == 'aggrandizing') return true;
    if (x == 'aggregating') return true;
    if (x == 'aggressing') return true;
    if (x == 'aggrieving') return true;
    if (x == 'aging') return true;
    if (x == 'agisting') return true;
    if (x == 'agitating') return true;
    if (x == 'agnising') return true;
    if (x == 'agnizing') return true;
    if (x == 'agog') return true;
    if (x == 'agonising') return true;
    if (x == 'agonizing') return true;
    if (x == 'agreeing') return true;
    if (x == 'aiding') return true;
    if (x == 'ailing') return true;
    if (x == 'aiming') return true;
    if (x == 'airbrushing') return true;
    if (x == 'airconditioning') return true;
    if (x == 'airdropping') return true;
    if (x == 'airing') return true;
    if (x == 'airlifting') return true;
    if (x == 'airmailing') return true;
    if (x == 'airproofing') return true;
    if (x == 'airthing') return true;
    if (x == 'airting') return true;
    if (x == 'alang') return true;
    if (x == 'alarming') return true;
    if (x == 'alaruming') return true;
    if (x == 'alerting') return true;
    if (x == 'alibiing') return true;
    if (x == 'alienating') return true;
    if (x == 'aliening') return true;
    if (x == 'alighting') return true;
    if (x == 'aligning') return true;
    if (x == 'alimenting') return true;
    if (x == 'alining') return true;
    if (x == 'alkalifying') return true;
    if (x == 'alkalising') return true;
    if (x == 'alkalizing') return true;
    if (x == 'alkylating') return true;
    if (x == 'allaying') return true;
    if (x == 'alleging') return true;
    if (x == 'alleviating') return true;
    if (x == 'allocating') return true;
    if (x == 'allotting') return true;
    if (x == 'allowing') return true;
    if (x == 'alloying') return true;
    if (x == 'alluding') return true;
    if (x == 'alluring') return true;
    if (x == 'allying') return true;
    if (x == 'almug') return true;
    if (x == 'along') return true;
    if (x == 'alphabeting') return true;
    if (x == 'alphabetising') return true;
    if (x == 'alphabetizing') return true;
    if (x == 'altering') return true;
    if (x == 'alternating') return true;
    if (x == 'amalgamating') return true;
    if (x == 'amassing') return true;
    if (x == 'amazing') return true;
    if (x == 'ambitioning') return true;
    if (x == 'ambling') return true;
    if (x == 'ambulating') return true;
    if (x == 'ambushing') return true;
    if (x == 'ameliorating') return true;
    if (x == 'amending') return true;
    if (x == 'amercing') return true;
    if (x == 'ammonifying') return true;
    if (x == 'amnestying') return true;
    if (x == 'among') return true;
    if (x == 'amortising') return true;
    if (x == 'amortizing') return true;
    if (x == 'amounting') return true;
    if (x == 'amplifying') return true;
    if (x == 'amputating') return true;
    if (x == 'amusing') return true;
    if (x == 'anaesthetising') return true;
    if (x == 'anagramming') return true;
    if (x == 'analog') return true;
    if (x == 'analysing') return true;
    if (x == 'analyzing') return true;
    if (x == 'anchoring') return true;
    if (x == 'anearing') return true;
    if (x == 'aneling') return true;
    if (x == 'anesthetizing') return true;
    if (x == 'angering') return true;
    if (x == 'angling') return true;
    if (x == 'anguishing') return true;
    if (x == 'angulating') return true;
    if (x == 'animating') return true;
    if (x == 'ankylosing') return true;
    if (x == 'annealing') return true;
    if (x == 'annexing') return true;
    if (x == 'annihilating') return true;
    if (x == 'annotating') return true;
    if (x == 'announcing') return true;
    if (x == 'annoying') return true;
    if (x == 'annulling') return true;
    if (x == 'anodising') return true;
    if (x == 'anodizing') return true;
    if (x == 'anointing') return true;
    if (x == 'answering') return true;
    if (x == 'antagonising') return true;
    if (x == 'antagonizing') return true;
    if (x == 'anteceding') return true;
    if (x == 'antedating') return true;
    if (x == 'anteing') return true;
    if (x == 'anteverting') return true;
    if (x == 'antheming') return true;
    if (x == 'anthropomorphising') return true;
    if (x == 'anthropomorphizing') return true;
    if (x == 'antiboxing') return true;
    if (x == 'anticipating') return true;
    if (x == 'anticking') return true;
    if (x == 'antidumping') return true;
    if (x == 'antieavesdropping') return true;
    if (x == 'antigambling') return true;
    if (x == 'antihunting') return true;
    if (x == 'antijamming') return true;
    if (x == 'antiking') return true;
    if (x == 'antilittering') return true;
    if (x == 'antilog') return true;
    if (x == 'antilynching') return true;
    if (x == 'anting') return true;
    if (x == 'antiprofiteering') return true;
    if (x == 'antiquing') return true;
    if (x == 'antiracing') return true;
    if (x == 'antiracketeering') return true;
    if (x == 'antishoplifting') return true;
    if (x == 'antismog') return true;
    if (x == 'antismoking') return true;
    if (x == 'antismuggling') return true;
    if (x == 'antispending') return true;
    if (x == 'antiwiretapping') return true;
    if (x == 'anviling') return true;
    if (x == 'anvilling') return true;
    if (x == 'anything') return true;
    if (x == 'aphorising') return true;
    if (x == 'aphorizing') return true;
    if (x == 'aping') return true;
    if (x == 'apolog') return true;
    if (x == 'apologising') return true;
    if (x == 'apologizing') return true;
    if (x == 'appalling') return true;
    if (x == 'appareling') return true;
    if (x == 'apparelling') return true;
    if (x == 'appealing') return true;
    if (x == 'appearing') return true;
    if (x == 'appeasing') return true;
    if (x == 'appending') return true;
    if (x == 'appetizing') return true;
    if (x == 'applauding') return true;
    if (x == 'appliqueing') return true;
    if (x == 'applying') return true;
    if (x == 'appointing') return true;
    if (x == 'apportioning') return true;
    if (x == 'apposing') return true;
    if (x == 'appraising') return true;
    if (x == 'appreciating') return true;
    if (x == 'apprehending') return true;
    if (x == 'apprenticing') return true;
    if (x == 'apprising') return true;
    if (x == 'apprizing') return true;
    if (x == 'approaching') return true;
    if (x == 'appropriating') return true;
    if (x == 'approving') return true;
    if (x == 'approximating') return true;
    if (x == 'aproning') return true;
    if (x == 'aquatinting') return true;
    if (x == 'arabising') return true;
    if (x == 'arabizing') return true;
    if (x == 'arbitrating') return true;
    if (x == 'arborizing') return true;
    if (x == 'arcading') return true;
    if (x == 'archaising') return true;
    if (x == 'archaizing') return true;
    if (x == 'arching') return true;
    if (x == 'archiving') return true;
    if (x == 'arcing') return true;
    if (x == 'arcking') return true;
    if (x == 'argling') return true;
    if (x == 'argufying') return true;
    if (x == 'arguing') return true;
    if (x == 'arising') return true;
    if (x == 'armaturing') return true;
    if (x == 'arming') return true;
    if (x == 'armoring') return true;
    if (x == 'armouring') return true;
    if (x == 'arointing') return true;
    if (x == 'arousing') return true;
    if (x == 'aroynting') return true;
    if (x == 'arraigning') return true;
    if (x == 'arranging') return true;
    if (x == 'arraying') return true;
    if (x == 'arresting') return true;
    if (x == 'arriving') return true;
    if (x == 'arrogating') return true;
    if (x == 'arrowing') return true;
    if (x == 'articling') return true;
    if (x == 'articulating') return true;
    if (x == 'ascending') return true;
    if (x == 'ascertaining') return true;
    if (x == 'ascribing') return true;
    if (x == 'ashing') return true;
    if (x == 'ashlaring') return true;
    if (x == 'ashlering') return true;
    if (x == 'asking') return true;
    if (x == 'asperating') return true;
    if (x == 'aspersing') return true;
    if (x == 'asphalting') return true;
    if (x == 'asphyxiating') return true;
    if (x == 'aspirating') return true;
    if (x == 'aspiring') return true;
    if (x == 'assagaiing') return true;
    if (x == 'assailing') return true;
    if (x == 'assassinating') return true;
    if (x == 'assaulting') return true;
    if (x == 'assaying') return true;
    if (x == 'assegaiing') return true;
    if (x == 'assembling') return true;
    if (x == 'assenting') return true;
    if (x == 'asserting') return true;
    if (x == 'assessing') return true;
    if (x == 'assigning') return true;
    if (x == 'assimilating') return true;
    if (x == 'assisting') return true;
    if (x == 'associating') return true;
    if (x == 'assoiling') return true;
    if (x == 'assorting') return true;
    if (x == 'assuaging') return true;
    if (x == 'assuming') return true;
    if (x == 'assuring') return true;
    if (x == 'asswaging') return true;
    if (x == 'asterisking') return true;
    if (x == 'astonishing') return true;
    if (x == 'astonying') return true;
    if (x == 'astounding') return true;
    if (x == 'astricting') return true;
    if (x == 'astringing') return true;
    if (x == 'atheling') return true;
    if (x == 'atomising') return true;
    if (x == 'atomizing') return true;
    if (x == 'atoning') return true;
    if (x == 'atrophying') return true;
    if (x == 'attaching') return true;
    if (x == 'attacking') return true;
    if (x == 'attaining') return true;
    if (x == 'attainting') return true;
    if (x == 'attempering') return true;
    if (x == 'attempting') return true;
    if (x == 'attending') return true;
    if (x == 'attenuating') return true;
    if (x == 'attesting') return true;
    if (x == 'attiring') return true;
    if (x == 'attorning') return true;
    if (x == 'attracting') return true;
    if (x == 'attributing') return true;
    if (x == 'attuning') return true;
    if (x == 'auctioning') return true;
    if (x == 'auding') return true;
    if (x == 'auditing') return true;
    if (x == 'auditioning') return true;
    if (x == 'augmenting') return true;
    if (x == 'auguring') return true;
    if (x == 'aureoling') return true;
    if (x == 'authenticating') return true;
    if (x == 'authoring') return true;
    if (x == 'authorising') return true;
    if (x == 'authorizing') return true;
    if (x == 'autographing') return true;
    if (x == 'autoing') return true;
    if (x == 'autolyzing') return true;
    if (x == 'automating') return true;
    if (x == 'autopsying') return true;
    if (x == 'availing') return true;
    if (x == 'avenging') return true;
    if (x == 'averaging') return true;
    if (x == 'averring') return true;
    if (x == 'averting') return true;
    if (x == 'avianizing') return true;
    if (x == 'aviating') return true;
    if (x == 'avoiding') return true;
    if (x == 'avouching') return true;
    if (x == 'avowing') return true;
    if (x == 'avulsing') return true;
    if (x == 'awaiting') return true;
    if (x == 'awakening') return true;
    if (x == 'awaking') return true;
    if (x == 'awarding') return true;
    if (x == 'aweing') return true;
    if (x == 'awing') return true;
    if (x == 'awning') return true;
    if (x == 'axing') return true;
    if (x == 'azotising') return true;
    if (x == 'azotizing') return true;
    return nil;
  }
;
twiEscGE: TwiEscDataObject
  firstLetter = 'g'
  lastLetter  = 'e'
  isGoodWord(x) {
    if (x == 'gabardine') return true;
    if (x == 'gabble') return true;
    if (x == 'gabelle') return true;
    if (x == 'gable') return true;
    if (x == 'gadarene') return true;
    if (x == 'gae') return true;
    if (x == 'gaffe') return true;
    if (x == 'gage') return true;
    if (x == 'gaggle') return true;
    if (x == 'gahnite') return true;
    if (x == 'gainable') return true;
    if (x == 'gale') return true;
    if (x == 'galeae') return true;
    if (x == 'galeate') return true;
    if (x == 'galenite') return true;
    if (x == 'galere') return true;
    if (x == 'galilee') return true;
    if (x == 'gallate') return true;
    if (x == 'gallstone') return true;
    if (x == 'galopade') return true;
    if (x == 'galore') return true;
    if (x == 'galoshe') return true;
    if (x == 'galvanise') return true;
    if (x == 'galvanize') return true;
    if (x == 'gambade') return true;
    if (x == 'gambe') return true;
    if (x == 'gamble') return true;
    if (x == 'gamboge') return true;
    if (x == 'game') return true;
    if (x == 'gamelike') return true;
    if (x == 'gamesome') return true;
    if (x == 'gamete') return true;
    if (x == 'gamine') return true;
    if (x == 'gamodeme') return true;
    if (x == 'gane') return true;
    if (x == 'gangrene') return true;
    if (x == 'gangue') return true;
    if (x == 'gantline') return true;
    if (x == 'gantlope') return true;
    if (x == 'ganymede') return true;
    if (x == 'gape') return true;
    if (x == 'garage') return true;
    if (x == 'garbage') return true;
    if (x == 'garble') return true;
    if (x == 'gargle') return true;
    if (x == 'gargoyle') return true;
    if (x == 'garnishee') return true;
    if (x == 'garote') return true;
    if (x == 'garotte') return true;
    if (x == 'garpike') return true;
    if (x == 'garrote') return true;
    if (x == 'garrotte') return true;
    if (x == 'gashouse') return true;
    if (x == 'gasogene') return true;
    if (x == 'gasolene') return true;
    if (x == 'gasoline') return true;
    if (x == 'gastrulae') return true;
    if (x == 'gate') return true;
    if (x == 'gatelike') return true;
    if (x == 'gauche') return true;
    if (x == 'gauge') return true;
    if (x == 'gauze') return true;
    if (x == 'gavage') return true;
    if (x == 'gave') return true;
    if (x == 'gavotte') return true;
    if (x == 'gawsie') return true;
    if (x == 'gaze') return true;
    if (x == 'gazelle') return true;
    if (x == 'gazette') return true;
    if (x == 'gazogene') return true;
    if (x == 'gearcase') return true;
    if (x == 'gee') return true;
    if (x == 'geese') return true;
    if (x == 'gelable') return true;
    if (x == 'gelate') return true;
    if (x == 'gelatine') return true;
    if (x == 'gelee') return true;
    if (x == 'geminate') return true;
    if (x == 'gemlike') return true;
    if (x == 'gemmae') return true;
    if (x == 'gemmate') return true;
    if (x == 'gemmule') return true;
    if (x == 'gemote') return true;
    if (x == 'gemstone') return true;
    if (x == 'gendarme') return true;
    if (x == 'gene') return true;
    if (x == 'generalise') return true;
    if (x == 'generalize') return true;
    if (x == 'generate') return true;
    if (x == 'generative') return true;
    if (x == 'genette') return true;
    if (x == 'genie') return true;
    if (x == 'genitive') return true;
    if (x == 'geniture') return true;
    if (x == 'genocide') return true;
    if (x == 'genome') return true;
    if (x == 'genotype') return true;
    if (x == 'genre') return true;
    if (x == 'gentile') return true;
    if (x == 'gentle') return true;
    if (x == 'gentrice') return true;
    if (x == 'genuine') return true;
    if (x == 'geode') return true;
    if (x == 'geophone') return true;
    if (x == 'geophyte') return true;
    if (x == 'geordie') return true;
    if (x == 'gerbille') return true;
    if (x == 'germane') return true;
    if (x == 'germfree') return true;
    if (x == 'germicide') return true;
    if (x == 'germinate') return true;
    if (x == 'gestate') return true;
    if (x == 'geste') return true;
    if (x == 'gesture') return true;
    if (x == 'getable') return true;
    if (x == 'gettable') return true;
    if (x == 'ghee') return true;
    if (x == 'ghillie') return true;
    if (x == 'ghostwrite') return true;
    if (x == 'ghostwrote') return true;
    if (x == 'gibbose') return true;
    if (x == 'gibbsite') return true;
    if (x == 'gibe') return true;
    if (x == 'gie') return true;
    if (x == 'gigabyte') return true;
    if (x == 'giggle') return true;
    if (x == 'gighe') return true;
    if (x == 'gigue') return true;
    if (x == 'gillie') return true;
    if (x == 'gingivae') return true;
    if (x == 'giraffe') return true;
    if (x == 'girasole') return true;
    if (x == 'girdle') return true;
    if (x == 'girlie') return true;
    if (x == 'gisarme') return true;
    if (x == 'give') return true;
    if (x == 'giveable') return true;
    if (x == 'glabellae') return true;
    if (x == 'glabrate') return true;
    if (x == 'glace') return true;
    if (x == 'glaciate') return true;
    if (x == 'glade') return true;
    if (x == 'gladiate') return true;
    if (x == 'gladsome') return true;
    if (x == 'glaire') return true;
    if (x == 'glaive') return true;
    if (x == 'glamorize') return true;
    if (x == 'glance') return true;
    if (x == 'glandule') return true;
    if (x == 'glare') return true;
    if (x == 'glassie') return true;
    if (x == 'glassine') return true;
    if (x == 'glassware') return true;
    if (x == 'glaze') return true;
    if (x == 'gleanable') return true;
    if (x == 'glebae') return true;
    if (x == 'glebe') return true;
    if (x == 'glede') return true;
    if (x == 'glee') return true;
    if (x == 'gleesome') return true;
    if (x == 'glenlike') return true;
    if (x == 'gliadine') return true;
    if (x == 'glide') return true;
    if (x == 'glime') return true;
    if (x == 'glimpse') return true;
    if (x == 'glissade') return true;
    if (x == 'globate') return true;
    if (x == 'globe') return true;
    if (x == 'globose') return true;
    if (x == 'globule') return true;
    if (x == 'gloriole') return true;
    if (x == 'glossae') return true;
    if (x == 'glosseme') return true;
    if (x == 'glove') return true;
    if (x == 'gloze') return true;
    if (x == 'glucose') return true;
    if (x == 'glue') return true;
    if (x == 'gluelike') return true;
    if (x == 'glume') return true;
    if (x == 'glycerine') return true;
    if (x == 'glycine') return true;
    if (x == 'gnathite') return true;
    if (x == 'gnatlike') return true;
    if (x == 'gnawable') return true;
    if (x == 'gnome') return true;
    if (x == 'goadlike') return true;
    if (x == 'goalie') return true;
    if (x == 'goatee') return true;
    if (x == 'goatlike') return true;
    if (x == 'gobble') return true;
    if (x == 'gobonee') return true;
    if (x == 'godlike') return true;
    if (x == 'goethite') return true;
    if (x == 'goggle') return true;
    if (x == 'goitre') return true;
    if (x == 'goldeye') return true;
    if (x == 'gone') return true;
    if (x == 'gonglike') return true;
    if (x == 'gonocyte') return true;
    if (x == 'gonopore') return true;
    if (x == 'goodbye') return true;
    if (x == 'goodwife') return true;
    if (x == 'goonie') return true;
    if (x == 'goose') return true;
    if (x == 'gore') return true;
    if (x == 'gorge') return true;
    if (x == 'gorse') return true;
    if (x == 'gothite') return true;
    if (x == 'gouache') return true;
    if (x == 'gouge') return true;
    if (x == 'gourde') return true;
    if (x == 'grabble') return true;
    if (x == 'grace') return true;
    if (x == 'gracile') return true;
    if (x == 'grackle') return true;
    if (x == 'gradable') return true;
    if (x == 'gradate') return true;
    if (x == 'grade') return true;
    if (x == 'gradine') return true;
    if (x == 'graduate') return true;
    if (x == 'graecise') return true;
    if (x == 'graecize') return true;
    if (x == 'graftage') return true;
    if (x == 'gramarye') return true;
    if (x == 'gramme') return true;
    if (x == 'grandame') return true;
    if (x == 'grandee') return true;
    if (x == 'grandiose') return true;
    if (x == 'grange') return true;
    if (x == 'granite') return true;
    if (x == 'grannie') return true;
    if (x == 'grantee') return true;
    if (x == 'granulate') return true;
    if (x == 'granule') return true;
    if (x == 'grape') return true;
    if (x == 'grapevine') return true;
    if (x == 'grapheme') return true;
    if (x == 'graphite') return true;
    if (x == 'grapline') return true;
    if (x == 'grapple') return true;
    if (x == 'grate') return true;
    if (x == 'gratitude') return true;
    if (x == 'grave') return true;
    if (x == 'gravestone') return true;
    if (x == 'gravidae') return true;
    if (x == 'gravitate') return true;
    if (x == 'gravitative') return true;
    if (x == 'gravure') return true;
    if (x == 'grazable') return true;
    if (x == 'graze') return true;
    if (x == 'grease') return true;
    if (x == 'greave') return true;
    if (x == 'grebe') return true;
    if (x == 'grecice') return true;
    if (x == 'grecize') return true;
    if (x == 'gree') return true;
    if (x == 'greegree') return true;
    if (x == 'greenhouse') return true;
    if (x == 'greige') return true;
    if (x == 'gremmie') return true;
    if (x == 'grenade') return true;
    if (x == 'grewsome') return true;
    if (x == 'gribble') return true;
    if (x == 'griddle') return true;
    if (x == 'gride') return true;
    if (x == 'grievance') return true;
    if (x == 'grieve') return true;
    if (x == 'griffe') return true;
    if (x == 'grillade') return true;
    if (x == 'grillage') return true;
    if (x == 'grille') return true;
    if (x == 'grilse') return true;
    if (x == 'grimace') return true;
    if (x == 'grime') return true;
    if (x == 'grindstone') return true;
    if (x == 'gripe') return true;
    if (x == 'grippe') return true;
    if (x == 'gripple') return true;
    if (x == 'grisette') return true;
    if (x == 'gristle') return true;
    if (x == 'grizzle') return true;
    if (x == 'groove') return true;
    if (x == 'grope') return true;
    if (x == 'grotesque') return true;
    if (x == 'groupie') return true;
    if (x == 'grouse') return true;
    if (x == 'grove') return true;
    if (x == 'growable') return true;
    if (x == 'groyne') return true;
    if (x == 'grubstake') return true;
    if (x == 'grudge') return true;
    if (x == 'gruesome') return true;
    if (x == 'grumble') return true;
    if (x == 'grume') return true;
    if (x == 'grumose') return true;
    if (x == 'grumphie') return true;
    if (x == 'gruntle') return true;
    if (x == 'grushie') return true;
    if (x == 'guanase') return true;
    if (x == 'guanine') return true;
    if (x == 'guarantee') return true;
    if (x == 'guardhouse') return true;
    if (x == 'guayule') return true;
    if (x == 'gude') return true;
    if (x == 'guggle') return true;
    if (x == 'guidable') return true;
    if (x == 'guidance') return true;
    if (x == 'guide') return true;
    if (x == 'guideline') return true;
    if (x == 'guile') return true;
    if (x == 'guillotine') return true;
    if (x == 'guimpe') return true;
    if (x == 'guipure') return true;
    if (x == 'guise') return true;
    if (x == 'gulflike') return true;
    if (x == 'gullable') return true;
    if (x == 'gullible') return true;
    if (x == 'gumlike') return true;
    if (x == 'gummite') return true;
    if (x == 'gummose') return true;
    if (x == 'gumshoe') return true;
    if (x == 'gumtree') return true;
    if (x == 'gunfire') return true;
    if (x == 'gunwale') return true;
    if (x == 'gurge') return true;
    if (x == 'gurgle') return true;
    if (x == 'gustable') return true;
    if (x == 'gutlike') return true;
    if (x == 'guttae') return true;
    if (x == 'guttate') return true;
    if (x == 'guttle') return true;
    if (x == 'guzzle') return true;
    if (x == 'gybe') return true;
    if (x == 'gyrate') return true;
    if (x == 'gyre') return true;
    if (x == 'gyrene') return true;
    if (x == 'gyroscope') return true;
    if (x == 'gyrose') return true;
    if (x == 'gyve') return true;
    return nil;
  }
;
twiEscES: TwiEscDataObject
  firstLetter = 'e'
  lastLetter  = 's'
  isGoodWord(x) {
    if (x < 'el') {                     // EA-EK
      if (isGoodWordEA(x)) return true;
      else return nil;
    }
    else if (x < 'en') {                // EL-EM
      if (isGoodWordEL(x)) return true;
      else return nil;
    }
    else if (x < 'eo') {                // EN
      if (isGoodWordEN(x)) return true;
      else return nil;
    }
    else if (x < 'ev') {                // EO-EU
      if (isGoodWordEO(x)) return true;
      else return nil;
    }
    else {                              // EV-EZ
      if (isGoodWordEV(x)) return true;
      else return nil;
    }
  }
  isGoodWordEA(x) {
    if (x == 'eagerness') return true;
    if (x == 'eagernesses') return true;
    if (x == 'eagers') return true;
    if (x == 'eagles') return true;
    if (x == 'eaglets') return true;
    if (x == 'eagres') return true;
    if (x == 'eanlings') return true;
    if (x == 'earaches') return true;
    if (x == 'eardrops') return true;
    if (x == 'eardrums') return true;
    if (x == 'earflaps') return true;
    if (x == 'earfuls') return true;
    if (x == 'earings') return true;
    if (x == 'earlaps') return true;
    if (x == 'earldoms') return true;
    if (x == 'earless') return true;
    if (x == 'earlobes') return true;
    if (x == 'earlocks') return true;
    if (x == 'earls') return true;
    if (x == 'earlships') return true;
    if (x == 'earmarks') return true;
    if (x == 'earmuffs') return true;
    if (x == 'earners') return true;
    if (x == 'earnestness') return true;
    if (x == 'earnestnesses') return true;
    if (x == 'earnests') return true;
    if (x == 'earnings') return true;
    if (x == 'earns') return true;
    if (x == 'earphones') return true;
    if (x == 'earpieces') return true;
    if (x == 'earplugs') return true;
    if (x == 'earrings') return true;
    if (x == 'ears') return true;
    if (x == 'earshots') return true;
    if (x == 'earstones') return true;
    if (x == 'earthenwares') return true;
    if (x == 'earthiness') return true;
    if (x == 'earthinesses') return true;
    if (x == 'earthliness') return true;
    if (x == 'earthlinesses') return true;
    if (x == 'earthnuts') return true;
    if (x == 'earthpeas') return true;
    if (x == 'earthquakes') return true;
    if (x == 'earths') return true;
    if (x == 'earthsets') return true;
    if (x == 'earthwards') return true;
    if (x == 'earthworms') return true;
    if (x == 'earwaxes') return true;
    if (x == 'earwigs') return true;
    if (x == 'earworms') return true;
    if (x == 'easels') return true;
    if (x == 'easements') return true;
    if (x == 'eases') return true;
    if (x == 'easies') return true;
    if (x == 'easiness') return true;
    if (x == 'easinesses') return true;
    if (x == 'easterlies') return true;
    if (x == 'easters') return true;
    if (x == 'eastings') return true;
    if (x == 'easts') return true;
    if (x == 'eastwards') return true;
    if (x == 'eatables') return true;
    if (x == 'eateries') return true;
    if (x == 'eaters') return true;
    if (x == 'eatings') return true;
    if (x == 'eats') return true;
    if (x == 'eaves') return true;
    if (x == 'eavesdroppers') return true;
    if (x == 'eavesdrops') return true;
    if (x == 'ebbets') return true;
    if (x == 'ebbs') return true;
    if (x == 'ebonies') return true;
    if (x == 'ebonises') return true;
    if (x == 'ebonites') return true;
    if (x == 'ebonizes') return true;
    if (x == 'ebons') return true;
    if (x == 'ecartes') return true;
    if (x == 'ecbolics') return true;
    if (x == 'eccentricities') return true;
    if (x == 'eccentrics') return true;
    if (x == 'ecclesiastics') return true;
    if (x == 'ecdyses') return true;
    if (x == 'ecdysis') return true;
    if (x == 'ecdysones') return true;
    if (x == 'ecdysons') return true;
    if (x == 'ecesis') return true;
    if (x == 'ecesises') return true;
    if (x == 'echards') return true;
    if (x == 'echelons') return true;
    if (x == 'eches') return true;
    if (x == 'echidnas') return true;
    if (x == 'echinoids') return true;
    if (x == 'echinus') return true;
    if (x == 'echoers') return true;
    if (x == 'echoes') return true;
    if (x == 'echoisms') return true;
    if (x == 'echoless') return true;
    if (x == 'eclairs') return true;
    if (x == 'eclats') return true;
    if (x == 'eclectics') return true;
    if (x == 'eclipses') return true;
    if (x == 'eclipsis') return true;
    if (x == 'eclipsises') return true;
    if (x == 'ecliptics') return true;
    if (x == 'eclogites') return true;
    if (x == 'eclogues') return true;
    if (x == 'eclosions') return true;
    if (x == 'ecoles') return true;
    if (x == 'ecologies') return true;
    if (x == 'ecologists') return true;
    if (x == 'economics') return true;
    if (x == 'economies') return true;
    if (x == 'economises') return true;
    if (x == 'economists') return true;
    if (x == 'economizes') return true;
    if (x == 'ecotones') return true;
    if (x == 'ecotypes') return true;
    if (x == 'ecraseurs') return true;
    if (x == 'ecrus') return true;
    if (x == 'ecstasies') return true;
    if (x == 'ecstatics') return true;
    if (x == 'ectases') return true;
    if (x == 'ectasis') return true;
    if (x == 'ectoderms') return true;
    if (x == 'ectomeres') return true;
    if (x == 'ectopias') return true;
    if (x == 'ectosarcs') return true;
    if (x == 'ectozoans') return true;
    if (x == 'ectypes') return true;
    if (x == 'ecus') return true;
    if (x == 'eczemas') return true;
    if (x == 'edacious') return true;
    if (x == 'edacities') return true;
    if (x == 'eddies') return true;
    if (x == 'eddoes') return true;
    if (x == 'edemas') return true;
    if (x == 'edentates') return true;
    if (x == 'edgeless') return true;
    if (x == 'edgers') return true;
    if (x == 'edges') return true;
    if (x == 'edgeways') return true;
    if (x == 'edginess') return true;
    if (x == 'edginesses') return true;
    if (x == 'edgings') return true;
    if (x == 'edhs') return true;
    if (x == 'edibilities') return true;
    if (x == 'edibles') return true;
    if (x == 'edicts') return true;
    if (x == 'edifications') return true;
    if (x == 'edifices') return true;
    if (x == 'edifiers') return true;
    if (x == 'edifies') return true;
    if (x == 'ediles') return true;
    if (x == 'editions') return true;
    if (x == 'editorialises') return true;
    if (x == 'editorializes') return true;
    if (x == 'editorials') return true;
    if (x == 'editors') return true;
    if (x == 'editress') return true;
    if (x == 'editresses') return true;
    if (x == 'edits') return true;
    if (x == 'educables') return true;
    if (x == 'educates') return true;
    if (x == 'educations') return true;
    if (x == 'educators') return true;
    if (x == 'educes') return true;
    if (x == 'eductions') return true;
    if (x == 'eductors') return true;
    if (x == 'educts') return true;
    if (x == 'eelgrass') return true;
    if (x == 'eelgrasses') return true;
    if (x == 'eelpouts') return true;
    if (x == 'eels') return true;
    if (x == 'eelworms') return true;
    if (x == 'eeriness') return true;
    if (x == 'eerinesses') return true;
    if (x == 'effacements') return true;
    if (x == 'effacers') return true;
    if (x == 'effaces') return true;
    if (x == 'effecters') return true;
    if (x == 'effectiveness') return true;
    if (x == 'effectors') return true;
    if (x == 'effects') return true;
    if (x == 'effectualness') return true;
    if (x == 'effectualnesses') return true;
    if (x == 'effeminacies') return true;
    if (x == 'effendis') return true;
    if (x == 'efferents') return true;
    if (x == 'effervescences') return true;
    if (x == 'effervesces') return true;
    if (x == 'efficacies') return true;
    if (x == 'efficacious') return true;
    if (x == 'efficiencies') return true;
    if (x == 'effigies') return true;
    if (x == 'effluents') return true;
    if (x == 'effluxes') return true;
    if (x == 'effortless') return true;
    if (x == 'efforts') return true;
    if (x == 'effs') return true;
    if (x == 'effulges') return true;
    if (x == 'effuses') return true;
    if (x == 'effusions') return true;
    if (x == 'efs') return true;
    if (x == 'efts') return true;
    if (x == 'eftsoons') return true;
    if (x == 'egads') return true;
    if (x == 'egalites') return true;
    if (x == 'egers') return true;
    if (x == 'egestions') return true;
    if (x == 'egests') return true;
    if (x == 'eggars') return true;
    if (x == 'eggcups') return true;
    if (x == 'eggers') return true;
    if (x == 'eggheads') return true;
    if (x == 'eggnogs') return true;
    if (x == 'eggplants') return true;
    if (x == 'eggs') return true;
    if (x == 'eggshells') return true;
    if (x == 'egis') return true;
    if (x == 'egises') return true;
    if (x == 'eglateres') return true;
    if (x == 'egoisms') return true;
    if (x == 'egoists') return true;
    if (x == 'egomanias') return true;
    if (x == 'egos') return true;
    if (x == 'egotisms') return true;
    if (x == 'egotists') return true;
    if (x == 'egregious') return true;
    if (x == 'egress') return true;
    if (x == 'egresses') return true;
    if (x == 'egrets') return true;
    if (x == 'eiderdowns') return true;
    if (x == 'eiders') return true;
    if (x == 'eidolons') return true;
    if (x == 'eidos') return true;
    if (x == 'eighteens') return true;
    if (x == 'eighteenths') return true;
    if (x == 'eighths') return true;
    if (x == 'eighties') return true;
    if (x == 'eightieths') return true;
    if (x == 'eights') return true;
    if (x == 'eightvos') return true;
    if (x == 'eikones') return true;
    if (x == 'eikons') return true;
    if (x == 'einkorns') return true;
    if (x == 'ejaculates') return true;
    if (x == 'ejaculations') return true;
    if (x == 'ejections') return true;
    if (x == 'ejectives') return true;
    if (x == 'ejectors') return true;
    if (x == 'ejects') return true;
    if (x == 'ekes') return true;
    if (x == 'ekistics') return true;
    if (x == 'ektexines') return true;
    return nil;
  }
  isGoodWordEL(x) {
    if (x == 'elaborateness') return true;
    if (x == 'elaboratenesses') return true;
    if (x == 'elaborates') return true;
    if (x == 'elaborations') return true;
    if (x == 'elains') return true;
    if (x == 'elands') return true;
    if (x == 'elans') return true;
    if (x == 'elapids') return true;
    if (x == 'elapses') return true;
    if (x == 'elastases') return true;
    if (x == 'elasticities') return true;
    if (x == 'elastics') return true;
    if (x == 'elastins') return true;
    if (x == 'elaterids') return true;
    if (x == 'elaterins') return true;
    if (x == 'elaters') return true;
    if (x == 'elates') return true;
    if (x == 'elations') return true;
    if (x == 'elatives') return true;
    if (x == 'elbows') return true;
    if (x == 'elderberries') return true;
    if (x == 'elders') return true;
    if (x == 'elds') return true;
    if (x == 'elections') return true;
    if (x == 'electives') return true;
    if (x == 'electorates') return true;
    if (x == 'electors') return true;
    if (x == 'electrets') return true;
    if (x == 'electricians') return true;
    if (x == 'electricities') return true;
    if (x == 'electrics') return true;
    if (x == 'electrifications') return true;
    if (x == 'electrocardiograms') return true;
    if (x == 'electrocardiographs') return true;
    if (x == 'electrocutes') return true;
    if (x == 'electrocutions') return true;
    if (x == 'electrodes') return true;
    if (x == 'electrolysis') return true;
    if (x == 'electrolysises') return true;
    if (x == 'electrolytes') return true;
    if (x == 'electromagnets') return true;
    if (x == 'electronics') return true;
    if (x == 'electrons') return true;
    if (x == 'electroplates') return true;
    if (x == 'electros') return true;
    if (x == 'electrums') return true;
    if (x == 'elects') return true;
    if (x == 'elegances') return true;
    if (x == 'elegancies') return true;
    if (x == 'elegiacs') return true;
    if (x == 'elegies') return true;
    if (x == 'elegises') return true;
    if (x == 'elegists') return true;
    if (x == 'elegits') return true;
    if (x == 'elegizes') return true;
    if (x == 'elements') return true;
    if (x == 'elemis') return true;
    if (x == 'elenchus') return true;
    if (x == 'elephants') return true;
    if (x == 'elevates') return true;
    if (x == 'elevations') return true;
    if (x == 'elevators') return true;
    if (x == 'elevens') return true;
    if (x == 'elevenths') return true;
    if (x == 'elevons') return true;
    if (x == 'elfins') return true;
    if (x == 'elflocks') return true;
    if (x == 'elicitors') return true;
    if (x == 'elicits') return true;
    if (x == 'elides') return true;
    if (x == 'eligibilities') return true;
    if (x == 'eligibles') return true;
    if (x == 'eliminates') return true;
    if (x == 'eliminations') return true;
    if (x == 'elisions') return true;
    if (x == 'elites') return true;
    if (x == 'elitisms') return true;
    if (x == 'elitists') return true;
    if (x == 'elixirs') return true;
    if (x == 'elkhounds') return true;
    if (x == 'elks') return true;
    if (x == 'ellipses') return true;
    if (x == 'ellipsis') return true;
    if (x == 'ells') return true;
    if (x == 'elms') return true;
    if (x == 'elocutions') return true;
    if (x == 'elodeas') return true;
    if (x == 'eloigners') return true;
    if (x == 'eloigns') return true;
    if (x == 'eloiners') return true;
    if (x == 'eloins') return true;
    if (x == 'elongates') return true;
    if (x == 'elongations') return true;
    if (x == 'elopers') return true;
    if (x == 'elopes') return true;
    if (x == 'els') return true;
    if (x == 'eluants') return true;
    if (x == 'eluates') return true;
    if (x == 'elucidates') return true;
    if (x == 'elucidations') return true;
    if (x == 'eluders') return true;
    if (x == 'eludes') return true;
    if (x == 'eluents') return true;
    if (x == 'elusions') return true;
    if (x == 'elusiveness') return true;
    if (x == 'elusivenesses') return true;
    if (x == 'elutes') return true;
    if (x == 'elutions') return true;
    if (x == 'eluviates') return true;
    if (x == 'eluviums') return true;
    if (x == 'elvers') return true;
    if (x == 'elves') return true;
    if (x == 'elytrous') return true;
    if (x == 'emaciates') return true;
    if (x == 'emaciations') return true;
    if (x == 'emanates') return true;
    if (x == 'emanations') return true;
    if (x == 'emanators') return true;
    if (x == 'emancipatations') return true;
    if (x == 'emancipates') return true;
    if (x == 'emancipations') return true;
    if (x == 'emasculatations') return true;
    if (x == 'emasculates') return true;
    if (x == 'embalmers') return true;
    if (x == 'embalms') return true;
    if (x == 'embankments') return true;
    if (x == 'embanks') return true;
    if (x == 'embargos') return true;
    if (x == 'embarkations') return true;
    if (x == 'embarks') return true;
    if (x == 'embarrass') return true;
    if (x == 'embarrasses') return true;
    if (x == 'embarrassments') return true;
    if (x == 'embars') return true;
    if (x == 'embassies') return true;
    if (x == 'embattles') return true;
    if (x == 'embays') return true;
    if (x == 'embeds') return true;
    if (x == 'embellishes') return true;
    if (x == 'embellishments') return true;
    if (x == 'embers') return true;
    if (x == 'embezzlements') return true;
    if (x == 'embezzlers') return true;
    if (x == 'embezzles') return true;
    if (x == 'embitters') return true;
    if (x == 'emblazers') return true;
    if (x == 'emblazes') return true;
    if (x == 'emblazons') return true;
    if (x == 'emblems') return true;
    if (x == 'embodiers') return true;
    if (x == 'embodies') return true;
    if (x == 'embodiments') return true;
    if (x == 'emboldens') return true;
    if (x == 'embolies') return true;
    if (x == 'embolisms') return true;
    if (x == 'embolus') return true;
    if (x == 'emborders') return true;
    if (x == 'embosks') return true;
    if (x == 'embosoms') return true;
    if (x == 'emboss') return true;
    if (x == 'embossers') return true;
    if (x == 'embosses') return true;
    if (x == 'embowels') return true;
    if (x == 'embowers') return true;
    if (x == 'embows') return true;
    if (x == 'embracers') return true;
    if (x == 'embraces') return true;
    if (x == 'embroiders') return true;
    if (x == 'embroils') return true;
    if (x == 'embrowns') return true;
    if (x == 'embrues') return true;
    if (x == 'embrutes') return true;
    if (x == 'embryons') return true;
    if (x == 'embryos') return true;
    if (x == 'emcees') return true;
    if (x == 'emeerates') return true;
    if (x == 'emeers') return true;
    if (x == 'emendates') return true;
    if (x == 'emendations') return true;
    if (x == 'emenders') return true;
    if (x == 'emends') return true;
    if (x == 'emeralds') return true;
    if (x == 'emergences') return true;
    if (x == 'emergencies') return true;
    if (x == 'emergents') return true;
    if (x == 'emerges') return true;
    if (x == 'emeries') return true;
    if (x == 'emeritus') return true;
    if (x == 'emerods') return true;
    if (x == 'emeroids') return true;
    if (x == 'emersions') return true;
    if (x == 'emes') return true;
    if (x == 'emeses') return true;
    if (x == 'emesis') return true;
    if (x == 'emetics') return true;
    if (x == 'emetines') return true;
    if (x == 'emetins') return true;
    if (x == 'emeus') return true;
    if (x == 'emeutes') return true;
    if (x == 'emigrants') return true;
    if (x == 'emigrates') return true;
    if (x == 'emigrations') return true;
    if (x == 'emigres') return true;
    if (x == 'eminences') return true;
    if (x == 'eminencies') return true;
    if (x == 'emirates') return true;
    if (x == 'emirs') return true;
    if (x == 'emissaries') return true;
    if (x == 'emissions') return true;
    if (x == 'emits') return true;
    if (x == 'emitters') return true;
    if (x == 'emmers') return true;
    if (x == 'emmets') return true;
    if (x == 'emodins') return true;
    if (x == 'emoluments') return true;
    if (x == 'emoters') return true;
    if (x == 'emotes') return true;
    if (x == 'emotions') return true;
    if (x == 'empalers') return true;
    if (x == 'empales') return true;
    if (x == 'empanels') return true;
    if (x == 'empathies') return true;
    if (x == 'emperies') return true;
    if (x == 'emperors') return true;
    if (x == 'emphases') return true;
    if (x == 'emphasis') return true;
    if (x == 'emphasises') return true;
    if (x == 'emphasizes') return true;
    if (x == 'emphysemas') return true;
    if (x == 'empires') return true;
    if (x == 'empirics') return true;
    if (x == 'emplaces') return true;
    if (x == 'emplanes') return true;
    if (x == 'employees') return true;
    if (x == 'employers') return true;
    if (x == 'employes') return true;
    if (x == 'employments') return true;
    if (x == 'employs') return true;
    if (x == 'empoisons') return true;
    if (x == 'emporiums') return true;
    if (x == 'empowers') return true;
    if (x == 'empress') return true;
    if (x == 'empresses') return true;
    if (x == 'emprises') return true;
    if (x == 'emprizes') return true;
    if (x == 'emptiers') return true;
    if (x == 'empties') return true;
    if (x == 'emptiness') return true;
    if (x == 'emptinesses') return true;
    if (x == 'emptings') return true;
    if (x == 'emptins') return true;
    if (x == 'empurples') return true;
    if (x == 'empyemas') return true;
    if (x == 'empyreans') return true;
    if (x == 'ems') return true;
    if (x == 'emulates') return true;
    if (x == 'emulations') return true;
    if (x == 'emulators') return true;
    if (x == 'emulous') return true;
    if (x == 'emulsifications') return true;
    if (x == 'emulsifiers') return true;
    if (x == 'emulsifies') return true;
    if (x == 'emulsions') return true;
    if (x == 'emulsoids') return true;
    if (x == 'emus') return true;
    if (x == 'emydes') return true;
    if (x == 'emyds') return true;
    return nil;
  }
  isGoodWordEN(x) {
    if (x == 'enablers') return true;
    if (x == 'enables') return true;
    if (x == 'enactments') return true;
    if (x == 'enactors') return true;
    if (x == 'enacts') return true;
    if (x == 'enamelers') return true;
    if (x == 'enamels') return true;
    if (x == 'enamines') return true;
    if (x == 'enamors') return true;
    if (x == 'enamours') return true;
    if (x == 'enates') return true;
    if (x == 'enations') return true;
    if (x == 'encages') return true;
    if (x == 'encampments') return true;
    if (x == 'encamps') return true;
    if (x == 'encases') return true;
    if (x == 'encashes') return true;
    if (x == 'enceintes') return true;
    if (x == 'encephalitides') return true;
    if (x == 'encephalitis') return true;
    if (x == 'enchains') return true;
    if (x == 'enchanters') return true;
    if (x == 'enchantments') return true;
    if (x == 'enchantress') return true;
    if (x == 'enchantresses') return true;
    if (x == 'enchants') return true;
    if (x == 'enchasers') return true;
    if (x == 'enchases') return true;
    if (x == 'encinas') return true;
    if (x == 'enciphers') return true;
    if (x == 'encircles') return true;
    if (x == 'enclasps') return true;
    if (x == 'enclaves') return true;
    if (x == 'enclitics') return true;
    if (x == 'enclosers') return true;
    if (x == 'encloses') return true;
    if (x == 'enclosures') return true;
    if (x == 'encoders') return true;
    if (x == 'encodes') return true;
    if (x == 'encomiums') return true;
    if (x == 'encompass') return true;
    if (x == 'encompasses') return true;
    if (x == 'encores') return true;
    if (x == 'encounters') return true;
    if (x == 'encouragements') return true;
    if (x == 'encourages') return true;
    if (x == 'encroaches') return true;
    if (x == 'encroachments') return true;
    if (x == 'encrusts') return true;
    if (x == 'encrypts') return true;
    if (x == 'encumberances') return true;
    if (x == 'encumbers') return true;
    if (x == 'encyclicals') return true;
    if (x == 'encyclics') return true;
    if (x == 'encyclopaedias') return true;
    if (x == 'encyclopedias') return true;
    if (x == 'encysts') return true;
    if (x == 'endamages') return true;
    if (x == 'endamebas') return true;
    if (x == 'endangers') return true;
    if (x == 'endarchies') return true;
    if (x == 'endbrains') return true;
    if (x == 'endearments') return true;
    if (x == 'endears') return true;
    if (x == 'endeavors') return true;
    if (x == 'endemics') return true;
    if (x == 'endemisms') return true;
    if (x == 'enders') return true;
    if (x == 'endexines') return true;
    if (x == 'endings') return true;
    if (x == 'endites') return true;
    if (x == 'endives') return true;
    if (x == 'endleaves') return true;
    if (x == 'endless') return true;
    if (x == 'endocarps') return true;
    if (x == 'endoderms') return true;
    if (x == 'endodontics') return true;
    if (x == 'endogamies') return true;
    if (x == 'endogenies') return true;
    if (x == 'endogens') return true;
    if (x == 'endopods') return true;
    if (x == 'endorsees') return true;
    if (x == 'endorsements') return true;
    if (x == 'endorsers') return true;
    if (x == 'endorses') return true;
    if (x == 'endorsors') return true;
    if (x == 'endosarcs') return true;
    if (x == 'endosmos') return true;
    if (x == 'endosmoses') return true;
    if (x == 'endosomes') return true;
    if (x == 'endowers') return true;
    if (x == 'endowments') return true;
    if (x == 'endows') return true;
    if (x == 'endpapers') return true;
    if (x == 'endplates') return true;
    if (x == 'endrins') return true;
    if (x == 'ends') return true;
    if (x == 'endues') return true;
    if (x == 'endurances') return true;
    if (x == 'endures') return true;
    if (x == 'enduros') return true;
    if (x == 'endways') return true;
    if (x == 'enemas') return true;
    if (x == 'enemies') return true;
    if (x == 'energids') return true;
    if (x == 'energies') return true;
    if (x == 'energises') return true;
    if (x == 'energizes') return true;
    if (x == 'enervates') return true;
    if (x == 'enervations') return true;
    if (x == 'enfaces') return true;
    if (x == 'enfeebles') return true;
    if (x == 'enfeoffs') return true;
    if (x == 'enfetters') return true;
    if (x == 'enfevers') return true;
    if (x == 'enfilades') return true;
    if (x == 'enflames') return true;
    if (x == 'enfolders') return true;
    if (x == 'enfolds') return true;
    if (x == 'enforcements') return true;
    if (x == 'enforcers') return true;
    if (x == 'enforces') return true;
    if (x == 'enframes') return true;
    if (x == 'enfranchisements') return true;
    if (x == 'enfranchises') return true;
    if (x == 'engagements') return true;
    if (x == 'engagers') return true;
    if (x == 'engages') return true;
    if (x == 'engenders') return true;
    if (x == 'engilds') return true;
    if (x == 'engineerings') return true;
    if (x == 'engineers') return true;
    if (x == 'engineries') return true;
    if (x == 'engines') return true;
    if (x == 'enginous') return true;
    if (x == 'engirdles') return true;
    if (x == 'engirds') return true;
    if (x == 'englishes') return true;
    if (x == 'engluts') return true;
    if (x == 'engorges') return true;
    if (x == 'engrafts') return true;
    if (x == 'engrails') return true;
    if (x == 'engrains') return true;
    if (x == 'engrammes') return true;
    if (x == 'engrams') return true;
    if (x == 'engravers') return true;
    if (x == 'engraves') return true;
    if (x == 'engravings') return true;
    if (x == 'engross') return true;
    if (x == 'engrosses') return true;
    if (x == 'engs') return true;
    if (x == 'engulfs') return true;
    if (x == 'enhaloes') return true;
    if (x == 'enhancements') return true;
    if (x == 'enhancers') return true;
    if (x == 'enhances') return true;
    if (x == 'enigmas') return true;
    if (x == 'enisles') return true;
    if (x == 'enjoiners') return true;
    if (x == 'enjoins') return true;
    if (x == 'enjoyers') return true;
    if (x == 'enjoyments') return true;
    if (x == 'enjoys') return true;
    if (x == 'enkindles') return true;
    if (x == 'enlaces') return true;
    if (x == 'enlargements') return true;
    if (x == 'enlargers') return true;
    if (x == 'enlarges') return true;
    if (x == 'enlightenments') return true;
    if (x == 'enlightens') return true;
    if (x == 'enlistees') return true;
    if (x == 'enlisters') return true;
    if (x == 'enlistments') return true;
    if (x == 'enlists') return true;
    if (x == 'enlivens') return true;
    if (x == 'enmeshes') return true;
    if (x == 'enmities') return true;
    if (x == 'enneads') return true;
    if (x == 'enneagons') return true;
    if (x == 'ennoblers') return true;
    if (x == 'ennobles') return true;
    if (x == 'ennuis') return true;
    if (x == 'enolases') return true;
    if (x == 'enologies') return true;
    if (x == 'enols') return true;
    if (x == 'enormities') return true;
    if (x == 'enormous') return true;
    if (x == 'enormousness') return true;
    if (x == 'enormousnesses') return true;
    if (x == 'enosis') return true;
    if (x == 'enosises') return true;
    if (x == 'enoughs') return true;
    if (x == 'enounces') return true;
    if (x == 'enows') return true;
    if (x == 'enplanes') return true;
    if (x == 'enquires') return true;
    if (x == 'enquiries') return true;
    if (x == 'enrages') return true;
    if (x == 'enravishes') return true;
    if (x == 'enrichers') return true;
    if (x == 'enriches') return true;
    if (x == 'enrichments') return true;
    if (x == 'enrobers') return true;
    if (x == 'enrobes') return true;
    if (x == 'enrollees') return true;
    if (x == 'enrollers') return true;
    if (x == 'enrollments') return true;
    if (x == 'enrolls') return true;
    if (x == 'enrols') return true;
    if (x == 'enroots') return true;
    if (x == 'ens') return true;
    if (x == 'ensamples') return true;
    if (x == 'ensconces') return true;
    if (x == 'enscrolls') return true;
    if (x == 'ensembles') return true;
    if (x == 'enserfs') return true;
    if (x == 'ensheaths') return true;
    if (x == 'enshrines') return true;
    if (x == 'enshrouds') return true;
    if (x == 'ensigncies') return true;
    if (x == 'ensigns') return true;
    if (x == 'ensilages') return true;
    if (x == 'ensiles') return true;
    if (x == 'enskies') return true;
    if (x == 'enslavements') return true;
    if (x == 'enslavers') return true;
    if (x == 'enslaves') return true;
    if (x == 'ensnarers') return true;
    if (x == 'ensnares') return true;
    if (x == 'ensnarls') return true;
    if (x == 'ensorcels') return true;
    if (x == 'ensouls') return true;
    if (x == 'enspheres') return true;
    if (x == 'ensues') return true;
    if (x == 'ensurers') return true;
    if (x == 'ensures') return true;
    if (x == 'enswathes') return true;
    if (x == 'entailers') return true;
    if (x == 'entails') return true;
    if (x == 'entamebas') return true;
    if (x == 'entanglements') return true;
    if (x == 'entangles') return true;
    if (x == 'entases') return true;
    if (x == 'entasias') return true;
    if (x == 'entasis') return true;
    if (x == 'entellus') return true;
    if (x == 'entelluses') return true;
    if (x == 'ententes') return true;
    if (x == 'enterers') return true;
    if (x == 'enterons') return true;
    if (x == 'enterprises') return true;
    if (x == 'enters') return true;
    if (x == 'entertainers') return true;
    if (x == 'entertainments') return true;
    if (x == 'entertains') return true;
    if (x == 'enthalpies') return true;
    if (x == 'enthralls') return true;
    if (x == 'enthrals') return true;
    if (x == 'enthrones') return true;
    if (x == 'enthuses') return true;
    if (x == 'enthusiasts') return true;
    if (x == 'enticements') return true;
    if (x == 'enticers') return true;
    if (x == 'entices') return true;
    if (x == 'entires') return true;
    if (x == 'entireties') return true;
    if (x == 'entities') return true;
    if (x == 'entitles') return true;
    if (x == 'entoderms') return true;
    if (x == 'entoils') return true;
    if (x == 'entombs') return true;
    if (x == 'entomologies') return true;
    if (x == 'entomologists') return true;
    if (x == 'entourages') return true;
    if (x == 'entozoans') return true;
    if (x == 'entrails') return true;
    if (x == 'entrains') return true;
    if (x == 'entrances') return true;
    if (x == 'entrants') return true;
    if (x == 'entrapments') return true;
    if (x == 'entraps') return true;
    if (x == 'entreaties') return true;
    if (x == 'entreats') return true;
    if (x == 'entrees') return true;
    if (x == 'entrenches') return true;
    if (x == 'entrenchments') return true;
    if (x == 'entrepots') return true;
    if (x == 'entrepreneurs') return true;
    if (x == 'entresols') return true;
    if (x == 'entries') return true;
    if (x == 'entropies') return true;
    if (x == 'entrusts') return true;
    if (x == 'entryways') return true;
    if (x == 'entwines') return true;
    if (x == 'entwists') return true;
    if (x == 'enumerates') return true;
    if (x == 'enumerations') return true;
    if (x == 'enunciates') return true;
    if (x == 'enunciations') return true;
    if (x == 'enures') return true;
    if (x == 'enuresis') return true;
    if (x == 'enuresises') return true;
    if (x == 'envelopes') return true;
    if (x == 'envelopments') return true;
    if (x == 'envelops') return true;
    if (x == 'envenoms') return true;
    if (x == 'enviers') return true;
    if (x == 'envies') return true;
    if (x == 'envious') return true;
    if (x == 'environmentalists') return true;
    if (x == 'environments') return true;
    if (x == 'environs') return true;
    if (x == 'envisages') return true;
    if (x == 'envisions') return true;
    if (x == 'envois') return true;
    if (x == 'envoys') return true;
    if (x == 'enwheels') return true;
    if (x == 'enwinds') return true;
    if (x == 'enwombs') return true;
    if (x == 'enwraps') return true;
    if (x == 'enzootics') return true;
    if (x == 'enzymes') return true;
    if (x == 'enzyms') return true;
    return nil;
  }
  isGoodWordEO(x) {
    if (x == 'eobionts') return true;
    if (x == 'eohippus') return true;
    if (x == 'eohippuses') return true;
    if (x == 'eolipiles') return true;
    if (x == 'eoliths') return true;
    if (x == 'eolopiles') return true;
    if (x == 'eonisms') return true;
    if (x == 'eons') return true;
    if (x == 'eosines') return true;
    if (x == 'eosins') return true;
    if (x == 'epacts') return true;
    if (x == 'eparchies') return true;
    if (x == 'eparchs') return true;
    if (x == 'epaulets') return true;
    if (x == 'epeeists') return true;
    if (x == 'epees') return true;
    if (x == 'epergnes') return true;
    if (x == 'ephahs') return true;
    if (x == 'ephas') return true;
    if (x == 'ephebes') return true;
    if (x == 'ephebos') return true;
    if (x == 'ephebus') return true;
    if (x == 'ephedras') return true;
    if (x == 'ephedrins') return true;
    if (x == 'ephemeras') return true;
    if (x == 'ephods') return true;
    if (x == 'ephorates') return true;
    if (x == 'ephors') return true;
    if (x == 'epiblasts') return true;
    if (x == 'epibolies') return true;
    if (x == 'epicalyces') return true;
    if (x == 'epicalyxes') return true;
    if (x == 'epicarps') return true;
    if (x == 'epicenes') return true;
    if (x == 'epicotyls') return true;
    if (x == 'epics') return true;
    if (x == 'epicureans') return true;
    if (x == 'epicures') return true;
    if (x == 'epicycles') return true;
    if (x == 'epidemics') return true;
    if (x == 'epidermis') return true;
    if (x == 'epidermises') return true;
    if (x == 'epiderms') return true;
    if (x == 'epidotes') return true;
    if (x == 'epifaunas') return true;
    if (x == 'epigeous') return true;
    if (x == 'epigones') return true;
    if (x == 'epigons') return true;
    if (x == 'epigonus') return true;
    if (x == 'epigrams') return true;
    if (x == 'epigraphs') return true;
    if (x == 'epigynies') return true;
    if (x == 'epilepsies') return true;
    if (x == 'epileptics') return true;
    if (x == 'epilogs') return true;
    if (x == 'epilogues') return true;
    if (x == 'epimeres') return true;
    if (x == 'epimers') return true;
    if (x == 'epinaos') return true;
    if (x == 'epinasties') return true;
    if (x == 'epiphanies') return true;
    if (x == 'epiphytes') return true;
    if (x == 'episcias') return true;
    if (x == 'episcopes') return true;
    if (x == 'episodes') return true;
    if (x == 'episomes') return true;
    if (x == 'epistasies') return true;
    if (x == 'epistaxis') return true;
    if (x == 'epistlers') return true;
    if (x == 'epistles') return true;
    if (x == 'epistyles') return true;
    if (x == 'epitaphs') return true;
    if (x == 'epitases') return true;
    if (x == 'epitasis') return true;
    if (x == 'epitaxies') return true;
    if (x == 'epithets') return true;
    if (x == 'epitomes') return true;
    if (x == 'epitomises') return true;
    if (x == 'epitomizes') return true;
    if (x == 'epizoisms') return true;
    if (x == 'epizoites') return true;
    if (x == 'epizooties') return true;
    if (x == 'epochs') return true;
    if (x == 'epodes') return true;
    if (x == 'eponymies') return true;
    if (x == 'eponyms') return true;
    if (x == 'epopees') return true;
    if (x == 'epopoeias') return true;
    if (x == 'epos') return true;
    if (x == 'eposes') return true;
    if (x == 'epoxides') return true;
    if (x == 'epoxies') return true;
    if (x == 'epsilons') return true;
    if (x == 'equabilities') return true;
    if (x == 'equalises') return true;
    if (x == 'equalities') return true;
    if (x == 'equalizes') return true;
    if (x == 'equals') return true;
    if (x == 'equanimities') return true;
    if (x == 'equates') return true;
    if (x == 'equations') return true;
    if (x == 'equators') return true;
    if (x == 'equerries') return true;
    if (x == 'equestrians') return true;
    if (x == 'equines') return true;
    if (x == 'equinities') return true;
    if (x == 'equinoxes') return true;
    if (x == 'equipages') return true;
    if (x == 'equipments') return true;
    if (x == 'equippers') return true;
    if (x == 'equips') return true;
    if (x == 'equites') return true;
    if (x == 'equities') return true;
    if (x == 'equivalences') return true;
    if (x == 'equivalents') return true;
    if (x == 'equivocates') return true;
    if (x == 'equivocations') return true;
    if (x == 'equivokes') return true;
    if (x == 'eradiates') return true;
    if (x == 'eradicates') return true;
    if (x == 'eras') return true;
    if (x == 'erasers') return true;
    if (x == 'erases') return true;
    if (x == 'erasions') return true;
    if (x == 'erasures') return true;
    if (x == 'erbiums') return true;
    if (x == 'erecters') return true;
    if (x == 'erections') return true;
    if (x == 'erectors') return true;
    if (x == 'erects') return true;
    if (x == 'eremites') return true;
    if (x == 'eremurus') return true;
    if (x == 'erepsins') return true;
    if (x == 'erethisms') return true;
    if (x == 'ergates') return true;
    if (x == 'ergotisms') return true;
    if (x == 'ergots') return true;
    if (x == 'ergs') return true;
    if (x == 'ericas') return true;
    if (x == 'erigerons') return true;
    if (x == 'eringoes') return true;
    if (x == 'eringos') return true;
    if (x == 'eristics') return true;
    if (x == 'erlkings') return true;
    if (x == 'ermines') return true;
    if (x == 'ernes') return true;
    if (x == 'erns') return true;
    if (x == 'erodes') return true;
    if (x == 'eros') return true;
    if (x == 'eroses') return true;
    if (x == 'erosions') return true;
    if (x == 'erotics') return true;
    if (x == 'erotisms') return true;
    if (x == 'errancies') return true;
    if (x == 'errands') return true;
    if (x == 'errantries') return true;
    if (x == 'errants') return true;
    if (x == 'erratas') return true;
    if (x == 'errhines') return true;
    if (x == 'erroneous') return true;
    if (x == 'errors') return true;
    if (x == 'errs') return true;
    if (x == 'ers') return true;
    if (x == 'ersatzes') return true;
    if (x == 'erses') return true;
    if (x == 'eructates') return true;
    if (x == 'eructs') return true;
    if (x == 'eruditions') return true;
    if (x == 'erugos') return true;
    if (x == 'eruptions') return true;
    if (x == 'eruptives') return true;
    if (x == 'erupts') return true;
    if (x == 'ervils') return true;
    if (x == 'eryngoes') return true;
    if (x == 'eryngos') return true;
    if (x == 'erythemas') return true;
    if (x == 'erythematous') return true;
    if (x == 'erythrocytosis') return true;
    if (x == 'erythrons') return true;
    if (x == 'es') return true;
    if (x == 'escalades') return true;
    if (x == 'escalates') return true;
    if (x == 'escalations') return true;
    if (x == 'escalators') return true;
    if (x == 'escallops') return true;
    if (x == 'escalops') return true;
    if (x == 'escapades') return true;
    if (x == 'escapees') return true;
    if (x == 'escapers') return true;
    if (x == 'escapes') return true;
    if (x == 'escapisms') return true;
    if (x == 'escapists') return true;
    if (x == 'escargots') return true;
    if (x == 'escaroles') return true;
    if (x == 'escarpments') return true;
    if (x == 'escarps') return true;
    if (x == 'escars') return true;
    if (x == 'eschalots') return true;
    if (x == 'eschars') return true;
    if (x == 'escheats') return true;
    if (x == 'eschewals') return true;
    if (x == 'eschews') return true;
    if (x == 'escolars') return true;
    if (x == 'escorts') return true;
    if (x == 'escots') return true;
    if (x == 'escrows') return true;
    if (x == 'escuages') return true;
    if (x == 'escudos') return true;
    if (x == 'esculents') return true;
    if (x == 'eserines') return true;
    if (x == 'eses') return true;
    if (x == 'eskars') return true;
    if (x == 'eskers') return true;
    if (x == 'esophagus') return true;
    if (x == 'espaliers') return true;
    if (x == 'espanoles') return true;
    if (x == 'espartos') return true;
    if (x == 'espials') return true;
    if (x == 'espies') return true;
    if (x == 'espionages') return true;
    if (x == 'espousals') return true;
    if (x == 'espousers') return true;
    if (x == 'espouses') return true;
    if (x == 'espressos') return true;
    if (x == 'esprits') return true;
    if (x == 'esquires') return true;
    if (x == 'ess') return true;
    if (x == 'essayers') return true;
    if (x == 'essayists') return true;
    if (x == 'essays') return true;
    if (x == 'essences') return true;
    if (x == 'esses') return true;
    if (x == 'essoins') return true;
    if (x == 'essonites') return true;
    if (x == 'establishes') return true;
    if (x == 'establishments') return true;
    if (x == 'estancias') return true;
    if (x == 'estates') return true;
    if (x == 'esteems') return true;
    if (x == 'esterases') return true;
    if (x == 'esterifies') return true;
    if (x == 'esters') return true;
    if (x == 'estheses') return true;
    if (x == 'esthesias') return true;
    if (x == 'esthesis') return true;
    if (x == 'esthesises') return true;
    if (x == 'esthetes') return true;
    if (x == 'estimates') return true;
    if (x == 'estimations') return true;
    if (x == 'estimators') return true;
    if (x == 'estivates') return true;
    if (x == 'estoppels') return true;
    if (x == 'estops') return true;
    if (x == 'estovers') return true;
    if (x == 'estragons') return true;
    if (x == 'estrangements') return true;
    if (x == 'estranges') return true;
    if (x == 'estrays') return true;
    if (x == 'estreats') return true;
    if (x == 'estrins') return true;
    if (x == 'estriols') return true;
    if (x == 'estrogens') return true;
    if (x == 'estrones') return true;
    if (x == 'estrous') return true;
    if (x == 'estrums') return true;
    if (x == 'estrus') return true;
    if (x == 'estruses') return true;
    if (x == 'estuaries') return true;
    if (x == 'etageres') return true;
    if (x == 'etamines') return true;
    if (x == 'etamins') return true;
    if (x == 'etapes') return true;
    if (x == 'etas') return true;
    if (x == 'etatisms') return true;
    if (x == 'etatists') return true;
    if (x == 'etceteras') return true;
    if (x == 'etchers') return true;
    if (x == 'etches') return true;
    if (x == 'etchings') return true;
    if (x == 'eternals') return true;
    if (x == 'eternises') return true;
    if (x == 'eternities') return true;
    if (x == 'eternizes') return true;
    if (x == 'etesians') return true;
    if (x == 'ethanes') return true;
    if (x == 'ethanols') return true;
    if (x == 'ethenes') return true;
    if (x == 'etherifies') return true;
    if (x == 'etherizes') return true;
    if (x == 'ethers') return true;
    if (x == 'ethicals') return true;
    if (x == 'ethicians') return true;
    if (x == 'ethicists') return true;
    if (x == 'ethicizes') return true;
    if (x == 'ethics') return true;
    if (x == 'ethinyls') return true;
    if (x == 'ethions') return true;
    if (x == 'ethmoids') return true;
    if (x == 'ethnarchs') return true;
    if (x == 'ethnicities') return true;
    if (x == 'ethnics') return true;
    if (x == 'ethnologies') return true;
    if (x == 'ethnos') return true;
    if (x == 'ethnoses') return true;
    if (x == 'ethologies') return true;
    if (x == 'ethos') return true;
    if (x == 'ethoses') return true;
    if (x == 'ethoxyls') return true;
    if (x == 'eths') return true;
    if (x == 'ethylates') return true;
    if (x == 'ethylenes') return true;
    if (x == 'ethyls') return true;
    if (x == 'ethynes') return true;
    if (x == 'ethynyls') return true;
    if (x == 'etiolates') return true;
    if (x == 'etiologies') return true;
    if (x == 'etnas') return true;
    if (x == 'etoiles') return true;
    if (x == 'etudes') return true;
    if (x == 'etuis') return true;
    if (x == 'etwees') return true;
    if (x == 'etymologists') return true;
    if (x == 'etymons') return true;
    if (x == 'eucaines') return true;
    if (x == 'eucalypts') return true;
    if (x == 'eucalyptus') return true;
    if (x == 'eucalyptuses') return true;
    if (x == 'eucharis') return true;
    if (x == 'eucharises') return true;
    if (x == 'euchres') return true;
    if (x == 'euclases') return true;
    if (x == 'eucrites') return true;
    if (x == 'eudaemons') return true;
    if (x == 'eudemons') return true;
    if (x == 'eugenics') return true;
    if (x == 'eugenists') return true;
    if (x == 'eugenols') return true;
    if (x == 'euglenas') return true;
    if (x == 'eulachans') return true;
    if (x == 'eulachons') return true;
    if (x == 'eulogias') return true;
    if (x == 'eulogies') return true;
    if (x == 'eulogises') return true;
    if (x == 'eulogists') return true;
    if (x == 'eulogiums') return true;
    if (x == 'eulogizes') return true;
    if (x == 'eunuchs') return true;
    if (x == 'euonymus') return true;
    if (x == 'euonymuses') return true;
    if (x == 'eupatrids') return true;
    if (x == 'eupepsias') return true;
    if (x == 'eupepsies') return true;
    if (x == 'euphemisms') return true;
    if (x == 'euphonies') return true;
    if (x == 'euphonious') return true;
    if (x == 'euphorias') return true;
    if (x == 'euphrasies') return true;
    if (x == 'euphroes') return true;
    if (x == 'euphuisms') return true;
    if (x == 'euphuists') return true;
    if (x == 'euploidies') return true;
    if (x == 'euploids') return true;
    if (x == 'eupneas') return true;
    if (x == 'eupnoeas') return true;
    if (x == 'euripus') return true;
    if (x == 'europiums') return true;
    if (x == 'euros') return true;
    if (x == 'eurythmies') return true;
    if (x == 'eustacies') return true;
    if (x == 'eusteles') return true;
    if (x == 'eutaxies') return true;
    if (x == 'eutectics') return true;
    if (x == 'euthanasias') return true;
    if (x == 'eutrophies') return true;
    if (x == 'euxenites') return true;
    return nil;
  }
  isGoodWordEV(x) {
    if (x == 'evacuants') return true;
    if (x == 'evacuates') return true;
    if (x == 'evacuations') return true;
    if (x == 'evacuees') return true;
    if (x == 'evaders') return true;
    if (x == 'evades') return true;
    if (x == 'evaluates') return true;
    if (x == 'evaluations') return true;
    if (x == 'evaluators') return true;
    if (x == 'evanesces') return true;
    if (x == 'evangelisms') return true;
    if (x == 'evangelists') return true;
    if (x == 'evangels') return true;
    if (x == 'evanishes') return true;
    if (x == 'evaporates') return true;
    if (x == 'evaporations') return true;
    if (x == 'evaporators') return true;
    if (x == 'evasions') return true;
    if (x == 'evasiveness') return true;
    if (x == 'evasivenesses') return true;
    if (x == 'evections') return true;
    if (x == 'eveners') return true;
    if (x == 'evenfalls') return true;
    if (x == 'evenings') return true;
    if (x == 'evenness') return true;
    if (x == 'evennesses') return true;
    if (x == 'evens') return true;
    if (x == 'evensongs') return true;
    if (x == 'eventides') return true;
    if (x == 'events') return true;
    if (x == 'eventualities') return true;
    if (x == 'evergreens') return true;
    if (x == 'eversions') return true;
    if (x == 'evertors') return true;
    if (x == 'everts') return true;
    if (x == 'eves') return true;
    if (x == 'evictees') return true;
    if (x == 'evictions') return true;
    if (x == 'evictors') return true;
    if (x == 'evicts') return true;
    if (x == 'evidences') return true;
    if (x == 'evildoers') return true;
    if (x == 'evilness') return true;
    if (x == 'evilnesses') return true;
    if (x == 'evils') return true;
    if (x == 'evinces') return true;
    if (x == 'eviscerates') return true;
    if (x == 'eviscerations') return true;
    if (x == 'evites') return true;
    if (x == 'evocations') return true;
    if (x == 'evocators') return true;
    if (x == 'evokers') return true;
    if (x == 'evokes') return true;
    if (x == 'evolutes') return true;
    if (x == 'evolutions') return true;
    if (x == 'evolvers') return true;
    if (x == 'evolves') return true;
    if (x == 'evonymus') return true;
    if (x == 'evonymuses') return true;
    if (x == 'evulsions') return true;
    if (x == 'evzones') return true;
    if (x == 'ewers') return true;
    if (x == 'ewes') return true;
    if (x == 'exabytes') return true;
    if (x == 'exacerbates') return true;
    if (x == 'exactas') return true;
    if (x == 'exacters') return true;
    if (x == 'exactions') return true;
    if (x == 'exactitudes') return true;
    if (x == 'exactness') return true;
    if (x == 'exactnesses') return true;
    if (x == 'exactors') return true;
    if (x == 'exacts') return true;
    if (x == 'exaggerates') return true;
    if (x == 'exaggerations') return true;
    if (x == 'exaggerators') return true;
    if (x == 'exaltations') return true;
    if (x == 'exalters') return true;
    if (x == 'exalts') return true;
    if (x == 'examens') return true;
    if (x == 'examinations') return true;
    if (x == 'examinees') return true;
    if (x == 'examiners') return true;
    if (x == 'examines') return true;
    if (x == 'examples') return true;
    if (x == 'exams') return true;
    if (x == 'exanthems') return true;
    if (x == 'exarchies') return true;
    if (x == 'exarchs') return true;
    if (x == 'exasperates') return true;
    if (x == 'exasperations') return true;
    if (x == 'excavates') return true;
    if (x == 'excavations') return true;
    if (x == 'excavators') return true;
    if (x == 'exceeders') return true;
    if (x == 'exceeds') return true;
    if (x == 'excellences') return true;
    if (x == 'excels') return true;
    if (x == 'exceptions') return true;
    if (x == 'excepts') return true;
    if (x == 'excerpts') return true;
    if (x == 'excess') return true;
    if (x == 'excesses') return true;
    if (x == 'exchanges') return true;
    if (x == 'excides') return true;
    if (x == 'exciples') return true;
    if (x == 'excises') return true;
    if (x == 'excisions') return true;
    if (x == 'excitabilities') return true;
    if (x == 'excitants') return true;
    if (x == 'excitations') return true;
    if (x == 'excitements') return true;
    if (x == 'exciters') return true;
    if (x == 'excites') return true;
    if (x == 'excitons') return true;
    if (x == 'excitors') return true;
    if (x == 'exclaims') return true;
    if (x == 'exclamations') return true;
    if (x == 'exclaves') return true;
    if (x == 'excluders') return true;
    if (x == 'excludes') return true;
    if (x == 'exclusions') return true;
    if (x == 'exclusiveness') return true;
    if (x == 'exclusivenesses') return true;
    if (x == 'excommunicates') return true;
    if (x == 'excommunications') return true;
    if (x == 'excrements') return true;
    if (x == 'excreters') return true;
    if (x == 'excretes') return true;
    if (x == 'excretions') return true;
    if (x == 'exculpates') return true;
    if (x == 'excursions') return true;
    if (x == 'excusers') return true;
    if (x == 'excuses') return true;
    if (x == 'execrates') return true;
    if (x == 'execs') return true;
    if (x == 'executers') return true;
    if (x == 'executes') return true;
    if (x == 'executioners') return true;
    if (x == 'executions') return true;
    if (x == 'executives') return true;
    if (x == 'executors') return true;
    if (x == 'executrixes') return true;
    if (x == 'exegeses') return true;
    if (x == 'exegesis') return true;
    if (x == 'exegetes') return true;
    if (x == 'exemplars') return true;
    if (x == 'exemplifications') return true;
    if (x == 'exemplifies') return true;
    if (x == 'exemptions') return true;
    if (x == 'exempts') return true;
    if (x == 'exequies') return true;
    if (x == 'exercisers') return true;
    if (x == 'exercises') return true;
    if (x == 'exergues') return true;
    if (x == 'exertions') return true;
    if (x == 'exerts') return true;
    if (x == 'exes') return true;
    if (x == 'exhalants') return true;
    if (x == 'exhalations') return true;
    if (x == 'exhalents') return true;
    if (x == 'exhales') return true;
    if (x == 'exhaustions') return true;
    if (x == 'exhausts') return true;
    if (x == 'exhibitions') return true;
    if (x == 'exhibitors') return true;
    if (x == 'exhibits') return true;
    if (x == 'exhilarates') return true;
    if (x == 'exhilarations') return true;
    if (x == 'exhortations') return true;
    if (x == 'exhorters') return true;
    if (x == 'exhorts') return true;
    if (x == 'exhumations') return true;
    if (x == 'exhumers') return true;
    if (x == 'exhumes') return true;
    if (x == 'exigences') return true;
    if (x == 'exigencies') return true;
    if (x == 'exiguities') return true;
    if (x == 'exiguous') return true;
    if (x == 'exiles') return true;
    if (x == 'eximious') return true;
    if (x == 'exines') return true;
    if (x == 'existences') return true;
    if (x == 'existents') return true;
    if (x == 'exists') return true;
    if (x == 'exits') return true;
    if (x == 'exocarps') return true;
    if (x == 'exocrines') return true;
    if (x == 'exoderms') return true;
    if (x == 'exodos') return true;
    if (x == 'exodus') return true;
    if (x == 'exoduses') return true;
    if (x == 'exogamies') return true;
    if (x == 'exogens') return true;
    if (x == 'exonerates') return true;
    if (x == 'exonerations') return true;
    if (x == 'exorcises') return true;
    if (x == 'exorcisms') return true;
    if (x == 'exorcists') return true;
    if (x == 'exorcizes') return true;
    if (x == 'exordiums') return true;
    if (x == 'exosmoses') return true;
    if (x == 'exospores') return true;
    if (x == 'exoticisms') return true;
    if (x == 'exotics') return true;
    if (x == 'exotisms') return true;
    if (x == 'exotoxins') return true;
    if (x == 'expanders') return true;
    if (x == 'expands') return true;
    if (x == 'expanses') return true;
    if (x == 'expansions') return true;
    if (x == 'expansiveness') return true;
    if (x == 'expansivenesses') return true;
    if (x == 'expatriates') return true;
    if (x == 'expectancies') return true;
    if (x == 'expectations') return true;
    if (x == 'expects') return true;
    if (x == 'expedients') return true;
    if (x == 'expedious') return true;
    if (x == 'expediters') return true;
    if (x == 'expedites') return true;
    if (x == 'expeditions') return true;
    if (x == 'expeditious') return true;
    if (x == 'expellees') return true;
    if (x == 'expellers') return true;
    if (x == 'expels') return true;
    if (x == 'expenders') return true;
    if (x == 'expenditures') return true;
    if (x == 'expends') return true;
    if (x == 'expenses') return true;
    if (x == 'experiences') return true;
    if (x == 'experimentations') return true;
    if (x == 'experimenters') return true;
    if (x == 'experiments') return true;
    if (x == 'expertises') return true;
    if (x == 'expertness') return true;
    if (x == 'expertnesses') return true;
    if (x == 'experts') return true;
    if (x == 'expiates') return true;
    if (x == 'expiations') return true;
    if (x == 'expiators') return true;
    if (x == 'expirations') return true;
    if (x == 'expirers') return true;
    if (x == 'expires') return true;
    if (x == 'expiries') return true;
    if (x == 'explains') return true;
    if (x == 'explanations') return true;
    if (x == 'explants') return true;
    if (x == 'expletives') return true;
    if (x == 'explicitness') return true;
    if (x == 'explicitnesses') return true;
    if (x == 'explicits') return true;
    if (x == 'exploders') return true;
    if (x == 'explodes') return true;
    if (x == 'exploitations') return true;
    if (x == 'exploits') return true;
    if (x == 'explorations') return true;
    if (x == 'explorers') return true;
    if (x == 'explores') return true;
    if (x == 'explosions') return true;
    if (x == 'explosives') return true;
    if (x == 'exponents') return true;
    if (x == 'exportations') return true;
    if (x == 'exporters') return true;
    if (x == 'exports') return true;
    if (x == 'expos') return true;
    if (x == 'exposals') return true;
    if (x == 'exposers') return true;
    if (x == 'exposes') return true;
    if (x == 'expositions') return true;
    if (x == 'exposits') return true;
    if (x == 'exposures') return true;
    if (x == 'expounds') return true;
    if (x == 'express') return true;
    if (x == 'expresses') return true;
    if (x == 'expressionless') return true;
    if (x == 'expressions') return true;
    if (x == 'expressiveness') return true;
    if (x == 'expressivenesses') return true;
    if (x == 'expressways') return true;
    if (x == 'expulses') return true;
    if (x == 'expulsions') return true;
    if (x == 'expungers') return true;
    if (x == 'expunges') return true;
    if (x == 'expurgates') return true;
    if (x == 'expurgations') return true;
    if (x == 'exscinds') return true;
    if (x == 'exsecants') return true;
    if (x == 'exsects') return true;
    if (x == 'exserts') return true;
    if (x == 'extemporaneous') return true;
    if (x == 'extenders') return true;
    if (x == 'extends') return true;
    if (x == 'extensions') return true;
    if (x == 'extensors') return true;
    if (x == 'extents') return true;
    if (x == 'extenuates') return true;
    if (x == 'extenuations') return true;
    if (x == 'exteriors') return true;
    if (x == 'exterminates') return true;
    if (x == 'exterminations') return true;
    if (x == 'exterminators') return true;
    if (x == 'externals') return true;
    if (x == 'externes') return true;
    if (x == 'externs') return true;
    if (x == 'extinctions') return true;
    if (x == 'extincts') return true;
    if (x == 'extinguishers') return true;
    if (x == 'extinguishes') return true;
    if (x == 'extirpates') return true;
    if (x == 'extollers') return true;
    if (x == 'extolls') return true;
    if (x == 'extols') return true;
    if (x == 'extorters') return true;
    if (x == 'extortioners') return true;
    if (x == 'extortionists') return true;
    if (x == 'extortions') return true;
    if (x == 'extorts') return true;
    if (x == 'extracampus') return true;
    if (x == 'extractions') return true;
    if (x == 'extractors') return true;
    if (x == 'extracts') return true;
    if (x == 'extradites') return true;
    if (x == 'extraditions') return true;
    if (x == 'extrados') return true;
    if (x == 'extradoses') return true;
    if (x == 'extraneous') return true;
    if (x == 'extras') return true;
    if (x == 'extravagances') return true;
    if (x == 'extravaganzas') return true;
    if (x == 'extravasates') return true;
    if (x == 'extravasations') return true;
    if (x == 'extraversions') return true;
    if (x == 'extraverts') return true;
    if (x == 'extremes') return true;
    if (x == 'extremities') return true;
    if (x == 'extricates') return true;
    if (x == 'extrications') return true;
    if (x == 'extroverts') return true;
    if (x == 'extruders') return true;
    if (x == 'extrudes') return true;
    if (x == 'exuberances') return true;
    if (x == 'exudates') return true;
    if (x == 'exudations') return true;
    if (x == 'exudes') return true;
    if (x == 'exults') return true;
    if (x == 'exurbias') return true;
    if (x == 'exurbs') return true;
    if (x == 'exuviates') return true;
    if (x == 'eyas') return true;
    if (x == 'eyases') return true;
    if (x == 'eyeballs') return true;
    if (x == 'eyebeams') return true;
    if (x == 'eyebolts') return true;
    if (x == 'eyebrows') return true;
    if (x == 'eyecups') return true;
    if (x == 'eyedness') return true;
    if (x == 'eyednesses') return true;
    if (x == 'eyedroppers') return true;
    if (x == 'eyefuls') return true;
    if (x == 'eyeglass') return true;
    if (x == 'eyeglasses') return true;
    if (x == 'eyeholes') return true;
    if (x == 'eyehooks') return true;
    if (x == 'eyelashes') return true;
    if (x == 'eyeless') return true;
    if (x == 'eyelets') return true;
    if (x == 'eyelids') return true;
    if (x == 'eyeliners') return true;
    if (x == 'eyepieces') return true;
    if (x == 'eyepoints') return true;
    if (x == 'eyers') return true;
    if (x == 'eyes') return true;
    if (x == 'eyeshades') return true;
    if (x == 'eyeshots') return true;
    if (x == 'eyesights') return true;
    if (x == 'eyesores') return true;
    if (x == 'eyespots') return true;
    if (x == 'eyestalks') return true;
    if (x == 'eyestones') return true;
    if (x == 'eyestrains') return true;
    if (x == 'eyewashes') return true;
    if (x == 'eyewaters') return true;
    if (x == 'eyewinks') return true;
    if (x == 'eyewitness') return true;
    if (x == 'eyras') return true;
    if (x == 'eyres') return true;
    if (x == 'eyries') return true;
    return nil;
  }
;
twiEscSC: TwiEscDataObject
  firstLetter = 's'
  lastLetter  = 'c'
  isGoodWord(x) {
    if (x == 'sabbatic') return true;
    if (x == 'sac') return true;
    if (x == 'saccadic') return true;
    if (x == 'sachemic') return true;
    if (x == 'sadistic') return true;
    if (x == 'salic') return true;
    if (x == 'salvific') return true;
    if (x == 'sandarac') return true;
    if (x == 'santalic') return true;
    if (x == 'sapphic') return true;
    if (x == 'sapremic') return true;
    if (x == 'saprobic') return true;
    if (x == 'sarcastic') return true;
    if (x == 'sardonic') return true;
    if (x == 'satanic') return true;
    if (x == 'satiric') return true;
    if (x == 'satyric') return true;
    if (x == 'scaldic') return true;
    if (x == 'scandic') return true;
    if (x == 'scenic') return true;
    if (x == 'sceptic') return true;
    if (x == 'schematic') return true;
    if (x == 'schizophrenic') return true;
    if (x == 'scholastic') return true;
    if (x == 'sciatic') return true;
    if (x == 'scientific') return true;
    if (x == 'sclerotic') return true;
    if (x == 'scotopic') return true;
    if (x == 'sebacic') return true;
    if (x == 'sebasic') return true;
    if (x == 'sec') return true;
    if (x == 'seismic') return true;
    if (x == 'selenic') return true;
    if (x == 'semantic') return true;
    if (x == 'sematic') return true;
    if (x == 'semiotic') return true;
    if (x == 'sepic') return true;
    if (x == 'septic') return true;
    if (x == 'serac') return true;
    if (x == 'seraphic') return true;
    if (x == 'sermonic') return true;
    if (x == 'shamanic') return true;
    if (x == 'shellac') return true;
    if (x == 'shoepac') return true;
    if (x == 'sialic') return true;
    if (x == 'sibylic') return true;
    if (x == 'sibyllic') return true;
    if (x == 'sic') return true;
    if (x == 'silicic') return true;
    if (x == 'simoniac') return true;
    if (x == 'siphonic') return true;
    if (x == 'skaldic') return true;
    if (x == 'skeptic') return true;
    if (x == 'slivovic') return true;
    if (x == 'smectic') return true;
    if (x == 'socialistic') return true;
    if (x == 'sodic') return true;
    if (x == 'somatic') return true;
    if (x == 'somitic') return true;
    if (x == 'sonantic') return true;
    if (x == 'sonic') return true;
    if (x == 'sophistic') return true;
    if (x == 'soporific') return true;
    if (x == 'sorbic') return true;
    if (x == 'soritic') return true;
    if (x == 'spagyric') return true;
    if (x == 'spasmodic') return true;
    if (x == 'spastic') return true;
    if (x == 'spathic') return true;
    if (x == 'specific') return true;
    if (x == 'spermic') return true;
    if (x == 'sphenic') return true;
    if (x == 'spheric') return true;
    if (x == 'sphygmic') return true;
    if (x == 'spic') return true;
    if (x == 'spiritualistic') return true;
    if (x == 'splenic') return true;
    if (x == 'spondaic') return true;
    if (x == 'sporadic') return true;
    if (x == 'stannic') return true;
    if (x == 'stanzaic') return true;
    if (x == 'static') return true;
    if (x == 'statistic') return true;
    if (x == 'stearic') return true;
    if (x == 'stelic') return true;
    if (x == 'stenographic') return true;
    if (x == 'stenotic') return true;
    if (x == 'stereophonic') return true;
    if (x == 'steric') return true;
    if (x == 'sthenic') return true;
    if (x == 'stichic') return true;
    if (x == 'stoic') return true;
    if (x == 'stolonic') return true;
    if (x == 'stomatic') return true;
    if (x == 'strategic') return true;
    if (x == 'strobic') return true;
    if (x == 'strontic') return true;
    if (x == 'strophic') return true;
    if (x == 'stylitic') return true;
    if (x == 'styptic') return true;
    if (x == 'subarctic') return true;
    if (x == 'subatmospheric') return true;
    if (x == 'suberic') return true;
    if (x == 'subfusc') return true;
    if (x == 'suboceanic') return true;
    if (x == 'suboptic') return true;
    if (x == 'subpubic') return true;
    if (x == 'subsonic') return true;
    if (x == 'subtonic') return true;
    if (x == 'subtopic') return true;
    if (x == 'subtunic') return true;
    if (x == 'succinic') return true;
    if (x == 'sulfitic') return true;
    if (x == 'sulfonic') return true;
    if (x == 'sulfuric') return true;
    if (x == 'sultanic') return true;
    if (x == 'sumac') return true;
    if (x == 'superenthusiastic') return true;
    if (x == 'superpatriotic') return true;
    if (x == 'supersonic') return true;
    if (x == 'sycophantic') return true;
    if (x == 'syenitic') return true;
    if (x == 'syllabic') return true;
    if (x == 'sylphic') return true;
    if (x == 'sylvatic') return true;
    if (x == 'symbolic') return true;
    if (x == 'symmetric') return true;
    if (x == 'sympathetic') return true;
    if (x == 'symphonic') return true;
    if (x == 'synaptic') return true;
    if (x == 'sync') return true;
    if (x == 'syncopic') return true;
    if (x == 'syndetic') return true;
    if (x == 'syndic') return true;
    if (x == 'synectic') return true;
    if (x == 'synergic') return true;
    if (x == 'syngamic') return true;
    if (x == 'synodic') return true;
    if (x == 'synoptic') return true;
    if (x == 'syntactic') return true;
    if (x == 'synthetic') return true;
    if (x == 'syntonic') return true;
    if (x == 'syphilitic') return true;
    if (x == 'systematic') return true;
    if (x == 'systemic') return true;
    if (x == 'systolic') return true;
    return nil;
  }
;
twiEscCA: TwiEscDataObject
  firstLetter = 'c'
  lastLetter  = 'a'
  isGoodWord(x) {
    if (x == 'cabala') return true;
    if (x == 'cabana') return true;
    if (x == 'cabbala') return true;
    if (x == 'cabresta') return true;
    if (x == 'cabretta') return true;
    if (x == 'cabrilla') return true;
    if (x == 'cachexia') return true;
    if (x == 'cachucha') return true;
    if (x == 'cadenza') return true;
    if (x == 'caeca') return true;
    if (x == 'caeoma') return true;
    if (x == 'caesura') return true;
    if (x == 'cafeteria') return true;
    if (x == 'calcanea') return true;
    if (x == 'calcaria') return true;
    if (x == 'calctufa') return true;
    if (x == 'caldera') return true;
    if (x == 'calesa') return true;
    if (x == 'california') return true;
    if (x == 'calisaya') return true;
    if (x == 'calla') return true;
    if (x == 'calvaria') return true;
    if (x == 'calyptra') return true;
    if (x == 'cambia') return true;
    if (x == 'cambogia') return true;
    if (x == 'camelia') return true;
    if (x == 'camellia') return true;
    if (x == 'camera') return true;
    if (x == 'camisa') return true;
    if (x == 'camisia') return true;
    if (x == 'camorra') return true;
    if (x == 'campagna') return true;
    if (x == 'canasta') return true;
    if (x == 'cancha') return true;
    if (x == 'candela') return true;
    if (x == 'candelabra') return true;
    if (x == 'candida') return true;
    if (x == 'canella') return true;
    if (x == 'canna') return true;
    if (x == 'cannula') return true;
    if (x == 'cantala') return true;
    if (x == 'cantata') return true;
    if (x == 'cantina') return true;
    if (x == 'canula') return true;
    if (x == 'canzona') return true;
    if (x == 'capita') return true;
    if (x == 'capitula') return true;
    if (x == 'capybara') return true;
    if (x == 'caracara') return true;
    if (x == 'caragana') return true;
    if (x == 'carbora') return true;
    if (x == 'carcinoma') return true;
    if (x == 'carcinomata') return true;
    if (x == 'cardia') return true;
    if (x == 'carina') return true;
    if (x == 'carioca') return true;
    if (x == 'carnauba') return true;
    if (x == 'carpalia') return true;
    if (x == 'casa') return true;
    if (x == 'casaba') return true;
    if (x == 'casava') return true;
    if (x == 'cascara') return true;
    if (x == 'cassaba') return true;
    if (x == 'cassava') return true;
    if (x == 'cassia') return true;
    if (x == 'catalpa') return true;
    if (x == 'catena') return true;
    if (x == 'cathedra') return true;
    if (x == 'cattleya') return true;
    if (x == 'cavalla') return true;
    if (x == 'cavatina') return true;
    if (x == 'ceca') return true;
    if (x == 'cedilla') return true;
    if (x == 'cedula') return true;
    if (x == 'ceiba') return true;
    if (x == 'celesta') return true;
    if (x == 'cella') return true;
    if (x == 'celomata') return true;
    if (x == 'cementa') return true;
    if (x == 'centra') return true;
    if (x == 'cercaria') return true;
    if (x == 'cerebella') return true;
    if (x == 'cerebra') return true;
    if (x == 'ceria') return true;
    if (x == 'cesta') return true;
    if (x == 'cesura') return true;
    if (x == 'chacma') return true;
    if (x == 'chaeta') return true;
    if (x == 'chalaza') return true;
    if (x == 'chaqueta') return true;
    if (x == 'charisma') return true;
    if (x == 'charismata') return true;
    if (x == 'charka') return true;
    if (x == 'charkha') return true;
    if (x == 'chela') return true;
    if (x == 'chia') return true;
    if (x == 'chiasma') return true;
    if (x == 'chiasmata') return true;
    if (x == 'chickpea') return true;
    if (x == 'chimaera') return true;
    if (x == 'chimera') return true;
    if (x == 'chimla') return true;
    if (x == 'china') return true;
    if (x == 'chinchilla') return true;
    if (x == 'cholera') return true;
    if (x == 'cholla') return true;
    if (x == 'chorea') return true;
    if (x == 'chrisma') return true;
    if (x == 'chroma') return true;
    if (x == 'chromophobia') return true;
    if (x == 'chufa') return true;
    if (x == 'chukka') return true;
    if (x == 'chutzpa') return true;
    if (x == 'ciboria') return true;
    if (x == 'cicada') return true;
    if (x == 'cicala') return true;
    if (x == 'cilia') return true;
    if (x == 'cinchona') return true;
    if (x == 'cinema') return true;
    if (x == 'cingula') return true;
    if (x == 'circa') return true;
    if (x == 'cisterna') return true;
    if (x == 'cithara') return true;
    if (x == 'citola') return true;
    if (x == 'clarkia') return true;
    if (x == 'claustrophobia') return true;
    if (x == 'clitella') return true;
    if (x == 'cloaca') return true;
    if (x == 'coagula') return true;
    if (x == 'coala') return true;
    if (x == 'cobia') return true;
    if (x == 'cobra') return true;
    if (x == 'coca') return true;
    if (x == 'coccidia') return true;
    if (x == 'cochlea') return true;
    if (x == 'cocinera') return true;
    if (x == 'cocoa') return true;
    if (x == 'cocobola') return true;
    if (x == 'coda') return true;
    if (x == 'codeia') return true;
    if (x == 'codeina') return true;
    if (x == 'coelomata') return true;
    if (x == 'cognomina') return true;
    if (x == 'cola') return true;
    if (x == 'collegia') return true;
    if (x == 'colluvia') return true;
    if (x == 'collyria') return true;
    if (x == 'colza') return true;
    if (x == 'coma') return true;
    if (x == 'comatula') return true;
    if (x == 'comitia') return true;
    if (x == 'comma') return true;
    if (x == 'commata') return true;
    if (x == 'compendia') return true;
    if (x == 'concertina') return true;
    if (x == 'concha') return true;
    if (x == 'conferva') return true;
    if (x == 'conga') return true;
    if (x == 'conidia') return true;
    if (x == 'contagia') return true;
    if (x == 'continua') return true;
    if (x == 'contra') return true;
    if (x == 'copaiba') return true;
    if (x == 'coppra') return true;
    if (x == 'copra') return true;
    if (x == 'copremia') return true;
    if (x == 'copula') return true;
    if (x == 'coquina') return true;
    if (x == 'corbina') return true;
    if (x == 'cordoba') return true;
    if (x == 'coremia') return true;
    if (x == 'coria') return true;
    if (x == 'cornea') return true;
    if (x == 'cornua') return true;
    if (x == 'cornucopia') return true;
    if (x == 'corolla') return true;
    if (x == 'corona') return true;
    if (x == 'corpora') return true;
    if (x == 'corrida') return true;
    if (x == 'corvina') return true;
    if (x == 'coryza') return true;
    if (x == 'costa') return true;
    if (x == 'cotta') return true;
    if (x == 'counterguerrila') return true;
    if (x == 'cowpea') return true;
    if (x == 'coxa') return true;
    if (x == 'coxalgia') return true;
    if (x == 'crania') return true;
    if (x == 'credenda') return true;
    if (x == 'credenza') return true;
    if (x == 'crissa') return true;
    if (x == 'crista') return true;
    if (x == 'criteria') return true;
    if (x == 'crura') return true;
    if (x == 'ctenidia') return true;
    if (x == 'cubicula') return true;
    if (x == 'cuesta') return true;
    if (x == 'culpa') return true;
    if (x == 'cupola') return true;
    if (x == 'cuppa') return true;
    if (x == 'cupula') return true;
    if (x == 'curacoa') return true;
    if (x == 'curara') return true;
    if (x == 'curcuma') return true;
    if (x == 'curia') return true;
    if (x == 'curiosa') return true;
    if (x == 'cuticula') return true;
    if (x == 'cyclopaedia') return true;
    if (x == 'cyclopedia') return true;
    if (x == 'cyclorama') return true;
    if (x == 'cyma') return true;
    if (x == 'cymatia') return true;
    if (x == 'cynophobia') return true;
    if (x == 'cypsela') return true;
    if (x == 'czarevna') return true;
    if (x == 'czarina') return true;
    if (x == 'czaritza') return true;
    return nil;
  }
;
twiEscAP: TwiEscDataObject
  firstLetter = 'a'
  lastLetter  = 'p'
  isGoodWord(x) {
    if (x == 'abamp') return true;
    if (x == 'acquaintanceship') return true;
    if (x == 'agitprop') return true;
    if (x == 'airdrop') return true;
    if (x == 'airship') return true;
    if (x == 'airstrip') return true;
    if (x == 'alp') return true;
    if (x == 'ambassadorship') return true;
    if (x == 'amidship') return true;
    if (x == 'amp') return true;
    if (x == 'anticensorship') return true;
    if (x == 'anviltop') return true;
    if (x == 'apocarp') return true;
    if (x == 'apostleship') return true;
    if (x == 'apprenticeship') return true;
    if (x == 'archbishop') return true;
    if (x == 'ascocarp') return true;
    if (x == 'asleep') return true;
    if (x == 'asp') return true;
    if (x == 'atop') return true;
    if (x == 'atrip') return true;
    if (x == 'authorship') return true;
    return nil;
  }
;
twiEscPE: TwiEscDataObject
  firstLetter = 'p'
  lastLetter  = 'e'
  isGoodWord(x) {
    if (x < 'pf') {                     // PA-PE
      if (isGoodWordPA(x)) return true;
      else return nil;
    }
    else if (x < 'pr') {                // PF-PQ
      if (isGoodWordPF(x)) return true;
      else return nil;
    }
    else {                              // PR-PZ
      if (isGoodWordPR(x)) return true;
      else return nil;
    }
  }
  isGoodWordPA(x) {
    if (x == 'pace') return true;
    if (x == 'packable') return true;
    if (x == 'package') return true;
    if (x == 'paddle') return true;
    if (x == 'padle') return true;
    if (x == 'padre') return true;
    if (x == 'padrone') return true;
    if (x == 'paganise') return true;
    if (x == 'paganize') return true;
    if (x == 'page') return true;
    if (x == 'paginate') return true;
    if (x == 'paise') return true;
    if (x == 'palace') return true;
    if (x == 'palatable') return true;
    if (x == 'palate') return true;
    if (x == 'palatine') return true;
    if (x == 'pale') return true;
    if (x == 'paleae') return true;
    if (x == 'paleface') return true;
    if (x == 'palestrae') return true;
    if (x == 'palette') return true;
    if (x == 'palewise') return true;
    if (x == 'palindrome') return true;
    if (x == 'palinode') return true;
    if (x == 'palisade') return true;
    if (x == 'pallette') return true;
    if (x == 'palliate') return true;
    if (x == 'palliative') return true;
    if (x == 'palmate') return true;
    if (x == 'palmette') return true;
    if (x == 'palmlike') return true;
    if (x == 'palpable') return true;
    if (x == 'palpate') return true;
    if (x == 'palpebrae') return true;
    if (x == 'palpitate') return true;
    if (x == 'panache') return true;
    if (x == 'pancake') return true;
    if (x == 'pandore') return true;
    if (x == 'pane') return true;
    if (x == 'panhandle') return true;
    if (x == 'panicle') return true;
    if (x == 'panne') return true;
    if (x == 'panoche') return true;
    if (x == 'panpipe') return true;
    if (x == 'pantie') return true;
    if (x == 'pantile') return true;
    if (x == 'pantofle') return true;
    if (x == 'pantomime') return true;
    if (x == 'papillae') return true;
    if (x == 'papoose') return true;
    if (x == 'pappoose') return true;
    if (x == 'pappose') return true;
    if (x == 'papulae') return true;
    if (x == 'papule') return true;
    if (x == 'papulose') return true;
    if (x == 'papyrine') return true;
    if (x == 'parable') return true;
    if (x == 'parachute') return true;
    if (x == 'parade') return true;
    if (x == 'paradise') return true;
    if (x == 'paragoge') return true;
    if (x == 'paralyse') return true;
    if (x == 'paralyze') return true;
    if (x == 'paraphrase') return true;
    if (x == 'parasite') return true;
    if (x == 'paravane') return true;
    if (x == 'pardee') return true;
    if (x == 'pardie') return true;
    if (x == 'pardine') return true;
    if (x == 'pardonable') return true;
    if (x == 'pare') return true;
    if (x == 'parentage') return true;
    if (x == 'pareve') return true;
    if (x == 'parge') return true;
    if (x == 'parklike') return true;
    if (x == 'parlance') return true;
    if (x == 'parlante') return true;
    if (x == 'parle') return true;
    if (x == 'parole') return true;
    if (x == 'parolee') return true;
    if (x == 'parridge') return true;
    if (x == 'parsable') return true;
    if (x == 'parse') return true;
    if (x == 'parsonage') return true;
    if (x == 'partake') return true;
    if (x == 'parterre') return true;
    if (x == 'partible') return true;
    if (x == 'participate') return true;
    if (x == 'participle') return true;
    if (x == 'particle') return true;
    if (x == 'partite') return true;
    if (x == 'partridge') return true;
    if (x == 'parure') return true;
    if (x == 'parve') return true;
    if (x == 'parvenue') return true;
    if (x == 'parvise') return true;
    if (x == 'pase') return true;
    if (x == 'passable') return true;
    if (x == 'passade') return true;
    if (x == 'passage') return true;
    if (x == 'passe') return true;
    if (x == 'passee') return true;
    if (x == 'passerine') return true;
    if (x == 'passible') return true;
    if (x == 'passionate') return true;
    if (x == 'passive') return true;
    if (x == 'paste') return true;
    if (x == 'pasteurise') return true;
    if (x == 'pasteurize') return true;
    if (x == 'pastiche') return true;
    if (x == 'pastille') return true;
    if (x == 'pastime') return true;
    if (x == 'pastorate') return true;
    if (x == 'pasture') return true;
    if (x == 'pate') return true;
    if (x == 'patellae') return true;
    if (x == 'patentee') return true;
    if (x == 'patience') return true;
    if (x == 'patinae') return true;
    if (x == 'patine') return true;
    if (x == 'patricide') return true;
    if (x == 'patronage') return true;
    if (x == 'patronise') return true;
    if (x == 'patronize') return true;
    if (x == 'pattee') return true;
    if (x == 'pattie') return true;
    if (x == 'pauperise') return true;
    if (x == 'pauperize') return true;
    if (x == 'pause') return true;
    if (x == 'pavane') return true;
    if (x == 'pave') return true;
    if (x == 'pavise') return true;
    if (x == 'pavonine') return true;
    if (x == 'pawnable') return true;
    if (x == 'pawnage') return true;
    if (x == 'pawnee') return true;
    if (x == 'payable') return true;
    if (x == 'payee') return true;
    if (x == 'pe') return true;
    if (x == 'peace') return true;
    if (x == 'peaceable') return true;
    if (x == 'peacetime') return true;
    if (x == 'peage') return true;
    if (x == 'peaklike') return true;
    if (x == 'pealike') return true;
    if (x == 'pearlite') return true;
    if (x == 'pease') return true;
    if (x == 'pebble') return true;
    if (x == 'peccable') return true;
    if (x == 'pectase') return true;
    if (x == 'pectate') return true;
    if (x == 'pectise') return true;
    if (x == 'pectize') return true;
    if (x == 'peculate') return true;
    if (x == 'pedagogue') return true;
    if (x == 'pedate') return true;
    if (x == 'peddle') return true;
    if (x == 'pedicle') return true;
    if (x == 'pedicure') return true;
    if (x == 'pedigree') return true;
    if (x == 'peduncle') return true;
    if (x == 'pee') return true;
    if (x == 'peelable') return true;
    if (x == 'peephole') return true;
    if (x == 'peerage') return true;
    if (x == 'peerie') return true;
    if (x == 'peeve') return true;
    if (x == 'peewee') return true;
    if (x == 'peglike') return true;
    if (x == 'peise') return true;
    if (x == 'peke') return true;
    if (x == 'pekoe') return true;
    if (x == 'pelage') return true;
    if (x == 'pele') return true;
    if (x == 'pelerine') return true;
    if (x == 'pelisse') return true;
    if (x == 'pelite') return true;
    if (x == 'pelletise') return true;
    if (x == 'pelletize') return true;
    if (x == 'pellicle') return true;
    if (x == 'peltate') return true;
    if (x == 'pemoline') return true;
    if (x == 'penalise') return true;
    if (x == 'penalize') return true;
    if (x == 'penance') return true;
    if (x == 'pence') return true;
    if (x == 'penetrable') return true;
    if (x == 'penetrative') return true;
    if (x == 'penile') return true;
    if (x == 'penitence') return true;
    if (x == 'penknife') return true;
    if (x == 'penlite') return true;
    if (x == 'pennae') return true;
    if (x == 'penname') return true;
    if (x == 'pennate') return true;
    if (x == 'pennine') return true;
    if (x == 'penoche') return true;
    if (x == 'pensee') return true;
    if (x == 'pensile') return true;
    if (x == 'pensione') return true;
    if (x == 'pensive') return true;
    if (x == 'pentacle') return true;
    if (x == 'pentane') return true;
    if (x == 'penthouse') return true;
    if (x == 'pentose') return true;
    if (x == 'penuche') return true;
    if (x == 'penuchle') return true;
    if (x == 'penuckle') return true;
    if (x == 'penultimate') return true;
    if (x == 'penumbrae') return true;
    if (x == 'peonage') return true;
    if (x == 'people') return true;
    if (x == 'pepsine') return true;
    if (x == 'peptide') return true;
    if (x == 'peptise') return true;
    if (x == 'peptize') return true;
    if (x == 'peptone') return true;
    if (x == 'perambulate') return true;
    if (x == 'percale') return true;
    if (x == 'perceivable') return true;
    if (x == 'perceive') return true;
    if (x == 'percentage') return true;
    if (x == 'percentile') return true;
    if (x == 'perceptible') return true;
    if (x == 'perceptive') return true;
    if (x == 'percolate') return true;
    if (x == 'perdue') return true;
    if (x == 'pere') return true;
    if (x == 'perfectible') return true;
    if (x == 'perforate') return true;
    if (x == 'perforce') return true;
    if (x == 'performance') return true;
    if (x == 'perfume') return true;
    if (x == 'perfuse') return true;
    if (x == 'pericopae') return true;
    if (x == 'pericope') return true;
    if (x == 'perigee') return true;
    if (x == 'perilune') return true;
    if (x == 'perique') return true;
    if (x == 'periscope') return true;
    if (x == 'perishable') return true;
    if (x == 'perjure') return true;
    if (x == 'perlite') return true;
    if (x == 'permanence') return true;
    if (x == 'permeable') return true;
    if (x == 'permease') return true;
    if (x == 'permeate') return true;
    if (x == 'permissible') return true;
    if (x == 'permissive') return true;
    if (x == 'permute') return true;
    if (x == 'perorate') return true;
    if (x == 'peroxide') return true;
    if (x == 'perpetrate') return true;
    if (x == 'perpetuate') return true;
    if (x == 'perquisite') return true;
    if (x == 'perse') return true;
    if (x == 'persecute') return true;
    if (x == 'perseverance') return true;
    if (x == 'persevere') return true;
    if (x == 'persistence') return true;
    if (x == 'personable') return true;
    if (x == 'personae') return true;
    if (x == 'personage') return true;
    if (x == 'personalise') return true;
    if (x == 'personalize') return true;
    if (x == 'perspective') return true;
    if (x == 'perspire') return true;
    if (x == 'persuade') return true;
    if (x == 'persuasive') return true;
    if (x == 'pertinence') return true;
    if (x == 'peruke') return true;
    if (x == 'peruse') return true;
    if (x == 'pervade') return true;
    if (x == 'pervasive') return true;
    if (x == 'perverse') return true;
    if (x == 'pesade') return true;
    if (x == 'pesthole') return true;
    if (x == 'pestilence') return true;
    if (x == 'pestle') return true;
    if (x == 'petabyte') return true;
    if (x == 'petaline') return true;
    if (x == 'petechiae') return true;
    if (x == 'petiole') return true;
    if (x == 'petite') return true;
    if (x == 'pettle') return true;
    if (x == 'petulance') return true;
    if (x == 'petuntse') return true;
    if (x == 'petuntze') return true;
    if (x == 'pewee') return true;
    if (x == 'peyote') return true;
    return nil;
  }
  isGoodWordPF(x) {
    if (x == 'pfennige') return true;
    if (x == 'phage') return true;
    if (x == 'phalange') return true;
    if (x == 'pharisee') return true;
    if (x == 'phase') return true;
    if (x == 'philistine') return true;
    if (x == 'philosophise') return true;
    if (x == 'philosophize') return true;
    if (x == 'philtre') return true;
    if (x == 'phocine') return true;
    if (x == 'phoebe') return true;
    if (x == 'phonate') return true;
    if (x == 'phone') return true;
    if (x == 'phoneme') return true;
    if (x == 'phorate') return true;
    if (x == 'phosgene') return true;
    if (x == 'phosphatase') return true;
    if (x == 'phosphate') return true;
    if (x == 'phosphorescence') return true;
    if (x == 'photosynthesise') return true;
    if (x == 'photosynthesize') return true;
    if (x == 'phrase') return true;
    if (x == 'phylae') return true;
    if (x == 'phyle') return true;
    if (x == 'phyllite') return true;
    if (x == 'phyllode') return true;
    if (x == 'phyllome') return true;
    if (x == 'physique') return true;
    if (x == 'phytane') return true;
    if (x == 'piaffe') return true;
    if (x == 'piastre') return true;
    if (x == 'piazze') return true;
    if (x == 'picayune') return true;
    if (x == 'pice') return true;
    if (x == 'pickaxe') return true;
    if (x == 'pickle') return true;
    if (x == 'picoline') return true;
    if (x == 'picolitre') return true;
    if (x == 'picometre') return true;
    if (x == 'picotee') return true;
    if (x == 'picrate') return true;
    if (x == 'picrite') return true;
    if (x == 'picture') return true;
    if (x == 'picturesque') return true;
    if (x == 'piddle') return true;
    if (x == 'pie') return true;
    if (x == 'piece') return true;
    if (x == 'pierce') return true;
    if (x == 'piffle') return true;
    if (x == 'pigeonhole') return true;
    if (x == 'piggie') return true;
    if (x == 'pikake') return true;
    if (x == 'pike') return true;
    if (x == 'pile') return true;
    if (x == 'pileate') return true;
    if (x == 'pilgrimage') return true;
    if (x == 'pillage') return true;
    if (x == 'pillowcase') return true;
    if (x == 'pilose') return true;
    if (x == 'pilotage') return true;
    if (x == 'pilule') return true;
    if (x == 'pimple') return true;
    if (x == 'pinafore') return true;
    if (x == 'pinbone') return true;
    if (x == 'pine') return true;
    if (x == 'pineapple') return true;
    if (x == 'pinecone') return true;
    if (x == 'pinelike') return true;
    if (x == 'pinene') return true;
    if (x == 'pinhole') return true;
    if (x == 'pinite') return true;
    if (x == 'pinkeye') return true;
    if (x == 'pinkie') return true;
    if (x == 'pinnace') return true;
    if (x == 'pinnacle') return true;
    if (x == 'pinnae') return true;
    if (x == 'pinnate') return true;
    if (x == 'pinnulae') return true;
    if (x == 'pinnule') return true;
    if (x == 'pinochle') return true;
    if (x == 'pinocle') return true;
    if (x == 'pinole') return true;
    if (x == 'pintle') return true;
    if (x == 'pintsize') return true;
    if (x == 'pinwale') return true;
    if (x == 'pipage') return true;
    if (x == 'pipe') return true;
    if (x == 'pipeage') return true;
    if (x == 'pipelike') return true;
    if (x == 'pipeline') return true;
    if (x == 'piperine') return true;
    if (x == 'pipette') return true;
    if (x == 'pique') return true;
    if (x == 'pirate') return true;
    if (x == 'pirogue') return true;
    if (x == 'piroque') return true;
    if (x == 'pirouette') return true;
    if (x == 'piscinae') return true;
    if (x == 'piscine') return true;
    if (x == 'pismire') return true;
    if (x == 'pisolite') return true;
    if (x == 'pistache') return true;
    if (x == 'pistillate') return true;
    if (x == 'pistole') return true;
    if (x == 'pitchblende') return true;
    if (x == 'pitiable') return true;
    if (x == 'pittance') return true;
    if (x == 'pixie') return true;
    if (x == 'pizzle') return true;
    if (x == 'placable') return true;
    if (x == 'placate') return true;
    if (x == 'place') return true;
    if (x == 'placentae') return true;
    if (x == 'plage') return true;
    if (x == 'plagiarise') return true;
    if (x == 'plagiarize') return true;
    if (x == 'plague') return true;
    if (x == 'plaice') return true;
    if (x == 'plaintive') return true;
    if (x == 'planate') return true;
    if (x == 'planche') return true;
    if (x == 'plane') return true;
    if (x == 'planulae') return true;
    if (x == 'plaque') return true;
    if (x == 'platane') return true;
    if (x == 'plate') return true;
    if (x == 'platitude') return true;
    if (x == 'plausible') return true;
    if (x == 'plausive') return true;
    if (x == 'playable') return true;
    if (x == 'playhouse') return true;
    if (x == 'playlike') return true;
    if (x == 'playmate') return true;
    if (x == 'playtime') return true;
    if (x == 'please') return true;
    if (x == 'pleasurable') return true;
    if (x == 'pleasure') return true;
    if (x == 'plebe') return true;
    if (x == 'plebiscite') return true;
    if (x == 'pledge') return true;
    if (x == 'pledgee') return true;
    if (x == 'plenitude') return true;
    if (x == 'pleurae') return true;
    if (x == 'pliable') return true;
    if (x == 'plicae') return true;
    if (x == 'plicate') return true;
    if (x == 'plie') return true;
    if (x == 'plimsole') return true;
    if (x == 'pliskie') return true;
    if (x == 'plisse') return true;
    if (x == 'plosive') return true;
    if (x == 'plottage') return true;
    if (x == 'plowable') return true;
    if (x == 'plowshare') return true;
    if (x == 'plumage') return true;
    if (x == 'plumate') return true;
    if (x == 'plume') return true;
    if (x == 'plumlike') return true;
    if (x == 'plumose') return true;
    if (x == 'plumule') return true;
    if (x == 'plunge') return true;
    if (x == 'pluralise') return true;
    if (x == 'pluralize') return true;
    if (x == 'plussage') return true;
    if (x == 'pluviose') return true;
    if (x == 'pocketknife') return true;
    if (x == 'podite') return true;
    if (x == 'podomere') return true;
    if (x == 'poechore') return true;
    if (x == 'poetise') return true;
    if (x == 'poetize') return true;
    if (x == 'poetlike') return true;
    if (x == 'pointe') return true;
    if (x == 'poise') return true;
    if (x == 'poke') return true;
    if (x == 'polarise') return true;
    if (x == 'polarize') return true;
    if (x == 'pole') return true;
    if (x == 'poleaxe') return true;
    if (x == 'polemise') return true;
    if (x == 'polemize') return true;
    if (x == 'police') return true;
    if (x == 'polite') return true;
    if (x == 'pollee') return true;
    if (x == 'pollinate') return true;
    if (x == 'pollute') return true;
    if (x == 'polyene') return true;
    if (x == 'polygene') return true;
    if (x == 'polypide') return true;
    if (x == 'polypore') return true;
    if (x == 'polysome') return true;
    if (x == 'polysyllable') return true;
    if (x == 'polytene') return true;
    if (x == 'polytype') return true;
    if (x == 'pomace') return true;
    if (x == 'pomade') return true;
    if (x == 'pome') return true;
    if (x == 'pomegranate') return true;
    if (x == 'pommee') return true;
    if (x == 'ponce') return true;
    if (x == 'pondville') return true;
    if (x == 'pone') return true;
    if (x == 'pongee') return true;
    if (x == 'pontificate') return true;
    if (x == 'pontine') return true;
    if (x == 'poodle') return true;
    if (x == 'pope') return true;
    if (x == 'popelike') return true;
    if (x == 'popple') return true;
    if (x == 'populace') return true;
    if (x == 'popularise') return true;
    if (x == 'popularize') return true;
    if (x == 'populate') return true;
    if (x == 'porcine') return true;
    if (x == 'porcupine') return true;
    if (x == 'pore') return true;
    if (x == 'porkpie') return true;
    if (x == 'porose') return true;
    if (x == 'porpoise') return true;
    if (x == 'porridge') return true;
    if (x == 'portable') return true;
    if (x == 'portage') return true;
    if (x == 'portance') return true;
    if (x == 'porte') return true;
    if (x == 'porterhouse') return true;
    if (x == 'porthole') return true;
    if (x == 'portiere') return true;
    if (x == 'portraiture') return true;
    if (x == 'pose') return true;
    if (x == 'positive') return true;
    if (x == 'posse') return true;
    if (x == 'possessive') return true;
    if (x == 'possible') return true;
    if (x == 'postadolescence') return true;
    if (x == 'postage') return true;
    if (x == 'postbaccalaureate') return true;
    if (x == 'postcavae') return true;
    if (x == 'postcollege') return true;
    if (x == 'postdate') return true;
    if (x == 'postexercise') return true;
    if (x == 'postface') return true;
    if (x == 'postgraduate') return true;
    if (x == 'posthaste') return true;
    if (x == 'posthole') return true;
    if (x == 'postiche') return true;
    if (x == 'postique') return true;
    if (x == 'postlude') return true;
    if (x == 'postoperative') return true;
    if (x == 'postpone') return true;
    if (x == 'postulate') return true;
    if (x == 'posture') return true;
    if (x == 'potable') return true;
    if (x == 'potage') return true;
    if (x == 'potence') return true;
    if (x == 'potentate') return true;
    if (x == 'pothole') return true;
    if (x == 'pothouse') return true;
    if (x == 'potiche') return true;
    if (x == 'potlache') return true;
    if (x == 'potlike') return true;
    if (x == 'potpie') return true;
    if (x == 'potsie') return true;
    if (x == 'potstone') return true;
    if (x == 'pottage') return true;
    if (x == 'pottle') return true;
    if (x == 'pouffe') return true;
    if (x == 'poularde') return true;
    if (x == 'poultice') return true;
    if (x == 'pounce') return true;
    if (x == 'poundage') return true;
    if (x == 'pourable') return true;
    if (x == 'poussie') return true;
    return nil;
  }
  isGoodWordPR(x) {
    if (x == 'practicable') return true;
    if (x == 'practice') return true;
    if (x == 'practise') return true;
    if (x == 'praecipe') return true;
    if (x == 'prairie') return true;
    if (x == 'praise') return true;
    if (x == 'praline') return true;
    if (x == 'prance') return true;
    if (x == 'prase') return true;
    if (x == 'prate') return true;
    if (x == 'pratique') return true;
    if (x == 'prattle') return true;
    if (x == 'preadolescence') return true;
    if (x == 'preallocate') return true;
    if (x == 'preamble') return true;
    if (x == 'prearrange') return true;
    if (x == 'preassemble') return true;
    if (x == 'preauthorise') return true;
    if (x == 'preauthorize') return true;
    if (x == 'prebattle') return true;
    if (x == 'precalculate') return true;
    if (x == 'precavae') return true;
    if (x == 'precede') return true;
    if (x == 'precedence') return true;
    if (x == 'precipe') return true;
    if (x == 'precipice') return true;
    if (x == 'precipitate') return true;
    if (x == 'precise') return true;
    if (x == 'preclearance') return true;
    if (x == 'preclude') return true;
    if (x == 'precollege') return true;
    if (x == 'precompute') return true;
    if (x == 'preconceive') return true;
    if (x == 'preconference') return true;
    if (x == 'precure') return true;
    if (x == 'predate') return true;
    if (x == 'predefine') return true;
    if (x == 'predeparture') return true;
    if (x == 'predesignate') return true;
    if (x == 'predestine') return true;
    if (x == 'predetermine') return true;
    if (x == 'predicate') return true;
    if (x == 'predictable') return true;
    if (x == 'predictive') return true;
    if (x == 'predischarge') return true;
    if (x == 'predispose') return true;
    if (x == 'prednisone') return true;
    if (x == 'predominance') return true;
    if (x == 'predominate') return true;
    if (x == 'pree') return true;
    if (x == 'preemie') return true;
    if (x == 'preeminence') return true;
    if (x == 'preexistence') return true;
    if (x == 'preface') return true;
    if (x == 'prefecture') return true;
    if (x == 'preferable') return true;
    if (x == 'preference') return true;
    if (x == 'prefigure') return true;
    if (x == 'pregame') return true;
    if (x == 'prehensile') return true;
    if (x == 'preimmunise') return true;
    if (x == 'preimmunize') return true;
    if (x == 'preinoculate') return true;
    if (x == 'prejudge') return true;
    if (x == 'prejudice') return true;
    if (x == 'prelate') return true;
    if (x == 'prelude') return true;
    if (x == 'premature') return true;
    if (x == 'premeditate') return true;
    if (x == 'premie') return true;
    if (x == 'premiere') return true;
    if (x == 'premise') return true;
    if (x == 'premorse') return true;
    if (x == 'premune') return true;
    if (x == 'prename') return true;
    if (x == 'prentice') return true;
    if (x == 'prepackage') return true;
    if (x == 'prepare') return true;
    if (x == 'prepense') return true;
    if (x == 'preplace') return true;
    if (x == 'preponderance') return true;
    if (x == 'preponderate') return true;
    if (x == 'preppie') return true;
    if (x == 'prepuce') return true;
    if (x == 'prepurchase') return true;
    if (x == 'prerelease') return true;
    if (x == 'prerequisite') return true;
    if (x == 'prerogative') return true;
    if (x == 'presage') return true;
    if (x == 'prescience') return true;
    if (x == 'prescore') return true;
    if (x == 'prescribe') return true;
    if (x == 'prese') return true;
    if (x == 'presence') return true;
    if (x == 'presentable') return true;
    if (x == 'preservative') return true;
    if (x == 'preserve') return true;
    if (x == 'preshape') return true;
    if (x == 'preside') return true;
    if (x == 'pressure') return true;
    if (x == 'pressurise') return true;
    if (x == 'pressurize') return true;
    if (x == 'presterilise') return true;
    if (x == 'presterilize') return true;
    if (x == 'prestige') return true;
    if (x == 'prestrike') return true;
    if (x == 'presumable') return true;
    if (x == 'presume') return true;
    if (x == 'presumptive') return true;
    if (x == 'presuppose') return true;
    if (x == 'pretaste') return true;
    if (x == 'pretence') return true;
    if (x == 'pretense') return true;
    if (x == 'preunite') return true;
    if (x == 'prevalence') return true;
    if (x == 'prevaricate') return true;
    if (x == 'preventable') return true;
    if (x == 'preventative') return true;
    if (x == 'preventive') return true;
    if (x == 'previse') return true;
    if (x == 'prevue') return true;
    if (x == 'price') return true;
    if (x == 'prickle') return true;
    if (x == 'pride') return true;
    if (x == 'primage') return true;
    if (x == 'primate') return true;
    if (x == 'prime') return true;
    if (x == 'primine') return true;
    if (x == 'primitive') return true;
    if (x == 'primrose') return true;
    if (x == 'primsie') return true;
    if (x == 'prince') return true;
    if (x == 'principe') return true;
    if (x == 'principle') return true;
    if (x == 'printable') return true;
    if (x == 'priorate') return true;
    if (x == 'prioritise') return true;
    if (x == 'prioritize') return true;
    if (x == 'prise') return true;
    if (x == 'prisere') return true;
    if (x == 'pristane') return true;
    if (x == 'pristine') return true;
    if (x == 'prithee') return true;
    if (x == 'private') return true;
    if (x == 'privilege') return true;
    if (x == 'prize') return true;
    if (x == 'probable') return true;
    if (x == 'probate') return true;
    if (x == 'probe') return true;
    if (x == 'procaine') return true;
    if (x == 'procedure') return true;
    if (x == 'procrastinate') return true;
    if (x == 'procreate') return true;
    if (x == 'procreative') return true;
    if (x == 'procurable') return true;
    if (x == 'procure') return true;
    if (x == 'prodrome') return true;
    if (x == 'produce') return true;
    if (x == 'productive') return true;
    if (x == 'proette') return true;
    if (x == 'profane') return true;
    if (x == 'professionalise') return true;
    if (x == 'professionalize') return true;
    if (x == 'profile') return true;
    if (x == 'profitable') return true;
    if (x == 'profligate') return true;
    if (x == 'profuse') return true;
    if (x == 'prognose') return true;
    if (x == 'prognosticate') return true;
    if (x == 'prograde') return true;
    if (x == 'programmable') return true;
    if (x == 'programme') return true;
    if (x == 'progressive') return true;
    if (x == 'prohibitive') return true;
    if (x == 'projectile') return true;
    if (x == 'prolapse') return true;
    if (x == 'prolate') return true;
    if (x == 'prole') return true;
    if (x == 'proliferate') return true;
    if (x == 'proline') return true;
    if (x == 'prologue') return true;
    if (x == 'prolonge') return true;
    if (x == 'promenade') return true;
    if (x == 'prominence') return true;
    if (x == 'promise') return true;
    if (x == 'promisee') return true;
    if (x == 'promote') return true;
    if (x == 'promulge') return true;
    if (x == 'pronate') return true;
    if (x == 'prone') return true;
    if (x == 'pronounce') return true;
    if (x == 'pronounceable') return true;
    if (x == 'propagandise') return true;
    if (x == 'propagandize') return true;
    if (x == 'propagate') return true;
    if (x == 'propane') return true;
    if (x == 'propene') return true;
    if (x == 'propense') return true;
    if (x == 'prophage') return true;
    if (x == 'prophase') return true;
    if (x == 'propine') return true;
    if (x == 'propitiate') return true;
    if (x == 'propone') return true;
    if (x == 'proportionate') return true;
    if (x == 'propose') return true;
    if (x == 'propulsive') return true;
    if (x == 'prorate') return true;
    if (x == 'prorogue') return true;
    if (x == 'proscribe') return true;
    if (x == 'prose') return true;
    if (x == 'prosecute') return true;
    if (x == 'proselyte') return true;
    if (x == 'proselytise') return true;
    if (x == 'proselytize') return true;
    if (x == 'prospective') return true;
    if (x == 'prostate') return true;
    if (x == 'prostitute') return true;
    if (x == 'prostrate') return true;
    if (x == 'prostyle') return true;
    if (x == 'protease') return true;
    if (x == 'protective') return true;
    if (x == 'protectorate') return true;
    if (x == 'protege') return true;
    if (x == 'protegee') return true;
    if (x == 'proteide') return true;
    if (x == 'proteose') return true;
    if (x == 'prototype') return true;
    if (x == 'protrude') return true;
    if (x == 'protrusive') return true;
    if (x == 'protuberance') return true;
    if (x == 'protyle') return true;
    if (x == 'provable') return true;
    if (x == 'prove') return true;
    if (x == 'provide') return true;
    if (x == 'providence') return true;
    if (x == 'province') return true;
    if (x == 'provocative') return true;
    if (x == 'provoke') return true;
    if (x == 'prude') return true;
    if (x == 'prudence') return true;
    if (x == 'pruinose') return true;
    if (x == 'prunable') return true;
    if (x == 'prune') return true;
    if (x == 'prunelle') return true;
    if (x == 'prythee') return true;
    if (x == 'psammite') return true;
    if (x == 'psephite') return true;
    if (x == 'pseudoscience') return true;
    if (x == 'psoae') return true;
    if (x == 'psyche') return true;
    if (x == 'psychoanalyze') return true;
    if (x == 'pterylae') return true;
    if (x == 'ptomaine') return true;
    if (x == 'publicise') return true;
    if (x == 'publicize') return true;
    if (x == 'puce') return true;
    if (x == 'puddle') return true;
    if (x == 'puerile') return true;
    if (x == 'pugaree') return true;
    if (x == 'puggaree') return true;
    if (x == 'puggree') return true;
    if (x == 'pugree') return true;
    if (x == 'puisne') return true;
    if (x == 'puke') return true;
    if (x == 'pulchritude') return true;
    if (x == 'pule') return true;
    if (x == 'pulicene') return true;
    if (x == 'pulicide') return true;
    if (x == 'pulque') return true;
    if (x == 'pulsate') return true;
    if (x == 'pulse') return true;
    if (x == 'pulverise') return true;
    if (x == 'pulverize') return true;
    if (x == 'pumice') return true;
    if (x == 'pumicite') return true;
    if (x == 'pumplike') return true;
    if (x == 'punctate') return true;
    if (x == 'punctuate') return true;
    if (x == 'puncture') return true;
    if (x == 'punishable') return true;
    if (x == 'punitive') return true;
    if (x == 'punkie') return true;
    if (x == 'pupae') return true;
    if (x == 'pupate') return true;
    if (x == 'pupilage') return true;
    if (x == 'purchase') return true;
    if (x == 'pure') return true;
    if (x == 'puree') return true;
    if (x == 'purfle') return true;
    if (x == 'purgative') return true;
    if (x == 'purge') return true;
    if (x == 'purine') return true;
    if (x == 'purline') return true;
    if (x == 'purple') return true;
    if (x == 'purpose') return true;
    if (x == 'purpure') return true;
    if (x == 'purse') return true;
    if (x == 'purslane') return true;
    if (x == 'pursuance') return true;
    if (x == 'pursue') return true;
    if (x == 'purveyance') return true;
    if (x == 'puslike') return true;
    if (x == 'pusslike') return true;
    if (x == 'pustule') return true;
    if (x == 'putative') return true;
    if (x == 'putrefactive') return true;
    if (x == 'puttee') return true;
    if (x == 'puzzle') return true;
    if (x == 'pye') return true;
    if (x == 'pyranose') return true;
    if (x == 'pyre') return true;
    if (x == 'pyrene') return true;
    if (x == 'pyridine') return true;
    if (x == 'pyrite') return true;
    if (x == 'pyrolyze') return true;
    if (x == 'pyrone') return true;
    if (x == 'pyronine') return true;
    if (x == 'pyrope') return true;
    if (x == 'pyroxene') return true;
    if (x == 'pyrrole') return true;
    if (x == 'pyruvate') return true;
    if (x == 'pyxie') return true;
    return nil;
  }
;
twiEscET: TwiEscDataObject
  firstLetter = 'e'
  lastLetter  = 't'
  isGoodWord(x) {
    if (x == 'eagerest') return true;
    if (x == 'eaglet') return true;
    if (x == 'earliest') return true;
    if (x == 'earnest') return true;
    if (x == 'earshot') return true;
    if (x == 'earthiest') return true;
    if (x == 'earthliest') return true;
    if (x == 'earthnut') return true;
    if (x == 'earthset') return true;
    if (x == 'easement') return true;
    if (x == 'easiest') return true;
    if (x == 'east') return true;
    if (x == 'eat') return true;
    if (x == 'ebbet') return true;
    if (x == 'ebullient') return true;
    if (x == 'eclat') return true;
    if (x == 'ecologist') return true;
    if (x == 'economist') return true;
    if (x == 'edgiest') return true;
    if (x == 'edict') return true;
    if (x == 'edit') return true;
    if (x == 'educt') return true;
    if (x == 'eeliest') return true;
    if (x == 'eelpout') return true;
    if (x == 'eeriest') return true;
    if (x == 'effacement') return true;
    if (x == 'effect') return true;
    if (x == 'efferent') return true;
    if (x == 'effervescent') return true;
    if (x == 'efficient') return true;
    if (x == 'effluent') return true;
    if (x == 'effort') return true;
    if (x == 'eft') return true;
    if (x == 'egest') return true;
    if (x == 'eggplant') return true;
    if (x == 'egoist') return true;
    if (x == 'egotist') return true;
    if (x == 'egret') return true;
    if (x == 'eight') return true;
    if (x == 'eject') return true;
    if (x == 'eldest') return true;
    if (x == 'elect') return true;
    if (x == 'electret') return true;
    if (x == 'electromagnet') return true;
    if (x == 'elegant') return true;
    if (x == 'elegist') return true;
    if (x == 'elegit') return true;
    if (x == 'element') return true;
    if (x == 'elephant') return true;
    if (x == 'elicit') return true;
    if (x == 'elitist') return true;
    if (x == 'elmiest') return true;
    if (x == 'eloquent') return true;
    if (x == 'eluant') return true;
    if (x == 'eluent') return true;
    if (x == 'embankment') return true;
    if (x == 'embarrassment') return true;
    if (x == 'embellishment') return true;
    if (x == 'embezzlement') return true;
    if (x == 'embodiment') return true;
    if (x == 'emergent') return true;
    if (x == 'emigrant') return true;
    if (x == 'eminent') return true;
    if (x == 'emit') return true;
    if (x == 'emmet') return true;
    if (x == 'emolument') return true;
    if (x == 'employment') return true;
    if (x == 'emptiest') return true;
    if (x == 'enact') return true;
    if (x == 'enactment') return true;
    if (x == 'encampment') return true;
    if (x == 'enchant') return true;
    if (x == 'enchantment') return true;
    if (x == 'encouragement') return true;
    if (x == 'encroachment') return true;
    if (x == 'encrust') return true;
    if (x == 'encrypt') return true;
    if (x == 'encyst') return true;
    if (x == 'endearment') return true;
    if (x == 'endmost') return true;
    if (x == 'endorsement') return true;
    if (x == 'endowment') return true;
    if (x == 'enforcement') return true;
    if (x == 'enfranchisement') return true;
    if (x == 'engagement') return true;
    if (x == 'engirt') return true;
    if (x == 'englut') return true;
    if (x == 'engraft') return true;
    if (x == 'enhancement') return true;
    if (x == 'enjoyment') return true;
    if (x == 'enlargement') return true;
    if (x == 'enlightenment') return true;
    if (x == 'enlist') return true;
    if (x == 'enlistment') return true;
    if (x == 'enrapt') return true;
    if (x == 'enrichment') return true;
    if (x == 'enrollment') return true;
    if (x == 'enroot') return true;
    if (x == 'enslavement') return true;
    if (x == 'entanglement') return true;
    if (x == 'entertainment') return true;
    if (x == 'enthusiast') return true;
    if (x == 'enticement') return true;
    if (x == 'entomologist') return true;
    if (x == 'entrant') return true;
    if (x == 'entrapment') return true;
    if (x == 'entreat') return true;
    if (x == 'entrenchment') return true;
    if (x == 'entrepot') return true;
    if (x == 'entrust') return true;
    if (x == 'entwist') return true;
    if (x == 'envelopment') return true;
    if (x == 'environment') return true;
    if (x == 'environmentalist') return true;
    if (x == 'eobiont') return true;
    if (x == 'epact') return true;
    if (x == 'epaulet') return true;
    if (x == 'epeeist') return true;
    if (x == 'epiblast') return true;
    if (x == 'epithet') return true;
    if (x == 'equipment') return true;
    if (x == 'equitant') return true;
    if (x == 'equivalent') return true;
    if (x == 'erect') return true;
    if (x == 'ergot') return true;
    if (x == 'erodent') return true;
    if (x == 'errant') return true;
    if (x == 'erst') return true;
    if (x == 'eruct') return true;
    if (x == 'erumpent') return true;
    if (x == 'erupt') return true;
    if (x == 'escapist') return true;
    if (x == 'escargot') return true;
    if (x == 'escarpment') return true;
    if (x == 'eschalot') return true;
    if (x == 'escheat') return true;
    if (x == 'escort') return true;
    if (x == 'escot') return true;
    if (x == 'esculent') return true;
    if (x == 'esprit') return true;
    if (x == 'essayist') return true;
    if (x == 'establishment') return true;
    if (x == 'estrangement') return true;
    if (x == 'estreat') return true;
    if (x == 'esurient') return true;
    if (x == 'et') return true;
    if (x == 'etatist') return true;
    if (x == 'ethicist') return true;
    if (x == 'etymologist') return true;
    if (x == 'eucalypt') return true;
    if (x == 'eugenist') return true;
    if (x == 'eulogist') return true;
    if (x == 'euphuist') return true;
    if (x == 'evacuant') return true;
    if (x == 'evangelist') return true;
    if (x == 'evenest') return true;
    if (x == 'event') return true;
    if (x == 'evert') return true;
    if (x == 'evict') return true;
    if (x == 'evident') return true;
    if (x == 'evilest') return true;
    if (x == 'evillest') return true;
    if (x == 'evolutionist') return true;
    if (x == 'exact') return true;
    if (x == 'exactest') return true;
    if (x == 'exalt') return true;
    if (x == 'excellent') return true;
    if (x == 'except') return true;
    if (x == 'excerpt') return true;
    if (x == 'excitant') return true;
    if (x == 'excitement') return true;
    if (x == 'excrement') return true;
    if (x == 'exeat') return true;
    if (x == 'exempt') return true;
    if (x == 'exert') return true;
    if (x == 'exhalant') return true;
    if (x == 'exhalent') return true;
    if (x == 'exhaust') return true;
    if (x == 'exhibit') return true;
    if (x == 'exhort') return true;
    if (x == 'exigent') return true;
    if (x == 'exist') return true;
    if (x == 'existent') return true;
    if (x == 'exit') return true;
    if (x == 'exorbitant') return true;
    if (x == 'exorcist') return true;
    if (x == 'expect') return true;
    if (x == 'expectant') return true;
    if (x == 'expedient') return true;
    if (x == 'experiment') return true;
    if (x == 'expert') return true;
    if (x == 'explant') return true;
    if (x == 'explicit') return true;
    if (x == 'exploit') return true;
    if (x == 'exponent') return true;
    if (x == 'export') return true;
    if (x == 'exposit') return true;
    if (x == 'exsecant') return true;
    if (x == 'exsect') return true;
    if (x == 'exsert') return true;
    if (x == 'extant') return true;
    if (x == 'extent') return true;
    if (x == 'extinct') return true;
    if (x == 'extort') return true;
    if (x == 'extortionist') return true;
    if (x == 'extract') return true;
    if (x == 'extravagant') return true;
    if (x == 'extravert') return true;
    if (x == 'extremest') return true;
    if (x == 'extrovert') return true;
    if (x == 'exuberant') return true;
    if (x == 'exult') return true;
    if (x == 'exultant') return true;
    if (x == 'eyebolt') return true;
    if (x == 'eyelet') return true;
    if (x == 'eyepoint') return true;
    if (x == 'eyeshot') return true;
    if (x == 'eyesight') return true;
    if (x == 'eyespot') return true;
    return nil;
  }
;
twiEscTH: TwiEscDataObject
  firstLetter = 't'
  lastLetter  = 'h'
  isGoodWord(x) {
    if (x == 'tablecloth') return true;
    if (x == 'tach') return true;
    if (x == 'taiglach') return true;
    if (x == 'tallish') return true;
    if (x == 'tallith') return true;
    if (x == 'tallitoth') return true;
    if (x == 'tannish') return true;
    if (x == 'tarboosh') return true;
    if (x == 'tarbush') return true;
    if (x == 'tarnish') return true;
    if (x == 'tartish') return true;
    if (x == 'teach') return true;
    if (x == 'teeth') return true;
    if (x == 'teiglach') return true;
    if (x == 'telegraph') return true;
    if (x == 'tempeh') return true;
    if (x == 'tench') return true;
    if (x == 'tenth') return true;
    if (x == 'teraph') return true;
    if (x == 'terefah') return true;
    if (x == 'teth') return true;
    if (x == 'tetrarch') return true;
    if (x == 'teuch') return true;
    if (x == 'teugh') return true;
    if (x == 'thatch') return true;
    if (x == 'therewith') return true;
    if (x == 'thickish') return true;
    if (x == 'thievish') return true;
    if (x == 'thigh') return true;
    if (x == 'thinnish') return true;
    if (x == 'thirteenth') return true;
    if (x == 'thirtieth') return true;
    if (x == 'thorough') return true;
    if (x == 'though') return true;
    if (x == 'thousandth') return true;
    if (x == 'thrash') return true;
    if (x == 'thresh') return true;
    if (x == 'through') return true;
    if (x == 'thrush') return true;
    if (x == 'thuggish') return true;
    if (x == 'ticklish') return true;
    if (x == 'tigerish') return true;
    if (x == 'tigrish') return true;
    if (x == 'tilefish') return true;
    if (x == 'tilth') return true;
    if (x == 'tinsmith') return true;
    if (x == 'toadfish') return true;
    if (x == 'toadish') return true;
    if (x == 'toadyish') return true;
    if (x == 'tolbooth') return true;
    if (x == 'tollbooth') return true;
    if (x == 'tonish') return true;
    if (x == 'tonnish') return true;
    if (x == 'tooth') return true;
    if (x == 'toothbrush') return true;
    if (x == 'toph') return true;
    if (x == 'topnotch') return true;
    if (x == 'torah') return true;
    if (x == 'torch') return true;
    if (x == 'tosh') return true;
    if (x == 'touch') return true;
    if (x == 'tough') return true;
    if (x == 'toughish') return true;
    if (x == 'tovarich') return true;
    if (x == 'tovarish') return true;
    if (x == 'townish') return true;
    if (x == 'towpath') return true;
    if (x == 'toyish') return true;
    if (x == 'trampish') return true;
    if (x == 'trash') return true;
    if (x == 'trefah') return true;
    if (x == 'trench') return true;
    if (x == 'tribrach') return true;
    if (x == 'trickish') return true;
    if (x == 'triglyph') return true;
    if (x == 'trigraph') return true;
    if (x == 'trillionth') return true;
    if (x == 'trimorph') return true;
    if (x == 'triptych') return true;
    if (x == 'tristich') return true;
    if (x == 'triumph') return true;
    if (x == 'troth') return true;
    if (x == 'trough') return true;
    if (x == 'trowth') return true;
    if (x == 'truth') return true;
    if (x == 'tundish') return true;
    if (x == 'turbeth') return true;
    if (x == 'turbith') return true;
    if (x == 'turpeth') return true;
    if (x == 'tush') return true;
    if (x == 'tussah') return true;
    if (x == 'tusseh') return true;
    if (x == 'twelfth') return true;
    if (x == 'twentieth') return true;
    if (x == 'twitch') return true;
    if (x == 'tzitzith') return true;
    return nil;
  }
;
twiEscHI: TwiEscDataObject
  firstLetter = 'h'
  lastLetter  = 'i'
  isGoodWord(x) {
    if (x == 'hadji') return true;
    if (x == 'haji') return true;
    if (x == 'hajji') return true;
    if (x == 'hamuli') return true;
    if (x == 'hegari') return true;
    if (x == 'helleri') return true;
    if (x == 'hermai') return true;
    if (x == 'hetairai') return true;
    if (x == 'hexerei') return true;
    if (x == 'hi') return true;
    if (x == 'hibachi') return true;
    if (x == 'hili') return true;
    if (x == 'hippopotami') return true;
    if (x == 'houri') return true;
    if (x == 'humeri') return true;
    return nil;
  }
;
twiEscSL: TwiEscDataObject
  firstLetter = 's'
  lastLetter  = 'l'
  isGoodWord(x) {
    if (x == 'sackful') return true;
    if (x == 'sacksful') return true;
    if (x == 'sacral') return true;
    if (x == 'sacramental') return true;
    if (x == 'sacrificial') return true;
    if (x == 'safrol') return true;
    if (x == 'sagittal') return true;
    if (x == 'sahiwal') return true;
    if (x == 'sail') return true;
    if (x == 'sal') return true;
    if (x == 'sall') return true;
    if (x == 'salol') return true;
    if (x == 'samiel') return true;
    if (x == 'sandal') return true;
    if (x == 'santol') return true;
    if (x == 'sapropel') return true;
    if (x == 'satchel') return true;
    if (x == 'satirical') return true;
    if (x == 'saul') return true;
    if (x == 'saurel') return true;
    if (x == 'sawbill') return true;
    if (x == 'sawmill') return true;
    if (x == 'scall') return true;
    if (x == 'scalpel') return true;
    if (x == 'scandal') return true;
    if (x == 'scenical') return true;
    if (x == 'sceptral') return true;
    if (x == 'school') return true;
    if (x == 'schoolgirl') return true;
    if (x == 'schorl') return true;
    if (x == 'schul') return true;
    if (x == 'scleral') return true;
    if (x == 'scoopful') return true;
    if (x == 'scoopsful') return true;
    if (x == 'scornful') return true;
    if (x == 'scoundrel') return true;
    if (x == 'scowl') return true;
    if (x == 'scrannel') return true;
    if (x == 'scrawl') return true;
    if (x == 'screwball') return true;
    if (x == 'scribal') return true;
    if (x == 'scriptural') return true;
    if (x == 'scroll') return true;
    if (x == 'scrotal') return true;
    if (x == 'scull') return true;
    if (x == 'sculptural') return true;
    if (x == 'scurril') return true;
    if (x == 'seafowl') return true;
    if (x == 'seal') return true;
    if (x == 'seashell') return true;
    if (x == 'seasonal') return true;
    if (x == 'seawall') return true;
    if (x == 'secretarial') return true;
    if (x == 'sectional') return true;
    if (x == 'sectoral') return true;
    if (x == 'seel') return true;
    if (x == 'segetal') return true;
    if (x == 'seidel') return true;
    if (x == 'seismal') return true;
    if (x == 'sel') return true;
    if (x == 'selfheal') return true;
    if (x == 'sell') return true;
    if (x == 'semifinal') return true;
    if (x == 'semiformal') return true;
    if (x == 'seminal') return true;
    if (x == 'senatorial') return true;
    if (x == 'sendal') return true;
    if (x == 'sensational') return true;
    if (x == 'senseful') return true;
    if (x == 'sensual') return true;
    if (x == 'sentimental') return true;
    if (x == 'sentinel') return true;
    if (x == 'sepal') return true;
    if (x == 'septal') return true;
    if (x == 'septennial') return true;
    if (x == 'septical') return true;
    if (x == 'sepulchral') return true;
    if (x == 'sequel') return true;
    if (x == 'sequential') return true;
    if (x == 'serail') return true;
    if (x == 'seral') return true;
    if (x == 'serial') return true;
    if (x == 'serosal') return true;
    if (x == 'serumal') return true;
    if (x == 'serval') return true;
    if (x == 'sesquicentennial') return true;
    if (x == 'sesspool') return true;
    if (x == 'setal') return true;
    if (x == 'several') return true;
    if (x == 'sexual') return true;
    if (x == 'shall') return true;
    if (x == 'shameful') return true;
    if (x == 'shaul') return true;
    if (x == 'shawl') return true;
    if (x == 'sheal') return true;
    if (x == 'sheenful') return true;
    if (x == 'shekel') return true;
    if (x == 'shelfful') return true;
    if (x == 'shell') return true;
    if (x == 'sheol') return true;
    if (x == 'shiel') return true;
    if (x == 'shill') return true;
    if (x == 'shlemiel') return true;
    if (x == 'shoal') return true;
    if (x == 'shoebill') return true;
    if (x == 'shogunal') return true;
    if (x == 'shool') return true;
    if (x == 'shopgirl') return true;
    if (x == 'shorl') return true;
    if (x == 'shovel') return true;
    if (x == 'showgirl') return true;
    if (x == 'shrapnel') return true;
    if (x == 'shrieval') return true;
    if (x == 'shrill') return true;
    if (x == 'shrivel') return true;
    if (x == 'shtetel') return true;
    if (x == 'shtetl') return true;
    if (x == 'shul') return true;
    if (x == 'sial') return true;
    if (x == 'sibyl') return true;
    if (x == 'sidehill') return true;
    if (x == 'sidereal') return true;
    if (x == 'sidewall') return true;
    if (x == 'sigil') return true;
    if (x == 'signal') return true;
    if (x == 'sill') return true;
    if (x == 'silvical') return true;
    if (x == 'simnel') return true;
    if (x == 'sinful') return true;
    if (x == 'siphonal') return true;
    if (x == 'sisal') return true;
    if (x == 'skatol') return true;
    if (x == 'skeletal') return true;
    if (x == 'skeptical') return true;
    if (x == 'skilful') return true;
    if (x == 'skill') return true;
    if (x == 'skillful') return true;
    if (x == 'skinful') return true;
    if (x == 'skirl') return true;
    if (x == 'skoal') return true;
    if (x == 'skull') return true;
    if (x == 'skysail') return true;
    if (x == 'slothful') return true;
    if (x == 'small') return true;
    if (x == 'smell') return true;
    if (x == 'snail') return true;
    if (x == 'snarl') return true;
    if (x == 'sneerful') return true;
    if (x == 'snell') return true;
    if (x == 'snivel') return true;
    if (x == 'snool') return true;
    if (x == 'snorkel') return true;
    if (x == 'snowball') return true;
    if (x == 'snowbell') return true;
    if (x == 'snowfall') return true;
    if (x == 'sobful') return true;
    if (x == 'social') return true;
    if (x == 'societal') return true;
    if (x == 'sociological') return true;
    if (x == 'softball') return true;
    if (x == 'soil') return true;
    if (x == 'sol') return true;
    if (x == 'solgel') return true;
    if (x == 'somedeal') return true;
    if (x == 'somital') return true;
    if (x == 'sonantal') return true;
    if (x == 'songful') return true;
    if (x == 'sophistical') return true;
    if (x == 'sorbitol') return true;
    if (x == 'sorel') return true;
    if (x == 'sororal') return true;
    if (x == 'sorrel') return true;
    if (x == 'sorrowful') return true;
    if (x == 'sotol') return true;
    if (x == 'soul') return true;
    if (x == 'soulful') return true;
    if (x == 'sourball') return true;
    if (x == 'spacial') return true;
    if (x == 'spadeful') return true;
    if (x == 'spail') return true;
    if (x == 'spall') return true;
    if (x == 'spancel') return true;
    if (x == 'spandrel') return true;
    if (x == 'spandril') return true;
    if (x == 'spaniel') return true;
    if (x == 'spathal') return true;
    if (x == 'spatial') return true;
    if (x == 'special') return true;
    if (x == 'spectral') return true;
    if (x == 'speel') return true;
    if (x == 'speil') return true;
    if (x == 'spell') return true;
    if (x == 'spheral') return true;
    if (x == 'spherical') return true;
    if (x == 'spiegel') return true;
    if (x == 'spiel') return true;
    if (x == 'spill') return true;
    if (x == 'spinal') return true;
    if (x == 'spinel') return true;
    if (x == 'spiral') return true;
    if (x == 'spiritual') return true;
    if (x == 'spital') return true;
    if (x == 'spitball') return true;
    if (x == 'spiteful') return true;
    if (x == 'splenial') return true;
    if (x == 'spoil') return true;
    if (x == 'sponsal') return true;
    if (x == 'spool') return true;
    if (x == 'spoonful') return true;
    if (x == 'spoonsful') return true;
    if (x == 'sporal') return true;
    if (x == 'sportful') return true;
    if (x == 'spousal') return true;
    if (x == 'sprawl') return true;
    if (x == 'springal') return true;
    if (x == 'spurgall') return true;
    if (x == 'squall') return true;
    if (x == 'squeal') return true;
    if (x == 'squill') return true;
    if (x == 'squirrel') return true;
    if (x == 'stairwell') return true;
    if (x == 'stall') return true;
    if (x == 'staminal') return true;
    if (x == 'stammel') return true;
    if (x == 'standstill') return true;
    if (x == 'statal') return true;
    if (x == 'statical') return true;
    if (x == 'statistical') return true;
    if (x == 'staumrel') return true;
    if (x == 'staysail') return true;
    if (x == 'steal') return true;
    if (x == 'steel') return true;
    if (x == 'stencil') return true;
    if (x == 'sterical') return true;
    if (x == 'sternal') return true;
    if (x == 'sterol') return true;
    if (x == 'stibial') return true;
    if (x == 'stickful') return true;
    if (x == 'stigmal') return true;
    if (x == 'still') return true;
    if (x == 'stipel') return true;
    if (x == 'stoical') return true;
    if (x == 'stomal') return true;
    if (x == 'stomatal') return true;
    if (x == 'stool') return true;
    if (x == 'stratal') return true;
    if (x == 'streusel') return true;
    if (x == 'strigil') return true;
    if (x == 'strobil') return true;
    if (x == 'stroll') return true;
    if (x == 'stromal') return true;
    if (x == 'strongyl') return true;
    if (x == 'structural') return true;
    if (x == 'strudel') return true;
    if (x == 'stull') return true;
    if (x == 'stunsail') return true;
    if (x == 'subaxial') return true;
    if (x == 'subcell') return true;
    if (x == 'subcool') return true;
    if (x == 'subdual') return true;
    if (x == 'subequatorial') return true;
    if (x == 'sublethal') return true;
    if (x == 'sublevel') return true;
    if (x == 'subnasal') return true;
    if (x == 'subnodal') return true;
    if (x == 'subnormal') return true;
    if (x == 'suboral') return true;
    if (x == 'suboval') return true;
    if (x == 'subprincipal') return true;
    if (x == 'subsoil') return true;
    if (x == 'substantial') return true;
    if (x == 'subtotal') return true;
    if (x == 'subviral') return true;
    if (x == 'subvocal') return true;
    if (x == 'successful') return true;
    if (x == 'succinyl') return true;
    if (x == 'sudoral') return true;
    if (x == 'suffixal') return true;
    if (x == 'suicidal') return true;
    if (x == 'sulfinyl') return true;
    if (x == 'sulfonal') return true;
    if (x == 'sulfonyl') return true;
    if (x == 'sulfuryl') return true;
    if (x == 'summital') return true;
    if (x == 'sundial') return true;
    if (x == 'supercolossal') return true;
    if (x == 'superficial') return true;
    if (x == 'superintellectual') return true;
    if (x == 'supernal') return true;
    if (x == 'supernatural') return true;
    if (x == 'superpowerful') return true;
    if (x == 'superspecial') return true;
    if (x == 'supersuccessful') return true;
    if (x == 'supplemental') return true;
    if (x == 'supposal') return true;
    if (x == 'sural') return true;
    if (x == 'surgical') return true;
    if (x == 'surreal') return true;
    if (x == 'surroyal') return true;
    if (x == 'surveil') return true;
    if (x == 'survival') return true;
    if (x == 'suspenseful') return true;
    if (x == 'sutural') return true;
    if (x == 'swail') return true;
    if (x == 'swayful') return true;
    if (x == 'swell') return true;
    if (x == 'swill') return true;
    if (x == 'swirl') return true;
    if (x == 'swivel') return true;
    if (x == 'symbol') return true;
    if (x == 'symbolical') return true;
    if (x == 'symmetrical') return true;
    if (x == 'syncopal') return true;
    if (x == 'syndical') return true;
    if (x == 'synodal') return true;
    if (x == 'synovial') return true;
    if (x == 'syntactical') return true;
    if (x == 'systematical') return true;
    if (x == 'syzygal') return true;
    if (x == 'syzygial') return true;
    return nil;
  }
;
twiEscLA: TwiEscDataObject
  firstLetter = 'l'
  lastLetter  = 'a'
  isGoodWord(x) {
    if (x == 'la') return true;
    if (x == 'labara') return true;
    if (x == 'labella') return true;
    if (x == 'labia') return true;
    if (x == 'labra') return true;
    if (x == 'lacuna') return true;
    if (x == 'lacunaria') return true;
    if (x == 'laguna') return true;
    if (x == 'lama') return true;
    if (x == 'lambda') return true;
    if (x == 'lamella') return true;
    if (x == 'lamia') return true;
    if (x == 'lamina') return true;
    if (x == 'lantana') return true;
    if (x == 'larva') return true;
    if (x == 'lasagna') return true;
    if (x == 'latakia') return true;
    if (x == 'latria') return true;
    if (x == 'laura') return true;
    if (x == 'lava') return true;
    if (x == 'lavalava') return true;
    if (x == 'lea') return true;
    if (x == 'lehua') return true;
    if (x == 'lemma') return true;
    if (x == 'lemmata') return true;
    if (x == 'lempira') return true;
    if (x == 'lepta') return true;
    if (x == 'leucemia') return true;
    if (x == 'leucoma') return true;
    if (x == 'leukemia') return true;
    if (x == 'leukoma') return true;
    if (x == 'leukopenia') return true;
    if (x == 'leva') return true;
    if (x == 'lexica') return true;
    if (x == 'liana') return true;
    if (x == 'libra') return true;
    if (x == 'ligula') return true;
    if (x == 'likuta') return true;
    if (x == 'lima') return true;
    if (x == 'limba') return true;
    if (x == 'limina') return true;
    if (x == 'linga') return true;
    if (x == 'lingua') return true;
    if (x == 'lipoma') return true;
    if (x == 'lipomata') return true;
    if (x == 'lira') return true;
    if (x == 'lithemia') return true;
    if (x == 'lithia') return true;
    if (x == 'lixivia') return true;
    if (x == 'llama') return true;
    if (x == 'lobelia') return true;
    if (x == 'loca') return true;
    if (x == 'lochia') return true;
    if (x == 'locusta') return true;
    if (x == 'loggia') return true;
    if (x == 'logia') return true;
    if (x == 'lomenta') return true;
    if (x == 'loofa') return true;
    if (x == 'lordoma') return true;
    if (x == 'lorica') return true;
    if (x == 'lota') return true;
    if (x == 'luffa') return true;
    if (x == 'lumina') return true;
    if (x == 'luna') return true;
    if (x == 'lunula') return true;
    if (x == 'lustra') return true;
    if (x == 'lutea') return true;
    if (x == 'lycea') return true;
    if (x == 'lymphocytopenia') return true;
    if (x == 'lymphoma') return true;
    if (x == 'lymphomata') return true;
    if (x == 'lyssa') return true;
    if (x == 'lytta') return true;
    return nil;
  }
;
twiEscAB: TwiEscDataObject
  firstLetter = 'a'
  lastLetter  = 'b'
  isGoodWord(x) {
    if (x == 'absorb') return true;
    if (x == 'acerb') return true;
    if (x == 'adsorb') return true;
    if (x == 'adverb') return true;
    if (x == 'alb') return true;
    if (x == 'aplomb') return true;
    if (x == 'ardeb') return true;
    return nil;
  }
;
twiEscBY: TwiEscDataObject
  firstLetter = 'b'
  lastLetter  = 'y'
  isGoodWord(x) {
    if (x == 'baby') return true;
    if (x == 'bacillary') return true;
    if (x == 'backstay') return true;
    if (x == 'bacteriology') return true;
    if (x == 'baddy') return true;
    if (x == 'badgerly') return true;
    if (x == 'badly') return true;
    if (x == 'baffy') return true;
    if (x == 'baggily') return true;
    if (x == 'baggy') return true;
    if (x == 'bailey') return true;
    if (x == 'bairnly') return true;
    if (x == 'bakery') return true;
    if (x == 'balcony') return true;
    if (x == 'baldly') return true;
    if (x == 'balkily') return true;
    if (x == 'balky') return true;
    if (x == 'balladry') return true;
    if (x == 'bally') return true;
    if (x == 'balmily') return true;
    if (x == 'balmy') return true;
    if (x == 'baloney') return true;
    if (x == 'banality') return true;
    if (x == 'banally') return true;
    if (x == 'banditry') return true;
    if (x == 'bandy') return true;
    if (x == 'bankruptcy') return true;
    if (x == 'barbarity') return true;
    if (x == 'barbarously') return true;
    if (x == 'barberry') return true;
    if (x == 'barely') return true;
    if (x == 'barfly') return true;
    if (x == 'barky') return true;
    if (x == 'barley') return true;
    if (x == 'barmy') return true;
    if (x == 'barny') return true;
    if (x == 'baronetcy') return true;
    if (x == 'barony') return true;
    if (x == 'barratry') return true;
    if (x == 'barrenly') return true;
    if (x == 'barretry') return true;
    if (x == 'basally') return true;
    if (x == 'basely') return true;
    if (x == 'basically') return true;
    if (x == 'basicity') return true;
    if (x == 'basify') return true;
    if (x == 'basilary') return true;
    if (x == 'basketry') return true;
    if (x == 'bassly') return true;
    if (x == 'bassy') return true;
    if (x == 'bastardy') return true;
    if (x == 'batboy') return true;
    if (x == 'battery') return true;
    if (x == 'batty') return true;
    if (x == 'baulky') return true;
    if (x == 'bawdily') return true;
    if (x == 'bawdry') return true;
    if (x == 'bawdy') return true;
    if (x == 'bawty') return true;
    if (x == 'bay') return true;
    if (x == 'bayberry') return true;
    if (x == 'beachboy') return true;
    if (x == 'beachy') return true;
    if (x == 'beadily') return true;
    if (x == 'beady') return true;
    if (x == 'beaky') return true;
    if (x == 'beamily') return true;
    if (x == 'beamy') return true;
    if (x == 'beanery') return true;
    if (x == 'bearably') return true;
    if (x == 'beastly') return true;
    if (x == 'beatify') return true;
    if (x == 'beauteously') return true;
    if (x == 'beautifully') return true;
    if (x == 'beautify') return true;
    if (x == 'beauty') return true;
    if (x == 'becomingly') return true;
    if (x == 'bedirty') return true;
    if (x == 'beechy') return true;
    if (x == 'beefily') return true;
    if (x == 'beefy') return true;
    if (x == 'beery') return true;
    if (x == 'beggarly') return true;
    if (x == 'beggary') return true;
    if (x == 'beigy') return true;
    if (x == 'belady') return true;
    if (x == 'belay') return true;
    if (x == 'belfry') return true;
    if (x == 'believably') return true;
    if (x == 'bellboy') return true;
    if (x == 'bellicosity') return true;
    if (x == 'belligerency') return true;
    if (x == 'belly') return true;
    if (x == 'beltway') return true;
    if (x == 'benday') return true;
    if (x == 'bendy') return true;
    if (x == 'beneficially') return true;
    if (x == 'beneficiary') return true;
    if (x == 'benignity') return true;
    if (x == 'benignly') return true;
    if (x == 'benny') return true;
    if (x == 'berry') return true;
    if (x == 'bestiality') return true;
    if (x == 'bestiary') return true;
    if (x == 'betony') return true;
    if (x == 'betray') return true;
    if (x == 'bevy') return true;
    if (x == 'beweary') return true;
    if (x == 'beworry') return true;
    if (x == 'bewray') return true;
    if (x == 'bey') return true;
    if (x == 'bheesty') return true;
    if (x == 'bialy') return true;
    if (x == 'biannually') return true;
    if (x == 'biasedly') return true;
    if (x == 'bibbery') return true;
    if (x == 'bibliography') return true;
    if (x == 'bicentenniary') return true;
    if (x == 'biconcavity') return true;
    if (x == 'biconvexity') return true;
    if (x == 'biddably') return true;
    if (x == 'biddy') return true;
    if (x == 'biennially') return true;
    if (x == 'biffy') return true;
    if (x == 'bifidity') return true;
    if (x == 'bifidly') return true;
    if (x == 'bigamy') return true;
    if (x == 'bigeminy') return true;
    if (x == 'biggety') return true;
    if (x == 'biggity') return true;
    if (x == 'bigly') return true;
    if (x == 'bigotry') return true;
    if (x == 'bihourly') return true;
    if (x == 'bikeway') return true;
    if (x == 'bilaterally') return true;
    if (x == 'bilberry') return true;
    if (x == 'bilgy') return true;
    if (x == 'biliary') return true;
    if (x == 'billowy') return true;
    if (x == 'billy') return true;
    if (x == 'bimonthly') return true;
    if (x == 'binary') return true;
    if (x == 'binately') return true;
    if (x == 'bindery') return true;
    if (x == 'binocularly') return true;
    if (x == 'bioassay') return true;
    if (x == 'biochemistry') return true;
    if (x == 'biodegradability') return true;
    if (x == 'biogeny') return true;
    if (x == 'biography') return true;
    if (x == 'biology') return true;
    if (x == 'biometry') return true;
    if (x == 'bionomy') return true;
    if (x == 'biopsy') return true;
    if (x == 'bioscopy') return true;
    if (x == 'biparty') return true;
    if (x == 'biracially') return true;
    if (x == 'birthday') return true;
    if (x == 'bistoury') return true;
    if (x == 'bitchery') return true;
    if (x == 'bitchily') return true;
    if (x == 'bitchy') return true;
    if (x == 'bitingly') return true;
    if (x == 'bitsy') return true;
    if (x == 'bitterly') return true;
    if (x == 'bitty') return true;
    if (x == 'biweekly') return true;
    if (x == 'biyearly') return true;
    if (x == 'bizarrely') return true;
    if (x == 'blabby') return true;
    if (x == 'blackberry') return true;
    if (x == 'blackboy') return true;
    if (x == 'blackfly') return true;
    if (x == 'blackly') return true;
    if (x == 'bladdery') return true;
    if (x == 'blamably') return true;
    if (x == 'blamelessly') return true;
    if (x == 'blameworthy') return true;
    if (x == 'blandly') return true;
    if (x == 'blankly') return true;
    if (x == 'blarney') return true;
    if (x == 'blasphemy') return true;
    if (x == 'blasty') return true;
    if (x == 'blatancy') return true;
    if (x == 'blazonry') return true;
    if (x == 'bleakly') return true;
    if (x == 'blearily') return true;
    if (x == 'bleary') return true;
    if (x == 'blebby') return true;
    if (x == 'blenny') return true;
    if (x == 'blighty') return true;
    if (x == 'blimey') return true;
    if (x == 'blimy') return true;
    if (x == 'blindly') return true;
    if (x == 'blissfully') return true;
    if (x == 'blistery') return true;
    if (x == 'blithely') return true;
    if (x == 'blocky') return true;
    if (x == 'bloodily') return true;
    if (x == 'bloodthirstily') return true;
    if (x == 'bloodthirsty') return true;
    if (x == 'bloody') return true;
    if (x == 'bloomery') return true;
    if (x == 'bloomy') return true;
    if (x == 'blossomy') return true;
    if (x == 'blotchy') return true;
    if (x == 'blotty') return true;
    if (x == 'blousily') return true;
    if (x == 'blousy') return true;
    if (x == 'blowby') return true;
    if (x == 'blowfly') return true;
    if (x == 'blowsily') return true;
    if (x == 'blowsy') return true;
    if (x == 'blowy') return true;
    if (x == 'blowzily') return true;
    if (x == 'blowzy') return true;
    if (x == 'blubbery') return true;
    if (x == 'blueberry') return true;
    if (x == 'bluejay') return true;
    if (x == 'bluely') return true;
    if (x == 'bluesy') return true;
    if (x == 'bluey') return true;
    if (x == 'bluffly') return true;
    if (x == 'bluntly') return true;
    if (x == 'blurrily') return true;
    if (x == 'blurry') return true;
    if (x == 'blustery') return true;
    if (x == 'boastfully') return true;
    if (x == 'bobbery') return true;
    if (x == 'bobby') return true;
    if (x == 'bobstay') return true;
    if (x == 'bodily') return true;
    if (x == 'bodingly') return true;
    if (x == 'body') return true;
    if (x == 'bogey') return true;
    if (x == 'boggy') return true;
    if (x == 'bogy') return true;
    if (x == 'boisterously') return true;
    if (x == 'boldly') return true;
    if (x == 'boloney') return true;
    if (x == 'boney') return true;
    if (x == 'bonnily') return true;
    if (x == 'bonny') return true;
    if (x == 'bony') return true;
    if (x == 'booby') return true;
    if (x == 'boomy') return true;
    if (x == 'bootery') return true;
    if (x == 'booty') return true;
    if (x == 'boozily') return true;
    if (x == 'boozy') return true;
    if (x == 'boringly') return true;
    if (x == 'borty') return true;
    if (x == 'bosky') return true;
    if (x == 'bosomy') return true;
    if (x == 'bossily') return true;
    if (x == 'bossy') return true;
    if (x == 'botany') return true;
    if (x == 'botchery') return true;
    if (x == 'botchily') return true;
    if (x == 'botchy') return true;
    if (x == 'botfly') return true;
    if (x == 'bottomry') return true;
    if (x == 'bouldery') return true;
    if (x == 'bouncily') return true;
    if (x == 'bouncy') return true;
    if (x == 'boundary') return true;
    if (x == 'bounteously') return true;
    if (x == 'bountifully') return true;
    if (x == 'bounty') return true;
    if (x == 'bousy') return true;
    if (x == 'bovinely') return true;
    if (x == 'bovinity') return true;
    if (x == 'bowery') return true;
    if (x == 'bowingly') return true;
    if (x == 'boxberry') return true;
    if (x == 'boxy') return true;
    if (x == 'boy') return true;
    if (x == 'boyishly') return true;
    if (x == 'braggy') return true;
    if (x == 'brainily') return true;
    if (x == 'brainy') return true;
    if (x == 'braky') return true;
    if (x == 'brambly') return true;
    if (x == 'branchy') return true;
    if (x == 'brandy') return true;
    if (x == 'branny') return true;
    if (x == 'brashly') return true;
    if (x == 'brashy') return true;
    if (x == 'brassily') return true;
    if (x == 'brassy') return true;
    if (x == 'bratty') return true;
    if (x == 'bravely') return true;
    if (x == 'bravery') return true;
    if (x == 'brawly') return true;
    if (x == 'brawnily') return true;
    if (x == 'brawny') return true;
    if (x == 'braxy') return true;
    if (x == 'bray') return true;
    if (x == 'brazenly') return true;
    if (x == 'breathlessly') return true;
    if (x == 'breathy') return true;
    if (x == 'breezily') return true;
    if (x == 'breezy') return true;
    if (x == 'brevetcy') return true;
    if (x == 'breviary') return true;
    if (x == 'brevity') return true;
    if (x == 'brewery') return true;
    if (x == 'briary') return true;
    if (x == 'bribery') return true;
    if (x == 'bricky') return true;
    if (x == 'bridally') return true;
    if (x == 'briefly') return true;
    if (x == 'briery') return true;
    if (x == 'brightly') return true;
    if (x == 'brilliancy') return true;
    if (x == 'brilliantly') return true;
    if (x == 'briny') return true;
    if (x == 'briony') return true;
    if (x == 'briskly') return true;
    if (x == 'bristly') return true;
    if (x == 'broadly') return true;
    if (x == 'broguery') return true;
    if (x == 'broidery') return true;
    if (x == 'brokenly') return true;
    if (x == 'brolly') return true;
    if (x == 'bronzy') return true;
    if (x == 'broody') return true;
    if (x == 'broomy') return true;
    if (x == 'brosy') return true;
    if (x == 'brotherly') return true;
    if (x == 'brothy') return true;
    if (x == 'browny') return true;
    if (x == 'brumby') return true;
    if (x == 'brushy') return true;
    if (x == 'brusquely') return true;
    if (x == 'brutality') return true;
    if (x == 'brutally') return true;
    if (x == 'brutely') return true;
    if (x == 'brutify') return true;
    if (x == 'bryology') return true;
    if (x == 'bryony') return true;
    if (x == 'bubbly') return true;
    if (x == 'bubby') return true;
    if (x == 'buccally') return true;
    if (x == 'buddy') return true;
    if (x == 'budgetary') return true;
    if (x == 'buffy') return true;
    if (x == 'buggery') return true;
    if (x == 'buggy') return true;
    if (x == 'buirdly') return true;
    if (x == 'bulgy') return true;
    if (x == 'bulkily') return true;
    if (x == 'bulky') return true;
    if (x == 'bullocky') return true;
    if (x == 'bully') return true;
    if (x == 'bullyboy') return true;
    if (x == 'bumpily') return true;
    if (x == 'bumpy') return true;
    if (x == 'bunchily') return true;
    if (x == 'bunchy') return true;
    if (x == 'bunky') return true;
    if (x == 'bunny') return true;
    if (x == 'buoy') return true;
    if (x == 'buoyancy') return true;
    if (x == 'burbly') return true;
    if (x == 'bureaucracy') return true;
    if (x == 'burglary') return true;
    if (x == 'burgundy') return true;
    if (x == 'burley') return true;
    if (x == 'burlily') return true;
    if (x == 'burly') return true;
    if (x == 'burry') return true;
    if (x == 'bursary') return true;
    if (x == 'bury') return true;
    if (x == 'busboy') return true;
    if (x == 'busby') return true;
    if (x == 'bushily') return true;
    if (x == 'bushy') return true;
    if (x == 'busily') return true;
    if (x == 'busty') return true;
    if (x == 'busy') return true;
    if (x == 'busybody') return true;
    if (x == 'butchery') return true;
    if (x == 'butlery') return true;
    if (x == 'butterfly') return true;
    if (x == 'buttery') return true;
    if (x == 'buttony') return true;
    if (x == 'butty') return true;
    if (x == 'buxomly') return true;
    if (x == 'buy') return true;
    if (x == 'buzzy') return true;
    if (x == 'by') return true;
    if (x == 'byplay') return true;
    if (x == 'byway') return true;
    return nil;
  }
;
twiEscYR: TwiEscDataObject
  firstLetter = 'y'
  lastLetter  = 'r'
  isGoodWord(x) {
    if (x == 'yabber') return true;
    if (x == 'yachter') return true;
    if (x == 'yager') return true;
    if (x == 'yammer') return true;
    if (x == 'yammerer') return true;
    if (x == 'yapper') return true;
    if (x == 'yar') return true;
    if (x == 'yarer') return true;
    if (x == 'yauper') return true;
    if (x == 'yawmeter') return true;
    if (x == 'yawner') return true;
    if (x == 'yawper') return true;
    if (x == 'year') return true;
    if (x == 'yearner') return true;
    if (x == 'yeastier') return true;
    if (x == 'yeller') return true;
    if (x == 'yellower') return true;
    if (x == 'yelper') return true;
    if (x == 'yester') return true;
    if (x == 'yielder') return true;
    if (x == 'yirr') return true;
    if (x == 'yodeler') return true;
    if (x == 'yodeller') return true;
    if (x == 'yodler') return true;
    if (x == 'yolkier') return true;
    if (x == 'yonder') return true;
    if (x == 'yonker') return true;
    if (x == 'younger') return true;
    if (x == 'youngster') return true;
    if (x == 'younker') return true;
    if (x == 'your') return true;
    if (x == 'yowler') return true;
    if (x == 'yummier') return true;
    return nil;
  }
;
twiEscRI: TwiEscDataObject
  firstLetter = 'r'
  lastLetter  = 'i'
  isGoodWord(x) {
    if (x == 'rabbi') return true;
    if (x == 'rabboni') return true;
    if (x == 'radii') return true;
    if (x == 'ragi') return true;
    if (x == 'raki') return true;
    if (x == 'rami') return true;
    if (x == 'rani') return true;
    if (x == 'rappini') return true;
    if (x == 'ravioli') return true;
    if (x == 'recti') return true;
    if (x == 'reguli') return true;
    if (x == 'rei') return true;
    if (x == 'renvoi') return true;
    if (x == 'retiarii') return true;
    if (x == 'rhinoceri') return true;
    if (x == 'rhizopi') return true;
    if (x == 'rhombi') return true;
    if (x == 'rhonchi') return true;
    if (x == 'rigatoni') return true;
    if (x == 'rilievi') return true;
    if (x == 'ripieni') return true;
    if (x == 'rishi') return true;
    return nil;
  }
;
twiEscIN: TwiEscDataObject
  firstLetter = 'i'
  lastLetter  = 'n'
  isGoodWord(x) {
    if (x == 'iceman') return true;
    if (x == 'icemen') return true;
    if (x == 'icon') return true;
    if (x == 'idealisation') return true;
    if (x == 'idealization') return true;
    if (x == 'ideation') return true;
    if (x == 'identification') return true;
    if (x == 'idolisation') return true;
    if (x == 'idolization') return true;
    if (x == 'ignition') return true;
    if (x == 'ignitron') return true;
    if (x == 'iguanian') return true;
    if (x == 'ikon') return true;
    if (x == 'illation') return true;
    if (x == 'illumination') return true;
    if (x == 'illusion') return true;
    if (x == 'illustration') return true;
    if (x == 'imagination') return true;
    if (x == 'imbolden') return true;
    if (x == 'imbrown') return true;
    if (x == 'imitation') return true;
    if (x == 'immersion') return true;
    if (x == 'immigration') return true;
    if (x == 'immobilisation') return true;
    if (x == 'immobilization') return true;
    if (x == 'immolation') return true;
    if (x == 'immortalisation') return true;
    if (x == 'immortalization') return true;
    if (x == 'immunisation') return true;
    if (x == 'immunization') return true;
    if (x == 'impawn') return true;
    if (x == 'imperfection') return true;
    if (x == 'impersonation') return true;
    if (x == 'implementation') return true;
    if (x == 'implication') return true;
    if (x == 'implosion') return true;
    if (x == 'importation') return true;
    if (x == 'imposition') return true;
    if (x == 'imprecision') return true;
    if (x == 'impregn') return true;
    if (x == 'impregnation') return true;
    if (x == 'impression') return true;
    if (x == 'imprison') return true;
    if (x == 'improvisation') return true;
    if (x == 'impugn') return true;
    if (x == 'impulsion') return true;
    if (x == 'imputation') return true;
    if (x == 'in') return true;
    if (x == 'inaction') return true;
    if (x == 'inanition') return true;
    if (x == 'inattention') return true;
    if (x == 'inauguration') return true;
    if (x == 'inborn') return true;
    if (x == 'incantation') return true;
    if (x == 'incarceration') return true;
    if (x == 'incarnation') return true;
    if (x == 'inception') return true;
    if (x == 'incision') return true;
    if (x == 'inclination') return true;
    if (x == 'inclusion') return true;
    if (x == 'incorporation') return true;
    if (x == 'incrimination') return true;
    if (x == 'incubation') return true;
    if (x == 'inculcation') return true;
    if (x == 'incursion') return true;
    if (x == 'indamin') return true;
    if (x == 'indecision') return true;
    if (x == 'indemnification') return true;
    if (x == 'indentation') return true;
    if (x == 'indican') return true;
    if (x == 'indication') return true;
    if (x == 'indigen') return true;
    if (x == 'indigestion') return true;
    if (x == 'indign') return true;
    if (x == 'indignation') return true;
    if (x == 'indirection') return true;
    if (x == 'indiscretion') return true;
    if (x == 'indisposition') return true;
    if (x == 'individualisation') return true;
    if (x == 'individualization') return true;
    if (x == 'indoctrination') return true;
    if (x == 'indrawn') return true;
    if (x == 'induction') return true;
    if (x == 'indulin') return true;
    if (x == 'industrialisation') return true;
    if (x == 'industrialization') return true;
    if (x == 'inebriation') return true;
    if (x == 'infatuation') return true;
    if (x == 'infection') return true;
    if (x == 'infestation') return true;
    if (x == 'infiltration') return true;
    if (x == 'infixion') return true;
    if (x == 'inflammation') return true;
    if (x == 'inflation') return true;
    if (x == 'inflection') return true;
    if (x == 'infliction') return true;
    if (x == 'information') return true;
    if (x == 'infraction') return true;
    if (x == 'infusion') return true;
    if (x == 'ingrain') return true;
    if (x == 'ingrown') return true;
    if (x == 'inhalation') return true;
    if (x == 'inhesion') return true;
    if (x == 'inhibition') return true;
    if (x == 'inhuman') return true;
    if (x == 'inion') return true;
    if (x == 'initialisation') return true;
    if (x == 'initialization') return true;
    if (x == 'initiation') return true;
    if (x == 'injection') return true;
    if (x == 'injunction') return true;
    if (x == 'inkhorn') return true;
    if (x == 'inn') return true;
    if (x == 'innovation') return true;
    if (x == 'inoculation') return true;
    if (x == 'inquisition') return true;
    if (x == 'inscription') return true;
    if (x == 'insectan') return true;
    if (x == 'insecuration') return true;
    if (x == 'insertion') return true;
    if (x == 'insinuation') return true;
    if (x == 'inspan') return true;
    if (x == 'inspection') return true;
    if (x == 'inspiration') return true;
    if (x == 'installation') return true;
    if (x == 'instigation') return true;
    if (x == 'institution') return true;
    if (x == 'instruction') return true;
    if (x == 'instrumentation') return true;
    if (x == 'insubordination') return true;
    if (x == 'insulation') return true;
    if (x == 'insulin') return true;
    if (x == 'insurrection') return true;
    if (x == 'integration') return true;
    if (x == 'intensification') return true;
    if (x == 'intention') return true;
    if (x == 'interaction') return true;
    if (x == 'intercalation') return true;
    if (x == 'interception') return true;
    if (x == 'intercession') return true;
    if (x == 'interconversion') return true;
    if (x == 'interdiction') return true;
    if (x == 'interjection') return true;
    if (x == 'intermission') return true;
    if (x == 'intermountain') return true;
    if (x == 'intern') return true;
    if (x == 'interpolation') return true;
    if (x == 'interpopulation') return true;
    if (x == 'interposition') return true;
    if (x == 'interpretation') return true;
    if (x == 'interrelation') return true;
    if (x == 'interrogation') return true;
    if (x == 'interruption') return true;
    if (x == 'intersection') return true;
    if (x == 'interspersion') return true;
    if (x == 'interurban') return true;
    if (x == 'intervention') return true;
    if (x == 'interwoven') return true;
    if (x == 'intimation') return true;
    if (x == 'intimidation') return true;
    if (x == 'intonation') return true;
    if (x == 'intown') return true;
    if (x == 'intoxication') return true;
    if (x == 'introduction') return true;
    if (x == 'introspection') return true;
    if (x == 'introversion') return true;
    if (x == 'intrusion') return true;
    if (x == 'intuition') return true;
    if (x == 'inturn') return true;
    if (x == 'inulin') return true;
    if (x == 'inundation') return true;
    if (x == 'inurn') return true;
    if (x == 'invasion') return true;
    if (x == 'invention') return true;
    if (x == 'inversion') return true;
    if (x == 'investigation') return true;
    if (x == 'invigoration') return true;
    if (x == 'invitation') return true;
    if (x == 'invocation') return true;
    if (x == 'inwoven') return true;
    if (x == 'iodation') return true;
    if (x == 'iodin') return true;
    if (x == 'iodopsin') return true;
    if (x == 'ion') return true;
    if (x == 'iron') return true;
    if (x == 'irradiation') return true;
    if (x == 'irresolution') return true;
    if (x == 'irrigation') return true;
    if (x == 'irritation') return true;
    if (x == 'isatin') return true;
    if (x == 'isochron') return true;
    if (x == 'isogon') return true;
    if (x == 'isolation') return true;
    if (x == 'isopodan') return true;
    if (x == 'isospin') return true;
    if (x == 'isthmian') return true;
    if (x == 'italian') return true;
    if (x == 'italicisation') return true;
    if (x == 'italicization') return true;
    if (x == 'itemisation') return true;
    if (x == 'itemization') return true;
    if (x == 'iteration') return true;
    return nil;
  }
;
twiEscNT: TwiEscDataObject
  firstLetter = 'n'
  lastLetter  = 't'
  isGoodWord(x) {
    if (x == 'nailset') return true;
    if (x == 'naivest') return true;
    if (x == 'nakedest') return true;
    if (x == 'nanowatt') return true;
    if (x == 'nappiest') return true;
    if (x == 'narcissist') return true;
    if (x == 'narcist') return true;
    if (x == 'narrowest') return true;
    if (x == 'nascent') return true;
    if (x == 'nastiest') return true;
    if (x == 'natant') return true;
    if (x == 'nationalist') return true;
    if (x == 'nativist') return true;
    if (x == 'nattiest') return true;
    if (x == 'naturalist') return true;
    if (x == 'naught') return true;
    if (x == 'naughtiest') return true;
    if (x == 'nauseant') return true;
    if (x == 'navicert') return true;
    if (x == 'nearest') return true;
    if (x == 'nearliest') return true;
    if (x == 'neat') return true;
    if (x == 'neatest') return true;
    if (x == 'neediest') return true;
    if (x == 'needlepoint') return true;
    if (x == 'neglect') return true;
    if (x == 'negligent') return true;
    if (x == 'neist') return true;
    if (x == 'nepotist') return true;
    if (x == 'nerviest') return true;
    if (x == 'nescient') return true;
    if (x == 'nest') return true;
    if (x == 'net') return true;
    if (x == 'nett') return true;
    if (x == 'nettiest') return true;
    if (x == 'nettliest') return true;
    if (x == 'neurologist') return true;
    if (x == 'newest') return true;
    if (x == 'newscast') return true;
    if (x == 'newsiest') return true;
    if (x == 'newsprint') return true;
    if (x == 'newt') return true;
    if (x == 'next') return true;
    if (x == 'nicest') return true;
    if (x == 'nidget') return true;
    if (x == 'niellist') return true;
    if (x == 'niftiest') return true;
    if (x == 'nighest') return true;
    if (x == 'night') return true;
    if (x == 'nihilist') return true;
    if (x == 'nimblest') return true;
    if (x == 'nippiest') return true;
    if (x == 'nit') return true;
    if (x == 'nittiest') return true;
    if (x == 'nitwit') return true;
    if (x == 'nobbiest') return true;
    if (x == 'noblest') return true;
    if (x == 'nocent') return true;
    if (x == 'noisiest') return true;
    if (x == 'nonabsorbent') return true;
    if (x == 'nonadjacent') return true;
    if (x == 'nonadult') return true;
    if (x == 'nonchalant') return true;
    if (x == 'noncombat') return true;
    if (x == 'noncombatant') return true;
    if (x == 'nonconformist') return true;
    if (x == 'noncurrent') return true;
    if (x == 'nondescript') return true;
    if (x == 'nonelect') return true;
    if (x == 'nonenforcement') return true;
    if (x == 'nonevent') return true;
    if (x == 'nonexistent') return true;
    if (x == 'nonfat') return true;
    if (x == 'nonguilt') return true;
    if (x == 'noninvolvement') return true;
    if (x == 'nonmalignant') return true;
    if (x == 'nonparticipant') return true;
    if (x == 'nonpayment') return true;
    if (x == 'nonpermanent') return true;
    if (x == 'nonpregnant') return true;
    if (x == 'nonprofit') return true;
    if (x == 'nonresident') return true;
    if (x == 'nonscientist') return true;
    if (x == 'nonsexist') return true;
    if (x == 'nonsignificant') return true;
    if (x == 'nonspecialist') return true;
    if (x == 'nonstudent') return true;
    if (x == 'nonsuit') return true;
    if (x == 'nonsupport') return true;
    if (x == 'nonviolent') return true;
    if (x == 'northeast') return true;
    if (x == 'northernmost') return true;
    if (x == 'northwest') return true;
    if (x == 'nosiest') return true;
    if (x == 'not') return true;
    if (x == 'nougat') return true;
    if (x == 'nought') return true;
    if (x == 'nourishment') return true;
    if (x == 'novelist') return true;
    if (x == 'nowt') return true;
    if (x == 'nubbiest') return true;
    if (x == 'nubbliest') return true;
    if (x == 'nudest') return true;
    if (x == 'nudist') return true;
    if (x == 'nugget') return true;
    if (x == 'numbest') return true;
    if (x == 'numerologist') return true;
    if (x == 'numismatist') return true;
    if (x == 'nut') return true;
    if (x == 'nutant') return true;
    if (x == 'nutlet') return true;
    if (x == 'nutmeat') return true;
    if (x == 'nutrient') return true;
    if (x == 'nutriment') return true;
    if (x == 'nuttiest') return true;
    if (x == 'nymphet') return true;
    return nil;
  }
;
*/
