Attribute VB_Name = "Principal"
Option Explicit

Public Sub Main()
    Dim ComDlg As New CommonDialog
    Dim s As String, sFich As String, sExt As String
    Dim i As Long
    
    InicializaDatosAventura
    
    ' cogemos los parmetros de la lnea de comandos
    s = Command
    s = Trim(s)
    
    ' comprobamos la existencia del fichero
    If Not ExisteFichero(s) Then
        ComDlg.DialogTitle = "Abrir aventura"
        ComDlg.DefaultExt = EXT_DLL
        ComDlg.Filter = "Ficheros Visual SINTAC|*" & EXT_DLL
        ComDlg.InitDir = App.Path
        ComDlg.Flags = &H1000 Or &H800 Or 4     ' FileMustExist | PathMustExist | HideReadOnly
        ComDlg.CancelError = False
        ComDlg.ShowOpen
        s = ComDlg.FileName
        If s = "" Then
            End
        End If
        DoEvents
    End If
    
    ' separamos la extensin del nombre
    ' elimina la extensin del nombre del fichero (si la tiene)
    i = InStrRev(s, ".")
    If i > 0 Then
        sFich = Left(s, i - 1)
        sExt = UCase(Right(s, Len(s) - i + 1))
    End If
    
    frmEspera.Show
    frmEspera.Refresh
    
    ' si es un fichero de recursos
    If sExt = EXT_DLL Then
        sFichAventura = sFich
        If Not CargarVocabularioRes(sFich & EXT_DLL) Then
            Unload frmEspera
            MsgBox "Error al cargar vocabulario", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarLocalidadesRes(sFich & EXT_DLL) Then
            Unload frmEspera
            MsgBox "Error al cargar localidades", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarObjetosRes(sFich & EXT_DLL) Then
            Unload frmEspera
            MsgBox "Error al cargar objetos", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarPSIsRes(sFich & EXT_DLL) Then
            Unload frmEspera
            MsgBox "Error al cargar PSIs", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarModulosRes(sFich & EXT_DLL) Then
            Unload frmEspera
            MsgBox "Error al cargar mdulos", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
    ' si no, esperamos un nombre de fichero de aventura
    ElseIf sExt = EXT_PROC Then
        sFichAventura = sFich
        If Not CargarVocabulario(sFich & EXT_VOC) Then
            Unload frmEspera
            MsgBox "Error al cargar vocabulario", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarLocalidades(sFich & EXT_LOC) Then
            Unload frmEspera
            MsgBox "Error al cargar localidades", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarObjetos(sFich & EXT_OBJ) Then
            Unload frmEspera
            MsgBox "Error al cargar objetos", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarPSIs(sFich & EXT_PSI) Then
            Unload frmEspera
            MsgBox "Error al cargar PSIs", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If Not CargarModulos(sFich & EXT_PROC) Then
            Unload frmEspera
            MsgBox "Error al cargar mdulos", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
        If CargarScript <> "" Then
            Unload frmEspera
            MsgBox "Error al cargar mdulos", vbOKOnly + vbCritical, "Visual SINTAC"
            End
        End If
    Else
        Unload frmEspera
        MsgBox "El fichero '" & s & "' no es un fichero de aventura vlido.", vbOKOnly + vbCritical
        End
    End If

    Unload frmEspera
    Ejecuta
    End
    
End Sub

