/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// AdvMap.cpp: implementation of the CAdvMap class.
//
//////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "AdvMap.h"
#include <iostream>

using namespace std;


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
IMPLEMENT_SERIAL( CAdvLocation, CObject, 1)

void CAdvLocation::Serialize( CArchive &ar )
{
	int count;
	CString Temp;

	if ( ar.IsStoring() )
	{
		for ( count=0; count<15; count++ )
		{
			ar<<Connection[count];
		}
		ar<<Description;
	}
	else
	{
		for ( count=0; count<15; count++ )
		{
			ar>>Connection[count];
		}
		ar>>Temp;
		if ( Temp.GetLength() > 2 )
		{
			if ( Temp.GetAt(Temp.GetLength()-1) == 0x0a )
			{
				Description = Temp.Left(Temp.GetLength()-1);
			}
			else
			{	
				Description=Temp;
			}
		}
		else
		{	
			Description=Temp;
		}
		
	}
}

IMPLEMENT_SERIAL( CAdvMap, CObject, 1);

CAdvMap::CAdvMap()
{
	LocationConn.SetSize( 10000 );
}

CAdvMap::~CAdvMap()
{

}

int CAdvMap::MapLocation( int location, int verb)
{
	return LocationConn[location].Connection[verb];
}

CString CAdvMap::GetDescription(int location)
{
	if ( location > MaxLocation )
	{
		throw ( new CRuntimeError(CString("Fatal Error: Attempt To Access Unknown Location - "),location));
	}
		return LocationConn[location].Description;

}

void CAdvMap::Output()
{
	for ( int count=0; count<10; count++)
	{
		cout << "ROOM " << count ;
		for ( int  connection=0; connection <15; connection++ )
		{
			cout << LocationConn[count].Connection[connection] << " ";
		}
		cout << endl;
	}
}

void CAdvMap::Serialize( CArchive &ar )
{
	
	if ( ar.IsStoring() )
	{
		ar << MaxLocation;
		for ( int count =0; count <= MaxLocation; count ++ )
		{
			LocationConn[count].Serialize( ar );
		}
	}
	else
	{
		ar >> MaxLocation;
		LocationConn.SetSize( MaxLocation + 1);
		for ( int count =0; count <= MaxLocation; count ++ )
		{

			LocationConn[count].Serialize( ar );
		}
	}
}

bool CAdvMap::validate(int LocationNo)
{
 if ( LocationNo > MaxLocation ) false;
 return true;
}
