#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


/*
craneFrustration : VideoGameMachine, OutOfReach, Container
 	'crane frustration (machine)/crane'
 	'Crane Frustration machine'
	@arcade
	
	identifier = 'Crane Frustration'
	
	desc {
		"This is the Crane Frustration machine. It's that horrible
		game where you control a crane with a joystick and try to
		grab prizes and pull them over to the prize chute. ";
		
		if(powerSwitch.isOn) {
			if(creditsRemaining > 0)
				"The machine is powered on and appears to have <<creditsRemaining>> credits in it already. ";
			else
				"The machine is powered on. ";
		}

		if(pacmanStuffedAnimal.isIn(craneFrustration)) {
			switch(tokenDistanceFromEdge) {
				case 3:
				case 2:
				case 1:
					"There's a stuffed animal in there, but it isn't very near the prize chute. ";
					break;
				case 0:
					"The stuffed animal is balanced on the edge of the chute! I'll bet you could get it if you played
					just one more time! ";
					break;
			}
		}
	}
	
	dobjFor(LookIn) asDobjFor(Examine)
	
	dobjFor(Play) {
		action() {
			if(pacmanStuffedAnimal.isIn(craneFrustration)) {
				"You grab the joystick, hit the button, and attempt to move the crane to grab the stuffed animal. ";
				
				switch(tokenDistanceFromEdge) {
					case 3:
						"You succeed in moving the stuffed animal a little bit, but it's still pretty far from the prize chute. ";
						break;
					case 2:
						"This was a good try. You succeed in moving it quite a bit, but it's still a little ways from prize chute. ";
						break;
					case 1:
						"Oooh! So close! You get it right up to the edge of the chute. You'll probably
						get it if you try one more time. ";
						break;
				}
				--tokenDistanceFromEdge;
			} else {
				"You grab the joystick, hit the button, and attempt to move the crane to grab one
				of the other prizes. But, as expected, you aren't able to get anything. ";
			}
						
			--creditsRemaining;
			exit;
		}
	}
	
	dobjFor(Attack) {
		action() {
			if(wasWon) {
				"You rough up the machine a bit, but nothing happens. ";
			} else {
				if(tokenDistanceFromEdge==0) {
					"Huzzah! The stuffed animal tips over the edge into the prize chute! ";
					pacmanStuffedAnimal.moveInto(craneFrustrationPrizeChute);
					winGame();
					exit;
				} else {
					"You rattle the machine a bit, but other than that, nothing happens. ";
					exit;
				}
			}
		}
	}
	
	dobjFor(Push) asDobjFor(Attack)
	dobjFor(Pull) asDobjFor(Attack)
	dobjFor(Tip) asDobjFor(Attack)

	creditsRequired = 1
	creditsRemaining = 3
	tokenDistanceFromEdge = 3
		
	tokenSlot : VideoGameMachineTokenSlot {
		'(Crane) (Frustration) (token) slot' 'Crane Frustration token slot'
		@craneFrustration
		"This is a token slot."
	}
	tokenReturn : VideoGameMachineTokenReturn {
		'(Crane) (Frustration) (token) return/receptacle' 'Crane Frustration token return'
		@craneFrustration
		"This is the token return for the Crane Frustration machine. "
	}
	
	winGame() {
		"\b--- GAME OVER: YOU HAVE WON CRANE FRUSTRATION ---\b";
		craneFrustrationTicket.winTicket();
		achieve.awardPointsOnce();
		wasWon = true;
	}
	
	achieve : Achievement {+5 "winning Crane Frustration";}

	
	canObjReachSelf(obj) {return true;}
	cannotReachFromOutsideMsg(dest) { "The prizes are inside the machine. If you want any of the prizes then you'll have to win them by playing the game. "; exit; }
;

craneFrustrationPrizeChute : Container '(Crane) (Frustration) prize chute' 'Crane Frustration prize chute'
	"This is the prize chute for Crane Frustration. This is where the prizes go if you
	successfully move them into it with the crane. "
	location = arcade
	isListed = nil
;

Decoration 'joystick' 'joystick'
	"It\'s a joystick that\'s used to move the crane around. To play the game, just <q>play crane frustration</q>. "
	location = arcade
;
Decoration 'yellow button' 'button'
	"The yellow button is used to grab items with the crane. However, you don't need to refer to it. To play the game, just <q>play crane frustration</q>. "
	location = arcade
;
Decoration 'prizes' 'prizes'
	desc {craneFrustration.desc;}
	location=arcade
	isPlural = true
;


pacmanStuffedAnimal : Thing 'pacman pac-man stuffed animal' 'Pac-Man stuffed animal'
	"It is a stuffed yellow Pac-Man. Who doesn\'t get shivers when looking at a Pac-Man?
	He is the father of all games. He is the brother and friend of all who play video games."
	
	location = craneFrustration
	isListed = (!isIn(craneFrustration))
	isListedInContents {return isListed;}
;


craneFrustrationTicket : WinningTicket whichMachine=craneFrustration;
*/
