\ wizardry.f for advtr.f  Leo Wong 11 June 02003 fyj +
\ * Is a wizard? * \
\ * Hours * \
\ * New Hours * \
\ * Set up New Hours * \ 
\ * Poof * \

\ * Is a wizard? * \
4 array val
: rca ( -- flag )
   \ Random challenge - 32-bit verseion
   S" @@@@" DROP @
   datime 2* 1+ SWAP  ( w t d )
   5 1 DO
     4 /MOD SWAP 79 + >R ROT ROT R>  ( d w t x )
     0 ?DO ( d w t ) 1027 * 21bit MOD LOOP ( d w t )
     TUCK 26 21bit */ 1+ DUP I val !   ( d t w val )
     32 8 I * - lshift +  ( d t w )
     SWAP ROT ( w t d )
   LOOP 2DROP PAD ! PAD 4 TYPE ;

: solve
   \ Solve the challenge ( assume challenge word in PAD )
   PAD 4 0 DO DUP C@ [CHAR] A - 1+ OVER C! CHAR+ LOOP DROP
   PAD 4 0 DO DUP C@ SWAP CHAR+ LOOP DROP  >R SWAP ROT R>
   PAD 4 0 DO DUP C@ ROT - ABS OVER C! CHAR+ LOOP DROP
   PAD 3 CHARS + magnm
   4 0 DO 10 /MOD >R OVER C@ * OVER C! 1 CHARS - R> LOOP 2DROP
   datime NIP 60 /MOD 10 /MOD 2>R 10 /MOD NIP 2R>
   PAD 3 0 DO DUP C@ ROT + OVER C! CHAR+ LOOP DROP
   PAD 4 0 DO DUP C@ 1+ OVER C! CHAR+ LOOP DROP
   PAD 4 0 DO DUP C@ 26 MOD OVER C! CHAR+ LOOP DROP
   PAD 4 0 DO DUP C@ [CHAR] A + 1- OVER C! CHAR+ LOOP DROP
   CR ." (hush!) " PAD 4 TYPE SPACE ;

: rcb ( -- flag )
   \ True if challenge met
   getin word1 CHAR+ @  ( w )
   datime NIP DUP 60 / 40 * SWAP 10 / 10 * +  ( w t )
   magnm  ( w t d )
   5 1 DO
      I val @ I 4 MOD 1+ val @ - ABS
      OVER 10 MOD *  2 PICK 10 MOD + 26 MOD 1+ >R  ( w t d ) ( R: x )
      ROT R> 32 8 I * - lshift -  ( t' d' w' )
      ROT ROT 10 / >R 10 / R>  ( w' t' d' )
   LOOP 2DROP  S" @@@@" DROP @ = ;

: wizard?  ( -- flag )
  \ TRUE if really a wizard
  16 0 7 yesm DUP \ Ask if a wizard.
     IF DROP  \ Says yes: require proof
        17 mspeak \  First test: know the magic word?
        getin word1 COUNT phrog magic = DUP
        IF DROP \ Does.  Give a random challenge and check reply.
           18 0 0 yesm 0= DUP  \ Correct answer is: no
           IF DROP rca solve rcb 
        THEN
     THEN
     DUP IF 19 ELSE 20 THEN mspeak 
  THEN ;

\ * Hours * \
: hoursx ( h days u -- )
  \ used by hours to print hours
  CR 10 SPACES TYPE SPACE >R
  R@ 0= IF ." Open all day" ELSE
  R@ 16777215 ( 24 bits set ) = IF ." Closed all day" ELSE 
  -1 BEGIN 
      BEGIN 1+ 1 OVER shift R@ AND 0= UNTIL 
      DUP  24 < WHILE DUP 
         BEGIN 1+ 1 OVER shift R@ AND OVER 24 = OR UNTIL
         CR 22 SPACES SWAP 0 .R ." :00 to " DUP 0 .R ." :00"
     REPEAT DROP
  THEN THEN R> DROP ;

: hours  ( -- )
   \ Announce the current hours when the cave is open for adventuring
   \ This info is stored in wkday, wkend, and holid, where 
   \ bit shift(1,n) is on iff the hours from n:00 to n:59 is "prime
   \ time" (cave closed).  wkday is for weekdays, wkend for weekends,
   \ holid for holidays.  Next holiday is from hbegin to hend.
   CR wkday S" Mon - Fri:" hoursx
   CR wkend S" Sat - Sun:" hoursx
   CR holid S" Holidays: " hoursx 
   datime DROP hend OVER < hend hbegin < OR 0=
   IF CR CR 10 SPACES
      hbegin SWAP - DUP 0>
      IF ." The next holiday will be in " DUP . 
         ." day" 1 > IF [CHAR] s EMIT THEN
      ELSE DROP ." Today is a holiday," THEN ." , namely " hname TYPE
   ELSE DROP THEN ;

\ * Set up New Hours * \ 
: newhrx ( days -- newhrx )
  \ Input prime time specs and set up a word of internal format
  \ The cave closed during prime time
  CR ." Prime time on " TYPE
  0                                            ( newhrx )
  BEGIN
     CR ."  from:" getn                        ( newhrx from )
     DUP 0< OVER 24 > OR IF DROP EXIT THEN        
     ."  till:" getn 1-                        ( newhrx from till )
     2DUP > OVER 24 > OR IF 2DROP EXIT THEN 
     1+ SWAP ?DO 1 I shift OR LOOP             ( newhrx )
  AGAIN ;

: newhrs ( -- )
   21 mspeak
   S" Weekdays" newhrx TO wkday
   S" Weekends" newhrx TO wkend
   S" Holidays" newhrx TO holid
   22 mspeak
   hours ;

CREATE wizmessage HERE 71 7 * CHARS DUP ALLOT ERASE
: msg  ( n -- a )  71 * CHARS wizmessage + ;

: motd  ( flag -- )
  \ If true accept new message from the wizard,
  \ else print the current one.  Message is initially null
  IF
    23 mspeak
    0 BEGIN 0 OVER msg C!
            CR PAD DUP 70 ACCEPT DUP
      WHILE 2 PICK msg puts 1+
      DUP 7 = UNTIL 25 mspeak 0 0 THEN
  ELSE
    0 BEGIN DUP msg COUNT DUP WHILE CR TYPE 1+ DUP 7 = UNTIL 0 0 THEN
  THEN 2DROP DROP ;

: maint  ( -- )
   \ Said magic word to invoke maintenance mode.
   \ Wizard can tweak things.
   wizard? IF
     FALSE TO blklin
     10 0 0 yesm IF hours THEN
     11 0 0 yesm IF newhrs THEN
     26 0 0 yesm IF
       27 mspeak  getn TO hbegin
       28 mspeak  getn TO hend
       datime DROP hbegin + DUP TO hbegin hend 1- TO hend
       29 mspeak PAD DUP 20 ACCEPT holiday puts
     THEN
     CR ." Length of short game (0 to leave at " short . ." )"
     getn DUP 0> IF TO short ELSE DROP THEN
     12 mspeak getin word1 COUNT DUP IF phrog TO magic ELSE 2DROP THEN
     13 mspeak getn DUP 0> IF TO magnm ELSE DROP THEN
     CR ." Latency for restart (0 to leave at " latncy . ." )"
     getn DUP 0> IF DUP 45 < IF 30 mspeak THEN  45 MAX TO latncy 
                 ELSE DROP THEN
     \ 14 0 0 yesm IF TRUE motd THEN
     0 TO saved
     2 TO setup
     0 1 abb !
     15 mspeak
     TRUE TO blklin
     ciao
   THEN ;

\ * START *\
: ps?  ( -- primetime? soon? | )
   \ Is it primetime or soon after a saved game?
   \ If _very_ soon, quit and return nothing
   datime  ( d t ) >R 
   DUP 7 MOD 2 < IF wkend ELSE wkday THEN
   OVER hbegin hend 1+ WITHIN IF DROP holid THEN
   1 R@ 60 / SHIFT AND 0<> ( d ptime? )
   SWAP ( ptime? d ) saved - 1440 * R> savet - + ( ptime? delay )
   DUP latncy <  ( ptime? delay soon? )
      DUP IF CR ." This adventure was suspended a mere " OVER .
                ." minutes ago" 
             SWAP latncy 3 / < IF 2 mspeak 2DROP QUIT THEN
          ELSE NIP THEN ;

:NONAME ( -- flag| )  \ start
   \ true if demo; flag ignored if save = -1
   \ if quit, return nothing
   ps? TUCK OR  ( soon? soon/ptime? )  
   IF
      IF ( soon ) 8 mspeak
         wizard? IF -1 to saved  0  ELSE 9 mspeak QUIT THEN
      ELSE ( primetime) 3 mspeak hours 4 mspeak
         wizard? IF -1 TO saved  0
         ELSE setup 0< 
            IF 9 mspeak QUIT
            ELSE 5 7 7 yesm DUP 0= IF DROP QUIT THEN
            THEN
         THEN
      THEN
   ELSE -1 TO saved THEN ; IS start

\ * Poof * \
: poof  ( -- )
   \ Part of database initialisation
   \ Set up some dummy prime-time specs, magic words, etc.
   ( 00777400 TO wkday )  0 TO wkday 
   0 TO wkend   0 TO holid   0 TO hbegin  -1 TO hend  30 TO short
   s" DWARF" phrog TO magic  11111 TO magnm  90 TO latncy ;
 