#charset "us-ascii"
#include <adv3.h>
#include <en_us.h>

versionInfo: GameID
    IFID = '2ee45116-9f36-596e-cc54-7f348655b8d1'
    name = 'Germania'
    byline = 'by Vicente Munoz'
    htmlByline = 'by <a href="mailto:vicmun_02@msn.com">Vicente Munoz</a>'
    version = '1.9 Beta'
    authorEmail = 'Vicente Munoz <vicmun_02@msn.com>'
    desc = 'When Roman Legionnaries find a strange cave the Germanic tribes fear the Centurion orders you to investigate what is inside and to come back with proof.'
    htmlDesc = 'When Roman Legionnaries find a strange cave the Germanic tribes fear the Centurion orders you to investigate what is inside and to come back with proof.'
    headline = 'Germania: The Cave of Fallen Warriors'
    seriesName = 'The Matrix of Warriors'
    seriesNumber = '1'
    genreName = 'Adventure/Puzzle'
    forgivenessLevel = 'Polite'
    gameUrl = 'http://mysite.com/mygame.htm'
    firstPublished = '2008'
    languageCode = 'en-US'
    licenseType = 'Freeware'
    copyingRules = 'Nominal cost only; compilations allowed'
    presentationProfile = 'Default'

    showCredit()
    {
        "Programmed by Vicente \"Vico Surge\" Munoz. Testers: Admiral Dread, StormEagle and Metaldrummer. Special Thanks to: Admiral Dread and StormEagle for all the crazy stuff, making me procrastinate and all the small little details I left out. ";
        "\b";
    }
    showAbout()
    {
        "Always wanted to try my hand at IF creation and decided to try TADS3 for the task, I can say I am quite pleased!<.p>
        This is part of a probably large series of small IF games. This chapter will be released for the IFBeginnersComp and Interactive Short Fiction Competition.<.p>
        Commands to remember: PUSH PULL USE ATTACHTO GET TAKE REPAIR GOTHROUGH MOVE SEARCH ";
    }
;

gameMain: GameMainDef
    initialPlayerChar = me
    showIntro()
    {
        "Your task was set as simple. Explore a cave that has been reported as a disturbance to the local population, it could be some of the Germanic tribes or wildlife, but that is for you to discover personally.<.p>
        As soon as you\'ve found the source of this problem it is imperative you report back to the Centurion on the camp. Mars be with you, Strength and Honor.\b";
    }
    showGoodbye()
    {
        "<.p>I'll be waiting...\b";
    }
    maxScore = 100
;

/* Rooms */

   /*************************
    *    #0  STARTROOM      *
    *************************/ 

startroom: OutdoorRoom
    roomName = 'Outside the Cave Entrance'
    desc = "The Entrance is muddy and obscure. Footsteps continue towards
    the depths of the cave with no sign as to where it ends." 
    south : FakeConnector { "<q>No cowards on my watch unless you want to taste my gladius!</q> cries the Legionary while grimacing as he places his hand over his sheath." }
    north = caveMouth
	roomParts = [outdoorSky, defaultDeck]
;	

+ me: Actor
;

++ meTunic : Wearable 'tunic' 'tunic'
	"A simple red tunic made of wool. "
	wornBy = me
  dobjFor(Doff)
  {
     check()
     {
       failCheck('You would have to remove your Lorica first and that would mean Death. ');
     }
  }
;

++ meSandals : Wearable 'sandal/sandals' 'pair of sandals'
	"A simple pair of sandals. "
	wornBy = me 
;

++ meGalea : Wearable 'galea/helmet' 'galea'
	"The Galea, or Legionary Helmet, covers most of your head and face, including your neck. "
	wornBy = me 
;

++ mepouch : Wearable, OpenableContainer 'leather pouch/pouch' 'leather pouch'
  "A small leather pouch. " 
  bulkCapacity = 2 
  wornBy = me
;

+++ coins : Thing 'coin/coins/gold/gold coin/gold coins' 'couple of coins'
	"Three gold coins with the head of the Cesar. "
	bulk = 1
  dobjFor(Take)
  {
    preCond = [touchObj]
    verify() { illogical('{You/he} don\'t need them for anything right now.'); }
  }
;

++ mesheath : Wearable, Container 'leather sheath/sheath' 'leather sheath'
  "A leather sheath. " 
  bulkCapacity = 2 
  wornBy = me
  dobjFor(Close)
  {
  	verify()
  	{
  		if (isOpen)
  		 illogical('There is no way to close the sheath. ');
  	}
  }
;

+++ meGladius : Thing 'gladius/sword/gladius sword/short sword' 'gladius' 
  "The Gladius is the standard sword, blade made of steel and hilt made of wood, of the Legionary. 
  It's length, 2 feet, is probably not so useful against Germanic tribes who wield gigantic axes but they don't have YOUR training." 
  bulk = 2
  dobjFor(Wield) remapTo(Wear, meGladius)
  dobjFor(Drop)
  {
    preCond = [touchObj]
    verify() { illogical('{You/he} can\'t do that! A Legionary never drops his Gladius!'); }
  }
  iobjFor(CutWith)
  {
      preCond = [touchObj]
      verify() { illogical('By Mars you are a Legionary not a Gardener!'); }
  }
;

++ meLorica : Wearable 'lorica/armor/armour/breastplate/segmentata/lorica segmentata' 'lorica segmentata' 
  "A Lorica Segmentata. This will keep you safe from any frontal attacks. " 
  wornBy = me
  dobjFor(Doff)
  {
     check()
     {
       failCheck('You\'ll end up dead if you do that. ');
     }
  }
;

++ meScutum : Wearable 'scutum/shield' 'scutum' 
  "The Scutum is the standard legionary, semi-cylindrical, squared shield made of wood. Light
  enough to be carried around for long distances and hard enough to knock your enemy to death." 
  wornBy = me 
  dobjFor(Doff)
  {
     check()
     {
       failCheck('The Centurion would punish you for leaving your Scutum behind. ');
     }
  }
;

+ mud : Fixture 'mud' 'mud' 
    "It's mud but it looks darker... " 
    smellDesc = "It does smell like mud but another faint odor comes into your nostrils... blood. " 
    feelDesc = "It feels rough and dry for some reason. "
    cannotTakeMsg = 'There is no reason as to why you should be carrying mud. '
;

+ footsteps : Fixture 'footsteps/footstep' 'footsteps' 
    "Those don't look like normal footsteps. They are as wide as two grown man hands
    and are probably twice as long as your feet! " 
    feelDesc = "They are fresh. Probably from an hour or two ago. "
;

+ theCave : Fixture 'cave/opening/entrance' 'cave'
	desc = "It looks rather huge. Could be a staging point for the Germanic tribes or maybe just the lair of some wild life causing problems but of course that is for you to discover. "
	cannotTakeMsg = "Unless you're Godzilla or Trogdor that's not possible. "
;


   /*************************
    *   #1   CAVEMOUTH      *
    *************************/ 

caveMouth: Room
    roomName = 'Cave Mouth'
    desc = "Close now to the cave you get a horrible stench with a red trail leading you inside.<.p>
    There is something painted on the walls just to your left near a bush." 
   	dobjFor(Smell) remapTo(Smell, stenchBeg)
    south = startroom
    north = insideMouth
    roomParts = [outdoorSky, defaultDeck]
    enteringRoom(traveler)  
    {        
      if(smallPyramid.discovered)    
          "";
          else
      {
		say('As you approach the mouth of the cave you see something shine in the bush to your left. ');
      }
    }     
;

+ stenchBeg : SimpleOdor 'stench' 'stench'
	desc = "Something smells rotten and it's coming from the inside. "
	isAmbient = true
;

+ bloodtrail : Fixture 'blood/trail/red/red trail/blood trail' 'blood trail'
	desc = "A dark red trail leading to the innards of the cave. "
	smellDesc = "Smells like blood, you could always TASTE it. "
	tasteDesc = "It is blood and feels warm in your tounge. "
	cannotTakeMsg = 'It\'s already dry and you don\'t have anything to store it in anyway. '
;

+ paitingOutside : Fixture 'painting/paint/wall' 'painting'
	desc = "Those are rather interesting paintings.<.p> One of them depicts a dead person being buried
	and in the next one he's coming up again.<.p> Another one depicts some kind of... wolf following a
	pack of people, the final one a wolf eating one of them. "
	cannotTakeMsg = 'That\'s painted on the wall. And there\'s no purpose on removing it either. '
;

+ bush : Fixture 'bush' 'bush'
	desc = "A small bush. Probably the only thing left with life in this place.<.p> Something shines on the ground where the bush stands. "
	cannotTakeMsg = 'No purpose on walking around with a bush. '
  actionDobjSearch() 
  { 
    if(smallPyramid.discovered) 
      "{You/he} find{s} nothing else in the bush. "; 
    else 
    { 
      "As {you/he} move the dirt around the shiny object you pull it out to discover it is a small glass pyramid.<.p> You admire it for a second then shrug and put it in your pouch. "; 
      smallPyramid.discover(); 
      smallPyramid.moveInto(mepouch);
      bush.moveInto(nil);
      shiny.moveInto(nil);
      emptyBush.discover();
    } 
  } 
    dobjFor(CutWith)
    {
        verify() { logicalRank(10, 'not cuttable'); }
    }
; 

+ emptyBush : Fixture, Hidden 'bush' 'bush'
	desc = "A small bush. Probably the only thing left with life in this place. "
	cannotTakeMsg = 'No purpose on walking around with a bush. '
  actionDobjSearch() 
  { 
    if(smallPyramid.discovered) 
      "{You/he} find{s} nothing else in the bush. "; 
    else 
    { 
      "As {you/he} move the dirt around the shiny object you pull it out to discover it is a small glass pyramid.<.p> You admire it for a second then shrug and put it in your pouch. "; 
      smallPyramid.discover(); 
      smallPyramid.moveInto(mepouch);
      bush.moveInto(nil);
      shiny.moveInto(nil);
      emptyBush.discover();
    } 
  } 
    dobjFor(CutWith)
    {
        verify() { logicalRank(10, 'not cuttable'); }
    }
; 

+ shiny : Immovable 'shiny/shine/glass' 'shiny'
	desc = "It looks like a piece of glass. If you had it in your hands you could examine it with more detail. "
	dobjFor(Take) remapTo(Search, bush)
	dobjFor(Get) remapTo(Search, bush)
;

   /*************************
    *   #2 INSIDEMOUTH      *
    *************************/ 

insideMouth: Room
    roomName = 'Inside the Cave'
    Desc = "The now lit room is revealed showing a series of drawings on the floor close to the pedestal and filled with small shards of glass attached to the walls and ceiling.<.p>
    The blood trail continues north into the darkness of the cave.<.p>" 
	initSpecialDesc = "The cave goes fairly deep but there is not enough light to see what's beyond.<.p>"
	roomParts = [glassSky, defaultCave]
    south = caveMouth
  	north : TravelMessage 
       {  ->caveHole
          ""
           canTravelerPass(traveler) {return truepedestal.discovered(); }
          explainTravelBarrier(traveler) { "There are too many eyes around you. A source of light would be better to continue your advance. "; } 
       }      
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && truepedestal.discovered)
             Desc;
         else
             initSpecialDesc;
     }      
    enteringRoom(traveler)  
    {        
      if(!traveler.hasSeen(self) && traveler == gPlayerChar)    
          "A brutal howl hits the cave as wind strikes from the outside.<.p> It creates a dust cloud that reveals a small hole on the ground. "; 
    } 
;

+ stenchMid : SimpleOdor 'stench' 'stench'
	desc = "Something smells rotten and it's coming from deeper inside the cave. "
	isAmbient = true
;

+ middlebloodtrail : Fixture 'blood/trail/red/red trail/blood trail' 'blood trail'
	desc = "A dark red trail that dims as it continues into the darkness of the cave. "
	smellDesc = "Smells like blood, you could always TASTE it. "
	tasteDesc = "It is blood and feels warm in your tounge. "
	cannotTakeMsg = 'It\'s already dry and you don\'t have anything to store it in anyway. '
;

/* This would be the pedestal in hidden mode representing just a square in the ground */
+ pedestal : Surface, Immovable 'pedestal/hole/square/square hole' 'square hole'
	desc = "The square shaped hole is perfectly cut.<.p>"
	cannotTakeMsg = 'It\'s just a square on the ground. Not like you could really take it. '
	dobjFor(Push) remapTo(Move, pedestal)
	dobjFor(Pull) remapTo(Move, pedestal)
  	actionDobjMove() 
  	{ 
  		"It won\'t move an inch. The base seems to be attached to the ground. ";
  	}
;

+ shadows : Fixture 'shadow/shadows' 'shadows'
	desc = "There's at least a hundred shadows moving all over this part of the cave.<.p>
	They follow every single of your footsteps... better be careful."
	initSpecialDesc = "A set of eerie shadows watch over you from all sides. "
	cannotTakeMsg = 'That doesn\'t sound wise. '
     dobjFor(Attack)
     {
         preCond = [touchObj]
         verify() { }
         action() { mainReport('That is unwise Legionary. There\'s too many of them. '); }
     }
;

+ truepedestal : Hidden, Fixture 'pedestal' 'pedestal'
	desc = "The stone pedestal stands up to four feet tall and on the middle holds a small pyramid. "
	cannotTakeMsg = 'There\'s no way to take the pedestal. It seems as if it was part of the ground. '
	dobjFor(Push) remapTo(Move, truepedestal)
	dobjFor(Pull) remapTo(Move, truepedestal)
  	actionDobjMove() 
  	{ 
  		"It won\'t move an inch. The base seems to be attached to the ground. ";
  	}
;

+ truepyramid : Hidden, Fixture 'small pyramid/pyramid' 'pyramid'
	desc = "The small glass pyramid has now become an incredible source of blinding light. "
	cannotTakeMsg = 'As hard as you try you can\'t take the pyramid out of its current position. '
;

+ smallPyramid : Hidden, Thing 'small pyramid/pyramid/glass/shiny/shine' 'small glass pyramid'
  "It's a perfectly cut pyramid made of glass. " 
  bulk = 1
  weigth = 1
    actionDobjPutOn()
  	{ 
    if(truepedestal.discovered) 
      "{You/he} find{s} nothing else in the bush. "; 
    else 
    { if(smallPyramid.discovered) "Once the pyramid is set on the hole it produces a mechanical noise and begins to rumble.<.p>
	Slowly moving back you notice a circular stone pedestal slowly rises from the ground and elevates up to four feet.<.p>
	As sun rays hit the pyramid they reflect onto the walls and begin to produce a blinding light that now baths the entire room!<.p>
	Once the room is fully illuminated a horrible hiss comes from the end of the cave and a set of red eyes cower into the darkness.<.p> ";
      truepedestal.discover(); 
      truepyramid.discover();
      glassReflection.discover();
      pedestal.moveInto(nil);
      shadows.moveInto(nil);
      smallPyramid.moveInto(nil); 
      floorDrawings.discovered();
	  addToScore(5, 'getting a source of light in the cave. '); 
    } 
  } 
; 

+ glassReflection : Hidden, Fixture 'glass/reflection/reflections/wall' 'glass'
	desc = "Thousands of glass shards are incrusted on the wall as if some kind of explosion had set them there. They reflect you in many sizes and forms. "
	cannotTakeMsg = 'It would be hard and time consuming to take every single shard of glass off from the walls. '
    actionDobjSearch()
  	{ 
    if(firstdisc.discovered) 
      "There is nothing else of interest that deserves your time. "; 
    else 
    { 
	  "You find a shard of glass that calls your attention. It is dark and shows no effects to sunlight. ";
	  evilShardDoor.makeOpen(!evilShardDoor.isOpen); 
	  firstdisc.discover();
    } 
  } 
;

+ evilShardDoor : HiddenDoor 'evil shard/evil/dark/shadow' 'shadow shard'
	desc = "This shard of glass is dark and it seems to be reflecting your presence but you can't quite make it"
	destination = halloftruth
	dobjFor(Get) remapTo(GoThrough, evilShardDoor)
	dobjFor(Take) remapTo(GoThrough, evilShardDoor)
;

+ floorDrawings : Hidden, Fixture 'drawings/pictures/warning' 'floor drawings'
	desc = "There are three drawings.<.p>
	The one on the left has a group of people marching toward the drawing on the right which is a snake of unnatural proportions.<.p>
	The top one has a man holding a pyramid with rays coming out of it. "
	cannotTakeMsg = 'That would be harder than you think, Legionary. '
;

   /*************************
    *    #3   CAVEHOLE      *
    *************************/ 

caveHole: Room
	roomName = 'Hole'
	initSpecialDesc = "This part of the cave is barely visible to the naked eye."
	Desc = "The blood trail ends here with a huge hole leading downwards, by means of a now visible rope, with no clue as to where it ends.<.p>"
	roomParts = [glassSky, defaultCave]
	south = insideMouth
  	down : TravelMessage 
       {  ->deepEntrance
          "The rope groans as you lower yourself but you return your gaze terrified as you hear a snap and begin to fall at full speed towards the bottom of the hole.<.p>
          You recover consciousness after an unknown amount of time with your back and left side in pain. Luckly for you your Scutum took the fall but it is now completely useless.<.p>
          As you stand up you hear something crunching below your broken Scutum. "
           canTravelerPass(traveler) {return mirror.discovered(); }
          explainTravelBarrier(traveler) { "There is no way of going down there. "; } 
       }      
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && mirror.discovered)
             Desc;
         else
             initSpecialDesc;
     }
;

+ stenchHoleTop : SimpleOdor 'stench' 'stench'
	desc = "The putrid smell intensifies but you aren't sure where it's really coming from. "
	isAmbient = true
;

+ cloth : Hidden, Thing 'piece of cloth/cloth' 'piece of cloth'
  "It's a dirty piece of cloth. " 
     actionDobjPutOn()
  	{ 
    if(trueGermanCorpse.discovered) 
      "{You/he} find{s} nothing else in the bush. "; 
    else 
    { if(germanCorpse.discovered) "You show compasion for your enemy and cover him with the piece of dirty cloth and place three coins over his face, two over his eyes and one over his mouth, for the boatman. ";
      addToScore(5, 'for honoring your enemies. '); 
      cloth.moveInto(nil);
      germanCorpse.moveInto(nil);
      coins.moveInto(nil);
      trueGermanCorpse.discover(); 
      corpseCoins.discover(); 
      corpseCloth.discover(); 
     } 
  } 
;

+ hole : Fixture 'hole' 'hole'
	desc = "It's so deep you can't see the end of it. "
	cannotTakeMsg = 'Suuuuuure. Why don\'t you try doing that with a dark hole? ' 
;

+ litHole : Hidden, Fixture 'hole' 'hole'
	desc = "Even with all the light you are still unable to verify how deep it goes. "
	cannotTakeMsg = 'Why don\'t you try doing that with a white hole? Huh? Tough guy. ' 
;

+ ropeUp : Hidden, Fixture 'rope' 'rope'
	desc = "The rope doesn't look that firm to hold your entire weight. Strangely enough it's coming from an opening on the right side of the cave. "
    dobjFor(Climb) remapTo(Down)
	cannotTakeMsg = 'You are not even sure where the rope is coming from to start with. '
;

+ caveShadow : Fixture 'shadow/cave shadow' 'shadow'
	desc = "A dancing shadow... "
	specialDesc = "A shadow dances near the edge of the hole. "	
	dobjFor(Look) remapTo(Search, self)
	dobjFor(Examine) remapTo(Search, self)
  	actionDobjSearch() 
  		{ 
    	if(clothMirror.discovered) 
      	"{You/he} find{s} nothing else in the bush. "; 
    	else 
    		{ 
      		"As you examine closer you notice it's a dirty piece of cloth. "; 
      		clothMirror.discover(); 
      		caveShadow.moveInto(nil); 
    		} 
  		} 
     dobjFor(Attack)
     {
         preCond = [touchObj]
         verify() { }
         action() { mainReport('The shadow shows no reaction from your presence. '); }
     }
;	

/* Couldn't use Get/Take directly so remapped Get/Take to Search. Works! Also notice this was done when I was starting to use TADS 3 so I didn't have much of a clue how to work stuff around. Need to rework it though. */
+ clothMirror : Hidden, Fixture 'cloth' 'cloth'
	desc = "It's just a dirty piece of cloth. "
	specialDesc = "A dirty piece of cloth seems to be covering something. "
	dobjFor(Take) remapTo(Search, self)
	dobjFor(Get) remapTo(Search, self)
	dobjFor(Remove) remapTo(Search, self)
  actionDobjSearch() 
  { 
    if(mirror.discovered) 
      "{You/he} find{s} nothing else in the bush. "; 
    else 
    { 
      "You take the piece of cloth and reveal a mirror.<.p>
      As soon as light hits the mirror it reflects towards the other smaller pieces incrusted in the walls illuminating the room!"; 
      mirror.discover(); 
      ropeUp.discover(); 
      engravedWord.discover();
      finalblood.discover(); 
      addToScore(10, 'getting more light into the cave. '); 
      addToScore(10, 'discovering a way to explore deeper into the cave. '); 
      cloth.discover();
      cloth.moveInto(gActor);
      clothMirror.moveInto(nil); 
      litHole.discovered();
      hole.moveInto(nil);
    } 
  } 
;

+ engravedWord : Hidden, Fixture 'engraved/marks/something/engraved words/words/word' 'engraved words'
	desc = "Someone engraved into the rock a message in several toungues, including Latin.<.p>
	It reads <q>Death for those who dare step beyond here without the Gift of the Gods</q><.p>
	Next to these words there's stick figure of a man being bathed in light and the rest drowning in water."
	initSpecialDesc = "There are some words written on the wall next to the mirror. "
	specialDesc = nil
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && mirror.discovered)
             initSpecialDesc;
         else
             specialDesc;
     }
;

+ finalblood : Hidden, Fixture 'blood/trail' 'blood'
	desc = "The blood trail ends on the edge of the hole. "
	cannotTakeMsg = 'It\'s already dry and you don\'t have anything to store it in anyway. '
;

+ mirror : Hidden, Fixture 'mirror' 'mirror'
	desc = "A mirror, covered by a wooden frame, roughly seven feet tall. It reflects the light coming from the south into the ceiling which in turn returns light to the bottom of the hole. "
	cannotTakeMsg = 'It is set firm where it stands and there is no point on carrying something that big around. '
	cannotMoveMsg = 'It seems to be stuck on the ground. ' 

;

   /*************************
    *  #4  DEEPENTRANCE     *
    *************************/ 

deepEntrance: Room
	roomName = 'Hole'
	initSpecialDesc = "The bottom of the hole. It shows no signs of the blood trail above but there is a tunnel to the north and an opening to the south from whence a putrid aroma is coming.<.p>"
	Desc = "The bottom of the hole. It shows no signs of the blood trail above but there is a tunnel to the north and an opening to the south from whence a putrid aroma is coming.<.p>"
	roomParts = [caveSky, defaultCave]
	north = fork
	south = deepOpening
    up : FakeConnector
    {
    	"There's no way of going up anymore. "
    }
    enteringRoom(traveler)  
    {        
      if(!traveler.hasSeen(self) && traveler == gPlayerChar)    
		meScutum.moveInto(nil);
    } 
    showSpecialDesc()
    {
        if (useInitSpecialDesc() && brokenmirror.discovered)
            Desc;
        else
            initSpecialDesc;
    }        
;	

+ sphere : Thing, Hidden 'sphere/glass/glass sphere' 'glass sphere'
  desc = "A small perfectly cut glass sphere with a red center that glows. " 
  brightness = 3 
  dobjFor(Drop)
  {
    preCond = [touchObj]
    verify() { illogical('{You/he} can\'t! As much as you try there is an unknown force preventing you from doing so!'); }
  }
; 

+ trueGermanCorpse : Hidden, Surface, Fixture 'body/corpse/tribesman/man' 'body'
	desc = "The body has now been fixed into position with both hands on his chest and covered with a piece of cloth. On top of his eyes sockets and mouth a total of three gold coins have been placed. "
	cannotTakeMsg = 'You better leave the dead alone. '
	initSpecialDesc = "A piece of cloth now covers the fallen tribesman."
	actionDobjAttack() 
	{
		"Show some respect for the dead! ";
	}
	dobjFor(Move) remapTo(Take, trueGermanCorpse)
	dobjFor(Pull) remapTo(Move, trueGermanCorpse)
	dobjFor(Push) remapTo(Move, trueGermanCorpse)
  actionDobjSearch() 
  { 
    if(sphere.discovered) 
      "{You/he} find{s} nothing else of interest. "; 
    else 
    { 
      "{You/he} put special attention to the small pouch and acquire a small glass sphere. It begins to glow and as it does so it heats your hand until it reaches a comfortable level. "; 
      addToScore(5, 'finding a new source of light. '); 
      sphere.discover(); 
      sphere.moveInto(gActor);
    } 
  } 
  actionDobjRepair() 
  { 
    if(eyeoftruth.discovered) 
      "\"Though I may fix wood and steal, move time and space, I cannot bring back those from the Nexus\" answer the eye "; 
  } 
;

+ corpseCloth : Fixture, Hidden 'cloth/piece of cloth' 'cloth'
	desc = "A small piece of cloth covers the defunct Germanic warrior. "
	cannotTakeMsg = 'Do not disrespect the dead Legionary. '
;

+ corpseCoins : Fixture, Hidden 'gold/coins/gold coin/gold coins' 'gold coins'
	desc = "A set of coins with the head of the cesar imprinted on them. They now reside over the face of the tribesman. "
	cannotTakeMsg = 'Do not disrespect the dead Legionary. '
;
	
+ germanCorpse : Hidden, Surface, Fixture 'body/corpse/tribesman/man' 'body'
	desc = "The body of a dead Germanic tribesman. Wearing a huge wolf pelt over his back and dressed in wool.<.p>
	He has a small pouch tied to his belt just like yours. "
	initSpecialDesc = "The body of a germanic tribesman."
	cannotTakeMsg = 'You better leave the dead alone. '
	actionDobjAttack() 
	{
		"Show some respect for the dead! ";
	}
	dobjFor(Move) remapTo(Take, germanCorpse)
	dobjFor(Pull) remapTo(Move, germanCorpse)
	dobjFor(Push) remapTo(Move, germanCorpse)
  actionDobjSearch() 
  { 
    if(sphere.discovered) 
      "{You/he} find{s} nothing else of interest. "; 
    else 
    { 
      "{You/he} put special attention to the small pouch and acquire a small glass sphere. It begins to glow and as it does so it heats your hand until it reaches a comfortable level. "; 
      addToScore(5, 'finding a new source of light. '); 
      sphere.discover(); 
      sphere.moveInto(gActor);
    } 
  } 
  actionDobjRepair() 
  { 
    if(eyeoftruth.discovered) 
      "\"Though I may fix wood and steal, move time and space, I cannot bring back those from the Nexus\" answer the eye "; 
  } 
;

+ stenchFinal : SimpleOdor 'stench' 'stench'
	desc = "The horrendous stench that has been bothering you is coming from the south. "
	isAmbient = true
;

+ realrope : Attachable, Thing 'rope' 'rope'
	"A rather large piece of rope. You assume it is around twenty or so feet. "  
	canAttachTo(obj) { return obj==realCrank; } 
   handleAttach(other) 
   { 
     finalCrank.discover(); 
     atacRope.discover();
     moveInto(nil); 
     other.moveInto(nil); 
     "{You/he} tie the rope to the crank and throw the other end into the hole. "; 
     addToScore(5, 'gaining access to the next level. '); 
   } 
;

+ brokenmirror : Hidden, Fixture 'mirror/broken/broken mirror/glass' 'broken mirror'
	desc = "Pieces of a broken mirror lay all over the floor. "
	initSpecialDesc = "There are several glass shards laying on the floor. " 
	cannotTakeMsg = "Not much sense on carrying any of these when you have your gladius. "
  actionDobjRepair() 
  { 
    if(eyeoftruth.discovered) 
      { "The eye shines again and the mirror is restored completely.<.p>
      Oddly small waves start to form inside the mirror and you are sucked into it. Once inside you find yourself in a room full of mirrors.<.p>
      \"Beware, something evil lurks this room\" Whispers the Eye of Truth. "; 
      addToScore(5, 'fixing the broken mirror. '); 
      gActor.moveInto(parallelDimension);
      brokenmirror.moveInto(nil);
      finalMirror.discover(); }
      else
      {
      "You are not sure on how to fix it and even if you did you don't have the tools for that. ";
      }
  }
;

+ finalMirror : Hidden, Fixture 'mirror/broken/broken mirror/glass' 'broken mirror'
	desc = "A six to seven feet tall mirror. Impressive to think this was broken just moments ago. "
	initSpecialDesc = "The mirror is reflecting the light coming from the top towards the north. " 
	cannotTakeMsg = "Too heavy to take with you. "
	
;

+ brokenScutum : Immovable 'broken scutum/broken/scutum/shield' 'broken scutum' 
  "The Scutum used to be semi-cylindrical. Now it's semi-trash being split into several small parts. " 
  initSpecialDesc = "The Scutum lays in pieces all over the floor. Something is underneath it. " 
  specialDesc = "The pieces of the scutum have been set into a pile and moved next to the wall. "
  cannotTakeMsg = 'It\'s useless now and there\'s no way to fix it anyway. ' 
  dobjFor(Search) remapTo(Pull, brokenScutum)
  dobjFor(LookUnder) remapTo(Pull, brokenScutum)
  dobjFor(Move) remapTo(Pull, brokenScutum)
  dobjFor(Pull) 
  { 
    action() 
    { 
      if(moved) 
        "You already gathered the remains scutum in a small pile. "; 
      else 
      { 
        "As you move the pieces of the Scutum into a pile you notice pieces of a mirror. "; 
        brokenmirror.discover();
        moved = true; 
      } 
    } 
  } 
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && truepedestal.discovered)
             initSpecialDesc;
         else
             specialDesc;
     }         
  actionDobjRepair() 
  { 
    if(eyeoftruth.discovered()) 
    {
      "\"Watch young one as matter becomes one again\" The sphere jumps out of your hand and rolls over to the broken scutum. After a blinding flash of light, and a minute or two to fix your sight, your eyes fix upon the newly fixed shield with the eye being the decorative center.<.p>
      \"Pick it up, young one, and delight yourself\" And as you pick it up the shield shows to be much more lighter than it originally was. "; 
      finalScutum.discover();
      finalScutum.moveInto(gActor);
      eyeoftruth.moveInto(nil);
      brokenScutum.moveInto(nil);
      brokenmirror.discover();
      addToScore(5, 'fixing your Scutum '); }
      else
      {
      "You are not sure on how to fix it and even if you did you don't have the tools for that. ";
      }
  } 
; 

+ finalScutum : Wearable, Hidden 'scutum/shield' 'scutum' 
  "This Scutum feels lighter than a standard one and instead of the decorative yellow center it has a small glass sphere, the eye of truth, adorning it. " 
  wornBy = me
  brightness = 3  
  dobjFor(Doff)
  {
     check()
     {
       failCheck('An unknown force prevents you from letting go of your Scutum. ');
     }
  }
;


   /*************************
    *     #5 DEEPOPENING    *
    *************************/ 

deepOpening: Room
	roomName = 'Opening'
	north = deepEntrance
	Desc = "This part of the tunnel is small and badly lit.<.p>
	You notice a bulge on the far side of the opening towards the south. "
	initSpecialDesc = "This part of the tunnel is small and badly lit. "
	roomParts = [caveSky, defaultCave]
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && germanCorpse.discovered)
             initSpecialDesc;
         else
         	 Desc;
     }        
;

+ stenchSource : SimpleOdor 'stench' 'stench'
	desc = "The stench is coming from somewhere in this small opening. "
	isAmbient = true
;

+ bulge : Immovable 'bulge' 'bulge'
	"It's a bulge. Lack of light prevents you from actually discerning what it is. "
  	cannotTakeMsg = 'It feels too heavy. Maybe you could pull it where there\'s more light. ' 
  	smellDesc = "This is the source of the stench. "
	actionDobjAttack() 
	{
		"You're not even sure what it is and you want to attack it? Nonsense! ";
	}
  	dobjFor(Move) remapTo(Pull, bulge)
  	dobjFor(Pull) 
  	{ 
    	action() 
    	{ 
      		if(moved) 
        	"You already gathered the remains scutum in a small pile. "; 
      		else 
      		{ 
        	"You pull the bulge back towards the area where you dropped, the only source of light that you have, to view it better.<.p>
        	As you acquire more visibility you notice its the body of a germanic tribesman.<.p>"; 
        	gActor.moveInto(deepEntrance);
        	germanCorpse.discover();
        	bulge.moveInto(nil);
        	moved = true; 
      		} 
    	} 
  	} 
;
    
   /*************************
    *         #6 FORK       *
    *************************/ 

fork: DarkRoom
	roomName = 'Fork'
	south = deepEntrance
	northeast = liftRoom
	northwest = guardEntrance
	desc = "The tunnel splits into two directions. Both exits, to the northwest and northeast, are dark.<.p>
	To north, west and east you can see a mirror. They seem to be aligned. "
	roomParts = [caveSky, defaultCave]
;

+ leftMirror : Fixture 'left mirror/mirror/mirror to the left' 'mirror to the left'
	desc = "A heavy mirror with a wooden frame. It points to the northeast. "
	cannotTakeMsg = 'It is too heavy to be taken around and it serves no true purpose. '
	cannotMoveMsg = 'That might not seem like a good idea. They seem to be aligned. ' 
;

+ northMirror : Fixture 'north mirror/mirror/mirror to the north' 'mirror to the north'
	desc = "A heavy mirror with a wooden frame. It points to the south. "
	cannotTakeMsg = 'It is too heavy to be taken around and it serves no true purpose. '
	cannotMoveMsg = 'That might not seem like a good idea. They seem to be aligned. ' 
;

+ rightMirror : Fixture 'right mirror/mirror/mirror to the right' 'mirror to the right'
	desc = "A heavy mirror with a wooden frame. It points to the northwest. "
	cannotTakeMsg = 'It is too heavy to be taken around and it serves no true purpose. '
	cannotMoveMsg = 'That might not seem like a good idea. They seem to be aligned. ' 
;

+ stenchFork : SimpleOdor 'stench' 'stench'
	desc = "A putrid aroma is coming from the south. "
	isAmbient = true
;

   /*************************
    *         #7 LIFT       *
    *************************/ 
    
liftRoom: DarkRoom
	roomName = 'Lift Entrance'
	southwest = fork
	desc = "The tunnel ends abruptly here with another hole, this one man-made, leading even deeper. "
	roomParts = [caveSky, defaultCave]
  	down : TravelMessage 
       {  ->templeEntrance
          "The rope groans as you climb down and reach the stone floor. "
           canTravelerPass(traveler) {return finalCrank.discovered(); }
          explainTravelBarrier(traveler) { "There is no way to reach the bottom unless you jump to your certain death. "; } 
       }      
;
       
+ crankMove : Attachable, Immovable 'crank/piece of wood' 'crank'
	desc = "The small circular crank keeps turning around by itself. "
	initSpecialDesc = "An odd noise is heard from the west wall coming from a crank. "
	cannotTakeMsg = 'You are not even sure how it is turning by itself and you wish to take it out? Nonsense! '
	soundSize = medium
	soundPresence = true
	soundDesc = "It's producing a grind like noise. As if something heavy was moving on the other side. " 
;

+ atacSpear : Immovable, Hidden 'spear/broken spear' 'broken spear'
	desc = "A relatively short spear has been impaled into the crank hard enough to make it stop moving by itself. "
	cannotTakeMsg = 'Why? You placed it there on the first place. '
;

+ realCrank : Attachable, Hidden, Immovable 'crank/piece of wood' 'crank'
	desc = "The small circular crank has a spear impaled and thus has stopped rotating. "
	initSpecialDesc = "The crank is not rotating anymore thus producing no more noise. "
	cannotTakeMsg = 'First you impale it and now you want to take it and do what, dine? You\'re doing it all wrong man! '
;

+ atacRope : Immovable, Hidden 'rope' 'rope'
	desc = "A piece of rope. It's been attached to the crank providing a mean to climb down. "
	cannotTakeMsg = 'Why? You placed it there on the first place. '
;

+ finalCrank : Hidden, Immovable 'crank/piece of wood' 'crank'
	desc = "The crank has a spear impaled and a rope tied to it. "
	initSpecialDesc = "The crank has a rope tied to it which goes down the hole. "
	cannotTakeMsg = 'Believe me that\'s not gonna happen, I mean you\'ve used a spear and now a rope, come on! '
;

+ darkLiftHole : Fixture 'dark/hole/dark hole' 'dark hole'
	desc = "This hole seems to be man-made. It is uncertain how deep it goes. "
	cannotTakeMsg = "Now you're just mucking about it. "
;

   /*************************
    *    #8 GUARDENTRANCE   *
    *************************/ 

guardEntrance: DarkRoom
	roomName = 'Tunnel'
	initSpecialDesc = "The tunnel ends here abruptly. The only way to continue is back towards the southwest from where you came.<.p>
	The only interesting thing here is a giant rock that is on the north wall. "
	specialDesc = "The giant rock has been moved and now there is an opening to the north towards a small cave.<.p> "
	southeast = fork
	north asExit(secretGuardDoor)
 	roomParts = [caveSky, disturbedCave]
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && giantRock.moved)
             specialDesc;
         else
             initSpecialDesc;
     }    
;

+ giantRock : Immovable 'rock/giant rock' 'giant rock'
	desc = "This giant rock seems out of place. The color variates slightly from the rest of the cave wall and there is a small space between, the tunnel wall and the body of the rock, letting through a weak current of air. "
	dobjFor(Move) remapTo(Push, giantRock)
  	actionDobjPull() 
  	{ 
  		"It is too heavy to pull it... maybe you could push it. ";
  	}
  	dobjFor(Push) 
  	{ 
    	action() 
    	{ 
      		if(moved) 
        	"You've already pushed this as far as you could. "; 
      		else 
      		{ 
        	"Slowly you push the rock an opening is revealed and covering it a wooden 'door'.<.p>"; 
        	pseudoWood.discover();
        	woodenPseudoDoor.discover();
        	moved = true; 
        	addToScore(5, 'finding another room. '); 
      		} 
    	} 
  	} 
;

+ pseudoWood : Immovable, Hidden 'opening' 'opening'
	desc = "The opening is covered by a piece of wood that seems to be a door. "
	cannotTakeMsg = 'Stop fooling around. '
;

+ woodenPseudoDoor : Immovable, Hidden 'plain door/door/plain wooden door' 'wooden door'
	desc = "This 'seems' to be a door. You are not even sure due to the fact it is a simple piece of wood covering the opening. "
	cannotTakeMsg = 'You don\'t even know how to open it and now you want to take it? '
  	actionDobjKnock() 
  	{ 
  		"You knock twice but hear no reply from the other side. ";
  	}
	dobjFor(Open) remapTo(Push, woodenPseudoDoor)
  	dobjFor(Move) remapTo(Push, woodenPseudoDoor)
  	dobjFor(Push) 
  	{ 
    	action() 
    	{ 
      		if(moved) 
        	""; 
      		else 
      		{ 
        	"Standing ready for anything you push the wooden door.<.p>
        	It slowly moves backward until it hits the ground making a loud CLANK and raising a cloud of dust.<.p>"; 
        	secretGuardDoor.makeOpen(!secretGuardDoor.isOpen); 
        	pseudoWood.moveInto(nil);
        	woodenPseudoDoor.moveInto(nil);
        	secretGuardDoor.discover();
      		} 
    	} 
  	} 
;

+ secretGuardDoor : HiddenDoor 'opening/cave opening' 'opening'
	desc = "The opening is quite big giving access to a small cave on the other side. "
	destination = guardRoom
;


   /*************************
    *      #9 GUARDROOM     *
    *************************/ 

guardRoom : DarkRoom
	roomName = 'Guard Room'
	south = guardEntrance
	desc = "This looks like a guard room. To the north there's a bear fur, to the west a basket and a small wooden shelf next to it."
	roomParts = [caveSky, defaultCave]
    enteringRoom(traveler)  
    {        
      if(!traveler.hasSeen(self) && traveler == gPlayerChar)    
          say('As you enter the room you feel someone is watching you.<.p>
          "Beware brave one" You hear a faint whisper next to your ear and a cold breeze blow close to your neck "Creatures older than your world lurk the darkness. The eye is your only salvation in the darkness... "<.p>
          An unknown force makes your hand rise and show you the glass sphere. The ruby center twitches and it opens up revealing an eye.<.p>
          "Use me young one to fix your broken items. You will notice time and space become meaningless in my presence." The voice whispers in your ear.<.p>
          [REPAIR COMMAND ENABLED] ');
          /* Yeah the repair command is there but it will only work correctly when the eye of truth is discovered. */          
          sphere.moveInto(nil);
          eyeoftruth.discover();
          eyeoftruth.moveInto(gActor);
          addToScore(5, 'learning about the eye of truth. '); 
    } 
;

+ woodShelf : Surface, Fixture 'shelf/wood shelf' 'wood shelf'
	desc = "A small wood shelf. It holds a small burnt out candle. "
	cannotTakeMsg = 'There is little sense in carrying a shelf all over a cave. '
;

++ burntCandle : Fixture 'burnt candle/burnt/candle' 'burnt candle'
	desc = "This candle is so small it would not last but a mere few seconds lit. "
	cannotTakeMsg = 'No use in carrying a burnt candle'
;

+ bearfur : Immovable 'bear fur/fur' 'bear fur'
	desc = "A giant bear fur. It must have been one hell of a fight to bring this animal one."
	feelDesc = "It has a rough feel but it is warm to the touch. "
	dobjFor(Move) remapTo(Pull, bearfur)
  	dobjFor(Pull) 
  	{ 
    	action() 
    	{ 
      		if(moved) 
        	"No purpose on moving the fur anymore. "; 
      		else 
      		{ 
        	"Slowly the fur rolls and reveals a broken spear. What was it doing there you have no clue.<.p>";
        	brokenSpear.discover();
      		} 
    	} 
  	} 
  	dobjFor(LookUnder) 
  	{ 
    	action() 
    	{ 
      		if(moved) 
        	"There's nothing else below it. "; 
      		else 
      		{ 
        	"There seems to be something below it. If you moved the fur you would have a better opportunity to see what it is.<.p>"; 
        	brokenSpear.discover();
      		} 
    	} 
  	} 
;

+ brokenSpear : Attachable, Thing, Hidden 'spear/broken spear' 'broken spear'
	desc = "A broken spear with a dull tip. "
  actionDobjRepair() 
  { 
    if(eyeoftruth.discovered()) 
      { "The eye shines to the point where it blinds you. After adjusting your sight the spear in your hand has grown up to four feet and the tip has become truly sharp.<.p>
      \"The old, the broken, the dull and the spent, I shall repair it for you always young one as long as you defend me\" "; 
      fullSpear.discover();
      fullSpear.moveInto(gActor);
      brokenSpear.moveInto(nil);
      addToScore(5, 'fixing the broken spear. '); }
      else
      {
      "You are not sure on how to fix it and even if you did you don't have the tools for that. ";
      }
  } 
;

+ fullSpear : Attachable, Thing, Hidden 'spear' 'spear'
	desc = "This spear is around four feet tall with a really sharp metal tip. "
	dobjFor(Use) remapTo(AttachTo)
	canAttachTo(obj) { return obj==crankMove; } 
   handleAttach(other) 
   { 
     realCrank.discover(); 
     atacSpear.discover();
     moveInto(nil); 
     other.moveInto(nil); 
     "{You/he} impale the spear on the rotating piece of circle wood. It complains making some grinding noise but it falls silent after a while. "; 
   } 
;
	
+ basket : OpenableContainer, Fixture 'basket' 'basket'
	desc = "A simple woven basket. "
	smellDesc = "It has a faint smell of crude meat. " 
	soundDesc = "No sound comes from the basket. "
	bulkCapacity = 3
	
;

+ pieceWood : Fixture 'wood/piece of wood/large wood' 'large piece of wood'
	desc = "This large piece of wood was covering the door. Now it makes a nice carpet on this dark cold room. "
	initSpecialDesc = "A large piece of wood lays on the ground. "
	cannotTakeMsg = 'You have no use for it, at all. '
;

+ eyeoftruth : Thing, Hidden 'sphere/glass/glass sphere/eye/eye of truth' 'eye of truth'
  desc = "A small perfectly cut glass sphere. In the center it holds an eye that watches over you. " 
  brightness = 3 
  dobjFor(Drop)
  {
    preCond = [touchObj]
    verify() { illogical('{You/he} can\'t! As much as you try there is an unknown force preventing you from doing so!'); }
  }
; 

   /*************************
    *    #10 HALLOFTRUTH    *
    *************************/ 

halloftruth : Room
	roomName = 'Hall of Truth'
	specialDesc = "This place looks like some sort of abandoned temple. A small hole enough to fit a person is on the middle of the room. "
	initSpecialDesc = "This place looks like some sort of abandoned temple. There is no source of light except for a pedestal in the middle of the room. "
		roomParts = [templeSky, defaultTemple]
    enteringRoom(traveler)  
    {        
      if(!traveler.hasSeen(self) && traveler == gPlayerChar)    
          say('Out of curiosity you decide to take the shard. As soon as it is in your hand the shard breaks into millions of pieces. Reality warps into darkness as you find yourself in some kind of parallel room. ');
    } 
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && !dimensionalGate.isOpen)
             initSpecialDesc;
         else
         	 specialDesc;
     }      
;

+ halloftruthpedestal : Surface, Fixture 'pedestal' 'pedestal'
	desc = "A stone pedestal for books. It also has a small metal plate that holds an almost burnt out candle. "
	cannotTakeMsg = 'There is no way you could just take it. '
	feelDesc = "Touching it produces an abnormal cold cross through your palm. "
	dobjFor(Pull) remapTo(Move, halloftruthpedestal)
	dobjFor(Push) remapTo(Move, halloftruthpedestal)
  	actionDobjMove() 
  	{ 
  		"It won\'t move an inch. The base seems to be attached to the ground. ";
  	}
;

++ firstdisc : Hidden, Thing 'disc/circle' 'small disc'
	desc = "It looks like a small disc made of metal. "
	dobjFor(Get) remapTo(Take)
  	actionDobjTake() 
  	{ 
  		if(firstdisc.moved)    
  		"It is better to keep it in a safe place";
  		else
  		{
  		"Curiosity strikes you as to what would a disc be doing in a place where one would find a scroll or a papyrus.<.p>
  		 As soon as you touch it a reaction is heard as it hums and light emanates dimly producing a dark-clad figure.<.p>
  		 \"It is certain though\" The figure speaks, you are unsure what kind of trick or magic is this but the figure seems not to notice you \"That Death is something we cannot avoid\"<.p>
  		 \"But we have found a way to contain our most brilliant minds in a single entity, a nexus, where we can 'store' them to avoid their loss\" The figure walks forward and dissapears for a second then returns with an object in his hand.<.p>
  		 \"Their minds will feed this single entity, from it we can move our armies with calculated precision, from it we can do research a million times faster, from it we can govern without the evils of corruption or personal agendas\"<.p>
  		 There is silence that is soon cut by whispers. Turning around reveals hundreds, maybe thousands, of eyes watching over you and the small disc but their attention seems to be concentrated solely on the disc, not you specificaly.
  		 \"We are seeing the future, Ladies and Gentlemen, where perfection can be led by our kind without the corruptions of flesh, greed or lust.\" The man fades away and a deep voice speaks afterwards. \"Recording 1 of 12.\"<.p>
  		 Silence. Nothing more. Again looking around reveals the temple empty and the disc now remaining silent. Touching it again produces no answer and knowing this is an impressive tool you decide to keep it safe in your pouch.<.p>
  		 Once you've taken it the arch on the other side of the pedestal begins to glow blue.";
  		 moved = true;
  		 firstdisc.moveInto(mepouch);
  		 addToScore(5, 'being one step closer to the truth... '); 
  		 evilShardDoor.moveInto(nil);
  		 dimensionalGate.makeOpen(!dimensionalGate.isOpen); 
  		 dimensionalGate.discover();
  		 nonWorkingGate.moveInto(nil);
  		 }
  	}
;

++ candle : Fixture 'small candle/candle' 'small candle'
	desc = "The small candle is about to burn out. "
	cannotTakeMsg = 'It serves no purpose as it is about to be completely burnt out. '
;
 
+ nonWorkingGate : Fixture 'door/arch/opening' 'arch'
	desc = "The arch looks bizarre. It doesn\'t fit in with the rest of the room. "
	initSpecialDesc = "Just a few feet north of the pedestal there is a stone arch. "
	cannotTakeMsg = 'The arch was sculpted from the floor making it one with the stone floor. '
;
	

+ dimensionalGate : HiddenDoor, Hidden 'door/arch/arches/opening' 'arch'
	desc = "The arch looks bizarre, even more with the faint blue glow. It doesn\'t fit in with the rest of the room. "
	initSpecialDesc = "The arch is now producing a faint blue aura. "
	specialDesc = "The arch is now producing a faint blue aura. "
	destination = insideMouth
	cannotTakeMsg = 'The arch has been sculpted from the stone floor making it part of the floor. '
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && !dimensionalGate.isOpen)
             initSpecialDesc;
         else
         	 specialDesc;
     }      
;
    

   /*************************
    *   #11 TEMPLEENTRANCE  *
    *************************/ 

templeEntrance : DarkRoom
	roomName = 'Stone Hallway'
	desc = "This part of the cave is different from the rest. The ground is made of cut stone and so is the ceiling.<.p>
	Pieces of wood and metal are scattered all over the floor. "
		roomParts = [templeSky, defaultTemple]
  	up : TravelMessage 
       {  ->liftRoom
          "The rope groans as you climb up and reach the "
           canTravelerPass(traveler) {return finalCrank.discovered(); }
          explainTravelBarrier(traveler) { "Woops. Something went wrong and this shouldn't be here. "; } 
       }      
  	north : TravelMessage 
       {  ->templeBridge
          ""
           canTravelerPass(traveler) {return silverDagger.discovered(); }
          explainTravelBarrier(traveler) { "\"Without the gift of the gods you may not cross\" whispers the eye of truth \"You must bring it to sink the guardian\""; } 
       }      
;

+ metal : Fixture 'pieces of metal/metal' 'pieces of metal'
	desc = "Some scattered pieces of metal covering the ground. "
	cannotTakeMsg = 'There\'s nothing that could be reused. '
  actionDobjRepair() 
  { 
  	"\"Alas young one\" Speaks the eye. \"No reason on rebuilding it when you have already found the solution\" ";
  }	
;

+ brokenwood : Fixture 'pieces of wood/wood' 'pieces of wood'
	desc = "Several pieces of wood, consisting of different sizes, laying all over the floor. "
	cannotTakeMsg = 'There doesn\'t seem to be anything you could reuse. '
  actionDobjRepair() 
  { 
	"\"Alas young one\" Speaks the eye. \"No reason on rebuilding it when you have already found the solution\" ";
  }	
;

+ bridgeNorth : Fixture 'bridge' 'bridge'
	desc = "The bridge looks untrustworthy and the length makes it even less trustworthy but is the only way of reaching the other end which looks like a gate of sorts. "
	cannotTakeMsg = "It wouldn't make any sense. Specially since there's no other way around it. "
;

   /*************************
    *   #12 TEMPLEBRIDGE  *
    *************************/ 
    
templeBridge : Room
	roomName = 'Wooden Bridge'
	desc = "The wooden bridge crosses a great length of empty dark space. Several planks are bathed by sunlight that comes from broken sections on the ceiling.<.p>"
		roomParts = [brokenTempleSky, gooBridge]
	north : FakeConnector { "The red eyes are still watching you... there must be a way to distract the guardian. " } 		
	south = templeEntrance
    enteringRoom(traveler)  
    {        
      if(finalScutum.discovered() && !traveler.hasSeen(self) && traveler == gPlayerChar)    
          { "\"Use the Gift of the Gods against the Guardian\" Your shield suddenly acquires a silver finish that reflects the sun rays. ";
          silverScutum.discover();
          silverScutum.moveInto(gActor);
          finalScutum.moveInto(nil);
          gActor.moveInto(secondAlternateBridge); }
          else
      {
		"You need your Scutum, young one, go back for it.";
      }
    }     
;

+ guardianTemple : Fixture 'guardian/snake/eyes/red eyes' 'red eyes'
	desc = "Unsure of what it is you can only assume it is huge as the eyes watch you from somewhere high. "
	initSpecialDesc = "A set of red eyes watch you from the darkness. "
	cannotTakeMsg = 'There doesn\'t seem to be anything you could reuse. '
;

+ firstsunlight : Fixture 'sunlight/light/rays' 'sunlight'
	desc = "Golden rays of sunlight. Your only friend in this dark place. "
;

+ silverScutum : Wearable, Hidden 'scutum/shield' 'scutum' 
  "The weights the same as before but it seems as if it was made from silver! " 
  wornBy = me
  brightness = 3  
  dobjFor(Doff)
  {
     check()
     {
       failCheck('An unknown force prevents you from letting go of your Scutum. ');
     }
  }
;

   /*************************
    *      #13 MAINGATE     *
    *************************/ 

mainGate : Room
	roomName = 'The Gate'
	desc = "The ground here is different from the rest of the cave. It consists of pure stone, probably carved out of the mountain itself, with decorations.<.p>
	The gate to the north holds several figures, all of them unknown to you, and a giant lock in the middle bottom side. "
		roomParts = [templeSky, defaultTemple]
	in = snakeTunnel
    north = cellNorthDoor
  	south : TravelMessage 
       {  ->templeBridge
          "Woops. Something went wrong and you shouldn't be seeing this. "
           canTravelerPass(traveler) {return totem.discovered(); }
          explainTravelBarrier(traveler) { "There is no more bridge thus no way to cross. "; } 
       }      
;
    
+ cellNorthDoor : LockableWithKey, Door -> cellSouthDoor 'gate/door' 'gate' 
  "The giant door seems to be made of stone. It has several figures sculpted and a giant odd looking small rectangle in the lower section" 
  keyList = [silverDagger] 
;

+ giantLock : Fixture 'lock/giant lock' 'giant lock'
	desc = "This rectangle seems to be some kind of lock. On the top it has some drawings sculpted into the body of the gate. "
;

+ gateDrawings : Fixture 'drawings/pictures/figures' 'drawings'
	desc = "The drawings show a man holding a dagger and opening the gate. It also shows a giant snake like creature trapping several people and then eating them. "
;

+ bridgeGone : Fixture 'bridge' 'bridge'
	desc = "It is gone. It fell down together with that gigantic snake. "
	cannotTakeMsg = "You cannot take what is not there. "
	actionDobjRepair() 
  { 
	"\"No time for that. You must hurry into the safety of the Nexus!\" Answers the eye. ";
  }	
;

   /*************************
    *       #14 TEMPLE      *
    *************************/ 
    
templeInside : Room
	roomName = 'Inside the Main Gate'
	desc = "Inside proves to be even bigger than the gate itself!<.p>
	There is a city of sorts to the north with what looks like a temple on the middle. The road looks rather long but there is nowhere else to go at this point."
		roomParts = [templeSky, defaultTemple]
    south : TravelMessage 
    	{
    		destination = cellSouthDoor
    		travelDesc =  "With huge effort you manage to push the doors open making a horrible racket. Once inside you find yourself in some kind of crossroad. "
    	}
	north : FakeConnector { "The road ahead looks long. " } 
    enteringRoom(traveler)  
    {        
      if(!traveler.hasSeen(self) && traveler == gPlayerChar)    
          addToScore(10, 'reaching the temple ');               
          finishGameMsg('You have made it into the Temple! But there is more, what lays inside this ancient structure? Why are there so many unnatural creatures and who is helping you? Sadly enough the only way to find out is to wait for the next installment.', [finishOptionUndo,finishOptionFullScore]);
    } 
;

+ cellSouthDoor : LockableWithKey, Door -> cellNorthDoor 'gate/door' 'gate' 
  "A cold, heavy, metal door. " 
  keyList = [silverDagger]
;

+ crossroadSign : Fixture 'crossroad/sign/wooden sign' 'crossroad sign'
	desc = "The crossroad sign has some pieces of wood attached to it pointing in several directions. "
	initSpecialDesc = "There's a crossroad sign next to one of the roads. "
;

   /*************************
    *      #15 PARALLEL     *
    *************************/ 
    
parallelDimension : Room
	roomName = 'The Room of Mirrors'
	desc = "The room is made out of mirrors except for the south which is completely dark. "
	initSpecialDesc = "There are no visible doors or exits of any kind in this room. Just mirrors. "
     showSpecialDesc()
     {
         if (useInitSpecialDesc() && mirror.discovered)
             Desc;
         else
             initSpecialDesc;
     }
	north : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
	northeast : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
	east : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
	southeast : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
	south : TravelMessage  
	  {  
	    destination = deepEntrance
	    canTravelerPass(traveler) { return silverDagger.discovered(); }  
           explainTravelBarrier(traveler)  
           { "You try finding a way to move the mirror or go through it but nothing works. "; } 
           travelDesc =  "You walk through the dark opening and suddenly find yourself back in the cave." 
      }
	southwest : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
	west : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
	northwest : FakeConnector { "You try finding a way to move the mirror or go through it but nothing works. " } 
;

+ silverDagger : Hidden, Key 'silver dagger/dagger' 'silver dagger'
  desc = "It is a dagger made of pure silver with a hilt made of an unknown white material. The blade has several perforations of different depths. " 
  isInInitState = true
; 

+ parallelNorthMirror : Fixture 'north mirror' 'north mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ northWestMirror : Fixture 'northwest mirror' 'northwest mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ westMirror : Fixture 'west mirror' 'west mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ southWestMirror : Fixture 'southwest mirror' 'southwest mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ southMirror : Fixture 'south mirror' 'south mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror. 
	<.p>The reflected image on this mirror looks odd. "
	dobjFor(Push) remapTo(Push, invertedImage)
	feelDesc = "Touching the mirror gives you an electrical feeling going through your arms. "
	dobjFor(Search) remapTo(Push, invertedImage)
  actionDobjPush() 
  { 
  	"Once you place your right hand on the mirror he extends his hand and stabs you with a dagger which crosses through your hand.<.p>
  	Immediately the eye shines and the reflection turns mad with rage until it explodes and with it the mirror itself giving you a way of this place.<.p>
  	\"Be wary young one. Trust not even yourself\" The dagger falls out of your wound as it closes. \"Now take the key, child, with it you shall enter the Nexus\"<.p>
  	Taking it in your hands proves to be an impressive feat as it tries to resist at first making your hand shake. Once in your grasp you feel a rush of warmth through your entire body. ";
  	silverDagger.discover();
  	silverDagger.moveInto(gActor);
  	addToScore(10, 'getting the key to the \"Nexus\". '); 
  	southMirror.moveInto(nil);
  	invertedImage.moveInto(nil);
  }	
;

+ southEastMirror : Fixture 'southeast mirror' 'southeast mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ eastMirror : Fixture 'east mirror' 'east mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ northEastMirror : Fixture 'northeast mirror' 'northeast mirror'
	desc = "The mirror is probably ten to twelve feet tall and it reaches the ceiling which is another giant mirror.
	<.p>The mirror reflects your image. "
	cannotMoveMsg = "Nothing happens. "
	actionDobjBreak() 
	{
  		"An unnatural force is preventing you from doing that. ";
	}
	actionDobjSearch() 
	{
  		"You find nothing odd. ";
	}
;

+ floor : Fixture 'floor' 'floor'
	desc = "The floor is made of a single stone slab. "
;

+ invertedImage : Immovable 'image/legionary/mirage/reflection' 'image'
	desc = "It is a reflection of you. But it looks... decayed, as if it had turned into a mummy.
	<.p> It seems to be calling for you with his hand to come closer. "
	feelDesc = "Touching the mirror gives you an electrical feeling going through your arms. "
  actionDobjPush() 
  { 
  	"Once you place your right hand on the mirror he extends his hand and stabs you with a dagger which crosses through your hand.<.p>
  	Immediately the eye shines and the reflection turns mad with rage until it explodes and with it the mirror itself giving you a way of this place.<.p>
  	\"Be wary young one. Trust not even yourself\" The dagger falls out of your wound as it closes. \"Now take the key, child, with it you shall enter the Nexus\"<.p>
  	Taking it your hands proves to be an impressive feat as it tries to resist at first making your hand shake. Once in your grasp you feel a rush of warmth through your entire body. ";
  	silverDagger.discover();
  	silverDagger.moveInto(gActor);
  	addToScore(10, 'getting the key to the \"Nexus\". '); 
  	southMirror.moveInto(nil);
  	invertedImage.moveInto(nil);
  }	
;

   /*************************
    *    #16 FINAL BRIDGE   *
    *************************/ 	

/* This is an internal room. The player will not see the transition but it works properly story-wise. */

alternateTempleBridge : Room
	roomName = 'Wooden Bridge'
	desc = "The wooden bridge crosses a great length of empty dark space. Several planks are bathed by sunlight that comes from broken sections on the ceiling. "
		roomParts = [brokenTempleSky, gooBridge]
	south : FakeConnector { "There are several red eyes and shadow lurking to the south. It doesn't seem like a good idea to go back. " } 		
    north : TravelMessage 
    	{
    		destination = mainGate
    		travelDesc =  "As you reach the other side the bridge collapses and falls into the darkness. You are safe... for now. "
    	}
;

+ demons : Fixture, Hidden 'demons/creatures' 'demons'
	desc = "The Demons stand next to the south end of the bridge but they don't seem to be advancing forward for some reason. "
;

   /*************************
    *    #17 SNAKE TUNNEL   *
    *************************/ 	

snakeTunnel : Room
	roomName = 'Dark Tunnel'
	desc = "The tunnel looks long and there's barely enough light to see what lays ahead. "
	north : FakeConnector { "That might not be wise. There is not enough sunlight to proceed. " } 		
	out = mainGate
		roomParts = [brokenTempleSky, gooBridge]
;

+ goo : Fixture 'goo/mucus/slime' 'slime'
	desc = "This seems to be some kind of mucus left by the Guardian..."
	initSpecialDesc = "It is also covered in some kind of slime..."
	cannotTakeMsg = "That sounds like a REALLY bad idea. "
	actionDobjSearch() 
	{
  		if(seconddisc.discovered())    
  		"It is better to keep it in a safe place";
  		else
  		{
		"You turn braver than ever and star looking through, what you hope, is not some kind of reproductive fluid.<.p>
		After a while you find what looks like a small disc but drop it by mistake.";
		seconddisc.discover();
		seconddisc.moveInto(snakeTunnel);
		}
	}
;

+ seconddisc : Hidden, Thing 'disc/circle' 'small disc'
	desc = "It looks like a small disc made of metal. "
	dobjFor(Get) remapTo(Take)
  	actionDobjTake() 
  	{ 
  		if(thirddisc.discovered())    
  		"It is better to keep it in a safe place";
  		else
  		{
		 " \"Gentlemen I bring you the most excellent news\" The figure spreads his arms and smiles as a group of moons form over his hands.
		 \"Itatia is now ours, together with Lauredia, Febura and Apacea\"<.p>
		 \"And I must thank you kindly, for cementing the foundations of a greater future, and for supporting Talandros Umora.
		 For if it hadn\'t been for those great enough to join the Nexus we wouldn\'t have gotten this far\"
		 The moons disappear and on his right hand appears a pillar.
		 \"Blessed be the Nexus and blessed be our Generals, our Scientists, our Politicians but most of all blessed all of you who agreed for the better of our kind\"<.p>
		 The figure suddenly disappears but in its place a small sphere with a red center is presented.
		 \"Observe perfection, beautifuly cut and beautifuly deadly, this is one of the many Battle Sphere the Nexus has created and simply with it we hold the Grounds of War and we hold the future of our Race. Nothing will ever stop us again.\"<.p>
		 The figure dissapears and a deep voice is heard. \"Recording 7 of 12.\"";
  		 seconddisc.moveInto(mepouch);
  		 thirddisc.discover();
  		 addToScore(5, 'being one step closer to the truth... '); 
  		}
  	}
;

   /*************************
    *   #18 SECOND BRIDGE   *
    *************************/ 	

/* This is an internal room. The player will not see the transition but it works properly story-wise. */
    
secondAlternateBridge : Room
	roomName = 'Wooden Bridge'
	desc = "The wooden bridge crosses a great length of empty dark space. Several planks are bathed by sunlight that comes from broken sections on the ceiling. "
		roomParts = [brokenTempleSky, gooBridge]
	north : FakeConnector { "The red eyes are still watching you... there must be a way to distract the guardian. " } 		
	south : FakeConnector { "There are several red eyes and shadow lurking to the south. It doesn't seem like a good idea to go back. " } 		
    enteringRoom(traveler)  
    {        
      if(finalScutum.discovered() && !traveler.hasSeen(self) && traveler == gPlayerChar)    
          { "\"Use the Gift of the Gods against the Guardian\" Your shield suddenly acquires a silver finish that reflects the sun rays. ";
          silverScutum.discover();
          silverScutum.moveInto(gActor);
          finalScutum.moveInto(nil); }
          else
      {
		"You need your Scutum, young one, go back for it.";
      }
    }     
;

+ sunlight : Fixture 'sunlight/light/rays' 'sunlight'
	desc = "Golden rays of sunlight. Your only friend in this dark place. "
  dobjFor(Use)
  {
    action()    
    {
       if(silverScutum.discovered())
       {
		"Using the Scutum you reflect the sunlight toward the red eyes. As you do a horrible albino giant snake is revealed which begins to screech and twist as it cowers from the sunlight.<.p>
		It quickly runs into a hole carved next to the gate giving some more screeching but not before it hits the stakes holding the bridge on the north side which provoke it to shake without control.<.p>
		\"Run young one! To the Nexus!\" Gazing to the south reveals a series of red eyes watching you. \"Do not look at them, run!\"<.p>
		Running to the other side of the bridge proves easier with the fact that it seems it will collapse any second. Luckily it does collapse after you've crossed so at least you are safe from whatever was on the other side.<.p> ";
		demons.discover();
		guardianTemple.moveInto(nil);
		gActor.moveInto(alternateTempleBridge);
		copyguardianTemple.moveInto(nil);
		addToScore(5, 'defeating the Guardian. ');
        exit;
       }
    }
  }
;
    
+ copyguardianTemple : Fixture 'guardian/snake/eyes/red eyes' 'red eyes'
	desc = "Unsure of what it is you can only assume it is huge as the eyes watch you from somewhere high. "
	initSpecialDesc = "A set of red eyes watch you from the darkness. "
	cannotTakeMsg = 'There doesn\'t seem to be anything you could reuse. '
;

/* This is just to allow the second disc to be taken. */

+ thirddisc : Hidden, Thing 'disc/circle' 'small disc'
	desc = "It looks like a small disc made of metal. "
;

   /*************************
    *    #W NEW COMMANDS    *
    *************************/ 

DefineTAction(Headbutt);

VerbRule(Headbutt)
  'headbutt' singleDobj
  : HeadbuttAction
  verbPhrase = 'headbutt/headbutt (what)'
;

DefineTAction(Knock);

VerbRule(Knock)
  'knock' singleDobj
  : KnockAction
  verbPhrase = 'knock/knocking (what)'
;

DefineTAction(Use);

VerbRule(Use)
  'use' singleDobj
  : UseAction
  verbPhrase = 'use/using (what)'
;

DefineTAction(Wield);

VerbRule(Wield)
  'wield' singleDobj
  : WieldAction
  verbPhrase = 'wield/wield (what)'
;

DefineTAction(Repair);

VerbRule(Repair)
  'repair' singleDobj
  : RepairAction
  verbPhrase = 'repair/repairing (what)'
;

   /*************************
    *    #X ROOMTEMPLATE    *
    *************************/ 

/* Floor */
    
defaultDeck : Floor 'ground/floor' 'ground' 
  "Some grass covers the ground but most of it consists of dried mud. " 
   putDestMessage = &putDestFloor
; 

defaultCave : Floor 'ground/floor' 'ground'
	"The floor of the cave is made of pure solid rock"
	putDestMessage = &putDestFloor
;

disturbedCave : Floor 'ground/floor' 'ground'
	"The ground seems to have been disturbed recently. There are marks of something heavy being moved towards the current position of the giant rock. "
	putDestMessage = &putDestFloor
;

defaultTemple : Floor 'ground/floor' 'ground'
	"The floor is covered in neatly cut pieces of rock, of which type you are not sure, but they all show different shades of gray. "
	putDestMessage = &putDestFloor
;

gooBridge : Floor 'bridge' 'bridge'
	"The wooden planks are covered by an unidentified source of goo. "
	putDestMessage = &putDestFloor
;

/* Ceiling */

outdoorSky : RoomPart 'sky' 'sky' 
  "A blue sky with a high sun and no wind. " 
; 

caveSky : RoomPart 'roof/ceiling' 'ceiling' 
  "There are a few stalactites adorning the ceiling of the cave. " 
; 

glassSky : RoomPart 'roof/ceiling' 'ceiling' 
  "The beauty of the ceiling is represented by hundreds of glass shards adorning it. " 
; 

templeSky : RoomPart 'roof/ceiling' 'ceiling' 
  "The ceiling is made from a single stone slab. There is not a single cut to be seen anywhere. " 
; 

brokenTempleSky : RoomPart 'roof/ceiling' 'ceiling' 
  "The ceiling is made from a single stone slab but it seems to have been damaged and has cracked in several sections letting light pass through. " 
; 

   /*************************
    *    #Y   ITEMS         *
    *************************/ 

/* The items located here have not been assigned anywhere */

totem : Hidden, Thing 'Totem' 'Totem'
	desc = "This odd totem has the form of a creature with two giant front claws that walks on his back legs. A message imprinted on a gold plaque reads, \"Zerg Rush KEKEKEKEKEKE\" "
;
	
dirtyDagger : Hidden, Thing 'dirty dagger/dagger' 'dirty dagger'
  desc = "A mud covered dagger. Nothing surprising except that it's in good state. " 
; 

+ runes : Hidden, Fixture 'rune/runes' 'runes'
	"You are not sure what this runes mean but the Centurion might know. "
;

germanAxe : Thing 'axe/two hand axe/two-hand axe' 'Germanic two hand Axe' 
  "A German two hand axe. What fun would it be without it?<.p>
  Probably about as much fun as a eunuch in a room full of harlots. " 
  bulk = 5 
;

torch : Hidden, Flashlight 'piece of wood/torch/wood' 'piece of wood'
  "A feet long piece of wood covered in some viscous dark liquid. " 
  isLit = nil
  brightnessOn = 3 
  bulk = 2
  weigth = 2
; 

flint : Hidden, Flashlight 'flint*flints' 'pair of flints'
  "A pair of flint rocks. " 
; 

prism : Thing 'prism' 'prism'
	"An hexagonal crystal perfectly cut on each side. "
    dobjFor(Remove)
     {
         preCond = [touchObj, objNotWorn, roomToHoldObj]
         verify()
         {
             /* if we're already held, there's nothing to remove me from */
             if (isHeldBy(gActor))
                 illogicalNow(&cannotRemoveHeldMsg);
         }
         action() { askForIobj(TakeFrom); }
     }
;

   /*************************
    *    #Z     NPC         *
    *************************/ 

/* The NPC's have their items declared in this section */
    
legionary : Person 'legionary/soldier/man' 'legionary' @startroom 
  "The Legionary was sent here to oversee that you investigate the cave. " 
  properName = 'Legionary'  
  globalParamName = 'legionary' 
  isHim = true
  dobjFor(Attack) remapTo(Headbutt, legionary)
  dobjFor(Kill) remapTo(Headbutt, legionary)
  actionDobjHeadbutt() 
  { 
  	"The Legionary smacks you silly.<.p>\"Stop fooling around and go do your work before I call the Centurion!\" He yells at you. ";
  }
;

;

+ centurionTalking : InConversationState 
  stateDesc = "He's looking at you rather annoyed. "  
  specialDesc = "{The legionary/he} leans himself against his scutum which he places in front of him. "
;

++ centurionWorking : ConversationReadyState 
  stateDesc = "He looks rather bored and impatient. " 
  specialDesc = "<<a++ ? '{The legionary/he}' : '{The legionary/he}'>>  
  awaits, annoyed and bored, for you to explore the cave. " 
  isInitState = true 
  a = 0 
;

+++ HelloTopic, StopEventList 
  [ 
    '<q>Hail!,</q> you say, he only nods slightly.<.p>'
  ] 
; 

+++ ByeTopic 
  "<q>Long live the Empire, Strength and Honor.</q> you say.<.p> 
   <q>Strength and Honor.</q> {the legionary/he} declares with his uninterested attitude towards you. " 
; 

+++ ImpByeTopic 
  "{The legionary/he} slowly shakes his head and awaits impatiently.<.p> " 
;

+ Sandals : Wearable 'sandal/sandals' 'pair of sandals'
	"A simple pair of sandals. "
	wornBy = me 
;

+ Galea : Wearable 'galea/helmet' 'galea'
	"The Galea, or Legionary Helmet, covers most of your head and face, including your neck. "
	wornBy = me 
;

+ tunic : Wearable 'tunic' 'tunic'
	"A simple red tunic made of wool. "
	wornBy = me
;

+ Wearable 'lorica/armor/armour/breastplate/segmentata/lorica segmentata' 'lorica segmentata' 
  "A Lorica Segmentata. This will keep you safe from any frontal attacks. " 
  wornBy = me 
;

+ Wearable 'scutum/shield' 'scutum' 
  "The Scutum is the standard legionary, semi-cylindrical, squared shield made of wood. Light
  enough to be carried around for long distances and hard enough to knock your enemy to death." 
  wornBy = me 
;

+ leathersheath : Wearable, Container 'leather sheath/sheath' 'leather sheath'
  "A leather sheath. " 
  bulkCapacity = 2 
  wornBy = me 
  isOpen { return !isWorn(); } 
;

++ Wearable 'gladius/sword/gladius sword/short sword' 'gladius' 
  "The Gladius is the standard sword, blade made of steel and hilt made of wood, of the Legionary. 
  It's length, 2 feet, is probably not so useful against Germanic tribes who wield gigantic axes but they don't have YOUR training." 
; 