/* The <gmon.h> header is used by gprof(1) and monitor(3).
 *
 * written by Kai-Uwe Bloem, 04/16/90
 */

#ifndef	_GMON_H
#define	_GMON_H

/* This header file descibes the outfit of the "gmon.out" file as created by
 * the monitor(3) library call and analyzed by gprof(1). gmon.out consists of
 * three parts :
 *  - header describing histogramm data
 *  - histogramm data
 *  - function call arc information
 */

/* header portion of gmon.out */

struct gm_header {
	unsigned long low;	/* lowest sampled pc in histogramm */
	unsigned long high;	/* highest sampled pc in histogramm */
	long nbytes;		/* length of header and histogramm in bytes */
};
/* nbytes = sizeof(struct gm_header) + databytes in histogramm. One entry in
 * the histogramm covers
 *   (high - low) / ((nbytes - sizeof(struct gm_header) * sizeof(CHUNK))
 * bytes of the text segment.
 */

/* histogramm data */

typedef	unsigned short	CHUNK;	/* data type of elements in histogramm */
				/* (type inherited from the profil(2) call) */

/* call arc information */

struct gm_call {
	unsigned long from;	/* pc of the calling procedure */
	unsigned long to;	/* pc of the called procedure */
	unsigned long ncalls;	/* how often has this call occured */
};
/* gm_call is needed to build a call graph of your program. Everytime a
 * procedure A compiled with -p is called, the calling procedure B is determined
 * and noted in the profiling data. This way you get :
 *  - which procedures have called procedure A
 *  - how often have those procedures called A
 * Note that if A is called from different places in B, you get different
 * gm_call entries.
 */

/* Function Prototypes. */
#ifndef _ANSI_H
#include <ansi.h>
#endif

_PROTOTYPE( void moncontrol, (int flag)					);
_PROTOTYPE( void monitor, (void (*low_pc)(void), void (*high_pc)(void),
			CHUNK buf[], unsigned long bufsiz, unsigned nr_func) );
_PROTOTYPE( void monstartup, (void (*low_pc)(void), void (*high_pc)(void))   );
_PROTOTYPE( void _mcleanup, (void)					);

#endif /* _GMON_H */
