#if (CHIP == M68000)
/*
 * The console driver for the Atari ST
 */
#define DEBDMP		/* dump system tables */
#define	TTYDMP		/* dump tty info  */
#define DEBOUT		/* debugging on console and/or printer */

#include "kernel.h"
#include <signal.h>
#include <sgtty.h>

#include "proc.h"
#include "tty.h"

#ifdef DEBOUT
PRIVATE int	STuseCon = 1;
PRIVATE int	STusePrt = 0;
#endif
#ifdef DEBDMP
PRIVATE int	STdoDump = 0;
#endif
PUBLIC int	STdebKey = 0;		/* set to F1..F10 by stkbd.c */

/*===========================================================================*
 *				func_key				     *
 *===========================================================================*/
PUBLIC void func_key()
{
  int i;

/* handle CTRL-ALT-PFX sequences */
  if (STdebKey == 0) return;

  switch (STdebKey) {
#ifdef DEBDMP
  case 1:	/* PF1: print process table */
	p_dmp(); break;
  case 2:	/* PF2: print memory map */
	map_dmp(); break;
  case 3:	/* PF3: print regs user prog */
	reg_dmp(bill_ptr); break; /* ++jrb */
  case 6:	/* PF6: ON/OFF dump tables on panic */
	STdoDump ^= 1; break;
#endif
#ifdef DEBOUT
  case 4:	/* PF4: ON/OFF console debugging */
	STuseCon ^= 1; break;
  case 5:	/* PF5: ON/OFF printer debugging */
	STusePrt ^= 1; break;
#endif
#ifdef DEBDMP
#ifdef TTYDMP
  case 7:	/* PF7: dump tty info */
	tty_dmp(); break;
#endif
#endif
  case 10:	/* PF10: issue SIGKILL */
	for (i = 0; i < NR_CONS; i++)
	{
	    sigchar(&tty_struct[i], SIGKILL); break;
	}
  default:
	break; /* don't bomb out */
  }
  STdebKey = 0;
  tty_events -= EVENT_THRESHOLD;
}

/*===========================================================================*
 *				dump					     *
 *===========================================================================*/
PUBLIC void dump()
{
#ifdef DEBDMP
  if (STdoDump == 0)
	return;
  printf("dump\n");
  reg_dmp(proc_ptr); /* ++jrb */
  p_dmp();
  map_dmp();
#endif
}

/*===========================================================================*
 *				putc					     *
 *===========================================================================*/
/* 
 * This procedure is used by the kernel version of printf().
 * The one in the library sends a message to FS, which is not
 * needed for printing within the kernel.
 */
PUBLIC void putc(c)
int c;
{
#ifdef DEBOUT
/*
 * Use any combination of the printer or the console.
 */

  if (STuseCon)
#endif
	out_char(cur_cons, c);	/* show char on current virtual cons */
#ifdef DEBOUT
  if (STusePrt)
	prtc(c);
#endif
}
#endif
