/* Function prototypes. */

struct inode;		/* need type outside of parameter list --kub */

/* cache.c */
_PROTOTYPE( zone_nr alloc_zone, (dev_t dev, zone_nr z)			);
_PROTOTYPE( void flushall, (dev_t dev)					);
_PROTOTYPE( void free_zone, (dev_t dev, zone_nr numb)			);
_PROTOTYPE( struct buf *get_block, (dev_t dev,
			block_nr block, int only_search)		);
_PROTOTYPE( void invalidate, (dev_t device)				);
_PROTOTYPE( void put_block, (struct buf *bp, int block_type)		);
_PROTOTYPE( void rw_block, (struct buf *bp, int rw_flag)		);
_PROTOTYPE( void rw_scattered, (dev_t dev,
			struct buf **bufq, int bufqsize, int rw_flag)	);

/* device.c */
_PROTOTYPE( void dev_close, (struct inode *rip)				);
_PROTOTYPE( int dev_io, (int rw_flag, int nonblock, dev_t dev,
			off_t pos, int bytes, int proc, char *buff)	);
_PROTOTYPE( int do_ioctl, (void)					);
_PROTOTYPE( int dev_open, (struct inode *rip, int mod, int nonblock)	);
_PROTOTYPE( void no_call, (int task_nr, message *m_ptr)			);
_PROTOTYPE( void rw_dev, (int task_nr, message *mess_ptr)		);
_PROTOTYPE( void rw_dev2, (int dummy, message *mess_ptr)		);
_PROTOTYPE( int tty_exit, (void)					);
_PROTOTYPE( void tty_open, (int task_nr, message *mess_ptr)		);

/* filedes.c */
_PROTOTYPE( struct filp *find_filp, (struct inode *rip, int bits)	);
_PROTOTYPE( int get_fd, (int start, mode_t bits, int *k, struct filp **fpt) );
_PROTOTYPE( struct filp *get_filp, (int fild)				);

/* inode.c */
_PROTOTYPE( struct inode *alloc_inode, (dev_t dev, mode_t bits)		);
_PROTOTYPE( void dup_inode, (struct inode *ip)				);
_PROTOTYPE( void free_inode, (dev_t dev, ino_t numb)			);
_PROTOTYPE( struct inode *get_inode, (dev_t dev, ino_t numb)		);
_PROTOTYPE( void put_inode, (struct inode *rip)				);
_PROTOTYPE( void update_times, (struct inode *rip)			);
_PROTOTYPE( void rw_inode, (struct inode *rip, int rw_flag)		);
_PROTOTYPE( void wipe_inode, (struct inode *rip)			);

/* link.c */
_PROTOTYPE( int do_link, (void)						);
_PROTOTYPE( int do_unlink, (void)					);
_PROTOTYPE( int do_rename, (void)					);
_PROTOTYPE( void truncate, (struct inode *rip)				);

/* main.c */
_PROTOTYPE( void main, (void)						);
_PROTOTYPE( void reply, (int whom, int result)				);

/* misc.c */
_PROTOTYPE( int do_dup, (void)						);
_PROTOTYPE( int do_exit, (void)						);
_PROTOTYPE( int do_fcntl, (void)					);
_PROTOTYPE( int do_fork, (void)						);
_PROTOTYPE( int do_revive, (void)					);
_PROTOTYPE( int do_set, (void)						);
_PROTOTYPE( int do_sync, (void)						);

/* mount.c */
_PROTOTYPE( int do_mount, (void)					);
_PROTOTYPE( int do_umount, (void)					);

/* open.c */
_PROTOTYPE( int do_close, (void)					);
_PROTOTYPE( int do_creat, (void)					);
_PROTOTYPE( int do_lseek, (void)					);
_PROTOTYPE( int do_mknod, (void)					);
_PROTOTYPE( int do_mkdir, (void)					);
_PROTOTYPE( int do_open, (void)						);

/* path.c */
_PROTOTYPE( struct inode *advance,
			(struct inode *dirp, char string [NAME_MAX])	);
_PROTOTYPE( int search_dir, (struct inode *ldir_ptr,
			char string [NAME_MAX], ino_t *numb, int flag)	);
_PROTOTYPE( struct inode *eat_path, (char *path)			);
_PROTOTYPE( struct inode *last_dir, (char *path, char string [NAME_MAX]));

/* pipe.c */
_PROTOTYPE( int do_pipe, (void)						);
_PROTOTYPE( int do_unpause, (void)					);
_PROTOTYPE( int pipe_check, (struct inode *rip, int rw_flag,
			int oflags, int bytes, off_t position)		);
_PROTOTYPE( void release, (struct inode *ip, int call_nr, int count)	);
_PROTOTYPE( void revive, (int proc_nr, int bytes)			);
_PROTOTYPE( void suspend, (int task)					);

/* protect.c */
_PROTOTYPE( int do_access, (void)					);
_PROTOTYPE( int do_chmod, (void)					);
_PROTOTYPE( int do_chown, (void)					);
_PROTOTYPE( int do_umask, (void)					);
_PROTOTYPE( int forbidden, (struct inode *rip,
			mode_t access_desired, int real_uid)		);
_PROTOTYPE( int read_only, (struct inode *ip)				);

/* putc.c */
_PROTOTYPE( void putc, (int c)						);

/* read.c */
_PROTOTYPE( int do_read, (void)						);
_PROTOTYPE( struct buf *rahead, (struct inode *rip, block_nr baseblock,
			off_t position, unsigned bytes_ahead)		);
_PROTOTYPE( void read_ahead, (void)					);
_PROTOTYPE( block_nr read_map, (struct inode *rip, off_t position)	);
_PROTOTYPE( int read_write, (int rw_flag)				);
_PROTOTYPE( int rw_user, (int s, int u, vir_bytes vir,
			vir_bytes bytes, char *buff, int direction)	);

/* stadir.c */
_PROTOTYPE( int do_chdir, (void)					);
_PROTOTYPE( int do_chroot, (void)					);
_PROTOTYPE( int do_fstat, (void)					);
_PROTOTYPE( int do_stat, (void)						);

/* super.c */
_PROTOTYPE( bit_nr alloc_bit, (struct buf *map_ptr [], bit_nr map_bits,
			unshort bit_blocks, bit_nr origin)		);
_PROTOTYPE( void free_bit, (struct buf *map_ptr [], bit_nr bit_returned));
_PROTOTYPE( struct super_block *get_super, (dev_t dev)			);
_PROTOTYPE( int load_bit_maps, (dev_t dev)				);
_PROTOTYPE( int mounted, (struct inode *rip)				);
_PROTOTYPE( void rw_super, (struct super_block *sp, int rw_flag)	);
_PROTOTYPE( int scale_factor, (struct inode *ip)			);
_PROTOTYPE( int unload_bit_maps, (dev_t dev)				);

/* time.c */
_PROTOTYPE( int do_stime, (void)					);
_PROTOTYPE( int do_time, (void)						);
_PROTOTYPE( int do_tims, (void)						);
_PROTOTYPE( int do_utime, (void)					);

/* utility.c */
_PROTOTYPE( time_t clock_time, (void)					);
_PROTOTYPE( void copy, (char *dest, char *source, int bytes)		);
_PROTOTYPE( int fetch_name, (char *path, int len, int flag)		);
_PROTOTYPE( int no_sys, (void)						);
_PROTOTYPE( void panic, (char *format, int num)				);

/* write.c */
_PROTOTYPE( void clear_zone, (struct inode *rip, off_t pos, int flag)	);
_PROTOTYPE( int do_write, (void)					);
_PROTOTYPE( struct buf *new_block, (struct inode *rip, off_t position)	);
_PROTOTYPE( void zero_block, (struct buf *bp)				);

/* library */
_PROTOTYPE( void printk, (char *_fmt, ...)				);
_PROTOTYPE( int receive, (int _src, message *_m_ptr)			);
_PROTOTYPE( int send, (int _dest, message *_m_ptr)			);
_PROTOTYPE( int sendrec, (int _src_dest, message *_m_ptr)		);
_PROTOTYPE( void sys_abort, (void)					);
_PROTOTYPE( void sys_copy, (message *mptr)				);
_PROTOTYPE( void sys_kill, (int proc, int sig)				);
_PROTOTYPE( void sys_times, (int proc, time_t ptr[4])			);
