/* type.h - types for db */

typedef unsigned long bigcount_t;
typedef unsigned long flags_t;
typedef int bool_pt;
typedef char bool_t;
typedef int char_pt;
typedef int char16_t;           /* ASCII character possibly with scan code */
typedef unsigned count_t;
typedef unsigned long offset_t;
typedef unsigned opcode_pt;     /* promote to unsigned and not int */
typedef int (*pfi_t)();
typedef void (*pfv_t)();
typedef unsigned long physoff_t;
typedef unsigned peekboff_t;
typedef unsigned peekoff_t;
typedef int peekseg_t;
typedef unsigned port_t;
typedef int reg_pt;
typedef unsigned char reg_t;
typedef unsigned segment_t;
typedef long soffset_t;
typedef unsigned u4_pt;         /* promote to unsigned and not int */
typedef unsigned char u8_t;
typedef unsigned u8_pt;
typedef unsigned u16_t;
typedef unsigned long u32_t;

struct adr
{
	offset_t off;
	segment_t seg;
};

struct regs
{
	offset_t ax;
	offset_t bx;
	offset_t cx;
	offset_t dx;
	offset_t si;
	offset_t di;
	offset_t bp;
	segment_t ds;
	segment_t es;
	offset_t sp;
	segment_t ss;
	offset_t ip;
	segment_t cs;
	flags_t f;
};

/* these functions are defined in assembler */

FORWARD segment_t codeseg();
FORWARD segment_t dataseg();		/* may be obsolete */
FORWARD unsigned get_processor();	/* used by asm routines only */
FORWARD u8_pt inportb();
FORWARD void oportb();
FORWARD u8_pt peek8();
FORWARD u8_pt peekb();
FORWARD u16_t peek16();
FORWARD u16_t peekw();
FORWARD u32_t peek32();
FORWARD void poke8();
FORWARD void pokeb();
FORWARD void poke16();
FORWARD void pokew();			/* may be obsolete */
FORWARD void poke32();
FORWARD void scrclose();
FORWARD char_pt scrin();
FORWARD void scrioctl();
FORWARD void scropen();
FORWARD void scrout();
FORWARD void symswap();
FORWARD void ttyclose();
FORWARD char_pt ttyin();
FORWARD void ttyioctl();
FORWARD void ttyopen();
FORWARD void ttyout();

/* these functions are defined in C (int functions are NOT declared here) */

FORWARD struct nlist *findsname();
FORWARD struct nlist *findsval();
FORWARD u8_pt get8();
FORWARD u16_t get16();
FORWARD u32_t get32();
FORWARD char *getline();
FORWARD void kbdclose();
FORWARD char_pt kbdin();
FORWARD void kbdioctl();
FORWARD void kbdopen();
FORWARD void kbdout();
FORWARD count_t stringtab();

/* these are the ONLY library functions used (apart from low level arith) */

FORWARD char *memcpy();
FORWARD int strlen();

/* these Minix kernel functions are used */

FORWARD void get_con_state();
FORWARD void map_dmp();
FORWARD void p_dmp();
FORWARD void reset_con_state();
