/* keyboard.h */

/*
  Shift state bits.
  Bits (1<<0) to (1<<7) match the BIOS KB_FLAG byte.
  Bits (1<<11) to (1<<15) match the BIOS KB_FLAG_1.
  The BIOS HOLD (bit 10) is not supported.
  New bits for right ALTs and CTRLs.
  NB  RIGHT_ALT / LEFT_ALT  must equal  RIGHT_CTRL / LEFT_CTRL.
      CAPS_SHIFT / CAPS_LOCK  must equal  INS_SHIFT / INS_LOCK
      and also the NUM and SCROLL ratios.
*/

#define RIGHT_ALT    (1<<9)     /* new */
#define RIGHT_CTRL   (1<<8)     /* new */

#define CAPS_SHIFT   (1<<14)
#define CAPS_LOCK    (1<<6)
#define INS_SHIFT    (1<<15)
#define INS_LOCK     (1<<7)
#define LEFT_ALT     (1<<3)
#define LEFT_CTRL    (1<<2)
#define LEFT_SHIFT   (1<<1)
#define NUM_SHIFT    (1<<13)
#define NUM_LOCK     (1<<5)
#define RIGHT_SHIFT  (1<<0)
#define SCROLL_SHIFT (1<<12)
#define SCROLL_LOCK  (1<<4)

/* area numbers, 0 is normal */

#define CKEY          3         /* separate cursor key */
#define FKEY          6         /* function key */
#define NKEY         14         /* numeric keypad */
#define OKEY         15         /* other */
#define RKEY         18         /* key release */

typedef unsigned char area_t;
typedef unsigned scancode_pt;
typedef unsigned shift_pt;
typedef unsigned short shift_t;

struct echar_s
{
  area_t area;
  unsigned char ch;             /* unsigned for special ASCII comparisons */
  shift_pt shift;
  unsigned state;
};

FORWARD scancode_pt scan_keyboard();
