.\" formatted output is in install.doc
.TL
CAP installation procedures
.AB
This document gives a step by step approach to installation of the
Columbia AppleTalk Package for Unix.
.AE
.SH
NOTE ON ETHERTALK
.LP
This file describes how to install CAP in both its "traditional"
configuration (based on Appletalk encapsulated in
UDP/IP packets) and (for SUN workstations or ULTRIX only) a version
of CAP that supports either Native EtherTalk or the UNIX AppleTalk
Bridge (UAB).
.SH
PREREQUISTES
.LP
To use CAP with IPTalk (DDP delivered within UDP), you must have a bridge
that has the ability to gateway IPTalk packets (to/from EtherTalk and/or
LocalTalk). Suitable candidates are the Webster MultiPort GateWay,
Shiva FastPath
(running suitable gateway code) and Cayman GatorBox.
You must also create the file /etc/atalk.local (see atalk.local.5 in
the man directory) which contains the static IPTalk network and node
numbers.

Before you start here, you should have read the "README" and "NOTES"
files.  The README file gives a very basic overview of CAP necessary
to understand the following.

The installation NOTES file tries to point out places where you might
want to redefine things a little, explains configurations, and points
out machine dependencies.
.SH
Review
.LP
or the the "before you do anything else" step.  If you had a previous
distribution of CAP (eg: 5.00), you should consider
whether it is important enough to dump it to tape and put it away for
safe keeping or not.  There are often considerable changes between
distributions.  You should make sure you keep around modifications,
patches, etc. even if you think they should be installed in the new
distribution just in case they are not.  You don't have to do this,
but if you are paranoid about problems occurring, you will (and
probably would without this prompting).
.PP
Versions of IPTalk/UDP gateway code prior to April, 1988 had
"well known" DDP sockets mapped to priviledged UDP ports starting at
768 (so NBP was 770, etc).  In April, 1988, the NIC assigned a range
of UDP ports starting at 200 for the defined DDP services and assigned
the names "at-nbp", "at-rtmp", "at-echo", "at-zis".  (In addition,
ports were allocated where there were holes or unused sockets between
at-rtmp and at-zis).  CAP Release 6 and above dynamically decides which mappings
to use by doing "getservbyname()" calls based upon those names and using
the UDP port number returned.  getservbyname() normally searches
/etc/services.  If the service name does not exist, then the old
mappings (based on 768) are used.

It is clear from this discussion, however, that one must make sure
that any mappings defined in /etc/services do not conflict
with the mappings used by the IPTalk gateway you are using.
.SH
Preparation
.LP
or the "make sure
things are okay first" step.  You should set your umask so people can
read the files when you extract the files.  Some of the steps require
that you have access to directories that are often only accessible by
a systems person.  We'll try to identify them below.  In addition,
some of the servers can only be run from the "root" id.  We'll try to
identify these too.
.SH
[1] Get CAP Files.
.LP
Assuming you have
gotten them somehow, you should now extract the files into
some convient directory like "cap60".

In the following, it is assume you are connected to the top level
directory (e.g. so an ls shows up samples, contrib, etc, lib,
applications, etc.)
.SH
[1.1] Generate system makefiles
.LP
You should run Configure to establish the baseline setup for your
system. With this distribution of CAP, Configure can be used to choose
a set of features that are to be included in the compilation. It also
checks the byte ordering on the host machine. After Configure, run
gen.makes to generate your baseline makefiles.
There are "Makefile"s included, but for the most part they are included
for systems without m4 and shouldn't be used unless absolutely
necessary.
.SH
[2] Install header files.
.LP
The simplest method is to type "make include".
This will create /usr/include/netat and copy the contents of cap60/netat
to /usr/include/netat.  You can also symbolically link
/usr/include/netat to cap60/netat.
.SH
[3] Make sure things will end up where you want them.
.LP
Figure out where you want everything.  The assumptions are: 
.nf
	cap libraries - /usr/local/lib - as a unix archive file
	cap programs - /usr/local/cap - as programs
	cap config files - /usr/local/lib/cap or /etc
.fi
If you want things elsewhere, edit m4.setup and regenerate the
makefiles.

By the way, /etc may be a bad place to put things.  At Columbia,
everything is generally put in /usr/local/lib/cap instead of /etc.
(Warning: if you want cap.printers in /etc, it is not enough to
redefine the "etcdir".  You must also uncomment the definition that
allows an alternate location for cap.printers. This also applies to
the file atalk.local. You have to change the definition in the makefile
in lib/cap).

This is also a good point to think about reconfiguring papif, lwsrv,
etc. to do what you want.  If you don't know yet, then don't worry,
you can recompile after you verify basic functionality.
.SH
[3.1] Testing
.LP
You can test things out without installing in system directories by
uncommenting the definition for "debug" in m4.setup and regenerating
the makefiles (with gen.makes).  This will put:
.nf
	libraries - $cwd/cap60/lib
	programs - $cwd/cap60/bin (you must create this)
	etc stuff - $cwd/cap60/etc
.fi
You need not install the header files if you run with debug.
.LP
.SH
[4] Build Libraries.
.LP
Type: "make libsmade" from the top level cap directory.
This should build the cap library.
If this
step doesn't work, then:
.nf
	(a) you didn't get the distribution correctly
	(b) you didn't install the header files correctly
	(c) you didn't Configure and generate the makefiles correctly
	(d) or worst of all the libraries don't work on your machine
.fi
If the problem is (d), you can refer to "PORTING" for some help.
.SH
[5] Installing libraries and building sample programs.
.LP
After building the libraries, you use "make programs" to install the
libraries into a readily accessible place (usually /usr/local/lib) and
compile the samples, applications and contributed programs.

You can install the various program by typing "make install", but you
might want to test them first.
.SH
[6] Installing administrative programs
.LP
This step is optional and not recommended if you do not plan to run
any CAP servers.  This step installs "atis" (nbp name server, echo server).

Change directory to cap60/etc.  Look at start-cap-servers and figure out if this
is what you want - modify it to be what you want.  If you don't know
what you want it to be, don't worry - you can do it later, but make
sure you don't remove the line with atis in it.  
You should then copy start-cap-servers to /usr/local/lib/cap (or another
desired location).

Type "make install".  This will compile and install atis into /usr/local/cap
(you probably have to do this su'ed).
.SH
[7] At this point, primary installation is done.
.LP
.SH
[8] Verification.
.LP
You should have already tested the gateway software first.
You must have /etc/atalk.local installed (cf. gw software
documentation).
.LP
A.  Change directory to cap60/samples and run 
.I atlook.
If everything is okay, you
should see some appletalk entities.  If you installed the IPTalk gateway code
(aka KIP) correctly before, then you should minimially see the IPGATEWAY entry.
[Should you not see the IPGATEWAY entry, then the assumption is that
the UDP code isn't functional].  For example:
.nf
	$ atlook
	abInit: [ddp:  55.32, 130] starting
	01 - 128.59.35.40:IPGATEWAY@* [Net: 58.01 Node:220 Skt: 72]
	...
	$ 
.fi
Another really simple program to try is
.I "atlooklws"
which will look for
and query LaserWriters.
.LP
If 
.I atlook
doesn't work, then:
.IP
(a) you may not have installed the IPTalk gateway correctly

(b) you may not have installed atalk.local in the place
.I atlook
expects it.  It will complain if the /etc/atalk.local file is not
there or
is incorrectly formatted

(c) if
.I atlook
coredumps, then something is really wrong.  you are
probably on a machine that CAP doesn't work on.
.LP
B.  If you have a LaserWriter and you see it in 
.I atlook,
then another
level of testing is to run the sample program 
.I tlw
(just type "tlw <laserwriter name>"). 
.LP
C.  To test the server functionality, as "root" run 
.I "atis".
To see if
atis is running properly, run "atistest" from the samples directory.
If it signals proper operation with an "okay" message, then you can
confirm things again (odds are everything is okay) by:
.IP
(a) running 
.I atlook

(b) typing "atis dump" (as root) and looking at /usr/tmp/nis.db
.LP
To get rid of the extraneous entry, simply edit /usr/tmp/nis.db and
remove it and then type "atis reload" (as root).  (Alternatively,
simply kill the running atis process).

The most common problem in getting atis to run is failing to setup IPTalk
(or, if used, atalkatab) properly.

.LP
D.  After verification, you will want things to start up
automatically, either get someone to or edit /etc/rc.local to run the
following lines (or an equivalent):
.sp
.nf
	if [ -f /usr/local/lib/cap/start-cap-servers ]; then
	    /usr/local/lib/cap/start-cap-servers & echo -n "CAP " > /dev/console
	fi
.fi
.sp
.LP
E. After final installation, you can do a 'make clean'. This removes all
the compiled binaries and object files thus saving on disc space.
.SH
CAP WITH ETHERTALK
.LP
CAP can also be setup to send EtherTalk packets directly - either with UAB
(UNIX AppleTalk Bridge) or Native EtherTalk. The setup is done from within
Configure (if the Configure script determines that the host is suitable).
The CAP libraries are automatically modified as necessary. Testing
and installation is as above, see the README files in the support/uab or
support/ethertalk directories for more information.
.sp
The choice of IPTalk, Native EtherTalk or UAB depends on your network
setup. If you have a majority of Macintoshes on LocalTalk connected to
an IPTalk gateway then use CAP in the IPTalk mode (default). If your
Macintoshes are mostly connected via EtherNet and you have other EtherTalk
gateways (Ciscos for example) then use CAP with Native EtherTalk. If you
have no other gateways, or need to use a SUN or ULTRIX host to bridge two
AppleTalk networks then use UAB. On a SUN you may also choose to install
kernel modifications to run either the 'enet' driver or use the native NIT
interface.
.SH
CHANGES FROM RUTGERS CAP
.LP
There are some important changes to note if you are already using Native
EtherTalk from the Rutgers distribution. Shared memory is no longer
used, the file /etc/cap.ether.shared is thus not required. The modifications
needed to the file /etc/atalk.local to select a zone and an ethernet interface
are not needed as CAP now uses the file /etc/etalk.local for both Native
EtherTalk and UAB. See the man files atalk.local.5 and etalk.local.5 for more
details. For Native EtherTalk, you may use etalk.local to seed the values for
"interface" and "thisZone" but the preferred method is to supply this
information as arguments to aarpd, as in
.sp
.nf
		aarpd  ie0  myZone
.fi
