/*
 * Copyright (c) 1990, The Regents of the University of California.
 * Edward Moy, Workstation Software Support Group, Workstation Support Services,
 * Information Systems and Technology.
 *
 * Permission is granted to any individual or institution to use, copy,
 * or redistribute this software so long as it is not sold for profit,
 * provided that this notice and the original copyright notices are
 * retained.  The University of California makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#include <netat/appletalk.h>
#include <netat/compat.h>
#ifdef USESTRINGDOTH
#include <string.h>
#else  USESTRINGDOTH
#include <strings.h>
#endif USESTRINGDOTH

#define ATPRESPONSETIMEOUT sectotick(60*2);
#define	MINUTES		* 60
#define	PASSWORD	7734
#define	R_BUFMAX	PAPSegSize*atpMaxNum

struct lws {
	struct lws *next;
	long passwd;
	char name[80];
} *lwhead;

u_long atpresponsetimeout = ATPRESPONSETIMEOUT;
char lwfile[] = LWRENAMEFILE;
char *myname;
char renamestr[] = "\
serverdict begin %ld exitserver\n\
statusdict begin\n\
(%s) (LaserShared) currentdict /appletalktype known\n\
{/appletalktype}{/product}ifelse exch def setprintername\n\
end\n\
";
int s_time = 2 * 60;

main(argc,argv)
int argc;
char **argv;
{
  register char *cp;
  register FILE *fp;
  register struct lws *lp, *ln;
  int cno, ocomp, wcomp;
  char buf[BUFSIZ];
  PAPStatusRec status;
  char *malloc();
  long atol();

  if(myname = rindex(*argv, '/'))
    myname++;
  else
    myname = *argv;
  for(argc--, argv++ ; argc > 0 && **argv == '-' ; argc--, argv++) {
    switch((*argv)[1]) {
     case 't':
      if((*argv)[2])
	s_time = atoi(&(*argv)[2]);
      else if(argc < 2)
	Usage();	/* never returns */
      else {
	argc--;
	s_time = atoi(*++argv);
      }
      if(s_time <= 0)
	Usage();
      s_time *= 60;
      break;
     default:
      Usage();	/* never returns */
    }
  }
  if(argc > 0)
    Usage();	/* never returns */
  if((fp = fopen(lwfile, "r")) == NULL) {
    fprintf(stderr, "%s: can't open %s\n", myname, lwfile);
    exit(1);
  }
  ln = NULL;
  while(fgets(buf, BUFSIZ, fp)) {
    if(cp = index(buf, '\n'))
      *cp = 0;
    if((cp = index(buf, '\t')) == NULL) {
      fprintf(stderr, "%s: Syntax error in %s\n", myname, lwfile);
      exit(1);
    }
    *cp++ = 0;
    if((lp = (struct lws *)malloc(sizeof(struct lws))) == NULL) {
      fprintf(stderr, "%s: Out of memory\n", myname);
      exit(1);
    }
    lp->passwd = atol(buf);
    strcpy(lp->name, cp);
    if(ln)
      ln->next = lp;
    else
      lwhead = lp;
    ln = lp;
  }
  if(lwhead == NULL) {
    fprintf(stderr, "%s: No entries in %s\n", myname, lwfile);
    exit(1);
  }
  ln->next = NULL;
  fclose(fp);
  disassociate();
  /* init cap */
  abInit(FALSE);		/* don't printout -- messes up with <stdin> */
  nbpInit();
  PAPInit();			/* init PAP printer routines */
  ATPSetResponseTimeout(atpresponsetimeout); /* set to 2 minutes */

  for( ; ; ) {
    lp = lwhead;
    do {
      if(PAPOpen(&cno, lp->name, atpMaxNum, &status, &ocomp) == noErr) {
	do {
	  abSleep(16, TRUE);
	} while(ocomp > 0);
	cp = index(lp->name, ':');
	*cp = 0;
	sprintf(buf, renamestr, lp->passwd, lp->name);
	*cp = ':';
        writeit(cno, buf);
	PAPClose(cno);
      }
    } while(lp = lp->next);
    sleep(s_time);
  }
}

disassociate()
{
  int i;

  if (fork())
    _exit(0);			/* kill parent */
  for (i=0; i < 3; i++) close(i); /* kill */
  (void)open("/",0);
  (void)dup2(0,1);
  (void)dup2(0,2);
#ifndef POSIX
#ifdef TIOCNOTTY
  if ((i = open("/dev/tty",2)) > 0) {
    (void)ioctl(i, TIOCNOTTY, (caddr_t)0);
    (void)close(i);
  }
#endif TIOCNOTTY
#else  POSIX
  (void) setsid();
#endif POSIX
}

writeit(cno, str)
int cno;
char *str;
{
  int eof, wcomp, paperr, err, doeof = FALSE;

  wcomp = 0;
  if ((paperr=PAPWrite(cno, str, strlen(str), FALSE, &wcomp)) < 0) {
    return;
  }
  /* post initial read from LW */
  err = 1;
  /* this is the main read/write loop */
  inithandleread();		/* initialze handleread */
  do {
    if ((eof = handleread(cno)))
      break;
    if (wcomp <= 0) {
      if (wcomp != noErr) {
	return;
      } else {
	err = 0;
	doeof = TRUE;
	if (err || doeof) {
	  if ((paperr=PAPWrite(cno, NULL, 0, doeof, &wcomp)) < 0)
	    break;
	} else err = 1;
      }
    }
    abSleep(4, TRUE);		/* wait a bit */
  } while (err > 0 );

  if (paperr != noErr) {
    wcomp = 0;
  }
  while (!eof || wcomp > 0) {		/* wait for completion */
    abSleep(4,TRUE);
    if (!eof)
      eof = handleread(cno);
  }
}

private int hr_rcomp = noErr;
private int hr_rlen = 0;
private char hr_rbuf[R_BUFMAX+10];
private int hr_eof = 0;

inithandleread()
{
  hr_rcomp = noErr;
  hr_rlen = 0;
  hr_eof = 0;
}

/*
 * handle the papread
 *  return: -1 paperr
 *           0 ok
 *           1 eof
*/
handleread(cno)
{
  int paperr;

  if (hr_rcomp > 0)
    return(0);
  switch (hr_rcomp) {
  case noErr:
    break;
  default:
    return(-1);
  }
  hr_rbuf[hr_rlen] = '\0';
  if (hr_eof) {
    return(1);
  }
  paperr = PAPRead(cno, hr_rbuf, &hr_rlen, &hr_eof, &hr_rcomp);
  switch (paperr) {
  case noErr:
    break;
  default:
    return(-1);
  }
  return(0);
}

Usage()
{
  fprintf(stderr, "Usage: %s [-t minutes]\n", myname);
  exit(1);
}
