/* Declarations for `malloc' and friends.
   Copyright 1990, 1991, 1992 Free Software Foundation, Inc.
		  Written May 1989 by Mike Haertel.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.

   The author may be reached (Email) at the address mike@ai.mit.edu,
   or (US mail) as Mike Haertel c/o Free Software Foundation.  */

#ifndef _CHECKER_H
#define _CHECKER_H	1

/* configuration file */
#include <features.h>
#include "config.h"
#include "machine.h"
#include "chkrlib.h"

#ifdef CHKR_GARBAGE
/* size of red zones */
extern unsigned int be_red_zone;	/* bytes, but must long */
extern unsigned int af_red_zone;

/* magic number in magic (Yes, I'm french :-) */
#define RED_ZONE_MAGIC 0xcafe0cfc
#endif /* CHKR_GARBAGE */

#ifdef CHKR_SAVESTACK
/* Defined in sysdep.c */
void chkr_save_stack(__ptr_t *ptr, int forget, int num);
void chkr_initialize();
extern char *chkr_prog_path;
/* Defined in find_exec.c */
char *chkr_find_executable(char *file);
/* Defined in symtab.c */
void chkr_use_symtab(void (*func)(int status));
void chkr_unload_symtab(void);
void chkr_load_symtab(void);
extern int symtab_available;
void chkr_show_addr(__ptr_t *ptr);
void chkr_remove_symtabfile();
void chkr_show_frames(void);
extern __ptr_t *chkr_frames_ip;
extern __ptr_t *chkr_frames_pointer;
extern int chkr_frames_to_forget;
#endif /* CHKR_SAVESTACK */

#ifdef CHKR_USE_BITMAP
#define CHKR_UN	0	/* Can't neither read nor write */
#define CHKR_RO	1	/* Read only */
#define CHKR_WO	2	/* Write only */
#define CHKR_RW 3	/* Read and write */
#define CHKR_TW 6	/* test for write, but no evloution */
extern int is_text_writable;
#ifdef CHKR_HEAPBITMAP
extern __ptr_t chkr_heap_begin;
extern unsigned char *chkr_heap_bitmap;
#endif /* CHKR_HEAPBITMAP */
#ifdef CHKR_DATABITMAP
extern unsigned char *chkr_data_bitmap;
#endif /* CHKR_DATABITMAP */
#ifdef CHKR_STACKBITMAP
extern unsigned char *chkr_stack_bitmap;
#endif /* CHKR_STACKBITMAP */
extern int bm_round;		/* number of bytes per byte of bitmap -1 */
extern int bm_log_size;
extern unsigned int null_pointer_zone;
void chkr_set_right(__ptr_t ptr, int len, int right);
void chkr_check_addr(__ptr_t ptr, int len, int right);
void chkr_check_str(__ptr_t ptr, int right);
#endif /* CHKR_USE_BITMAP */

#ifdef CHKR_PROFILE
void display_profile(void);
#endif

#if CHECKER
/* Fonction called in case of error */
void chkr_abort();
void chkr_garbage_detector();
void chkr_evol_detector();
extern int chkr_errno;	/* error number */
extern int chkr_show_err_flag;	/* flag: print error when detect */
extern const char * const chkr_errlist[];
void chkr_perror();
void chkr_do_end();
char *copy_of_exec_file(register char *s);
#endif /* CHECKER */

/* malloc functions, to be used internally */
void *sys_malloc(size_t real_size);
void sys_free(void * ptr);
void *sys_realloc (void * ptr, size_t size);

#endif /* checker.h  */
