/*
 * iflink	This file contains an implementation of the command
 *		that links a kernel-resident DDI device driver to a
 *		network interface (called a `stream').  It is similar
 *		to the UNIX SystemV `slink' command.
 *
 * Usage:	iflink [-v] [-f family] filename stream
 *
 * Version:	@(#)iflink.c	1.02	05/25/93
 *
 * Author: 	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <linux/ddi.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>


char *Version = "@(#) iflink 1.02 (05/25/93)";


int opt_v = 0;				/* debugging output flag	*/


static void usage(void)
{
  fprintf(stderr, "Usage: iflink [-v] [-f family] filename stream\n");
  exit(-1);
}


void main(argc, argv)
int argc;
char *argv[];
{
  char path[PATH_MAX];
  char if_name[DDI_MAXNAME + 1];
  struct iflink r;
  register int c;
  int proto, dev;
  char *af_name, *dev_name, *stream;
  extern int getopt(), optind, opterr;
  extern char *optarg;

  /* Initialize variables... */
  af_name = "inet";
  proto = -1;
  dev = -1;

  /* Fetch the command-line arguments. */
  opterr = 0;
  while ((c = getopt(argc, argv, "vf:")) != EOF) switch(c) {
	case 'f':
		af_name = optarg;
		break;
	case 'v':
		opt_v = 1;
		break;
	default:
		usage();
  }

  /* Two more arguments needed! */
  if (optind != (argc - 2)) usage();
  dev_name = argv[optind++];
  stream = argv[optind];

  /* Create PROTOCOL pathname and open file. */
  sprintf(path, "/dev/%s", af_name);
  if ((proto = open(path, O_RDWR)) < 0) {
	perror(af_name);
	exit(-1);
  }

  /* Open the device file. */
  if ((dev = open(dev_name, O_RDWR)) < 0) {
	perror(dev_name);
	(void) close(proto);
	exit(-1);
  }

  /* Ask the device for its DDI ID string. */
  if (ioctl(dev, SIOCGIFNAME, if_name) < 0) {
	perror("SIOCGIFNAME");
	(void) close(dev);
	(void) close(proto);
	exit(-1);
  }

  /* Fill in the STREAM LINK request. */
  strncpy(r.id, if_name, DDI_MAXNAME);
  strncpy(r.stream, stream, DDI_MAXNAME);
  r.family = 0;				/* dunno - not used yet		*/
  r.flags = 0;				/* also not used yet		*/

  /* Tell the correct protocol layer to link in this stream. */
  if (ioctl(proto, SIOCSIFLINK, &r) < 0) {
	perror("SIOCSIFLINK");
	(void) close(dev);
	(void) close(proto);
	exit(-1);
  }

  /* All done.  Close up and exit. */
  (void) close(proto);
  (void) close(dev);
  exit(0);
}
