#include "listserv.h"

static char rcsid[] = "$Header: /usr/local/src/mail/listserv/RCS/subscribe.c,v 1.4 92/09/14 11:04:20 andy Exp Locker: andy $";

extern FILE *msg;
extern FILE *mailer;

subscription(from,command,add,outsider)
char *from,*command;
int add,outsider;
	{
	FILE *list;
	FILE *listtmp;
	char grp[256];
	char adr[256];
	char tmp[256];
	char buf[BUFSIZ];
	int del = 0;
	int i, l;
	int aliasok;

	printf("subscription %s %s %d\n", from, command, add);

	i = sscanf(command,"%s%s%s", tmp, adr, grp);
	if (i < 2 || i > 3)
		sendhelp(from, command);
	if (i == 2)
		{
		strcpy(grp, adr);
		strcpy(adr, from);
		}
	
	cleanup(grp,&i);
	cleanup(adr,&outsider);

	if (strcasecmp(grp, adr) == 0)
		{
		callmailer("", from, "");
		fprintf(mailer,"Subscription address loop: %s\n", adr);
		fflush(mailer);
		pclose(mailer);
		return(-1);
		}

	if (outsider)
		sprintf(tmp,"%s/%s.pub", SERVDIR, grp);
	else
		sprintf(tmp,"%s/%s.info", SERVDIR, grp);
	if (access(tmp,R_OK) != 0)
		{
		callmailer("", from, "");
		fprintf(mailer,"The mailing list \"%s\" could not be found.\n",
			grp);
		fprintf(mailer,"You may use the INDEX command to get a listing\n");
		fprintf(mailer,"of available mailing lists.\n");
		fflush(mailer);
		pclose(mailer);
		return(-1);
		}

	strcpy(tmp, SERVDIR);
	strcat(tmp, "/");
	strcat(tmp, grp);
	if (add)
		{
		l = open(tmp, AFLAGS, AMODE);
		if (l == -1)
			{
			callmailer(LISTSERVMANAGER, from, "");
			fprintf(mailer,"Error[1] processing request. Please try later.\n");
			fprintf(mailer,">%s\n", command);
			fflush(mailer);
			pclose(mailer);
			return(-1);
			}
		else
			{
			list = fdopen(l, "a");
			if (list == NULL)
				{
				callmailer(LISTSERVMANAGER, from, "");
				fprintf(mailer,"Error[1] processing request. Please try later.\n");
				fprintf(mailer,">%s\n", command);
				fflush(mailer);
				pclose(mailer);
				return(-1);
				}
			}
		flock(l, LOCK_EX);
		fprintf(list, "%s\n", adr);
		fflush(list);
		flock(l, LOCK_UN);
		close(l);
		}
	else
		{
		del = 0;
		list = fopen(tmp, "r");
		if (list == NULL)
			{
			callmailer(LISTSERVMANAGER, from, "");
			fprintf(mailer,"Error[2] processing request. Please try later.\n");
			fprintf(mailer,">%s\n", command);
			fflush(mailer);
			pclose(mailer);
			return(-1);
			}
		flock(fileno(list), LOCK_EX);
		
		strcpy(tmp, SERVDIR);
		strcat(tmp, "/");
		strcat(tmp, grp);
		strcat(tmp, ".tmp");
		listtmp = fopen(tmp, "w");
		if (listtmp == NULL)
			{
			callmailer(LISTSERVMANAGER, from, "");
			fprintf(mailer,"Error[3] processing request. Please try later.\n");
			fprintf(mailer,">%s\n", command);
			fflush(mailer);
			pclose(mailer);
			return(-1);
			}
		/* copy the list, omitting the one address */
		while (fgets(buf, sizeof(buf), list))
			{
			buf[strlen(buf)-1] = '\0';
			if (strcasecmp(buf, adr))
				{
				fputs(buf, listtmp);
				fputs("\n", listtmp);
				}
			else
				del++;
			}
		fflush(listtmp);
		fclose(listtmp);

		/* replace the old list with the shortened one */
		strcpy(buf, SERVDIR);
		strcat(buf, "/");
		strcat(buf, grp);
		unlink(buf);	/* delete original file */
		rename(tmp, buf);	/* put updated one in place */
		flock(fileno(list), LOCK_UN);	/* release lock */
		}
#ifndef DEBUG
	if (strcmp(from, adr))
		{
		callmailer(adr, from, command);
		fprintf(mailer,"Per request by %s\n", from);
		}
	else
		{
		callmailer("", from, command);
		fprintf(mailer,"Per your request\n");
		}
#else
		callmailer("", from, command);
		fprintf(mailer,"Per your request\n");
#endif

		fprintf(mailer,"\t\"%s\"\n", command);
	/* Mail subscription confirmation and info/intro files.*/
	if (add)
		{
		fprintf(mailer,"'%s' was ADDED to the '%s' mailing list.\n",
			adr, grp);
		fflush(mailer);
		pclose(mailer);

		sprintf(tmp, "%s/%s.intro", SERVDIR,grp);
		if (access(tmp,R_OK) == 0)
			{
#ifndef DEBUG
		callmailer("", adr, command);
#else		
		callmailer("", from, command);
#endif
		mailcat(tmp, "");
		sprintf(tmp, "%s/%s.faq", SERVDIR, grp);
		if(access(tmp,R_OK) == 0)
			mailcat(tmp,"\n\n");
		fflush(mailer);
		pclose(mailer);
			}
		}
	
	else
		if (del)
			{
			fprintf(mailer,
			"'%s' was DELETED from the '%s' mailing list.\n",
				adr, grp);
			fprintf(mailer, 
			"\nAlthough you have been deleted from the list,");
			fprintf(mailer, 
			" some mail sent previous to your deletion may be\n");
			fprintf(mailer,
			"queued in the system. Please don't panic if you");
			fprintf(mailer, 
			" receive a few last pieces of mail.\n");
			fflush(mailer);
			pclose(mailer);
			}
		else
			{
			fprintf(mailer,
			"'%s' was NOT FOUND on the '%s' mailing list.\n",
				adr, grp);
			fflush(mailer);
			pclose(mailer);
			}
	
	}
