/**********************************************************************/
/*   Utility to print out a tree structure prettily.		      */
/**********************************************************************/
# include	<stdio.h>
# include	"sptree.h"

# define	MAX_DEPTH 256
typedef char STRING[400];
STRING pe[MAX_DEPTH];
int	max_level = 0;

void	print_tree();

void
ptree(tree)
SPTREE	*tree;
{	int	i;

	if (tree->root == NULL) {
		printf("NULL TREE\n");
		return;
		}
	max_level = 0;
	for (i = 0; i < MAX_DEPTH; i++)
		pe[i][0] = NULL;
	print_tree(0, tree->root);
	printf("Tree:\n");

	for (i = 0; i <= max_level; i++) {
		int spc = (max_level - i) / 2;
		printf("%2d: ", i);
		while (spc-- > 0)
			printf("    ");
		printf("%s\n", pe[i]);
		}
	printf("Statistics: %s\n", spstats(tree));

}
void
print_tree(level, x)
int	level;
SPBLK	*x;
{	char	*str;
	if (level > MAX_DEPTH) {
		printf("Maximum nesting level exceeded in print_tree\n");
		abort();
		}
	if (level > max_level) {
		max_level = level;
		}
	str = pe[level];
	str += strlen(str);
	sprintf(str, " %s(%s:%s,%s)", x->key,
		x->uplink ? x->uplink->key : "-",
	    x->leftlink ? x->leftlink->key : "-",
		x->rightlink ? x->rightlink->key : "-");
	if (x->leftlink)
		print_tree(level+1, x->leftlink);
	if (x->rightlink)
		print_tree(level+1,x->rightlink);
}
