/*
 * @(#)time.c	1.5 91/09/05
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ptrace.h>
#include <sys/time.h>

#include "defs.h"

void
printtv(pid, addr)
{
	struct timeval tv;

	if (addr == 0 || umove(pid, addr, sizeof tv, (char *)&tv) < 0) {
		fprintf(outf, "(struct timeval *)0");
	} else {
		fprintf(outf, "{%u,%u}", tv.tv_sec, tv.tv_usec);
	}
}

int
sys_gettimeofday(tcp)
struct tcb *tcp;
{
	struct timeval tv;
	struct timezone tz;

	if (exiting(tcp)) {
		if (syserror(tcp)) {
			fprintf(outf, "%#x, %#x",
					tcp->u_args[0], tcp->u_args[1]);
			return 0;
		}
		printtv(tcp->pid, tcp->u_args[0]);
		if (tcp->u_args[1] == 0 || umove(tcp->pid, tcp->u_args[1],
						sizeof tz, (char *)&tz) < 0) {
			fprintf(outf, ", (struct timezone *)0");
		} else {
			fprintf(outf, ", {%d west,%d dst}",
				tz.tz_minuteswest, tz.tz_dsttime);
		}
	}
	return 0;
}

int
sys_settimeofday(tcp)
struct tcb *tcp;
{
	struct timeval tv;
	struct timezone tz;

	if (entering(tcp)) {
		printtv(tcp->pid, tcp->u_args[0]);
		if (tcp->u_args[1] == 0 || umove(tcp->pid, tcp->u_args[1],
						sizeof tz, (char *)&tz) < 0) {
			fprintf(outf, ", (struct timezone *)0");
		} else {
			fprintf(outf, ", {%d west,%d dst}",
				tz.tz_minuteswest, tz.tz_dsttime);
		}
	}
	return 0;
}

int
sys_adjtime(tcp)
struct tcb *tcp;
{
	struct timeval tv;

	if (entering(tcp)) {
		printtv(tcp->pid, tcp->u_args[0]);
		fprintf(outf, ", ");
	} else {
		if (syserror(tcp))
			fprintf(outf, "%#x", tcp->u_args[1]);
		else
			printtv(tcp->pid, tcp->u_args[1]);
	}
}

static Xlat which[] = {
	ITIMER_REAL,	"ITIMER_REAL",
	ITIMER_VIRTUAL,	"ITIMER_VIRTUAL",
	ITIMER_PROF,	"ITIMER_PROF",
	0,		NULL,
};

static void
printitv(pid, addr)
{
	struct itimerval itv;

	if (addr == 0 || umove(pid, addr, sizeof itv, (char *)&itv) < 0) {
		fprintf(outf, "(struct itimerval *)0");
	} else {
		fprintf(outf, "{{%u,%u},{%u,%u}}",
		itv.it_interval.tv_sec, itv.it_interval.tv_usec,
		itv.it_value.tv_sec, itv.it_value.tv_usec);
	}
}

int
sys_getitimer(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printxval(which, tcp->u_args[0], "ITMER_???");
		fprintf(outf, ", ");
	} else {
		if (syserror(tcp))
			fprintf(outf, "%#x", tcp->u_args[1]);
		else
			printitv(tcp->pid, tcp->u_args[1]);
	}
	return 0;
}

int
sys_setitimer(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printxval(which, tcp->u_args[0], "ITMER_???");
		fprintf(outf, ", ");
		printitv(tcp->pid, tcp->u_args[1]);
		fprintf(outf, ", ");
	} else {
		if (syserror(tcp))
			fprintf(outf, "%#x", tcp->u_args[2]);
		else
			printitv(tcp->pid, tcp->u_args[2]);
	}
	return 0;
}
