/*
 * @(#)syscall.c	1.5 91/09/05
 */

#include <stdio.h>
#include <strings.h>
#include <signal.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/user.h>
#include <sys/time.h>

#include "defs.h"

#ifndef __linux
extern char *sys_errlist[];
extern int sys_nerr;
#endif

#ifdef linux
#define	PTRACE_PEEKUSER	PTRACE_PEEKUSR
#endif

#include "syscall.h"
struct sysent {
	int	nargs;
	int	(*sys_func)();
	char	*sys_name;
} sysent[] = {
#include "syscallent.h"
};
int nsyscall = sizeof sysent / sizeof sysent[0];

int
syscall(tcp)
struct tcb *tcp;
{
	int	i, sys_res;
	int	pid = tcp->pid;
	struct	user *u;
	struct timeval tv;
#ifdef linux
	int	eax;
#endif

	if (dtime && tcp->flags & TCB_INSYSCALL)
		gettimeofday(&tv, NULL);
#if 0
	errno = 0;
	if ((scno = ptrace(PTRACE_PEEKUSER, pid, uoff(u_arg[7]), 0)) == -1) {
		if (errno) {
			perror("trace: ptrace(PTRACE_PEEKUSER)");
			return -1;
		}
	}
#endif
#ifdef linux
	errno = 0;
	eax = ptrace(PTRACE_PEEKUSER, pid, 4*EAX, 0);
	if (errno) {
		perror("ptrace(PTRACE_PEEKUSER,..,eax)");
		return -1;
	}
#if old_linux
	/*
	 * linux ptrace can't handle more than one pending signal, this means
	 * we easily get out of sync.
	 */
	if (eax == -ENOSYS)
		tcp->flags &= ~TCB_INSYSCALL;
	else
		tcp->flags |= TCB_INSYSCALL;
#else
	if (eax != -ENOSYS && !(tcp->flags & TCB_INSYSCALL)) {
		if (debug)
			fprintf(stderr, "stray syscall exit: eax = %d\n", eax);
		return 0;
	}
#endif
#endif
	if (tcp->flags & TCB_INSYSCALL) {
		u_int u_error;

#ifndef linux
		/* get error code from user struct */
		errno = 0;
		u_error = ptrace(PTRACE_PEEKUSER, pid, uoff(u_error), 0);
		if (errno) {
			perror("ptrace(PTRACE_PEEKUSER,..,u_error)");
			return -1;
		}
		u_error >>= 24; /* u_error is a char */
		tcp->u_error = u_error;

		/* get system call return value */
		errno = 0;
		tcp->u_rval = ptrace(PTRACE_PEEKUSER, pid,
					uoff(u_rval1), 0);
		if (errno) {
			perror("ptrace(PTRACE_PEEKUSER,..,u_rval1)");
			return -1;
		}
#else
		if (eax && (unsigned) -eax < 520) {
			tcp->u_rval = -1;
			u_error = tcp->u_error = -eax;
		} else {
			tcp->u_rval = eax;
			u_error = tcp->u_error = 0;
		}
#endif

		sys_res = (*sysent[tcp->scno].sys_func)(tcp);
		fprintf(outf, ")");
		if (u_error) {
#ifdef linux
			switch (u_error) {
			case ERESTARTSYS:
				fprintf(outf, " (RESTARTSYS)");
				sys_res = RVAL_NONE;
				break;
			case ERESTARTNOINTR:
				fprintf(outf, " (RESTARTNOINTR)");
				sys_res = RVAL_NONE;
				break;
			case ERESTARTNOHAND:
				fprintf(outf, " (RESTARTNOHAND)");
				sys_res = RVAL_NONE;
				break;
			default:
				fprintf(outf, " = -1 (%s)",
				(u_error<sys_nerr)?sys_errlist[u_error]:"???");
			}
#else
			fprintf(outf, " = -1 (%s)",
			(u_error<sys_nerr)?sys_errlist[u_error]:"???");
#endif
		} else {
			if (!(sys_res & RVAL_NONE)) {
				if (sys_res & RVAL_HEX)
					fprintf(outf, " = %#x", tcp->u_rval);
				else
					fprintf(outf, " = %d", tcp->u_rval);
			}
			if (sys_res & RVAL_STR)
				fprintf(outf, " (%s)", tcp->auxstr);
		}
		if (dtime) {
			tv.tv_sec -= tcp->tv.tv_sec;
			if ((tv.tv_usec -= tcp->tv.tv_usec) < 0) {
				--tv.tv_sec;
				tv.tv_usec += 1000000;
			}
			fprintf(outf, " <%d.%06d>", tv.tv_sec, tv.tv_usec);
		}
		putc('\n', outf);
		fflush(outf);
		tcp->flags &= ~TCB_INSYSCALL;
		return 0;
	}
	errno = 0;
#ifndef linux
	if ((tcp->scno = ptrace(PTRACE_PEEKUSER, pid, uoff(u_arg[7]), 0)) == -1) {
#else
	if ((tcp->scno = ptrace(PTRACE_PEEKUSER, pid, 4*ORIG_EAX, 0)) == -1) {
#endif
		if (errno) {
			perror("trace: ptrace(PTRACE_PEEKUSER)");
			return -1;
		}
	}
	if (Nproc > 1)
		fprintf(outf, " [pid %u]: ", pid);
	if (tflag) {
		char str[sizeof("HH:MM:SS")];

		gettimeofday(&tv, NULL);
		strftime(str, sizeof(str), "%T", localtime(&tv.tv_sec));
		if (tflag > 1)
			fprintf(outf, "%s.%.06d ", str, tv.tv_usec);
		else
			fprintf(outf, "%s ", str);
	}
	if (cflag) {
		(void)printcall(tcp->pid);
	}
#ifdef linux
	if ((unsigned) tcp->scno >= nsyscall) {
		fprintf(stderr, "scno out of range: %d\n", tcp->scno);
		tcp->scno = 0;
	}
	if ((tcp->scno != 102 /* __NR_socketcall */) && 
		(tcp->scno != 117 /* __NR_ipc */) )
#endif
	fprintf(outf, "%s(", sysent[tcp->scno].sys_name);
	for (i=0; i<sysent[tcp->scno].nargs; i++) {
		errno = 0;
		tcp->u_args[i] = ptrace(PTRACE_PEEKUSER, pid,
#ifdef linux
			i*4, 0);
#else
			uoff(u_arg[0]) + (i*sizeof(u->u_arg[0])), 0);
#endif
		if (errno) {
			perror("ptrace(PTRACE_PEEKUSER)");
			return -1;
		}
	}
	sys_res = (*sysent[tcp->scno].sys_func)(tcp);
	fflush(outf);
	tcp->flags |= TCB_INSYSCALL;
	return sys_res;
}

int
printargs(tcp)
struct tcb *tcp;
{
	int i, nargs = sysent[tcp->scno].nargs;

	if (tcp->flags & TCB_INSYSCALL)
		return 0;

	for (i = 0; i < nargs; i++)
		fprintf(outf, i>0?", %#x":"%#x", tcp->u_args[i]);
	return 0;
}

#ifndef linux
int
getrval2(pid)
{
	int val;

	errno = 0;
	val = ptrace(PTRACE_PEEKUSER, pid, uoff(u_rval2), 0);
	if (errno) {
		perror(" [ptrace(PTRACE_PEEKUSER,..,u_rval2)]");
		return -1;
	}
	return val;
}
#endif

/*
 * Apparently, indirect system calls have already be converted by ptrace(2),
 * so if you see "indir" this program has gone astray.
 */
int
sys_indir(tcp)
struct tcb *tcp;
{
	u_int i, scno, nargs;

	if (entering(tcp)) {
		if ((scno = tcp->u_args[0]) > nsyscall) {
			fprintf(stderr, "Bogus syscall: %u\n", scno);
			return 0;
		}
		nargs = sysent[scno].nargs;
		fprintf(outf, "%s", sysent[scno].sys_name);
		for (i = 0; i < nargs; i++)
			fprintf(outf, ", %#x", tcp->u_args[i+1]);
	}
	return 0;
}
