/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionParser;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class ExpressionTool {
    public static Expression make(String string, StaticContext staticContext, int n, int n2) throws XPathException {
        try {
            ExpressionParser expressionParser = new ExpressionParser();
            if (n2 == -1) {
                n2 = 0;
            }
            Expression expression = expressionParser.parse(string, n, n2, staticContext);
            expression = expression.simplify();
            return expression;
        }
        catch (XPathException.Dynamic dynamic) {
            return new ErrorExpression(dynamic);
        }
    }

    public static void copyLocationInfo(Expression expression, Expression expression2) {
        if (expression instanceof ComputedExpression && expression2 instanceof ComputedExpression) {
            ((ComputedExpression)expression2).setLineNumber(((ComputedExpression)expression).getLineNumber());
        }
    }

    public static SourceLocator getLocator(Expression expression) {
        if (expression instanceof ComputedExpression) {
            ExpressionLocation expressionLocation = new ExpressionLocation();
            expressionLocation.setLineNumber(((ComputedExpression)expression).getLineNumber());
            return expressionLocation;
        }
        return null;
    }

    public static Expression unsorted(Expression expression, boolean bl) throws XPathException {
        PromotionOffer promotionOffer = new PromotionOffer();
        promotionOffer.action = 13;
        promotionOffer.mustEliminateDuplicates = bl;
        return expression.promote(promotionOffer);
    }

    public static Value lazyEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        if (expression instanceof VariableReference) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if (xPathContext == null) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        if ((expression.getDependencies() & 0x2D) != 0) {
            return ExpressionTool.eagerEvaluate(expression, xPathContext);
        }
        return Closure.make(expression, xPathContext);
    }

    public static Value eagerEvaluate(Expression expression, XPathContext xPathContext) throws XPathException {
        if (expression instanceof Value && !(expression instanceof Closure)) {
            return (Value)expression;
        }
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return EmptySequence.getInstance();
        }
        if (sequenceIterator instanceof SingletonIterator) {
            Item item = ((SingletonIterator)sequenceIterator).getValue();
            return Value.asValue(item);
        }
        SequenceExtent sequenceExtent = new SequenceExtent(sequenceIterator);
        int n = sequenceExtent.getLength();
        if (n == 0) {
            return EmptySequence.getInstance();
        }
        if (n == 1) {
            return Value.asValue(sequenceExtent.itemAt(0));
        }
        return sequenceExtent;
    }

    public static boolean markTailFunctionCalls(Expression expression) {
        if (expression instanceof ComputedExpression) {
            return ((ComputedExpression)expression).markTailFunctionCalls();
        }
        return false;
    }

    public static String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        return string;
    }

    public static int allocateSlots(Expression expression, int n) {
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n++);
        }
        Expression[] expressionArray = expression.getSubExpressions();
        int n2 = 0;
        while (n2 < expressionArray.length) {
            n = ExpressionTool.allocateSlots(expressionArray[n2], n);
            ++n2;
        }
        return n;
    }
}

