# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AzureResourceBase(_serialization.Model):
    """Common properties for all Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: String Id used to locate any resource on Azure.
    :vartype id: str
    :ivar name: Name of this resource.
    :vartype name: str
    :ivar type: Type of this resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class DenySettings(_serialization.Model):
    """Defines how resources deployed by the deployment stack are locked.

    All required parameters must be populated in order to send to server.

    :ivar mode: denySettings Mode. Required. Known values are: "denyDelete", "denyWriteAndDelete",
     and "none".
    :vartype mode: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenySettingsMode
    :ivar excluded_principals: List of AAD principal IDs excluded from the lock. Up to 5 principals
     are permitted.
    :vartype excluded_principals: list[str]
    :ivar excluded_actions: List of role-based management operations that are excluded from the
     denySettings. Up to 200 actions are permitted. If the denySetting mode is set to
     'denyWriteAndDelete', then the following actions are automatically appended to
     'excludedActions': '*\\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting
     mode is set to 'denyDelete', then the following actions are automatically appended to
     'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
    :vartype excluded_actions: list[str]
    :ivar apply_to_child_scopes: DenySettings will be applied to child scopes.
    :vartype apply_to_child_scopes: bool
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "mode": {"key": "mode", "type": "str"},
        "excluded_principals": {"key": "excludedPrincipals", "type": "[str]"},
        "excluded_actions": {"key": "excludedActions", "type": "[str]"},
        "apply_to_child_scopes": {"key": "applyToChildScopes", "type": "bool"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.DenySettingsMode"],
        excluded_principals: Optional[List[str]] = None,
        excluded_actions: Optional[List[str]] = None,
        apply_to_child_scopes: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mode: denySettings Mode. Required. Known values are: "denyDelete",
         "denyWriteAndDelete", and "none".
        :paramtype mode: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenySettingsMode
        :keyword excluded_principals: List of AAD principal IDs excluded from the lock. Up to 5
         principals are permitted.
        :paramtype excluded_principals: list[str]
        :keyword excluded_actions: List of role-based management operations that are excluded from the
         denySettings. Up to 200 actions are permitted. If the denySetting mode is set to
         'denyWriteAndDelete', then the following actions are automatically appended to
         'excludedActions': '*\\/read' and 'Microsoft.Authorization/locks/delete'. If the denySetting
         mode is set to 'denyDelete', then the following actions are automatically appended to
         'excludedActions': 'Microsoft.Authorization/locks/delete'. Duplicate actions will be removed.
        :paramtype excluded_actions: list[str]
        :keyword apply_to_child_scopes: DenySettings will be applied to child scopes.
        :paramtype apply_to_child_scopes: bool
        """
        super().__init__(**kwargs)
        self.mode = mode
        self.excluded_principals = excluded_principals
        self.excluded_actions = excluded_actions
        self.apply_to_child_scopes = apply_to_child_scopes


class DeploymentStack(AzureResourceBase):
    """Deployment stack object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: String Id used to locate any resource on Azure.
    :vartype id: str
    :ivar name: Name of this resource.
    :vartype name: str
    :ivar type: Type of this resource.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.SystemData
    :ivar location: The location of the deployment stack. It cannot be changed after creation. It
     must be one of the supported Azure locations.
    :vartype location: str
    :ivar tags: Deployment stack resource tags.
    :vartype tags: dict[str, str]
    :ivar error: Common error response for all Azure Resource Manager APIs to return error details
     for failed operations. (This also follows the OData error response format.).
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksTemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     Use this element when providing the parameter values directly in the request, rather than
     linking to an existing parameter file. Use either the parametersLink property or the parameters
     property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar parameters_link: The URI of parameters file. Use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksParametersLink
    :ivar action_on_unmanage: Defines the behavior of resources that are not managed immediately
     after the stack is updated.
    :vartype action_on_unmanage:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStackPropertiesActionOnUnmanage
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDebugSetting
    :ivar deployment_scope: The scope at which the initial deployment should be created. If a scope
     is not specified, it will default to the scope of the deployment stack. Valid scopes are:
     management group (format:
     '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     '/subscriptions/{subscriptionId}'), resource group (format:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
    :vartype deployment_scope: str
    :ivar description: Deployment stack description.
    :vartype description: str
    :ivar deny_settings: Defines how resources deployed by the stack are locked.
    :vartype deny_settings:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenySettings
    :ivar provisioning_state: State of the deployment stack. Known values are: "Creating",
     "Validating", "Waiting", "Deploying", "Canceling", "Locking", "DeletingResources", "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStackProvisioningState
    :ivar detached_resources: An array of resources that were detached during the most recent
     update.
    :vartype detached_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceReference]
    :ivar deleted_resources: An array of resources that were deleted during the most recent update.
    :vartype deleted_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceReference]
    :ivar failed_resources: An array of resources that failed to reach goal state during the most
     recent update.
    :vartype failed_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceReferenceExtended]
    :ivar resources: An array of resources currently managed by the deployment stack.
    :vartype resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ManagedResourceReference]
    :ivar deployment_id: The resourceId of the deployment resource created by the deployment stack.
    :vartype deployment_id: str
    :ivar outputs: The outputs of the underlying deployment.
    :vartype outputs: JSON
    :ivar duration: The duration of the deployment stack update.
    :vartype duration: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "description": {"max_length": 4096},
        "provisioning_state": {"readonly": True},
        "detached_resources": {"readonly": True},
        "deleted_resources": {"readonly": True},
        "failed_resources": {"readonly": True},
        "resources": {"readonly": True},
        "deployment_id": {"readonly": True},
        "outputs": {"readonly": True},
        "duration": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "error": {"key": "properties.error", "type": "ErrorResponse"},
        "template": {"key": "properties.template", "type": "object"},
        "template_link": {"key": "properties.templateLink", "type": "DeploymentStacksTemplateLink"},
        "parameters": {"key": "properties.parameters", "type": "object"},
        "parameters_link": {"key": "properties.parametersLink", "type": "DeploymentStacksParametersLink"},
        "action_on_unmanage": {
            "key": "properties.actionOnUnmanage",
            "type": "DeploymentStackPropertiesActionOnUnmanage",
        },
        "debug_setting": {"key": "properties.debugSetting", "type": "DeploymentStacksDebugSetting"},
        "deployment_scope": {"key": "properties.deploymentScope", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "deny_settings": {"key": "properties.denySettings", "type": "DenySettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "detached_resources": {"key": "properties.detachedResources", "type": "[ResourceReference]"},
        "deleted_resources": {"key": "properties.deletedResources", "type": "[ResourceReference]"},
        "failed_resources": {"key": "properties.failedResources", "type": "[ResourceReferenceExtended]"},
        "resources": {"key": "properties.resources", "type": "[ManagedResourceReference]"},
        "deployment_id": {"key": "properties.deploymentId", "type": "str"},
        "outputs": {"key": "properties.outputs", "type": "object"},
        "duration": {"key": "properties.duration", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        error: Optional["_models.ErrorResponse"] = None,
        template: Optional[JSON] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        parameters: Optional[JSON] = None,
        parameters_link: Optional["_models.DeploymentStacksParametersLink"] = None,
        action_on_unmanage: Optional["_models.DeploymentStackPropertiesActionOnUnmanage"] = None,
        debug_setting: Optional["_models.DeploymentStacksDebugSetting"] = None,
        deployment_scope: Optional[str] = None,
        description: Optional[str] = None,
        deny_settings: Optional["_models.DenySettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the deployment stack. It cannot be changed after creation.
         It must be one of the supported Azure locations.
        :paramtype location: str
        :keyword tags: Deployment stack resource tags.
        :paramtype tags: dict[str, str]
        :keyword error: Common error response for all Azure Resource Manager APIs to return error
         details for failed operations. (This also follows the OData error response format.).
        :paramtype error:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksTemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. Use this element when providing the parameter values directly in the request, rather
         than linking to an existing parameter file. Use either the parametersLink property or the
         parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        :keyword parameters_link: The URI of parameters file. Use this element to link to an existing
         parameters file. Use either the parametersLink property or the parameters property, but not
         both.
        :paramtype parameters_link:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksParametersLink
        :keyword action_on_unmanage: Defines the behavior of resources that are not managed immediately
         after the stack is updated.
        :paramtype action_on_unmanage:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStackPropertiesActionOnUnmanage
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDebugSetting
        :keyword deployment_scope: The scope at which the initial deployment should be created. If a
         scope is not specified, it will default to the scope of the deployment stack. Valid scopes are:
         management group (format:
         '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
         '/subscriptions/{subscriptionId}'), resource group (format:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
        :paramtype deployment_scope: str
        :keyword description: Deployment stack description.
        :paramtype description: str
        :keyword deny_settings: Defines how resources deployed by the stack are locked.
        :paramtype deny_settings:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenySettings
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.error = error
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.action_on_unmanage = action_on_unmanage
        self.debug_setting = debug_setting
        self.deployment_scope = deployment_scope
        self.description = description
        self.deny_settings = deny_settings
        self.provisioning_state: Optional[Union[str, "_models.DeploymentStackProvisioningState"]] = None
        self.detached_resources: Optional[List["_models.ResourceReference"]] = None
        self.deleted_resources: Optional[List["_models.ResourceReference"]] = None
        self.failed_resources: Optional[List["_models.ResourceReferenceExtended"]] = None
        self.resources: Optional[List["_models.ManagedResourceReference"]] = None
        self.deployment_id: Optional[str] = None
        self.outputs: Optional[JSON] = None
        self.duration: Optional[str] = None


class DeploymentStackListResult(_serialization.Model):
    """List of deployment stacks.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployment stacks.
    :vartype value:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStack]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentStack]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeploymentStack"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of deployment stacks.
        :paramtype value:
         list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStack]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DeploymentStacksError(_serialization.Model):
    """Deployment Stacks error response.

    :ivar error: Common error response for all Azure Resource Manager APIs to return error details
     for failed operations. (This also follows the OData error response format.).
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Common error response for all Azure Resource Manager APIs to return error
         details for failed operations. (This also follows the OData error response format.).
        :paramtype error:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
        """
        super().__init__(**kwargs)
        self.error = error


class DeploymentStackProperties(DeploymentStacksError):
    """Deployment stack properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar error: Common error response for all Azure Resource Manager APIs to return error details
     for failed operations. (This also follows the OData error response format.).
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksTemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     Use this element when providing the parameter values directly in the request, rather than
     linking to an existing parameter file. Use either the parametersLink property or the parameters
     property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar parameters_link: The URI of parameters file. Use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksParametersLink
    :ivar action_on_unmanage: Defines the behavior of resources that are not managed immediately
     after the stack is updated. Required.
    :vartype action_on_unmanage:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStackPropertiesActionOnUnmanage
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDebugSetting
    :ivar deployment_scope: The scope at which the initial deployment should be created. If a scope
     is not specified, it will default to the scope of the deployment stack. Valid scopes are:
     management group (format:
     '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
     '/subscriptions/{subscriptionId}'), resource group (format:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
    :vartype deployment_scope: str
    :ivar description: Deployment stack description.
    :vartype description: str
    :ivar deny_settings: Defines how resources deployed by the stack are locked. Required.
    :vartype deny_settings:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenySettings
    :ivar provisioning_state: State of the deployment stack. Known values are: "Creating",
     "Validating", "Waiting", "Deploying", "Canceling", "Locking", "DeletingResources", "Succeeded",
     "Failed", "Canceled", and "Deleting".
    :vartype provisioning_state: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStackProvisioningState
    :ivar detached_resources: An array of resources that were detached during the most recent
     update.
    :vartype detached_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceReference]
    :ivar deleted_resources: An array of resources that were deleted during the most recent update.
    :vartype deleted_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceReference]
    :ivar failed_resources: An array of resources that failed to reach goal state during the most
     recent update.
    :vartype failed_resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceReferenceExtended]
    :ivar resources: An array of resources currently managed by the deployment stack.
    :vartype resources:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ManagedResourceReference]
    :ivar deployment_id: The resourceId of the deployment resource created by the deployment stack.
    :vartype deployment_id: str
    :ivar outputs: The outputs of the underlying deployment.
    :vartype outputs: JSON
    :ivar duration: The duration of the deployment stack update.
    :vartype duration: str
    """

    _validation = {
        "action_on_unmanage": {"required": True},
        "description": {"max_length": 4096},
        "deny_settings": {"required": True},
        "provisioning_state": {"readonly": True},
        "detached_resources": {"readonly": True},
        "deleted_resources": {"readonly": True},
        "failed_resources": {"readonly": True},
        "resources": {"readonly": True},
        "deployment_id": {"readonly": True},
        "outputs": {"readonly": True},
        "duration": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "DeploymentStacksTemplateLink"},
        "parameters": {"key": "parameters", "type": "object"},
        "parameters_link": {"key": "parametersLink", "type": "DeploymentStacksParametersLink"},
        "action_on_unmanage": {"key": "actionOnUnmanage", "type": "DeploymentStackPropertiesActionOnUnmanage"},
        "debug_setting": {"key": "debugSetting", "type": "DeploymentStacksDebugSetting"},
        "deployment_scope": {"key": "deploymentScope", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "deny_settings": {"key": "denySettings", "type": "DenySettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "detached_resources": {"key": "detachedResources", "type": "[ResourceReference]"},
        "deleted_resources": {"key": "deletedResources", "type": "[ResourceReference]"},
        "failed_resources": {"key": "failedResources", "type": "[ResourceReferenceExtended]"},
        "resources": {"key": "resources", "type": "[ManagedResourceReference]"},
        "deployment_id": {"key": "deploymentId", "type": "str"},
        "outputs": {"key": "outputs", "type": "object"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_on_unmanage: "_models.DeploymentStackPropertiesActionOnUnmanage",
        deny_settings: "_models.DenySettings",
        error: Optional["_models.ErrorResponse"] = None,
        template: Optional[JSON] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        parameters: Optional[JSON] = None,
        parameters_link: Optional["_models.DeploymentStacksParametersLink"] = None,
        debug_setting: Optional["_models.DeploymentStacksDebugSetting"] = None,
        deployment_scope: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: Common error response for all Azure Resource Manager APIs to return error
         details for failed operations. (This also follows the OData error response format.).
        :paramtype error:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksTemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. Use this element when providing the parameter values directly in the request, rather
         than linking to an existing parameter file. Use either the parametersLink property or the
         parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        :keyword parameters_link: The URI of parameters file. Use this element to link to an existing
         parameters file. Use either the parametersLink property or the parameters property, but not
         both.
        :paramtype parameters_link:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksParametersLink
        :keyword action_on_unmanage: Defines the behavior of resources that are not managed immediately
         after the stack is updated. Required.
        :paramtype action_on_unmanage:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStackPropertiesActionOnUnmanage
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDebugSetting
        :keyword deployment_scope: The scope at which the initial deployment should be created. If a
         scope is not specified, it will default to the scope of the deployment stack. Valid scopes are:
         management group (format:
         '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format:
         '/subscriptions/{subscriptionId}'), resource group (format:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
        :paramtype deployment_scope: str
        :keyword description: Deployment stack description.
        :paramtype description: str
        :keyword deny_settings: Defines how resources deployed by the stack are locked. Required.
        :paramtype deny_settings:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenySettings
        """
        super().__init__(error=error, **kwargs)
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.action_on_unmanage = action_on_unmanage
        self.debug_setting = debug_setting
        self.deployment_scope = deployment_scope
        self.description = description
        self.deny_settings = deny_settings
        self.provisioning_state: Optional[Union[str, "_models.DeploymentStackProvisioningState"]] = None
        self.detached_resources: Optional[List["_models.ResourceReference"]] = None
        self.deleted_resources: Optional[List["_models.ResourceReference"]] = None
        self.failed_resources: Optional[List["_models.ResourceReferenceExtended"]] = None
        self.resources: Optional[List["_models.ManagedResourceReference"]] = None
        self.deployment_id: Optional[str] = None
        self.outputs: Optional[JSON] = None
        self.duration: Optional[str] = None


class DeploymentStackPropertiesActionOnUnmanage(_serialization.Model):  # pylint: disable=name-too-long
    """Defines the behavior of resources that are not managed immediately after the stack is updated.

    All required parameters must be populated in order to send to server.

    :ivar resources: Specifies the action that should be taken on the resource when the deployment
     stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the
     resource in it's current state. Required. Known values are: "delete" and "detach".
    :vartype resources: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDeleteDetachEnum
    :ivar resource_groups: Specifies the action that should be taken on the resource when the
     deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will
     leave the resource in it's current state. Known values are: "delete" and "detach".
    :vartype resource_groups: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDeleteDetachEnum
    :ivar management_groups: Specifies the action that should be taken on the resource when the
     deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will
     leave the resource in it's current state. Known values are: "delete" and "detach".
    :vartype management_groups: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDeleteDetachEnum
    """

    _validation = {
        "resources": {"required": True},
    }

    _attribute_map = {
        "resources": {"key": "resources", "type": "str"},
        "resource_groups": {"key": "resourceGroups", "type": "str"},
        "management_groups": {"key": "managementGroups", "type": "str"},
    }

    def __init__(
        self,
        *,
        resources: Union[str, "_models.DeploymentStacksDeleteDetachEnum"],
        resource_groups: Optional[Union[str, "_models.DeploymentStacksDeleteDetachEnum"]] = None,
        management_groups: Optional[Union[str, "_models.DeploymentStacksDeleteDetachEnum"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resources: Specifies the action that should be taken on the resource when the
         deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will
         leave the resource in it's current state. Required. Known values are: "delete" and "detach".
        :paramtype resources: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDeleteDetachEnum
        :keyword resource_groups: Specifies the action that should be taken on the resource when the
         deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will
         leave the resource in it's current state. Known values are: "delete" and "detach".
        :paramtype resource_groups: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDeleteDetachEnum
        :keyword management_groups: Specifies the action that should be taken on the resource when the
         deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will
         leave the resource in it's current state. Known values are: "delete" and "detach".
        :paramtype management_groups: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksDeleteDetachEnum
        """
        super().__init__(**kwargs)
        self.resources = resources
        self.resource_groups = resource_groups
        self.management_groups = management_groups


class DeploymentStacksDebugSetting(_serialization.Model):
    """The debug setting.

    :ivar detail_level: Specifies the type of information to log for debugging. The permitted
     values are none, requestContent, responseContent, or both requestContent and responseContent
     separated by a comma. The default is none. When setting this value, carefully consider the type
     of information that is being passed in during deployment. By logging information about the
     request or response, sensitive data that is retrieved through the deployment operations could
     potentially be exposed.
    :vartype detail_level: str
    """

    _attribute_map = {
        "detail_level": {"key": "detailLevel", "type": "str"},
    }

    def __init__(self, *, detail_level: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword detail_level: Specifies the type of information to log for debugging. The permitted
         values are none, requestContent, responseContent, or both requestContent and responseContent
         separated by a comma. The default is none. When setting this value, carefully consider the type
         of information that is being passed in during deployment. By logging information about the
         request or response, sensitive data that is retrieved through the deployment operations could
         potentially be exposed.
        :paramtype detail_level: str
        """
        super().__init__(**kwargs)
        self.detail_level = detail_level


class DeploymentStacksParametersLink(_serialization.Model):
    """Entity representing the reference to the deployment parameters.

    All required parameters must be populated in order to send to server.

    :ivar uri: The URI of the parameters file. Required.
    :vartype uri: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(self, *, uri: str, content_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The URI of the parameters file. Required.
        :paramtype uri: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class DeploymentStacksTemplateLink(_serialization.Model):
    """Entity representing the reference to the template.

    :ivar uri: The URI of the template to deploy. Use either the uri or id property, but not both.
    :vartype uri: str
    :ivar id: The resource id of a Template Spec. Use either the id or uri property, but not both.
    :vartype id: str
    :ivar relative_path: The relativePath property can be used to deploy a linked template at a
     location relative to the parent. If the parent template was linked with a TemplateSpec, this
     will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
     deployment will be a combination of the parent and relativePath URIs.
    :vartype relative_path: str
    :ivar query_string: The query string (for example, a SAS token) to be used with the
     templateLink URI.
    :vartype query_string: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "query_string": {"key": "queryString", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        relative_path: Optional[str] = None,
        query_string: Optional[str] = None,
        content_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword uri: The URI of the template to deploy. Use either the uri or id property, but not
         both.
        :paramtype uri: str
        :keyword id: The resource id of a Template Spec. Use either the id or uri property, but not
         both.
        :paramtype id: str
        :keyword relative_path: The relativePath property can be used to deploy a linked template at a
         location relative to the parent. If the parent template was linked with a TemplateSpec, this
         will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child
         deployment will be a combination of the parent and relativePath URIs.
        :paramtype relative_path: str
        :keyword query_string: The query string (for example, a SAS token) to be used with the
         templateLink URI.
        :paramtype query_string: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.id = id
        self.relative_path = relative_path
        self.query_string = query_string
        self.content_version = content_version


class DeploymentStackTemplateDefinition(_serialization.Model):
    """Export Template specific properties of the Stack.

    :ivar template: The template content. Use this element to pass the template syntax directly in
     the request rather than link to an existing template. It can be a JObject or well-formed JSON
     string. Use either the templateLink property or the template property, but not both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link:
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksTemplateLink
    """

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "DeploymentStacksTemplateLink"},
    }

    def __init__(
        self,
        *,
        template: Optional[JSON] = None,
        template_link: Optional["_models.DeploymentStacksTemplateLink"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template: The template content. Use this element to pass the template syntax directly
         in the request rather than link to an existing template. It can be a JObject or well-formed
         JSON string. Use either the templateLink property or the template property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DeploymentStacksTemplateLink
        """
        super().__init__(**kwargs)
        self.template = template
        self.template_link = template_link


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ResourceReference(_serialization.Model):
    """The resource Id model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resourceId of a resource managed by the deployment stack.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class ManagedResourceReference(ResourceReference):
    """The managed resource model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resourceId of a resource managed by the deployment stack.
    :vartype id: str
    :ivar status: Current management state of the resource in the deployment stack. Known values
     are: "Managed", "removeDenyFailed", "deleteFailed", and "None".
    :vartype status: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceStatusMode
    :ivar deny_status: denyAssignment settings applied to the resource. Known values are:
     "denyDelete", "notSupported", "inapplicable", "denyWriteAndDelete", "removedBySystem", and
     "None".
    :vartype deny_status: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenyStatusMode
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "deny_status": {"key": "denyStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.ResourceStatusMode"] = "None",
        deny_status: Union[str, "_models.DenyStatusMode"] = "None",
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Current management state of the resource in the deployment stack. Known values
         are: "Managed", "removeDenyFailed", "deleteFailed", and "None".
        :paramtype status: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ResourceStatusMode
        :keyword deny_status: denyAssignment settings applied to the resource. Known values are:
         "denyDelete", "notSupported", "inapplicable", "denyWriteAndDelete", "removedBySystem", and
         "None".
        :paramtype deny_status: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.DenyStatusMode
        """
        super().__init__(**kwargs)
        self.status = status
        self.deny_status = deny_status


class ResourceReferenceExtended(ResourceReference, DeploymentStacksError):
    """The resource Id extended model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Common error response for all Azure Resource Manager APIs to return error details
     for failed operations. (This also follows the OData error response format.).
    :vartype error: ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
    :ivar id: The resourceId of a resource managed by the deployment stack.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponse"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponse"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Common error response for all Azure Resource Manager APIs to return error
         details for failed operations. (This also follows the OData error response format.).
        :paramtype error:
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.ErrorResponse
        """
        super().__init__(error=error, **kwargs)
        self.error = error
        self.id: Optional[str] = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.resource.deploymentstacks.v2022_08_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
