# Installation
> `npm install --save @types/esm`

# Summary
This package contains type definitions for esm (https://github.com/standard-things/esm#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/esm.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/esm/index.d.ts)
````ts
/// <reference types="node"/>

declare namespace Options {
    interface Esm {
        cache: boolean;
        esModule: boolean;
        extensions: boolean;
        mutableNamespace: boolean;
        namedExports: boolean;
        paths: boolean;
        vars: boolean;
        dedefault: boolean;
        topLevelReturn: boolean;
    }

    interface Options {
        cjs: boolean | Partial<Esm>;
        mainFields: string[];
        mode: "auto" | "all" | "strict";
        await: boolean;
        force: boolean;
        wasm: boolean;
    }
}

declare function esm(mod: typeof module, options?: Partial<Options.Options>): typeof require;
export = esm;

````

### Additional Details
 * Last updated: Mon, 06 Nov 2023 22:41:05 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node)

# Credits
These definitions were written by [Richie Bendall](https://github.com/Richienb).
