/* SPDX-License-Identifier: GPL-2.0+ */
/* Copyright (C) 2018 Microchip Technology Inc. */

#ifndef _LAN743X_ETHTOOL_H
#define _LAN743X_ETHTOOL_H

#include "linux/ethtool.h"

#define LAN743X_ETH_REG_VERSION         1

enum {
	ETH_PRIV_FLAGS,
	ETH_ID_REV,
	ETH_FPGA_REV,
	ETH_STRAP_READ,
	ETH_INT_STS,
	ETH_HW_CFG,
	ETH_PMT_CTL,
	ETH_E2P_CMD,
	ETH_E2P_DATA,
	ETH_MAC_CR,
	ETH_MAC_RX,
	ETH_MAC_TX,
	ETH_FLOW,
	ETH_MII_ACC,
	ETH_MII_DATA,
	ETH_EEE_TX_LPI_REQ_DLY,
	ETH_WUCSR,
	ETH_WK_SRC,

	/* Add new registers above */
	MAX_LAN743X_ETH_COMMON_REGS
};

enum {
	/* SGMII Register */
	ETH_SR_VSMMD_DEV_ID1,
	ETH_SR_VSMMD_DEV_ID2,
	ETH_SR_VSMMD_PCS_ID1,
	ETH_SR_VSMMD_PCS_ID2,
	ETH_SR_VSMMD_STS,
	ETH_SR_VSMMD_CTRL,
	ETH_SR_MII_CTRL,
	ETH_SR_MII_STS,
	ETH_SR_MII_DEV_ID1,
	ETH_SR_MII_DEV_ID2,
	ETH_SR_MII_AN_ADV,
	ETH_SR_MII_LP_BABL,
	ETH_SR_MII_EXPN,
	ETH_SR_MII_EXT_STS,
	ETH_SR_MII_TIME_SYNC_ABL,
	ETH_SR_MII_TIME_SYNC_TX_MAX_DLY_LWR,
	ETH_SR_MII_TIME_SYNC_TX_MAX_DLY_UPR,
	ETH_SR_MII_TIME_SYNC_TX_MIN_DLY_LWR,
	ETH_SR_MII_TIME_SYNC_TX_MIN_DLY_UPR,
	ETH_SR_MII_TIME_SYNC_RX_MAX_DLY_LWR,
	ETH_SR_MII_TIME_SYNC_RX_MAX_DLY_UPR,
	ETH_SR_MII_TIME_SYNC_RX_MIN_DLY_LWR,
	ETH_SR_MII_TIME_SYNC_RX_MIN_DLY_UPR,
	ETH_VR_MII_DIG_CTRL1,
	ETH_VR_MII_AN_CTRL,
	ETH_VR_MII_AN_INTR_STS,
	ETH_VR_MII_TC,
	ETH_VR_MII_DBG_CTRL,
	ETH_VR_MII_EEE_MCTRL0,
	ETH_VR_MII_EEE_TXTIMER,
	ETH_VR_MII_EEE_RXTIMER,
	ETH_VR_MII_LINK_TIMER_CTRL,
	ETH_VR_MII_EEE_MCTRL1,
	ETH_VR_MII_DIG_STS,
	ETH_VR_MII_ICG_ERRCNT1,
	ETH_VR_MII_GPIO,
	ETH_VR_MII_EEE_LPI_STATUS,
	ETH_VR_MII_EEE_WKERR,
	ETH_VR_MII_MISC_STS,
	ETH_VR_MII_RX_LSTS,
	ETH_VR_MII_GEN2_GEN4_TX_BSTCTRL0,
	ETH_VR_MII_GEN2_GEN4_TX_LVLCTRL0,
	ETH_VR_MII_GEN2_GEN4_TXGENCTRL0,
	ETH_VR_MII_GEN2_GEN4_TXGENCTRL1,
	ETH_VR_MII_GEN4_TXGENCTRL2,
	ETH_VR_MII_GEN2_GEN4_TX_STS,
	ETH_VR_MII_GEN2_GEN4_RXGENCTRL0,
	ETH_VR_MII_GEN2_GEN4_RXGENCTRL1,
	ETH_VR_MII_GEN4_RXEQ_CTRL,
	ETH_VR_MII_GEN4_RXLOS_CTRL0,
	ETH_VR_MII_GEN2_GEN4_MPLL_CTRL0,
	ETH_VR_MII_GEN2_GEN4_MPLL_CTRL1,
	ETH_VR_MII_GEN2_GEN4_MPLL_STS,
	ETH_VR_MII_GEN2_GEN4_LVL_CTRL,
	ETH_VR_MII_GEN4_MISC_CTRL2,
	ETH_VR_MII_GEN2_GEN4_MISC_CTRL0,
	ETH_VR_MII_GEN2_GEN4_MISC_CTRL1,
	ETH_VR_MII_SNPS_CR_CTRL,
	ETH_VR_MII_SNPS_CR_ADDR,
	ETH_VR_MII_SNPS_CR_DATA,
	ETH_VR_MII_DIG_CTRL2,
	ETH_VR_MII_DIG_ERRCNT,

	/* Add new registers above */
	MAX_LAN743X_ETH_SGMII_REGS
};

extern const struct ethtool_ops lan743x_ethtool_ops;

#endif /* _LAN743X_ETHTOOL_H */
